// java wrapper for vtkImplicitPlaneRepresentation object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkImplicitPlaneRepresentation.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkBoundedWidgetRepresentation_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkImplicitPlaneRepresentation_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkImplicitPlaneRepresentation",dType)) { return me; }
  if ((res= vtkBoundedWidgetRepresentation_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_SetOrigin_14(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrigin(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_SetOrigin_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrigin(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetOrigin_16(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrigin();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetOrigin_17(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetOrigin(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_SetNormal_18(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNormal(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_SetNormal_19(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNormal(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_SetNormalToCamera_110(JNIEnv* env, jobject obj)
{

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNormalToCamera();

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetNormal_111(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNormal();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetNormal_112(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetNormal(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_SetNormalToXAxis_113(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNormalToXAxis(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetNormalToXAxis_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNormalToXAxis();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_NormalToXAxisOn_115(JNIEnv* env, jobject obj)
{

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->NormalToXAxisOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_NormalToXAxisOff_116(JNIEnv* env, jobject obj)
{

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->NormalToXAxisOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_SetNormalToYAxis_117(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNormalToYAxis(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetNormalToYAxis_118(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNormalToYAxis();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_NormalToYAxisOn_119(JNIEnv* env, jobject obj)
{

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->NormalToYAxisOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_NormalToYAxisOff_120(JNIEnv* env, jobject obj)
{

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->NormalToYAxisOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_SetNormalToZAxis_121(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNormalToZAxis(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetNormalToZAxis_122(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNormalToZAxis();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_NormalToZAxisOn_123(JNIEnv* env, jobject obj)
{

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->NormalToZAxisOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_NormalToZAxisOff_124(JNIEnv* env, jobject obj)
{

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->NormalToZAxisOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_SetLockNormalToCamera_125(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLockNormalToCamera(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetLockNormalToCamera_126(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLockNormalToCamera();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_LockNormalToCameraOn_127(JNIEnv* env, jobject obj)
{

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->LockNormalToCameraOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_LockNormalToCameraOff_128(JNIEnv* env, jobject obj)
{

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->LockNormalToCameraOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_SetTubing_129(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTubing(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetTubing_130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTubing();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_TubingOn_131(JNIEnv* env, jobject obj)
{

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->TubingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_TubingOff_132(JNIEnv* env, jobject obj)
{

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->TubingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_SetDrawPlane_133(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawPlane(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetDrawPlane_134(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDrawPlane();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_DrawPlaneOn_135(JNIEnv* env, jobject obj)
{

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawPlaneOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_DrawPlaneOff_136(JNIEnv* env, jobject obj)
{

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawPlaneOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_SetDrawOutline_137(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawOutline(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetDrawOutline_138(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDrawOutline();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_DrawOutlineOn_139(JNIEnv* env, jobject obj)
{

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawOutlineOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_DrawOutlineOff_140(JNIEnv* env, jobject obj)
{

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawOutlineOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_SetScaleEnabled_141(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScaleEnabled(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetScaleEnabled_142(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScaleEnabled();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_ScaleEnabledOn_143(JNIEnv* env, jobject obj)
{

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ScaleEnabledOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_ScaleEnabledOff_144(JNIEnv* env, jobject obj)
{

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ScaleEnabledOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetPolyData_145(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPolyData * temp0;
  temp0 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPolyData(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetPolyDataAlgorithm_146(JNIEnv* env, jobject obj)
{
  vtkPolyDataAlgorithm * temp20;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolyDataAlgorithm();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetPlane_147(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPlane * temp0;
  temp0 = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPlane(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_SetPlane_148(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPlane * temp0;
  temp0 = static_cast<vtkPlane*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPlane(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_UpdatePlacement_149(JNIEnv* env, jobject obj)
{

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdatePlacement();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetNormalProperty_150(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNormalProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetSelectedNormalProperty_151(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectedNormalProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetPlaneProperty_152(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPlaneProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetSelectedPlaneProperty_153(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectedPlaneProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetEdgesProperty_154(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgesProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_SetInteractionColor_155(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInteractionColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_SetInteractionColor_156(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInteractionColor(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_SetHandleColor_157(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHandleColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_SetHandleColor_158(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHandleColor(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_SetForegroundColor_159(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetForegroundColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_SetForegroundColor_160(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetForegroundColor(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_SetEdgeColor_161(JNIEnv* env, jobject obj,jobject id0)
{
  vtkLookupTable * temp0;
  temp0 = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeColor(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_SetEdgeColor_162(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_SetEdgeColor_163(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeColor(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_SetBumpDistance_164(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBumpDistance(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetBumpDistanceMinValue_165(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBumpDistanceMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetBumpDistanceMaxValue_166(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBumpDistanceMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetBumpDistance_167(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBumpDistance();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_BumpPlane_168(JNIEnv* env, jobject obj,jint id0,jdouble id1)
{
  int   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->BumpPlane(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_PushPlane_169(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->PushPlane(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_ComputeInteractionState_170(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeInteractionState(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_PlaceWidget_171(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->PlaceWidget(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_BuildRepresentation_172(JNIEnv* env, jobject obj)
{

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildRepresentation();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_StartWidgetInteraction_173(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartWidgetInteraction(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_WidgetInteraction_174(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->WidgetInteraction(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_EndWidgetInteraction_175(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->EndWidgetInteraction(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetBounds_176(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetActors_177(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPropCollection * temp0;
  temp0 = static_cast<vtkPropCollection*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetActors(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_ReleaseGraphicsResources_178(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_RenderOpaqueGeometry_179(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOpaqueGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_RenderTranslucentPolygonalGeometry_180(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderTranslucentPolygonalGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_HasTranslucentPolygonalGeometry_181(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasTranslucentPolygonalGeometry();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_SetInteractionState_182(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInteractionState(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetInteractionStateMinValue_183(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInteractionStateMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetInteractionStateMaxValue_184(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInteractionStateMaxValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_SetRepresentationState_185(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRepresentationState(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetRepresentationState_186(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRepresentationState();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetUnderlyingPlane_187(JNIEnv* env, jobject obj)
{
  vtkPlane * temp20;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUnderlyingPlane();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_SetCropPlaneToBoundingBox_188(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCropPlaneToBoundingBox(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetCropPlaneToBoundingBox_189(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCropPlaneToBoundingBox();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_CropPlaneToBoundingBoxOn_190(JNIEnv* env, jobject obj)
{

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->CropPlaneToBoundingBoxOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_CropPlaneToBoundingBoxOff_191(JNIEnv* env, jobject obj)
{

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->CropPlaneToBoundingBoxOff();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetSnapToAxes_192(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSnapToAxes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_SetSnapToAxes_193(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSnapToAxes(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_GetAlwaysSnapToNearestAxis_194(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAlwaysSnapToNearestAxis();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitPlaneRepresentation_SetAlwaysSnapToNearestAxis_195(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkImplicitPlaneRepresentation* op = static_cast<vtkImplicitPlaneRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAlwaysSnapToNearestAxis(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkImplicitPlaneRepresentation_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkImplicitPlaneRepresentation::New());
}
