// java wrapper for vtkKdTreeSelector object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkKdTreeSelector.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkSelectionAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkKdTreeSelector_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkKdTreeSelector",dType)) { return me; }
  if ((res= vtkSelectionAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdTreeSelector_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkKdTreeSelector* op = static_cast<vtkKdTreeSelector*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdTreeSelector_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkKdTreeSelector* op = static_cast<vtkKdTreeSelector*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkKdTreeSelector_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkKdTreeSelector* op = static_cast<vtkKdTreeSelector*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkKdTreeSelector_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkKdTreeSelector* op = static_cast<vtkKdTreeSelector*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTreeSelector_SetKdTree_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkKdTree * temp0;
  temp0 = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, id0));

  vtkKdTreeSelector* op = static_cast<vtkKdTreeSelector*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetKdTree(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkKdTreeSelector_GetKdTree_15(JNIEnv* env, jobject obj)
{
  vtkKdTree * temp20;

  vtkKdTreeSelector* op = static_cast<vtkKdTreeSelector*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKdTree();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTreeSelector_SetSelectionBounds_16(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkKdTreeSelector* op = static_cast<vtkKdTreeSelector*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectionBounds(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTreeSelector_SetSelectionBounds_17(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkKdTreeSelector* op = static_cast<vtkKdTreeSelector*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectionBounds(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkKdTreeSelector_GetSelectionBounds_18(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkKdTreeSelector* op = static_cast<vtkKdTreeSelector*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectionBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTreeSelector_SetSelectionFieldName_19(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkKdTreeSelector* op = static_cast<vtkKdTreeSelector*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectionFieldName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkKdTreeSelector_GetSelectionFieldName_110(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkKdTreeSelector* op = static_cast<vtkKdTreeSelector*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectionFieldName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTreeSelector_SetSelectionAttribute_111(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkKdTreeSelector* op = static_cast<vtkKdTreeSelector*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectionAttribute(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdTreeSelector_GetSelectionAttribute_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkKdTreeSelector* op = static_cast<vtkKdTreeSelector*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectionAttribute();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTreeSelector_SetSingleSelection_113(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkKdTreeSelector* op = static_cast<vtkKdTreeSelector*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSingleSelection(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkKdTreeSelector_GetSingleSelection_114(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkKdTreeSelector* op = static_cast<vtkKdTreeSelector*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSingleSelection();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTreeSelector_SingleSelectionOn_115(JNIEnv* env, jobject obj)
{

  vtkKdTreeSelector* op = static_cast<vtkKdTreeSelector*>(vtkJavaGetPointerFromObject(env, obj));
  op->SingleSelectionOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTreeSelector_SingleSelectionOff_116(JNIEnv* env, jobject obj)
{

  vtkKdTreeSelector* op = static_cast<vtkKdTreeSelector*>(vtkJavaGetPointerFromObject(env, obj));
  op->SingleSelectionOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTreeSelector_SetSingleSelectionThreshold_117(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkKdTreeSelector* op = static_cast<vtkKdTreeSelector*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSingleSelectionThreshold(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkKdTreeSelector_GetSingleSelectionThreshold_118(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkKdTreeSelector* op = static_cast<vtkKdTreeSelector*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSingleSelectionThreshold();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkKdTreeSelector_GetMTime_119(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkKdTreeSelector* op = static_cast<vtkKdTreeSelector*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkKdTreeSelector_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkKdTreeSelector::New());
}
