// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkFluidMapperThicknessAndVolumeColorFilterFS.h"

const char *vtkFluidMapperThicknessAndVolumeColorFilterFS =
"//VTK::System::Dec\n"
"\n"
"// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen\n"
"// SPDX-License-Identifier: BSD-3-Clause\n"
"uniform sampler2D fluidThicknessTexture;\n"
"uniform int       viewportWidth;\n"
"uniform int       viewportHeight;\n"
"uniform int       filterRadius = 5;\n"
"\n"
"uniform int       hasVertexColor = 0;\n"
"uniform sampler2D fluidColorTexture;\n"
"\n"
"uniform float minThickness;\n"
"\n"
"in vec2 texCoord;\n"
"// the output of this shader\n"
"//VTK::Output::Dec\n"
"\n"
"//-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+\n"
"float compute_weight2D(vec2 r, float two_sigma2)\n"
"{\n"
"  return exp(-dot(r, r) / two_sigma2);\n"
"}\n"
"\n"
"void main()\n"
"{\n"
"  vec2  blurRadius = vec2(1.0 / float(viewportWidth), 1.0 / float(viewportHeight));\n"
"  float sigma      = float(filterRadius) / 3.0;\n"
"  float two_sigma2 = 2.0 * sigma * sigma;\n"
"  float fthick     = texture2D(fluidThicknessTexture, texCoord).r;\n"
"  if (fthick < minThickness)\n"
"  {\n"
"    discard;\n"
"  }\n"
"\n"
"  vec4 f_tex = texCoord.xyxy;\n"
"  vec2 r     = vec2(0, 0);\n"
"  vec4 sum4  = vec4(fthick, 0, 0, 0);\n"
"  vec4 wsum4 = vec4(1, 0, 0, 0);\n"
"  vec4 sampleThick;\n"
"  vec4 w4_r;\n"
"\n"
"  for(int x = 1; x <= filterRadius; ++x)\n"
"  {\n"
"    r.x     += blurRadius.x;\n"
"    f_tex.x += blurRadius.x;\n"
"    f_tex.z -= blurRadius.x;\n"
"    vec4 f_tex1 = f_tex.xyxy;\n"
"    vec4 f_tex2 = f_tex.zwzw;\n"
"\n"
"    for(int y = 1; y <= filterRadius; ++y)\n"
"    {\n"
"      r.y += blurRadius.y;\n"
"      w4_r = vec4(compute_weight2D(blurRadius * r, two_sigma2));\n"
"\n"
"      f_tex1.y += blurRadius.y;\n"
"      f_tex1.w -= blurRadius.y;\n"
"      f_tex2.y += blurRadius.y;\n"
"      f_tex2.w -= blurRadius.y;\n"
"\n"
"      sampleThick.x = texture(fluidThicknessTexture, f_tex1.xy).r;\n"
"      sampleThick.y = texture(fluidThicknessTexture, f_tex1.zw).r;\n"
"      sampleThick.z = texture(fluidThicknessTexture, f_tex2.xy).r;\n"
"      sampleThick.w = texture(fluidThicknessTexture, f_tex2.zw).r;\n"
"      sum4         += sampleThick * w4_r;\n"
"      wsum4        += w4_r;\n"
"    }\n"
"  }\n"
"\n"
"  vec2 filteredThickness;\n"
"  filteredThickness.x = dot(sum4, vec4(1, 1, 1, 1));\n"
"  filteredThickness.y = dot(wsum4, vec4(1, 1, 1, 1));\n"
"  gl_FragData[0]      = vec4(filteredThickness.x / filteredThickness.y, 0, 0, 1);\n"
"\n"
"  if(hasVertexColor == 0)\n"
"  {\n"
"    return;\n"
"  }\n"
"\n"
"  f_tex = texCoord.xyxy;\n"
"  r     = vec2(0, 0);\n"
"  vec3 sumColor = texture2D(fluidColorTexture, texCoord).rgb;\n"
"  wsum4 = vec4(1, 0, 0, 0);\n"
"\n"
"  for(int x = 1; x <= filterRadius; ++x)\n"
"  {\n"
"    r.x     += blurRadius.x;\n"
"    f_tex.x += blurRadius.x;\n"
"    f_tex.z -= blurRadius.x;\n"
"    vec4 f_tex1 = f_tex.xyxy;\n"
"    vec4 f_tex2 = f_tex.zwzw;\n"
"\n"
"    for(int y = 1; y <= filterRadius; ++y)\n"
"    {\n"
"      r.y   += blurRadius.y;\n"
"      w4_r   = vec4(compute_weight2D(blurRadius * r, two_sigma2));\n"
"      wsum4 += w4_r;\n"
"\n"
"      f_tex1.y += blurRadius.y;\n"
"      f_tex1.w -= blurRadius.y;\n"
"      f_tex2.y += blurRadius.y;\n"
"      f_tex2.w -= blurRadius.y;\n"
"\n"
"      vec3 sampleColor = texture(fluidColorTexture, f_tex1.xy).rgb;\n"
"      sumColor += sampleColor * w4_r[0];\n"
"\n"
"      sampleColor = texture(fluidColorTexture, f_tex1.zw).rgb;\n"
"      sumColor   += sampleColor * w4_r[1];\n"
"\n"
"      sampleColor = texture(fluidColorTexture, f_tex2.xy).rgb;\n"
"      sumColor   += sampleColor * w4_r[2];\n"
"\n"
"      sampleColor = texture(fluidColorTexture, f_tex2.zw).rgb;\n"
"      sumColor   += sampleColor * w4_r[3];\n"
"    }\n"
"  }\n"
"\n"
"  float wsum = dot(wsum4, vec4(1, 1, 1, 1));\n"
"  gl_FragData[1] = vec4(sumColor / wsum, 1);\n"
"}\n"
"";
