/** @file
 * VirtualBox API class wrapper code for IResourceStore.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_RESOURCESTORE

#include "ResourceStoreWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(ResourceStoreWrap)

//
// IResourceStore properties
//

STDMETHODIMP ResourceStoreWrap::COMGETTER(MidlDoesNotLikeEmptyInterfaces)(BOOL *aMidlDoesNotLikeEmptyInterfaces)
{
#if 0 /* This is a dummy attribute */
    LogRelFlow(("{%p} %s: enter aMidlDoesNotLikeEmptyInterfaces=%p\n", this, "ResourceStore::getMidlDoesNotLikeEmptyInterfaces", aMidlDoesNotLikeEmptyInterfaces));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMidlDoesNotLikeEmptyInterfaces);
        
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMidlDoesNotLikeEmptyInterfaces(aMidlDoesNotLikeEmptyInterfaces);
        }
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
    }

    LogRelFlow(("{%p} %s: leave *aMidlDoesNotLikeEmptyInterfaces=%RTbool hrc=%Rhrc\n", this, "ResourceStore::getMidlDoesNotLikeEmptyInterfaces", *aMidlDoesNotLikeEmptyInterfaces, hrc));
    return hrc;
#else  /* dummy attribute */
    NOREF(aMidlDoesNotLikeEmptyInterfaces);
    return E_FAIL;
#endif /* dummy attribute */
}


//
// IResourceStore methods
//

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(ResourceStoreWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(ResourceStoreWrap, IResourceStore)
#endif // VBOX_WITH_XPCOM
