/** @file
 * VirtualBox API class wrapper code for IPlatform.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_PLATFORM

#include "PlatformWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(PlatformWrap)

//
// IPlatform properties
//

STDMETHODIMP PlatformWrap::COMGETTER(Architecture)(PlatformArchitecture_T *aArchitecture)
{
    LogRelFlow(("{%p} %s: enter aArchitecture=%p\n", this, "Platform::getArchitecture", aArchitecture));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aArchitecture);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_GET_ARCHITECTURE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getArchitecture(aArchitecture);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_GET_ARCHITECTURE_RETURN(this, hrc, 0 /*normal*/,*aArchitecture);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_GET_ARCHITECTURE_RETURN(this, hrc, 1 /*hrc exception*/,*aArchitecture);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_GET_ARCHITECTURE_RETURN(this, hrc, 9 /*unhandled exception*/,*aArchitecture);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aArchitecture=%RU32 hrc=%Rhrc\n", this, "Platform::getArchitecture", *aArchitecture, hrc));
    return hrc;
}

STDMETHODIMP PlatformWrap::COMSETTER(Architecture)(PlatformArchitecture_T aArchitecture)
{
    LogRelFlow(("{%p} %s: enter aArchitecture=%RU32\n", this, "Platform::setArchitecture", aArchitecture));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_SET_ARCHITECTURE_ENTER(this, aArchitecture);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setArchitecture(aArchitecture);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_SET_ARCHITECTURE_RETURN(this, hrc, 0 /*normal*/,aArchitecture);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_SET_ARCHITECTURE_RETURN(this, hrc, 1 /*hrc exception*/,aArchitecture);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_SET_ARCHITECTURE_RETURN(this, hrc, 9 /*unhandled exception*/,aArchitecture);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Platform::setArchitecture", hrc));
    return hrc;
}

STDMETHODIMP PlatformWrap::COMGETTER(Properties)(IPlatformProperties **aProperties)
{
    LogRelFlow(("{%p} %s: enter aProperties=%p\n", this, "Platform::getProperties", aProperties));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProperties);
        ComTypeOutConverter<IPlatformProperties> TmpProperties(aProperties);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_GET_PROPERTIES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProperties(TmpProperties.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_GET_PROPERTIES_RETURN(this, hrc, 0 /*normal*/,(void *)TmpProperties.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_GET_PROPERTIES_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_GET_PROPERTIES_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aProperties=%p hrc=%Rhrc\n", this, "Platform::getProperties", *aProperties, hrc));
    return hrc;
}

STDMETHODIMP PlatformWrap::COMGETTER(X86)(IPlatformX86 **aX86)
{
    LogRelFlow(("{%p} %s: enter aX86=%p\n", this, "Platform::getX86", aX86));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aX86);
        ComTypeOutConverter<IPlatformX86> TmpX86(aX86);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_GET_X86_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getX86(TmpX86.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_GET_X86_RETURN(this, hrc, 0 /*normal*/,(void *)TmpX86.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_GET_X86_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_GET_X86_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aX86=%p hrc=%Rhrc\n", this, "Platform::getX86", *aX86, hrc));
    return hrc;
}

STDMETHODIMP PlatformWrap::COMGETTER(ARM)(IPlatformARM **aARM)
{
    LogRelFlow(("{%p} %s: enter aARM=%p\n", this, "Platform::getARM", aARM));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aARM);
        ComTypeOutConverter<IPlatformARM> TmpARM(aARM);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_GET_ARM_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getARM(TmpARM.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_GET_ARM_RETURN(this, hrc, 0 /*normal*/,(void *)TmpARM.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_GET_ARM_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_GET_ARM_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aARM=%p hrc=%Rhrc\n", this, "Platform::getARM", *aARM, hrc));
    return hrc;
}

STDMETHODIMP PlatformWrap::COMGETTER(ChipsetType)(ChipsetType_T *aChipsetType)
{
    LogRelFlow(("{%p} %s: enter aChipsetType=%p\n", this, "Platform::getChipsetType", aChipsetType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aChipsetType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_GET_CHIPSETTYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getChipsetType(aChipsetType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_GET_CHIPSETTYPE_RETURN(this, hrc, 0 /*normal*/,*aChipsetType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_GET_CHIPSETTYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aChipsetType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_GET_CHIPSETTYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aChipsetType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aChipsetType=%RU32 hrc=%Rhrc\n", this, "Platform::getChipsetType", *aChipsetType, hrc));
    return hrc;
}

STDMETHODIMP PlatformWrap::COMSETTER(ChipsetType)(ChipsetType_T aChipsetType)
{
    LogRelFlow(("{%p} %s: enter aChipsetType=%RU32\n", this, "Platform::setChipsetType", aChipsetType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_SET_CHIPSETTYPE_ENTER(this, aChipsetType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setChipsetType(aChipsetType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_SET_CHIPSETTYPE_RETURN(this, hrc, 0 /*normal*/,aChipsetType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_SET_CHIPSETTYPE_RETURN(this, hrc, 1 /*hrc exception*/,aChipsetType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_SET_CHIPSETTYPE_RETURN(this, hrc, 9 /*unhandled exception*/,aChipsetType);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Platform::setChipsetType", hrc));
    return hrc;
}

STDMETHODIMP PlatformWrap::COMGETTER(IommuType)(IommuType_T *aIommuType)
{
    LogRelFlow(("{%p} %s: enter aIommuType=%p\n", this, "Platform::getIommuType", aIommuType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIommuType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_GET_IOMMUTYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIommuType(aIommuType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_GET_IOMMUTYPE_RETURN(this, hrc, 0 /*normal*/,*aIommuType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_GET_IOMMUTYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aIommuType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_GET_IOMMUTYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aIommuType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIommuType=%RU32 hrc=%Rhrc\n", this, "Platform::getIommuType", *aIommuType, hrc));
    return hrc;
}

STDMETHODIMP PlatformWrap::COMSETTER(IommuType)(IommuType_T aIommuType)
{
    LogRelFlow(("{%p} %s: enter aIommuType=%RU32\n", this, "Platform::setIommuType", aIommuType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_SET_IOMMUTYPE_ENTER(this, aIommuType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setIommuType(aIommuType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_SET_IOMMUTYPE_RETURN(this, hrc, 0 /*normal*/,aIommuType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_SET_IOMMUTYPE_RETURN(this, hrc, 1 /*hrc exception*/,aIommuType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_SET_IOMMUTYPE_RETURN(this, hrc, 9 /*unhandled exception*/,aIommuType);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Platform::setIommuType", hrc));
    return hrc;
}

STDMETHODIMP PlatformWrap::COMGETTER(RTCUseUTC)(BOOL *aRTCUseUTC)
{
    LogRelFlow(("{%p} %s: enter aRTCUseUTC=%p\n", this, "Platform::getRTCUseUTC", aRTCUseUTC));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRTCUseUTC);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_GET_RTCUSEUTC_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRTCUseUTC(aRTCUseUTC);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_GET_RTCUSEUTC_RETURN(this, hrc, 0 /*normal*/,*aRTCUseUTC != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_GET_RTCUSEUTC_RETURN(this, hrc, 1 /*hrc exception*/,*aRTCUseUTC != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_GET_RTCUSEUTC_RETURN(this, hrc, 9 /*unhandled exception*/,*aRTCUseUTC != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRTCUseUTC=%RTbool hrc=%Rhrc\n", this, "Platform::getRTCUseUTC", *aRTCUseUTC, hrc));
    return hrc;
}

STDMETHODIMP PlatformWrap::COMSETTER(RTCUseUTC)(BOOL aRTCUseUTC)
{
    LogRelFlow(("{%p} %s: enter aRTCUseUTC=%RTbool\n", this, "Platform::setRTCUseUTC", aRTCUseUTC));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_SET_RTCUSEUTC_ENTER(this, aRTCUseUTC != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setRTCUseUTC(aRTCUseUTC != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_SET_RTCUSEUTC_RETURN(this, hrc, 0 /*normal*/,aRTCUseUTC != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_SET_RTCUSEUTC_RETURN(this, hrc, 1 /*hrc exception*/,aRTCUseUTC != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORM_SET_RTCUSEUTC_RETURN(this, hrc, 9 /*unhandled exception*/,aRTCUseUTC != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Platform::setRTCUseUTC", hrc));
    return hrc;
}

STDMETHODIMP PlatformWrap::COMGETTER(InternalAndReservedAttribute1IPlatform)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformWrap::COMGETTER(InternalAndReservedAttribute2IPlatform)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformWrap::COMGETTER(InternalAndReservedAttribute3IPlatform)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformWrap::COMGETTER(InternalAndReservedAttribute4IPlatform)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformWrap::COMGETTER(InternalAndReservedAttribute5IPlatform)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformWrap::COMGETTER(InternalAndReservedAttribute6IPlatform)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformWrap::COMGETTER(InternalAndReservedAttribute7IPlatform)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformWrap::COMGETTER(InternalAndReservedAttribute8IPlatform)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformWrap::COMGETTER(InternalAndReservedAttribute9IPlatform)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformWrap::COMGETTER(InternalAndReservedAttribute10IPlatform)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformWrap::COMGETTER(InternalAndReservedAttribute11IPlatform)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformWrap::COMGETTER(InternalAndReservedAttribute12IPlatform)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformWrap::COMGETTER(InternalAndReservedAttribute13IPlatform)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformWrap::COMGETTER(InternalAndReservedAttribute14IPlatform)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformWrap::COMGETTER(InternalAndReservedAttribute15IPlatform)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformWrap::COMGETTER(InternalAndReservedAttribute16IPlatform)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IPlatform methods
//

STDMETHODIMP PlatformWrap::InternalAndReservedMethod1IPlatform()
{
    return E_NOTIMPL;
}

STDMETHODIMP PlatformWrap::InternalAndReservedMethod2IPlatform()
{
    return E_NOTIMPL;
}

STDMETHODIMP PlatformWrap::InternalAndReservedMethod3IPlatform()
{
    return E_NOTIMPL;
}

STDMETHODIMP PlatformWrap::InternalAndReservedMethod4IPlatform()
{
    return E_NOTIMPL;
}

STDMETHODIMP PlatformWrap::InternalAndReservedMethod5IPlatform()
{
    return E_NOTIMPL;
}

STDMETHODIMP PlatformWrap::InternalAndReservedMethod6IPlatform()
{
    return E_NOTIMPL;
}

STDMETHODIMP PlatformWrap::InternalAndReservedMethod7IPlatform()
{
    return E_NOTIMPL;
}

STDMETHODIMP PlatformWrap::InternalAndReservedMethod8IPlatform()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(PlatformWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(PlatformWrap, IPlatform)
#endif // VBOX_WITH_XPCOM
