/** @file
 * VirtualBox API class wrapper code for INetworkAdapter.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_NETWORKADAPTER

#include "NetworkAdapterWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(NetworkAdapterWrap)

//
// INetworkAdapter properties
//

STDMETHODIMP NetworkAdapterWrap::COMGETTER(AdapterType)(NetworkAdapterType_T *aAdapterType)
{
    LogRelFlow(("{%p} %s: enter aAdapterType=%p\n", this, "NetworkAdapter::getAdapterType", aAdapterType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAdapterType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_ADAPTERTYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAdapterType(aAdapterType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_ADAPTERTYPE_RETURN(this, hrc, 0 /*normal*/,*aAdapterType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_ADAPTERTYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aAdapterType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_ADAPTERTYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aAdapterType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAdapterType=%RU32 hrc=%Rhrc\n", this, "NetworkAdapter::getAdapterType", *aAdapterType, hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMSETTER(AdapterType)(NetworkAdapterType_T aAdapterType)
{
    LogRelFlow(("{%p} %s: enter aAdapterType=%RU32\n", this, "NetworkAdapter::setAdapterType", aAdapterType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_ADAPTERTYPE_ENTER(this, aAdapterType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAdapterType(aAdapterType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_ADAPTERTYPE_RETURN(this, hrc, 0 /*normal*/,aAdapterType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_ADAPTERTYPE_RETURN(this, hrc, 1 /*hrc exception*/,aAdapterType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_ADAPTERTYPE_RETURN(this, hrc, 9 /*unhandled exception*/,aAdapterType);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NetworkAdapter::setAdapterType", hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMGETTER(Slot)(ULONG *aSlot)
{
    LogRelFlow(("{%p} %s: enter aSlot=%p\n", this, "NetworkAdapter::getSlot", aSlot));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSlot);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_SLOT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSlot(aSlot);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_SLOT_RETURN(this, hrc, 0 /*normal*/,*aSlot);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_SLOT_RETURN(this, hrc, 1 /*hrc exception*/,*aSlot);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_SLOT_RETURN(this, hrc, 9 /*unhandled exception*/,*aSlot);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSlot=%RU32 hrc=%Rhrc\n", this, "NetworkAdapter::getSlot", *aSlot, hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMGETTER(Enabled)(BOOL *aEnabled)
{
    LogRelFlow(("{%p} %s: enter aEnabled=%p\n", this, "NetworkAdapter::getEnabled", aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_ENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEnabled(aEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_ENABLED_RETURN(this, hrc, 0 /*normal*/,*aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_ENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_ENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEnabled=%RTbool hrc=%Rhrc\n", this, "NetworkAdapter::getEnabled", *aEnabled, hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMSETTER(Enabled)(BOOL aEnabled)
{
    LogRelFlow(("{%p} %s: enter aEnabled=%RTbool\n", this, "NetworkAdapter::setEnabled", aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_ENABLED_ENTER(this, aEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setEnabled(aEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_ENABLED_RETURN(this, hrc, 0 /*normal*/,aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_ENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_ENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NetworkAdapter::setEnabled", hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMGETTER(MACAddress)(BSTR *aMACAddress)
{
    LogRelFlow(("{%p} %s: enter aMACAddress=%p\n", this, "NetworkAdapter::getMACAddress", aMACAddress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMACAddress);
        BSTROutConverter TmpMACAddress(aMACAddress);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_MACADDRESS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMACAddress(TmpMACAddress.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_MACADDRESS_RETURN(this, hrc, 0 /*normal*/,TmpMACAddress.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_MACADDRESS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_MACADDRESS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMACAddress=%ls hrc=%Rhrc\n", this, "NetworkAdapter::getMACAddress", *aMACAddress, hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMSETTER(MACAddress)(IN_BSTR aMACAddress)
{
    LogRelFlow(("{%p} %s: enter aMACAddress=%ls\n", this, "NetworkAdapter::setMACAddress", aMACAddress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpMACAddress(aMACAddress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_MACADDRESS_ENTER(this, TmpMACAddress.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setMACAddress(TmpMACAddress.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_MACADDRESS_RETURN(this, hrc, 0 /*normal*/,TmpMACAddress.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_MACADDRESS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_MACADDRESS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NetworkAdapter::setMACAddress", hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMGETTER(AttachmentType)(NetworkAttachmentType_T *aAttachmentType)
{
    LogRelFlow(("{%p} %s: enter aAttachmentType=%p\n", this, "NetworkAdapter::getAttachmentType", aAttachmentType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAttachmentType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_ATTACHMENTTYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAttachmentType(aAttachmentType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_ATTACHMENTTYPE_RETURN(this, hrc, 0 /*normal*/,*aAttachmentType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_ATTACHMENTTYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aAttachmentType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_ATTACHMENTTYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aAttachmentType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAttachmentType=%RU32 hrc=%Rhrc\n", this, "NetworkAdapter::getAttachmentType", *aAttachmentType, hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMSETTER(AttachmentType)(NetworkAttachmentType_T aAttachmentType)
{
    LogRelFlow(("{%p} %s: enter aAttachmentType=%RU32\n", this, "NetworkAdapter::setAttachmentType", aAttachmentType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_ATTACHMENTTYPE_ENTER(this, aAttachmentType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAttachmentType(aAttachmentType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_ATTACHMENTTYPE_RETURN(this, hrc, 0 /*normal*/,aAttachmentType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_ATTACHMENTTYPE_RETURN(this, hrc, 1 /*hrc exception*/,aAttachmentType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_ATTACHMENTTYPE_RETURN(this, hrc, 9 /*unhandled exception*/,aAttachmentType);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NetworkAdapter::setAttachmentType", hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMGETTER(BridgedInterface)(BSTR *aBridgedInterface)
{
    LogRelFlow(("{%p} %s: enter aBridgedInterface=%p\n", this, "NetworkAdapter::getBridgedInterface", aBridgedInterface));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aBridgedInterface);
        BSTROutConverter TmpBridgedInterface(aBridgedInterface);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_BRIDGEDINTERFACE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getBridgedInterface(TmpBridgedInterface.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_BRIDGEDINTERFACE_RETURN(this, hrc, 0 /*normal*/,TmpBridgedInterface.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_BRIDGEDINTERFACE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_BRIDGEDINTERFACE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aBridgedInterface=%ls hrc=%Rhrc\n", this, "NetworkAdapter::getBridgedInterface", *aBridgedInterface, hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMSETTER(BridgedInterface)(IN_BSTR aBridgedInterface)
{
    LogRelFlow(("{%p} %s: enter aBridgedInterface=%ls\n", this, "NetworkAdapter::setBridgedInterface", aBridgedInterface));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpBridgedInterface(aBridgedInterface);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_BRIDGEDINTERFACE_ENTER(this, TmpBridgedInterface.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setBridgedInterface(TmpBridgedInterface.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_BRIDGEDINTERFACE_RETURN(this, hrc, 0 /*normal*/,TmpBridgedInterface.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_BRIDGEDINTERFACE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_BRIDGEDINTERFACE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NetworkAdapter::setBridgedInterface", hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMGETTER(HostOnlyInterface)(BSTR *aHostOnlyInterface)
{
    LogRelFlow(("{%p} %s: enter aHostOnlyInterface=%p\n", this, "NetworkAdapter::getHostOnlyInterface", aHostOnlyInterface));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHostOnlyInterface);
        BSTROutConverter TmpHostOnlyInterface(aHostOnlyInterface);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_HOSTONLYINTERFACE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHostOnlyInterface(TmpHostOnlyInterface.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_HOSTONLYINTERFACE_RETURN(this, hrc, 0 /*normal*/,TmpHostOnlyInterface.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_HOSTONLYINTERFACE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_HOSTONLYINTERFACE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHostOnlyInterface=%ls hrc=%Rhrc\n", this, "NetworkAdapter::getHostOnlyInterface", *aHostOnlyInterface, hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMSETTER(HostOnlyInterface)(IN_BSTR aHostOnlyInterface)
{
    LogRelFlow(("{%p} %s: enter aHostOnlyInterface=%ls\n", this, "NetworkAdapter::setHostOnlyInterface", aHostOnlyInterface));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpHostOnlyInterface(aHostOnlyInterface);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_HOSTONLYINTERFACE_ENTER(this, TmpHostOnlyInterface.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setHostOnlyInterface(TmpHostOnlyInterface.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_HOSTONLYINTERFACE_RETURN(this, hrc, 0 /*normal*/,TmpHostOnlyInterface.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_HOSTONLYINTERFACE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_HOSTONLYINTERFACE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NetworkAdapter::setHostOnlyInterface", hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMGETTER(HostOnlyNetwork)(BSTR *aHostOnlyNetwork)
{
    LogRelFlow(("{%p} %s: enter aHostOnlyNetwork=%p\n", this, "NetworkAdapter::getHostOnlyNetwork", aHostOnlyNetwork));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHostOnlyNetwork);
        BSTROutConverter TmpHostOnlyNetwork(aHostOnlyNetwork);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_HOSTONLYNETWORK_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHostOnlyNetwork(TmpHostOnlyNetwork.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_HOSTONLYNETWORK_RETURN(this, hrc, 0 /*normal*/,TmpHostOnlyNetwork.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_HOSTONLYNETWORK_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_HOSTONLYNETWORK_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHostOnlyNetwork=%ls hrc=%Rhrc\n", this, "NetworkAdapter::getHostOnlyNetwork", *aHostOnlyNetwork, hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMSETTER(HostOnlyNetwork)(IN_BSTR aHostOnlyNetwork)
{
    LogRelFlow(("{%p} %s: enter aHostOnlyNetwork=%ls\n", this, "NetworkAdapter::setHostOnlyNetwork", aHostOnlyNetwork));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpHostOnlyNetwork(aHostOnlyNetwork);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_HOSTONLYNETWORK_ENTER(this, TmpHostOnlyNetwork.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setHostOnlyNetwork(TmpHostOnlyNetwork.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_HOSTONLYNETWORK_RETURN(this, hrc, 0 /*normal*/,TmpHostOnlyNetwork.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_HOSTONLYNETWORK_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_HOSTONLYNETWORK_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NetworkAdapter::setHostOnlyNetwork", hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMGETTER(InternalNetwork)(BSTR *aInternalNetwork)
{
    LogRelFlow(("{%p} %s: enter aInternalNetwork=%p\n", this, "NetworkAdapter::getInternalNetwork", aInternalNetwork));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aInternalNetwork);
        BSTROutConverter TmpInternalNetwork(aInternalNetwork);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_INTERNALNETWORK_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getInternalNetwork(TmpInternalNetwork.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_INTERNALNETWORK_RETURN(this, hrc, 0 /*normal*/,TmpInternalNetwork.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_INTERNALNETWORK_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_INTERNALNETWORK_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aInternalNetwork=%ls hrc=%Rhrc\n", this, "NetworkAdapter::getInternalNetwork", *aInternalNetwork, hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMSETTER(InternalNetwork)(IN_BSTR aInternalNetwork)
{
    LogRelFlow(("{%p} %s: enter aInternalNetwork=%ls\n", this, "NetworkAdapter::setInternalNetwork", aInternalNetwork));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpInternalNetwork(aInternalNetwork);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_INTERNALNETWORK_ENTER(this, TmpInternalNetwork.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setInternalNetwork(TmpInternalNetwork.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_INTERNALNETWORK_RETURN(this, hrc, 0 /*normal*/,TmpInternalNetwork.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_INTERNALNETWORK_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_INTERNALNETWORK_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NetworkAdapter::setInternalNetwork", hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMGETTER(NATNetwork)(BSTR *aNATNetwork)
{
    LogRelFlow(("{%p} %s: enter aNATNetwork=%p\n", this, "NetworkAdapter::getNATNetwork", aNATNetwork));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNATNetwork);
        BSTROutConverter TmpNATNetwork(aNATNetwork);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_NATNETWORK_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getNATNetwork(TmpNATNetwork.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_NATNETWORK_RETURN(this, hrc, 0 /*normal*/,TmpNATNetwork.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_NATNETWORK_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_NATNETWORK_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNATNetwork=%ls hrc=%Rhrc\n", this, "NetworkAdapter::getNATNetwork", *aNATNetwork, hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMSETTER(NATNetwork)(IN_BSTR aNATNetwork)
{
    LogRelFlow(("{%p} %s: enter aNATNetwork=%ls\n", this, "NetworkAdapter::setNATNetwork", aNATNetwork));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpNATNetwork(aNATNetwork);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_NATNETWORK_ENTER(this, TmpNATNetwork.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setNATNetwork(TmpNATNetwork.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_NATNETWORK_RETURN(this, hrc, 0 /*normal*/,TmpNATNetwork.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_NATNETWORK_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_NATNETWORK_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NetworkAdapter::setNATNetwork", hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMGETTER(GenericDriver)(BSTR *aGenericDriver)
{
    LogRelFlow(("{%p} %s: enter aGenericDriver=%p\n", this, "NetworkAdapter::getGenericDriver", aGenericDriver));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aGenericDriver);
        BSTROutConverter TmpGenericDriver(aGenericDriver);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_GENERICDRIVER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getGenericDriver(TmpGenericDriver.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_GENERICDRIVER_RETURN(this, hrc, 0 /*normal*/,TmpGenericDriver.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_GENERICDRIVER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_GENERICDRIVER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aGenericDriver=%ls hrc=%Rhrc\n", this, "NetworkAdapter::getGenericDriver", *aGenericDriver, hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMSETTER(GenericDriver)(IN_BSTR aGenericDriver)
{
    LogRelFlow(("{%p} %s: enter aGenericDriver=%ls\n", this, "NetworkAdapter::setGenericDriver", aGenericDriver));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpGenericDriver(aGenericDriver);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_GENERICDRIVER_ENTER(this, TmpGenericDriver.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setGenericDriver(TmpGenericDriver.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_GENERICDRIVER_RETURN(this, hrc, 0 /*normal*/,TmpGenericDriver.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_GENERICDRIVER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_GENERICDRIVER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NetworkAdapter::setGenericDriver", hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMGETTER(CloudNetwork)(BSTR *aCloudNetwork)
{
    LogRelFlow(("{%p} %s: enter aCloudNetwork=%p\n", this, "NetworkAdapter::getCloudNetwork", aCloudNetwork));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCloudNetwork);
        BSTROutConverter TmpCloudNetwork(aCloudNetwork);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_CLOUDNETWORK_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCloudNetwork(TmpCloudNetwork.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_CLOUDNETWORK_RETURN(this, hrc, 0 /*normal*/,TmpCloudNetwork.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_CLOUDNETWORK_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_CLOUDNETWORK_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aCloudNetwork=%ls hrc=%Rhrc\n", this, "NetworkAdapter::getCloudNetwork", *aCloudNetwork, hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMSETTER(CloudNetwork)(IN_BSTR aCloudNetwork)
{
    LogRelFlow(("{%p} %s: enter aCloudNetwork=%ls\n", this, "NetworkAdapter::setCloudNetwork", aCloudNetwork));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpCloudNetwork(aCloudNetwork);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_CLOUDNETWORK_ENTER(this, TmpCloudNetwork.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setCloudNetwork(TmpCloudNetwork.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_CLOUDNETWORK_RETURN(this, hrc, 0 /*normal*/,TmpCloudNetwork.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_CLOUDNETWORK_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_CLOUDNETWORK_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NetworkAdapter::setCloudNetwork", hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMGETTER(CableConnected)(BOOL *aCableConnected)
{
    LogRelFlow(("{%p} %s: enter aCableConnected=%p\n", this, "NetworkAdapter::getCableConnected", aCableConnected));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCableConnected);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_CABLECONNECTED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCableConnected(aCableConnected);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_CABLECONNECTED_RETURN(this, hrc, 0 /*normal*/,*aCableConnected != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_CABLECONNECTED_RETURN(this, hrc, 1 /*hrc exception*/,*aCableConnected != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_CABLECONNECTED_RETURN(this, hrc, 9 /*unhandled exception*/,*aCableConnected != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aCableConnected=%RTbool hrc=%Rhrc\n", this, "NetworkAdapter::getCableConnected", *aCableConnected, hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMSETTER(CableConnected)(BOOL aCableConnected)
{
    LogRelFlow(("{%p} %s: enter aCableConnected=%RTbool\n", this, "NetworkAdapter::setCableConnected", aCableConnected));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_CABLECONNECTED_ENTER(this, aCableConnected != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setCableConnected(aCableConnected != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_CABLECONNECTED_RETURN(this, hrc, 0 /*normal*/,aCableConnected != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_CABLECONNECTED_RETURN(this, hrc, 1 /*hrc exception*/,aCableConnected != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_CABLECONNECTED_RETURN(this, hrc, 9 /*unhandled exception*/,aCableConnected != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NetworkAdapter::setCableConnected", hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMGETTER(LineSpeed)(ULONG *aLineSpeed)
{
    LogRelFlow(("{%p} %s: enter aLineSpeed=%p\n", this, "NetworkAdapter::getLineSpeed", aLineSpeed));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLineSpeed);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_LINESPEED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLineSpeed(aLineSpeed);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_LINESPEED_RETURN(this, hrc, 0 /*normal*/,*aLineSpeed);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_LINESPEED_RETURN(this, hrc, 1 /*hrc exception*/,*aLineSpeed);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_LINESPEED_RETURN(this, hrc, 9 /*unhandled exception*/,*aLineSpeed);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLineSpeed=%RU32 hrc=%Rhrc\n", this, "NetworkAdapter::getLineSpeed", *aLineSpeed, hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMSETTER(LineSpeed)(ULONG aLineSpeed)
{
    LogRelFlow(("{%p} %s: enter aLineSpeed=%RU32\n", this, "NetworkAdapter::setLineSpeed", aLineSpeed));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_LINESPEED_ENTER(this, aLineSpeed);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setLineSpeed(aLineSpeed);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_LINESPEED_RETURN(this, hrc, 0 /*normal*/,aLineSpeed);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_LINESPEED_RETURN(this, hrc, 1 /*hrc exception*/,aLineSpeed);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_LINESPEED_RETURN(this, hrc, 9 /*unhandled exception*/,aLineSpeed);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NetworkAdapter::setLineSpeed", hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMGETTER(PromiscModePolicy)(NetworkAdapterPromiscModePolicy_T *aPromiscModePolicy)
{
    LogRelFlow(("{%p} %s: enter aPromiscModePolicy=%p\n", this, "NetworkAdapter::getPromiscModePolicy", aPromiscModePolicy));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPromiscModePolicy);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_PROMISCMODEPOLICY_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPromiscModePolicy(aPromiscModePolicy);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_PROMISCMODEPOLICY_RETURN(this, hrc, 0 /*normal*/,*aPromiscModePolicy);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_PROMISCMODEPOLICY_RETURN(this, hrc, 1 /*hrc exception*/,*aPromiscModePolicy);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_PROMISCMODEPOLICY_RETURN(this, hrc, 9 /*unhandled exception*/,*aPromiscModePolicy);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPromiscModePolicy=%RU32 hrc=%Rhrc\n", this, "NetworkAdapter::getPromiscModePolicy", *aPromiscModePolicy, hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMSETTER(PromiscModePolicy)(NetworkAdapterPromiscModePolicy_T aPromiscModePolicy)
{
    LogRelFlow(("{%p} %s: enter aPromiscModePolicy=%RU32\n", this, "NetworkAdapter::setPromiscModePolicy", aPromiscModePolicy));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_PROMISCMODEPOLICY_ENTER(this, aPromiscModePolicy);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setPromiscModePolicy(aPromiscModePolicy);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_PROMISCMODEPOLICY_RETURN(this, hrc, 0 /*normal*/,aPromiscModePolicy);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_PROMISCMODEPOLICY_RETURN(this, hrc, 1 /*hrc exception*/,aPromiscModePolicy);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_PROMISCMODEPOLICY_RETURN(this, hrc, 9 /*unhandled exception*/,aPromiscModePolicy);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NetworkAdapter::setPromiscModePolicy", hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMGETTER(TraceEnabled)(BOOL *aTraceEnabled)
{
    LogRelFlow(("{%p} %s: enter aTraceEnabled=%p\n", this, "NetworkAdapter::getTraceEnabled", aTraceEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aTraceEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_TRACEENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getTraceEnabled(aTraceEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_TRACEENABLED_RETURN(this, hrc, 0 /*normal*/,*aTraceEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_TRACEENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aTraceEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_TRACEENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aTraceEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aTraceEnabled=%RTbool hrc=%Rhrc\n", this, "NetworkAdapter::getTraceEnabled", *aTraceEnabled, hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMSETTER(TraceEnabled)(BOOL aTraceEnabled)
{
    LogRelFlow(("{%p} %s: enter aTraceEnabled=%RTbool\n", this, "NetworkAdapter::setTraceEnabled", aTraceEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_TRACEENABLED_ENTER(this, aTraceEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setTraceEnabled(aTraceEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_TRACEENABLED_RETURN(this, hrc, 0 /*normal*/,aTraceEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_TRACEENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aTraceEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_TRACEENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aTraceEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NetworkAdapter::setTraceEnabled", hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMGETTER(TraceFile)(BSTR *aTraceFile)
{
    LogRelFlow(("{%p} %s: enter aTraceFile=%p\n", this, "NetworkAdapter::getTraceFile", aTraceFile));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aTraceFile);
        BSTROutConverter TmpTraceFile(aTraceFile);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_TRACEFILE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getTraceFile(TmpTraceFile.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_TRACEFILE_RETURN(this, hrc, 0 /*normal*/,TmpTraceFile.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_TRACEFILE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_TRACEFILE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aTraceFile=%ls hrc=%Rhrc\n", this, "NetworkAdapter::getTraceFile", *aTraceFile, hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMSETTER(TraceFile)(IN_BSTR aTraceFile)
{
    LogRelFlow(("{%p} %s: enter aTraceFile=%ls\n", this, "NetworkAdapter::setTraceFile", aTraceFile));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpTraceFile(aTraceFile);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_TRACEFILE_ENTER(this, TmpTraceFile.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setTraceFile(TmpTraceFile.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_TRACEFILE_RETURN(this, hrc, 0 /*normal*/,TmpTraceFile.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_TRACEFILE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_TRACEFILE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NetworkAdapter::setTraceFile", hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMGETTER(NATEngine)(INATEngine **aNATEngine)
{
    LogRelFlow(("{%p} %s: enter aNATEngine=%p\n", this, "NetworkAdapter::getNATEngine", aNATEngine));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNATEngine);
        ComTypeOutConverter<INATEngine> TmpNATEngine(aNATEngine);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_NATENGINE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getNATEngine(TmpNATEngine.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_NATENGINE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpNATEngine.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_NATENGINE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_NATENGINE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNATEngine=%p hrc=%Rhrc\n", this, "NetworkAdapter::getNATEngine", *aNATEngine, hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMGETTER(BootPriority)(ULONG *aBootPriority)
{
    LogRelFlow(("{%p} %s: enter aBootPriority=%p\n", this, "NetworkAdapter::getBootPriority", aBootPriority));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aBootPriority);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_BOOTPRIORITY_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getBootPriority(aBootPriority);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_BOOTPRIORITY_RETURN(this, hrc, 0 /*normal*/,*aBootPriority);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_BOOTPRIORITY_RETURN(this, hrc, 1 /*hrc exception*/,*aBootPriority);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_BOOTPRIORITY_RETURN(this, hrc, 9 /*unhandled exception*/,*aBootPriority);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aBootPriority=%RU32 hrc=%Rhrc\n", this, "NetworkAdapter::getBootPriority", *aBootPriority, hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMSETTER(BootPriority)(ULONG aBootPriority)
{
    LogRelFlow(("{%p} %s: enter aBootPriority=%RU32\n", this, "NetworkAdapter::setBootPriority", aBootPriority));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_BOOTPRIORITY_ENTER(this, aBootPriority);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setBootPriority(aBootPriority);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_BOOTPRIORITY_RETURN(this, hrc, 0 /*normal*/,aBootPriority);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_BOOTPRIORITY_RETURN(this, hrc, 1 /*hrc exception*/,aBootPriority);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_BOOTPRIORITY_RETURN(this, hrc, 9 /*unhandled exception*/,aBootPriority);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NetworkAdapter::setBootPriority", hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMGETTER(BandwidthGroup)(IBandwidthGroup **aBandwidthGroup)
{
    LogRelFlow(("{%p} %s: enter aBandwidthGroup=%p\n", this, "NetworkAdapter::getBandwidthGroup", aBandwidthGroup));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aBandwidthGroup);
        ComTypeOutConverter<IBandwidthGroup> TmpBandwidthGroup(aBandwidthGroup);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_BANDWIDTHGROUP_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getBandwidthGroup(TmpBandwidthGroup.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_BANDWIDTHGROUP_RETURN(this, hrc, 0 /*normal*/,(void *)TmpBandwidthGroup.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_BANDWIDTHGROUP_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GET_BANDWIDTHGROUP_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aBandwidthGroup=%p hrc=%Rhrc\n", this, "NetworkAdapter::getBandwidthGroup", *aBandwidthGroup, hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMSETTER(BandwidthGroup)(IBandwidthGroup *aBandwidthGroup)
{
    LogRelFlow(("{%p} %s: enter aBandwidthGroup=%p\n", this, "NetworkAdapter::setBandwidthGroup", aBandwidthGroup));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        ComTypeInConverter<IBandwidthGroup> TmpBandwidthGroup(aBandwidthGroup);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_BANDWIDTHGROUP_ENTER(this, (void *)TmpBandwidthGroup.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setBandwidthGroup(TmpBandwidthGroup.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_BANDWIDTHGROUP_RETURN(this, hrc, 0 /*normal*/,(void *)TmpBandwidthGroup.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_BANDWIDTHGROUP_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SET_BANDWIDTHGROUP_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NetworkAdapter::setBandwidthGroup", hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::COMGETTER(InternalAndReservedAttribute1INetworkAdapter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP NetworkAdapterWrap::COMGETTER(InternalAndReservedAttribute2INetworkAdapter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP NetworkAdapterWrap::COMGETTER(InternalAndReservedAttribute3INetworkAdapter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP NetworkAdapterWrap::COMGETTER(InternalAndReservedAttribute4INetworkAdapter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP NetworkAdapterWrap::COMGETTER(InternalAndReservedAttribute5INetworkAdapter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP NetworkAdapterWrap::COMGETTER(InternalAndReservedAttribute6INetworkAdapter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP NetworkAdapterWrap::COMGETTER(InternalAndReservedAttribute7INetworkAdapter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP NetworkAdapterWrap::COMGETTER(InternalAndReservedAttribute8INetworkAdapter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// INetworkAdapter methods
//

STDMETHODIMP NetworkAdapterWrap::GetProperty(IN_BSTR aKey,
                                             BSTR *aValue)
{
    LogRelFlow(("{%p} %s: enter aKey=%ls aValue=%p\n", this, "NetworkAdapter::getProperty", aKey, aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aValue);


        BSTRInConverter TmpKey(aKey);
        BSTROutConverter TmpValue(aValue);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GETPROPERTY_ENTER(this, TmpKey.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProperty(TmpKey.str(),
                              TmpValue.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GETPROPERTY_RETURN(this, hrc, 0 /*normal*/, TmpKey.str().c_str(), TmpValue.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GETPROPERTY_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GETPROPERTY_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aValue=%ls hrc=%Rhrc\n", this, "NetworkAdapter::getProperty", *aValue, hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::SetProperty(IN_BSTR aKey,
                                             IN_BSTR aValue)
{
    LogRelFlow(("{%p} %s: enter aKey=%ls aValue=%ls\n", this, "NetworkAdapter::setProperty", aKey, aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpKey(aKey);
        BSTRInConverter TmpValue(aValue);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SETPROPERTY_ENTER(this, TmpKey.str().c_str(), TmpValue.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setProperty(TmpKey.str(),
                              TmpValue.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SETPROPERTY_RETURN(this, hrc, 0 /*normal*/, TmpKey.str().c_str(), TmpValue.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SETPROPERTY_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_SETPROPERTY_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NetworkAdapter::setProperty", hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::GetProperties(IN_BSTR aNames,
                                               ComSafeArrayOut(BSTR, aReturnNames),
                                               ComSafeArrayOut(BSTR, aReturnValues))
{
    LogRelFlow(("{%p} %s: enter aNames=%ls aReturnNames=%p aReturnValues=%p\n", this, "NetworkAdapter::getProperties", aNames, aReturnNames, aReturnValues));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aReturnNames);
        CheckComArgOutPointerValidThrow(aReturnValues);


        BSTRInConverter TmpNames(aNames);
        ArrayBSTROutConverter TmpReturnNames(ComSafeArrayOutArg(aReturnNames));
        ArrayBSTROutConverter TmpReturnValues(ComSafeArrayOutArg(aReturnValues));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GETPROPERTIES_ENTER(this, TmpNames.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProperties(TmpNames.str(),
                                TmpReturnNames.array(),
                                TmpReturnValues.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GETPROPERTIES_RETURN(this, hrc, 0 /*normal*/, TmpNames.str().c_str(), (uint32_t)TmpReturnNames.array().size(), NULL /*for now*/, (uint32_t)TmpReturnValues.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GETPROPERTIES_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NETWORKADAPTER_GETPROPERTIES_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aReturnNames=%zu aReturnValues=%zu hrc=%Rhrc\n", this, "NetworkAdapter::getProperties", ComSafeArraySize(*aReturnNames), ComSafeArraySize(*aReturnValues), hrc));
    return hrc;
}

STDMETHODIMP NetworkAdapterWrap::InternalAndReservedMethod1INetworkAdapter()
{
    return E_NOTIMPL;
}

STDMETHODIMP NetworkAdapterWrap::InternalAndReservedMethod2INetworkAdapter()
{
    return E_NOTIMPL;
}

STDMETHODIMP NetworkAdapterWrap::InternalAndReservedMethod3INetworkAdapter()
{
    return E_NOTIMPL;
}

STDMETHODIMP NetworkAdapterWrap::InternalAndReservedMethod4INetworkAdapter()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(NetworkAdapterWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(NetworkAdapterWrap, INetworkAdapter)
#endif // VBOX_WITH_XPCOM
