// Code generated by Microsoft Kiota - DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package models

import (
    i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e "time"
    i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91 "github.com/microsoft/kiota-abstractions-go/serialization"
)

type Alert struct {
    Entity
}
// NewAlert instantiates a new Alert and sets the default values.
func NewAlert()(*Alert) {
    m := &Alert{
        Entity: *NewEntity(),
    }
    return m
}
// CreateAlertFromDiscriminatorValue creates a new instance of the appropriate class based on discriminator value
// returns a Parsable when successful
func CreateAlertFromDiscriminatorValue(parseNode i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, error) {
    return NewAlert(), nil
}
// GetActivityGroupName gets the activityGroupName property value. Name or alias of the activity group (attacker) this alert is attributed to.
// returns a *string when successful
func (m *Alert) GetActivityGroupName()(*string) {
    val, err := m.GetBackingStore().Get("activityGroupName")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*string)
    }
    return nil
}
// GetAlertDetections gets the alertDetections property value. The alertDetections property
// returns a []AlertDetectionable when successful
func (m *Alert) GetAlertDetections()([]AlertDetectionable) {
    val, err := m.GetBackingStore().Get("alertDetections")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]AlertDetectionable)
    }
    return nil
}
// GetAssignedTo gets the assignedTo property value. Name of the analyst the alert is assigned to for triage, investigation, or remediation (supports update).
// returns a *string when successful
func (m *Alert) GetAssignedTo()(*string) {
    val, err := m.GetBackingStore().Get("assignedTo")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*string)
    }
    return nil
}
// GetAzureSubscriptionId gets the azureSubscriptionId property value. Azure subscription ID, present if this alert is related to an Azure resource.
// returns a *string when successful
func (m *Alert) GetAzureSubscriptionId()(*string) {
    val, err := m.GetBackingStore().Get("azureSubscriptionId")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*string)
    }
    return nil
}
// GetAzureTenantId gets the azureTenantId property value. Microsoft Entra tenant ID. Required.
// returns a *string when successful
func (m *Alert) GetAzureTenantId()(*string) {
    val, err := m.GetBackingStore().Get("azureTenantId")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*string)
    }
    return nil
}
// GetCategory gets the category property value. Category of the alert (for example, credentialTheft, ransomware).
// returns a *string when successful
func (m *Alert) GetCategory()(*string) {
    val, err := m.GetBackingStore().Get("category")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*string)
    }
    return nil
}
// GetClosedDateTime gets the closedDateTime property value. Time at which the alert was closed. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z (supports update).
// returns a *Time when successful
func (m *Alert) GetClosedDateTime()(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time) {
    val, err := m.GetBackingStore().Get("closedDateTime")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)
    }
    return nil
}
// GetCloudAppStates gets the cloudAppStates property value. Security-related stateful information generated by the provider about the cloud application/s related to this alert.
// returns a []CloudAppSecurityStateable when successful
func (m *Alert) GetCloudAppStates()([]CloudAppSecurityStateable) {
    val, err := m.GetBackingStore().Get("cloudAppStates")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]CloudAppSecurityStateable)
    }
    return nil
}
// GetComments gets the comments property value. Customer-provided comments on alert (for customer alert management) (supports update).
// returns a []string when successful
func (m *Alert) GetComments()([]string) {
    val, err := m.GetBackingStore().Get("comments")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]string)
    }
    return nil
}
// GetConfidence gets the confidence property value. Confidence of the detection logic (percentage between 1-100).
// returns a *int32 when successful
func (m *Alert) GetConfidence()(*int32) {
    val, err := m.GetBackingStore().Get("confidence")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*int32)
    }
    return nil
}
// GetCreatedDateTime gets the createdDateTime property value. Time at which the alert was created by the alert provider. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z. Required.
// returns a *Time when successful
func (m *Alert) GetCreatedDateTime()(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time) {
    val, err := m.GetBackingStore().Get("createdDateTime")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)
    }
    return nil
}
// GetDescription gets the description property value. Alert description.
// returns a *string when successful
func (m *Alert) GetDescription()(*string) {
    val, err := m.GetBackingStore().Get("description")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*string)
    }
    return nil
}
// GetDetectionIds gets the detectionIds property value. Set of alerts related to this alert entity (each alert is pushed to the SIEM as a separate record).
// returns a []string when successful
func (m *Alert) GetDetectionIds()([]string) {
    val, err := m.GetBackingStore().Get("detectionIds")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]string)
    }
    return nil
}
// GetEventDateTime gets the eventDateTime property value. Time at which the event or events that served as the trigger to generate the alert occurred. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z. Required.
// returns a *Time when successful
func (m *Alert) GetEventDateTime()(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time) {
    val, err := m.GetBackingStore().Get("eventDateTime")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)
    }
    return nil
}
// GetFeedback gets the feedback property value. Analyst feedback on the alert. Possible values are: unknown, truePositive, falsePositive, benignPositive. Supports update.
// returns a *AlertFeedback when successful
func (m *Alert) GetFeedback()(*AlertFeedback) {
    val, err := m.GetBackingStore().Get("feedback")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*AlertFeedback)
    }
    return nil
}
// GetFieldDeserializers the deserialization information for the current model
// returns a map[string]func(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(error) when successful
func (m *Alert) GetFieldDeserializers()(map[string]func(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(error)) {
    res := m.Entity.GetFieldDeserializers()
    res["activityGroupName"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetStringValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetActivityGroupName(val)
        }
        return nil
    }
    res["alertDetections"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfObjectValues(CreateAlertDetectionFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]AlertDetectionable, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = v.(AlertDetectionable)
                }
            }
            m.SetAlertDetections(res)
        }
        return nil
    }
    res["assignedTo"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetStringValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetAssignedTo(val)
        }
        return nil
    }
    res["azureSubscriptionId"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetStringValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetAzureSubscriptionId(val)
        }
        return nil
    }
    res["azureTenantId"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetStringValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetAzureTenantId(val)
        }
        return nil
    }
    res["category"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetStringValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetCategory(val)
        }
        return nil
    }
    res["closedDateTime"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetTimeValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetClosedDateTime(val)
        }
        return nil
    }
    res["cloudAppStates"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfObjectValues(CreateCloudAppSecurityStateFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]CloudAppSecurityStateable, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = v.(CloudAppSecurityStateable)
                }
            }
            m.SetCloudAppStates(res)
        }
        return nil
    }
    res["comments"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfPrimitiveValues("string")
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]string, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = *(v.(*string))
                }
            }
            m.SetComments(res)
        }
        return nil
    }
    res["confidence"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetInt32Value()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetConfidence(val)
        }
        return nil
    }
    res["createdDateTime"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetTimeValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetCreatedDateTime(val)
        }
        return nil
    }
    res["description"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetStringValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetDescription(val)
        }
        return nil
    }
    res["detectionIds"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfPrimitiveValues("string")
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]string, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = *(v.(*string))
                }
            }
            m.SetDetectionIds(res)
        }
        return nil
    }
    res["eventDateTime"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetTimeValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetEventDateTime(val)
        }
        return nil
    }
    res["feedback"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetEnumValue(ParseAlertFeedback)
        if err != nil {
            return err
        }
        if val != nil {
            m.SetFeedback(val.(*AlertFeedback))
        }
        return nil
    }
    res["fileStates"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfObjectValues(CreateFileSecurityStateFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]FileSecurityStateable, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = v.(FileSecurityStateable)
                }
            }
            m.SetFileStates(res)
        }
        return nil
    }
    res["historyStates"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfObjectValues(CreateAlertHistoryStateFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]AlertHistoryStateable, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = v.(AlertHistoryStateable)
                }
            }
            m.SetHistoryStates(res)
        }
        return nil
    }
    res["hostStates"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfObjectValues(CreateHostSecurityStateFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]HostSecurityStateable, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = v.(HostSecurityStateable)
                }
            }
            m.SetHostStates(res)
        }
        return nil
    }
    res["incidentIds"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfPrimitiveValues("string")
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]string, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = *(v.(*string))
                }
            }
            m.SetIncidentIds(res)
        }
        return nil
    }
    res["investigationSecurityStates"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfObjectValues(CreateInvestigationSecurityStateFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]InvestigationSecurityStateable, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = v.(InvestigationSecurityStateable)
                }
            }
            m.SetInvestigationSecurityStates(res)
        }
        return nil
    }
    res["lastEventDateTime"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetTimeValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetLastEventDateTime(val)
        }
        return nil
    }
    res["lastModifiedDateTime"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetTimeValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetLastModifiedDateTime(val)
        }
        return nil
    }
    res["malwareStates"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfObjectValues(CreateMalwareStateFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]MalwareStateable, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = v.(MalwareStateable)
                }
            }
            m.SetMalwareStates(res)
        }
        return nil
    }
    res["messageSecurityStates"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfObjectValues(CreateMessageSecurityStateFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]MessageSecurityStateable, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = v.(MessageSecurityStateable)
                }
            }
            m.SetMessageSecurityStates(res)
        }
        return nil
    }
    res["networkConnections"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfObjectValues(CreateNetworkConnectionFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]NetworkConnectionable, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = v.(NetworkConnectionable)
                }
            }
            m.SetNetworkConnections(res)
        }
        return nil
    }
    res["processes"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfObjectValues(CreateProcessFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]Processable, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = v.(Processable)
                }
            }
            m.SetProcesses(res)
        }
        return nil
    }
    res["recommendedActions"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfPrimitiveValues("string")
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]string, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = *(v.(*string))
                }
            }
            m.SetRecommendedActions(res)
        }
        return nil
    }
    res["registryKeyStates"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfObjectValues(CreateRegistryKeyStateFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]RegistryKeyStateable, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = v.(RegistryKeyStateable)
                }
            }
            m.SetRegistryKeyStates(res)
        }
        return nil
    }
    res["securityResources"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfObjectValues(CreateSecurityResourceFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]SecurityResourceable, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = v.(SecurityResourceable)
                }
            }
            m.SetSecurityResources(res)
        }
        return nil
    }
    res["severity"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetEnumValue(ParseAlertSeverity)
        if err != nil {
            return err
        }
        if val != nil {
            m.SetSeverity(val.(*AlertSeverity))
        }
        return nil
    }
    res["sourceMaterials"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfPrimitiveValues("string")
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]string, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = *(v.(*string))
                }
            }
            m.SetSourceMaterials(res)
        }
        return nil
    }
    res["status"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetEnumValue(ParseAlertStatus)
        if err != nil {
            return err
        }
        if val != nil {
            m.SetStatus(val.(*AlertStatus))
        }
        return nil
    }
    res["tags"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfPrimitiveValues("string")
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]string, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = *(v.(*string))
                }
            }
            m.SetTags(res)
        }
        return nil
    }
    res["title"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetStringValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetTitle(val)
        }
        return nil
    }
    res["triggers"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfObjectValues(CreateAlertTriggerFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]AlertTriggerable, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = v.(AlertTriggerable)
                }
            }
            m.SetTriggers(res)
        }
        return nil
    }
    res["uriClickSecurityStates"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfObjectValues(CreateUriClickSecurityStateFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]UriClickSecurityStateable, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = v.(UriClickSecurityStateable)
                }
            }
            m.SetUriClickSecurityStates(res)
        }
        return nil
    }
    res["userStates"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfObjectValues(CreateUserSecurityStateFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]UserSecurityStateable, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = v.(UserSecurityStateable)
                }
            }
            m.SetUserStates(res)
        }
        return nil
    }
    res["vendorInformation"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetObjectValue(CreateSecurityVendorInformationFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            m.SetVendorInformation(val.(SecurityVendorInformationable))
        }
        return nil
    }
    res["vulnerabilityStates"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfObjectValues(CreateVulnerabilityStateFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]VulnerabilityStateable, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = v.(VulnerabilityStateable)
                }
            }
            m.SetVulnerabilityStates(res)
        }
        return nil
    }
    return res
}
// GetFileStates gets the fileStates property value. Security-related stateful information generated by the provider about the file(s) related to this alert.
// returns a []FileSecurityStateable when successful
func (m *Alert) GetFileStates()([]FileSecurityStateable) {
    val, err := m.GetBackingStore().Get("fileStates")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]FileSecurityStateable)
    }
    return nil
}
// GetHistoryStates gets the historyStates property value. The historyStates property
// returns a []AlertHistoryStateable when successful
func (m *Alert) GetHistoryStates()([]AlertHistoryStateable) {
    val, err := m.GetBackingStore().Get("historyStates")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]AlertHistoryStateable)
    }
    return nil
}
// GetHostStates gets the hostStates property value. Security-related stateful information generated by the provider about the host(s) related to this alert.
// returns a []HostSecurityStateable when successful
func (m *Alert) GetHostStates()([]HostSecurityStateable) {
    val, err := m.GetBackingStore().Get("hostStates")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]HostSecurityStateable)
    }
    return nil
}
// GetIncidentIds gets the incidentIds property value. IDs of incidents related to current alert.
// returns a []string when successful
func (m *Alert) GetIncidentIds()([]string) {
    val, err := m.GetBackingStore().Get("incidentIds")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]string)
    }
    return nil
}
// GetInvestigationSecurityStates gets the investigationSecurityStates property value. The investigationSecurityStates property
// returns a []InvestigationSecurityStateable when successful
func (m *Alert) GetInvestigationSecurityStates()([]InvestigationSecurityStateable) {
    val, err := m.GetBackingStore().Get("investigationSecurityStates")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]InvestigationSecurityStateable)
    }
    return nil
}
// GetLastEventDateTime gets the lastEventDateTime property value. The lastEventDateTime property
// returns a *Time when successful
func (m *Alert) GetLastEventDateTime()(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time) {
    val, err := m.GetBackingStore().Get("lastEventDateTime")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)
    }
    return nil
}
// GetLastModifiedDateTime gets the lastModifiedDateTime property value. Time at which the alert entity was last modified. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
// returns a *Time when successful
func (m *Alert) GetLastModifiedDateTime()(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time) {
    val, err := m.GetBackingStore().Get("lastModifiedDateTime")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)
    }
    return nil
}
// GetMalwareStates gets the malwareStates property value. Threat Intelligence pertaining to malware related to this alert.
// returns a []MalwareStateable when successful
func (m *Alert) GetMalwareStates()([]MalwareStateable) {
    val, err := m.GetBackingStore().Get("malwareStates")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]MalwareStateable)
    }
    return nil
}
// GetMessageSecurityStates gets the messageSecurityStates property value. The messageSecurityStates property
// returns a []MessageSecurityStateable when successful
func (m *Alert) GetMessageSecurityStates()([]MessageSecurityStateable) {
    val, err := m.GetBackingStore().Get("messageSecurityStates")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]MessageSecurityStateable)
    }
    return nil
}
// GetNetworkConnections gets the networkConnections property value. Security-related stateful information generated by the provider about the network connection(s) related to this alert.
// returns a []NetworkConnectionable when successful
func (m *Alert) GetNetworkConnections()([]NetworkConnectionable) {
    val, err := m.GetBackingStore().Get("networkConnections")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]NetworkConnectionable)
    }
    return nil
}
// GetProcesses gets the processes property value. Security-related stateful information generated by the provider about the process or processes related to this alert.
// returns a []Processable when successful
func (m *Alert) GetProcesses()([]Processable) {
    val, err := m.GetBackingStore().Get("processes")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]Processable)
    }
    return nil
}
// GetRecommendedActions gets the recommendedActions property value. Vendor/provider recommended action(s) to take as a result of the alert (for example, isolate machine, enforce2FA, reimage host).
// returns a []string when successful
func (m *Alert) GetRecommendedActions()([]string) {
    val, err := m.GetBackingStore().Get("recommendedActions")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]string)
    }
    return nil
}
// GetRegistryKeyStates gets the registryKeyStates property value. Security-related stateful information generated by the provider about the registry keys related to this alert.
// returns a []RegistryKeyStateable when successful
func (m *Alert) GetRegistryKeyStates()([]RegistryKeyStateable) {
    val, err := m.GetBackingStore().Get("registryKeyStates")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]RegistryKeyStateable)
    }
    return nil
}
// GetSecurityResources gets the securityResources property value. Resources related to current alert. For example, for some alerts this can have the Azure Resource value.
// returns a []SecurityResourceable when successful
func (m *Alert) GetSecurityResources()([]SecurityResourceable) {
    val, err := m.GetBackingStore().Get("securityResources")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]SecurityResourceable)
    }
    return nil
}
// GetSeverity gets the severity property value. The severity property
// returns a *AlertSeverity when successful
func (m *Alert) GetSeverity()(*AlertSeverity) {
    val, err := m.GetBackingStore().Get("severity")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*AlertSeverity)
    }
    return nil
}
// GetSourceMaterials gets the sourceMaterials property value. Hyperlinks (URIs) to the source material related to the alert, for example, provider's user interface for alerts or log search.
// returns a []string when successful
func (m *Alert) GetSourceMaterials()([]string) {
    val, err := m.GetBackingStore().Get("sourceMaterials")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]string)
    }
    return nil
}
// GetStatus gets the status property value. The status property
// returns a *AlertStatus when successful
func (m *Alert) GetStatus()(*AlertStatus) {
    val, err := m.GetBackingStore().Get("status")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*AlertStatus)
    }
    return nil
}
// GetTags gets the tags property value. User-definable labels that can be applied to an alert and can serve as filter conditions (for example 'HVA', 'SAW') (supports update).
// returns a []string when successful
func (m *Alert) GetTags()([]string) {
    val, err := m.GetBackingStore().Get("tags")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]string)
    }
    return nil
}
// GetTitle gets the title property value. Alert title. Required.
// returns a *string when successful
func (m *Alert) GetTitle()(*string) {
    val, err := m.GetBackingStore().Get("title")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*string)
    }
    return nil
}
// GetTriggers gets the triggers property value. Security-related information about the specific properties that triggered the alert (properties appearing in the alert). Alerts might contain information about multiple users, hosts, files, ip addresses. This field indicates which properties triggered the alert generation.
// returns a []AlertTriggerable when successful
func (m *Alert) GetTriggers()([]AlertTriggerable) {
    val, err := m.GetBackingStore().Get("triggers")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]AlertTriggerable)
    }
    return nil
}
// GetUriClickSecurityStates gets the uriClickSecurityStates property value. The uriClickSecurityStates property
// returns a []UriClickSecurityStateable when successful
func (m *Alert) GetUriClickSecurityStates()([]UriClickSecurityStateable) {
    val, err := m.GetBackingStore().Get("uriClickSecurityStates")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]UriClickSecurityStateable)
    }
    return nil
}
// GetUserStates gets the userStates property value. Security-related stateful information generated by the provider about the user accounts related to this alert.
// returns a []UserSecurityStateable when successful
func (m *Alert) GetUserStates()([]UserSecurityStateable) {
    val, err := m.GetBackingStore().Get("userStates")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]UserSecurityStateable)
    }
    return nil
}
// GetVendorInformation gets the vendorInformation property value. Complex type containing details about the security product/service vendor, provider, and subprovider (for example, vendor=Microsoft; provider=Windows Defender ATP; subProvider=AppLocker). Required.
// returns a SecurityVendorInformationable when successful
func (m *Alert) GetVendorInformation()(SecurityVendorInformationable) {
    val, err := m.GetBackingStore().Get("vendorInformation")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(SecurityVendorInformationable)
    }
    return nil
}
// GetVulnerabilityStates gets the vulnerabilityStates property value. Threat intelligence pertaining to one or more vulnerabilities related to this alert.
// returns a []VulnerabilityStateable when successful
func (m *Alert) GetVulnerabilityStates()([]VulnerabilityStateable) {
    val, err := m.GetBackingStore().Get("vulnerabilityStates")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]VulnerabilityStateable)
    }
    return nil
}
// Serialize serializes information the current object
func (m *Alert) Serialize(writer i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.SerializationWriter)(error) {
    err := m.Entity.Serialize(writer)
    if err != nil {
        return err
    }
    {
        err = writer.WriteStringValue("activityGroupName", m.GetActivityGroupName())
        if err != nil {
            return err
        }
    }
    if m.GetAlertDetections() != nil {
        cast := make([]i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, len(m.GetAlertDetections()))
        for i, v := range m.GetAlertDetections() {
            if v != nil {
                cast[i] = v.(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable)
            }
        }
        err = writer.WriteCollectionOfObjectValues("alertDetections", cast)
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteStringValue("assignedTo", m.GetAssignedTo())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteStringValue("azureSubscriptionId", m.GetAzureSubscriptionId())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteStringValue("azureTenantId", m.GetAzureTenantId())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteStringValue("category", m.GetCategory())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteTimeValue("closedDateTime", m.GetClosedDateTime())
        if err != nil {
            return err
        }
    }
    if m.GetCloudAppStates() != nil {
        cast := make([]i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, len(m.GetCloudAppStates()))
        for i, v := range m.GetCloudAppStates() {
            if v != nil {
                cast[i] = v.(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable)
            }
        }
        err = writer.WriteCollectionOfObjectValues("cloudAppStates", cast)
        if err != nil {
            return err
        }
    }
    if m.GetComments() != nil {
        err = writer.WriteCollectionOfStringValues("comments", m.GetComments())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteInt32Value("confidence", m.GetConfidence())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteTimeValue("createdDateTime", m.GetCreatedDateTime())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteStringValue("description", m.GetDescription())
        if err != nil {
            return err
        }
    }
    if m.GetDetectionIds() != nil {
        err = writer.WriteCollectionOfStringValues("detectionIds", m.GetDetectionIds())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteTimeValue("eventDateTime", m.GetEventDateTime())
        if err != nil {
            return err
        }
    }
    if m.GetFeedback() != nil {
        cast := (*m.GetFeedback()).String()
        err = writer.WriteStringValue("feedback", &cast)
        if err != nil {
            return err
        }
    }
    if m.GetFileStates() != nil {
        cast := make([]i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, len(m.GetFileStates()))
        for i, v := range m.GetFileStates() {
            if v != nil {
                cast[i] = v.(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable)
            }
        }
        err = writer.WriteCollectionOfObjectValues("fileStates", cast)
        if err != nil {
            return err
        }
    }
    if m.GetHistoryStates() != nil {
        cast := make([]i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, len(m.GetHistoryStates()))
        for i, v := range m.GetHistoryStates() {
            if v != nil {
                cast[i] = v.(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable)
            }
        }
        err = writer.WriteCollectionOfObjectValues("historyStates", cast)
        if err != nil {
            return err
        }
    }
    if m.GetHostStates() != nil {
        cast := make([]i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, len(m.GetHostStates()))
        for i, v := range m.GetHostStates() {
            if v != nil {
                cast[i] = v.(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable)
            }
        }
        err = writer.WriteCollectionOfObjectValues("hostStates", cast)
        if err != nil {
            return err
        }
    }
    if m.GetIncidentIds() != nil {
        err = writer.WriteCollectionOfStringValues("incidentIds", m.GetIncidentIds())
        if err != nil {
            return err
        }
    }
    if m.GetInvestigationSecurityStates() != nil {
        cast := make([]i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, len(m.GetInvestigationSecurityStates()))
        for i, v := range m.GetInvestigationSecurityStates() {
            if v != nil {
                cast[i] = v.(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable)
            }
        }
        err = writer.WriteCollectionOfObjectValues("investigationSecurityStates", cast)
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteTimeValue("lastEventDateTime", m.GetLastEventDateTime())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteTimeValue("lastModifiedDateTime", m.GetLastModifiedDateTime())
        if err != nil {
            return err
        }
    }
    if m.GetMalwareStates() != nil {
        cast := make([]i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, len(m.GetMalwareStates()))
        for i, v := range m.GetMalwareStates() {
            if v != nil {
                cast[i] = v.(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable)
            }
        }
        err = writer.WriteCollectionOfObjectValues("malwareStates", cast)
        if err != nil {
            return err
        }
    }
    if m.GetMessageSecurityStates() != nil {
        cast := make([]i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, len(m.GetMessageSecurityStates()))
        for i, v := range m.GetMessageSecurityStates() {
            if v != nil {
                cast[i] = v.(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable)
            }
        }
        err = writer.WriteCollectionOfObjectValues("messageSecurityStates", cast)
        if err != nil {
            return err
        }
    }
    if m.GetNetworkConnections() != nil {
        cast := make([]i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, len(m.GetNetworkConnections()))
        for i, v := range m.GetNetworkConnections() {
            if v != nil {
                cast[i] = v.(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable)
            }
        }
        err = writer.WriteCollectionOfObjectValues("networkConnections", cast)
        if err != nil {
            return err
        }
    }
    if m.GetProcesses() != nil {
        cast := make([]i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, len(m.GetProcesses()))
        for i, v := range m.GetProcesses() {
            if v != nil {
                cast[i] = v.(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable)
            }
        }
        err = writer.WriteCollectionOfObjectValues("processes", cast)
        if err != nil {
            return err
        }
    }
    if m.GetRecommendedActions() != nil {
        err = writer.WriteCollectionOfStringValues("recommendedActions", m.GetRecommendedActions())
        if err != nil {
            return err
        }
    }
    if m.GetRegistryKeyStates() != nil {
        cast := make([]i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, len(m.GetRegistryKeyStates()))
        for i, v := range m.GetRegistryKeyStates() {
            if v != nil {
                cast[i] = v.(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable)
            }
        }
        err = writer.WriteCollectionOfObjectValues("registryKeyStates", cast)
        if err != nil {
            return err
        }
    }
    if m.GetSecurityResources() != nil {
        cast := make([]i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, len(m.GetSecurityResources()))
        for i, v := range m.GetSecurityResources() {
            if v != nil {
                cast[i] = v.(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable)
            }
        }
        err = writer.WriteCollectionOfObjectValues("securityResources", cast)
        if err != nil {
            return err
        }
    }
    if m.GetSeverity() != nil {
        cast := (*m.GetSeverity()).String()
        err = writer.WriteStringValue("severity", &cast)
        if err != nil {
            return err
        }
    }
    if m.GetSourceMaterials() != nil {
        err = writer.WriteCollectionOfStringValues("sourceMaterials", m.GetSourceMaterials())
        if err != nil {
            return err
        }
    }
    if m.GetStatus() != nil {
        cast := (*m.GetStatus()).String()
        err = writer.WriteStringValue("status", &cast)
        if err != nil {
            return err
        }
    }
    if m.GetTags() != nil {
        err = writer.WriteCollectionOfStringValues("tags", m.GetTags())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteStringValue("title", m.GetTitle())
        if err != nil {
            return err
        }
    }
    if m.GetTriggers() != nil {
        cast := make([]i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, len(m.GetTriggers()))
        for i, v := range m.GetTriggers() {
            if v != nil {
                cast[i] = v.(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable)
            }
        }
        err = writer.WriteCollectionOfObjectValues("triggers", cast)
        if err != nil {
            return err
        }
    }
    if m.GetUriClickSecurityStates() != nil {
        cast := make([]i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, len(m.GetUriClickSecurityStates()))
        for i, v := range m.GetUriClickSecurityStates() {
            if v != nil {
                cast[i] = v.(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable)
            }
        }
        err = writer.WriteCollectionOfObjectValues("uriClickSecurityStates", cast)
        if err != nil {
            return err
        }
    }
    if m.GetUserStates() != nil {
        cast := make([]i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, len(m.GetUserStates()))
        for i, v := range m.GetUserStates() {
            if v != nil {
                cast[i] = v.(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable)
            }
        }
        err = writer.WriteCollectionOfObjectValues("userStates", cast)
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteObjectValue("vendorInformation", m.GetVendorInformation())
        if err != nil {
            return err
        }
    }
    if m.GetVulnerabilityStates() != nil {
        cast := make([]i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, len(m.GetVulnerabilityStates()))
        for i, v := range m.GetVulnerabilityStates() {
            if v != nil {
                cast[i] = v.(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable)
            }
        }
        err = writer.WriteCollectionOfObjectValues("vulnerabilityStates", cast)
        if err != nil {
            return err
        }
    }
    return nil
}
// SetActivityGroupName sets the activityGroupName property value. Name or alias of the activity group (attacker) this alert is attributed to.
func (m *Alert) SetActivityGroupName(value *string)() {
    err := m.GetBackingStore().Set("activityGroupName", value)
    if err != nil {
        panic(err)
    }
}
// SetAlertDetections sets the alertDetections property value. The alertDetections property
func (m *Alert) SetAlertDetections(value []AlertDetectionable)() {
    err := m.GetBackingStore().Set("alertDetections", value)
    if err != nil {
        panic(err)
    }
}
// SetAssignedTo sets the assignedTo property value. Name of the analyst the alert is assigned to for triage, investigation, or remediation (supports update).
func (m *Alert) SetAssignedTo(value *string)() {
    err := m.GetBackingStore().Set("assignedTo", value)
    if err != nil {
        panic(err)
    }
}
// SetAzureSubscriptionId sets the azureSubscriptionId property value. Azure subscription ID, present if this alert is related to an Azure resource.
func (m *Alert) SetAzureSubscriptionId(value *string)() {
    err := m.GetBackingStore().Set("azureSubscriptionId", value)
    if err != nil {
        panic(err)
    }
}
// SetAzureTenantId sets the azureTenantId property value. Microsoft Entra tenant ID. Required.
func (m *Alert) SetAzureTenantId(value *string)() {
    err := m.GetBackingStore().Set("azureTenantId", value)
    if err != nil {
        panic(err)
    }
}
// SetCategory sets the category property value. Category of the alert (for example, credentialTheft, ransomware).
func (m *Alert) SetCategory(value *string)() {
    err := m.GetBackingStore().Set("category", value)
    if err != nil {
        panic(err)
    }
}
// SetClosedDateTime sets the closedDateTime property value. Time at which the alert was closed. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z (supports update).
func (m *Alert) SetClosedDateTime(value *i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)() {
    err := m.GetBackingStore().Set("closedDateTime", value)
    if err != nil {
        panic(err)
    }
}
// SetCloudAppStates sets the cloudAppStates property value. Security-related stateful information generated by the provider about the cloud application/s related to this alert.
func (m *Alert) SetCloudAppStates(value []CloudAppSecurityStateable)() {
    err := m.GetBackingStore().Set("cloudAppStates", value)
    if err != nil {
        panic(err)
    }
}
// SetComments sets the comments property value. Customer-provided comments on alert (for customer alert management) (supports update).
func (m *Alert) SetComments(value []string)() {
    err := m.GetBackingStore().Set("comments", value)
    if err != nil {
        panic(err)
    }
}
// SetConfidence sets the confidence property value. Confidence of the detection logic (percentage between 1-100).
func (m *Alert) SetConfidence(value *int32)() {
    err := m.GetBackingStore().Set("confidence", value)
    if err != nil {
        panic(err)
    }
}
// SetCreatedDateTime sets the createdDateTime property value. Time at which the alert was created by the alert provider. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z. Required.
func (m *Alert) SetCreatedDateTime(value *i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)() {
    err := m.GetBackingStore().Set("createdDateTime", value)
    if err != nil {
        panic(err)
    }
}
// SetDescription sets the description property value. Alert description.
func (m *Alert) SetDescription(value *string)() {
    err := m.GetBackingStore().Set("description", value)
    if err != nil {
        panic(err)
    }
}
// SetDetectionIds sets the detectionIds property value. Set of alerts related to this alert entity (each alert is pushed to the SIEM as a separate record).
func (m *Alert) SetDetectionIds(value []string)() {
    err := m.GetBackingStore().Set("detectionIds", value)
    if err != nil {
        panic(err)
    }
}
// SetEventDateTime sets the eventDateTime property value. Time at which the event or events that served as the trigger to generate the alert occurred. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z. Required.
func (m *Alert) SetEventDateTime(value *i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)() {
    err := m.GetBackingStore().Set("eventDateTime", value)
    if err != nil {
        panic(err)
    }
}
// SetFeedback sets the feedback property value. Analyst feedback on the alert. Possible values are: unknown, truePositive, falsePositive, benignPositive. Supports update.
func (m *Alert) SetFeedback(value *AlertFeedback)() {
    err := m.GetBackingStore().Set("feedback", value)
    if err != nil {
        panic(err)
    }
}
// SetFileStates sets the fileStates property value. Security-related stateful information generated by the provider about the file(s) related to this alert.
func (m *Alert) SetFileStates(value []FileSecurityStateable)() {
    err := m.GetBackingStore().Set("fileStates", value)
    if err != nil {
        panic(err)
    }
}
// SetHistoryStates sets the historyStates property value. The historyStates property
func (m *Alert) SetHistoryStates(value []AlertHistoryStateable)() {
    err := m.GetBackingStore().Set("historyStates", value)
    if err != nil {
        panic(err)
    }
}
// SetHostStates sets the hostStates property value. Security-related stateful information generated by the provider about the host(s) related to this alert.
func (m *Alert) SetHostStates(value []HostSecurityStateable)() {
    err := m.GetBackingStore().Set("hostStates", value)
    if err != nil {
        panic(err)
    }
}
// SetIncidentIds sets the incidentIds property value. IDs of incidents related to current alert.
func (m *Alert) SetIncidentIds(value []string)() {
    err := m.GetBackingStore().Set("incidentIds", value)
    if err != nil {
        panic(err)
    }
}
// SetInvestigationSecurityStates sets the investigationSecurityStates property value. The investigationSecurityStates property
func (m *Alert) SetInvestigationSecurityStates(value []InvestigationSecurityStateable)() {
    err := m.GetBackingStore().Set("investigationSecurityStates", value)
    if err != nil {
        panic(err)
    }
}
// SetLastEventDateTime sets the lastEventDateTime property value. The lastEventDateTime property
func (m *Alert) SetLastEventDateTime(value *i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)() {
    err := m.GetBackingStore().Set("lastEventDateTime", value)
    if err != nil {
        panic(err)
    }
}
// SetLastModifiedDateTime sets the lastModifiedDateTime property value. Time at which the alert entity was last modified. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
func (m *Alert) SetLastModifiedDateTime(value *i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)() {
    err := m.GetBackingStore().Set("lastModifiedDateTime", value)
    if err != nil {
        panic(err)
    }
}
// SetMalwareStates sets the malwareStates property value. Threat Intelligence pertaining to malware related to this alert.
func (m *Alert) SetMalwareStates(value []MalwareStateable)() {
    err := m.GetBackingStore().Set("malwareStates", value)
    if err != nil {
        panic(err)
    }
}
// SetMessageSecurityStates sets the messageSecurityStates property value. The messageSecurityStates property
func (m *Alert) SetMessageSecurityStates(value []MessageSecurityStateable)() {
    err := m.GetBackingStore().Set("messageSecurityStates", value)
    if err != nil {
        panic(err)
    }
}
// SetNetworkConnections sets the networkConnections property value. Security-related stateful information generated by the provider about the network connection(s) related to this alert.
func (m *Alert) SetNetworkConnections(value []NetworkConnectionable)() {
    err := m.GetBackingStore().Set("networkConnections", value)
    if err != nil {
        panic(err)
    }
}
// SetProcesses sets the processes property value. Security-related stateful information generated by the provider about the process or processes related to this alert.
func (m *Alert) SetProcesses(value []Processable)() {
    err := m.GetBackingStore().Set("processes", value)
    if err != nil {
        panic(err)
    }
}
// SetRecommendedActions sets the recommendedActions property value. Vendor/provider recommended action(s) to take as a result of the alert (for example, isolate machine, enforce2FA, reimage host).
func (m *Alert) SetRecommendedActions(value []string)() {
    err := m.GetBackingStore().Set("recommendedActions", value)
    if err != nil {
        panic(err)
    }
}
// SetRegistryKeyStates sets the registryKeyStates property value. Security-related stateful information generated by the provider about the registry keys related to this alert.
func (m *Alert) SetRegistryKeyStates(value []RegistryKeyStateable)() {
    err := m.GetBackingStore().Set("registryKeyStates", value)
    if err != nil {
        panic(err)
    }
}
// SetSecurityResources sets the securityResources property value. Resources related to current alert. For example, for some alerts this can have the Azure Resource value.
func (m *Alert) SetSecurityResources(value []SecurityResourceable)() {
    err := m.GetBackingStore().Set("securityResources", value)
    if err != nil {
        panic(err)
    }
}
// SetSeverity sets the severity property value. The severity property
func (m *Alert) SetSeverity(value *AlertSeverity)() {
    err := m.GetBackingStore().Set("severity", value)
    if err != nil {
        panic(err)
    }
}
// SetSourceMaterials sets the sourceMaterials property value. Hyperlinks (URIs) to the source material related to the alert, for example, provider's user interface for alerts or log search.
func (m *Alert) SetSourceMaterials(value []string)() {
    err := m.GetBackingStore().Set("sourceMaterials", value)
    if err != nil {
        panic(err)
    }
}
// SetStatus sets the status property value. The status property
func (m *Alert) SetStatus(value *AlertStatus)() {
    err := m.GetBackingStore().Set("status", value)
    if err != nil {
        panic(err)
    }
}
// SetTags sets the tags property value. User-definable labels that can be applied to an alert and can serve as filter conditions (for example 'HVA', 'SAW') (supports update).
func (m *Alert) SetTags(value []string)() {
    err := m.GetBackingStore().Set("tags", value)
    if err != nil {
        panic(err)
    }
}
// SetTitle sets the title property value. Alert title. Required.
func (m *Alert) SetTitle(value *string)() {
    err := m.GetBackingStore().Set("title", value)
    if err != nil {
        panic(err)
    }
}
// SetTriggers sets the triggers property value. Security-related information about the specific properties that triggered the alert (properties appearing in the alert). Alerts might contain information about multiple users, hosts, files, ip addresses. This field indicates which properties triggered the alert generation.
func (m *Alert) SetTriggers(value []AlertTriggerable)() {
    err := m.GetBackingStore().Set("triggers", value)
    if err != nil {
        panic(err)
    }
}
// SetUriClickSecurityStates sets the uriClickSecurityStates property value. The uriClickSecurityStates property
func (m *Alert) SetUriClickSecurityStates(value []UriClickSecurityStateable)() {
    err := m.GetBackingStore().Set("uriClickSecurityStates", value)
    if err != nil {
        panic(err)
    }
}
// SetUserStates sets the userStates property value. Security-related stateful information generated by the provider about the user accounts related to this alert.
func (m *Alert) SetUserStates(value []UserSecurityStateable)() {
    err := m.GetBackingStore().Set("userStates", value)
    if err != nil {
        panic(err)
    }
}
// SetVendorInformation sets the vendorInformation property value. Complex type containing details about the security product/service vendor, provider, and subprovider (for example, vendor=Microsoft; provider=Windows Defender ATP; subProvider=AppLocker). Required.
func (m *Alert) SetVendorInformation(value SecurityVendorInformationable)() {
    err := m.GetBackingStore().Set("vendorInformation", value)
    if err != nil {
        panic(err)
    }
}
// SetVulnerabilityStates sets the vulnerabilityStates property value. Threat intelligence pertaining to one or more vulnerabilities related to this alert.
func (m *Alert) SetVulnerabilityStates(value []VulnerabilityStateable)() {
    err := m.GetBackingStore().Set("vulnerabilityStates", value)
    if err != nil {
        panic(err)
    }
}
type Alertable interface {
    Entityable
    i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable
    GetActivityGroupName()(*string)
    GetAlertDetections()([]AlertDetectionable)
    GetAssignedTo()(*string)
    GetAzureSubscriptionId()(*string)
    GetAzureTenantId()(*string)
    GetCategory()(*string)
    GetClosedDateTime()(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)
    GetCloudAppStates()([]CloudAppSecurityStateable)
    GetComments()([]string)
    GetConfidence()(*int32)
    GetCreatedDateTime()(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)
    GetDescription()(*string)
    GetDetectionIds()([]string)
    GetEventDateTime()(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)
    GetFeedback()(*AlertFeedback)
    GetFileStates()([]FileSecurityStateable)
    GetHistoryStates()([]AlertHistoryStateable)
    GetHostStates()([]HostSecurityStateable)
    GetIncidentIds()([]string)
    GetInvestigationSecurityStates()([]InvestigationSecurityStateable)
    GetLastEventDateTime()(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)
    GetLastModifiedDateTime()(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)
    GetMalwareStates()([]MalwareStateable)
    GetMessageSecurityStates()([]MessageSecurityStateable)
    GetNetworkConnections()([]NetworkConnectionable)
    GetProcesses()([]Processable)
    GetRecommendedActions()([]string)
    GetRegistryKeyStates()([]RegistryKeyStateable)
    GetSecurityResources()([]SecurityResourceable)
    GetSeverity()(*AlertSeverity)
    GetSourceMaterials()([]string)
    GetStatus()(*AlertStatus)
    GetTags()([]string)
    GetTitle()(*string)
    GetTriggers()([]AlertTriggerable)
    GetUriClickSecurityStates()([]UriClickSecurityStateable)
    GetUserStates()([]UserSecurityStateable)
    GetVendorInformation()(SecurityVendorInformationable)
    GetVulnerabilityStates()([]VulnerabilityStateable)
    SetActivityGroupName(value *string)()
    SetAlertDetections(value []AlertDetectionable)()
    SetAssignedTo(value *string)()
    SetAzureSubscriptionId(value *string)()
    SetAzureTenantId(value *string)()
    SetCategory(value *string)()
    SetClosedDateTime(value *i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)()
    SetCloudAppStates(value []CloudAppSecurityStateable)()
    SetComments(value []string)()
    SetConfidence(value *int32)()
    SetCreatedDateTime(value *i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)()
    SetDescription(value *string)()
    SetDetectionIds(value []string)()
    SetEventDateTime(value *i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)()
    SetFeedback(value *AlertFeedback)()
    SetFileStates(value []FileSecurityStateable)()
    SetHistoryStates(value []AlertHistoryStateable)()
    SetHostStates(value []HostSecurityStateable)()
    SetIncidentIds(value []string)()
    SetInvestigationSecurityStates(value []InvestigationSecurityStateable)()
    SetLastEventDateTime(value *i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)()
    SetLastModifiedDateTime(value *i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)()
    SetMalwareStates(value []MalwareStateable)()
    SetMessageSecurityStates(value []MessageSecurityStateable)()
    SetNetworkConnections(value []NetworkConnectionable)()
    SetProcesses(value []Processable)()
    SetRecommendedActions(value []string)()
    SetRegistryKeyStates(value []RegistryKeyStateable)()
    SetSecurityResources(value []SecurityResourceable)()
    SetSeverity(value *AlertSeverity)()
    SetSourceMaterials(value []string)()
    SetStatus(value *AlertStatus)()
    SetTags(value []string)()
    SetTitle(value *string)()
    SetTriggers(value []AlertTriggerable)()
    SetUriClickSecurityStates(value []UriClickSecurityStateable)()
    SetUserStates(value []UserSecurityStateable)()
    SetVendorInformation(value SecurityVendorInformationable)()
    SetVulnerabilityStates(value []VulnerabilityStateable)()
}
