const char metrics_collectors_shared_lua[] =
"local clock = require('clock')\n"
"local fiber = require('fiber')\n"
"local log = require('log')\n"
"\n"
"local Shared = {}\n"
"\n"
"-- Create collector class with the list of instance methods copied from\n"
"-- this class (like an inheritance but with limited list of methods).\n"
"function Shared:new_class(kind, method_names)\n"
"    method_names = method_names or {}\n"
"    -- essential methods\n"
"    table.insert(method_names, 'new')\n"
"    table.insert(method_names, 'set_registry')\n"
"    table.insert(method_names, 'make_key')\n"
"    table.insert(method_names, 'append_global_labels')\n"
"    table.insert(method_names, 'collect')\n"
"    table.insert(method_names, 'remove')\n"
"    local methods = {}\n"
"    for _, name in pairs(method_names) do\n"
"        methods[name] = self[name]\n"
"    end\n"
"    local class = {kind = kind}\n"
"    class.__index = class\n"
"    return setmetatable(class, {__index = methods})\n"
"end\n"
"\n"
"function Shared:new(name, help, metainfo)\n"
"    metainfo = table.copy(metainfo) or {}\n"
"\n"
"    if not name then\n"
"        error(\"Name should be set for %s\")\n"
"    end\n"
"    return setmetatable({\n"
"        name = name,\n"
"        help = help or \"\",\n"
"        observations = {},\n"
"        label_pairs = {},\n"
"        metainfo = metainfo,\n"
"    }, self)\n"
"end\n"
"\n"
"function Shared:set_registry(registry)\n"
"    self.registry = registry\n"
"end\n"
"\n"
"function Shared.make_key(label_pairs)\n"
"    if type(label_pairs) ~= 'table' then\n"
"        return \"\"\n"
"    end\n"
"    local parts = {}\n"
"    for k, v in pairs(label_pairs) do\n"
"        table.insert(parts, k .. '\\t' .. v)\n"
"    end\n"
"    table.sort(parts)\n"
"    return table.concat(parts, '\\t')\n"
"end\n"
"\n"
"function Shared:remove(label_pairs)\n"
"    assert(label_pairs, 'label pairs is a required parameter')\n"
"    local key = self.make_key(label_pairs)\n"
"    self.observations[key] = nil\n"
"    self.label_pairs[key] = nil\n"
"end\n"
"\n"
"function Shared:set(num, label_pairs)\n"
"    if num ~= nil and type(tonumber(num)) ~= 'number' then\n"
"        error(\"Collector set value should be a number\")\n"
"    end\n"
"    num = num or 0\n"
"    local key = self.make_key(label_pairs)\n"
"    self.observations[key] = num\n"
"    self.label_pairs[key] = label_pairs or {}\n"
"end\n"
"\n"
"function Shared:inc(num, label_pairs)\n"
"    if num ~= nil and type(tonumber(num)) ~= 'number' then\n"
"        error(\"Collector increment should be a number\")\n"
"    end\n"
"    num = num or 1\n"
"    local key = self.make_key(label_pairs)\n"
"    local old_value = self.observations[key] or 0\n"
"    self.observations[key] = old_value + num\n"
"    self.label_pairs[key] = label_pairs or {}\n"
"end\n"
"\n"
"function Shared:dec(num, label_pairs)\n"
"    if num ~= nil and type(tonumber(num)) ~= 'number' then\n"
"        error(\"Collector decrement should be a number\")\n"
"    end\n"
"    num = num or 1\n"
"    local key = self.make_key(label_pairs)\n"
"    local old_value = self.observations[key] or 0\n"
"    self.observations[key] = old_value - num\n"
"    self.label_pairs[key] = label_pairs or {}\n"
"end\n"
"\n"
"local function log_observe_latency_error(err)\n"
"    log.error(debug.traceback('Saving metrics failed: ' .. tostring(err)))\n"
"end\n"
"\n"
"local function observe_latency_tail(collector, label_pairs, start_time, ok, result, ...)\n"
"    local latency = clock.monotonic() - start_time\n"
"    if type(label_pairs) == 'function' then\n"
"        label_pairs = label_pairs(ok, result, ...)\n"
"    end\n"
"    xpcall(\n"
"        collector.observe,\n"
"        log_observe_latency_error,\n"
"        collector, latency, label_pairs\n"
"    )\n"
"    if not ok then\n"
"        error(result)\n"
"    end\n"
"    return result, ...\n"
"end\n"
"\n"
"--- Measure latency of function call\n"
"--\n"
"-- @param label_pairs either table with labels or function to generate labels.\n"
"--      If function is given its called with the results of pcall.\n"
"-- @param fn function for pcall to instrument\n"
"-- ... - args for function fn\n"
"-- @return value from fn\n"
"function Shared:observe_latency(label_pairs, fn, ...)\n"
"    return observe_latency_tail(self, label_pairs, clock.monotonic(), pcall(fn, ...))\n"
"end\n"
"\n"
"function Shared:append_global_labels(label_pairs)\n"
"    local global_labels = self.registry and self.registry.label_pairs\n"
"    if global_labels == nil or next(global_labels) == nil then\n"
"        return label_pairs\n"
"    end\n"
"\n"
"    local extended_label_pairs = table.copy(label_pairs)\n"
"\n"
"    for k, v in pairs(global_labels) do\n"
"        if extended_label_pairs[k] == nil then\n"
"            extended_label_pairs[k] = v\n"
"        end\n"
"    end\n"
"\n"
"    return extended_label_pairs\n"
"end\n"
"\n"
"function Shared:collect()\n"
"    if next(self.observations) == nil then\n"
"        return {}\n"
"    end\n"
"    local result = {}\n"
"    for key, observation in pairs(self.observations) do\n"
"        local obs = {\n"
"            metric_name = self.name,\n"
"            label_pairs = self:append_global_labels(self.label_pairs[key]),\n"
"            value = observation,\n"
"            timestamp = fiber.time64(),\n"
"        }\n"
"        table.insert(result, obs)\n"
"    end\n"
"    return result\n"
"end\n"
"\n"
"return Shared\n"
""
;
