/**
 * @file coeftab_d.h
 *
 * Precision dependent coeficient array header.
 *
 * @copyright 2012-2024 Bordeaux INP, CNRS (LaBRI UMR 5800), Inria,
 *                      Univ. Bordeaux. All rights reserved.
 *
 * @version 6.4.0
 * @author David Goudin
 * @author Pascal Henon
 * @author Francois Pellegrini
 * @author Pierre Ramet
 * @author Mathieu Faverge
 * @author Xavier Lacoste
 * @author Esragul Korkmaz
 * @author Gregoire Pichon
 * @date 2024-07-05
 *
 * @generated from /build/pastix/src/pastix-6.4.0/sopalin/coeftab_z.h, normal z -> d, Thu Oct 23 06:51:46 2025
 *
 * @addtogroup coeftab
 * @{
 *
 **/
#ifndef _coeftab_d_h_
#define _coeftab_d_h_

/**
 *    @name PastixDouble compression/uncompression routines
 *    @{
 */
pastix_int_t coeftab_dcompress  ( SolverMatrix *solvmtx );
void         coeftab_duncompress( SolverMatrix *solvmtx );
void         coeftab_dmemory    ( const SolverMatrix *solvmtx,
                                  const pastix_int_t *iparm,
                                  pastix_fixdbl_t    *dparm );

/**
 *    @}
 *    @name PastixDouble Extraction routines
 *    @{
 */
void coeftab_dgetschur( const SolverMatrix *solvmtx,
                        double *S, pastix_int_t lds );

void coeftab_dgetdiag( const SolverMatrix *solvmtx,
                       double *D, pastix_int_t incD );

/**
 *    @}
 *    @name PastixDouble debug routines
 *    @{
 */
void coeftab_ddump( pastix_data_t      *pastix_data,
                    const SolverMatrix *solvmtx,
                    const char         *filename );
void cpucblk_ddumpfile( pastix_coefside_t side,
                        SolverCblk       *cblk,
                        pastix_int_t      itercblk,
                        const char       *directory );
int  coeftab_ddiff( pastix_coefside_t   side,
                    const SolverMatrix *solvA,
                    SolverMatrix       *solvB );

/**
 *    @}
 */
#endif /* _coeftab_d_h_ */

/**
 * @}
 */
