// python wrapper for vtkPVPlotMatrixView
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVPlotMatrixView.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVPlotMatrixView(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVPlotMatrixView_ClassNew(); }

#ifndef DECLARED_PyvtkPVContextView_ClassNew
extern "C" { PyObject *PyvtkPVContextView_ClassNew(); }
#define DECLARED_PyvtkPVContextView_ClassNew
#endif

static PyObject *
PyvtkPVPlotMatrixView_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVPlotMatrixView::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVPlotMatrixView::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVPlotMatrixView *tempr = vtkPVPlotMatrixView::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVPlotMatrixView *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVPlotMatrixView::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVPlotMatrixView::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVPlotMatrixView::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_GetContextItem(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetContextItem");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkAbstractContextItem *tempr = (ap.IsBound() ?
      op->GetContextItem() :
      op->vtkPVPlotMatrixView::GetContextItem());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetSelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  vtkChartRepresentation *temp0 = nullptr;
  vtkSelection *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkChartRepresentation") &&
      ap.GetVTKObject(temp1, "vtkSelection"))
  {
    if (ap.IsBound())
    {
      op->SetSelection(temp0, temp1);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetSelection(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetActivePlot(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActivePlot");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetActivePlot(temp0, temp1);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetActivePlot(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_GetActiveRow(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetActiveRow");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetActiveRow() :
      op->vtkPVPlotMatrixView::GetActiveRow());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_GetActiveColumn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetActiveColumn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetActiveColumn() :
      op->vtkPVPlotMatrixView::GetActiveColumn());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_ClearAnimationPath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearAnimationPath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearAnimationPath();
    }
    else
    {
      op->vtkPVPlotMatrixView::ClearAnimationPath();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_AddAnimationPath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddAnimationPath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->AddAnimationPath(temp0, temp1);
    }
    else
    {
      op->vtkPVPlotMatrixView::AddAnimationPath(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_StartAnimationPath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "StartAnimationPath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->StartAnimationPath();
    }
    else
    {
      op->vtkPVPlotMatrixView::StartAnimationPath();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_AdvanceAnimationPath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AdvanceAnimationPath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->AdvanceAnimationPath();
    }
    else
    {
      op->vtkPVPlotMatrixView::AdvanceAnimationPath();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetTitleFont(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTitleFont");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  bool temp2 = false;
  bool temp3 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetTitleFont(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetTitleFont(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetTitleFontFamily(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTitleFontFamily");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTitleFontFamily(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetTitleFontFamily(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetTitleFontSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTitleFontSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTitleFontSize(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetTitleFontSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetTitleBold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTitleBold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTitleBold(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetTitleBold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetTitleItalic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTitleItalic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTitleItalic(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetTitleItalic(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetTitleFontFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTitleFontFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTitleFontFile(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetTitleFontFile(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_GetTitleFontFamily(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTitleFontFamily");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetTitleFontFamily() :
      op->vtkPVPlotMatrixView::GetTitleFontFamily());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_GetTitleFontSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTitleFontSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTitleFontSize() :
      op->vtkPVPlotMatrixView::GetTitleFontSize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_GetTitleFontBold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTitleFontBold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTitleFontBold() :
      op->vtkPVPlotMatrixView::GetTitleFontBold());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_GetTitleFontItalic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTitleFontItalic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTitleFontItalic() :
      op->vtkPVPlotMatrixView::GetTitleFontItalic());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetTitleColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTitleColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetTitleColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetTitleColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_GetTitleColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTitleColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetTitleColor() :
      op->vtkPVPlotMatrixView::GetTitleColor());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetTitleAlignment(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTitleAlignment");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTitleAlignment(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetTitleAlignment(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_GetTitleAlignment(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTitleAlignment");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTitleAlignment() :
      op->vtkPVPlotMatrixView::GetTitleAlignment());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetNumberOfAnimationFrames(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfAnimationFrames");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfAnimationFrames(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetNumberOfAnimationFrames(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetGutter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGutter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  float temp0;
  float temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetGutter(temp0, temp1);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetGutter(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetGutterX(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGutterX");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  float temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGutterX(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetGutterX(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetGutterY(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGutterY");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  float temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGutterY(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetGutterY(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetPadding(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPadding");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  float temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPadding(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetPadding(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetBorders(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBorders");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  int temp1;
  int temp2;
  int temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetBorders(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetBorders(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetBorderLeft(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBorderLeft");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBorderLeft(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetBorderLeft(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetBorderBottom(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBorderBottom");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBorderBottom(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetBorderBottom(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetBorderRight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBorderRight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBorderRight(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetBorderRight(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetBorderTop(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBorderTop");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBorderTop(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetBorderTop(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetGridVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGridVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetGridVisibility(temp0, temp1);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetGridVisibility(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetScatterPlotGridVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScatterPlotGridVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetScatterPlotGridVisibility(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetScatterPlotGridVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetHistogramGridVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHistogramGridVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetHistogramGridVisibility(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetHistogramGridVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetActivePlotGridVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActivePlotGridVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetActivePlotGridVisibility(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetActivePlotGridVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_GetGridVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGridVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetGridVisibility(temp0) :
      op->vtkPVPlotMatrixView::GetGridVisibility(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetBackgroundColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBackgroundColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  double temp1;
  double temp2;
  double temp3;
  double temp4;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4))
  {
    if (ap.IsBound())
    {
      op->SetBackgroundColor(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetBackgroundColor(temp0, temp1, temp2, temp3, temp4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_GetBackgroundColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBackgroundColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  const size_t size1 = 3;
  double temp1[3];
  double save1[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    bool tempr = (ap.IsBound() ?
      op->GetBackgroundColor(temp0, temp1) :
      op->vtkPVPlotMatrixView::GetBackgroundColor(temp0, temp1));

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetScatterPlotBackgroundColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScatterPlotBackgroundColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  double temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetScatterPlotBackgroundColor(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetScatterPlotBackgroundColor(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetHistogramBackgroundColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHistogramBackgroundColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  double temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetHistogramBackgroundColor(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetHistogramBackgroundColor(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetActivePlotBackgroundColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActivePlotBackgroundColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  double temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetActivePlotBackgroundColor(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetActivePlotBackgroundColor(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetAxisColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  double temp1;
  double temp2;
  double temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetAxisColor(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetAxisColor(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_GetAxisColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAxisColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  const size_t size1 = 3;
  double temp1[3];
  double save1[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    bool tempr = (ap.IsBound() ?
      op->GetAxisColor(temp0, temp1) :
      op->vtkPVPlotMatrixView::GetAxisColor(temp0, temp1));

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetScatterPlotAxisColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScatterPlotAxisColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetScatterPlotAxisColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetScatterPlotAxisColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetHistogramAxisColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHistogramAxisColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetHistogramAxisColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetHistogramAxisColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetActivePlotAxisColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActivePlotAxisColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetActivePlotAxisColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetActivePlotAxisColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetGridColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGridColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  double temp1;
  double temp2;
  double temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetGridColor(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetGridColor(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_GetGridColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGridColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  const size_t size1 = 3;
  double temp1[3];
  double save1[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    bool tempr = (ap.IsBound() ?
      op->GetGridColor(temp0, temp1) :
      op->vtkPVPlotMatrixView::GetGridColor(temp0, temp1));

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetScatterPlotGridColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScatterPlotGridColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetScatterPlotGridColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetScatterPlotGridColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetHistogramGridColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHistogramGridColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetHistogramGridColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetHistogramGridColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetActivePlotGridColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActivePlotGridColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetActivePlotGridColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetActivePlotGridColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetAxisLabelVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisLabelVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetAxisLabelVisibility(temp0, temp1);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetAxisLabelVisibility(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_GetAxisLabelVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAxisLabelVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetAxisLabelVisibility(temp0) :
      op->vtkPVPlotMatrixView::GetAxisLabelVisibility(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScatterPlotAxisLabelVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetScatterPlotAxisLabelVisibility(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetScatterPlotAxisLabelVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetHistogramAxisLabelVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHistogramAxisLabelVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetHistogramAxisLabelVisibility(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetHistogramAxisLabelVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetActivePlotAxisLabelVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActivePlotAxisLabelVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetActivePlotAxisLabelVisibility(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetActivePlotAxisLabelVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetAxisLabelFont(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisLabelFont");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  const char *temp1 = nullptr;
  int temp2;
  bool temp3 = false;
  bool temp4 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4))
  {
    if (ap.IsBound())
    {
      op->SetAxisLabelFont(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetAxisLabelFont(temp0, temp1, temp2, temp3, temp4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetAxisLabelFontFamily(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisLabelFontFamily");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetAxisLabelFontFamily(temp0, temp1);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetAxisLabelFontFamily(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelFontFamily(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScatterPlotAxisLabelFontFamily");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetScatterPlotAxisLabelFontFamily(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetScatterPlotAxisLabelFontFamily(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetHistogramAxisLabelFontFamily(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHistogramAxisLabelFontFamily");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetHistogramAxisLabelFontFamily(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetHistogramAxisLabelFontFamily(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetActivePlotAxisLabelFontFamily(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActivePlotAxisLabelFontFamily");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetActivePlotAxisLabelFontFamily(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetActivePlotAxisLabelFontFamily(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetAxisLabelFontFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisLabelFontFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetAxisLabelFontFile(temp0, temp1);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetAxisLabelFontFile(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelFontFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScatterPlotAxisLabelFontFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetScatterPlotAxisLabelFontFile(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetScatterPlotAxisLabelFontFile(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetHistogramAxisLabelFontFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHistogramAxisLabelFontFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetHistogramAxisLabelFontFile(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetHistogramAxisLabelFontFile(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetActivePlotAxisLabelFontFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActivePlotAxisLabelFontFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetActivePlotAxisLabelFontFile(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetActivePlotAxisLabelFontFile(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetAxisLabelFontSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisLabelFontSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetAxisLabelFontSize(temp0, temp1);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetAxisLabelFontSize(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelFontSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScatterPlotAxisLabelFontSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetScatterPlotAxisLabelFontSize(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetScatterPlotAxisLabelFontSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetHistogramAxisLabelFontSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHistogramAxisLabelFontSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetHistogramAxisLabelFontSize(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetHistogramAxisLabelFontSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetActivePlotAxisLabelFontSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActivePlotAxisLabelFontSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetActivePlotAxisLabelFontSize(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetActivePlotAxisLabelFontSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetAxisLabelBold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisLabelBold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetAxisLabelBold(temp0, temp1);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetAxisLabelBold(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelBold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScatterPlotAxisLabelBold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetScatterPlotAxisLabelBold(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetScatterPlotAxisLabelBold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetHistogramAxisLabelBold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHistogramAxisLabelBold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetHistogramAxisLabelBold(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetHistogramAxisLabelBold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetActivePlotAxisLabelBold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActivePlotAxisLabelBold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetActivePlotAxisLabelBold(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetActivePlotAxisLabelBold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetAxisLabelItalic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisLabelItalic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetAxisLabelItalic(temp0, temp1);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetAxisLabelItalic(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelItalic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScatterPlotAxisLabelItalic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetScatterPlotAxisLabelItalic(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetScatterPlotAxisLabelItalic(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetHistogramAxisLabelItalic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHistogramAxisLabelItalic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetHistogramAxisLabelItalic(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetHistogramAxisLabelItalic(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetActivePlotAxisLabelItalic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActivePlotAxisLabelItalic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetActivePlotAxisLabelItalic(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetActivePlotAxisLabelItalic(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_GetAxisLabelFontFamily(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAxisLabelFontFamily");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetAxisLabelFontFamily(temp0) :
      op->vtkPVPlotMatrixView::GetAxisLabelFontFamily(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_GetAxisLabelFontSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAxisLabelFontSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetAxisLabelFontSize(temp0) :
      op->vtkPVPlotMatrixView::GetAxisLabelFontSize(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_GetAxisLabelFontBold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAxisLabelFontBold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetAxisLabelFontBold(temp0) :
      op->vtkPVPlotMatrixView::GetAxisLabelFontBold(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_GetAxisLabelFontItalic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAxisLabelFontItalic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetAxisLabelFontItalic(temp0) :
      op->vtkPVPlotMatrixView::GetAxisLabelFontItalic(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetAxisLabelColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisLabelColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  double temp1;
  double temp2;
  double temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetAxisLabelColor(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetAxisLabelColor(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScatterPlotAxisLabelColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetScatterPlotAxisLabelColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetScatterPlotAxisLabelColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetHistogramAxisLabelColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHistogramAxisLabelColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetHistogramAxisLabelColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetHistogramAxisLabelColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetActivePlotAxisLabelColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActivePlotAxisLabelColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetActivePlotAxisLabelColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetActivePlotAxisLabelColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_GetAxisLabelColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAxisLabelColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  const size_t size1 = 3;
  double temp1[3];
  double save1[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    bool tempr = (ap.IsBound() ?
      op->GetAxisLabelColor(temp0, temp1) :
      op->vtkPVPlotMatrixView::GetAxisLabelColor(temp0, temp1));

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetAxisLabelNotation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisLabelNotation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetAxisLabelNotation(temp0, temp1);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetAxisLabelNotation(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelNotation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScatterPlotAxisLabelNotation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetScatterPlotAxisLabelNotation(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetScatterPlotAxisLabelNotation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetHistogramAxisLabelNotation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHistogramAxisLabelNotation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetHistogramAxisLabelNotation(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetHistogramAxisLabelNotation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetActivePlotAxisLabelNotation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActivePlotAxisLabelNotation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetActivePlotAxisLabelNotation(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetActivePlotAxisLabelNotation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_GetAxisLabelNotation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAxisLabelNotation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetAxisLabelNotation(temp0) :
      op->vtkPVPlotMatrixView::GetAxisLabelNotation(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetAxisLabelPrecision(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisLabelPrecision");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetAxisLabelPrecision(temp0, temp1);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetAxisLabelPrecision(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelPrecision(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScatterPlotAxisLabelPrecision");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetScatterPlotAxisLabelPrecision(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetScatterPlotAxisLabelPrecision(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetHistogramAxisLabelPrecision(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHistogramAxisLabelPrecision");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetHistogramAxisLabelPrecision(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetHistogramAxisLabelPrecision(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetActivePlotAxisLabelPrecision(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActivePlotAxisLabelPrecision");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetActivePlotAxisLabelPrecision(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetActivePlotAxisLabelPrecision(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_GetAxisLabelPrecision(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAxisLabelPrecision");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetAxisLabelPrecision(temp0) :
      op->vtkPVPlotMatrixView::GetAxisLabelPrecision(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetTooltipNotation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTooltipNotation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetTooltipNotation(temp0, temp1);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetTooltipNotation(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetScatterPlotTooltipNotation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScatterPlotTooltipNotation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetScatterPlotTooltipNotation(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetScatterPlotTooltipNotation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetHistogramTooltipNotation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHistogramTooltipNotation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetHistogramTooltipNotation(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetHistogramTooltipNotation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetActivePlotTooltipNotation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActivePlotTooltipNotation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetActivePlotTooltipNotation(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetActivePlotTooltipNotation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetTooltipPrecision(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTooltipPrecision");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetTooltipPrecision(temp0, temp1);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetTooltipPrecision(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetScatterPlotTooltipPrecision(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScatterPlotTooltipPrecision");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetScatterPlotTooltipPrecision(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetScatterPlotTooltipPrecision(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetHistogramTooltipPrecision(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHistogramTooltipPrecision");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetHistogramTooltipPrecision(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetHistogramTooltipPrecision(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetActivePlotTooltipPrecision(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActivePlotTooltipPrecision");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetActivePlotTooltipPrecision(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetActivePlotTooltipPrecision(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_GetTooltipNotation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTooltipNotation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTooltipNotation(temp0) :
      op->vtkPVPlotMatrixView::GetTooltipNotation(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_GetTooltipPrecision(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTooltipPrecision");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTooltipPrecision(temp0) :
      op->vtkPVPlotMatrixView::GetTooltipPrecision(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetScatterPlotSelectedRowColumnColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScatterPlotSelectedRowColumnColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  double temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetScatterPlotSelectedRowColumnColor(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetScatterPlotSelectedRowColumnColor(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_GetScatterPlotSelectedRowColumnColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetScatterPlotSelectedRowColumnColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  double save0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    bool tempr = (ap.IsBound() ?
      op->GetScatterPlotSelectedRowColumnColor(temp0) :
      op->vtkPVPlotMatrixView::GetScatterPlotSelectedRowColumnColor(temp0));

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_SetScatterPlotSelectedActiveColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScatterPlotSelectedActiveColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  double temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetScatterPlotSelectedActiveColor(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkPVPlotMatrixView::SetScatterPlotSelectedActiveColor(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_GetScatterPlotSelectedActiveColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetScatterPlotSelectedActiveColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  double save0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    bool tempr = (ap.IsBound() ?
      op->GetScatterPlotSelectedActiveColor(temp0) :
      op->vtkPVPlotMatrixView::GetScatterPlotSelectedActiveColor(temp0));

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixView_UpdateSettings(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateSettings");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixView *op = static_cast<vtkPVPlotMatrixView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UpdateSettings();
    }
    else
    {
      op->vtkPVPlotMatrixView::UpdateSettings();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVPlotMatrixView_Methods[] = {
  {"IsTypeOf", PyvtkPVPlotMatrixView_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVPlotMatrixView_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVPlotMatrixView_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVPlotMatrixView\nC++: static vtkPVPlotMatrixView *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVPlotMatrixView_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVPlotMatrixView\nC++: vtkPVPlotMatrixView *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVPlotMatrixView_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVPlotMatrixView_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetContextItem", PyvtkPVPlotMatrixView_GetContextItem, METH_VARARGS,
   "GetContextItem(self) -> vtkAbstractContextItem\nC++: vtkAbstractContextItem *GetContextItem() override;\n\nGet the context item.\n"},
  {"SetSelection", PyvtkPVPlotMatrixView_SetSelection, METH_VARARGS,
   "SetSelection(self, repr:vtkChartRepresentation,\n    selection:vtkSelection) -> None\nC++: void SetSelection(vtkChartRepresentation *repr,\n    vtkSelection *selection) override;\n\nRepresentations can use this method to set the selection for a\nparticular representation. Subclasses override this method to\npass on the selection to the chart using annotation link. Note\nthis is meant to pass selection for the local process alone. The\nview does not manage data movement for the selection.\n"},
  {"SetActivePlot", PyvtkPVPlotMatrixView_SetActivePlot, METH_VARARGS,
   "SetActivePlot(self, i:int, j:int) -> None\nC++: void SetActivePlot(int i, int j)\n\nGet/set the active plot in the scatter plot matrix.\n"},
  {"GetActiveRow", PyvtkPVPlotMatrixView_GetActiveRow, METH_VARARGS,
   "GetActiveRow(self) -> int\nC++: int GetActiveRow()\n\n"},
  {"GetActiveColumn", PyvtkPVPlotMatrixView_GetActiveColumn, METH_VARARGS,
   "GetActiveColumn(self) -> int\nC++: int GetActiveColumn()\n\n"},
  {"ClearAnimationPath", PyvtkPVPlotMatrixView_ClearAnimationPath, METH_VARARGS,
   "ClearAnimationPath(self) -> None\nC++: void ClearAnimationPath()\n\nClear the animation path, ensuring it is empty.\n"},
  {"AddAnimationPath", PyvtkPVPlotMatrixView_AddAnimationPath, METH_VARARGS,
   "AddAnimationPath(self, i:int, j:int) -> None\nC++: void AddAnimationPath(int i, int j)\n\nAppend to the animation path of the scatter plot matrix.\n"},
  {"StartAnimationPath", PyvtkPVPlotMatrixView_StartAnimationPath, METH_VARARGS,
   "StartAnimationPath(self) -> None\nC++: void StartAnimationPath()\n\nAppend to the animation path of the scatter plot matrix.\n"},
  {"AdvanceAnimationPath", PyvtkPVPlotMatrixView_AdvanceAnimationPath, METH_VARARGS,
   "AdvanceAnimationPath(self) -> None\nC++: void AdvanceAnimationPath()\n\nPush the animation forward a frame.\n"},
  {"SetTitleFont", PyvtkPVPlotMatrixView_SetTitleFont, METH_VARARGS,
   "SetTitleFont(self, family:str, pointSize:int, bold:bool,\n    italic:bool) -> None\nC++: void SetTitleFont(const char *family, int pointSize,\n    bool bold, bool italic) override;\n\nGet/Set the font of the title. These methods should not be called\ndirectly. They are made public only so that the\nclient-server-stream-interpreter can invoke them. Use the\ncorresponding properties to change these values.\n"},
  {"SetTitleFontFamily", PyvtkPVPlotMatrixView_SetTitleFontFamily, METH_VARARGS,
   "SetTitleFontFamily(self, family:str) -> None\nC++: void SetTitleFontFamily(const char *family) override;\n\n"},
  {"SetTitleFontSize", PyvtkPVPlotMatrixView_SetTitleFontSize, METH_VARARGS,
   "SetTitleFontSize(self, pointSize:int) -> None\nC++: void SetTitleFontSize(int pointSize) override;\n\n"},
  {"SetTitleBold", PyvtkPVPlotMatrixView_SetTitleBold, METH_VARARGS,
   "SetTitleBold(self, bold:bool) -> None\nC++: void SetTitleBold(bool bold) override;\n\n"},
  {"SetTitleItalic", PyvtkPVPlotMatrixView_SetTitleItalic, METH_VARARGS,
   "SetTitleItalic(self, italic:bool) -> None\nC++: void SetTitleItalic(bool italic) override;\n\n"},
  {"SetTitleFontFile", PyvtkPVPlotMatrixView_SetTitleFontFile, METH_VARARGS,
   "SetTitleFontFile(self, file:str) -> None\nC++: void SetTitleFontFile(const char *file) override;\n\n"},
  {"GetTitleFontFamily", PyvtkPVPlotMatrixView_GetTitleFontFamily, METH_VARARGS,
   "GetTitleFontFamily(self) -> str\nC++: const char *GetTitleFontFamily() override;\n\n"},
  {"GetTitleFontSize", PyvtkPVPlotMatrixView_GetTitleFontSize, METH_VARARGS,
   "GetTitleFontSize(self) -> int\nC++: int GetTitleFontSize() override;\n\n"},
  {"GetTitleFontBold", PyvtkPVPlotMatrixView_GetTitleFontBold, METH_VARARGS,
   "GetTitleFontBold(self) -> int\nC++: int GetTitleFontBold() override;\n\n"},
  {"GetTitleFontItalic", PyvtkPVPlotMatrixView_GetTitleFontItalic, METH_VARARGS,
   "GetTitleFontItalic(self) -> int\nC++: int GetTitleFontItalic() override;\n\n"},
  {"SetTitleColor", PyvtkPVPlotMatrixView_SetTitleColor, METH_VARARGS,
   "SetTitleColor(self, red:float, green:float, blue:float) -> None\nC++: void SetTitleColor(double red, double green, double blue)\n    override;\n\nGet/Set the color of the title. These methods should not be\ncalled directly. They are made public only so that the\nclient-server-stream-interpreter can invoke them. Use the\ncorresponding properties to change these values.\n"},
  {"GetTitleColor", PyvtkPVPlotMatrixView_GetTitleColor, METH_VARARGS,
   "GetTitleColor(self) -> Pointer\nC++: double *GetTitleColor() override;\n\n"},
  {"SetTitleAlignment", PyvtkPVPlotMatrixView_SetTitleAlignment, METH_VARARGS,
   "SetTitleAlignment(self, alignment:int) -> None\nC++: void SetTitleAlignment(int alignment) override;\n\nSet the alignement of the title. These methods should not be\ncalled directly. They are made public only so that the\nclient-server-stream-interpreter can invoke them. Use the\ncorresponding properties to change these values.\n"},
  {"GetTitleAlignment", PyvtkPVPlotMatrixView_GetTitleAlignment, METH_VARARGS,
   "GetTitleAlignment(self) -> int\nC++: int GetTitleAlignment() override;\n\n"},
  {"SetNumberOfAnimationFrames", PyvtkPVPlotMatrixView_SetNumberOfAnimationFrames, METH_VARARGS,
   "SetNumberOfAnimationFrames(self, value:int) -> None\nC++: void SetNumberOfAnimationFrames(int value)\n\nSet the number of animation frames used when changing the active\nscatterplot.\n"},
  {"SetGutter", PyvtkPVPlotMatrixView_SetGutter, METH_VARARGS,
   "SetGutter(self, x:float, y:float) -> None\nC++: virtual void SetGutter(float x, float y)\n\nSet the gutter that should be left between the charts in the\nmatrix. These methods should not be called directly. They are\nmade public only so that the client-server-stream-interpreter can\ninvoke them. Use the corresponding properties to change these\nvalues.\n"},
  {"SetGutterX", PyvtkPVPlotMatrixView_SetGutterX, METH_VARARGS,
   "SetGutterX(self, value:float) -> None\nC++: void SetGutterX(float value)\n\n"},
  {"SetGutterY", PyvtkPVPlotMatrixView_SetGutterY, METH_VARARGS,
   "SetGutterY(self, value:float) -> None\nC++: void SetGutterY(float value)\n\n"},
  {"SetPadding", PyvtkPVPlotMatrixView_SetPadding, METH_VARARGS,
   "SetPadding(self, padding:float) -> None\nC++: virtual void SetPadding(float padding)\n\nSet the padding that applied an uniform padding on each charts.\n"},
  {"SetBorders", PyvtkPVPlotMatrixView_SetBorders, METH_VARARGS,
   "SetBorders(self, left:int, bottom:int, right:int, top:int) -> None\nC++: virtual void SetBorders(int left, int bottom, int right,\n    int top)\n\nSet/get the borders of the chart matrix (space in pixels around\neach chart). These methods should not be called directly. They\nare made public only so that the client-server-stream-interpreter\ncan invoke them. Use the corresponding properties to change these\nvalues.\n"},
  {"SetBorderLeft", PyvtkPVPlotMatrixView_SetBorderLeft, METH_VARARGS,
   "SetBorderLeft(self, value:int) -> None\nC++: virtual void SetBorderLeft(int value)\n\n"},
  {"SetBorderBottom", PyvtkPVPlotMatrixView_SetBorderBottom, METH_VARARGS,
   "SetBorderBottom(self, value:int) -> None\nC++: virtual void SetBorderBottom(int value)\n\n"},
  {"SetBorderRight", PyvtkPVPlotMatrixView_SetBorderRight, METH_VARARGS,
   "SetBorderRight(self, value:int) -> None\nC++: virtual void SetBorderRight(int value)\n\n"},
  {"SetBorderTop", PyvtkPVPlotMatrixView_SetBorderTop, METH_VARARGS,
   "SetBorderTop(self, value:int) -> None\nC++: virtual void SetBorderTop(int value)\n\n"},
  {"SetGridVisibility", PyvtkPVPlotMatrixView_SetGridVisibility, METH_VARARGS,
   "SetGridVisibility(self, plotType:int, visible:bool) -> None\nC++: void SetGridVisibility(int plotType, bool visible)\n\nSets whether or not the grid for the given axis is visible given\na plot type, which refers to vtkScatterPlotMatrix::{SCATTERPLOT,\nHISTOGRAM, ACTIVEPLOT}. These methods should not be called\ndirectly. They are made public only so that the\nclient-server-stream-interpreter can invoke them. Use the\ncorresponding properties to change these values.\n"},
  {"SetScatterPlotGridVisibility", PyvtkPVPlotMatrixView_SetScatterPlotGridVisibility, METH_VARARGS,
   "SetScatterPlotGridVisibility(self, value:bool) -> None\nC++: void SetScatterPlotGridVisibility(bool value)\n\n"},
  {"SetHistogramGridVisibility", PyvtkPVPlotMatrixView_SetHistogramGridVisibility, METH_VARARGS,
   "SetHistogramGridVisibility(self, value:bool) -> None\nC++: void SetHistogramGridVisibility(bool value)\n\n"},
  {"SetActivePlotGridVisibility", PyvtkPVPlotMatrixView_SetActivePlotGridVisibility, METH_VARARGS,
   "SetActivePlotGridVisibility(self, value:bool) -> None\nC++: void SetActivePlotGridVisibility(bool value)\n\n"},
  {"GetGridVisibility", PyvtkPVPlotMatrixView_GetGridVisibility, METH_VARARGS,
   "GetGridVisibility(self, plotType:int) -> int\nC++: int GetGridVisibility(int plotType)\n\n"},
  {"SetBackgroundColor", PyvtkPVPlotMatrixView_SetBackgroundColor, METH_VARARGS,
   "SetBackgroundColor(self, plotType:int, red:float, green:float,\n    blue:float, alpha:float) -> None\nC++: void SetBackgroundColor(int plotType, double red,\n    double green, double blue, double alpha)\n\nSets the background color for the chart given a plot type, which\nrefers to vtkScatterPlotMatrix::{SCATTERPLOT, HISTOGRAM,\nACTIVEPLOT}. These methods should not be called directly. They\nare made public only so that the client-server-stream-interpreter\ncan invoke them. Use the corresponding properties to change these\nvalues. The getter return false if the color can't be recovered.\n"},
  {"GetBackgroundColor", PyvtkPVPlotMatrixView_GetBackgroundColor, METH_VARARGS,
   "GetBackgroundColor(self, plotType:int, color:[float, float,\n    float]) -> bool\nC++: bool GetBackgroundColor(int plotType, double color[3])\n\n"},
  {"SetScatterPlotBackgroundColor", PyvtkPVPlotMatrixView_SetScatterPlotBackgroundColor, METH_VARARGS,
   "SetScatterPlotBackgroundColor(self, value1:float, value2:float,\n    value3:float, value4:float) -> None\nC++: void SetScatterPlotBackgroundColor(double value1,\n    double value2, double value3, double value4)\n\n"},
  {"SetHistogramBackgroundColor", PyvtkPVPlotMatrixView_SetHistogramBackgroundColor, METH_VARARGS,
   "SetHistogramBackgroundColor(self, value1:float, value2:float,\n    value3:float, value4:float) -> None\nC++: void SetHistogramBackgroundColor(double value1,\n    double value2, double value3, double value4)\n\n"},
  {"SetActivePlotBackgroundColor", PyvtkPVPlotMatrixView_SetActivePlotBackgroundColor, METH_VARARGS,
   "SetActivePlotBackgroundColor(self, value1:float, value2:float,\n    value3:float, value4:float) -> None\nC++: void SetActivePlotBackgroundColor(double value1,\n    double value2, double value3, double value4)\n\n"},
  {"SetAxisColor", PyvtkPVPlotMatrixView_SetAxisColor, METH_VARARGS,
   "SetAxisColor(self, plotType:int, red:float, green:float,\n    blue:float) -> None\nC++: void SetAxisColor(int plotType, double red, double green,\n    double blue)\n\nSets the color for the axes given a plot type, which refers to\nvtkScatterPlotMatrix::{SCATTERPLOT, HISTOGRAM, ACTIVEPLOT}. These\nmethods should not be called directly. They are made public only\nso that the client-server-stream-interpreter can invoke them. Use\nthe corresponding properties to change these values. The getter\nreturn false if the color can't be recovered.\n"},
  {"GetAxisColor", PyvtkPVPlotMatrixView_GetAxisColor, METH_VARARGS,
   "GetAxisColor(self, plotType:int, color:[float, float, float])\n    -> bool\nC++: bool GetAxisColor(int plotType, double color[3])\n\n"},
  {"SetScatterPlotAxisColor", PyvtkPVPlotMatrixView_SetScatterPlotAxisColor, METH_VARARGS,
   "SetScatterPlotAxisColor(self, value1:float, value2:float,\n    value3:float) -> None\nC++: void SetScatterPlotAxisColor(double value1, double value2,\n    double value3)\n\n"},
  {"SetHistogramAxisColor", PyvtkPVPlotMatrixView_SetHistogramAxisColor, METH_VARARGS,
   "SetHistogramAxisColor(self, value1:float, value2:float,\n    value3:float) -> None\nC++: void SetHistogramAxisColor(double value1, double value2,\n    double value3)\n\n"},
  {"SetActivePlotAxisColor", PyvtkPVPlotMatrixView_SetActivePlotAxisColor, METH_VARARGS,
   "SetActivePlotAxisColor(self, value1:float, value2:float,\n    value3:float) -> None\nC++: void SetActivePlotAxisColor(double value1, double value2,\n    double value3)\n\n"},
  {"SetGridColor", PyvtkPVPlotMatrixView_SetGridColor, METH_VARARGS,
   "SetGridColor(self, plotType:int, red:float, green:float,\n    blue:float) -> None\nC++: void SetGridColor(int plotType, double red, double green,\n    double blue)\n\nSets the color for the axes given a plot type, which refers to\nvtkScatterPlotMatrix::{SCATTERPLOT, HISTOGRAM, ACTIVEPLOT}. These\nmethods should not be called directly. They are made public only\nso that the client-server-stream-interpreter can invoke them. Use\nthe corresponding properties to change these values. The getter\nreturn false if the color can't be recovered.\n"},
  {"GetGridColor", PyvtkPVPlotMatrixView_GetGridColor, METH_VARARGS,
   "GetGridColor(self, plotType:int, color:[float, float, float])\n    -> bool\nC++: bool GetGridColor(int plotType, double color[3])\n\n"},
  {"SetScatterPlotGridColor", PyvtkPVPlotMatrixView_SetScatterPlotGridColor, METH_VARARGS,
   "SetScatterPlotGridColor(self, value1:float, value2:float,\n    value3:float) -> None\nC++: void SetScatterPlotGridColor(double value1, double value2,\n    double value3)\n\n"},
  {"SetHistogramGridColor", PyvtkPVPlotMatrixView_SetHistogramGridColor, METH_VARARGS,
   "SetHistogramGridColor(self, value1:float, value2:float,\n    value3:float) -> None\nC++: void SetHistogramGridColor(double value1, double value2,\n    double value3)\n\n"},
  {"SetActivePlotGridColor", PyvtkPVPlotMatrixView_SetActivePlotGridColor, METH_VARARGS,
   "SetActivePlotGridColor(self, value1:float, value2:float,\n    value3:float) -> None\nC++: void SetActivePlotGridColor(double value1, double value2,\n    double value3)\n\n"},
  {"SetAxisLabelVisibility", PyvtkPVPlotMatrixView_SetAxisLabelVisibility, METH_VARARGS,
   "SetAxisLabelVisibility(self, plotType:int, visible:bool) -> None\nC++: void SetAxisLabelVisibility(int plotType, bool visible)\n\nSets whether or not the labels for the axes are visible, given a\nplot type, which refers to vtkScatterPlotMatrix::{SCATTERPLOT,\nHISTOGRAM, ACTIVEPLOT}. These methods should not be called\ndirectly. They are made public only so that the\nclient-server-stream-interpreter can invoke them. Use the\ncorresponding properties to change these values.\n"},
  {"GetAxisLabelVisibility", PyvtkPVPlotMatrixView_GetAxisLabelVisibility, METH_VARARGS,
   "GetAxisLabelVisibility(self, plotType:int) -> int\nC++: int GetAxisLabelVisibility(int plotType)\n\n"},
  {"SetScatterPlotAxisLabelVisibility", PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelVisibility, METH_VARARGS,
   "SetScatterPlotAxisLabelVisibility(self, value:bool) -> None\nC++: void SetScatterPlotAxisLabelVisibility(bool value)\n\n"},
  {"SetHistogramAxisLabelVisibility", PyvtkPVPlotMatrixView_SetHistogramAxisLabelVisibility, METH_VARARGS,
   "SetHistogramAxisLabelVisibility(self, value:bool) -> None\nC++: void SetHistogramAxisLabelVisibility(bool value)\n\n"},
  {"SetActivePlotAxisLabelVisibility", PyvtkPVPlotMatrixView_SetActivePlotAxisLabelVisibility, METH_VARARGS,
   "SetActivePlotAxisLabelVisibility(self, value:bool) -> None\nC++: void SetActivePlotAxisLabelVisibility(bool value)\n\n"},
  {"SetAxisLabelFont", PyvtkPVPlotMatrixView_SetAxisLabelFont, METH_VARARGS,
   "SetAxisLabelFont(self, plotType:int, family:str, pointSize:int,\n    bold:bool, italic:bool) -> None\nC++: void SetAxisLabelFont(int plotType, const char *family,\n    int pointSize, bool bold, bool italic)\n\nSet the axis label font for the axes given a plot type, which\nrefers to vtkScatterPlotMatrix::{SCATTERPLOT, HISTOGRAM,\nACTIVEPLOT}. These methods should not be called directly. They\nare made public only so that the client-server-stream-interpreter\ncan invoke them. Use the corresponding properties to change these\nvalues.\n"},
  {"SetAxisLabelFontFamily", PyvtkPVPlotMatrixView_SetAxisLabelFontFamily, METH_VARARGS,
   "SetAxisLabelFontFamily(self, plotType:int, family:str) -> None\nC++: void SetAxisLabelFontFamily(int plotType, const char *family)\n\n"},
  {"SetScatterPlotAxisLabelFontFamily", PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelFontFamily, METH_VARARGS,
   "SetScatterPlotAxisLabelFontFamily(self, value:str) -> None\nC++: void SetScatterPlotAxisLabelFontFamily(const char *value)\n\n"},
  {"SetHistogramAxisLabelFontFamily", PyvtkPVPlotMatrixView_SetHistogramAxisLabelFontFamily, METH_VARARGS,
   "SetHistogramAxisLabelFontFamily(self, value:str) -> None\nC++: void SetHistogramAxisLabelFontFamily(const char *value)\n\n"},
  {"SetActivePlotAxisLabelFontFamily", PyvtkPVPlotMatrixView_SetActivePlotAxisLabelFontFamily, METH_VARARGS,
   "SetActivePlotAxisLabelFontFamily(self, value:str) -> None\nC++: void SetActivePlotAxisLabelFontFamily(const char *value)\n\n"},
  {"SetAxisLabelFontFile", PyvtkPVPlotMatrixView_SetAxisLabelFontFile, METH_VARARGS,
   "SetAxisLabelFontFile(self, plotType:int, file:str) -> None\nC++: void SetAxisLabelFontFile(int plotType, const char *file)\n\n"},
  {"SetScatterPlotAxisLabelFontFile", PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelFontFile, METH_VARARGS,
   "SetScatterPlotAxisLabelFontFile(self, value:str) -> None\nC++: void SetScatterPlotAxisLabelFontFile(const char *value)\n\n"},
  {"SetHistogramAxisLabelFontFile", PyvtkPVPlotMatrixView_SetHistogramAxisLabelFontFile, METH_VARARGS,
   "SetHistogramAxisLabelFontFile(self, value:str) -> None\nC++: void SetHistogramAxisLabelFontFile(const char *value)\n\n"},
  {"SetActivePlotAxisLabelFontFile", PyvtkPVPlotMatrixView_SetActivePlotAxisLabelFontFile, METH_VARARGS,
   "SetActivePlotAxisLabelFontFile(self, value:str) -> None\nC++: void SetActivePlotAxisLabelFontFile(const char *value)\n\n"},
  {"SetAxisLabelFontSize", PyvtkPVPlotMatrixView_SetAxisLabelFontSize, METH_VARARGS,
   "SetAxisLabelFontSize(self, plotType:int, pointSize:int) -> None\nC++: void SetAxisLabelFontSize(int plotType, int pointSize)\n\n"},
  {"SetScatterPlotAxisLabelFontSize", PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelFontSize, METH_VARARGS,
   "SetScatterPlotAxisLabelFontSize(self, value:int) -> None\nC++: void SetScatterPlotAxisLabelFontSize(int value)\n\n"},
  {"SetHistogramAxisLabelFontSize", PyvtkPVPlotMatrixView_SetHistogramAxisLabelFontSize, METH_VARARGS,
   "SetHistogramAxisLabelFontSize(self, value:int) -> None\nC++: void SetHistogramAxisLabelFontSize(int value)\n\n"},
  {"SetActivePlotAxisLabelFontSize", PyvtkPVPlotMatrixView_SetActivePlotAxisLabelFontSize, METH_VARARGS,
   "SetActivePlotAxisLabelFontSize(self, value:int) -> None\nC++: void SetActivePlotAxisLabelFontSize(int value)\n\n"},
  {"SetAxisLabelBold", PyvtkPVPlotMatrixView_SetAxisLabelBold, METH_VARARGS,
   "SetAxisLabelBold(self, plotType:int, bold:bool) -> None\nC++: void SetAxisLabelBold(int plotType, bool bold)\n\n"},
  {"SetScatterPlotAxisLabelBold", PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelBold, METH_VARARGS,
   "SetScatterPlotAxisLabelBold(self, value:bool) -> None\nC++: void SetScatterPlotAxisLabelBold(bool value)\n\n"},
  {"SetHistogramAxisLabelBold", PyvtkPVPlotMatrixView_SetHistogramAxisLabelBold, METH_VARARGS,
   "SetHistogramAxisLabelBold(self, value:bool) -> None\nC++: void SetHistogramAxisLabelBold(bool value)\n\n"},
  {"SetActivePlotAxisLabelBold", PyvtkPVPlotMatrixView_SetActivePlotAxisLabelBold, METH_VARARGS,
   "SetActivePlotAxisLabelBold(self, value:bool) -> None\nC++: void SetActivePlotAxisLabelBold(bool value)\n\n"},
  {"SetAxisLabelItalic", PyvtkPVPlotMatrixView_SetAxisLabelItalic, METH_VARARGS,
   "SetAxisLabelItalic(self, plotType:int, italic:bool) -> None\nC++: void SetAxisLabelItalic(int plotType, bool italic)\n\n"},
  {"SetScatterPlotAxisLabelItalic", PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelItalic, METH_VARARGS,
   "SetScatterPlotAxisLabelItalic(self, value:bool) -> None\nC++: void SetScatterPlotAxisLabelItalic(bool value)\n\n"},
  {"SetHistogramAxisLabelItalic", PyvtkPVPlotMatrixView_SetHistogramAxisLabelItalic, METH_VARARGS,
   "SetHistogramAxisLabelItalic(self, value:bool) -> None\nC++: void SetHistogramAxisLabelItalic(bool value)\n\n"},
  {"SetActivePlotAxisLabelItalic", PyvtkPVPlotMatrixView_SetActivePlotAxisLabelItalic, METH_VARARGS,
   "SetActivePlotAxisLabelItalic(self, value:bool) -> None\nC++: void SetActivePlotAxisLabelItalic(bool value)\n\n"},
  {"GetAxisLabelFontFamily", PyvtkPVPlotMatrixView_GetAxisLabelFontFamily, METH_VARARGS,
   "GetAxisLabelFontFamily(self, plotType:int) -> str\nC++: const char *GetAxisLabelFontFamily(int plotType)\n\n"},
  {"GetAxisLabelFontSize", PyvtkPVPlotMatrixView_GetAxisLabelFontSize, METH_VARARGS,
   "GetAxisLabelFontSize(self, plotType:int) -> int\nC++: int GetAxisLabelFontSize(int plotType)\n\n"},
  {"GetAxisLabelFontBold", PyvtkPVPlotMatrixView_GetAxisLabelFontBold, METH_VARARGS,
   "GetAxisLabelFontBold(self, plotType:int) -> int\nC++: int GetAxisLabelFontBold(int plotType)\n\n"},
  {"GetAxisLabelFontItalic", PyvtkPVPlotMatrixView_GetAxisLabelFontItalic, METH_VARARGS,
   "GetAxisLabelFontItalic(self, plotType:int) -> int\nC++: int GetAxisLabelFontItalic(int plotType)\n\n"},
  {"SetAxisLabelColor", PyvtkPVPlotMatrixView_SetAxisLabelColor, METH_VARARGS,
   "SetAxisLabelColor(self, plotType:int, red:float, green:float,\n    blue:float) -> None\nC++: void SetAxisLabelColor(int plotType, double red,\n    double green, double blue)\n\nSets the axis label color for the axes given a plot type, which\nrefers to vtkScatterPlotMatrix::{SCATTERPLOT, HISTOGRAM,\nACTIVEPLOT}. These methods should not be called directly. They\nare made public only so that the client-server-stream-interpreter\ncan invoke them. Use the corresponding properties to change these\nvalues. The getter return false if the color can't be recovered.\n"},
  {"SetScatterPlotAxisLabelColor", PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelColor, METH_VARARGS,
   "SetScatterPlotAxisLabelColor(self, value1:float, value2:float,\n    value3:float) -> None\nC++: void SetScatterPlotAxisLabelColor(double value1,\n    double value2, double value3)\n\n"},
  {"SetHistogramAxisLabelColor", PyvtkPVPlotMatrixView_SetHistogramAxisLabelColor, METH_VARARGS,
   "SetHistogramAxisLabelColor(self, value1:float, value2:float,\n    value3:float) -> None\nC++: void SetHistogramAxisLabelColor(double value1, double value2,\n     double value3)\n\n"},
  {"SetActivePlotAxisLabelColor", PyvtkPVPlotMatrixView_SetActivePlotAxisLabelColor, METH_VARARGS,
   "SetActivePlotAxisLabelColor(self, value1:float, value2:float,\n    value3:float) -> None\nC++: void SetActivePlotAxisLabelColor(double value1,\n    double value2, double value3)\n\n"},
  {"GetAxisLabelColor", PyvtkPVPlotMatrixView_GetAxisLabelColor, METH_VARARGS,
   "GetAxisLabelColor(self, plotType:int, color:[float, float, float])\n     -> bool\nC++: bool GetAxisLabelColor(int plotType, double color[3])\n\n"},
  {"SetAxisLabelNotation", PyvtkPVPlotMatrixView_SetAxisLabelNotation, METH_VARARGS,
   "SetAxisLabelNotation(self, plotType:int, notation:int) -> None\nC++: void SetAxisLabelNotation(int plotType, int notation)\n\nSets the axis label notation for the axes given a plot type,\nwhich refers to vtkScatterPlotMatrix::{SCATTERPLOT, HISTOGRAM,\nACTIVEPLOT}. These methods should not be called directly. They\nare made public only so that the client-server-stream-interpreter\ncan invoke them. Use the corresponding properties to change these\nvalues.\n"},
  {"SetScatterPlotAxisLabelNotation", PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelNotation, METH_VARARGS,
   "SetScatterPlotAxisLabelNotation(self, value:int) -> None\nC++: void SetScatterPlotAxisLabelNotation(int value)\n\n"},
  {"SetHistogramAxisLabelNotation", PyvtkPVPlotMatrixView_SetHistogramAxisLabelNotation, METH_VARARGS,
   "SetHistogramAxisLabelNotation(self, value:int) -> None\nC++: void SetHistogramAxisLabelNotation(int value)\n\n"},
  {"SetActivePlotAxisLabelNotation", PyvtkPVPlotMatrixView_SetActivePlotAxisLabelNotation, METH_VARARGS,
   "SetActivePlotAxisLabelNotation(self, value:int) -> None\nC++: void SetActivePlotAxisLabelNotation(int value)\n\n"},
  {"GetAxisLabelNotation", PyvtkPVPlotMatrixView_GetAxisLabelNotation, METH_VARARGS,
   "GetAxisLabelNotation(self, plotType:int) -> int\nC++: int GetAxisLabelNotation(int plotType)\n\n"},
  {"SetAxisLabelPrecision", PyvtkPVPlotMatrixView_SetAxisLabelPrecision, METH_VARARGS,
   "SetAxisLabelPrecision(self, plotType:int, precision:int) -> None\nC++: void SetAxisLabelPrecision(int plotType, int precision)\n\nSets the axis label precision for the axes given a plot type,\nwhich refers to vtkScatterPlotMatrix::{SCATTERPLOT, HISTOGRAM,\nACTIVEPLOT}. These methods should not be called directly. They\nare made public only so that the client-server-stream-interpreter\ncan invoke them. Use the corresponding properties to change these\nvalues.\n"},
  {"SetScatterPlotAxisLabelPrecision", PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelPrecision, METH_VARARGS,
   "SetScatterPlotAxisLabelPrecision(self, value:int) -> None\nC++: void SetScatterPlotAxisLabelPrecision(int value)\n\n"},
  {"SetHistogramAxisLabelPrecision", PyvtkPVPlotMatrixView_SetHistogramAxisLabelPrecision, METH_VARARGS,
   "SetHistogramAxisLabelPrecision(self, value:int) -> None\nC++: void SetHistogramAxisLabelPrecision(int value)\n\n"},
  {"SetActivePlotAxisLabelPrecision", PyvtkPVPlotMatrixView_SetActivePlotAxisLabelPrecision, METH_VARARGS,
   "SetActivePlotAxisLabelPrecision(self, value:int) -> None\nC++: void SetActivePlotAxisLabelPrecision(int value)\n\n"},
  {"GetAxisLabelPrecision", PyvtkPVPlotMatrixView_GetAxisLabelPrecision, METH_VARARGS,
   "GetAxisLabelPrecision(self, plotType:int) -> int\nC++: int GetAxisLabelPrecision(int plotType)\n\n"},
  {"SetTooltipNotation", PyvtkPVPlotMatrixView_SetTooltipNotation, METH_VARARGS,
   "SetTooltipNotation(self, plotType:int, notation:int) -> None\nC++: void SetTooltipNotation(int plotType, int notation)\n\nSet chart's tooltip notation and precision, given a plot type,\nwhich refers to vtkScatterPlotMatrix::{SCATTERPLOT, HISTOGRAM,\nACTIVEPLOT}. These methods should not be called directly. They\nare made public only so that the client-server-stream-interpreter\ncan invoke them. Use the corresponding properties to change these\nvalues.\n"},
  {"SetScatterPlotTooltipNotation", PyvtkPVPlotMatrixView_SetScatterPlotTooltipNotation, METH_VARARGS,
   "SetScatterPlotTooltipNotation(self, value:int) -> None\nC++: void SetScatterPlotTooltipNotation(int value)\n\n"},
  {"SetHistogramTooltipNotation", PyvtkPVPlotMatrixView_SetHistogramTooltipNotation, METH_VARARGS,
   "SetHistogramTooltipNotation(self, value:int) -> None\nC++: void SetHistogramTooltipNotation(int value)\n\n"},
  {"SetActivePlotTooltipNotation", PyvtkPVPlotMatrixView_SetActivePlotTooltipNotation, METH_VARARGS,
   "SetActivePlotTooltipNotation(self, value:int) -> None\nC++: void SetActivePlotTooltipNotation(int value)\n\n"},
  {"SetTooltipPrecision", PyvtkPVPlotMatrixView_SetTooltipPrecision, METH_VARARGS,
   "SetTooltipPrecision(self, plotType:int, precision:int) -> None\nC++: void SetTooltipPrecision(int plotType, int precision)\n\n"},
  {"SetScatterPlotTooltipPrecision", PyvtkPVPlotMatrixView_SetScatterPlotTooltipPrecision, METH_VARARGS,
   "SetScatterPlotTooltipPrecision(self, value:int) -> None\nC++: void SetScatterPlotTooltipPrecision(int value)\n\n"},
  {"SetHistogramTooltipPrecision", PyvtkPVPlotMatrixView_SetHistogramTooltipPrecision, METH_VARARGS,
   "SetHistogramTooltipPrecision(self, value:int) -> None\nC++: void SetHistogramTooltipPrecision(int value)\n\n"},
  {"SetActivePlotTooltipPrecision", PyvtkPVPlotMatrixView_SetActivePlotTooltipPrecision, METH_VARARGS,
   "SetActivePlotTooltipPrecision(self, value:int) -> None\nC++: void SetActivePlotTooltipPrecision(int value)\n\n"},
  {"GetTooltipNotation", PyvtkPVPlotMatrixView_GetTooltipNotation, METH_VARARGS,
   "GetTooltipNotation(self, plotType:int) -> int\nC++: int GetTooltipNotation(int plotType)\n\n"},
  {"GetTooltipPrecision", PyvtkPVPlotMatrixView_GetTooltipPrecision, METH_VARARGS,
   "GetTooltipPrecision(self, plotType:int) -> int\nC++: int GetTooltipPrecision(int plotType)\n\n"},
  {"SetScatterPlotSelectedRowColumnColor", PyvtkPVPlotMatrixView_SetScatterPlotSelectedRowColumnColor, METH_VARARGS,
   "SetScatterPlotSelectedRowColumnColor(self, red:float, green:float,\n     blue:float, alpha:float) -> None\nC++: void SetScatterPlotSelectedRowColumnColor(double red,\n    double green, double blue, double alpha)\n\nSet the scatter plot title's color. These methods should not be\ncalled directly. They are made public only so that the\nclient-server-stream-interpreter can invoke them. Use the\ncorresponding properties to change these values. The getter\nreturn false if the color can't be recovered.\n"},
  {"GetScatterPlotSelectedRowColumnColor", PyvtkPVPlotMatrixView_GetScatterPlotSelectedRowColumnColor, METH_VARARGS,
   "GetScatterPlotSelectedRowColumnColor(self, color:[float, float,\n    float]) -> bool\nC++: bool GetScatterPlotSelectedRowColumnColor(double color[3])\n\n"},
  {"SetScatterPlotSelectedActiveColor", PyvtkPVPlotMatrixView_SetScatterPlotSelectedActiveColor, METH_VARARGS,
   "SetScatterPlotSelectedActiveColor(self, red:float, green:float,\n    blue:float, alpha:float) -> None\nC++: void SetScatterPlotSelectedActiveColor(double red,\n    double green, double blue, double alpha)\n\nSet the scatter plot title's color. These methods should not be\ncalled directly. They are made public only so that the\nclient-server-stream-interpreter can invoke them. Use the\ncorresponding properties to change these values. The getter\nreturn false if the color can't be recovered.\n"},
  {"GetScatterPlotSelectedActiveColor", PyvtkPVPlotMatrixView_GetScatterPlotSelectedActiveColor, METH_VARARGS,
   "GetScatterPlotSelectedActiveColor(self, color:[float, float,\n    float]) -> bool\nC++: bool GetScatterPlotSelectedActiveColor(double color[3])\n\n"},
  {"UpdateSettings", PyvtkPVPlotMatrixView_UpdateSettings, METH_VARARGS,
   "UpdateSettings(self) -> None\nC++: void UpdateSettings()\n\nUpdate all the settings\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVPlotMatrixView_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("active_plot"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetActivePlot(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetActivePlot(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetActivePlot\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("title_font_family"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPlotMatrixView_GetTitleFontFamily(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetTitleFontFamily(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetTitleFontFamily(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTitleFontFamily/SetTitleFontFamily\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("title_font_size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPlotMatrixView_GetTitleFontSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetTitleFontSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetTitleFontSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTitleFontSize/SetTitleFontSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("title_bold"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetTitleBold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetTitleBold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTitleBold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("title_italic"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetTitleItalic(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetTitleItalic(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTitleItalic\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("title_font_file"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetTitleFontFile(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetTitleFontFile(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTitleFontFile\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("title_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetTitleColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetTitleColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTitleColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("title_alignment"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPlotMatrixView_GetTitleAlignment(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetTitleAlignment(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetTitleAlignment(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTitleAlignment/SetTitleAlignment\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("gutter"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetGutter(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetGutter(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetGutter\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("gutter_x"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetGutterX(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetGutterX(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetGutterX\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("gutter_y"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetGutterY(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetGutterY(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetGutterY\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("padding"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetPadding(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetPadding(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPadding\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("borders"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetBorders(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetBorders(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBorders\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("border_left"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetBorderLeft(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetBorderLeft(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBorderLeft\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("border_bottom"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetBorderBottom(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetBorderBottom(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBorderBottom\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("border_right"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetBorderRight(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetBorderRight(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBorderRight\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("border_top"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetBorderTop(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetBorderTop(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBorderTop\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("scatter_plot_grid_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotGridVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotGridVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetScatterPlotGridVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("histogram_grid_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetHistogramGridVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetHistogramGridVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetHistogramGridVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_plot_grid_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetActivePlotGridVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetActivePlotGridVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetActivePlotGridVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("scatter_plot_background_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotBackgroundColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotBackgroundColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetScatterPlotBackgroundColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("histogram_background_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetHistogramBackgroundColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetHistogramBackgroundColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetHistogramBackgroundColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_plot_background_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetActivePlotBackgroundColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetActivePlotBackgroundColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetActivePlotBackgroundColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("scatter_plot_axis_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotAxisColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotAxisColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetScatterPlotAxisColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("histogram_axis_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetHistogramAxisColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetHistogramAxisColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetHistogramAxisColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_plot_axis_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetActivePlotAxisColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetActivePlotAxisColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetActivePlotAxisColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("scatter_plot_grid_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotGridColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotGridColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetScatterPlotGridColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("histogram_grid_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetHistogramGridColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetHistogramGridColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetHistogramGridColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_plot_grid_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetActivePlotGridColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetActivePlotGridColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetActivePlotGridColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("scatter_plot_axis_label_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetScatterPlotAxisLabelVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("histogram_axis_label_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetHistogramAxisLabelVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetHistogramAxisLabelVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetHistogramAxisLabelVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_plot_axis_label_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetActivePlotAxisLabelVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetActivePlotAxisLabelVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetActivePlotAxisLabelVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("scatter_plot_axis_label_font_family"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelFontFamily(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelFontFamily(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetScatterPlotAxisLabelFontFamily\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("histogram_axis_label_font_family"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetHistogramAxisLabelFontFamily(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetHistogramAxisLabelFontFamily(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetHistogramAxisLabelFontFamily\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_plot_axis_label_font_family"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetActivePlotAxisLabelFontFamily(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetActivePlotAxisLabelFontFamily(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetActivePlotAxisLabelFontFamily\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("scatter_plot_axis_label_font_file"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelFontFile(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelFontFile(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetScatterPlotAxisLabelFontFile\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("histogram_axis_label_font_file"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetHistogramAxisLabelFontFile(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetHistogramAxisLabelFontFile(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetHistogramAxisLabelFontFile\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_plot_axis_label_font_file"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetActivePlotAxisLabelFontFile(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetActivePlotAxisLabelFontFile(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetActivePlotAxisLabelFontFile\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("axis_label_font_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetAxisLabelFontSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetAxisLabelFontSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetAxisLabelFontSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("scatter_plot_axis_label_font_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelFontSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelFontSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetScatterPlotAxisLabelFontSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("histogram_axis_label_font_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetHistogramAxisLabelFontSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetHistogramAxisLabelFontSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetHistogramAxisLabelFontSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_plot_axis_label_font_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetActivePlotAxisLabelFontSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetActivePlotAxisLabelFontSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetActivePlotAxisLabelFontSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("scatter_plot_axis_label_bold"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelBold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelBold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetScatterPlotAxisLabelBold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("histogram_axis_label_bold"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetHistogramAxisLabelBold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetHistogramAxisLabelBold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetHistogramAxisLabelBold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_plot_axis_label_bold"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetActivePlotAxisLabelBold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetActivePlotAxisLabelBold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetActivePlotAxisLabelBold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("scatter_plot_axis_label_italic"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelItalic(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelItalic(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetScatterPlotAxisLabelItalic\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("histogram_axis_label_italic"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetHistogramAxisLabelItalic(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetHistogramAxisLabelItalic(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetHistogramAxisLabelItalic\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_plot_axis_label_italic"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetActivePlotAxisLabelItalic(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetActivePlotAxisLabelItalic(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetActivePlotAxisLabelItalic\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("scatter_plot_axis_label_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetScatterPlotAxisLabelColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("histogram_axis_label_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetHistogramAxisLabelColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetHistogramAxisLabelColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetHistogramAxisLabelColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_plot_axis_label_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetActivePlotAxisLabelColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetActivePlotAxisLabelColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetActivePlotAxisLabelColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("axis_label_notation"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetAxisLabelNotation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetAxisLabelNotation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetAxisLabelNotation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("scatter_plot_axis_label_notation"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelNotation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelNotation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetScatterPlotAxisLabelNotation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("histogram_axis_label_notation"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetHistogramAxisLabelNotation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetHistogramAxisLabelNotation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetHistogramAxisLabelNotation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_plot_axis_label_notation"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetActivePlotAxisLabelNotation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetActivePlotAxisLabelNotation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetActivePlotAxisLabelNotation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("axis_label_precision"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetAxisLabelPrecision(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetAxisLabelPrecision(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetAxisLabelPrecision\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("scatter_plot_axis_label_precision"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelPrecision(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotAxisLabelPrecision(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetScatterPlotAxisLabelPrecision\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("histogram_axis_label_precision"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetHistogramAxisLabelPrecision(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetHistogramAxisLabelPrecision(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetHistogramAxisLabelPrecision\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_plot_axis_label_precision"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetActivePlotAxisLabelPrecision(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetActivePlotAxisLabelPrecision(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetActivePlotAxisLabelPrecision\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tooltip_notation"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetTooltipNotation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetTooltipNotation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTooltipNotation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("scatter_plot_tooltip_notation"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotTooltipNotation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotTooltipNotation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetScatterPlotTooltipNotation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("histogram_tooltip_notation"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetHistogramTooltipNotation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetHistogramTooltipNotation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetHistogramTooltipNotation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_plot_tooltip_notation"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetActivePlotTooltipNotation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetActivePlotTooltipNotation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetActivePlotTooltipNotation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tooltip_precision"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetTooltipPrecision(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetTooltipPrecision(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTooltipPrecision\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("scatter_plot_tooltip_precision"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotTooltipPrecision(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotTooltipPrecision(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetScatterPlotTooltipPrecision\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("histogram_tooltip_precision"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetHistogramTooltipPrecision(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetHistogramTooltipPrecision(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetHistogramTooltipPrecision\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_plot_tooltip_precision"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetActivePlotTooltipPrecision(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetActivePlotTooltipPrecision(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetActivePlotTooltipPrecision\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("scatter_plot_selected_row_column_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotSelectedRowColumnColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotSelectedRowColumnColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetScatterPlotSelectedRowColumnColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("scatter_plot_selected_active_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotSelectedActiveColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetScatterPlotSelectedActiveColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetScatterPlotSelectedActiveColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("context_item"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPlotMatrixView_GetContextItem(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetContextItem\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_row"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPlotMatrixView_GetActiveRow(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetActiveRow\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_column"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPlotMatrixView_GetActiveColumn(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetActiveColumn\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("title_font_bold"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPlotMatrixView_GetTitleFontBold(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTitleFontBold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("title_font_italic"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPlotMatrixView_GetTitleFontItalic(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTitleFontItalic\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("title_color"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPlotMatrixView_GetTitleColor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTitleColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_animation_frames"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixView_SetNumberOfAnimationFrames(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixView_SetNumberOfAnimationFrames(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNumberOfAnimationFrames\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVPlotMatrixView_Doc =
  "vtkPVPlotMatrixView - no description provided.\n\n"
  "Superclass: vtkPVContextView\n\n"
;

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVPlotMatrixView_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPVPlotMatrixView", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVPlotMatrixView_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVPlotMatrixView_StaticNew()
{
  return vtkPVPlotMatrixView::New();
}

PyObject *PyvtkPVPlotMatrixView_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVPlotMatrixView_Type, PyvtkPVPlotMatrixView_Methods,
    "vtkPVPlotMatrixView",
 &PyvtkPVPlotMatrixView_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkPVContextView_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVPlotMatrixView_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVPlotMatrixView(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVPlotMatrixView_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVPlotMatrixView", o) != 0)
  {
    Py_DECREF(o);
  }

}

