#include "nv_push_clb197.h"

#include <stdio.h>





const char *P_PARSE_NVB097_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NVB097_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                                   const char *prefix) ATTRIBUTE_COLD;

const char*
P_PARSE_NVB197_MTHD(uint16_t idx)
{
    switch (idx) {

  
    default:

    return P_PARSE_NVB097_MTHD(idx);

                                                                                                                                                                                                                                                                                                                                                                                                                                            case NVB197_SET_HYBRID_ANTI_ALIAS_CONTROL:
        return "NVB197_SET_HYBRID_ANTI_ALIAS_CONTROL";
                                                                                                                                                        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(0):
        return "NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(0)";
    case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(1):
        return "NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(1)";
    case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(2):
        return "NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(2)";
    case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(3):
        return "NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(3)";
    case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(4):
        return "NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(4)";
    case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(5):
        return "NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(5)";
    case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(6):
        return "NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(6)";
    case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(7):
        return "NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(7)";
    case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(8):
        return "NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(8)";
    case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(9):
        return "NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(9)";
    case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(10):
        return "NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(10)";
    case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(11):
        return "NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(11)";
    case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(12):
        return "NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(12)";
    case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(13):
        return "NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(13)";
    case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(14):
        return "NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(14)";
    case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(15):
        return "NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(15)";
    case NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(0):
        return "NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(0)";
    case NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(1):
        return "NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(1)";
    case NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(2):
        return "NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(2)";
    case NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(3):
        return "NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(3)";
    case NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(4):
        return "NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(4)";
    case NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(5):
        return "NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(5)";
    case NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(6):
        return "NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(6)";
    case NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(7):
        return "NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(7)";
    case NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(8):
        return "NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(8)";
    case NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(9):
        return "NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(9)";
    case NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(10):
        return "NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(10)";
    case NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(11):
        return "NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(11)";
    case NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(12):
        return "NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(12)";
    case NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(13):
        return "NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(13)";
    case NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(14):
        return "NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(14)";
    case NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(15):
        return "NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(15)";
                                                                                                                                                                                                        case NVB197_SET_POST_Z_PS_IMASK:
        return "NVB197_SET_POST_Z_PS_IMASK";
                                                                case NVB197_SET_SAMPLE_MASK:
        return "NVB197_SET_SAMPLE_MASK";
    case NVB197_SET_COLOR_TARGET_SAMPLE_MASK:
        return "NVB197_SET_COLOR_TARGET_SAMPLE_MASK";
            case NVB197_SET_TIR:
        return "NVB197_SET_TIR";
    case NVB197_SET_ANTI_ALIAS_RASTER:
        return "NVB197_SET_ANTI_ALIAS_RASTER";
                            case NVB197_SET_TIR_MODULATION:
        return "NVB197_SET_TIR_MODULATION";
    case NVB197_SET_TIR_MODULATION_FUNCTION:
        return "NVB197_SET_TIR_MODULATION_FUNCTION";
                case NVB197_SET_ZT_FORMAT:
        return "NVB197_SET_ZT_FORMAT";
                            case NVB197_SET_VIEWPORT_MULTICAST:
        return "NVB197_SET_VIEWPORT_MULTICAST";
                                                                                                                                                                                                                    case NVB197_SET_STENCIL_COMPRESSION:
        return "NVB197_SET_STENCIL_COMPRESSION";
            case NVB197_SET_TIR_CONTROL:
        return "NVB197_SET_TIR_CONTROL";
    case NVB197_SET_MUTABLE_METHOD_CONTROL:
        return "NVB197_SET_MUTABLE_METHOD_CONTROL";
    case NVB197_SET_POST_PS_INITIAL_COVERAGE:
        return "NVB197_SET_POST_PS_INITIAL_COVERAGE";
    case NVB197_SET_FILL_VIA_TRIANGLE:
        return "NVB197_SET_FILL_VIA_TRIANGLE";
            case NVB197_SET_CONSERVATIVE_RASTER:
        return "NVB197_SET_CONSERVATIVE_RASTER";
            case NVB197_SET_ANTI_ALIAS_SAMPLE_POSITIONS(0):
        return "NVB197_SET_ANTI_ALIAS_SAMPLE_POSITIONS(0)";
    case NVB197_SET_ANTI_ALIAS_SAMPLE_POSITIONS(1):
        return "NVB197_SET_ANTI_ALIAS_SAMPLE_POSITIONS(1)";
    case NVB197_SET_ANTI_ALIAS_SAMPLE_POSITIONS(2):
        return "NVB197_SET_ANTI_ALIAS_SAMPLE_POSITIONS(2)";
    case NVB197_SET_ANTI_ALIAS_SAMPLE_POSITIONS(3):
        return "NVB197_SET_ANTI_ALIAS_SAMPLE_POSITIONS(3)";
    case NVB197_SET_OFFSET_RENDER_TARGET_INDEX:
        return "NVB197_SET_OFFSET_RENDER_TARGET_INDEX";
    case NVB197_FORCE_HEAVYWEIGHT_METHOD_SYNC:
        return "NVB197_FORCE_HEAVYWEIGHT_METHOD_SYNC";
    case NVB197_SET_COVERAGE_TO_COLOR:
        return "NVB197_SET_COVERAGE_TO_COLOR";
    case NVB197_DECOMPRESS_ZETA_SURFACE:
        return "NVB197_DECOMPRESS_ZETA_SURFACE";
    case NVB197_SET_ZT_SPARSE:
        return "NVB197_SET_ZT_SPARSE";
    case NVB197_INVALIDATE_SAMPLER_CACHE_ALL:
        return "NVB197_INVALIDATE_SAMPLER_CACHE_ALL";
    case NVB197_INVALIDATE_TEXTURE_HEADER_CACHE_ALL:
        return "NVB197_INVALIDATE_TEXTURE_HEADER_CACHE_ALL";
                    case NVB197_SET_PIXEL_SHADER_INTERLOCK_CONTROL:
        return "NVB197_SET_PIXEL_SHADER_INTERLOCK_CONTROL";
                            case NVB197_SET_PIXEL_SHADER_TICKET_DISPENSER_VALUE:
        return "NVB197_SET_PIXEL_SHADER_TICKET_DISPENSER_VALUE";
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            case NVB197_SET_VIEWPORT_CLIP_CONTROL:
        return "NVB197_SET_VIEWPORT_CLIP_CONTROL";
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            
    }
}

void
P_DUMP_NVB197_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                         const char *prefix)
{
    UNUSED uint32_t parsed;
    switch (idx) {

  
    default:

    P_DUMP_NVB097_MTHD_DATA(fp, idx, data, prefix);
    break;

                                                                                                                                                                                                                                                                                                                                                                                                                                          
    case NVB197_SET_HYBRID_ANTI_ALIAS_CONTROL:

    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.PASSES = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.CENTROID = ", prefix);
        switch (parsed) {
        case NVB197_SET_HYBRID_ANTI_ALIAS_CONTROL_CENTROID_PER_FRAGMENT:
            fprintf(fp, "PER_FRAGMENT\n");
            break;
        case NVB197_SET_HYBRID_ANTI_ALIAS_CONTROL_CENTROID_PER_PASS:
            fprintf(fp, "PER_PASS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 1) - 1);
        fprintf(fp, "%s.PASSES_EXTENDED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                                                                                                                                      
    case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(0):
    case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(1):
    case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(2):
    case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(3):
    case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(4):
    case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(5):
    case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(6):
    case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(7):
    case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(8):
    case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(9):
    case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(10):
    case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(11):
    case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(12):
    case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(13):
    case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(14):
    case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE(15):

    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.X = ", prefix);
        switch (parsed) {
        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE_X_POS_X:
            fprintf(fp, "POS_X\n");
            break;
        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE_X_NEG_X:
            fprintf(fp, "NEG_X\n");
            break;
        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE_X_POS_Y:
            fprintf(fp, "POS_Y\n");
            break;
        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE_X_NEG_Y:
            fprintf(fp, "NEG_Y\n");
            break;
        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE_X_POS_Z:
            fprintf(fp, "POS_Z\n");
            break;
        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE_X_NEG_Z:
            fprintf(fp, "NEG_Z\n");
            break;
        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE_X_POS_W:
            fprintf(fp, "POS_W\n");
            break;
        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE_X_NEG_W:
            fprintf(fp, "NEG_W\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 3) - 1);
        fprintf(fp, "%s.Y = ", prefix);
        switch (parsed) {
        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE_Y_POS_X:
            fprintf(fp, "POS_X\n");
            break;
        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE_Y_NEG_X:
            fprintf(fp, "NEG_X\n");
            break;
        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE_Y_POS_Y:
            fprintf(fp, "POS_Y\n");
            break;
        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE_Y_NEG_Y:
            fprintf(fp, "NEG_Y\n");
            break;
        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE_Y_POS_Z:
            fprintf(fp, "POS_Z\n");
            break;
        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE_Y_NEG_Z:
            fprintf(fp, "NEG_Z\n");
            break;
        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE_Y_POS_W:
            fprintf(fp, "POS_W\n");
            break;
        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE_Y_NEG_W:
            fprintf(fp, "NEG_W\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 3) - 1);
        fprintf(fp, "%s.Z = ", prefix);
        switch (parsed) {
        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE_Z_POS_X:
            fprintf(fp, "POS_X\n");
            break;
        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE_Z_NEG_X:
            fprintf(fp, "NEG_X\n");
            break;
        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE_Z_POS_Y:
            fprintf(fp, "POS_Y\n");
            break;
        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE_Z_NEG_Y:
            fprintf(fp, "NEG_Y\n");
            break;
        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE_Z_POS_Z:
            fprintf(fp, "POS_Z\n");
            break;
        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE_Z_NEG_Z:
            fprintf(fp, "NEG_Z\n");
            break;
        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE_Z_POS_W:
            fprintf(fp, "POS_W\n");
            break;
        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE_Z_NEG_W:
            fprintf(fp, "NEG_W\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 3) - 1);
        fprintf(fp, "%s.W = ", prefix);
        switch (parsed) {
        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE_W_POS_X:
            fprintf(fp, "POS_X\n");
            break;
        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE_W_NEG_X:
            fprintf(fp, "NEG_X\n");
            break;
        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE_W_POS_Y:
            fprintf(fp, "POS_Y\n");
            break;
        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE_W_NEG_Y:
            fprintf(fp, "NEG_Y\n");
            break;
        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE_W_POS_Z:
            fprintf(fp, "POS_Z\n");
            break;
        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE_W_NEG_Z:
            fprintf(fp, "NEG_Z\n");
            break;
        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE_W_POS_W:
            fprintf(fp, "POS_W\n");
            break;
        case NVB197_SET_VIEWPORT_COORDINATE_SWIZZLE_W_NEG_W:
            fprintf(fp, "NEG_W\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(0):
    case NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(1):
    case NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(2):
    case NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(3):
    case NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(4):
    case NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(5):
    case NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(6):
    case NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(7):
    case NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(8):
    case NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(9):
    case NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(10):
    case NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(11):
    case NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(12):
    case NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(13):
    case NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(14):
    case NVB197_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(15):

    
        parsed = (data >> 0) & ((1u << 5) - 1);
        fprintf(fp, "%s.X_BITS = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 5) - 1);
        fprintf(fp, "%s.Y_BITS = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                                                                                                                                                                                      
    case NVB197_SET_POST_Z_PS_IMASK:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVB197_SET_POST_Z_PS_IMASK_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVB197_SET_POST_Z_PS_IMASK_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
                                                              
    case NVB197_SET_SAMPLE_MASK:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.RASTER_OUT_ENABLE = ", prefix);
        switch (parsed) {
        case NVB197_SET_SAMPLE_MASK_RASTER_OUT_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVB197_SET_SAMPLE_MASK_RASTER_OUT_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.COLOR_TARGET_ENABLE = ", prefix);
        switch (parsed) {
        case NVB197_SET_SAMPLE_MASK_COLOR_TARGET_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVB197_SET_SAMPLE_MASK_COLOR_TARGET_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NVB197_SET_COLOR_TARGET_SAMPLE_MASK:

    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
          
    case NVB197_SET_TIR:

    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NVB197_SET_TIR_MODE_DISABLED:
            fprintf(fp, "DISABLED\n");
            break;
        case NVB197_SET_TIR_MODE_RASTER_N_TARGET_M:
            fprintf(fp, "RASTER_N_TARGET_M\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NVB197_SET_ANTI_ALIAS_RASTER:

    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.SAMPLES = ", prefix);
        switch (parsed) {
        case NVB197_SET_ANTI_ALIAS_RASTER_SAMPLES_MODE_1X1:
            fprintf(fp, "MODE_1X1\n");
            break;
        case NVB197_SET_ANTI_ALIAS_RASTER_SAMPLES_MODE_2X2:
            fprintf(fp, "MODE_2X2\n");
            break;
        case NVB197_SET_ANTI_ALIAS_RASTER_SAMPLES_MODE_4X2_D3D:
            fprintf(fp, "MODE_4X2_D3D\n");
            break;
        case NVB197_SET_ANTI_ALIAS_RASTER_SAMPLES_MODE_2X1_D3D:
            fprintf(fp, "MODE_2X1_D3D\n");
            break;
        case NVB197_SET_ANTI_ALIAS_RASTER_SAMPLES_MODE_4X4:
            fprintf(fp, "MODE_4X4\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
                          
    case NVB197_SET_TIR_MODULATION:

    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.COMPONENT_SELECT = ", prefix);
        switch (parsed) {
        case NVB197_SET_TIR_MODULATION_COMPONENT_SELECT_NO_MODULATION:
            fprintf(fp, "NO_MODULATION\n");
            break;
        case NVB197_SET_TIR_MODULATION_COMPONENT_SELECT_MODULATE_RGB:
            fprintf(fp, "MODULATE_RGB\n");
            break;
        case NVB197_SET_TIR_MODULATION_COMPONENT_SELECT_MODULATE_ALPHA_ONLY:
            fprintf(fp, "MODULATE_ALPHA_ONLY\n");
            break;
        case NVB197_SET_TIR_MODULATION_COMPONENT_SELECT_MODULATE_RGBA:
            fprintf(fp, "MODULATE_RGBA\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NVB197_SET_TIR_MODULATION_FUNCTION:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.SELECT = ", prefix);
        switch (parsed) {
        case NVB197_SET_TIR_MODULATION_FUNCTION_SELECT_LINEAR:
            fprintf(fp, "LINEAR\n");
            break;
        case NVB197_SET_TIR_MODULATION_FUNCTION_SELECT_TABLE:
            fprintf(fp, "TABLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
              
    case NVB197_SET_ZT_FORMAT:

    
        parsed = (data >> 0) & ((1u << 5) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVB197_SET_ZT_FORMAT_V_Z16:
            fprintf(fp, "Z16\n");
            break;
        case NVB197_SET_ZT_FORMAT_V_Z24S8:
            fprintf(fp, "Z24S8\n");
            break;
        case NVB197_SET_ZT_FORMAT_V_X8Z24:
            fprintf(fp, "X8Z24\n");
            break;
        case NVB197_SET_ZT_FORMAT_V_S8Z24:
            fprintf(fp, "S8Z24\n");
            break;
        case NVB197_SET_ZT_FORMAT_V_S8:
            fprintf(fp, "S8\n");
            break;
        case NVB197_SET_ZT_FORMAT_V_V8Z24:
            fprintf(fp, "V8Z24\n");
            break;
        case NVB197_SET_ZT_FORMAT_V_ZF32:
            fprintf(fp, "ZF32\n");
            break;
        case NVB197_SET_ZT_FORMAT_V_ZF32_X24S8:
            fprintf(fp, "ZF32_X24S8\n");
            break;
        case NVB197_SET_ZT_FORMAT_V_X8Z24_X16V8S8:
            fprintf(fp, "X8Z24_X16V8S8\n");
            break;
        case NVB197_SET_ZT_FORMAT_V_ZF32_X16V8X8:
            fprintf(fp, "ZF32_X16V8X8\n");
            break;
        case NVB197_SET_ZT_FORMAT_V_ZF32_X16V8S8:
            fprintf(fp, "ZF32_X16V8S8\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
                          
    case NVB197_SET_VIEWPORT_MULTICAST:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ORDER = ", prefix);
        switch (parsed) {
        case NVB197_SET_VIEWPORT_MULTICAST_ORDER_VIEWPORT_ORDER:
            fprintf(fp, "VIEWPORT_ORDER\n");
            break;
        case NVB197_SET_VIEWPORT_MULTICAST_ORDER_PRIMITIVE_ORDER:
            fprintf(fp, "PRIMITIVE_ORDER\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
                                                                                                                                                                                                                  
    case NVB197_SET_STENCIL_COMPRESSION:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVB197_SET_STENCIL_COMPRESSION_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVB197_SET_STENCIL_COMPRESSION_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
          
    case NVB197_SET_TIR_CONTROL:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.Z_PASS_PIXEL_COUNT_USE_RASTER_SAMPLES = ", prefix);
        switch (parsed) {
        case NVB197_SET_TIR_CONTROL_Z_PASS_PIXEL_COUNT_USE_RASTER_SAMPLES_DISABLE:
            fprintf(fp, "DISABLE\n");
            break;
        case NVB197_SET_TIR_CONTROL_Z_PASS_PIXEL_COUNT_USE_RASTER_SAMPLES_ENABLE:
            fprintf(fp, "ENABLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.ALPHA_TO_COVERAGE_USE_RASTER_SAMPLES = ", prefix);
        switch (parsed) {
        case NVB197_SET_TIR_CONTROL_ALPHA_TO_COVERAGE_USE_RASTER_SAMPLES_DISABLE:
            fprintf(fp, "DISABLE\n");
            break;
        case NVB197_SET_TIR_CONTROL_ALPHA_TO_COVERAGE_USE_RASTER_SAMPLES_ENABLE:
            fprintf(fp, "ENABLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.REDUCE_COVERAGE = ", prefix);
        switch (parsed) {
        case NVB197_SET_TIR_CONTROL_REDUCE_COVERAGE_DISABLE:
            fprintf(fp, "DISABLE\n");
            break;
        case NVB197_SET_TIR_CONTROL_REDUCE_COVERAGE_ENABLE:
            fprintf(fp, "ENABLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NVB197_SET_MUTABLE_METHOD_CONTROL:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.TREAT_MUTABLE_AS_HEAVYWEIGHT = ", prefix);
        switch (parsed) {
        case NVB197_SET_MUTABLE_METHOD_CONTROL_TREAT_MUTABLE_AS_HEAVYWEIGHT_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVB197_SET_MUTABLE_METHOD_CONTROL_TREAT_MUTABLE_AS_HEAVYWEIGHT_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NVB197_SET_POST_PS_INITIAL_COVERAGE:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.USE_PRE_PS_COVERAGE = ", prefix);
        switch (parsed) {
        case NVB197_SET_POST_PS_INITIAL_COVERAGE_USE_PRE_PS_COVERAGE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVB197_SET_POST_PS_INITIAL_COVERAGE_USE_PRE_PS_COVERAGE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NVB197_SET_FILL_VIA_TRIANGLE:

    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NVB197_SET_FILL_VIA_TRIANGLE_MODE_DISABLED:
            fprintf(fp, "DISABLED\n");
            break;
        case NVB197_SET_FILL_VIA_TRIANGLE_MODE_FILL_ALL:
            fprintf(fp, "FILL_ALL\n");
            break;
        case NVB197_SET_FILL_VIA_TRIANGLE_MODE_FILL_BBOX:
            fprintf(fp, "FILL_BBOX\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
          
    case NVB197_SET_CONSERVATIVE_RASTER:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVB197_SET_CONSERVATIVE_RASTER_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVB197_SET_CONSERVATIVE_RASTER_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
          
    case NVB197_SET_ANTI_ALIAS_SAMPLE_POSITIONS(0):
    case NVB197_SET_ANTI_ALIAS_SAMPLE_POSITIONS(1):
    case NVB197_SET_ANTI_ALIAS_SAMPLE_POSITIONS(2):
    case NVB197_SET_ANTI_ALIAS_SAMPLE_POSITIONS(3):

    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.X0 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 4) & ((1u << 4) - 1);
        fprintf(fp, "%s.Y0 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 4) - 1);
        fprintf(fp, "%s.X1 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 12) & ((1u << 4) - 1);
        fprintf(fp, "%s.Y1 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 4) - 1);
        fprintf(fp, "%s.X2 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 20) & ((1u << 4) - 1);
        fprintf(fp, "%s.Y2 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 24) & ((1u << 4) - 1);
        fprintf(fp, "%s.X3 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 28) & ((1u << 4) - 1);
        fprintf(fp, "%s.Y3 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVB197_SET_OFFSET_RENDER_TARGET_INDEX:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.BY_VIEWPORT_INDEX = ", prefix);
        switch (parsed) {
        case NVB197_SET_OFFSET_RENDER_TARGET_INDEX_BY_VIEWPORT_INDEX_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVB197_SET_OFFSET_RENDER_TARGET_INDEX_BY_VIEWPORT_INDEX_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NVB197_FORCE_HEAVYWEIGHT_METHOD_SYNC:

    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVB197_SET_COVERAGE_TO_COLOR:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVB197_SET_COVERAGE_TO_COLOR_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVB197_SET_COVERAGE_TO_COLOR_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 3) - 1);
        fprintf(fp, "%s.CT_SELECT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVB197_DECOMPRESS_ZETA_SURFACE:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.Z_ENABLE = ", prefix);
        switch (parsed) {
        case NVB197_DECOMPRESS_ZETA_SURFACE_Z_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVB197_DECOMPRESS_ZETA_SURFACE_Z_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.STENCIL_ENABLE = ", prefix);
        switch (parsed) {
        case NVB197_DECOMPRESS_ZETA_SURFACE_STENCIL_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVB197_DECOMPRESS_ZETA_SURFACE_STENCIL_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NVB197_SET_ZT_SPARSE:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVB197_SET_ZT_SPARSE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVB197_SET_ZT_SPARSE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.UNMAPPED_COMPARE = ", prefix);
        switch (parsed) {
        case NVB197_SET_ZT_SPARSE_UNMAPPED_COMPARE_ZT_SPARSE_UNMAPPED_0:
            fprintf(fp, "ZT_SPARSE_UNMAPPED_0\n");
            break;
        case NVB197_SET_ZT_SPARSE_UNMAPPED_COMPARE_ZT_SPARSE_FAIL_ALWAYS:
            fprintf(fp, "ZT_SPARSE_FAIL_ALWAYS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NVB197_INVALIDATE_SAMPLER_CACHE_ALL:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVB197_INVALIDATE_TEXTURE_HEADER_CACHE_ALL:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                  
    case NVB197_SET_PIXEL_SHADER_INTERLOCK_CONTROL:

    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.TILE_COALESCER_MODE = ", prefix);
        switch (parsed) {
        case NVB197_SET_PIXEL_SHADER_INTERLOCK_CONTROL_TILE_COALESCER_MODE_NO_CONFLICT_DETECT:
            fprintf(fp, "NO_CONFLICT_DETECT\n");
            break;
        case NVB197_SET_PIXEL_SHADER_INTERLOCK_CONTROL_TILE_COALESCER_MODE_CONFLICT_DETECT_SAMPLE:
            fprintf(fp, "CONFLICT_DETECT_SAMPLE\n");
            break;
        case NVB197_SET_PIXEL_SHADER_INTERLOCK_CONTROL_TILE_COALESCER_MODE_CONFLICT_DETECT_PIXEL:
            fprintf(fp, "CONFLICT_DETECT_PIXEL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.TILE_COALESCER_TILE_SIZE = ", prefix);
        switch (parsed) {
        case NVB197_SET_PIXEL_SHADER_INTERLOCK_CONTROL_TILE_COALESCER_TILE_SIZE_TC_TILE_SIZE_16X16:
            fprintf(fp, "TC_TILE_SIZE_16X16\n");
            break;
        case NVB197_SET_PIXEL_SHADER_INTERLOCK_CONTROL_TILE_COALESCER_TILE_SIZE_TC_TILE_SIZE_8X8:
            fprintf(fp, "TC_TILE_SIZE_8X8\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 1) - 1);
        fprintf(fp, "%s.TILE_COALESCER_FRAGMENT_ORDER = ", prefix);
        switch (parsed) {
        case NVB197_SET_PIXEL_SHADER_INTERLOCK_CONTROL_TILE_COALESCER_FRAGMENT_ORDER_TC_FRAGMENT_ORDERED:
            fprintf(fp, "TC_FRAGMENT_ORDERED\n");
            break;
        case NVB197_SET_PIXEL_SHADER_INTERLOCK_CONTROL_TILE_COALESCER_FRAGMENT_ORDER_TC_FRAGMENT_UNORDERED:
            fprintf(fp, "TC_FRAGMENT_UNORDERED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
                          
    case NVB197_SET_PIXEL_SHADER_TICKET_DISPENSER_VALUE:

    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.TICKET_DISPENSER_INDEX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 16) - 1);
        fprintf(fp, "%s.TICKET_DISPENSER_VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          
    case NVB197_SET_VIEWPORT_CLIP_CONTROL:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.MIN_Z_ZERO_MAX_Z_ONE = ", prefix);
        switch (parsed) {
        case NVB197_SET_VIEWPORT_CLIP_CONTROL_MIN_Z_ZERO_MAX_Z_ONE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVB197_SET_VIEWPORT_CLIP_CONTROL_MIN_Z_ZERO_MAX_Z_ONE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 1) - 1);
        fprintf(fp, "%s.PIXEL_MIN_Z = ", prefix);
        switch (parsed) {
        case NVB197_SET_VIEWPORT_CLIP_CONTROL_PIXEL_MIN_Z_CLIP:
            fprintf(fp, "CLIP\n");
            break;
        case NVB197_SET_VIEWPORT_CLIP_CONTROL_PIXEL_MIN_Z_CLAMP:
            fprintf(fp, "CLAMP\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.PIXEL_MAX_Z = ", prefix);
        switch (parsed) {
        case NVB197_SET_VIEWPORT_CLIP_CONTROL_PIXEL_MAX_Z_CLIP:
            fprintf(fp, "CLIP\n");
            break;
        case NVB197_SET_VIEWPORT_CLIP_CONTROL_PIXEL_MAX_Z_CLAMP:
            fprintf(fp, "CLAMP\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 7) & ((1u << 1) - 1);
        fprintf(fp, "%s.GEOMETRY_GUARDBAND = ", prefix);
        switch (parsed) {
        case NVB197_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_GUARDBAND_SCALE_256:
            fprintf(fp, "SCALE_256\n");
            break;
        case NVB197_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_GUARDBAND_SCALE_1:
            fprintf(fp, "SCALE_1\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 10) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINE_POINT_CULL_GUARDBAND = ", prefix);
        switch (parsed) {
        case NVB197_SET_VIEWPORT_CLIP_CONTROL_LINE_POINT_CULL_GUARDBAND_SCALE_256:
            fprintf(fp, "SCALE_256\n");
            break;
        case NVB197_SET_VIEWPORT_CLIP_CONTROL_LINE_POINT_CULL_GUARDBAND_SCALE_1:
            fprintf(fp, "SCALE_1\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 11) & ((1u << 3) - 1);
        fprintf(fp, "%s.GEOMETRY_CLIP = ", prefix);
        switch (parsed) {
        case NVB197_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_WZERO_CLIP:
            fprintf(fp, "WZERO_CLIP\n");
            break;
        case NVB197_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_PASSTHRU:
            fprintf(fp, "PASSTHRU\n");
            break;
        case NVB197_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_FRUSTUM_XY_CLIP:
            fprintf(fp, "FRUSTUM_XY_CLIP\n");
            break;
        case NVB197_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_FRUSTUM_XYZ_CLIP:
            fprintf(fp, "FRUSTUM_XYZ_CLIP\n");
            break;
        case NVB197_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_WZERO_CLIP_NO_Z_CULL:
            fprintf(fp, "WZERO_CLIP_NO_Z_CULL\n");
            break;
        case NVB197_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_FRUSTUM_Z_CLIP:
            fprintf(fp, "FRUSTUM_Z_CLIP\n");
            break;
        case NVB197_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_WZERO_TRI_FILL_OR_CLIP:
            fprintf(fp, "WZERO_TRI_FILL_OR_CLIP\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 2) - 1);
        fprintf(fp, "%s.GEOMETRY_GUARDBAND_Z = ", prefix);
        switch (parsed) {
        case NVB197_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_GUARDBAND_Z_SAME_AS_XY_GUARDBAND:
            fprintf(fp, "SAME_AS_XY_GUARDBAND\n");
            break;
        case NVB197_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_GUARDBAND_Z_SCALE_256:
            fprintf(fp, "SCALE_256\n");
            break;
        case NVB197_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_GUARDBAND_Z_SCALE_1:
            fprintf(fp, "SCALE_1\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
}
