/*
 * Copyright (C) 2001-2004 Sistina Software, Inc. All rights reserved.  
 * Copyright (C) 2004-2023 Red Hat, Inc. All rights reserved.
 *
 * This file is part of LVM2.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License v.2.1.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */
/* Do not edit. This file is generated by the Makefile. */
static const char _command_input[] =

"OO_ALL: --commandprofile String, --config String, --debug,\0"
"--driverloaded Bool, --help, --nolocking, --lockopt String, --longhelp, --profile String, --quiet,\0"
"--verbose, --version, --yes, --test, --devicesfile String, --devices PV, --nohints --journal String\0"
"OO_REPORTING: --foreign, --ignorelockingfailure, --readonly, --reportformat ReportFmt,\0"
"--shared, --units Units\0"
"OO_REPORT: OO_REPORTING, --all, --aligned, --binary,\0"
"--configreport ConfigReport, --logonly, --headings HeadingsType,\0"
"--nameprefixes, --noheadings, --nosuffix, --options String,\0"
"--rows, --select String, --separator String, --sort String,\0"
"--unbuffered, --unquoted\0"
"OO_CONFIG: --atversion String, --typeconfig ConfigType, --file String, --ignoreadvanced,\0"
"--ignoreunsupported, --ignorelocal, --list, --mergedconfig, --metadataprofile String,\0"
"--sinceversion String, --showdeprecated, --showunsupported, --validate, --valuesonly,\0"
"--withsummary, --withcomments, --withgeneralpreamble, --withlocalpreamble, --withspaces,\0"
"--unconfigured, --withversions\0"
"OO_LVCHANGE: --autobackup Bool, --force, --ignoremonitoring,\0"
"--noudevsync, --reportformat ReportFmt, --select String\0"
"OO_LVCHANGE_META: --addtag Tag, --deltag Tag,\0"
"--alloc Alloc, --contiguous Bool,\0"
"--compression Bool, --deduplication Bool,\0"
"--detachprofile, --metadataprofile String,\0"
"--permission Permission, --readahead Readahead, --setactivationskip Bool,\0"
"--setautoactivation Bool, --errorwhenfull Bool, --discards Discards, --zero Bool,\0"
"--cachemode CacheMode, --cachepolicy String, --cachesettings String,\0"
"--minrecoveryrate SizeKB, --maxrecoveryrate SizeKB,\0"
"--vdosettings String, --integritysettings String,\0"
"--writebehind Number, --writemostly WriteMostlyPV, --persistent n\0"
"lvchange OO_LVCHANGE_META VG|LV|Tag|Select ...\0"
"OO: --activate Active, --poll Bool, --monitor Bool, OO_LVCHANGE\0"
"IO: --ignoreskippedcluster\0"
"ID: lvchange_properties\0"
"DESC: Change a general LV attribute.\0"
"DESC: For options listed in parentheses, any one is\0"
"DESC: required, after which the others are optional.\0"
"RULE: all not lv_is_pvmove lv_is_mirror_log lv_is_mirror_image\0"
"RULE: all and lv_is_vg_writable\0"
"RULE: --contiguous not --alloc\0"
"RULE: --profile not --detachprofile\0"
"RULE: --metadataprofile not --detachprofile\0"
"RULE: --minrecoveryrate --maxrecoveryrate and LV_raid\0"
"RULE: --writebehind --writemostly and LV_raid1\0"
"RULE: --cachemode --cachepolicy --cachesettings and LV_cache LV_cachepool LV_writecache\0"
"RULE: --errorwhenfull --discards --zero and LV_thinpool\0"
"RULE: --permission not lv_is_external_origin lv_is_raid_metadata lv_is_raid_image LV_thinpool\0"
"RULE: --alloc --contiguous --metadataprofile --persistent --profile --readahead not lv_is_thick_origin\0"
"RULE: --alloc --discards --zero --cachemode --cachepolicy --cachesettings not lv_is_partial\0"
"lvchange --resync VG|LV_raid_mirror|Tag|Select ...\0"
"OO: --activate Active, OO_LVCHANGE\0"
"IO: --ignoreskippedcluster\0"
"ID: lvchange_resync\0"
"DESC: Resynchronize a mirror or raid LV.\0"
"DESC: Use to reset 'R' attribute on a not initially synchronized LV.\0"
"RULE: all not lv_is_pvmove lv_is_locked lv_is_raid_with_integrity\0"
"RULE: all not LV_raid0\0"
"lvchange --syncaction SyncAction VG|LV_raid|Tag|Select ...\0"
"OO: OO_LVCHANGE\0"
"IO: --ignoreskippedcluster\0"
"ID: lvchange_syncaction\0"
"DESC: Resynchronize or check a raid LV.\0"
"RULE: all not LV_raid0\0"
"lvchange --rebuild PV VG|LV_raid|Tag|Select ...\0"
"OO: OO_LVCHANGE\0"
"IO: --ignoreskippedcluster\0"
"ID: lvchange_rebuild\0"
"DESC: Reconstruct data on specific PVs of a raid LV.\0"
"RULE: all not LV_raid0\0"
"lvchange --activate Active VG|LV|Tag|Select ...\0"
"OO: --activationmode ActivationMode, --partial, --poll Bool, --monitor Bool,\0"
"--ignoreactivationskip, --ignorelockingfailure, --sysinit, --readonly, OO_LVCHANGE\0"
"IO: --ignoreskippedcluster\0"
"ID: lvchange_activate\0"
"DESC: Activate or deactivate an LV.\0"
"lvchange --refresh VG|LV|Tag|Select ...\0"
"OO: --activationmode ActivationMode, --partial, --poll Bool, --monitor Bool, OO_LVCHANGE\0"
"IO: --ignoreskippedcluster\0"
"ID: lvchange_refresh\0"
"DESC: Reactivate an LV using the latest metadata.\0"
"lvchange --monitor Bool VG|LV|Tag|Select ...\0"
"OO: OO_LVCHANGE\0"
"IO: --ignoreskippedcluster\0"
"ID: lvchange_monitor\0"
"DESC: Start or stop monitoring an LV from dmeventd.\0"
"RULE: all not lv_is_pvmove\0"
"lvchange --poll Bool VG|LV|Tag|Select ...\0"
"OO: --monitor Bool, OO_LVCHANGE\0"
"IO: --ignoreskippedcluster\0"
"ID: lvchange_poll\0"
"DESC: Start or stop processing an LV conversion.\0"
"lvchange --persistent y --minor Number LV\0"
"OO: --major Number, --activate Active, --poll Bool, --monitor Bool, OO_LVCHANGE\0"
"IO: --ignoreskippedcluster\0"
"ID: lvchange_persistent\0"
"DESC: Make the minor device number persistent for an LV.\0"
"RULE: all not LV_thinpool LV_cachepool LV_vdopool\0"
"OO_LVCONVERT_POOL: --chunksize SizeKB, --poolmetadata LV,\0"
"--poolmetadatasize SizeMB, --poolmetadataspare Bool, --metadataprofile String,\0"
"--readahead Readahead, --wipesignatures Bool, --zero Bool\0"
"OO_LVCONVERT_CACHE: --cachemetadataformat CacheMetadataFormat,\0"
"--cachemode CacheMode, --cachepolicy String,\0"
"--cachesettings String, --zero Bool\0"
"OO_LVCONVERT_VDO: --compression Bool, --deduplication Bool, --vdosettings String\0"
"OO_LVCONVERT_VDO_POOL: OO_LVCONVERT_VDO, --metadataprofile String,\0"
"--readahead Readahead, --wipesignatures Bool, --zero Bool\0"
"OO_LVCONVERT_THINPOOL: --discards Discards, --errorwhenfull Bool, --pooldatavdo Bool,\0"
"OO_LVCONVERT_VDO, OO_LVCONVERT_POOL\0"
"OO_LVCONVERT: --alloc Alloc, --background, --force, --noudevsync\0"
"lvconvert --type linear LV\0"
"OO: OO_LVCONVERT\0"
"OP: PV ...\0"
"ID: lvconvert_raid_types\0"
"DESC: Convert LV to linear.\0"
"RULE: all not lv_is_locked lv_is_pvmove\0"
"lvconvert --type striped LV\0"
"OO: --stripes_long Number, --stripesize SizeKB, --regionsize RegionSize, --interval Number, OO_LVCONVERT\0"
"OP: PV ...\0"
"ID: lvconvert_raid_types\0"
"DESC: Convert LV to striped.\0"
"RULE: all not lv_is_locked lv_is_pvmove\0"
"lvconvert --type mirror LV\0"
"OO: --mirrors SNumber, --stripes_long Number, --stripesize SizeKB, --regionsize RegionSize, --interval Number, --mirrorlog MirrorLog, OO_LVCONVERT\0"
"OP: PV ...\0"
"ID: lvconvert_raid_types\0"
"DESC: Convert LV to type mirror (also see type raid1),\0"
"RULE: all not lv_is_locked lv_is_pvmove\0"
"lvconvert --type raid LV\0"
"OO: --mirrors SNumber, --stripes_long Number, --stripesize SizeKB, --regionsize RegionSize, --interval Number, OO_LVCONVERT\0"
"OP: PV ...\0"
"ID: lvconvert_raid_types\0"
"DESC: Convert LV to raid or change raid layout\0"
"DESC: (a specific raid level must be used, e.g. raid1).\0"
"RULE: all not lv_is_locked lv_is_pvmove\0"
"RULE: lv_is_raid_with_integrity not --stripes_long --stripesize --regionsize --interval\0"
"lvconvert --mirrors SNumber LV\0"
"OO: --regionsize RegionSize, --interval Number, --mirrorlog MirrorLog, OO_LVCONVERT\0"
"OP: PV ...\0"
"ID: lvconvert_raid_types\0"
"DESC: Convert LV to raid1 or mirror, or change number of mirror images.\0"
"RULE: all not lv_is_locked lv_is_pvmove\0"
"lvconvert --stripes_long Number LV_raid\0"
"OO: OO_LVCONVERT, --interval Number, --regionsize RegionSize, --stripesize SizeKB\0"
"OP: PV ...\0"
"ID: lvconvert_raid_types\0"
"DESC: Convert raid LV to change number of stripe images.\0"
"RULE: all not lv_is_locked lv_is_pvmove lv_is_raid_with_integrity\0"
"RULE: all not LV_raid0 LV_raid1\0"
"lvconvert --stripesize SizeKB LV_raid\0"
"OO: OO_LVCONVERT, --interval Number, --regionsize RegionSize\0"
"ID: lvconvert_raid_types\0"
"DESC: Convert raid LV to change the stripe size.\0"
"RULE: all not lv_is_locked lv_is_pvmove lv_is_raid_with_integrity\0"
"RULE: all not LV_raid0 LV_raid1\0"
"lvconvert --regionsize RegionSize LV_raid\0"
"OO: OO_LVCONVERT\0"
"ID: lvconvert_change_region_size\0"
"DESC: Change the region size of an LV.\0"
"RULE: all not lv_is_locked lv_is_pvmove lv_is_raid_with_integrity\0"
"RULE: all not LV_raid0\0"
"FLAGS: SECONDARY_SYNTAX\0"
"lvconvert --splitmirrors Number --name LV_new LV_raid1_mirror_cache\0"
"OO: OO_LVCONVERT\0"
"OP: PV ...\0"
"ID: lvconvert_split_mirror_images\0"
"DESC: Split images from a raid1 or mirror LV and use them to create a new LV.\0"
"RULE: all not lv_is_locked lv_is_pvmove lv_is_raid_with_integrity\0"
"lvconvert --splitmirrors Number --trackchanges LV_raid1_cache\0"
"OO: OO_LVCONVERT\0"
"OP: PV ...\0"
"ID: lvconvert_split_mirror_images\0"
"DESC: Split images from a raid1 LV and track changes to origin for later merge.\0"
"RULE: all not lv_is_locked lv_is_pvmove lv_is_raid_with_integrity\0"
"lvconvert --mergemirrors LV_linear_raid|VG|Tag ...\0"
"OO: OO_LVCONVERT\0"
"ID: lvconvert_merge_mirror_images\0"
"DESC: Merge LV images that were split from a raid1 LV.\0"
"RULE: all not lv_is_locked lv_is_pvmove lv_is_merging_origin lv_is_virtual_origin lv_is_external_origin lv_is_merging_cow lv_is_raid_with_integrity\0"
"lvconvert --mirrorlog MirrorLog LV_mirror\0"
"OO: OO_LVCONVERT\0"
"OP: PV ...\0"
"ID: lvconvert_change_mirrorlog\0"
"DESC: Change the type of mirror log used by a mirror LV.\0"
"RULE: all not lv_is_locked lv_is_pvmove\0"
"FLAGS: SECONDARY_SYNTAX\0"
"lvconvert --type thin --thinpool LV LV_linear_striped_raid_cache_thin_error_zero\0"
"OO: --thin, --originname LV_new, OO_LVCONVERT_POOL, OO_LVCONVERT\0"
"OP: PV ...\0"
"ID: lvconvert_to_thin_with_external\0"
"DESC: Convert LV to a thin LV, using the original LV as an external origin.\0"
"RULE: all and lv_is_visible\0"
"RULE: all not lv_is_locked lv_is_raid_with_integrity\0"
"RULE: --poolmetadata not --readahead --stripesize --stripes_long\0"
"lvconvert --thin --thinpool LV LV_linear_striped_raid_cache_thin_error_zero\0"
"OO: --originname LV_new, OO_LVCONVERT_POOL, OO_LVCONVERT\0"
"OP: PV ...\0"
"ID: lvconvert_to_thin_with_external\0"
"DESC: Convert LV to a thin LV, using the original LV as an external origin.\0"
"FLAGS: SECONDARY_SYNTAX\0"
"AUTOTYPE: thin\0"
"RULE: all and lv_is_visible\0"
"RULE: all not lv_is_locked lv_is_raid_with_integrity\0"
"RULE: --poolmetadata not --readahead --stripesize --stripes_long\0"
"lvconvert --type thin LV_linear_striped_raid_cache_writecache_vdo_error_zero\0"
"OO: --thin, OO_LVCONVERT_POOL, OO_LVCONVERT\0"
"OP: PV ...\0"
"ID: lvconvert_to_thin_with_data\0"
"DESC: Convert LV to a thin LV, using LV as thin-pool data volume.\0"
"RULE: all and lv_is_visible\0"
"RULE: all not lv_is_locked lv_is_origin lv_is_merging_origin lv_is_external_origin lv_is_raid_with_integrity\0"
"RULE: --poolmetadata not --readahead --stripesize --stripes_long\0"
"lvconvert --thin LV_linear_striped_raid_cache_writecache_vdo_error_zero\0"
"OO: OO_LVCONVERT_POOL, OO_LVCONVERT\0"
"OP: PV ...\0"
"ID: lvconvert_to_thin_with_data\0"
"DESC: Convert LV to a thin LV, using LV as thin-pool data volume.\0"
"FLAGS: SECONDARY_SYNTAX\0"
"AUTOTYPE: thin\0"
"RULE: all and lv_is_visible\0"
"RULE: all not lv_is_locked lv_is_origin lv_is_merging_origin lv_is_external_origin lv_is_raid_with_integrity\0"
"RULE: --poolmetadata not --readahead --stripesize --stripes_long\0"
"lvconvert --type cache --cachepool LV LV_linear_striped_raid_thinpool_thinpooldata_vdo_vdopool_vdopooldata_thin_error_zero\0"
"OO: --cache, OO_LVCONVERT_CACHE, OO_LVCONVERT_POOL, OO_LVCONVERT\0"
"OP: PV ...\0"
"ID: lvconvert_to_cache_with_cachepool\0"
"DESC: Attach a cache pool to an LV, converts the LV to type cache.\0"
"RULE: all not lv_is_locked lv_is_merging_origin lv_is_merging_cow lv_is_cow\0"
"RULE: --poolmetadata not --readahead --stripesize --stripes_long\0"
"lvconvert --cache --cachepool LV LV_linear_striped_raid_thinpool_vdo_vdopool_vdopooldata_thin_error_zero\0"
"OO: OO_LVCONVERT_CACHE, OO_LVCONVERT_POOL, OO_LVCONVERT\0"
"OP: PV ...\0"
"ID: lvconvert_to_cache_with_cachepool\0"
"DESC: Attach a cache pool to an LV.\0"
"RULE: all not lv_is_locked lv_is_merging_origin lv_is_merging_cow lv_is_cow\0"
"RULE: --poolmetadata not --readahead --stripesize --stripes_long\0"
"FLAGS: SECONDARY_SYNTAX\0"
"AUTOTYPE: cache\0"
"lvconvert --type writecache --cachevol LV LV_linear_striped_raid_thinpool\0"
"OO: OO_LVCONVERT, --cachesettings String\0"
"ID: lvconvert_to_writecache\0"
"DESC: Attach a writecache to an LV, converts the LV to type writecache.\0"
"RULE: all and lv_is_visible\0"
"lvconvert --type cache --cachevol LV LV_linear_striped_raid_thinpool\0"
"OO: --cache, OO_LVCONVERT_CACHE, OO_LVCONVERT, --poolmetadatasize SizeMB, --chunksize SizeKB\0"
"ID: lvconvert_to_cache_with_cachevol\0"
"DESC: Attach a cache to an LV, converts the LV to type cache.\0"
"RULE: all and lv_is_visible\0"
"lvconvert --cache --cachevol LV LV_linear_striped_raid_thinpool\0"
"OO: OO_LVCONVERT_CACHE, OO_LVCONVERT, --poolmetadatasize SizeMB, --chunksize SizeKB\0"
"ID: lvconvert_to_cache_with_cachevol\0"
"DESC: Attach a cache to an LV, converts the LV to type cache.\0"
"RULE: all and lv_is_visible\0"
"FLAGS: SECONDARY_SYNTAX\0"
"lvconvert --type writecache --cachedevice PV LV_linear_striped_raid_thinpool\0"
"OO: OO_LVCONVERT, --cachesize SizeMB, --cachesettings String\0"
"ID: lvconvert_to_writecache_with_device\0"
"DESC: Add a writecache to an LV, using a specified cache device.\0"
"RULE: all and lv_is_visible\0"
"lvconvert --type cache --cachedevice PV LV_linear_striped_raid_thinpool\0"
"OO: OO_LVCONVERT, --cachesize SizeMB, --cachesettings String, --chunksize SizeKB\0"
"ID: lvconvert_to_cache_with_device\0"
"DESC: Add a cache to an LV, using a specified cache device.\0"
"RULE: all and lv_is_visible\0"
"lvconvert --type thin-pool LV_linear_striped_raid_cache_writecache_vdo_error_zero\0"
"OO: --stripes_long Number, --stripesize SizeKB,\0"
"OO_LVCONVERT_THINPOOL, OO_LVCONVERT\0"
"OP: PV ...\0"
"ID: lvconvert_to_thinpool\0"
"DESC: Convert LV to type thin-pool (existing data on LV will be erased).\0"
"RULE: all and lv_is_visible\0"
"RULE: all not lv_is_locked lv_is_origin lv_is_merging_origin lv_is_external_origin lv_is_raid_with_integrity\0"
"RULE: --poolmetadata not --readahead --stripesize --stripes_long\0"
"lvconvert --thinpool LV_linear_striped_raid_cache_writecache_vdo_error_zero_thinpool\0"
"OO: --stripes_long Number, --stripesize SizeKB,\0"
"OO_LVCONVERT_THINPOOL, OO_LVCONVERT\0"
"OP: PV ...\0"
"ID: lvconvert_to_thinpool_or_swap_metadata\0"
"DESC: Convert LV to type thin-pool (variant, use --type thin-pool).\0"
"DESC: Swap metadata LV in a thin pool (variant, use --swapmetadata).\0"
"FLAGS: PREVIOUS_SYNTAX\0"
"RULE: all and lv_is_visible\0"
"RULE: all not lv_is_raid_with_integrity\0"
"RULE: --poolmetadata not --readahead --stripesize --stripes_long\0"
"AUTOTYPE: thin-pool\0"
"lvconvert --type cache-pool LV_linear_striped_raid_error_zero\0"
"OO: OO_LVCONVERT_CACHE, OO_LVCONVERT_POOL, OO_LVCONVERT\0"
"OP: PV ...\0"
"ID: lvconvert_to_cachepool\0"
"DESC: Convert LV to type cache-pool (existing data on LV will be erased).\0"
"RULE: --poolmetadata not --readahead --stripesize --stripes_long\0"
"RULE: all not lv_is_raid_with_integrity\0"
"lvconvert --cachepool LV_linear_striped_raid_cachepool_error_zero\0"
"OO: --type cache-pool, OO_LVCONVERT_CACHE, OO_LVCONVERT_POOL, OO_LVCONVERT\0"
"OP: PV ...\0"
"ID: lvconvert_to_cachepool_or_swap_metadata\0"
"DESC: Convert LV to type cache-pool (variant: use --type cache-pool,\0"
"DESC: existing data on LV will be erased).\0"
"DESC: Swap metadata LV in a cache pool (variant: use --swapmetadata).\0"
"FLAGS: PREVIOUS_SYNTAX\0"
"RULE: all and lv_is_visible\0"
"RULE: all not lv_is_raid_with_integrity\0"
"RULE: --poolmetadata not --readahead --stripesize --stripes_long\0"
"lvconvert --type vdo-pool LV_linear_striped_raid_cache\0"
"OO: --name LV_new, --virtualsize SizeMB, OO_LVCONVERT_VDO_POOL, OO_LVCONVERT\0"
"ID: lvconvert_to_vdopool\0"
"DESC: Convert LV to type vdopool (existing data on LV will be erased).\0"
"RULE: all and lv_is_visible lv_is_writable\0"
"RULE: all not lv_is_locked lv_is_origin lv_is_merging_origin lv_is_external_origin lv_is_virtual lv_is_raid_with_integrity\0"
"lvconvert --vdopool LV_linear_striped_raid_cache\0"
"OO: --name LV_new, --virtualsize SizeMB, OO_LVCONVERT_VDO_POOL, OO_LVCONVERT\0"
"ID: lvconvert_to_vdopool_param\0"
"DESC: Convert LV to type vdopool (variant: use --type vdo-pool,\0"
"DESC: existing data on LV will be erased).\0"
"RULE: all and lv_is_visible lv_is_writable\0"
"RULE: all not lv_is_locked lv_is_origin lv_is_merging_origin lv_is_external_origin lv_is_virtual lv_is_raid_with_integrity\0"
"FLAGS: SECONDARY_SYNTAX\0"
"AUTOTYPE: vdo-pool\0"
"lvconvert --splitcache LV_cachepool_cache_thinpool_vdopool_writecache\0"
"OO: OO_LVCONVERT, --cachesettings String\0"
"ID: lvconvert_split_and_keep_cache\0"
"DESC: Detach a cache from an LV.\0"
"lvconvert --uncache LV_cache_thinpool_vdopool_writecache\0"
"OO: OO_LVCONVERT, --cachesettings String\0"
"ID: lvconvert_split_and_remove_cache\0"
"DESC: Detach and delete a cache from an LV.\0"
"FLAGS: SECONDARY_SYNTAX\0"
"lvconvert --swapmetadata --poolmetadata LV LV_thinpool_cachepool\0"
"OO: --chunksize SizeKB, OO_LVCONVERT\0"
"ID: lvconvert_swap_pool_metadata\0"
"DESC: Swap metadata LV in a thin pool or cache pool (for repair only).\0"
"FLAGS: SECONDARY_SYNTAX\0"
"lvconvert --merge LV_linear_striped_raid_thin_snapshot|VG|Tag ...\0"
"OO: --background, --interval Number, OO_LVCONVERT\0"
"ID: lvconvert_merge\0"
"DESC: Merge LV that was split from a mirror (variant, use --mergemirrors).\0"
"DESC: Merge thin LV into its origin LV (variant, use --mergethin).\0"
"DESC: Merge COW snapshot LV into its origin (variant, use --mergesnapshot).\0"
"RULE: all not lv_is_locked lv_is_pvmove lv_is_merging_origin lv_is_virtual_origin lv_is_external_origin lv_is_merging_cow\0"
"FLAGS: SECONDARY_SYNTAX\0"
"lvconvert --mergethin LV_thin ...\0"
"OO: OO_LVCONVERT\0"
"ID: lvconvert_merge_thin\0"
"DESC: Merge thin LV into its origin LV.\0"
"RULE: all not lv_is_locked lv_is_pvmove lv_is_merging_origin lv_is_virtual_origin lv_is_external_origin lv_is_merging_cow\0"
"RULE: all and lv_is_visible\0"
"lvconvert --mergesnapshot LV_snapshot ...\0"
"OO: --background, --interval Number, OO_LVCONVERT\0"
"ID: lvconvert_merge_snapshot\0"
"DESC: Merge COW snapshot LV into its origin.\0"
"RULE: all not lv_is_locked lv_is_pvmove lv_is_merging_origin lv_is_virtual_origin lv_is_external_origin lv_is_merging_cow\0"
"RULE: all and lv_is_visible\0"
"lvconvert --splitsnapshot LV_snapshot\0"
"OO: OO_LVCONVERT\0"
"ID: lvconvert_split_cow_snapshot\0"
"DESC: Separate a COW snapshot from its origin LV.\0"
"RULE: all not lv_is_locked lv_is_pvmove lv_is_origin lv_is_external_origin lv_is_merging_cow\0"
"FLAGS: SECONDARY_SYNTAX\0"
"lvconvert --type snapshot LV LV_linear_striped\0"
"OO: --snapshot, --chunksize SizeKB, --zero Bool, OO_LVCONVERT\0"
"ID: lvconvert_combine_split_snapshot\0"
"DESC: Combine a former COW snapshot (second arg) with a former\0"
"DESC: origin LV (first arg) to reverse a splitsnapshot command.\0"
"RULE: all not lv_is_locked lv_is_pvmove\0"
"RULE: all and lv_is_visible\0"
"lvconvert --snapshot LV LV_linear_striped\0"
"OO: --chunksize SizeKB, --zero Bool, OO_LVCONVERT\0"
"ID: lvconvert_combine_split_snapshot\0"
"DESC: Combine a former COW snapshot (second arg) with a former\0"
"DESC: origin LV (first arg) to reverse a splitsnapshot command.\0"
"RULE: all not lv_is_locked lv_is_pvmove\0"
"RULE: all and lv_is_visible\0"
"FLAGS: SECONDARY_SYNTAX\0"
"AUTOTYPE: snapshot\0"
"lvconvert --repair LV_cache_cachepool_mirror_raid_thinpool\0"
"OO: --usepolicies, --interval Number, --setactivationskip Bool, --poolmetadataspare Bool, OO_LVCONVERT\0"
"OP: PV ...\0"
"ID: lvconvert_repair\0"
"DESC: Replace failed PVs in a raid or mirror LV.\0"
"DESC: Repair a thin pool.\0"
"DESC: Repair a cache pool.\0"
"RULE: all not lv_is_locked lv_is_pvmove\0"
"RULE: --poolmetadataspare and LV_cache LV_cachepool LV_thinpool\0"
"RULE: --setactivationskip and LV_cache LV_cachepool LV_thinpool\0"
"lvconvert --replace PV LV_raid\0"
"OO: OO_LVCONVERT\0"
"OP: PV ...\0"
"ID: lvconvert_replace_pv\0"
"DESC: Replace specific PV(s) in a raid LV with another PV.\0"
"RULE: all not lv_is_locked lv_is_pvmove\0"
"lvconvert --startpoll LV_mirror_raid\0"
"OO: OO_LVCONVERT\0"
"ID: lvconvert_start_poll\0"
"DESC: Poll LV to continue conversion.\0"
"RULE: all and lv_is_converting\0"
"lvconvert LV_mirror_raid\0"
"OO: OO_LVCONVERT\0"
"ID: lvconvert_plain\0"
"DESC: Poll LV to continue conversion (also see --startpoll)\0"
"DESC: or waits till conversion/mirror syncing is finished\0"
"FLAGS: SECONDARY_SYNTAX\0"
"lvconvert --raidintegrity Bool LV_raid\0"
"OO: --raidintegritymode String, --raidintegrityblocksize Number, --integritysettings String, OO_LVCONVERT\0"
"OP: PV ...\0"
"ID: lvconvert_integrity\0"
"DESC: Add or remove data integrity checksums to raid images.\0"
"OO_LVCREATE: --addtag Tag, --alloc Alloc, --autobackup Bool, --activate Active,\0"
"--contiguous Bool, --ignoreactivationskip, --ignoremonitoring, --major Number,\0"
"--metadataprofile String, --minor Number, --monitor Bool, --name String, --nosync,\0"
"--noudevsync, --permission Permission, --persistent Bool, --readahead Readahead,\0"
"--reportformat ReportFmt, --setactivationskip Bool, --wipesignatures Bool,\0"
"--zero Bool, --setautoactivation Bool\0"
"OO_LVCREATE_CACHE: --cachemode CacheMode, --cachepolicy String, --cachesettings String,\0"
"--chunksize SizeKB, --cachemetadataformat CacheMetadataFormat\0"
"OO_LVCREATE_POOL: --poolmetadatasize SizeMB, --poolmetadataspare Bool, --chunksize SizeKB\0"
"OO_LVCREATE_VDO: --compression Bool, --deduplication Bool, --vdosettings String\0"
"OO_LVCREATE_THINPOOL: --discards Discards, --errorwhenfull Bool, --pooldatavdo Bool, OO_LVCREATE_VDO, OO_LVCREATE_POOL\0"
"OO_LVCREATE_RAID: --regionsize RegionSize, --minrecoveryrate SizeKB, --maxrecoveryrate SizeKB,\0"
"--raidintegrity Bool, --raidintegritymode String, --raidintegrityblocksize Number, --integritysettings String\0"
"lvcreate --type error --size SizeMB VG\0"
"OO: OO_LVCREATE\0"
"ID: lvcreate_error_vol\0"
"DESC: Create an LV that returns errors when used.\0"
"FLAGS: SECONDARY_SYNTAX\0"
"lvcreate --type zero --size SizeMB VG\0"
"OO: OO_LVCREATE\0"
"ID: lvcreate_zero_vol\0"
"DESC: Create an LV that returns zeros when read.\0"
"FLAGS: SECONDARY_SYNTAX\0"
"lvcreate --type linear --size SizeMB VG\0"
"OO: OO_LVCREATE\0"
"OP: PV ...\0"
"IO: --mirrors 0, --stripes 1\0"
"ID: lvcreate_linear\0"
"DESC: Create a linear LV.\0"
"FLAGS: SECONDARY_SYNTAX\0"
"lvcreate --size SizeMB VG\0"
"OO: OO_LVCREATE\0"
"OP: PV ...\0"
"IO: --mirrors 0, --stripes 1\0"
"ID: lvcreate_linear\0"
"DESC: Create a linear LV.\0"
"AUTOTYPE: linear\0"
"lvcreate --type striped --size SizeMB VG\0"
"OO: --stripes Number, --stripesize SizeKB, OO_LVCREATE\0"
"OP: PV ...\0"
"ID: lvcreate_striped\0"
"DESC: Create a striped LV (also see lvcreate --stripes).\0"
"FLAGS: SECONDARY_SYNTAX\0"
"lvcreate --stripes Number --size SizeMB VG\0"
"OO: --stripesize SizeKB, OO_LVCREATE\0"
"OP: PV ...\0"
"ID: lvcreate_striped\0"
"DESC: Create a striped LV.\0"
"AUTOTYPE: striped\0"
"lvcreate --type mirror --size SizeMB VG\0"
"OO: --stripes Number, --stripesize SizeKB,\0"
"--mirrors PNumber, --mirrorlog MirrorLog, --regionsize RegionSize, OO_LVCREATE\0"
"OP: PV ...\0"
"ID: lvcreate_mirror\0"
"DESC: Create a mirror LV (also see --type raid1).\0"
"FLAGS: SECONDARY_SYNTAX\0"
"lvcreate --mirrors PNumber --size SizeMB VG\0"
"OO: --stripesize SizeKB, --mirrorlog MirrorLog, OO_LVCREATE_RAID, OO_LVCREATE\0"
"OP: PV ...\0"
"IO: --stripes 1\0"
"ID: lvcreate_mirror_or_raid1\0"
"DESC: Create a raid1 or mirror LV.\0"
"DESC: Implicit type is defined by lvm.conf global/mirror_segtype_default.\0"
"AUTOTYPE: raid1\0"
"AUTOTYPE: mirror\0"
"lvcreate --type raid --size SizeMB VG\0"
"OO: --mirrors PNumber, --stripes Number, --stripesize SizeKB,\0"
"OO_LVCREATE_RAID, OO_LVCREATE\0"
"OP: PV ...\0"
"ID: lvcreate_raid_any\0"
"DESC: Create a raid LV (a specific raid level must be used, e.g. raid1).\0"
"lvcreate --mirrors PNumber --stripes Number --size SizeMB VG\0"
"OO: --stripesize SizeKB, OO_LVCREATE_RAID, OO_LVCREATE\0"
"OP: PV ...\0"
"ID: lvcreate_raid_any\0"
"DESC: Create a raid10 LV.\0"
"AUTOTYPE: raid10\0"
"lvcreate --type snapshot --size SizeMB LV\0"
"OO: --snapshot, --stripes Number, --stripesize SizeKB,\0"
"--chunksize SizeKB, OO_LVCREATE\0"
"OP: PV ...\0"
"ID: lvcreate_cow_snapshot\0"
"DESC: Create a COW snapshot LV of an origin LV\0"
"DESC: (also see --snapshot).\0"
"FLAGS: SECONDARY_SYNTAX\0"
"lvcreate --snapshot --size SizeMB LV\0"
"OO: --stripes Number, --stripesize SizeKB,\0"
"--chunksize SizeKB, OO_LVCREATE\0"
"OP: PV ...\0"
"ID: lvcreate_cow_snapshot\0"
"DESC: Create a COW snapshot LV of an origin LV.\0"
"AUTOTYPE: snapshot\0"
"lvcreate --type snapshot --size SizeMB --virtualsize SizeMB VG\0"
"OO: --snapshot, --chunksize SizeKB, OO_LVCREATE\0"
"OP: PV ...\0"
"ID: lvcreate_cow_snapshot_with_virtual_origin\0"
"DESC: Create a sparse COW snapshot LV of a virtual origin LV\0"
"DESC: (also see --snapshot).\0"
"FLAGS: SECONDARY_SYNTAX\0"
"lvcreate --type thin-pool --size SizeMB VG\0"
"OO: --thinpool LV_new, --stripes Number, --stripesize SizeKB,\0"
"--thin, OO_LVCREATE_THINPOOL, OO_LVCREATE\0"
"OP: PV ...\0"
"IO: --mirrors 0\0"
"ID: lvcreate_thinpool\0"
"DESC: Create a thin pool.\0"
"lvcreate --thin --size SizeMB VG\0"
"OO: --stripes Number, --stripesize SizeKB, OO_LVCREATE_THINPOOL, OO_LVCREATE\0"
"OP: PV ...\0"
"IO: --mirrors 0\0"
"ID: lvcreate_thinpool\0"
"DESC: Create a thin pool.\0"
"FLAGS: SECONDARY_SYNTAX\0"
"AUTOTYPE: thin-pool\0"
"lvcreate --size SizeMB --thinpool LV_new VG\0"
"OO: --stripes Number, --stripesize SizeKB,\0"
"--thin, OO_LVCREATE_THINPOOL, OO_LVCREATE\0"
"OP: PV ...\0"
"IO: --mirrors 0\0"
"ID: lvcreate_thinpool\0"
"DESC: Create a thin pool named in --thinpool.\0"
"FLAGS: SECONDARY_SYNTAX\0"
"AUTOTYPE: thin-pool\0"
"lvcreate --type cache-pool --size SizeMB VG\0"
"OO: --stripes Number, --stripesize SizeKB,\0"
"--cache, OO_LVCREATE_CACHE, OO_LVCREATE_POOL, OO_LVCREATE\0"
"OP: PV ...\0"
"ID: lvcreate_cachepool\0"
"DESC: Create a cache pool.\0"
"lvcreate --type cache-pool --size SizeMB --cachepool LV_new VG\0"
"OO: --stripes Number, --stripesize SizeKB,\0"
"--cache, OO_LVCREATE_CACHE, OO_LVCREATE_POOL, OO_LVCREATE\0"
"OP: PV ...\0"
"ID: lvcreate_cachepool\0"
"DESC: Create a cache pool named by the --cachepool arg\0"
"DESC: (variant, uses --cachepool in place of --name).\0"
"FLAGS: SECONDARY_SYNTAX\0"
"lvcreate --type thin --virtualsize SizeMB --thinpool LV_thinpool VG\0"
"OO: --thin, OO_LVCREATE\0"
"IO: --mirrors 0\0"
"ID: lvcreate_thin_vol\0"
"DESC: Create a thin LV in a thin pool.\0"
"FLAGS: SECONDARY_SYNTAX\0"
"lvcreate --type thin --virtualsize SizeMB LV_thinpool\0"
"OO: --thin, OO_LVCREATE\0"
"IO: --mirrors 0\0"
"ID: lvcreate_thin_vol\0"
"DESC: Create a thin LV in a thin pool named in the first arg\0"
"DESC: (variant, also see --thinpool for naming pool).\0"
"FLAGS: SECONDARY_SYNTAX\0"
"lvcreate --virtualsize SizeMB --thinpool LV_thinpool VG\0"
"OO: --thin, OO_LVCREATE\0"
"IO: --mirrors 0\0"
"ID: lvcreate_thin_vol\0"
"DESC: Create a thin LV in a thin pool.\0"
"AUTOTYPE: thin\0"
"lvcreate --virtualsize SizeMB LV_thinpool\0"
"OO: --thin, OO_LVCREATE\0"
"IO: --mirrors 0\0"
"ID: lvcreate_thin_vol\0"
"DESC: Create a thin LV in the thin pool named in the first arg\0"
"DESC: (also see --thinpool for naming pool.)\0"
"FLAGS: SECONDARY_SYNTAX\0"
"AUTOTYPE: thin\0"
"lvcreate --type thin LV_thin\0"
"OO: --thin, --snapshot, OO_LVCREATE\0"
"IO: --mirrors 0\0"
"ID: lvcreate_thin_snapshot\0"
"DESC: Create a thin LV that is a snapshot of an existing thin LV.\0"
"FLAGS: SECONDARY_SYNTAX\0"
"lvcreate --thin LV_thin\0"
"OO: --snapshot, OO_LVCREATE\0"
"IO: --mirrors 0\0"
"ID: lvcreate_thin_snapshot\0"
"DESC: Create a thin LV that is a snapshot of an existing thin LV.\0"
"FLAGS: SECONDARY_SYNTAX\0"
"AUTOTYPE: thin\0"
"lvcreate --snapshot LV_thin\0"
"OO: OO_LVCREATE\0"
"IO: --mirrors 0\0"
"ID: lvcreate_thin_snapshot\0"
"DESC: Create a thin LV that is a snapshot of an existing thin LV.\0"
"AUTOTYPE: thin\0"
"lvcreate --type thin --thinpool LV_thinpool LV\0"
"OO: --thin, OO_LVCREATE\0"
"IO: --mirrors 0\0"
"ID: lvcreate_thin_snapshot_of_external\0"
"DESC: Create a thin LV that is a snapshot of an external origin LV.\0"
"lvcreate --snapshot --thinpool LV_thinpool LV\0"
"OO: OO_LVCREATE\0"
"IO: --mirrors 0\0"
"ID: lvcreate_thin_snapshot_of_external\0"
"DESC: Create a thin LV that is a snapshot of an external origin LV.\0"
"FLAGS: SECONDARY_SYNTAX\0"
"AUTOTYPE: thin\0"
"lvcreate --type vdo --size SizeMB VG\0"
"OO: --stripes Number, --stripesize SizeKB,\0"
"--vdo, --virtualsize SizeMB, --vdopool LV_new, OO_LVCREATE_VDO, OO_LVCREATE\0"
"OP: PV ...\0"
"IO: --mirrors 0\0"
"ID: lvcreate_vdo_vol\0"
"DESC: Create a LV that returns VDO when used.\0"
"lvcreate --vdo --size SizeMB VG\0"
"OO: --stripes Number, --stripesize SizeKB,\0"
"--virtualsize SizeMB, --vdopool LV_new, OO_LVCREATE_VDO, OO_LVCREATE\0"
"OP: PV ...\0"
"IO: --mirrors 0\0"
"ID: lvcreate_vdo_vol\0"
"DESC: Create a VDO LV with VDO pool.\0"
"FLAGS: SECONDARY_SYNTAX\0"
"AUTOTYPE: vdo\0"
"lvcreate --vdopool LV_new --size SizeMB VG\0"
"OO: --stripes Number, --stripesize SizeKB,\0"
"--virtualsize SizeMB, OO_LVCREATE_VDO, OO_LVCREATE\0"
"OP: PV ...\0"
"IO: --mirrors 0\0"
"ID: lvcreate_vdo_vol\0"
"DESC: Create a VDO LV with VDO pool.\0"
"FLAGS: SECONDARY_SYNTAX\0"
"AUTOTYPE: vdo\0"
"lvcreate --type thin --virtualsize SizeMB --size SizeMB --thinpool LV_new VG\0"
"OO: --stripes Number, --stripesize SizeKB,\0"
"--thin, OO_LVCREATE_THINPOOL, OO_LVCREATE\0"
"OP: PV ...\0"
"IO: --mirrors 0\0"
"ID: lvcreate_thin_vol_and_thinpool\0"
"DESC: Create a thin LV, first creating a thin pool for it,\0"
"DESC: where the new thin pool is named by the --thinpool arg.\0"
"FLAGS: SECONDARY_SYNTAX\0"
"lvcreate --virtualsize SizeMB --size SizeMB --thinpool LV_new VG\0"
"OO: --stripes Number, --stripesize SizeKB,\0"
"--thin, OO_LVCREATE_THINPOOL, OO_LVCREATE\0"
"OP: PV ...\0"
"IO: --mirrors 0\0"
"ID: lvcreate_thin_vol_and_thinpool\0"
"DESC: Create a thin LV, first creating a thin pool for it,\0"
"DESC: where the new thin pool is named by --thinpool.\0"
"FLAGS: SECONDARY_SYNTAX\0"
"AUTOTYPE: thin\0"
"lvcreate --type thin --virtualsize SizeMB --size SizeMB LV_new|VG\0"
"OO: --stripes Number, --stripesize SizeKB,\0"
"--thin, OO_LVCREATE_THINPOOL, OO_LVCREATE\0"
"OP: PV ...\0"
"IO: --mirrors 0\0"
"ID: lvcreate_thin_vol_and_thinpool\0"
"DESC: Create a thin LV, first creating a thin pool for it,\0"
"DESC: where the new thin pool is named in the first arg,\0"
"DESC: or the new thin pool name is generated when the first\0"
"DESC: arg is a VG name.\0"
"FLAGS: SECONDARY_SYNTAX\0"
"lvcreate --thin --virtualsize SizeMB --size SizeMB LV_new|VG\0"
"OO: --stripes Number, --stripesize SizeKB,\0"
"OO_LVCREATE_THINPOOL, OO_LVCREATE\0"
"OP: PV ...\0"
"IO: --mirrors 0\0"
"ID: lvcreate_thin_vol_and_thinpool\0"
"DESC: Create a thin LV, first creating a thin pool for it,\0"
"DESC: where the new thin pool is named in the first arg,\0"
"DESC: or the new thin pool name is generated when the first\0"
"DESC: arg is a VG name.\0"
"FLAGS: SECONDARY_SYNTAX\0"
"AUTOTYPE: thin\0"
"lvcreate --size SizeMB --virtualsize SizeMB VG\0"
"OO: --stripes Number, --stripesize SizeKB, --snapshot, --thin,\0"
"OO_LVCREATE_THINPOOL, OO_LVCREATE\0"
"OP: PV ...\0"
"IO: --mirrors 0\0"
"ID: lvcreate_thin_vol_with_thinpool_or_sparse_snapshot\0"
"DESC: Create a thin LV, first creating a thin pool for it.\0"
"DESC: Create a sparse snapshot of a virtual origin LV\0"
"DESC: Chooses type thin or snapshot according to\0"
"DESC: config setting sparse_segtype_default.\0"
"FLAGS: SECONDARY_SYNTAX\0"
"AUTOTYPE: thin\0"
"AUTOTYPE: snapshot\0"
"lvcreate --type cache --size SizeMB --cachepool LV_cachepool VG\0"
"OO: --stripes Number, --stripesize SizeKB,\0"
"--cache, OO_LVCREATE_CACHE, OO_LVCREATE_POOL, OO_LVCREATE\0"
"OP: PV ...\0"
"ID: lvcreate_and_attach_cachepool\0"
"DESC: Create a new LV, then attach the specified cachepool\0"
"DESC: which converts the new LV to type cache.\0"
"lvcreate --size SizeMB --cachepool LV_cachepool VG\0"
"OO: --stripes Number, --stripesize SizeKB,\0"
"--cache, OO_LVCREATE_CACHE, OO_LVCREATE\0"
"OP: PV ...\0"
"ID: lvcreate_and_attach_cachepool_v2\0"
"DESC: Create a new LV, then attach the specified cachepool\0"
"DESC: which converts the new LV to type cache.\0"
"FLAGS: SECONDARY_SYNTAX\0"
"AUTOTYPE: cache\0"
"lvcreate --type cache --size SizeMB LV_cachepool\0"
"OO: --stripes Number, --stripesize SizeKB,\0"
"--cache, OO_LVCREATE_CACHE, OO_LVCREATE_POOL, OO_LVCREATE\0"
"OP: PV ...\0"
"ID: lvcreate_and_attach_cachepool_v3\0"
"DESC: Create a new LV, then attach the specified cachepool\0"
"DESC: which converts the new LV to type cache.\0"
"DESC: (variant, also use --cachepool).\0"
"FLAGS: SECONDARY_SYNTAX\0"
"lvcreate --cache --size SizeMB LV\0"
"OO: OO_LVCREATE_CACHE, OO_LVCREATE_POOL, OO_LVCREATE,\0"
"--stripes Number, --stripesize SizeKB\0"
"OP: PV ...\0"
"ID: lvcreate_new_plus_old_cachepool_or_lvconvert_old_plus_new_cachepool\0"
"DESC: When the LV arg is a cachepool, then create a new LV and\0"
"DESC: attach the cachepool arg to it.\0"
"DESC: (variant, use --type cache and --cachepool.)\0"
"DESC: When the LV arg is not a cachepool, then create a new cachepool\0"
"DESC: and attach it to the LV arg (alternative, use lvconvert.)\0"
"FLAGS: SECONDARY_SYNTAX\0"
"AUTOTYPE: cache\0"
"lvcreate --type cache --size SizeMB --cachevol LV VG\0"
"OO: --stripes Number, --stripesize SizeKB, OO_LVCREATE_CACHE, OO_LVCREATE\0"
"OP: PV ...\0"
"ID: lvcreate_and_attach_cachevol_for_cache\0"
"DESC: Create a new LV, then attach the specified cachevol\0"
"DESC: which converts the new LV to type cache.\0"
"lvcreate --type cache --size SizeMB --cachedevice PV VG\0"
"OO: --stripes Number, --stripesize SizeKB,\0"
"--cachesize SizeMB, OO_LVCREATE_CACHE, OO_LVCREATE\0"
"OP: PV ...\0"
"ID: lvcreate_and_attach_cachedevice_for_cache\0"
"DESC: Create a new LV, then attach a cachevol created from\0"
"DESC: the specified cache device, which converts the\0"
"DESC: new LV to type cache.\0"
"lvcreate --type writecache --size SizeMB --cachevol LV VG\0"
"OO: OO_LVCREATE, --cachesettings String, --stripes Number, --stripesize SizeKB\0"
"OP: PV ...\0"
"ID: lvcreate_and_attach_cachevol_for_writecache\0"
"DESC: Create a new LV, then attach the specified cachevol\0"
"DESC: which converts the new LV to type writecache.\0"
"lvcreate --type writecache --size SizeMB --cachedevice PV VG\0"
"OO: OO_LVCREATE, --cachesize SizeMB, --cachesettings String, --stripes Number, --stripesize SizeKB\0"
"OP: PV ...\0"
"ID: lvcreate_and_attach_cachedevice_for_writecache\0"
"DESC: Create a new LV, then attach a cachevol created from\0"
"DESC: the specified cache device, which converts the\0"
"DESC: new LV to type writecache.\0"
"lvdisplay\0"
"OO: OO_REPORTING, --all, --history, --segments, --maps\0"
"OP: VG|LV|Tag ...\0"
"IO: --partial, --ignoreskippedcluster\0"
"ID: lvdisplay_general\0"
"lvdisplay --columns\0"
"OO: OO_REPORT, --history, --segments\0"
"OP: VG|LV|Tag ...\0"
"IO: --partial, --ignoreskippedcluster\0"
"RULE: --noheadings not --headings\0"
"ID: lvdisplay_columns\0"
"DESC: Display output in columns like lvs.\0"
"lvdisplay --colon\0"
"OO: OO_REPORTING, --all, --history, --segments\0"
"OP: VG|LV|Tag ...\0"
"IO: --partial, --ignoreskippedcluster\0"
"ID: lvdisplay_colon\0"
"DESC: Generate colon separated output.\0"
"lvextend --size PSizeMB LV\0"
"OO: --alloc Alloc, --autobackup Bool, --force, --mirrors Number,\0"
"--nofsck, --nosync, --noudevsync, --reportformat ReportFmt, --resizefs,\0"
"--stripes Number, --stripesize SizeKB, --poolmetadatasize PSizeMB,\0"
"--type SegType, --fs String, --fsmode String\0"
"OP: PV ...\0"
"ID: lvextend_size\0"
"DESC: Extend an LV by a specified size.\0"
"lvextend LV PV ...\0"
"OO: --alloc Alloc, --autobackup Bool, --force, --mirrors Number,\0"
"--nofsck, --nosync, --noudevsync,\0"
"--reportformat ReportFmt, --resizefs, --stripes Number, --stripesize SizeKB,\0"
"--type SegType, --fs String, --fsmode String\0"
"ID: lvextend_pv\0"
"DESC: Extend an LV by specified PV extents.\0"
"lvextend --poolmetadatasize PSizeMB LV_thinpool_linear\0"
"OO: --alloc Alloc, --autobackup Bool, --force, --mirrors Number,\0"
"--nofsck, --nosync, --noudevsync,\0"
"--reportformat ReportFmt, --stripes Number, --stripesize SizeKB,\0"
"--type SegType\0"
"OP: PV ...\0"
"ID: lvextend_pool_metadata\0"
"DESC: Extend a pool metadata SubLV by a specified size.\0"
"lvextend --usepolicies LV_snapshot_thinpool_vdopool\0"
"OO: --alloc Alloc, --autobackup Bool, --force, --mirrors Number,\0"
"--nofsck, --nosync, --noudevsync,\0"
"--reportformat ReportFmt, --resizefs,\0"
"--type SegType, --fs String, --fsmode String\0"
"OP: PV ...\0"
"ID: lvextend_policy\0"
"DESC: Extend an LV according to a predefined policy.\0"
"lvmconfig\0"
"OO: OO_CONFIG\0"
"OP: String ...\0"
"ID: lvmconfig_general\0"
"lvmdevices\0"
"ID: lvmdevices_list\0"
"DESC: Print devices in the devices file.\0"
"lvmdevices --check\0"
"ID: lvmdevices_check\0"
"OO: --refresh\0"
"DESC: Check the devices file and report incorrect values.\0"
"lvmdevices --update\0"
"OO: --delnotfound, --refresh, --force\0"
"ID: lvmdevices_update\0"
"DESC: Update the devices file to fix incorrect values.\0"
"lvmdevices --adddev PV\0"
"OO: --deviceidtype String\0"
"ID: lvmdevices_edit\0"
"DESC: Add a device to the devices file.\0"
"lvmdevices --deldev PV|String\0"
"OO: --deviceidtype String\0"
"ID: lvmdevices_edit\0"
"DESC: Remove a device from the devices file.\0"
"lvmdevices --addpvid String\0"
"OO: --deviceidtype String\0"
"ID: lvmdevices_edit\0"
"DESC: Find the device with the given PVID and add it to the devices file.\0"
"lvmdevices --delpvid String\0"
"ID: lvmdevices_edit\0"
"DESC: Remove the devices file entry for the given PVID.\0"
"lvmdevices --addid String --deviceidtype String\0"
"ID: lvmdevices_edit\0"
"DESC: Find the device with the given device_id and add it to the devices file.\0"
"lvmdevices --delid String --deviceidtype String\0"
"ID: lvmdevices_edit\0"
"DESC: Remove the devices file entry with the given device_id.\0"
"lvmdevices --listids PV\0"
"ID: lvmdevices_edit\0"
"OO: --deviceidtype String\0"
"DESC: Print device_id types and values available for the device.\0"
"lvreduce --size NSizeMB LV\0"
"OO: --autobackup Bool, --force, --nofsck, --noudevsync,\0"
"--reportformat ReportFmt, --resizefs, --fs String, --fsmode String\0"
"ID: lvreduce_size\0"
"lvremove VG|LV|Tag|Select ...\0"
"OO: --autobackup Bool, --force, --nohistory, --noudevsync,\0"
"--reportformat ReportFmt, --select String\0"
"ID: lvremove_general\0"
"lvrename VG LV LV_new\0"
"OO: --autobackup Bool, --noudevsync, --reportformat ReportFmt\0"
"ID: lvrename_vg_lv_lv\0"
"lvrename LV LV_new\0"
"OO: --autobackup Bool, --noudevsync, --reportformat ReportFmt\0"
"ID: lvrename_lv_lv\0"
"lvresize --size SSizeMB LV\0"
"OO: --alloc Alloc, --autobackup Bool, --force,\0"
"--nofsck, --nosync, --noudevsync, --reportformat ReportFmt, --resizefs,\0"
"--stripes Number, --stripesize SizeKB, --poolmetadatasize PSizeMB,\0"
"--type SegType, --fs String, --fsmode String\0"
"OP: PV ...\0"
"ID: lvresize_size\0"
"DESC: Resize an LV by a specified size.\0"
"lvresize LV PV ...\0"
"OO: --alloc Alloc, --autobackup Bool, --force,\0"
"--nofsck, --nosync, --noudevsync,\0"
"--reportformat ReportFmt, --resizefs, --stripes Number, --stripesize SizeKB,\0"
"--type SegType, --fs String, --fsmode String\0"
"ID: lvresize_pv\0"
"DESC: Resize an LV by specified PV extents.\0"
"lvresize --poolmetadatasize PSizeMB LV_thinpool\0"
"OO: --alloc Alloc, --autobackup Bool, --force,\0"
"--nofsck, --nosync, --noudevsync,\0"
"--reportformat ReportFmt, --stripes Number, --stripesize SizeKB,\0"
"--type SegType\0"
"OP: PV ...\0"
"ID: lvresize_pool_metadata\0"
"DESC: Resize a pool metadata SubLV by a specified size.\0"
"lvs\0"
"OO: --history, --segments, OO_REPORT\0"
"OP: VG|LV|Tag ...\0"
"IO: --partial, --ignoreskippedcluster, --trustcache\0"
"ID: lvs_general\0"
"RULE: --noheadings not --headings\0"
"lvscan\0"
"OO: --all, --ignorelockingfailure, --readonly, --reportformat ReportFmt\0"
"IO: --partial, --cache_long, --blockdevice\0"
"ID: lvscan_general\0"
"OO_PVCHANGE: --autobackup Bool, --force, --reportformat ReportFmt\0"
"OO_PVCHANGE_META: --allocatable Bool, --addtag Tag, --deltag Tag,\0"
"--uuid, --metadataignore Bool\0"
"pvchange --all OO_PVCHANGE_META\0"
"OO: OO_PVCHANGE\0"
"IO: --ignoreskippedcluster\0"
"ID: pvchange_properties_all\0"
"DESC: Change properties of all PVs.\0"
"pvchange OO_PVCHANGE_META PV|Select ...\0"
"OO: --select String, OO_PVCHANGE\0"
"IO: --ignoreskippedcluster\0"
"ID: pvchange_properties_some\0"
"DESC: Change properties of specified PVs.\0"
"pvresize PV ...\0"
"OO: --setphysicalvolumesize SizeMB, --reportformat ReportFmt, --autobackup Bool\0"
"ID: pvresize_general\0"
"pvck PV ...\0"
"OO: --labelsector Number\0"
"ID: pvck_general\0"
"DESC: Check for metadata on a device\0"
"pvck --dump DumpType PV\0"
"OO: --settings String, --file String,\0"
"--pvmetadatacopies MetadataCopiesPV, --labelsector Number\0"
"ID: pvck_dump\0"
"DESC: Check and print LVM headers and metadata on a device\0"
"pvck --repairtype RepairType PV\0"
"OO: --settings String, --file String, --labelsector Number\0"
"ID: pvck_repair_type\0"
"DESC: Repair LVM headers or metadata on a device\0"
"pvck --repair --file String PV\0"
"OO: --settings String, --labelsector Number\0"
"ID: pvck_repair\0"
"DESC: Repair LVM headers and metadata on a device\0"
"pvcreate PV ...\0"
"OO: --dataalignment SizeKB, --dataalignmentoffset SizeKB, --bootloaderareasize SizeMB,\0"
"--force, --labelsector Number, --metadatatype MetadataType,\0"
"--pvmetadatacopies MetadataCopiesPV, --metadatasize SizeMB,\0"
"--metadataignore Bool, --norestorefile, --setphysicalvolumesize SizeMB,\0"
"--reportformat ReportFmt, --restorefile String, --uuidstr String, --zero Bool\0"
"ID: pvcreate_general\0"
"RULE: --norestorefile not --restorefile\0"
"RULE: --bootloaderareasize not --restorefile\0"
"pvdisplay\0"
"OO: OO_REPORTING, --maps, --segments, --short\0"
"OP: PV|Tag ...\0"
"IO: --partial, --ignoreskippedcluster\0"
"ID: pvdisplay_general\0"
"pvdisplay --columns\0"
"OO: OO_REPORT, --segments\0"
"OP: PV|Tag ...\0"
"IO: --partial, --ignoreskippedcluster\0"
"RULE: --noheadings not --headings\0"
"ID: pvdisplay_columns\0"
"DESC: Display output in columns like pvs.\0"
"pvdisplay --colon\0"
"OO: OO_REPORTING, --segments\0"
"OP: PV|Tag ...\0"
"IO: --partial, --ignoreskippedcluster\0"
"ID: pvdisplay_colon\0"
"DESC: Generate colon separated output.\0"
"pvmove PV\0"
"OO: --abort, --alloc Alloc, --atomic, --autobackup Bool, --background,\0"
"--interval Number, --name LV, --noudevsync, --reportformat ReportFmt\0"
"OP: PV ...\0"
"ID: pvmove_one\0"
"DESC: Move PV extents.\0"
"pvmove\0"
"OO: --abort, --background, --interval Number\0"
"ID: pvmove_any\0"
"DESC: Continue or abort existing pvmove operations.\0"
"pvremove PV ...\0"
"OO: --force, --reportformat ReportFmt\0"
"ID: pvremove_general\0"
"pvs\0"
"OO: --segments, --allpvs, OO_REPORT\0"
"OP: PV|Tag ...\0"
"IO: --partial, --ignoreskippedcluster, --trustcache\0"
"ID: pvs_general\0"
"RULE: --noheadings not --headings\0"
"pvscan\0"
"OO: --ignorelockingfailure, --reportformat ReportFmt, --exported, --novolumegroup,\0"
"--short, --uuid, --allpvs\0"
"ID: pvscan_display\0"
"DESC: Display PV information.\0"
"pvscan --cache_long\0"
"OO: --ignorelockingfailure, --reportformat ReportFmt,\0"
"--major Number, --minor Number, --noudevsync\0"
"OP: PV|String ...\0"
"IO: --background\0"
"ID: pvscan_cache\0"
"DESC: Record that a PV is online or offline.\0"
"pvscan --cache_long --activate ay\0"
"OO: --ignorelockingfailure, --reportformat ReportFmt,\0"
"--major Number, --minor Number, --noudevsync, --autoactivation String\0"
"OP: PV|String ...\0"
"IO: --background\0"
"ID: pvscan_cache\0"
"DESC: Record that a PV is online and autoactivate the VG if complete.\0"
"pvscan --cache_long --listvg PV\0"
"OO: --ignorelockingfailure, --checkcomplete, --vgonline, --udevoutput,\0"
"--autoactivation String\0"
"ID: pvscan_cache\0"
"DESC: Record that a PV is online and list the VG using the PV.\0"
"pvscan --cache_long --listlvs PV\0"
"OO: --ignorelockingfailure, --checkcomplete, --vgonline\0"
"ID: pvscan_cache\0"
"DESC: Record that a PV is online and list LVs using the PV.\0"
"pvscan --listlvs PV\0"
"ID: pvscan_cache\0"
"DESC: List LVs using the PV.\0"
"pvscan --listvg PV\0"
"ID: pvscan_cache\0"
"DESC: List the VG using the PV.\0"
"vgcfgbackup\0"
"OO: --file String, --foreign, --ignorelockingfailure, --readonly,\0"
"--reportformat ReportFmt\0"
"OP: VG ...\0"
"IO: --partial\0"
"ID: vgcfgbackup_general\0"
"OO_VGCFGRESTORE: --force_long, --metadatatype MetadataType\0"
"vgcfgrestore VG\0"
"OO: OO_VGCFGRESTORE\0"
"ID: vgcfgrestore_by_vg\0"
"DESC: Restore VG metadata from last backup.\0"
"vgcfgrestore --file String VG\0"
"OO: OO_VGCFGRESTORE\0"
"ID: vgcfgrestore_by_file\0"
"DESC: Restore VG metadata from specified file.\0"
"vgcfgrestore --list VG\0"
"OO: OO_VGCFGRESTORE\0"
"ID: vgcfgrestore_list_by_vg\0"
"DESC: List all VG metadata backups.\0"
"vgcfgrestore --list --file String\0"
"OO: OO_VGCFGRESTORE\0"
"OP: VG\0"
"ID: vgcfgrestore_list_by_file\0"
"DESC: List one VG metadata backup file.\0"
"OO_VGCHANGE: --autobackup Bool, --ignoremonitoring,\0"
"--noudevsync, --reportformat ReportFmt, --select String, --force\0"
"OO_VGCHANGE_META: --addtag Tag, --deltag Tag,\0"
"--logicalvolume Uint32, --maxphysicalvolumes Uint32, --alloc Alloc, --uuid,\0"
"--pvmetadatacopies MetadataCopiesPV, --vgmetadatacopies MetadataCopiesVG,\0"
"--physicalextentsize SizeMB, --resizeable Bool,\0"
"--detachprofile, --metadataprofile String,\0"
"--setautoactivation Bool\0"
"vgchange OO_VGCHANGE_META\0"
"OO: --poll Bool, OO_VGCHANGE\0"
"OP: VG|Tag|Select ...\0"
"IO: --ignoreskippedcluster\0"
"ID: vgchange_properties\0"
"DESC: Change a general VG attribute.\0"
"DESC: For options listed in parentheses, any one is\0"
"DESC: required, after which the others are optional.\0"
"vgchange --monitor Bool\0"
"OO: --sysinit, --ignorelockingfailure, --poll Bool, OO_VGCHANGE\0"
"OP: VG|Tag|Select ...\0"
"IO: --ignoreskippedcluster\0"
"ID: vgchange_monitor\0"
"DESC: Start or stop monitoring LVs from dmeventd.\0"
"vgchange --poll Bool\0"
"OO: --ignorelockingfailure, OO_VGCHANGE\0"
"OP: VG|Tag|Select ...\0"
"IO: --ignoreskippedcluster\0"
"ID: vgchange_poll\0"
"DESC: Start or stop processing LV conversions.\0"
"vgchange --activate Active\0"
"OO: --activationmode ActivationMode, --ignoreactivationskip, --partial, --sysinit,\0"
"--readonly, --ignorelockingfailure, --monitor Bool, --poll Bool,\0"
"--autoactivation String, --persist String, OO_VGCHANGE\0"
"OP: VG|Tag|Select ...\0"
"IO: --ignoreskippedcluster\0"
"ID: vgchange_activate\0"
"DESC: Activate or deactivate LVs.\0"
"vgchange --refresh\0"
"OO: --sysinit, --ignorelockingfailure, --poll Bool, OO_VGCHANGE\0"
"OP: VG|Tag|Select ...\0"
"IO: --ignoreskippedcluster\0"
"ID: vgchange_refresh\0"
"DESC: Reactivate LVs using the latest metadata.\0"
"vgchange --systemid String VG|Tag|Select\0"
"OO: --select String, --majoritypvs, --persist String, --removekey String\0"
"ID: vgchange_systemid\0"
"DESC: Change the system ID of a VG.\0"
"vgchange --setpersist String VG|Tag|Select\0"
"OO: --select String, --persist start\0"
"ID: vgchange_setpersist\0"
"DESC: Set or clear flags to control persistent reservation behavior.\0"
"vgchange --persist String VG|Tag|Select\0"
"OO: --select String, --removekey String, --majoritypvs, --force\0"
"ID: vgchange_persist\0"
"DESC: Perform persistent reservation commands on devices.\0"
"vgchange --setlockargs String VG|Tag|Select\0"
"OO: --select String\0"
"ID: vgchange_setlockargs\0"
"DESC: Set or clear lock_args flags to control lock manager behavior.\0"
"vgchange --lockstart\0"
"OO: --select String, --persist start\0"
"OP: VG|Tag|Select ...\0"
"ID: vgchange_lockstart\0"
"DESC: Start the lockspace of a shared VG in lvmlockd.\0"
"vgchange --lockstop\0"
"OO: --select String, --persist stop\0"
"OP: VG|Tag|Select ...\0"
"ID: vgchange_lockstop\0"
"DESC: Stop the lockspace of a shared VG in lvmlockd.\0"
"vgchange --locktype LockType VG\0"
"OO: --setlockargs String\0"
"ID: vgchange_locktype\0"
"DESC: Change the lock type for a shared VG.\0"
"vgck\0"
"OO: --reportformat ReportFmt\0"
"OP: VG|Tag ...\0"
"ID: vgck_general\0"
"DESC: Read and display information about a VG.\0"
"vgck --updatemetadata VG\0"
"ID: vgck_update_metadata\0"
"DESC: Rewrite VG metadata to correct problems.\0"
"vgcreate VG_new PV ...\0"
"OO: --addtag Tag, --alloc Alloc, --autobackup Bool, --clustered Bool, --maxlogicalvolumes Uint32,\0"
"--maxphysicalvolumes Uint32, --metadataprofile String, --metadatatype MetadataType,\0"
"--physicalextentsize SizeMB, --force, --zero Bool, --labelsector Number,\0"
"--metadatasize SizeMB, --pvmetadatacopies MetadataCopiesPV, --vgmetadatacopies MetadataCopiesVG,\0"
"--reportformat ReportFmt, --dataalignment SizeKB, --dataalignmentoffset SizeKB,\0"
"--shared, --systemid String, --locktype LockType, --setautoactivation Bool,\0"
"--setpersist String, --persist start, --setlockargs String\0"
"ID: vgcreate_general\0"
"vgdisplay\0"
"OO: OO_REPORTING, --short, --activevolumegroups\0"
"OP: VG|Tag ...\0"
"IO: --partial, --ignoreskippedcluster\0"
"ID: vgdisplay_general\0"
"vgdisplay --columns\0"
"OO: OO_REPORT\0"
"OP: VG|Tag ...\0"
"IO: --partial, --ignoreskippedcluster\0"
"RULE: --noheadings not --headings\0"
"ID: vgdisplay_columns\0"
"DESC: Display output in columns like vgs.\0"
"vgdisplay --colon\0"
"OO: OO_REPORTING, --activevolumegroups\0"
"OP: VG|Tag ...\0"
"IO: --partial, --ignoreskippedcluster\0"
"ID: vgdisplay_colon\0"
"DESC: Generate colon separated output.\0"
"OO_VGEXPORT: --reportformat ReportFmt\0"
"vgexport VG|Tag|Select ...\0"
"OO: --select String, --persist stop, OO_VGEXPORT\0"
"ID: vgexport_some\0"
"DESC: Export specified VGs.\0"
"vgexport --all\0"
"OO: OO_VGEXPORT\0"
"ID: vgexport_all\0"
"DESC: Export all VGs.\0"
"vgextend VG PV ...\0"
"OO: --autobackup Bool,\0"
"--force, --zero Bool, --labelsector Number, --metadatatype MetadataType,\0"
"--metadatasize SizeMB, --pvmetadatacopies MetadataCopiesPV,\0"
"--metadataignore Bool, --dataalignment SizeKB, --dataalignmentoffset SizeKB,\0"
"--reportformat ReportFmt, --restoremissing\0"
"ID: vgextend_general\0"
"OO_VGIMPORT: --force, --reportformat ReportFmt\0"
"vgimport VG|Tag|Select ...\0"
"OO: --select String, --persist start, OO_VGIMPORT\0"
"ID: vgimport_some\0"
"DESC: Import specified VGs.\0"
"vgimport --all\0"
"OO: OO_VGIMPORT\0"
"ID: vgimport_all\0"
"DESC: Import all VGs.\0"
"vgimportclone PV ...\0"
"OO: --basevgname VG, --import, --importdevices\0"
"ID: vgimportclone_general\0"
"vgimportdevices VG|Tag|Select ...\0"
"OO: --select String, --foreign, --reportformat ReportFmt\0"
"ID: vgimportdevices_some\0"
"DESC: Add devices from specific VGs to the devices file.\0"
"vgimportdevices --all\0"
"OO: --foreign, --reportformat ReportFmt\0"
"ID: vgimportdevices_all\0"
"DESC: Add devices from all accessible VGs to the devices file.\0"
"vgimportdevices --rootvg\0"
"OO: --auto, --reportformat ReportFmt\0"
"ID: vgimportdevices_root\0"
"DESC: Add devices from root VG to the devices file.\0"
"vgmerge VG VG\0"
"OO: --autobackup Bool, --list, --poolmetadataspare Bool\0"
"ID: vgmerge_general\0"
"vgmknodes\0"
"OO: --ignorelockingfailure, --refresh, --reportformat ReportFmt\0"
"OP: VG|LV|Tag ...\0"
"ID: vgmknodes_general\0"
"OO_VGREDUCE: --autobackup Bool, --force, --reportformat ReportFmt\0"
"vgreduce VG PV ...\0"
"OO: OO_VGREDUCE\0"
"ID: vgreduce_by_pv\0"
"DESC: Remove a PV from a VG.\0"
"vgreduce --all VG\0"
"OO: OO_VGREDUCE\0"
"ID: vgreduce_all\0"
"DESC: Remove all unused PVs from a VG.\0"
"vgreduce --removemissing VG\0"
"OO: --mirrorsonly, OO_VGREDUCE\0"
"ID: vgreduce_missing\0"
"DESC: Remove all missing PVs from a VG.\0"
"vgremove VG|Tag|Select ...\0"
"OO: --force, --noudevsync, --reportformat ReportFmt, --select String\0"
"ID: vgremove_general\0"
"vgrename VG VG_new\0"
"OO: --autobackup Bool, --force, --reportformat ReportFmt\0"
"ID: vgrename_by_name\0"
"DESC: Rename a VG.\0"
"vgrename String VG_new\0"
"OO: --autobackup Bool, --force, --reportformat ReportFmt\0"
"ID: vgrename_by_uuid\0"
"DESC: Rename a VG by specifying the VG UUID.\0"
"vgs\0"
"OO: OO_REPORT\0"
"OP: VG|Tag ...\0"
"IO: --partial, --ignoreskippedcluster, --trustcache\0"
"ID: vgs_general\0"
"RULE: --noheadings not --headings\0"
"vgscan\0"
"OO: --ignorelockingfailure, --mknodes, --notifydbus, --refresh,\0"
"--reportformat ReportFmt\0"
"IO: --partial, --cache_long\0"
"ID: vgscan_general\0"
"OO_VGSPLIT: --autobackup Bool, --poolmetadataspare Bool\0"
"OO_VGSPLIT_NEW: --alloc Alloc,\0"
"--maxlogicalvolumes Uint32, --maxphysicalvolumes Uint32,\0"
"--metadatatype MetadataType, --vgmetadatacopies MetadataCopiesVG\0"
"vgsplit VG VG PV ...\0"
"OO: OO_VGSPLIT, OO_VGSPLIT_NEW\0"
"ID: vgsplit_by_pv\0"
"DESC: Split a VG by specified PVs.\0"
"vgsplit --name LV VG VG\0"
"OO: OO_VGSPLIT, OO_VGSPLIT_NEW\0"
"ID: vgsplit_by_lv\0"
"DESC: Split a VG by PVs in a specified LV.\0"
"config\0"
"OO: OO_CONFIG\0"
"OP: String ...\0"
"ID: lvmconfig_general\0"
"dumpconfig\0"
"OO: OO_CONFIG\0"
"OP: String ...\0"
"ID: lvmconfig_general\0"
"devtypes\0"
"OO: --aligned, --binary, --nameprefixes, --noheadings,\0"
"--nosuffix, --options String, --reportformat ReportFmt, --rows,\0"
"--select String, --separator String, --sort String, --unbuffered, --unquoted\0"
"ID: devtypes_general\0"
"fullreport\0"
"OO: OO_REPORT\0"
"OP: VG ...\0"
"IO: --partial, --ignoreskippedcluster, --trustcache\0"
"ID: fullreport_general\0"
"RULE: --noheadings not --headings\0"
"lastlog\0"
"OO: --reportformat ReportFmt, --select String\0"
"ID: lastlog_general\0"
"lvpoll --polloperation PollOp LV ...\0"
"OO: --abort, --autobackup Bool, --handlemissingpvs, --interval Number\0"
"ID: lvpoll_general\0"
"formats\0"
"ID: formats_general\0"
"help\0"
"OP: String ...\0"
"ID: help_general\0"
"version\0"
"ID: version_general\0"
"pvdata\0"
"ID: pvdata_general\0"
"segtypes\0"
"ID: segtypes_general\0"
"systemid\0"
"ID: systemid_general\0"
"tags\0"
"ID: tags_general\0"
"lvmchange\0"
"ID: lvmchange_general\0"
"lvmdiskscan\0"
"OO: --lvmpartition, --readonly\0"
"ID: lvmdiskscan_general\0"
"lvmsadc\0"
"ID: lvmsadc_general\0"
"lvmsar\0"
"OO: --full, --stdin\0"
"ID: lvmsar_general\0"
"vgconvert VG ...\0"
"OO: --force, --labelsector Number, --bootloaderareasize SizeMB,\0"
"--metadatatype MetadataType, --pvmetadatacopies MetadataCopiesPV,\0"
"--metadatasize SizeMB, --reportformat ReportFmt\0"
"ID: vgconvert_general\0"
"\0\0";
