
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "plugininterface_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"
#include "plugininterface_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_PluginInterface_Type = nullptr;
static PyTypeObject *Sbk_PluginInterface_TypeF(void)
{
    return _Sbk_PluginInterface_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void PluginInterfaceWrapper::pysideInitQtMetaTypes()
{
    qRegisterMetaType< ::PluginInterface *>();
    qRegisterMetaType< ::PluginInterface::InitState >("PluginInterface::InitState");
}

void PluginInterfaceWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

PluginInterfaceWrapper::PluginInterfaceWrapper()
{
}

bool PluginInterfaceWrapper::acceptNavigationRequest(::WebPage * page, const ::QUrl & url, ::QWebEnginePage::NavigationType type, bool isMainFrame)
{
    static const char *funcName = "acceptNavigationRequest";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PluginInterface_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::PluginInterface::acceptNavigationRequest(page, url, type, isMainFrame);
    }
    return sbk_o_acceptNavigationRequest("PluginInterface", funcName, gil, pyOverride, page, url, type, isMainFrame);
}

bool PluginInterfaceWrapper::sbk_o_acceptNavigationRequest(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::WebPage * page, const ::QUrl & url, ::QWebEnginePage::NavigationType type, bool isMainFrame)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[4] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), page),
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), &url),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEnginePage_NavigationType_IDX])))->converter, &type),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &isMainFrame)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNNN)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), page),
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), &url),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEnginePage_NavigationType_IDX])))->converter, &type),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &isMainFrame)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 4, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
    Py_DECREF(pyArgArray[2]);
    Py_DECREF(pyArgArray[3]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void PluginInterfaceWrapper::init(::PluginInterface::InitState state, const ::QString & settingsPath)
{
    static const char *funcName = "init";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PluginInterface_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("PluginInterface.init");
        return;
    }
    sbk_o_init("PluginInterface", funcName, gil, pyOverride, state, settingsPath);
}

void PluginInterfaceWrapper::sbk_o_init(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::PluginInterface::InitState state, const ::QString & settingsPath)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginInterface_InitState_IDX])))->converter, &state),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &settingsPath)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginInterface_InitState_IDX])))->converter, &state),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &settingsPath)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

bool PluginInterfaceWrapper::keyPress(::Qz::ObjectName type, ::QObject * obj, ::QKeyEvent * event)
{
    static const char *funcName = "keyPress";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PluginInterface_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::PluginInterface::keyPress(type, obj, event);
    }
    return sbk_o_keyPress("PluginInterface", funcName, gil, pyOverride, type, obj, event);
}

bool PluginInterfaceWrapper::sbk_o_keyPress(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::Qz::ObjectName type, ::QObject * obj, ::QKeyEvent * event)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[3] = {
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Qz_ObjectName_IDX])))->converter, &type),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), obj),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeyEvent_IDX]), event)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Qz_ObjectName_IDX])))->converter, &type),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), obj),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeyEvent_IDX]), event)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 3, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
    Py_DECREF(pyArgArray[2]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool PluginInterfaceWrapper::keyRelease(::Qz::ObjectName type, ::QObject * obj, ::QKeyEvent * event)
{
    static const char *funcName = "keyRelease";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PluginInterface_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::PluginInterface::keyRelease(type, obj, event);
    }
    return PluginInterfaceWrapper::sbk_o_keyPress("PluginInterface", funcName, gil, pyOverride, type, obj, event);
}

bool PluginInterfaceWrapper::mouseDoubleClick(::Qz::ObjectName type, ::QObject * obj, ::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClick";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PluginInterface_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::PluginInterface::mouseDoubleClick(type, obj, event);
    }
    return sbk_o_mouseDoubleClick("PluginInterface", funcName, gil, pyOverride, type, obj, event);
}

bool PluginInterfaceWrapper::sbk_o_mouseDoubleClick(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::Qz::ObjectName type, ::QObject * obj, ::QMouseEvent * event)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[3] = {
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Qz_ObjectName_IDX])))->converter, &type),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), obj),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QMouseEvent_IDX]), event)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Qz_ObjectName_IDX])))->converter, &type),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), obj),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QMouseEvent_IDX]), event)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 3, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
    Py_DECREF(pyArgArray[2]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool PluginInterfaceWrapper::mouseMove(::Qz::ObjectName type, ::QObject * obj, ::QMouseEvent * event)
{
    static const char *funcName = "mouseMove";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PluginInterface_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::PluginInterface::mouseMove(type, obj, event);
    }
    return PluginInterfaceWrapper::sbk_o_mouseDoubleClick("PluginInterface", funcName, gil, pyOverride, type, obj, event);
}

bool PluginInterfaceWrapper::mousePress(::Qz::ObjectName type, ::QObject * obj, ::QMouseEvent * event)
{
    static const char *funcName = "mousePress";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PluginInterface_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::PluginInterface::mousePress(type, obj, event);
    }
    return PluginInterfaceWrapper::sbk_o_mouseDoubleClick("PluginInterface", funcName, gil, pyOverride, type, obj, event);
}

bool PluginInterfaceWrapper::mouseRelease(::Qz::ObjectName type, ::QObject * obj, ::QMouseEvent * event)
{
    static const char *funcName = "mouseRelease";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PluginInterface_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::PluginInterface::mouseRelease(type, obj, event);
    }
    return PluginInterfaceWrapper::sbk_o_mouseDoubleClick("PluginInterface", funcName, gil, pyOverride, type, obj, event);
}

bool PluginInterfaceWrapper::newWindowRequested(::WebPage * page, ::QWebEngineNewWindowRequest & request)
{
    static const char *funcName = "newWindowRequested";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PluginInterface_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::PluginInterface::newWindowRequested(page, request);
    }
    return sbk_o_newWindowRequested("PluginInterface", funcName, gil, pyOverride, page, request);
}

bool PluginInterfaceWrapper::sbk_o_newWindowRequested(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::WebPage * page, ::QWebEngineNewWindowRequest & request)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), page),
        Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineNewWindowRequest_IDX]), &request)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), page),
        Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineNewWindowRequest_IDX]), &request)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void PluginInterfaceWrapper::populateExtensionsMenu(::QMenu * menu)
{
    static const char *funcName = "populateExtensionsMenu";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PluginInterface_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::PluginInterface::populateExtensionsMenu(menu);
    }
    sbk_o_populateExtensionsMenu("PluginInterface", funcName, gil, pyOverride, menu);
}

void PluginInterfaceWrapper::sbk_o_populateExtensionsMenu(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QMenu * menu)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]), menu)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]), menu)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void PluginInterfaceWrapper::populateWebViewMenu(::QMenu * menu, ::WebView * view, const ::WebHitTestResult & r)
{
    static const char *funcName = "populateWebViewMenu";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PluginInterface_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::PluginInterface::populateWebViewMenu(menu, view, r);
    }
    sbk_o_populateWebViewMenu("PluginInterface", funcName, gil, pyOverride, menu, view, r);
}

void PluginInterfaceWrapper::sbk_o_populateWebViewMenu(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QMenu * menu, ::WebView * view, const ::WebHitTestResult & r)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[3] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]), menu),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebView_IDX]), view),
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX]), &r)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]), menu),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebView_IDX]), view),
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX]), &r)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 3, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
    Py_DECREF(pyArgArray[2]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void PluginInterfaceWrapper::showSettings(::QWidget * parent)
{
    static const char *funcName = "showSettings";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PluginInterface_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::PluginInterface::showSettings(parent);
    }
    sbk_o_showSettings("PluginInterface", funcName, gil, pyOverride, parent);
}

void PluginInterfaceWrapper::sbk_o_showSettings(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QWidget * parent)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), parent)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), parent)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

bool PluginInterfaceWrapper::testPlugin()
{
    static const char *funcName = "testPlugin";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PluginInterface_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("PluginInterface.testPlugin");
        return false;
    }
    return WebViewWrapper::sbk_o_hasHeightForWidth("PluginInterface", funcName, gil, pyOverride);
}

void PluginInterfaceWrapper::unload()
{
    static const char *funcName = "unload";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PluginInterface_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("PluginInterface.unload");
        return;
    }
    WebViewWrapper::sbk_o_closeView("PluginInterface", funcName, gil, pyOverride);
}

bool PluginInterfaceWrapper::wheelEvent(::Qz::ObjectName type, ::QObject * obj, ::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PluginInterface_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::PluginInterface::wheelEvent(type, obj, event);
    }
    return sbk_o_wheelEvent("PluginInterface", funcName, gil, pyOverride, type, obj, event);
}

bool PluginInterfaceWrapper::sbk_o_wheelEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::Qz::ObjectName type, ::QObject * obj, ::QWheelEvent * event)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[3] = {
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Qz_ObjectName_IDX])))->converter, &type),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), obj),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QWheelEvent_IDX]), event)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Qz_ObjectName_IDX])))->converter, &type),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), obj),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QWheelEvent_IDX]), event)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 3, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
    Py_DECREF(pyArgArray[2]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

PluginInterfaceWrapper::~PluginInterfaceWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_PluginInterface_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_PluginInterface_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(args)
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PyTypeObject *type = self->ob_type;
    PyTypeObject *myType = Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]);
    if (type == myType) {
        Shiboken::Errors::setInstantiateAbstractClass("PluginInterface");
        return -1;
    }

    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::PluginInterface >()))
        return -1;

    PluginInterfaceWrapper *cptr{};
    Shiboken::PythonContextMarker pcm;


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {

        // PluginInterface()
        cptr = new PluginInterfaceWrapper();
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< PluginInterface >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_PluginInterfaceFunc_acceptNavigationRequest(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PluginInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "acceptNavigationRequest", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return {};


    // Overloaded function decisor
    // 0: PluginInterface::acceptNavigationRequest(WebPage*,QUrl,QWebEnginePage::NavigationType,bool)->bool
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEnginePage_NavigationType_IDX])))->converter, (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[3])))) {
        overloadId = 0; // acceptNavigationRequest(WebPage*,QUrl,QWebEnginePage::NavigationType,bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "acceptNavigationRequest", errInfo, SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::WebPage *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QUrl cppArg1_local;
        ::QUrl *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1].isValue())
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        ::QWebEnginePage::NavigationType cppArg2{QWebEnginePage::NavigationTypeLinkClicked};
        pythonToCpp[2](pyArgs[2], &cppArg2);
        bool cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (Shiboken::Errors::occurred() == nullptr) {
            // acceptNavigationRequest(WebPage*,QUrl,QWebEnginePage::NavigationType,bool)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::PluginInterface::acceptNavigationRequest(cppArg0, *cppArg1, cppArg2, cppArg3)
                : cppSelf->acceptNavigationRequest(cppArg0, *cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PluginInterfaceFunc_init(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PluginInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "init", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: PluginInterface::init(PluginInterface::InitState,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginInterface_InitState_IDX])))->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // init(PluginInterface::InitState,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "init", errInfo, SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]);

    // Call function/method
    {
        ::PluginInterface::InitState cppArg0{PluginInterface::StartupInitState};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // init(PluginInterface::InitState,QString)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                Shiboken::Errors::setPureVirtualMethodError("PluginInterface.init");
                return {};
            }
            cppSelf->init(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_PluginInterfaceFunc_keyPress(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PluginInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "keyPress", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: PluginInterface::keyPress(Qz::ObjectName,QObject*,QKeyEvent*)->bool
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Qz_ObjectName_IDX])))->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeyEvent_IDX]), (pyArgs[2])))) {
        overloadId = 0; // keyPress(Qz::ObjectName,QObject*,QKeyEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "keyPress", errInfo, SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]);

    // Call function/method
    {
        ::Qz::ObjectName cppArg0{Qz::ON_WebView};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QObject *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QKeyEvent *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // keyPress(Qz::ObjectName,QObject*,QKeyEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::PluginInterface::keyPress(cppArg0, cppArg1, cppArg2)
                : cppSelf->keyPress(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PluginInterfaceFunc_keyRelease(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PluginInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "keyRelease", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: PluginInterface::keyRelease(Qz::ObjectName,QObject*,QKeyEvent*)->bool
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Qz_ObjectName_IDX])))->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeyEvent_IDX]), (pyArgs[2])))) {
        overloadId = 0; // keyRelease(Qz::ObjectName,QObject*,QKeyEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "keyRelease", errInfo, SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]);

    // Call function/method
    {
        ::Qz::ObjectName cppArg0{Qz::ON_WebView};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QObject *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QKeyEvent *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // keyRelease(Qz::ObjectName,QObject*,QKeyEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::PluginInterface::keyRelease(cppArg0, cppArg1, cppArg2)
                : cppSelf->keyRelease(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PluginInterfaceFunc_mouseDoubleClick(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PluginInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "mouseDoubleClick", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: PluginInterface::mouseDoubleClick(Qz::ObjectName,QObject*,QMouseEvent*)->bool
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Qz_ObjectName_IDX])))->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QMouseEvent_IDX]), (pyArgs[2])))) {
        overloadId = 0; // mouseDoubleClick(Qz::ObjectName,QObject*,QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "mouseDoubleClick", errInfo, SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]);

    // Call function/method
    {
        ::Qz::ObjectName cppArg0{Qz::ON_WebView};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QObject *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QMouseEvent *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // mouseDoubleClick(Qz::ObjectName,QObject*,QMouseEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::PluginInterface::mouseDoubleClick(cppArg0, cppArg1, cppArg2)
                : cppSelf->mouseDoubleClick(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PluginInterfaceFunc_mouseMove(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PluginInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "mouseMove", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: PluginInterface::mouseMove(Qz::ObjectName,QObject*,QMouseEvent*)->bool
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Qz_ObjectName_IDX])))->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QMouseEvent_IDX]), (pyArgs[2])))) {
        overloadId = 0; // mouseMove(Qz::ObjectName,QObject*,QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "mouseMove", errInfo, SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]);

    // Call function/method
    {
        ::Qz::ObjectName cppArg0{Qz::ON_WebView};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QObject *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QMouseEvent *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // mouseMove(Qz::ObjectName,QObject*,QMouseEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::PluginInterface::mouseMove(cppArg0, cppArg1, cppArg2)
                : cppSelf->mouseMove(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PluginInterfaceFunc_mousePress(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PluginInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "mousePress", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: PluginInterface::mousePress(Qz::ObjectName,QObject*,QMouseEvent*)->bool
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Qz_ObjectName_IDX])))->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QMouseEvent_IDX]), (pyArgs[2])))) {
        overloadId = 0; // mousePress(Qz::ObjectName,QObject*,QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "mousePress", errInfo, SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]);

    // Call function/method
    {
        ::Qz::ObjectName cppArg0{Qz::ON_WebView};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QObject *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QMouseEvent *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // mousePress(Qz::ObjectName,QObject*,QMouseEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::PluginInterface::mousePress(cppArg0, cppArg1, cppArg2)
                : cppSelf->mousePress(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PluginInterfaceFunc_mouseRelease(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PluginInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "mouseRelease", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: PluginInterface::mouseRelease(Qz::ObjectName,QObject*,QMouseEvent*)->bool
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Qz_ObjectName_IDX])))->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QMouseEvent_IDX]), (pyArgs[2])))) {
        overloadId = 0; // mouseRelease(Qz::ObjectName,QObject*,QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "mouseRelease", errInfo, SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]);

    // Call function/method
    {
        ::Qz::ObjectName cppArg0{Qz::ON_WebView};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QObject *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QMouseEvent *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // mouseRelease(Qz::ObjectName,QObject*,QMouseEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::PluginInterface::mouseRelease(cppArg0, cppArg1, cppArg2)
                : cppSelf->mouseRelease(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PluginInterfaceFunc_newWindowRequested(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PluginInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "newWindowRequested", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: PluginInterface::newWindowRequested(WebPage*,QWebEngineNewWindowRequest&)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineNewWindowRequest_IDX]), (pyArgs[1])))) {
        overloadId = 0; // newWindowRequested(WebPage*,QWebEngineNewWindowRequest&)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "newWindowRequested", errInfo, SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::WebPage *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QWebEngineNewWindowRequest *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // newWindowRequested(WebPage*,QWebEngineNewWindowRequest&)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::PluginInterface::newWindowRequested(cppArg0, *cppArg1)
                : cppSelf->newWindowRequested(cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PluginInterfaceFunc_populateExtensionsMenu(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PluginInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PluginInterface::populateExtensionsMenu(QMenu*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]), (pyArg)))) {
        overloadId = 0; // populateExtensionsMenu(QMenu*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "populateExtensionsMenu", errInfo, SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMenu *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // populateExtensionsMenu(QMenu*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::PluginInterface::populateExtensionsMenu(cppArg0)
                : cppSelf->populateExtensionsMenu(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_PluginInterfaceFunc_populateWebViewMenu(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PluginInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "populateWebViewMenu", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: PluginInterface::populateWebViewMenu(QMenu*,WebView*,WebHitTestResult)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebView_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX]), (pyArgs[2])))) {
        overloadId = 0; // populateWebViewMenu(QMenu*,WebView*,WebHitTestResult)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "populateWebViewMenu", errInfo, SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QMenu *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::WebView *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::WebHitTestResult cppArg2_local = ::WebHitTestResult(static_cast<::WebPage*>(nullptr), ::QPoint());
        ::WebHitTestResult *cppArg2 = &cppArg2_local;
        if (pythonToCpp[2].isValue())
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);


        if (Shiboken::Errors::occurred() == nullptr) {
            // populateWebViewMenu(QMenu*,WebView*,WebHitTestResult)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::PluginInterface::populateWebViewMenu(cppArg0, cppArg1, *cppArg2)
                : cppSelf->populateWebViewMenu(cppArg0, cppArg1, *cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_PluginInterfaceFunc_showSettings(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PluginInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "showSettings", errInfo, SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]);

    if (PyArg_ParseTuple(args, "|O:showSettings", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: PluginInterface::showSettings(QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // showSettings(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // showSettings(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "showSettings", errInfo, SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "showSettings", errInfo, SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // showSettings(QWidget*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::PluginInterface::showSettings(cppArg0)
                : cppSelf->showSettings(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_PluginInterfaceFunc_testPlugin(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PluginInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // testPlugin()
        if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
            Shiboken::Errors::setPureVirtualMethodError("PluginInterface.testPlugin");
            return {};
        }
        bool cppResult = cppSelf->testPlugin();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PluginInterfaceFunc_unload(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PluginInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // unload()
        if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
            Shiboken::Errors::setPureVirtualMethodError("PluginInterface.unload");
            return {};
        }
        cppSelf->unload();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_PluginInterfaceFunc_wheelEvent(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PluginInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "wheelEvent", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: PluginInterface::wheelEvent(Qz::ObjectName,QObject*,QWheelEvent*)->bool
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Qz_ObjectName_IDX])))->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QWheelEvent_IDX]), (pyArgs[2])))) {
        overloadId = 0; // wheelEvent(Qz::ObjectName,QObject*,QWheelEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "wheelEvent", errInfo, SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]);

    // Call function/method
    {
        ::Qz::ObjectName cppArg0{Qz::ON_WebView};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QObject *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QWheelEvent *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // wheelEvent(Qz::ObjectName,QObject*,QWheelEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::PluginInterface::wheelEvent(cppArg0, cppArg1, cppArg2)
                : cppSelf->wheelEvent(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_PluginInterface_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_PluginInterface_EnumFlagInfo[] = {
    "InitState:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_PluginInterface_methods[] = {
    {"acceptNavigationRequest", reinterpret_cast<PyCFunction>(Sbk_PluginInterfaceFunc_acceptNavigationRequest), METH_VARARGS, nullptr},
    {"init", reinterpret_cast<PyCFunction>(Sbk_PluginInterfaceFunc_init), METH_VARARGS, nullptr},
    {"keyPress", reinterpret_cast<PyCFunction>(Sbk_PluginInterfaceFunc_keyPress), METH_VARARGS, nullptr},
    {"keyRelease", reinterpret_cast<PyCFunction>(Sbk_PluginInterfaceFunc_keyRelease), METH_VARARGS, nullptr},
    {"mouseDoubleClick", reinterpret_cast<PyCFunction>(Sbk_PluginInterfaceFunc_mouseDoubleClick), METH_VARARGS, nullptr},
    {"mouseMove", reinterpret_cast<PyCFunction>(Sbk_PluginInterfaceFunc_mouseMove), METH_VARARGS, nullptr},
    {"mousePress", reinterpret_cast<PyCFunction>(Sbk_PluginInterfaceFunc_mousePress), METH_VARARGS, nullptr},
    {"mouseRelease", reinterpret_cast<PyCFunction>(Sbk_PluginInterfaceFunc_mouseRelease), METH_VARARGS, nullptr},
    {"newWindowRequested", reinterpret_cast<PyCFunction>(Sbk_PluginInterfaceFunc_newWindowRequested), METH_VARARGS, nullptr},
    {"populateExtensionsMenu", reinterpret_cast<PyCFunction>(Sbk_PluginInterfaceFunc_populateExtensionsMenu), METH_O, nullptr},
    {"populateWebViewMenu", reinterpret_cast<PyCFunction>(Sbk_PluginInterfaceFunc_populateWebViewMenu), METH_VARARGS, nullptr},
    {"showSettings", reinterpret_cast<PyCFunction>(Sbk_PluginInterfaceFunc_showSettings), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"testPlugin", reinterpret_cast<PyCFunction>(Sbk_PluginInterfaceFunc_testPlugin), METH_NOARGS, nullptr},
    {"unload", reinterpret_cast<PyCFunction>(Sbk_PluginInterfaceFunc_unload), METH_NOARGS, nullptr},
    {"wheelEvent", reinterpret_cast<PyCFunction>(Sbk_PluginInterfaceFunc_wheelEvent), METH_VARARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_PluginInterface_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::PluginInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<PluginInterfaceWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_PluginInterface_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_PluginInterface_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_PluginInterface_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_PluginInterface_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_PluginInterface_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_PluginInterface_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_PluginInterface_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_PluginInterface_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_PluginInterface_spec = {
    "1:PyFalkon.PluginInterface",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_PluginInterface_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_PluginInterface_InitState(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::PluginInterface::InitState>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::PluginInterface::InitState *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_PluginInterface_InitState_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginInterface_InitState_IDX])))
        return Enum_PythonToCpp_PluginInterface_InitState;
    return {};
}

static PyObject *PluginInterface_InitState_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::PluginInterface::InitState>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::PluginInterface::InitState *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void PluginInterface_PythonToCpp_PluginInterface_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_PluginInterface_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_PluginInterface_PythonToCpp_PluginInterface_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_PluginInterface_TypeF()))
        return PluginInterface_PythonToCpp_PluginInterface_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *PluginInterface_PTR_CppToPython_PluginInterface(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_PluginInterface_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    auto *tCppIn = reinterpret_cast<const ::PluginInterface *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    return Shiboken::Object::newObjectForPointer(Sbk_PluginInterface_TypeF(), const_cast<void *>(cppIn), false, typeName);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *PluginInterface_SignatureStrings[] = {
    "PyFalkon.PluginInterface(self)",
    "PyFalkon.PluginInterface.acceptNavigationRequest(self,page:PyFalkon.WebPage,url:typing.Union[PySide6.QtCore.QUrl, QString],type:PySide6.QtWebEngineCore.QWebEnginePage.NavigationType,isMainFrame:bool)->bool",
    "PyFalkon.PluginInterface.init(self,state:PyFalkon.PluginInterface.InitState,settingsPath:QString)",
    "PyFalkon.PluginInterface.keyPress(self,type:PyFalkon.Qz.ObjectName,obj:PySide6.QtCore.QObject,event:PySide6.QtGui.QKeyEvent)->bool",
    "PyFalkon.PluginInterface.keyRelease(self,type:PyFalkon.Qz.ObjectName,obj:PySide6.QtCore.QObject,event:PySide6.QtGui.QKeyEvent)->bool",
    "PyFalkon.PluginInterface.mouseDoubleClick(self,type:PyFalkon.Qz.ObjectName,obj:PySide6.QtCore.QObject,event:PySide6.QtGui.QMouseEvent)->bool",
    "PyFalkon.PluginInterface.mouseMove(self,type:PyFalkon.Qz.ObjectName,obj:PySide6.QtCore.QObject,event:PySide6.QtGui.QMouseEvent)->bool",
    "PyFalkon.PluginInterface.mousePress(self,type:PyFalkon.Qz.ObjectName,obj:PySide6.QtCore.QObject,event:PySide6.QtGui.QMouseEvent)->bool",
    "PyFalkon.PluginInterface.mouseRelease(self,type:PyFalkon.Qz.ObjectName,obj:PySide6.QtCore.QObject,event:PySide6.QtGui.QMouseEvent)->bool",
    "PyFalkon.PluginInterface.newWindowRequested(self,page:PyFalkon.WebPage,request:PySide6.QtWebEngineCore.QWebEngineNewWindowRequest)->bool",
    "PyFalkon.PluginInterface.populateExtensionsMenu(self,menu:PySide6.QtWidgets.QMenu)",
    "PyFalkon.PluginInterface.populateWebViewMenu(self,menu:PySide6.QtWidgets.QMenu,view:PyFalkon.WebView,r:PyFalkon.WebHitTestResult)",
    "PyFalkon.PluginInterface.showSettings(self,parent:PySide6.QtWidgets.QWidget=nullptr)",
    "PyFalkon.PluginInterface.testPlugin(self)->bool",
    "PyFalkon.PluginInterface.unload(self)",
    "PyFalkon.PluginInterface.wheelEvent(self,type:PyFalkon.Qz.ObjectName,obj:PySide6.QtCore.QObject,event:PySide6.QtGui.QWheelEvent)->bool",
    nullptr}; // Sentinel
#else
static constexpr size_t PluginInterface_SignatureByteSize = 439;
static constexpr uint8_t PluginInterface_SignatureBytes[439] = {
    0x78, 0xda, 0xc5, 0x95, 0xc1, 0x6e, 0xdb, 0x30, 0x0c, 0x86, 0xef, 0x7b, 0x8a, 0x1d, 0x17, 0x40,
    0xf3, 0x71, 0x07, 0x03, 0xdb, 0xa5, 0x4d, 0xb7, 0x62, 0x48, 0x67, 0x27, 0xed, 0x72, 0x18, 0x76,
    0x90, 0xed, 0xbf, 0x8e, 0x1a, 0x45, 0x72, 0x25, 0x2a, 0x9e, 0xfb, 0xf4, 0xa5, 0x6b, 0x27, 0x4b,
    0x02, 0x34, 0x6e, 0x80, 0x16, 0x3d, 0x59, 0xa6, 0x7e, 0x92, 0x1f, 0x69, 0x99, 0x4a, 0x9a, 0x0b,
    0xa9, 0x97, 0xd6, 0x44, 0x89, 0x0e, 0xa5, 0x32, 0x97, 0x86, 0xe0, 0x6e, 0x65, 0x8e, 0x4f, 0x1e,
    0xfa, 0x76, 0xf4, 0x21, 0x79, 0x66, 0x3b, 0x92, 0x79, 0x8e, 0x8a, 0xae, 0xe4, 0x5a, 0x95, 0x92,
    0x94, 0x35, 0x53, 0xdc, 0x07, 0x78, 0x7a, 0x72, 0x13, 0x95, 0x2c, 0x11, 0x6f, 0x5d, 0xe7, 0xc8,
    0x12, 0x36, 0x88, 0xe0, 0x74, 0x4c, 0x4d, 0xa5, 0x4c, 0x19, 0xdd, 0x18, 0x76, 0xf9, 0x93, 0x34,
    0x33, 0x55, 0xe0, 0x4b, 0x94, 0xd2, 0x99, 0x75, 0x88, 0xd2, 0x1b, 0xa7, 0xc5, 0xc7, 0x74, 0x46,
    0x8e, 0x25, 0x7f, 0x05, 0x4b, 0xdb, 0x20, 0x1b, 0x09, 0x47, 0x19, 0x1b, 0x46, 0x40, 0xa7, 0xdd,
    0xbe, 0xb6, 0xa1, 0xa3, 0xff, 0x1c, 0xd7, 0xec, 0x25, 0x94, 0x9f, 0x48, 0x65, 0x2e, 0x9c, 0x5c,
    0x21, 0xce, 0xac, 0xd5, 0xa3, 0xcf, 0xdf, 0xda, 0xc7, 0xf3, 0xd5, 0x28, 0xa3, 0x7a, 0x74, 0x4f,
    0x92, 0x76, 0xd8, 0x0f, 0x85, 0x97, 0x2c, 0x9c, 0xb5, 0x12, 0xe1, 0x41, 0xc4, 0x9c, 0x3e, 0x91,
    0xb4, 0x88, 0x7b, 0xe8, 0x23, 0xfd, 0x5a, 0xa2, 0x49, 0x1c, 0xbc, 0xef, 0xb2, 0xf4, 0xb5, 0xf5,
    0xda, 0xf4, 0x21, 0xfa, 0x95, 0xdd, 0x21, 0xe7, 0x76, 0xae, 0x20, 0x6c, 0x76, 0x17, 0x1f, 0x76,
    0xa6, 0xdb, 0x16, 0x58, 0xc3, 0xd0, 0xce, 0xe6, 0xf7, 0xa0, 0xa2, 0xf4, 0x27, 0x9a, 0x71, 0x6b,
    0x1f, 0x2c, 0x92, 0x11, 0xa6, 0xd0, 0x90, 0x1e, 0xef, 0x08, 0xb1, 0xb2, 0xc1, 0xe3, 0xdc, 0x86,
    0x4c, 0xe3, 0x4c, 0xab, 0x7c, 0xf9, 0xfa, 0x28, 0x93, 0x36, 0xc3, 0x09, 0x30, 0x13, 0xbb, 0xc6,
    0xfb, 0x53, 0xbc, 0xd1, 0xe1, 0x38, 0x15, 0xe3, 0xcd, 0x0e, 0xc8, 0x09, 0x20, 0x06, 0xf5, 0x5c,
    0x99, 0xc2, 0xd6, 0xfd, 0x4c, 0x41, 0x71, 0x6c, 0xaa, 0xb8, 0x4e, 0xf4, 0x82, 0x49, 0x71, 0x75,
    0x10, 0x77, 0x10, 0xa4, 0xb2, 0x55, 0xd0, 0xfc, 0xaf, 0x8f, 0xff, 0x11, 0x8c, 0xe7, 0xe1, 0xe2,
    0x27, 0x30, 0xa1, 0x83, 0x59, 0xf1, 0x6a, 0x37, 0xa7, 0x2a, 0x4a, 0x90, 0xe7, 0x3a, 0xd9, 0x3e,
    0x1a, 0x0e, 0xc9, 0x50, 0xbf, 0x15, 0xea, 0x97, 0xc5, 0x13, 0x6b, 0x96, 0xee, 0x55, 0xde, 0xfa,
    0x0a, 0xb7, 0x67, 0xfa, 0xa1, 0xe8, 0x9a, 0x8b, 0x9a, 0xc2, 0x07, 0x4d, 0x47, 0x08, 0xfc, 0xc2,
    0xd6, 0xb3, 0x7e, 0x76, 0x6d, 0xfa, 0xea, 0xf6, 0x3f, 0xd8, 0x36, 0x79, 0xb7, 0xf8, 0x6a, 0x82,
    0xd6, 0x15, 0xb9, 0x23, 0x41, 0x89, 0x33, 0x77, 0xb6, 0xee, 0xde, 0x18, 0xea, 0x6c, 0x30, 0xda,
    0xca, 0x62, 0xe8, 0x8e, 0xa9, 0x17, 0x80, 0x7e, 0x3a, 0x33, 0xaf, 0x7f, 0x1e, 0xe7, 0xdb, 0xd8,
    0x1b, 0xd8, 0x47, 0x47, 0xcb, 0x97, 0xdd
};
#endif

PyTypeObject *init_PluginInterface(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX].type;

    Shiboken::AutoDecRef Sbk_PluginInterface_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_PluginInterface_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "PluginInterface",
        "PluginInterface*",
        &Sbk_PluginInterface_spec,
        &Shiboken::callCppDestructor< PluginInterface >,
        Sbk_PluginInterface_Type_bases.object(),
        0);
    auto *pyType = Sbk_PluginInterface_TypeF(); // references _Sbk_PluginInterface_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, PluginInterface_SignatureStrings);
#else
    InitSignatureBytes(pyType, PluginInterface_SignatureBytes, PluginInterface_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_PluginInterface_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        PluginInterface_PythonToCpp_PluginInterface_PTR,
        is_PluginInterface_PythonToCpp_PluginInterface_PTR_Convertible,
        PluginInterface_PTR_CppToPython_PluginInterface);

    Shiboken::Conversions::registerConverterName(converter, "PluginInterface");
    Shiboken::Conversions::registerConverterName(converter, "PluginInterface*");
    Shiboken::Conversions::registerConverterName(converter, "PluginInterface&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::PluginInterface).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(PluginInterfaceWrapper).name());

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_PluginInterface_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'InitState'.
    const char *InitState_Initializer[] = {
        "StartupInitState",
        "LateInitState",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t InitState_InitializerValues[] = {
        uint8_t(PluginInterface::InitState::StartupInitState), //  0x00  0
        uint8_t(PluginInterface::InitState::LateInitState)     //  0x01  1
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_PluginInterface_TypeF(),
        "1:PyFalkon.PluginInterface.InitState",
        InitState_Initializer, InitState_InitializerValues);
    SbkPyFalkonTypeStructs[SBK_PluginInterface_InitState_IDX].type = EType;
    // Register converter for enum 'PluginInterface::InitState'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            PluginInterface_InitState_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_PluginInterface_InitState,
            is_Enum_PythonToCpp_PluginInterface_InitState_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "PluginInterface::InitState");
        Shiboken::Conversions::registerConverterAlias(converter, "InitState");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'InitState' enum.

    PluginInterfaceWrapper::pysideInitQtMetaTypes();

    return pyType;
}
