/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.tomcat.dbcp.dbcp2.BasicDataSource;
import org.apache.tomcat.dbcp.dbcp2.ConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.DriverConnectionFactory;

final class ConnectionFactoryFactory {
    ConnectionFactoryFactory() {
    }

    static ConnectionFactory createConnectionFactory(BasicDataSource basicDataSource, Driver driver) throws SQLException {
        Properties properties = basicDataSource.getConnectionProperties();
        String string = basicDataSource.getUrl();
        String string2 = basicDataSource.getUserName();
        if (string2 != null) {
            properties.put("user", string2);
        } else {
            basicDataSource.log(String.format("DBCP DataSource configured without a '%s'", "user"));
        }
        String string3 = basicDataSource.getPassword();
        if (string3 != null) {
            properties.put("password", string3);
        } else {
            basicDataSource.log(String.format("DBCP DataSource configured without a '%s'", "password"));
        }
        String string4 = basicDataSource.getConnectionFactoryClassName();
        if (string4 != null) {
            try {
                Class<?> clazz = Class.forName(string4);
                return (ConnectionFactory)clazz.getConstructor(Driver.class, String.class, Properties.class).newInstance(driver, string, properties);
            }
            catch (Exception exception) {
                String string5 = "Cannot load ConnectionFactory implementation '" + string4 + "'";
                basicDataSource.log(string5, exception);
                throw new SQLException(string5, exception);
            }
        }
        return new DriverConnectionFactory(driver, string, properties);
    }
}

