/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.primitives;

import com.dickimawbooks.texparserlib.TeXFontFamily;
import com.dickimawbooks.texparserlib.TeXFontShape;
import com.dickimawbooks.texparserlib.TeXFontWeight;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.primitives.TeXFontDeclaration;
import java.io.IOException;

public class TeXFontShapeDeclaration
extends TeXFontDeclaration {
    private TeXFontShape shape;
    private TeXFontShape orgShape;
    private TeXFontWeight orgWeight;
    private TeXFontFamily orgFamily;

    public TeXFontShapeDeclaration(String string, int n) {
        super(string);
        this.orgWeight = TeXFontWeight.INHERIT;
        this.orgFamily = TeXFontFamily.INHERIT;
        this.orgShape = TeXFontShape.INHERIT;
        switch (n) {
            case -1: {
                this.shape = TeXFontShape.INHERIT;
                break;
            }
            case 0: {
                this.shape = TeXFontShape.UP;
                break;
            }
            case 1: {
                this.shape = TeXFontShape.IT;
                break;
            }
            case 2: {
                this.shape = TeXFontShape.SL;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid font shape ID " + n);
            }
        }
    }

    public TeXFontShapeDeclaration(String string, TeXFontShape teXFontShape) {
        super(string);
        this.shape = teXFontShape;
        this.orgWeight = TeXFontWeight.INHERIT;
        this.orgFamily = TeXFontFamily.INHERIT;
        this.orgShape = TeXFontShape.INHERIT;
    }

    @Override
    public Object clone() {
        return new TeXFontShapeDeclaration(this.getName(), this.shape);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXSettings teXSettings = teXParser.getSettings();
        this.orgWeight = teXSettings.getCurrentFontWeight();
        this.orgShape = teXSettings.getCurrentFontShape();
        this.orgFamily = teXSettings.getCurrentFontFamily();
        teXSettings.setFontWeight(TeXFontWeight.MD);
        teXSettings.setFontShape(this.shape);
        teXSettings.setFontFamily(TeXFontFamily.RM);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }

    @Override
    public void end(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXSettings teXSettings = teXParser.getSettings();
        teXSettings.setFontWeight(this.orgWeight);
        teXSettings.setFontShape(this.orgShape);
        teXSettings.setFontFamily(this.orgFamily);
    }
}

