/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree.intermediate;

import org.eclipse.elk.alg.mrtree.graph.TGraph;
import org.eclipse.elk.alg.mrtree.intermediate.CompactionProcessor;
import org.eclipse.elk.alg.mrtree.intermediate.DirectionProcessor;
import org.eclipse.elk.alg.mrtree.intermediate.FanProcessor;
import org.eclipse.elk.alg.mrtree.intermediate.GraphBoundsProcessor;
import org.eclipse.elk.alg.mrtree.intermediate.LevelCoordinatesProcessor;
import org.eclipse.elk.alg.mrtree.intermediate.LevelHeightProcessor;
import org.eclipse.elk.alg.mrtree.intermediate.LevelProcessor;
import org.eclipse.elk.alg.mrtree.intermediate.NeighborsProcessor;
import org.eclipse.elk.alg.mrtree.intermediate.NodePositionProcessor;
import org.eclipse.elk.alg.mrtree.intermediate.RootProcessor;
import org.eclipse.elk.alg.mrtree.intermediate.Untreeifyer;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.alg.ILayoutProcessorFactory;

public enum IntermediateProcessorStrategy implements ILayoutProcessorFactory<TGraph>
{
    ROOT_PROC,
    FAN_PROC,
    LEVEL_PROC,
    NEIGHBORS_PROC,
    LEVEL_HEIGHT,
    DIRECTION_PROC,
    NODE_POSITION_PROC,
    COMPACTION_PROC,
    LEVEL_COORDS,
    GRAPH_BOUNDS_PROC,
    DETREEIFYING_PROC;


    @Override
    public ILayoutProcessor<TGraph> create() {
        switch (this) {
            case ROOT_PROC: {
                return new RootProcessor();
            }
            case FAN_PROC: {
                return new FanProcessor();
            }
            case LEVEL_PROC: {
                return new LevelProcessor();
            }
            case NEIGHBORS_PROC: {
                return new NeighborsProcessor();
            }
            case LEVEL_HEIGHT: {
                return new LevelHeightProcessor();
            }
            case LEVEL_COORDS: {
                return new LevelCoordinatesProcessor();
            }
            case DIRECTION_PROC: {
                return new DirectionProcessor();
            }
            case NODE_POSITION_PROC: {
                return new NodePositionProcessor();
            }
            case COMPACTION_PROC: {
                return new CompactionProcessor();
            }
            case GRAPH_BOUNDS_PROC: {
                return new GraphBoundsProcessor();
            }
            case DETREEIFYING_PROC: {
                return new Untreeifyer();
            }
        }
        throw new IllegalArgumentException("No implementation is available for the layout processor " + this.toString());
    }
}

