/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices;

import java.util.List;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.index.IndexService;
import org.opensearch.index.MergeSchedulerConfig;
import org.opensearch.indices.IndicesService;

@ExperimentalApi
public class ClusterMergeSchedulerConfig {
    public static final Setting<Integer> CLUSTER_MAX_THREAD_COUNT_SETTING = new Setting<Integer>("cluster.index.merge.scheduler.max_thread_count", ClusterMergeSchedulerConfig::getClusterMaxThreadCountDefault, s -> Setting.parseInt(s, 1, "cluster.default.index.merge.scheduler.max_thread_count"), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> CLUSTER_MAX_MERGE_COUNT_SETTING = new Setting<Integer>("cluster.index.merge.scheduler.max_merge_count", ClusterMergeSchedulerConfig::getClusterMaxMergeCountDefault, s -> Setting.parseInt(s, 1, "cluster.default.index.merge.scheduler.max_merge_count"), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> CLUSTER_AUTO_THROTTLE_SETTING = Setting.boolSetting("cluster.index.merge.scheduler.auto_throttle", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private static volatile String clusterMaxThreadCountDefault;
    private volatile int clusterMaxThreadCount;
    private volatile int clusterMaxMergeCount;
    private volatile boolean clusterAutoThrottleEnabled;
    private final IndicesService indicesService;

    public ClusterMergeSchedulerConfig(IndicesService indicesService) {
        this.indicesService = indicesService;
        ClusterService clusterService = indicesService.clusterService();
        Settings clusterSettings = clusterService.getSettings();
        this.clusterMaxThreadCount = CLUSTER_MAX_THREAD_COUNT_SETTING.get(clusterSettings);
        this.clusterMaxMergeCount = CLUSTER_MAX_MERGE_COUNT_SETTING.get(clusterSettings);
        this.clusterAutoThrottleEnabled = CLUSTER_AUTO_THROTTLE_SETTING.get(clusterSettings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(this::setClusterMaxThreadAndMergeCount, List.of(CLUSTER_MAX_MERGE_COUNT_SETTING, CLUSTER_MAX_THREAD_COUNT_SETTING), this::validateMaxThreadAndMergeCount);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(CLUSTER_AUTO_THROTTLE_SETTING, this::onClusterMergeAutoThrottleUpdate);
    }

    private void validateMaxThreadAndMergeCount(Settings settings) {
        MergeSchedulerConfig.validateMaxThreadAndMergeCount(CLUSTER_MAX_THREAD_COUNT_SETTING.get(settings), CLUSTER_MAX_MERGE_COUNT_SETTING.get(settings));
    }

    private void setClusterMaxThreadAndMergeCount(Settings settings) {
        this.clusterMaxThreadCount = CLUSTER_MAX_THREAD_COUNT_SETTING.get(settings);
        this.clusterMaxMergeCount = CLUSTER_MAX_MERGE_COUNT_SETTING.get(settings);
        for (IndexService indexService : this.indicesService) {
            indexService.onDefaultMaxMergeOrThreadCountUpdate(this.clusterMaxThreadCount, this.clusterMaxMergeCount);
        }
    }

    private void onClusterMergeAutoThrottleUpdate(Boolean value) {
        this.clusterAutoThrottleEnabled = value;
        for (IndexService indexService : this.indicesService) {
            indexService.onDefaultAutoThrottleEnabledUpdate(this.clusterAutoThrottleEnabled);
        }
    }

    public Integer getClusterMaxMergeCount() {
        return this.clusterMaxMergeCount;
    }

    public Integer getClusterMaxThreadCount() {
        return this.clusterMaxThreadCount;
    }

    public Boolean getClusterMergeAutoThrottleEnabled() {
        return this.clusterAutoThrottleEnabled;
    }

    public static String getClusterMaxThreadCountDefault(Settings settings) {
        if (OpenSearchExecutors.NODE_PROCESSORS_SETTING.exists(settings) || clusterMaxThreadCountDefault == null) {
            clusterMaxThreadCountDefault = Integer.toString(Math.max(1, Math.min(4, OpenSearchExecutors.allocatedProcessors(settings) / 2)));
        }
        return clusterMaxThreadCountDefault;
    }

    public static String getClusterMaxMergeCountDefault(Settings settings) {
        return Integer.toString(CLUSTER_MAX_THREAD_COUNT_SETTING.get(settings) + 5);
    }
}

