/*
  SPDX-FileCopyrightText: 2025-2026 Laurent Montel <montel@kde.org>

  SPDX-License-Identifier: GPL-2.0-or-later
*/

#pragma once
#include "textautogeneratetext_export.h"
#include <QWidget>
class QLabel;
class QToolButton;
namespace TextAutoGenerateText
{
class TextAutoGenerateTextToolPlugin;
/*!
 * \brief The TextAutoGenerateToolPluginConfigureWidget class
 * \author Laurent Montel <montel@kde.org>
 */
class TEXTAUTOGENERATETEXT_EXPORT TextAutoGenerateToolPluginConfigureWidget : public QWidget
{
    Q_OBJECT
public:
    /*!
     */
    explicit TextAutoGenerateToolPluginConfigureWidget(TextAutoGenerateTextToolPlugin *plugin, QWidget *parent = nullptr);
    /*!
     */
    ~TextAutoGenerateToolPluginConfigureWidget() override;

private:
    TEXTAUTOGENERATETEXT_NO_EXPORT void generateArguments(TextAutoGenerateTextToolPlugin *plugin);
    [[nodiscard]] TEXTAUTOGENERATETEXT_NO_EXPORT QLabel *createLabel(const QString &label);
    QLabel *const mDescriptionLabel;
    QLabel *const mArgumentsLabel;
    QToolButton *const mInfoToolButton;
};

}
