/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.commandsearch;

import java.awt.event.InputEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.svgicons.FreeplaneIconFactory;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.commandsearch.ItemChecker;
import org.freeplane.features.commandsearch.SearchItem;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.mindmapmode.MModeController;

public class PreferencesItem
extends SearchItem {
    private static final ImageIcon OPTION_ICON = FreeplaneIconFactory.toImageIcon(ResourceController.getResourceController().getIcon("Option.icon"));
    private static final ImageIcon SELECTED_OPTION_ICON = FreeplaneIconFactory.toImageIcon(ResourceController.getResourceController().getIcon("SelectedOption.icon"));
    private static final String PREFERENCES_PATH = TextUtils.getText("ShowPreferencesAction.text") + "->";
    private final String tabIdentifier;
    private final String tabLabel;
    private final String propertyName;
    private final String displayedText;
    private final String searchedText;
    private final String tooltip;

    PreferencesItem(String tabIdentifier, String tabLabel, String propertyName, String path, String tooltip) {
        this.tabIdentifier = tabIdentifier;
        this.tabLabel = tabLabel != null ? tabLabel : tabIdentifier;
        this.propertyName = propertyName;
        String safePath = path != null ? path : "";
        this.displayedText = this.tabLabel + "->" + safePath;
        this.searchedText = PreferencesItem.normalizeText(safePath);
        this.tooltip = tooltip;
    }

    @Override
    int getItemTypeRank() {
        return 1;
    }

    @Override
    public String getComparedText() {
        return this.displayedText;
    }

    @Override
    public Icon getTypeIcon() {
        return ResourceController.getResourceController().getBooleanProperty(this.propertyName, false) ? SELECTED_OPTION_ICON : OPTION_ICON;
    }

    @Override
    public String getDisplayedText() {
        return this.displayedText;
    }

    @Override
    public String getTooltip() {
        return this.tooltip;
    }

    @Override
    void execute(InputEvent event) {
        this.openPreferences();
    }

    public void openPreferences() {
        Controller controller = Controller.getCurrentController();
        MModeController modeController = (MModeController)controller.getModeController("MindMap");
        modeController.showPreferences(this.getTabIdentifier(), this.getPropertyName());
    }

    @Override
    void assignNewAccelerator() {
    }

    @Override
    boolean shouldUpdateResultList() {
        return false;
    }

    public String toString() {
        return "PreferencesItem [displayedText=" + this.displayedText + "]";
    }

    @Override
    protected boolean checkAndMatch(String searchTerm, ItemChecker textChecker) {
        return textChecker.contains(this.searchedText, searchTerm);
    }

    String getTab() {
        return this.tabLabel;
    }

    String getTabIdentifier() {
        return this.tabIdentifier != null ? this.tabIdentifier : this.tabLabel;
    }

    String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String getCopiedText() {
        return PREFERENCES_PATH + this.getDisplayedText();
    }
}

