/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt.internal_4742761;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import org.jacoco.agent.rt.internal_4742761.ClassFileDumper;
import org.jacoco.agent.rt.internal_4742761.IExceptionLogger;
import org.jacoco.agent.rt.internal_4742761.core.instr.Instrumenter;
import org.jacoco.agent.rt.internal_4742761.core.runtime.AgentOptions;
import org.jacoco.agent.rt.internal_4742761.core.runtime.IRuntime;
import org.jacoco.agent.rt.internal_4742761.core.runtime.WildcardMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageTransformer
implements ClassFileTransformer {
    private static final String AGENT_PREFIX;
    private final Instrumenter instrumenter;
    private final IExceptionLogger logger;
    private final WildcardMatcher includes;
    private final WildcardMatcher excludes;
    private final WildcardMatcher exclClassloader;
    private final ClassFileDumper classFileDumper;
    private final boolean inclBootstrapClasses;
    private final boolean inclNoLocationClasses;

    public CoverageTransformer(IRuntime runtime, AgentOptions options, IExceptionLogger logger) {
        this.instrumenter = new Instrumenter(runtime);
        this.logger = logger;
        this.includes = new WildcardMatcher(CoverageTransformer.toVMName(options.getIncludes()));
        this.excludes = new WildcardMatcher(CoverageTransformer.toVMName(options.getExcludes()));
        this.exclClassloader = new WildcardMatcher(options.getExclClassloader());
        this.classFileDumper = new ClassFileDumper(options.getClassDumpDir());
        this.inclBootstrapClasses = options.getInclBootstrapClasses();
        this.inclNoLocationClasses = options.getInclNoLocationClasses();
    }

    @Override
    public byte[] transform(ClassLoader loader, String classname, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (classBeingRedefined != null) {
            return null;
        }
        if (!this.filter(loader, classname, protectionDomain)) {
            return null;
        }
        try {
            this.classFileDumper.dump(classname, classfileBuffer);
            return this.instrumenter.instrument(classfileBuffer, classname);
        }
        catch (Exception ex) {
            IllegalClassFormatException wrapper = new IllegalClassFormatException(ex.getMessage());
            wrapper.initCause(ex);
            this.logger.logExeption(wrapper);
            throw wrapper;
        }
    }

    boolean filter(ClassLoader loader, String classname, ProtectionDomain protectionDomain) {
        if (loader == null) {
            if (!this.inclBootstrapClasses) {
                return false;
            }
        } else {
            if (!this.inclNoLocationClasses && !this.hasSourceLocation(protectionDomain)) {
                return false;
            }
            if (this.exclClassloader.matches(loader.getClass().getName())) {
                return false;
            }
        }
        return !classname.startsWith(AGENT_PREFIX) && this.includes.matches(classname) && !this.excludes.matches(classname);
    }

    private boolean hasSourceLocation(ProtectionDomain protectionDomain) {
        if (protectionDomain == null) {
            return false;
        }
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null) {
            return false;
        }
        return codeSource.getLocation() != null;
    }

    private static String toVMName(String srcName) {
        return srcName.replace('.', '/');
    }

    static {
        String name = CoverageTransformer.class.getName();
        AGENT_PREFIX = CoverageTransformer.toVMName(name.substring(0, name.lastIndexOf(46)));
    }
}

