/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUTextureDescriptor.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSGPUExtent3DDict.h"
#include "JSGPUTextureDimension.h"
#include "JSGPUTextureFormat.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/Variant.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPUTextureDescriptor>> convertDictionary<GPUTextureDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPUTextureDescriptor result;
    JSValue labelValue;
    if (isNullOrUndefined)
        labelValue = jsUndefined();
    else {
        labelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "label"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!labelValue.isUndefined()) {
        auto labelConversionResult = convert<IDLUSVString>(lexicalGlobalObject, labelValue);
        if (labelConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.label = labelConversionResult.releaseReturnValue();
    }
    JSValue dimensionValue;
    if (isNullOrUndefined)
        dimensionValue = jsUndefined();
    else {
        dimensionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "dimension"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto dimensionConversionResult = convertOptionalWithDefault<IDLEnumeration<GPUTextureDimension>>(lexicalGlobalObject, dimensionValue, [&]() -> ConversionResult<IDLEnumeration<GPUTextureDimension>> { return Converter<IDLEnumeration<GPUTextureDimension>>::ReturnType { GPUTextureDimension::_2d }; });
    if (dimensionConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.dimension = dimensionConversionResult.releaseReturnValue();
    JSValue formatValue;
    if (isNullOrUndefined)
        formatValue = jsUndefined();
    else {
        formatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "format"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (formatValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "format"_s, "GPUTextureDescriptor"_s, "GPUTextureFormat"_s);
        return ConversionResultException { };
    }
    auto formatConversionResult = convert<IDLEnumeration<GPUTextureFormat>>(lexicalGlobalObject, formatValue);
    if (formatConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.format = formatConversionResult.releaseReturnValue();
    JSValue mipLevelCountValue;
    if (isNullOrUndefined)
        mipLevelCountValue = jsUndefined();
    else {
        mipLevelCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "mipLevelCount"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto mipLevelCountConversionResult = convertOptionalWithDefault<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, mipLevelCountValue, [&]() -> ConversionResult<IDLEnforceRangeAdaptor<IDLUnsignedLong>> { return Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType { 1 }; });
    if (mipLevelCountConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.mipLevelCount = mipLevelCountConversionResult.releaseReturnValue();
    JSValue sampleCountValue;
    if (isNullOrUndefined)
        sampleCountValue = jsUndefined();
    else {
        sampleCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sampleCount"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto sampleCountConversionResult = convertOptionalWithDefault<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, sampleCountValue, [&]() -> ConversionResult<IDLEnforceRangeAdaptor<IDLUnsignedLong>> { return Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType { 1 }; });
    if (sampleCountConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.sampleCount = sampleCountConversionResult.releaseReturnValue();
    JSValue sizeValue;
    if (isNullOrUndefined)
        sizeValue = jsUndefined();
    else {
        sizeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "size"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (sizeValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "size"_s, "GPUTextureDescriptor"_s, "(sequence or GPUExtent3DDict)"_s);
        return ConversionResultException { };
    }
    auto sizeConversionResult = convert<IDLUnion<IDLSequence<IDLEnforceRangeAdaptor<IDLUnsignedLong>>, IDLDictionary<GPUExtent3DDict>>>(lexicalGlobalObject, sizeValue);
    if (sizeConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.size = sizeConversionResult.releaseReturnValue();
    JSValue usageValue;
    if (isNullOrUndefined)
        usageValue = jsUndefined();
    else {
        usageValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "usage"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (usageValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "usage"_s, "GPUTextureDescriptor"_s, "unsigned long"_s);
        return ConversionResultException { };
    }
    auto usageConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, usageValue);
    if (usageConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.usage = usageConversionResult.releaseReturnValue();
    JSValue viewFormatsValue;
    if (isNullOrUndefined)
        viewFormatsValue = jsUndefined();
    else {
        viewFormatsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "viewFormats"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto viewFormatsConversionResult = convertOptionalWithDefault<IDLSequence<IDLEnumeration<GPUTextureFormat>>>(lexicalGlobalObject, viewFormatsValue, [&]() -> ConversionResult<IDLSequence<IDLEnumeration<GPUTextureFormat>>> { return Converter<IDLSequence<IDLEnumeration<GPUTextureFormat>>>::ReturnType { }; });
    if (viewFormatsConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.viewFormats = viewFormatsConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore

