// Copyright 2018 gRPC authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.12.4
// source: grpc_gcp.proto

package grpc_gcp

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A selection of strategies for picking a channel for a call with BIND command.
type ChannelPoolConfig_BindPickStrategy int32

const (
	// No preference -- picking a channel for a BIND call will be no different
	// than for any other calls.
	ChannelPoolConfig_UNSPECIFIED ChannelPoolConfig_BindPickStrategy = 0
	// A channel with the least active streams at the moment of a BIND call
	// initiation will be picked.
	ChannelPoolConfig_LEAST_ACTIVE_STREAMS ChannelPoolConfig_BindPickStrategy = 1
	// Cycle through channels created by the BIND call initiation. I. e. pick
	// a channel in a round-robin manner. Note that some channels may be
	// skipped during channel pool resize.
	ChannelPoolConfig_ROUND_ROBIN ChannelPoolConfig_BindPickStrategy = 2
)

// Enum value maps for ChannelPoolConfig_BindPickStrategy.
var (
	ChannelPoolConfig_BindPickStrategy_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "LEAST_ACTIVE_STREAMS",
		2: "ROUND_ROBIN",
	}
	ChannelPoolConfig_BindPickStrategy_value = map[string]int32{
		"UNSPECIFIED":          0,
		"LEAST_ACTIVE_STREAMS": 1,
		"ROUND_ROBIN":          2,
	}
)

func (x ChannelPoolConfig_BindPickStrategy) Enum() *ChannelPoolConfig_BindPickStrategy {
	p := new(ChannelPoolConfig_BindPickStrategy)
	*p = x
	return p
}

func (x ChannelPoolConfig_BindPickStrategy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ChannelPoolConfig_BindPickStrategy) Descriptor() protoreflect.EnumDescriptor {
	return file_grpc_gcp_proto_enumTypes[0].Descriptor()
}

func (ChannelPoolConfig_BindPickStrategy) Type() protoreflect.EnumType {
	return &file_grpc_gcp_proto_enumTypes[0]
}

func (x ChannelPoolConfig_BindPickStrategy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ChannelPoolConfig_BindPickStrategy.Descriptor instead.
func (ChannelPoolConfig_BindPickStrategy) EnumDescriptor() ([]byte, []int) {
	return file_grpc_gcp_proto_rawDescGZIP(), []int{1, 0}
}

type AffinityConfig_Command int32

const (
	// The annotated method will be required to be bound to an existing session
	// to execute the RPC. The corresponding <affinity_key_field_path> will be
	// used to find the affinity key from the request message.
	AffinityConfig_BOUND AffinityConfig_Command = 0
	// The annotated method will establish the channel affinity with the
	// channel which is used to execute the RPC. The corresponding
	// <affinity_key_field_path> will be used to find the affinity key from the
	// response message.
	AffinityConfig_BIND AffinityConfig_Command = 1
	// The annotated method will remove the channel affinity with the
	// channel which is used to execute the RPC. The corresponding
	// <affinity_key_field_path> will be used to find the affinity key from the
	// request message.
	AffinityConfig_UNBIND AffinityConfig_Command = 2
)

// Enum value maps for AffinityConfig_Command.
var (
	AffinityConfig_Command_name = map[int32]string{
		0: "BOUND",
		1: "BIND",
		2: "UNBIND",
	}
	AffinityConfig_Command_value = map[string]int32{
		"BOUND":  0,
		"BIND":   1,
		"UNBIND": 2,
	}
)

func (x AffinityConfig_Command) Enum() *AffinityConfig_Command {
	p := new(AffinityConfig_Command)
	*p = x
	return p
}

func (x AffinityConfig_Command) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AffinityConfig_Command) Descriptor() protoreflect.EnumDescriptor {
	return file_grpc_gcp_proto_enumTypes[1].Descriptor()
}

func (AffinityConfig_Command) Type() protoreflect.EnumType {
	return &file_grpc_gcp_proto_enumTypes[1]
}

func (x AffinityConfig_Command) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AffinityConfig_Command.Descriptor instead.
func (AffinityConfig_Command) EnumDescriptor() ([]byte, []int) {
	return file_grpc_gcp_proto_rawDescGZIP(), []int{3, 0}
}

type ApiConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The channel pool configurations.
	ChannelPool *ChannelPoolConfig `protobuf:"bytes,2,opt,name=channel_pool,json=channelPool,proto3" json:"channel_pool,omitempty"`
	// The method configurations.
	Method []*MethodConfig `protobuf:"bytes,1001,rep,name=method,proto3" json:"method,omitempty"`
}

func (x *ApiConfig) Reset() {
	*x = ApiConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grpc_gcp_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApiConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApiConfig) ProtoMessage() {}

func (x *ApiConfig) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_gcp_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApiConfig.ProtoReflect.Descriptor instead.
func (*ApiConfig) Descriptor() ([]byte, []int) {
	return file_grpc_gcp_proto_rawDescGZIP(), []int{0}
}

func (x *ApiConfig) GetChannelPool() *ChannelPoolConfig {
	if x != nil {
		return x.ChannelPool
	}
	return nil
}

func (x *ApiConfig) GetMethod() []*MethodConfig {
	if x != nil {
		return x.Method
	}
	return nil
}

// ChannelPoolConfig are options for configuring the channel pool.
// RPCs will be scheduled onto existing channels in the pool until all channels
// have <max_concurrent_streams_low_watermark> number of streams. At this point
// a new channel is spun out. Once <max_size> channels have been spun out and
// each has <max_concurrent_streams_low_watermark> streams, subsequent RPCs will
// hang until any of the in-flight RPCs is finished, freeing up a channel.
type ChannelPoolConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The max number of channels in the pool.
	// Default value is 0, meaning 'unlimited' size.
	MaxSize uint32 `protobuf:"varint,1,opt,name=max_size,json=maxSize,proto3" json:"max_size,omitempty"`
	// The idle timeout (seconds) of channels without bound affinity sessions.
	IdleTimeout uint64 `protobuf:"varint,2,opt,name=idle_timeout,json=idleTimeout,proto3" json:"idle_timeout,omitempty"`
	// The low watermark of max number of concurrent streams in a channel.
	// New channel will be created once it get hit, until we reach the max size of the channel pool.
	// Default value is 100. The valid range is [1, 100]. Any value outside the range will be ignored and the default value will be used.
	// Note: It is not recommended that users adjust this value, since a single channel should generally have no trouble managing the default (maximum) number of streams.
	MaxConcurrentStreamsLowWatermark uint32 `protobuf:"varint,3,opt,name=max_concurrent_streams_low_watermark,json=maxConcurrentStreamsLowWatermark,proto3" json:"max_concurrent_streams_low_watermark,omitempty"`
	// The minimum number of channels in the pool.
	MinSize uint32 `protobuf:"varint,4,opt,name=min_size,json=minSize,proto3" json:"min_size,omitempty"`
	// If a channel mapped to an affinity key is not ready, temporarily fallback
	// to another ready channel.
	// Enabling this fallback is beneficial in scenarios with short RPC timeouts
	// and rather slow connection establishing or during incidents when new
	// connections fail but existing connections still operate.
	FallbackToReady bool `protobuf:"varint,5,opt,name=fallback_to_ready,json=fallbackToReady,proto3" json:"fallback_to_ready,omitempty"`
	// Enables per channel unresponsive connection detection if > 0 and unresponsive_calls > 0.
	// If enabled and more than unresponsive_detection_ms passed since the last response from the server,
	// and >= unresponsive_calls RPC calls (started after last response from the server) timed-out on the client side,
	// then the connection of that channel will be gracefully refreshed. I.e., a new connection will be created for
	// that channel and after the new connection is ready it will replace the old connection. The calls on the old
	// connection will not be interrupted. The unresponsive_detection_ms will be doubled every consecutive refresh
	// if no response from the server is received.
	UnresponsiveDetectionMs uint32 `protobuf:"varint,6,opt,name=unresponsive_detection_ms,json=unresponsiveDetectionMs,proto3" json:"unresponsive_detection_ms,omitempty"`
	// Enables per channel unresponsive connection detection if > 0 and unresponsive_detection_ms > 0.
	// If enabled and more than unresponsive_detection_ms passed since the last response from the server,
	// and >= unresponsive_calls RPC calls (started after last response from the server) timed-out on the client side,
	// then the connection of that channel will be gracefully refreshed. I.e., a new connection will be created for
	// that channel and after the new connection is ready it will replace the old connection. The calls on the old
	// connection will not be interrupted. The unresponsive_detection_ms will be doubled every consecutive refresh
	// if no response from the server is received.
	UnresponsiveCalls uint32 `protobuf:"varint,7,opt,name=unresponsive_calls,json=unresponsiveCalls,proto3" json:"unresponsive_calls,omitempty"`
	// The strategy for picking a channel for a call with BIND command.
	BindPickStrategy ChannelPoolConfig_BindPickStrategy `protobuf:"varint,8,opt,name=bind_pick_strategy,json=bindPickStrategy,proto3,enum=grpc.gcp.ChannelPoolConfig_BindPickStrategy" json:"bind_pick_strategy,omitempty"`
}

func (x *ChannelPoolConfig) Reset() {
	*x = ChannelPoolConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grpc_gcp_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChannelPoolConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChannelPoolConfig) ProtoMessage() {}

func (x *ChannelPoolConfig) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_gcp_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChannelPoolConfig.ProtoReflect.Descriptor instead.
func (*ChannelPoolConfig) Descriptor() ([]byte, []int) {
	return file_grpc_gcp_proto_rawDescGZIP(), []int{1}
}

func (x *ChannelPoolConfig) GetMaxSize() uint32 {
	if x != nil {
		return x.MaxSize
	}
	return 0
}

func (x *ChannelPoolConfig) GetIdleTimeout() uint64 {
	if x != nil {
		return x.IdleTimeout
	}
	return 0
}

func (x *ChannelPoolConfig) GetMaxConcurrentStreamsLowWatermark() uint32 {
	if x != nil {
		return x.MaxConcurrentStreamsLowWatermark
	}
	return 0
}

func (x *ChannelPoolConfig) GetMinSize() uint32 {
	if x != nil {
		return x.MinSize
	}
	return 0
}

func (x *ChannelPoolConfig) GetFallbackToReady() bool {
	if x != nil {
		return x.FallbackToReady
	}
	return false
}

func (x *ChannelPoolConfig) GetUnresponsiveDetectionMs() uint32 {
	if x != nil {
		return x.UnresponsiveDetectionMs
	}
	return 0
}

func (x *ChannelPoolConfig) GetUnresponsiveCalls() uint32 {
	if x != nil {
		return x.UnresponsiveCalls
	}
	return 0
}

func (x *ChannelPoolConfig) GetBindPickStrategy() ChannelPoolConfig_BindPickStrategy {
	if x != nil {
		return x.BindPickStrategy
	}
	return ChannelPoolConfig_UNSPECIFIED
}

type MethodConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A fully qualified name of a gRPC method, or a wildcard pattern ending
	// with .*, such as foo.bar.A, foo.bar.*. Method configs are evaluated
	// sequentially, and the first one takes precedence.
	Name []string `protobuf:"bytes,1,rep,name=name,proto3" json:"name,omitempty"`
	// The channel affinity configurations.
	Affinity *AffinityConfig `protobuf:"bytes,1001,opt,name=affinity,proto3" json:"affinity,omitempty"`
}

func (x *MethodConfig) Reset() {
	*x = MethodConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grpc_gcp_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MethodConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MethodConfig) ProtoMessage() {}

func (x *MethodConfig) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_gcp_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MethodConfig.ProtoReflect.Descriptor instead.
func (*MethodConfig) Descriptor() ([]byte, []int) {
	return file_grpc_gcp_proto_rawDescGZIP(), []int{2}
}

func (x *MethodConfig) GetName() []string {
	if x != nil {
		return x.Name
	}
	return nil
}

func (x *MethodConfig) GetAffinity() *AffinityConfig {
	if x != nil {
		return x.Affinity
	}
	return nil
}

type AffinityConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The affinity command applies on the selected gRPC methods.
	Command AffinityConfig_Command `protobuf:"varint,2,opt,name=command,proto3,enum=grpc.gcp.AffinityConfig_Command" json:"command,omitempty"`
	// The field path of the affinity key in the request/response message.
	// For example: "f.a", "f.b.d", etc.
	AffinityKey string `protobuf:"bytes,3,opt,name=affinity_key,json=affinityKey,proto3" json:"affinity_key,omitempty"`
}

func (x *AffinityConfig) Reset() {
	*x = AffinityConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grpc_gcp_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AffinityConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AffinityConfig) ProtoMessage() {}

func (x *AffinityConfig) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_gcp_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AffinityConfig.ProtoReflect.Descriptor instead.
func (*AffinityConfig) Descriptor() ([]byte, []int) {
	return file_grpc_gcp_proto_rawDescGZIP(), []int{3}
}

func (x *AffinityConfig) GetCommand() AffinityConfig_Command {
	if x != nil {
		return x.Command
	}
	return AffinityConfig_BOUND
}

func (x *AffinityConfig) GetAffinityKey() string {
	if x != nil {
		return x.AffinityKey
	}
	return ""
}

var File_grpc_gcp_proto protoreflect.FileDescriptor

var file_grpc_gcp_proto_rawDesc = []byte{
	0x0a, 0x0e, 0x67, 0x72, 0x70, 0x63, 0x5f, 0x67, 0x63, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x08, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x67, 0x63, 0x70, 0x22, 0x7c, 0x0a, 0x09, 0x41, 0x70,
	0x69, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3e, 0x0a, 0x0c, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x67, 0x72, 0x70, 0x63, 0x2e, 0x67, 0x63, 0x70, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x50, 0x6f, 0x6f, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x2f, 0x0a, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x18, 0xe9, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e,
	0x67, 0x63, 0x70, 0x2e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x22, 0xff, 0x03, 0x0a, 0x11, 0x43, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x6f, 0x6f, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x19,
	0x0a, 0x08, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x07, 0x6d, 0x61, 0x78, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x69, 0x64, 0x6c,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x0b, 0x69, 0x64, 0x6c, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x4e, 0x0a, 0x24,
	0x6d, 0x61, 0x78, 0x5f, 0x63, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x5f, 0x6c, 0x6f, 0x77, 0x5f, 0x77, 0x61, 0x74, 0x65, 0x72,
	0x6d, 0x61, 0x72, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x20, 0x6d, 0x61, 0x78, 0x43,
	0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73,
	0x4c, 0x6f, 0x77, 0x57, 0x61, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x72, 0x6b, 0x12, 0x19, 0x0a, 0x08,
	0x6d, 0x69, 0x6e, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07,
	0x6d, 0x69, 0x6e, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x66, 0x61, 0x6c, 0x6c, 0x62,
	0x61, 0x63, 0x6b, 0x5f, 0x74, 0x6f, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0f, 0x66, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x54, 0x6f, 0x52, 0x65,
	0x61, 0x64, 0x79, 0x12, 0x3a, 0x0a, 0x19, 0x75, 0x6e, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x69, 0x76, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x73,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x17, 0x75, 0x6e, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x69, 0x76, 0x65, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x73, 0x12,
	0x2d, 0x0a, 0x12, 0x75, 0x6e, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x69, 0x76, 0x65, 0x5f,
	0x63, 0x61, 0x6c, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x11, 0x75, 0x6e, 0x72,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x69, 0x76, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x73, 0x12, 0x5a,
	0x0a, 0x12, 0x62, 0x69, 0x6e, 0x64, 0x5f, 0x70, 0x69, 0x63, 0x6b, 0x5f, 0x73, 0x74, 0x72, 0x61,
	0x74, 0x65, 0x67, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x72, 0x70,
	0x63, 0x2e, 0x67, 0x63, 0x70, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x6f, 0x6f,
	0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x42, 0x69, 0x6e, 0x64, 0x50, 0x69, 0x63, 0x6b,
	0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x52, 0x10, 0x62, 0x69, 0x6e, 0x64, 0x50, 0x69,
	0x63, 0x6b, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x22, 0x4e, 0x0a, 0x10, 0x42, 0x69,
	0x6e, 0x64, 0x50, 0x69, 0x63, 0x6b, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x0f,
	0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x18, 0x0a, 0x14, 0x4c, 0x45, 0x41, 0x53, 0x54, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x5f,
	0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x53, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x4f, 0x55,
	0x4e, 0x44, 0x5f, 0x52, 0x4f, 0x42, 0x49, 0x4e, 0x10, 0x02, 0x22, 0x59, 0x0a, 0x0c, 0x4d, 0x65,
	0x74, 0x68, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x35,
	0x0a, 0x08, 0x61, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x18, 0xe9, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x18, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x67, 0x63, 0x70, 0x2e, 0x41, 0x66, 0x66,
	0x69, 0x6e, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x08, 0x61, 0x66, 0x66,
	0x69, 0x6e, 0x69, 0x74, 0x79, 0x22, 0x9b, 0x01, 0x0a, 0x0e, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69,
	0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3a, 0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x20, 0x2e, 0x67, 0x72, 0x70, 0x63,
	0x2e, 0x67, 0x63, 0x70, 0x2e, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x52, 0x07, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x61, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79,
	0x5f, 0x6b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x66, 0x66, 0x69,
	0x6e, 0x69, 0x74, 0x79, 0x4b, 0x65, 0x79, 0x22, 0x2a, 0x0a, 0x07, 0x43, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x12, 0x09, 0x0a, 0x05, 0x42, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a,
	0x04, 0x42, 0x49, 0x4e, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x55, 0x4e, 0x42, 0x49, 0x4e,
	0x44, 0x10, 0x02, 0x42, 0x0c, 0x5a, 0x0a, 0x2e, 0x2f, 0x67, 0x72, 0x70, 0x63, 0x5f, 0x67, 0x63,
	0x70, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_grpc_gcp_proto_rawDescOnce sync.Once
	file_grpc_gcp_proto_rawDescData = file_grpc_gcp_proto_rawDesc
)

func file_grpc_gcp_proto_rawDescGZIP() []byte {
	file_grpc_gcp_proto_rawDescOnce.Do(func() {
		file_grpc_gcp_proto_rawDescData = protoimpl.X.CompressGZIP(file_grpc_gcp_proto_rawDescData)
	})
	return file_grpc_gcp_proto_rawDescData
}

var file_grpc_gcp_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_grpc_gcp_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_grpc_gcp_proto_goTypes = []interface{}{
	(ChannelPoolConfig_BindPickStrategy)(0), // 0: grpc.gcp.ChannelPoolConfig.BindPickStrategy
	(AffinityConfig_Command)(0),             // 1: grpc.gcp.AffinityConfig.Command
	(*ApiConfig)(nil),                       // 2: grpc.gcp.ApiConfig
	(*ChannelPoolConfig)(nil),               // 3: grpc.gcp.ChannelPoolConfig
	(*MethodConfig)(nil),                    // 4: grpc.gcp.MethodConfig
	(*AffinityConfig)(nil),                  // 5: grpc.gcp.AffinityConfig
}
var file_grpc_gcp_proto_depIdxs = []int32{
	3, // 0: grpc.gcp.ApiConfig.channel_pool:type_name -> grpc.gcp.ChannelPoolConfig
	4, // 1: grpc.gcp.ApiConfig.method:type_name -> grpc.gcp.MethodConfig
	0, // 2: grpc.gcp.ChannelPoolConfig.bind_pick_strategy:type_name -> grpc.gcp.ChannelPoolConfig.BindPickStrategy
	5, // 3: grpc.gcp.MethodConfig.affinity:type_name -> grpc.gcp.AffinityConfig
	1, // 4: grpc.gcp.AffinityConfig.command:type_name -> grpc.gcp.AffinityConfig.Command
	5, // [5:5] is the sub-list for method output_type
	5, // [5:5] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_grpc_gcp_proto_init() }
func file_grpc_gcp_proto_init() {
	if File_grpc_gcp_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_grpc_gcp_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApiConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grpc_gcp_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChannelPoolConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grpc_gcp_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MethodConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grpc_gcp_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AffinityConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_grpc_gcp_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_grpc_gcp_proto_goTypes,
		DependencyIndexes: file_grpc_gcp_proto_depIdxs,
		EnumInfos:         file_grpc_gcp_proto_enumTypes,
		MessageInfos:      file_grpc_gcp_proto_msgTypes,
	}.Build()
	File_grpc_gcp_proto = out.File
	file_grpc_gcp_proto_rawDesc = nil
	file_grpc_gcp_proto_goTypes = nil
	file_grpc_gcp_proto_depIdxs = nil
}
