#ifndef TopologyToolKit_client_server_h
#define TopologyToolKit_client_server_h

#include "vtkClientServerInterpreter.h"

extern "C" void ttkAlgorithmCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkArrayEditorCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkArrayPreconditioningCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkBarycentricSubdivisionCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkBlockAggregatorCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkBottleneckDistanceCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkCinemaDarkroomCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkCinemaImagingCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkCinemaProductReaderCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkCinemaQueryCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkCinemaReaderCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkCinemaWriterCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkClusteringMetricsCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkComponentSizeCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkConnectedComponentsCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkContinuousScatterPlotCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkContourAroundPointCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkContourForestsCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkContourTreeCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkContourTreeAlignmentCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkDataSetInterpolatorCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkDataSetToTableCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkDepthImageBasedGeometryApproximationCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkDimensionReductionCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkDiscreteGradientCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkDistanceFieldCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkDistanceMatrixDistortionCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkEigenFieldCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkEndForCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkExtractCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkFiberCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkFiberSurfaceCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkFlattenMultiBlockCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkForEachCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkGaussianPointCloudCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkGeometrySmootherCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkGridLayoutCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkHarmonicFieldCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkHelloWorldCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkIcosphereCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkIcosphereFromObjectCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkIcospheresFromPointsCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkIdentifierRandomizerCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkIdentifiersCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkIdentifyByScalarFieldCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkImportEmbeddingFromTableCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkIntegralLinesCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkJacobiSetCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkLDistanceCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkLDistanceMatrixCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkMandatoryCriticalPointsCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkManifoldCheckCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkMarchingTetrahedraCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkMatrixToHeatMapCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkMergeBlockTablesCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkMergeTreeCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkMergeTreeAutoencoderCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkMergeTreeAutoencoderDecodingCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkMergeTreeClusteringCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkMergeTreeDistanceMatrixCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkMergeTreePrincipalGeodesicsCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkMergeTreePrincipalGeodesicsDecodingCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkMergeTreeTemporalReductionCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkMergeTreeTemporalReductionDecodingCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkMeshGraphCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkMeshSubdivisionCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkMetricDistortionCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkMorphologicalOperatorsCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkMorseSmaleComplexCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkMorseSmaleQuadrangulationCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkOBJWriterCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkOFFReaderCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkOFFWriterCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkPathCompressionCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkPeriodicGhostsGenerationCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkPersistenceCurveCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkPersistenceDiagramCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkPersistenceDiagramApproximationCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkPersistenceDiagramClusteringCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkPersistenceDiagramDistanceMatrixCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkPersistentGeneratorsCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkPlanarGraphLayoutCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkPointDataConverterCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkPointDataSelectorCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkPointMergerCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkPointSetToCurveCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkPointSetToSurfaceCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkProjectionFromFieldCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkProjectionFromTableCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkQuadrangulationSubdivisionCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkRangePolygonCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkReebGraphCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkReebSpaceCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkRipsComplexCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkRipsPersistenceDiagramCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkScalarFieldCriticalPointsCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkScalarFieldNormalizerCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkScalarFieldSmootherCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkSignedDistanceFieldCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkSphereFromPointCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkStableManifoldPersistenceCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkStringArrayConverterCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkSurfaceGeometrySmootherCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkTableDataSelectorCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkTableDistanceMatrixCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkTextureMapFromFieldCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkTopologicalCompressionCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkTopologicalCompressionReaderCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkTopologicalCompressionWriterCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkTopologicalSimplificationCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkTopologicalSimplificationByPersistenceCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkTrackingFromFieldsCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkTrackingFromOverlapCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkTrackingFromPersistenceDiagramsCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkTriangulationManagerCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkTriangulationReaderCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkTriangulationRequestCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkTriangulationWriterCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkUncertainDataEstimatorCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkWRLExporterCS_Initialize(vtkClientServerInterpreter*);
extern "C" void ttkWebSocketIOCS_Initialize(vtkClientServerInterpreter*);

inline void TopologyToolKit_client_server_initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  ttkAlgorithmCS_Initialize(csi);
  ttkArrayEditorCS_Initialize(csi);
  ttkArrayPreconditioningCS_Initialize(csi);
  ttkBarycentricSubdivisionCS_Initialize(csi);
  ttkBlockAggregatorCS_Initialize(csi);
  ttkBottleneckDistanceCS_Initialize(csi);
  ttkCinemaDarkroomCS_Initialize(csi);
  ttkCinemaImagingCS_Initialize(csi);
  ttkCinemaProductReaderCS_Initialize(csi);
  ttkCinemaQueryCS_Initialize(csi);
  ttkCinemaReaderCS_Initialize(csi);
  ttkCinemaWriterCS_Initialize(csi);
  ttkClusteringMetricsCS_Initialize(csi);
  ttkComponentSizeCS_Initialize(csi);
  ttkConnectedComponentsCS_Initialize(csi);
  ttkContinuousScatterPlotCS_Initialize(csi);
  ttkContourAroundPointCS_Initialize(csi);
  ttkContourForestsCS_Initialize(csi);
  ttkContourTreeCS_Initialize(csi);
  ttkContourTreeAlignmentCS_Initialize(csi);
  ttkDataSetInterpolatorCS_Initialize(csi);
  ttkDataSetToTableCS_Initialize(csi);
  ttkDepthImageBasedGeometryApproximationCS_Initialize(csi);
  ttkDimensionReductionCS_Initialize(csi);
  ttkDiscreteGradientCS_Initialize(csi);
  ttkDistanceFieldCS_Initialize(csi);
  ttkDistanceMatrixDistortionCS_Initialize(csi);
  ttkEigenFieldCS_Initialize(csi);
  ttkEndForCS_Initialize(csi);
  ttkExtractCS_Initialize(csi);
  ttkFiberCS_Initialize(csi);
  ttkFiberSurfaceCS_Initialize(csi);
  ttkFlattenMultiBlockCS_Initialize(csi);
  ttkForEachCS_Initialize(csi);
  ttkGaussianPointCloudCS_Initialize(csi);
  ttkGeometrySmootherCS_Initialize(csi);
  ttkGridLayoutCS_Initialize(csi);
  ttkHarmonicFieldCS_Initialize(csi);
  ttkHelloWorldCS_Initialize(csi);
  ttkIcosphereCS_Initialize(csi);
  ttkIcosphereFromObjectCS_Initialize(csi);
  ttkIcospheresFromPointsCS_Initialize(csi);
  ttkIdentifierRandomizerCS_Initialize(csi);
  ttkIdentifiersCS_Initialize(csi);
  ttkIdentifyByScalarFieldCS_Initialize(csi);
  ttkImportEmbeddingFromTableCS_Initialize(csi);
  ttkIntegralLinesCS_Initialize(csi);
  ttkJacobiSetCS_Initialize(csi);
  ttkLDistanceCS_Initialize(csi);
  ttkLDistanceMatrixCS_Initialize(csi);
  ttkMandatoryCriticalPointsCS_Initialize(csi);
  ttkManifoldCheckCS_Initialize(csi);
  ttkMarchingTetrahedraCS_Initialize(csi);
  ttkMatrixToHeatMapCS_Initialize(csi);
  ttkMergeBlockTablesCS_Initialize(csi);
  ttkMergeTreeCS_Initialize(csi);
  ttkMergeTreeAutoencoderCS_Initialize(csi);
  ttkMergeTreeAutoencoderDecodingCS_Initialize(csi);
  ttkMergeTreeClusteringCS_Initialize(csi);
  ttkMergeTreeDistanceMatrixCS_Initialize(csi);
  ttkMergeTreePrincipalGeodesicsCS_Initialize(csi);
  ttkMergeTreePrincipalGeodesicsDecodingCS_Initialize(csi);
  ttkMergeTreeTemporalReductionCS_Initialize(csi);
  ttkMergeTreeTemporalReductionDecodingCS_Initialize(csi);
  ttkMeshGraphCS_Initialize(csi);
  ttkMeshSubdivisionCS_Initialize(csi);
  ttkMetricDistortionCS_Initialize(csi);
  ttkMorphologicalOperatorsCS_Initialize(csi);
  ttkMorseSmaleComplexCS_Initialize(csi);
  ttkMorseSmaleQuadrangulationCS_Initialize(csi);
  ttkOBJWriterCS_Initialize(csi);
  ttkOFFReaderCS_Initialize(csi);
  ttkOFFWriterCS_Initialize(csi);
  ttkPathCompressionCS_Initialize(csi);
  ttkPeriodicGhostsGenerationCS_Initialize(csi);
  ttkPersistenceCurveCS_Initialize(csi);
  ttkPersistenceDiagramCS_Initialize(csi);
  ttkPersistenceDiagramApproximationCS_Initialize(csi);
  ttkPersistenceDiagramClusteringCS_Initialize(csi);
  ttkPersistenceDiagramDistanceMatrixCS_Initialize(csi);
  ttkPersistentGeneratorsCS_Initialize(csi);
  ttkPlanarGraphLayoutCS_Initialize(csi);
  ttkPointDataConverterCS_Initialize(csi);
  ttkPointDataSelectorCS_Initialize(csi);
  ttkPointMergerCS_Initialize(csi);
  ttkPointSetToCurveCS_Initialize(csi);
  ttkPointSetToSurfaceCS_Initialize(csi);
  ttkProjectionFromFieldCS_Initialize(csi);
  ttkProjectionFromTableCS_Initialize(csi);
  ttkQuadrangulationSubdivisionCS_Initialize(csi);
  ttkRangePolygonCS_Initialize(csi);
  ttkReebGraphCS_Initialize(csi);
  ttkReebSpaceCS_Initialize(csi);
  ttkRipsComplexCS_Initialize(csi);
  ttkRipsPersistenceDiagramCS_Initialize(csi);
  ttkScalarFieldCriticalPointsCS_Initialize(csi);
  ttkScalarFieldNormalizerCS_Initialize(csi);
  ttkScalarFieldSmootherCS_Initialize(csi);
  ttkSignedDistanceFieldCS_Initialize(csi);
  ttkSphereFromPointCS_Initialize(csi);
  ttkStableManifoldPersistenceCS_Initialize(csi);
  ttkStringArrayConverterCS_Initialize(csi);
  ttkSurfaceGeometrySmootherCS_Initialize(csi);
  ttkTableDataSelectorCS_Initialize(csi);
  ttkTableDistanceMatrixCS_Initialize(csi);
  ttkTextureMapFromFieldCS_Initialize(csi);
  ttkTopologicalCompressionCS_Initialize(csi);
  ttkTopologicalCompressionReaderCS_Initialize(csi);
  ttkTopologicalCompressionWriterCS_Initialize(csi);
  ttkTopologicalSimplificationCS_Initialize(csi);
  ttkTopologicalSimplificationByPersistenceCS_Initialize(csi);
  ttkTrackingFromFieldsCS_Initialize(csi);
  ttkTrackingFromOverlapCS_Initialize(csi);
  ttkTrackingFromPersistenceDiagramsCS_Initialize(csi);
  ttkTriangulationManagerCS_Initialize(csi);
  ttkTriangulationReaderCS_Initialize(csi);
  ttkTriangulationRequestCS_Initialize(csi);
  ttkTriangulationWriterCS_Initialize(csi);
  ttkUncertainDataEstimatorCS_Initialize(csi);
  ttkWRLExporterCS_Initialize(csi);
  ttkWebSocketIOCS_Initialize(csi);
}

#endif
