// python wrapper for ttkMergeTree
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkMergeTree.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkMergeTree(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkMergeTree_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkMergeTree_BACKEND_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkMergeTree.ttkMergeTree.BACKEND", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyttkMergeTree_BACKEND_FromEnum(T val)
{
  return PyVTKEnum_New(&PyttkMergeTree_BACKEND_Type, static_cast<int>(val));
}


static PyObject *
PyttkMergeTree_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkMergeTree::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTree_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTree *op = static_cast<ttkMergeTree *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkMergeTree::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTree_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkMergeTree *tempr = ttkMergeTree::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTree_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTree *op = static_cast<ttkMergeTree *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkMergeTree *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkMergeTree::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTree_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkMergeTree::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTree_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTree *op = static_cast<ttkMergeTree *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkMergeTree::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTree_GetForceInputOffsetScalarField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetForceInputOffsetScalarField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTree *op = static_cast<ttkMergeTree *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetForceInputOffsetScalarField() :
      op->ttkMergeTree::GetForceInputOffsetScalarField());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTree_SetForceInputOffsetScalarField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetForceInputOffsetScalarField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTree *op = static_cast<ttkMergeTree *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetForceInputOffsetScalarField(temp0);
    }
    else
    {
      op->ttkMergeTree::SetForceInputOffsetScalarField(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTree_GetBackend(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBackend");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTree *op = static_cast<ttkMergeTree *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetBackend() :
      op->ttkMergeTree::GetBackend());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTree_SetBackend(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBackend");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTree *op = static_cast<ttkMergeTree *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBackend(temp0);
    }
    else
    {
      op->ttkMergeTree::SetBackend(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTree_SetTreeType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTreeType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTree *op = static_cast<ttkMergeTree *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTreeType(temp0);
    }
    else
    {
      op->ttkMergeTree::SetTreeType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTree_SetWithSegmentation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWithSegmentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTree *op = static_cast<ttkMergeTree *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetWithSegmentation(temp0);
    }
    else
    {
      op->ttkMergeTree::SetWithSegmentation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTree_GetWithSegmentation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWithSegmentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTree *op = static_cast<ttkMergeTree *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetWithSegmentation() :
      op->ttkMergeTree::GetWithSegmentation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTree_SetWithNormalize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWithNormalize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTree *op = static_cast<ttkMergeTree *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetWithNormalize(temp0);
    }
    else
    {
      op->ttkMergeTree::SetWithNormalize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTree_GetWithNormalize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWithNormalize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTree *op = static_cast<ttkMergeTree *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetWithNormalize() :
      op->ttkMergeTree::GetWithNormalize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTree_SetWithAdvStats(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWithAdvStats");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTree *op = static_cast<ttkMergeTree *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetWithAdvStats(temp0);
    }
    else
    {
      op->ttkMergeTree::SetWithAdvStats(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTree_GetWithAdvStats(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWithAdvStats");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTree *op = static_cast<ttkMergeTree *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetWithAdvStats() :
      op->ttkMergeTree::GetWithAdvStats());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTree_SetSuperArcSamplingLevel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSuperArcSamplingLevel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTree *op = static_cast<ttkMergeTree *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSuperArcSamplingLevel(temp0);
    }
    else
    {
      op->ttkMergeTree::SetSuperArcSamplingLevel(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTree_GetSuperArcSamplingLevel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSuperArcSamplingLevel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTree *op = static_cast<ttkMergeTree *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSuperArcSamplingLevel() :
      op->ttkMergeTree::GetSuperArcSamplingLevel());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkMergeTree_Methods[] = {
  {"IsTypeOf", PyttkMergeTree_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkMergeTree_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkMergeTree_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkMergeTree\nC++: static ttkMergeTree *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkMergeTree_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkMergeTree\nC++: ttkMergeTree *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkMergeTree_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkMergeTree_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetForceInputOffsetScalarField", PyttkMergeTree_GetForceInputOffsetScalarField, METH_VARARGS,
   "GetForceInputOffsetScalarField(self) -> bool\nC++: virtual bool GetForceInputOffsetScalarField()\n\n"},
  {"SetForceInputOffsetScalarField", PyttkMergeTree_SetForceInputOffsetScalarField, METH_VARARGS,
   "SetForceInputOffsetScalarField(self, _arg:bool) -> None\nC++: virtual void SetForceInputOffsetScalarField(bool _arg)\n\n"},
  {"GetBackend", PyttkMergeTree_GetBackend, METH_VARARGS,
   "GetBackend(self) -> int\nC++: virtual int GetBackend()\n\n"},
  {"SetBackend", PyttkMergeTree_SetBackend, METH_VARARGS,
   "SetBackend(self, _arg:int) -> None\nC++: virtual void SetBackend(int _arg)\n\n"},
  {"SetTreeType", PyttkMergeTree_SetTreeType, METH_VARARGS,
   "SetTreeType(self, type:int) -> None\nC++: void SetTreeType(const int type)\n\n"},
  {"SetWithSegmentation", PyttkMergeTree_SetWithSegmentation, METH_VARARGS,
   "SetWithSegmentation(self, segm:bool) -> None\nC++: void SetWithSegmentation(const bool segm)\n\n"},
  {"GetWithSegmentation", PyttkMergeTree_GetWithSegmentation, METH_VARARGS,
   "GetWithSegmentation(self) -> bool\nC++: bool GetWithSegmentation()\n\n"},
  {"SetWithNormalize", PyttkMergeTree_SetWithNormalize, METH_VARARGS,
   "SetWithNormalize(self, norm:bool) -> None\nC++: void SetWithNormalize(const bool norm)\n\n"},
  {"GetWithNormalize", PyttkMergeTree_GetWithNormalize, METH_VARARGS,
   "GetWithNormalize(self) -> bool\nC++: bool GetWithNormalize()\n\n"},
  {"SetWithAdvStats", PyttkMergeTree_SetWithAdvStats, METH_VARARGS,
   "SetWithAdvStats(self, adv:bool) -> None\nC++: void SetWithAdvStats(const bool adv)\n\n"},
  {"GetWithAdvStats", PyttkMergeTree_GetWithAdvStats, METH_VARARGS,
   "GetWithAdvStats(self) -> bool\nC++: bool GetWithAdvStats()\n\n"},
  {"SetSuperArcSamplingLevel", PyttkMergeTree_SetSuperArcSamplingLevel, METH_VARARGS,
   "SetSuperArcSamplingLevel(self, lvl:int) -> None\nC++: void SetSuperArcSamplingLevel(int lvl)\n\n"},
  {"GetSuperArcSamplingLevel", PyttkMergeTree_GetSuperArcSamplingLevel, METH_VARARGS,
   "GetSuperArcSamplingLevel(self) -> int\nC++: int GetSuperArcSamplingLevel()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkMergeTree_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("force_input_offset_scalar_field"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTree_GetForceInputOffsetScalarField(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTree_SetForceInputOffsetScalarField(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTree_SetForceInputOffsetScalarField(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetForceInputOffsetScalarField/SetForceInputOffsetScalarField\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("backend"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTree_GetBackend(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTree_SetBackend(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTree_SetBackend(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBackend/SetBackend\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tree_type"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTree_SetTreeType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTree_SetTreeType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTreeType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("with_segmentation"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTree_GetWithSegmentation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTree_SetWithSegmentation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTree_SetWithSegmentation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWithSegmentation/SetWithSegmentation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("with_normalize"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTree_GetWithNormalize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTree_SetWithNormalize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTree_SetWithNormalize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWithNormalize/SetWithNormalize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("with_adv_stats"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTree_GetWithAdvStats(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTree_SetWithAdvStats(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTree_SetWithAdvStats(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWithAdvStats/SetWithAdvStats\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("super_arc_sampling_level"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTree_GetSuperArcSamplingLevel(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTree_SetSuperArcSamplingLevel(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTree_SetSuperArcSamplingLevel(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSuperArcSamplingLevel/SetSuperArcSamplingLevel\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkMergeTree_Doc =
  "ttkMergeTree - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Charles Gueunet <charles.gueunet@kitware.com>\\date June 2017.\n\n"
  "\\sa ttk::ftm::FTMTree\n\n"
  "TTK filter for the computation of merge trees.\n\n"
  "The computation of the merge tree done by this package is done in\n"
  "parallel if TTK_ENABLE_OPENMP is set to ON, using a task based\n"
  "approach described in the article mention below. The VTK wrapper will\n"
  "first call a connectivity filter, and then call a merge tree\n"
  "computation for each connected components. The final tree is then\n"
  "aggregated.\n\n"
  "\\param Input Input scalar field, either 2D or 3D, regular\n"
  "grid or triangulation (vtkDataSet)\n"
  "\\param TreeType the Type of three to Compute:\n\n"
  "* Join Tree (leaves corresponds to minima of the scalar field)\n"
  "* Split Tree (leaves corresponds to maxima of the scalar field)\n"
  "\\param Segmentation control wethear or not the output should be\n"
  "    augmented\n"
  "with the segmentation.\n"
  "\\param SuperArcSamplingLevel control the number of subdivision of\n"
  "    each\n"
  "superarc. Intermediate point will be located on the barycenter of the\n"
  "corresponding portion of vertex.\n"
  "\\param Output the output of this filter is composed of:\n\n"
  "1. The nodes of the tree\n"
  "2. The arcs of the tree\n"
  "3. The semgentation of the initial dataset\n"
  "The structure of the tree (Nodes+Arcs) have a concept of nodeId,\n"
  "which is an id that is consistent between execution if\n"
  "SetWithNormalize is set to True. The downNodeId of an arc is its\n"
  "starting node (directed towards the leaves as the computation starts\n"
  "here) and the upNodeId it the ending node, in direction of the Root\n"
  "of the tree. The segmentation also contains some basics metrics like\n"
  "the size of each region (RegionSpan) or its number of vertex\n"
  "(RegionSize)\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(), GetOutput()).\n\n"
  "Related publication\n\n"
  "\"Task-based Augmented Merge Trees with Fibonacci Heaps\"\n\n"
  "Charles Gueunet, Pierre Fortin, Julien Jomier, Julien Tierny\n\n"
  "2017 IEEE 7th Symposium on Large Data Analysis and Visualization\n"
  "(LDAV), doi: 10.1109/LDAV.2017.8231846.\n\n"
  "\"Task-based augmented contour trees with fibonacci heaps\"\n\n"
  "Charles Gueunet, Pierre Fortin, Julien Jomier, Julien Tierny\n\n"
  "IEEE Transactions on Parallel and Distributed Systems, Volume 30,\n"
  "Issue 8, Pages 1889-1905\n\n"
  "Online examples:\n\n"
  "- <a href=\"https://topology-tool-kit.github.io/examples/ctBones/\">CT\n"
  "  Bones example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/interactionSites/\"\n"
  "  > Interaction sites\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/mergeTreeClustering/\"\n"
  "  >Merge Tree Clustering example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/mergeTreeFeatureTracking/\"\n"
  "  >Merge Tree Feature Tracking example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/mergeTreePGA/\">Me\n"
  "  rge Tree Principal Geodesic Analysis example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/mergeTreeTemporalReduction/\"\n"
  "  >Merge Tree Temporal Reduction\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/mergeTreeWAE/\">Me\n"
  "  rge tree Wasserstein Auto-Encoder example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/mergeTreeExTreeM/\"\n"
  "  >Merge Trees Via ExTreeM\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkMergeTree_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkMergeTree.ttkMergeTree", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkMergeTree_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkMergeTree_StaticNew()
{
  return ttkMergeTree::New();
}

PyObject *PyttkMergeTree_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkMergeTree_Type, PyttkMergeTree_Methods,
    "ttkMergeTree",
 &PyttkMergeTree_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyttkMergeTree_BACKEND_Type);
  // members of ttkMergeTree::BACKEND
  {
    PyObject *enumval;
    PyObject *enumdict = PyDict_New();
    PyttkMergeTree_BACKEND_Type.tp_dict = enumdict;

    typedef ttkMergeTree::BACKEND cxx_enum_type;
    static const struct {
      const char *name; cxx_enum_type value;
    } constants[2] = {
      { "FTM", cxx_enum_type::FTM },
      { "EXTREEM", cxx_enum_type::EXTREEM },
    };

    for (int c = 0; c < 2; c++)
    {
      enumval = PyttkMergeTree_BACKEND_FromEnum(constants[c].value);
      if (enumval)
      {
        PyDict_SetItemString(enumdict, constants[c].name, enumval);
        Py_DECREF(enumval);
      }
    }
  }

  PyVTKEnum_Add(&PyttkMergeTree_BACKEND_Type, "ttkMergeTree.BACKEND");

  o = (PyObject *)&PyttkMergeTree_BACKEND_Type;
  if (PyDict_SetItemString(d, "BACKEND", o) != 0)
  {
    Py_DECREF(o);
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkMergeTree_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkMergeTree(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkMergeTree_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkMergeTree", o) != 0)
  {
    Py_DECREF(o);
  }

}

