/* JpegXLSupport.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from JpegXLSupport.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include "metadata.h"
#include <gdk-pixbuf/gdk-pixbuf.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PHOTO_FILE_FORMAT_PROPERTIES (photo_file_format_properties_get_type ())
#define PHOTO_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatProperties))
#define PHOTO_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatPropertiesClass))
#define IS_PHOTO_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES))
#define IS_PHOTO_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_FORMAT_PROPERTIES))
#define PHOTO_FILE_FORMAT_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatPropertiesClass))

typedef struct _PhotoFileFormatProperties PhotoFileFormatProperties;
typedef struct _PhotoFileFormatPropertiesClass PhotoFileFormatPropertiesClass;
typedef struct _PhotoFileFormatPropertiesPrivate PhotoFileFormatPropertiesPrivate;
typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_GIF,
	PHOTO_FILE_FORMAT_WEBP,
	PHOTO_FILE_FORMAT_AVIF,
	PHOTO_FILE_FORMAT_HEIF,
	PHOTO_FILE_FORMAT_JPEGXL,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())
typedef enum  {
	PHOTO_FILE_FORMAT_FLAGS_NONE = 0x00000000
} PhotoFileFormatFlags;

#define TYPE_PHOTO_FILE_FORMAT_FLAGS (photo_file_format_flags_get_type ())

#define TYPE_JPEG_XL_FILE_FORMAT_PROPERTIES (jpeg_xl_file_format_properties_get_type ())
#define JPEG_XL_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_JPEG_XL_FILE_FORMAT_PROPERTIES, JpegXLFileFormatProperties))
#define JPEG_XL_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_JPEG_XL_FILE_FORMAT_PROPERTIES, JpegXLFileFormatPropertiesClass))
#define IS_JPEG_XL_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_JPEG_XL_FILE_FORMAT_PROPERTIES))
#define IS_JPEG_XL_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_JPEG_XL_FILE_FORMAT_PROPERTIES))
#define JPEG_XL_FILE_FORMAT_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_JPEG_XL_FILE_FORMAT_PROPERTIES, JpegXLFileFormatPropertiesClass))

typedef struct _JpegXLFileFormatProperties JpegXLFileFormatProperties;
typedef struct _JpegXLFileFormatPropertiesClass JpegXLFileFormatPropertiesClass;
typedef struct _JpegXLFileFormatPropertiesPrivate JpegXLFileFormatPropertiesPrivate;
#define _photo_file_format_properties_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_properties_unref (var), NULL)))

#define TYPE_PHOTO_FILE_SNIFFER (photo_file_sniffer_get_type ())
#define PHOTO_FILE_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer))
#define PHOTO_FILE_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSnifferClass))
#define IS_PHOTO_FILE_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_SNIFFER))
#define IS_PHOTO_FILE_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_SNIFFER))
#define PHOTO_FILE_SNIFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSnifferClass))

typedef struct _PhotoFileSniffer PhotoFileSniffer;
typedef struct _PhotoFileSnifferClass PhotoFileSnifferClass;
typedef struct _PhotoFileSnifferPrivate PhotoFileSnifferPrivate;

#define TYPE_DETECTED_PHOTO_INFORMATION (detected_photo_information_get_type ())
#define DETECTED_PHOTO_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformation))
#define DETECTED_PHOTO_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformationClass))
#define IS_DETECTED_PHOTO_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DETECTED_PHOTO_INFORMATION))
#define IS_DETECTED_PHOTO_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DETECTED_PHOTO_INFORMATION))
#define DETECTED_PHOTO_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformationClass))

typedef struct _DetectedPhotoInformation DetectedPhotoInformation;
typedef struct _DetectedPhotoInformationClass DetectedPhotoInformationClass;
typedef enum  {
	PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL = 0x00000000,
	PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5 = 0x00000001
} PhotoFileSnifferOptions;

#define PHOTO_FILE_SNIFFER_TYPE_OPTIONS (photo_file_sniffer_options_get_type ())

#define TYPE_GDK_SNIFFER (gdk_sniffer_get_type ())
#define GDK_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GDK_SNIFFER, GdkSniffer))
#define GDK_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GDK_SNIFFER, GdkSnifferClass))
#define IS_GDK_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GDK_SNIFFER))
#define IS_GDK_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GDK_SNIFFER))
#define GDK_SNIFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GDK_SNIFFER, GdkSnifferClass))

typedef struct _GdkSniffer GdkSniffer;
typedef struct _GdkSnifferClass GdkSnifferClass;
typedef struct _GdkSnifferPrivate GdkSnifferPrivate;

#define TYPE_JPEG_XL_SNIFFER (jpeg_xl_sniffer_get_type ())
#define JPEG_XL_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_JPEG_XL_SNIFFER, JpegXLSniffer))
#define JPEG_XL_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_JPEG_XL_SNIFFER, JpegXLSnifferClass))
#define IS_JPEG_XL_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_JPEG_XL_SNIFFER))
#define IS_JPEG_XL_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_JPEG_XL_SNIFFER))
#define JPEG_XL_SNIFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_JPEG_XL_SNIFFER, JpegXLSnifferClass))

typedef struct _JpegXLSniffer JpegXLSniffer;
typedef struct _JpegXLSnifferClass JpegXLSnifferClass;
typedef struct _JpegXLSnifferPrivate JpegXLSnifferPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _detected_photo_information_unref0(var) ((var == NULL) ? NULL : (var = (detected_photo_information_unref (var), NULL)))
typedef struct _DetectedPhotoInformationPrivate DetectedPhotoInformationPrivate;

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_PHOTO_FILE_ADAPTER (photo_file_adapter_get_type ())
#define PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter))
#define PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))
#define IS_PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_ADAPTER))
#define IS_PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_ADAPTER))
#define PHOTO_FILE_ADAPTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))

typedef struct _PhotoFileAdapter PhotoFileAdapter;
typedef struct _PhotoFileAdapterClass PhotoFileAdapterClass;
typedef struct _PhotoFileAdapterPrivate PhotoFileAdapterPrivate;

#define TYPE_PHOTO_FILE_READER (photo_file_reader_get_type ())
#define PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReader))
#define PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))
#define IS_PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_READER))
#define IS_PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_READER))
#define PHOTO_FILE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))

typedef struct _PhotoFileReader PhotoFileReader;
typedef struct _PhotoFileReaderClass PhotoFileReaderClass;
typedef struct _PhotoFileReaderPrivate PhotoFileReaderPrivate;

#define TYPE_GDK_READER (gdk_reader_get_type ())
#define GDK_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GDK_READER, GdkReader))
#define GDK_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GDK_READER, GdkReaderClass))
#define IS_GDK_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GDK_READER))
#define IS_GDK_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GDK_READER))
#define GDK_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GDK_READER, GdkReaderClass))

typedef struct _GdkReader GdkReader;
typedef struct _GdkReaderClass GdkReaderClass;
typedef struct _GdkReaderPrivate GdkReaderPrivate;

#define TYPE_JPEG_XL_READER (jpeg_xl_reader_get_type ())
#define JPEG_XL_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_JPEG_XL_READER, JpegXLReader))
#define JPEG_XL_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_JPEG_XL_READER, JpegXLReaderClass))
#define IS_JPEG_XL_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_JPEG_XL_READER))
#define IS_JPEG_XL_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_JPEG_XL_READER))
#define JPEG_XL_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_JPEG_XL_READER, JpegXLReaderClass))

typedef struct _JpegXLReader JpegXLReader;
typedef struct _JpegXLReaderClass JpegXLReaderClass;
typedef struct _JpegXLReaderPrivate JpegXLReaderPrivate;

#define TYPE_PHOTO_FILE_METADATA_WRITER (photo_file_metadata_writer_get_type ())
#define PHOTO_FILE_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriter))
#define PHOTO_FILE_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriterClass))
#define IS_PHOTO_FILE_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_METADATA_WRITER))
#define IS_PHOTO_FILE_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_METADATA_WRITER))
#define PHOTO_FILE_METADATA_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriterClass))

typedef struct _PhotoFileMetadataWriter PhotoFileMetadataWriter;
typedef struct _PhotoFileMetadataWriterClass PhotoFileMetadataWriterClass;
typedef struct _PhotoFileMetadataWriterPrivate PhotoFileMetadataWriterPrivate;

#define TYPE_JPEG_XL_METADATA_WRITER (jpeg_xl_metadata_writer_get_type ())
#define JPEG_XL_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_JPEG_XL_METADATA_WRITER, JpegXLMetadataWriter))
#define JPEG_XL_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_JPEG_XL_METADATA_WRITER, JpegXLMetadataWriterClass))
#define IS_JPEG_XL_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_JPEG_XL_METADATA_WRITER))
#define IS_JPEG_XL_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_JPEG_XL_METADATA_WRITER))
#define JPEG_XL_METADATA_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_JPEG_XL_METADATA_WRITER, JpegXLMetadataWriterClass))

typedef struct _JpegXLMetadataWriter JpegXLMetadataWriter;
typedef struct _JpegXLMetadataWriterClass JpegXLMetadataWriterClass;
typedef struct _JpegXLMetadataWriterPrivate JpegXLMetadataWriterPrivate;

#define TYPE_PHOTO_FILE_FORMAT_DRIVER (photo_file_format_driver_get_type ())
#define PHOTO_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_FORMAT_DRIVER, PhotoFileFormatDriver))
#define PHOTO_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_FORMAT_DRIVER, PhotoFileFormatDriverClass))
#define IS_PHOTO_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_FORMAT_DRIVER))
#define IS_PHOTO_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_FORMAT_DRIVER))
#define PHOTO_FILE_FORMAT_DRIVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_FORMAT_DRIVER, PhotoFileFormatDriverClass))

typedef struct _PhotoFileFormatDriver PhotoFileFormatDriver;
typedef struct _PhotoFileFormatDriverClass PhotoFileFormatDriverClass;
typedef struct _PhotoFileFormatDriverPrivate PhotoFileFormatDriverPrivate;

#define TYPE_PHOTO_FILE_WRITER (photo_file_writer_get_type ())
#define PHOTO_FILE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_WRITER, PhotoFileWriter))
#define PHOTO_FILE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_WRITER, PhotoFileWriterClass))
#define IS_PHOTO_FILE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_WRITER))
#define IS_PHOTO_FILE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_WRITER))
#define PHOTO_FILE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_WRITER, PhotoFileWriterClass))

typedef struct _PhotoFileWriter PhotoFileWriter;
typedef struct _PhotoFileWriterClass PhotoFileWriterClass;

#define TYPE_JPEG_XL_FILE_FORMAT_DRIVER (jpeg_xl_file_format_driver_get_type ())
#define JPEG_XL_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_JPEG_XL_FILE_FORMAT_DRIVER, JpegXLFileFormatDriver))
#define JPEG_XL_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_JPEG_XL_FILE_FORMAT_DRIVER, JpegXLFileFormatDriverClass))
#define IS_JPEG_XL_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_JPEG_XL_FILE_FORMAT_DRIVER))
#define IS_JPEG_XL_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_JPEG_XL_FILE_FORMAT_DRIVER))
#define JPEG_XL_FILE_FORMAT_DRIVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_JPEG_XL_FILE_FORMAT_DRIVER, JpegXLFileFormatDriverClass))

typedef struct _JpegXLFileFormatDriver JpegXLFileFormatDriver;
typedef struct _JpegXLFileFormatDriverClass JpegXLFileFormatDriverClass;
typedef struct _JpegXLFileFormatDriverPrivate JpegXLFileFormatDriverPrivate;
#define _photo_file_format_driver_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_driver_unref (var), NULL)))

struct _PhotoFileFormatProperties {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileFormatPropertiesPrivate * priv;
};

struct _PhotoFileFormatPropertiesClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileFormatProperties *self);
	PhotoFileFormat (*get_file_format) (PhotoFileFormatProperties* self);
	PhotoFileFormatFlags (*get_flags) (PhotoFileFormatProperties* self);
	gboolean (*is_recognized_extension) (PhotoFileFormatProperties* self, const gchar* ext);
	gchar* (*get_default_extension) (PhotoFileFormatProperties* self);
	gchar** (*get_known_extensions) (PhotoFileFormatProperties* self, gint* result_length1);
	gchar* (*get_default_mime_type) (PhotoFileFormatProperties* self);
	gchar** (*get_mime_types) (PhotoFileFormatProperties* self, gint* result_length1);
	gchar* (*get_user_visible_name) (PhotoFileFormatProperties* self);
};

struct _JpegXLFileFormatProperties {
	PhotoFileFormatProperties parent_instance;
	JpegXLFileFormatPropertiesPrivate * priv;
};

struct _JpegXLFileFormatPropertiesClass {
	PhotoFileFormatPropertiesClass parent_class;
};

struct _PhotoFileSniffer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileSnifferPrivate * priv;
	GFile* file;
	PhotoFileSnifferOptions options;
	gboolean calc_md5;
};

struct _PhotoFileSnifferClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileSniffer *self);
	DetectedPhotoInformation* (*sniff) (PhotoFileSniffer* self, gboolean* is_corrupted, GError** error);
};

struct _GdkSniffer {
	PhotoFileSniffer parent_instance;
	GdkSnifferPrivate * priv;
};

struct _GdkSnifferClass {
	PhotoFileSnifferClass parent_class;
};

struct _JpegXLSniffer {
	GdkSniffer parent_instance;
	JpegXLSnifferPrivate * priv;
};

struct _JpegXLSnifferClass {
	GdkSnifferClass parent_class;
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _DetectedPhotoInformation {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DetectedPhotoInformationPrivate * priv;
	PhotoFileFormat file_format;
	PhotoMetadata* metadata;
	gchar* md5;
	gchar* exif_md5;
	gchar* thumbnail_md5;
	gchar* format_name;
	Dimensions image_dim;
	GdkColorspace colorspace;
	gint channels;
	gint bits_per_channel;
};

struct _DetectedPhotoInformationClass {
	GTypeClass parent_class;
	void (*finalize) (DetectedPhotoInformation *self);
};

struct _PhotoFileAdapter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileAdapterPrivate * priv;
};

struct _PhotoFileAdapterClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileAdapter *self);
};

struct _PhotoFileReader {
	PhotoFileAdapter parent_instance;
	PhotoFileReaderPrivate * priv;
};

struct _PhotoFileReaderClass {
	PhotoFileAdapterClass parent_class;
	PhotoMetadata* (*read_metadata) (PhotoFileReader* self, GError** error);
	GdkPixbuf* (*unscaled_read) (PhotoFileReader* self, GError** error);
	GdkPixbuf* (*scaled_read) (PhotoFileReader* self, Dimensions* full, Dimensions* scaled, GError** error);
};

struct _GdkReader {
	PhotoFileReader parent_instance;
	GdkReaderPrivate * priv;
};

struct _GdkReaderClass {
	PhotoFileReaderClass parent_class;
};

struct _JpegXLReader {
	GdkReader parent_instance;
	JpegXLReaderPrivate * priv;
};

struct _JpegXLReaderClass {
	GdkReaderClass parent_class;
};

struct _PhotoFileMetadataWriter {
	PhotoFileAdapter parent_instance;
	PhotoFileMetadataWriterPrivate * priv;
};

struct _PhotoFileMetadataWriterClass {
	PhotoFileAdapterClass parent_class;
	void (*write_metadata) (PhotoFileMetadataWriter* self, PhotoMetadata* metadata, GError** error);
};

struct _JpegXLMetadataWriter {
	PhotoFileMetadataWriter parent_instance;
	JpegXLMetadataWriterPrivate * priv;
};

struct _JpegXLMetadataWriterClass {
	PhotoFileMetadataWriterClass parent_class;
};

struct _PhotoFileFormatDriver {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileFormatDriverPrivate * priv;
};

struct _PhotoFileFormatDriverClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileFormatDriver *self);
	PhotoFileFormatProperties* (*get_properties) (PhotoFileFormatDriver* self);
	PhotoFileReader* (*create_reader) (PhotoFileFormatDriver* self, const gchar* filepath);
	PhotoMetadata* (*create_metadata) (PhotoFileFormatDriver* self);
	gboolean (*can_write_image) (PhotoFileFormatDriver* self);
	gboolean (*can_write_metadata) (PhotoFileFormatDriver* self);
	PhotoFileWriter* (*create_writer) (PhotoFileFormatDriver* self, const gchar* filepath);
	PhotoFileMetadataWriter* (*create_metadata_writer) (PhotoFileFormatDriver* self, const gchar* filepath);
	PhotoFileSniffer* (*create_sniffer) (PhotoFileFormatDriver* self, GFile* file, PhotoFileSnifferOptions options);
};

struct _JpegXLFileFormatDriver {
	PhotoFileFormatDriver parent_instance;
	JpegXLFileFormatDriverPrivate * priv;
};

struct _JpegXLFileFormatDriverClass {
	PhotoFileFormatDriverClass parent_class;
};

static gpointer jpeg_xl_file_format_properties_parent_class = NULL;
static gchar** jpeg_xl_file_format_properties_KNOWN_EXTENSIONS;
static gint jpeg_xl_file_format_properties_KNOWN_EXTENSIONS_length1;
static gchar** jpeg_xl_file_format_properties_KNOWN_EXTENSIONS = NULL;
static gint jpeg_xl_file_format_properties_KNOWN_EXTENSIONS_length1 = 0;
static gint _jpeg_xl_file_format_properties_KNOWN_EXTENSIONS_size_ = 0;
static gchar** jpeg_xl_file_format_properties_KNOWN_MIME_TYPES;
static gint jpeg_xl_file_format_properties_KNOWN_MIME_TYPES_length1;
static gchar** jpeg_xl_file_format_properties_KNOWN_MIME_TYPES = NULL;
static gint jpeg_xl_file_format_properties_KNOWN_MIME_TYPES_length1 = 0;
static gint _jpeg_xl_file_format_properties_KNOWN_MIME_TYPES_size_ = 0;
static JpegXLFileFormatProperties* jpeg_xl_file_format_properties_instance;
static JpegXLFileFormatProperties* jpeg_xl_file_format_properties_instance = NULL;
static gpointer jpeg_xl_sniffer_parent_class = NULL;
static gpointer jpeg_xl_reader_parent_class = NULL;
static gpointer jpeg_xl_metadata_writer_parent_class = NULL;
static gpointer jpeg_xl_file_format_driver_parent_class = NULL;
static JpegXLFileFormatDriver* jpeg_xl_file_format_driver_instance;
static JpegXLFileFormatDriver* jpeg_xl_file_format_driver_instance = NULL;

VALA_EXTERN gpointer photo_file_format_properties_ref (gpointer instance);
VALA_EXTERN void photo_file_format_properties_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_photo_file_format_properties (const gchar* name,
                                                     const gchar* nick,
                                                     const gchar* blurb,
                                                     GType object_type,
                                                     GParamFlags flags);
VALA_EXTERN void value_set_photo_file_format_properties (GValue* value,
                                             gpointer v_object);
VALA_EXTERN void value_take_photo_file_format_properties (GValue* value,
                                              gpointer v_object);
VALA_EXTERN gpointer value_get_photo_file_format_properties (const GValue* value);
VALA_EXTERN GType photo_file_format_properties_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileFormatProperties, photo_file_format_properties_unref)
VALA_EXTERN GType photo_file_format_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType photo_file_format_flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType jpeg_xl_file_format_properties_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (JpegXLFileFormatProperties, photo_file_format_properties_unref)
VALA_EXTERN PhotoFileFormat photo_file_format_properties_get_file_format (PhotoFileFormatProperties* self);
VALA_EXTERN PhotoFileFormatFlags photo_file_format_properties_get_flags (PhotoFileFormatProperties* self);
VALA_EXTERN gchar* photo_file_format_properties_get_user_visible_name (PhotoFileFormatProperties* self);
VALA_EXTERN gchar* photo_file_format_properties_get_default_extension (PhotoFileFormatProperties* self);
VALA_EXTERN gchar** photo_file_format_properties_get_known_extensions (PhotoFileFormatProperties* self,
                                                           gint* result_length1);
VALA_EXTERN gchar* photo_file_format_properties_get_default_mime_type (PhotoFileFormatProperties* self);
VALA_EXTERN gchar** photo_file_format_properties_get_mime_types (PhotoFileFormatProperties* self,
                                                     gint* result_length1);
VALA_EXTERN void jpeg_xl_file_format_properties_init (void);
VALA_EXTERN JpegXLFileFormatProperties* jpeg_xl_file_format_properties_new (void);
VALA_EXTERN JpegXLFileFormatProperties* jpeg_xl_file_format_properties_construct (GType object_type);
VALA_EXTERN JpegXLFileFormatProperties* jpeg_xl_file_format_properties_get_instance (void);
static PhotoFileFormat jpeg_xl_file_format_properties_real_get_file_format (PhotoFileFormatProperties* base);
static PhotoFileFormatFlags jpeg_xl_file_format_properties_real_get_flags (PhotoFileFormatProperties* base);
static gchar* jpeg_xl_file_format_properties_real_get_user_visible_name (PhotoFileFormatProperties* base);
static gchar* jpeg_xl_file_format_properties_real_get_default_extension (PhotoFileFormatProperties* base);
static gchar** jpeg_xl_file_format_properties_real_get_known_extensions (PhotoFileFormatProperties* base,
                                                                  gint* result_length1);
static gchar** _vala_array_dup25 (gchar** self,
                           gssize length);
static gchar* jpeg_xl_file_format_properties_real_get_default_mime_type (PhotoFileFormatProperties* base);
static gchar** jpeg_xl_file_format_properties_real_get_mime_types (PhotoFileFormatProperties* base,
                                                            gint* result_length1);
static gchar** _vala_array_dup26 (gchar** self,
                           gssize length);
VALA_EXTERN PhotoFileFormatProperties* photo_file_format_properties_construct (GType object_type);
static void jpeg_xl_file_format_properties_finalize (PhotoFileFormatProperties * obj);
static GType jpeg_xl_file_format_properties_get_type_once (void);
VALA_EXTERN gpointer photo_file_sniffer_ref (gpointer instance);
VALA_EXTERN void photo_file_sniffer_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_photo_file_sniffer (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void value_set_photo_file_sniffer (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void value_take_photo_file_sniffer (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer value_get_photo_file_sniffer (const GValue* value);
VALA_EXTERN GType photo_file_sniffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileSniffer, photo_file_sniffer_unref)
VALA_EXTERN gpointer detected_photo_information_ref (gpointer instance);
VALA_EXTERN void detected_photo_information_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_detected_photo_information (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags);
VALA_EXTERN void value_set_detected_photo_information (GValue* value,
                                           gpointer v_object);
VALA_EXTERN void value_take_detected_photo_information (GValue* value,
                                            gpointer v_object);
VALA_EXTERN gpointer value_get_detected_photo_information (const GValue* value);
VALA_EXTERN GType detected_photo_information_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DetectedPhotoInformation, detected_photo_information_unref)
VALA_EXTERN GType photo_file_sniffer_options_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gdk_sniffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GdkSniffer, photo_file_sniffer_unref)
VALA_EXTERN GType jpeg_xl_sniffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (JpegXLSniffer, photo_file_sniffer_unref)
VALA_EXTERN DetectedPhotoInformation* photo_file_sniffer_sniff (PhotoFileSniffer* self,
                                                    gboolean* is_corrupted,
                                                    GError** error);
VALA_EXTERN JpegXLSniffer* jpeg_xl_sniffer_new (GFile* file,
                                    PhotoFileSnifferOptions options);
VALA_EXTERN JpegXLSniffer* jpeg_xl_sniffer_construct (GType object_type,
                                          GFile* file,
                                          PhotoFileSnifferOptions options);
VALA_EXTERN GdkSniffer* gdk_sniffer_construct (GType object_type,
                                   GFile* file,
                                   PhotoFileSnifferOptions options);
static gboolean jpeg_xl_sniffer_is_jpegxl_file (GFile* file,
                                         GError** error);
static DetectedPhotoInformation* jpeg_xl_sniffer_real_sniff (PhotoFileSniffer* base,
                                                      gboolean* is_corrupted,
                                                      GError** error);
VALA_EXTERN GType photo_metadata_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoMetadata, media_metadata_unref)
VALA_EXTERN GType dimensions_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Dimensions* dimensions_dup (const Dimensions* self);
VALA_EXTERN void dimensions_free (Dimensions* self);
static GType jpeg_xl_sniffer_get_type_once (void);
VALA_EXTERN gpointer photo_file_adapter_ref (gpointer instance);
VALA_EXTERN void photo_file_adapter_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_photo_file_adapter (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void value_set_photo_file_adapter (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void value_take_photo_file_adapter (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer value_get_photo_file_adapter (const GValue* value);
VALA_EXTERN GType photo_file_adapter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileAdapter, photo_file_adapter_unref)
VALA_EXTERN GType photo_file_reader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileReader, photo_file_adapter_unref)
VALA_EXTERN GType gdk_reader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GdkReader, photo_file_adapter_unref)
VALA_EXTERN GType jpeg_xl_reader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (JpegXLReader, photo_file_adapter_unref)
VALA_EXTERN JpegXLReader* jpeg_xl_reader_new (const gchar* filepath);
VALA_EXTERN JpegXLReader* jpeg_xl_reader_construct (GType object_type,
                                        const gchar* filepath);
VALA_EXTERN GdkReader* gdk_reader_construct (GType object_type,
                                 const gchar* filepath,
                                 PhotoFileFormat file_format);
static GType jpeg_xl_reader_get_type_once (void);
VALA_EXTERN GType photo_file_metadata_writer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileMetadataWriter, photo_file_adapter_unref)
VALA_EXTERN GType jpeg_xl_metadata_writer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (JpegXLMetadataWriter, photo_file_adapter_unref)
VALA_EXTERN void photo_file_metadata_writer_write_metadata (PhotoFileMetadataWriter* self,
                                                PhotoMetadata* metadata,
                                                GError** error);
VALA_EXTERN JpegXLMetadataWriter* jpeg_xl_metadata_writer_new (const gchar* filepath);
VALA_EXTERN JpegXLMetadataWriter* jpeg_xl_metadata_writer_construct (GType object_type,
                                                         const gchar* filepath);
VALA_EXTERN PhotoFileMetadataWriter* photo_file_metadata_writer_construct (GType object_type,
                                                               const gchar* filepath,
                                                               PhotoFileFormat file_format);
static void jpeg_xl_metadata_writer_real_write_metadata (PhotoFileMetadataWriter* base,
                                                  PhotoMetadata* metadata,
                                                  GError** error);
VALA_EXTERN void photo_metadata_write_to_file (PhotoMetadata* self,
                                   GFile* file,
                                   GError** error);
VALA_EXTERN GFile* photo_file_adapter_get_file (PhotoFileAdapter* self);
static GType jpeg_xl_metadata_writer_get_type_once (void);
VALA_EXTERN gpointer photo_file_format_driver_ref (gpointer instance);
VALA_EXTERN void photo_file_format_driver_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_photo_file_format_driver (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags);
VALA_EXTERN void value_set_photo_file_format_driver (GValue* value,
                                         gpointer v_object);
VALA_EXTERN void value_take_photo_file_format_driver (GValue* value,
                                          gpointer v_object);
VALA_EXTERN gpointer value_get_photo_file_format_driver (const GValue* value);
VALA_EXTERN GType photo_file_format_driver_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileFormatDriver, photo_file_format_driver_unref)
VALA_EXTERN GType photo_file_writer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileWriter, photo_file_adapter_unref)
VALA_EXTERN GType jpeg_xl_file_format_driver_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (JpegXLFileFormatDriver, photo_file_format_driver_unref)
VALA_EXTERN PhotoFileFormatProperties* photo_file_format_driver_get_properties (PhotoFileFormatDriver* self);
VALA_EXTERN PhotoFileReader* photo_file_format_driver_create_reader (PhotoFileFormatDriver* self,
                                                         const gchar* filepath);
VALA_EXTERN gboolean photo_file_format_driver_can_write_image (PhotoFileFormatDriver* self);
VALA_EXTERN gboolean photo_file_format_driver_can_write_metadata (PhotoFileFormatDriver* self);
VALA_EXTERN PhotoFileWriter* photo_file_format_driver_create_writer (PhotoFileFormatDriver* self,
                                                         const gchar* filepath);
VALA_EXTERN PhotoFileMetadataWriter* photo_file_format_driver_create_metadata_writer (PhotoFileFormatDriver* self,
                                                                          const gchar* filepath);
VALA_EXTERN PhotoFileSniffer* photo_file_format_driver_create_sniffer (PhotoFileFormatDriver* self,
                                                           GFile* file,
                                                           PhotoFileSnifferOptions options);
VALA_EXTERN PhotoMetadata* photo_file_format_driver_create_metadata (PhotoFileFormatDriver* self);
VALA_EXTERN void jpeg_xl_file_format_driver_init (void);
VALA_EXTERN JpegXLFileFormatDriver* jpeg_xl_file_format_driver_new (void);
VALA_EXTERN JpegXLFileFormatDriver* jpeg_xl_file_format_driver_construct (GType object_type);
VALA_EXTERN JpegXLFileFormatDriver* jpeg_xl_file_format_driver_get_instance (void);
static PhotoFileFormatProperties* jpeg_xl_file_format_driver_real_get_properties (PhotoFileFormatDriver* base);
static PhotoFileReader* jpeg_xl_file_format_driver_real_create_reader (PhotoFileFormatDriver* base,
                                                                const gchar* filepath);
static gboolean jpeg_xl_file_format_driver_real_can_write_image (PhotoFileFormatDriver* base);
static gboolean jpeg_xl_file_format_driver_real_can_write_metadata (PhotoFileFormatDriver* base);
static PhotoFileWriter* jpeg_xl_file_format_driver_real_create_writer (PhotoFileFormatDriver* base,
                                                                const gchar* filepath);
static PhotoFileMetadataWriter* jpeg_xl_file_format_driver_real_create_metadata_writer (PhotoFileFormatDriver* base,
                                                                                 const gchar* filepath);
static PhotoFileSniffer* jpeg_xl_file_format_driver_real_create_sniffer (PhotoFileFormatDriver* base,
                                                                  GFile* file,
                                                                  PhotoFileSnifferOptions options);
static PhotoMetadata* jpeg_xl_file_format_driver_real_create_metadata (PhotoFileFormatDriver* base);
VALA_EXTERN PhotoMetadata* photo_metadata_new (void);
VALA_EXTERN PhotoMetadata* photo_metadata_construct (GType object_type);
VALA_EXTERN PhotoFileFormatDriver* photo_file_format_driver_construct (GType object_type);
static void jpeg_xl_file_format_driver_finalize (PhotoFileFormatDriver * obj);
static GType jpeg_xl_file_format_driver_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const guint8 JPEG_XL_SNIFFER_CODESTREAM_MAGIC_SEQUENCE[2] = {(guint8) 0xff, (guint8) 0x0a};
static const guint8 JPEG_XL_SNIFFER_BMFF_MAGIC_SEQUENCE[12] = {(guint8) 0x00, (guint8) 0x00, (guint8) 0x00, (guint8) 0x0C, (guint8) 0x4A, (guint8) 0x58, (guint8) 0x4C, (guint8) 0x20, (guint8) 0x0D, (guint8) 0x0A, (guint8) 0x87, (guint8) 0x0A};

void
jpeg_xl_file_format_properties_init (void)
{
	JpegXLFileFormatProperties* _tmp0_;
	_tmp0_ = jpeg_xl_file_format_properties_new ();
	_photo_file_format_properties_unref0 (jpeg_xl_file_format_properties_instance);
	jpeg_xl_file_format_properties_instance = _tmp0_;
}

static gpointer
_photo_file_format_properties_ref0 (gpointer self)
{
	return self ? photo_file_format_properties_ref (self) : NULL;
}

JpegXLFileFormatProperties*
jpeg_xl_file_format_properties_get_instance (void)
{
	JpegXLFileFormatProperties* _tmp0_;
	JpegXLFileFormatProperties* _tmp1_;
	JpegXLFileFormatProperties* result;
	_tmp0_ = jpeg_xl_file_format_properties_instance;
	_tmp1_ = _photo_file_format_properties_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static PhotoFileFormat
jpeg_xl_file_format_properties_real_get_file_format (PhotoFileFormatProperties* base)
{
	JpegXLFileFormatProperties * self;
	PhotoFileFormat result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_JPEG_XL_FILE_FORMAT_PROPERTIES, JpegXLFileFormatProperties);
	result = PHOTO_FILE_FORMAT_JPEGXL;
	return result;
}

static PhotoFileFormatFlags
jpeg_xl_file_format_properties_real_get_flags (PhotoFileFormatProperties* base)
{
	JpegXLFileFormatProperties * self;
	PhotoFileFormatFlags result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_JPEG_XL_FILE_FORMAT_PROPERTIES, JpegXLFileFormatProperties);
	result = PHOTO_FILE_FORMAT_FLAGS_NONE;
	return result;
}

static gchar*
jpeg_xl_file_format_properties_real_get_user_visible_name (PhotoFileFormatProperties* base)
{
	JpegXLFileFormatProperties * self;
	gchar* _tmp0_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_JPEG_XL_FILE_FORMAT_PROPERTIES, JpegXLFileFormatProperties);
	_tmp0_ = g_strdup (_ ("JPEGXL"));
	result = _tmp0_;
	return result;
}

static gchar*
jpeg_xl_file_format_properties_real_get_default_extension (PhotoFileFormatProperties* base)
{
	JpegXLFileFormatProperties * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_JPEG_XL_FILE_FORMAT_PROPERTIES, JpegXLFileFormatProperties);
	_tmp0_ = jpeg_xl_file_format_properties_KNOWN_EXTENSIONS;
	_tmp0__length1 = jpeg_xl_file_format_properties_KNOWN_EXTENSIONS_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

static gchar**
_vala_array_dup25 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
jpeg_xl_file_format_properties_real_get_known_extensions (PhotoFileFormatProperties* base,
                                                          gint* result_length1)
{
	JpegXLFileFormatProperties * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_JPEG_XL_FILE_FORMAT_PROPERTIES, JpegXLFileFormatProperties);
	_tmp0_ = jpeg_xl_file_format_properties_KNOWN_EXTENSIONS;
	_tmp0__length1 = jpeg_xl_file_format_properties_KNOWN_EXTENSIONS_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup25 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static gchar*
jpeg_xl_file_format_properties_real_get_default_mime_type (PhotoFileFormatProperties* base)
{
	JpegXLFileFormatProperties * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_JPEG_XL_FILE_FORMAT_PROPERTIES, JpegXLFileFormatProperties);
	_tmp0_ = jpeg_xl_file_format_properties_KNOWN_MIME_TYPES;
	_tmp0__length1 = jpeg_xl_file_format_properties_KNOWN_MIME_TYPES_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

static gchar**
_vala_array_dup26 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
jpeg_xl_file_format_properties_real_get_mime_types (PhotoFileFormatProperties* base,
                                                    gint* result_length1)
{
	JpegXLFileFormatProperties * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_JPEG_XL_FILE_FORMAT_PROPERTIES, JpegXLFileFormatProperties);
	_tmp0_ = jpeg_xl_file_format_properties_KNOWN_MIME_TYPES;
	_tmp0__length1 = jpeg_xl_file_format_properties_KNOWN_MIME_TYPES_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup26 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

JpegXLFileFormatProperties*
jpeg_xl_file_format_properties_construct (GType object_type)
{
	JpegXLFileFormatProperties* self = NULL;
	self = (JpegXLFileFormatProperties*) photo_file_format_properties_construct (object_type);
	return self;
}

JpegXLFileFormatProperties*
jpeg_xl_file_format_properties_new (void)
{
	return jpeg_xl_file_format_properties_construct (TYPE_JPEG_XL_FILE_FORMAT_PROPERTIES);
}

static void
jpeg_xl_file_format_properties_class_init (JpegXLFileFormatPropertiesClass * klass,
                                           gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	jpeg_xl_file_format_properties_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileFormatPropertiesClass *) klass)->finalize = jpeg_xl_file_format_properties_finalize;
	((PhotoFileFormatPropertiesClass *) klass)->get_file_format = (PhotoFileFormat (*) (PhotoFileFormatProperties*)) jpeg_xl_file_format_properties_real_get_file_format;
	((PhotoFileFormatPropertiesClass *) klass)->get_flags = (PhotoFileFormatFlags (*) (PhotoFileFormatProperties*)) jpeg_xl_file_format_properties_real_get_flags;
	((PhotoFileFormatPropertiesClass *) klass)->get_user_visible_name = (gchar* (*) (PhotoFileFormatProperties*)) jpeg_xl_file_format_properties_real_get_user_visible_name;
	((PhotoFileFormatPropertiesClass *) klass)->get_default_extension = (gchar* (*) (PhotoFileFormatProperties*)) jpeg_xl_file_format_properties_real_get_default_extension;
	((PhotoFileFormatPropertiesClass *) klass)->get_known_extensions = (gchar** (*) (PhotoFileFormatProperties*, gint*)) jpeg_xl_file_format_properties_real_get_known_extensions;
	((PhotoFileFormatPropertiesClass *) klass)->get_default_mime_type = (gchar* (*) (PhotoFileFormatProperties*)) jpeg_xl_file_format_properties_real_get_default_mime_type;
	((PhotoFileFormatPropertiesClass *) klass)->get_mime_types = (gchar** (*) (PhotoFileFormatProperties*, gint*)) jpeg_xl_file_format_properties_real_get_mime_types;
	_tmp0_ = g_strdup ("jxl");
	_tmp1_ = g_strdup ("jpegxl");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	jpeg_xl_file_format_properties_KNOWN_EXTENSIONS = _tmp2_;
	jpeg_xl_file_format_properties_KNOWN_EXTENSIONS_length1 = 2;
	_jpeg_xl_file_format_properties_KNOWN_EXTENSIONS_size_ = jpeg_xl_file_format_properties_KNOWN_EXTENSIONS_length1;
	_tmp3_ = g_strdup ("image/jxl");
	_tmp4_ = g_new0 (gchar*, 1 + 1);
	_tmp4_[0] = _tmp3_;
	jpeg_xl_file_format_properties_KNOWN_MIME_TYPES = _tmp4_;
	jpeg_xl_file_format_properties_KNOWN_MIME_TYPES_length1 = 1;
	_jpeg_xl_file_format_properties_KNOWN_MIME_TYPES_size_ = jpeg_xl_file_format_properties_KNOWN_MIME_TYPES_length1;
}

static void
jpeg_xl_file_format_properties_instance_init (JpegXLFileFormatProperties * self,
                                              gpointer klass)
{
}

static void
jpeg_xl_file_format_properties_finalize (PhotoFileFormatProperties * obj)
{
	JpegXLFileFormatProperties * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_JPEG_XL_FILE_FORMAT_PROPERTIES, JpegXLFileFormatProperties);
	PHOTO_FILE_FORMAT_PROPERTIES_CLASS (jpeg_xl_file_format_properties_parent_class)->finalize (obj);
}

static GType
jpeg_xl_file_format_properties_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (JpegXLFileFormatPropertiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) jpeg_xl_file_format_properties_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (JpegXLFileFormatProperties), 0, (GInstanceInitFunc) jpeg_xl_file_format_properties_instance_init, NULL };
	GType jpeg_xl_file_format_properties_type_id;
	jpeg_xl_file_format_properties_type_id = g_type_register_static (TYPE_PHOTO_FILE_FORMAT_PROPERTIES, "JpegXLFileFormatProperties", &g_define_type_info, 0);
	return jpeg_xl_file_format_properties_type_id;
}

GType
jpeg_xl_file_format_properties_get_type (void)
{
	static volatile gsize jpeg_xl_file_format_properties_type_id__once = 0;
	if (g_once_init_enter (&jpeg_xl_file_format_properties_type_id__once)) {
		GType jpeg_xl_file_format_properties_type_id;
		jpeg_xl_file_format_properties_type_id = jpeg_xl_file_format_properties_get_type_once ();
		g_once_init_leave (&jpeg_xl_file_format_properties_type_id__once, jpeg_xl_file_format_properties_type_id);
	}
	return jpeg_xl_file_format_properties_type_id__once;
}

JpegXLSniffer*
jpeg_xl_sniffer_construct (GType object_type,
                           GFile* file,
                           PhotoFileSnifferOptions options)
{
	JpegXLSniffer* self = NULL;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	self = (JpegXLSniffer*) gdk_sniffer_construct (object_type, file, options);
	return self;
}

JpegXLSniffer*
jpeg_xl_sniffer_new (GFile* file,
                     PhotoFileSnifferOptions options)
{
	return jpeg_xl_sniffer_construct (TYPE_JPEG_XL_SNIFFER, file, options);
}

static gboolean
jpeg_xl_sniffer_is_jpegxl_file (GFile* file,
                                GError** error)
{
	GFileInputStream* instream = NULL;
	GFileInputStream* _tmp0_;
	guint8* file_lead_sequence = NULL;
	guint8* _tmp2_;
	gint file_lead_sequence_length1;
	gint _file_lead_sequence_size_;
	gssize size = 0L;
	GFileInputStream* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	gboolean _tmp6_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	_tmp0_ = g_file_read (file, NULL, &_inner_error0_);
	instream = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	_tmp2_ = g_new0 (guint8, G_N_ELEMENTS (JPEG_XL_SNIFFER_BMFF_MAGIC_SEQUENCE));
	file_lead_sequence = _tmp2_;
	file_lead_sequence_length1 = G_N_ELEMENTS (JPEG_XL_SNIFFER_BMFF_MAGIC_SEQUENCE);
	_file_lead_sequence_size_ = file_lead_sequence_length1;
	_tmp3_ = instream;
	_tmp4_ = file_lead_sequence;
	_tmp4__length1 = file_lead_sequence_length1;
	size = g_input_stream_read (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_input_stream_get_type (), GInputStream), _tmp4_, (gsize) _tmp4__length1, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		file_lead_sequence = (g_free (file_lead_sequence), NULL);
		_g_object_unref0 (instream);
		return _tmp5_;
	}
	if (size == ((gssize) G_N_ELEMENTS (JPEG_XL_SNIFFER_BMFF_MAGIC_SEQUENCE))) {
		gboolean _tmp7_ = FALSE;
		guint8* _tmp8_;
		gint _tmp8__length1;
		_tmp8_ = file_lead_sequence;
		_tmp8__length1 = file_lead_sequence_length1;
		if (memcmp (JPEG_XL_SNIFFER_CODESTREAM_MAGIC_SEQUENCE, _tmp8_, (gsize) G_N_ELEMENTS (JPEG_XL_SNIFFER_CODESTREAM_MAGIC_SEQUENCE)) == 0) {
			_tmp7_ = TRUE;
		} else {
			guint8* _tmp9_;
			gint _tmp9__length1;
			_tmp9_ = file_lead_sequence;
			_tmp9__length1 = file_lead_sequence_length1;
			_tmp7_ = memcmp (JPEG_XL_SNIFFER_BMFF_MAGIC_SEQUENCE, _tmp9_, (gsize) G_N_ELEMENTS (JPEG_XL_SNIFFER_BMFF_MAGIC_SEQUENCE)) == 0;
		}
		_tmp6_ = _tmp7_;
	} else {
		_tmp6_ = FALSE;
	}
	result = _tmp6_;
	file_lead_sequence = (g_free (file_lead_sequence), NULL);
	_g_object_unref0 (instream);
	return result;
}

static gpointer
_detected_photo_information_ref0 (gpointer self)
{
	return self ? detected_photo_information_ref (self) : NULL;
}

static DetectedPhotoInformation*
jpeg_xl_sniffer_real_sniff (PhotoFileSniffer* base,
                            gboolean* is_corrupted,
                            GError** error)
{
	JpegXLSniffer * self;
	gboolean _vala_is_corrupted = FALSE;
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
	DetectedPhotoInformation* detected = NULL;
	gboolean _tmp2_ = FALSE;
	DetectedPhotoInformation* _tmp3_;
	DetectedPhotoInformation* _tmp4_;
	DetectedPhotoInformation* _tmp5_ = NULL;
	DetectedPhotoInformation* _tmp6_;
	DetectedPhotoInformation* _tmp8_;
	GError* _inner_error0_ = NULL;
	DetectedPhotoInformation* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_JPEG_XL_SNIFFER, JpegXLSniffer);
	_vala_is_corrupted = FALSE;
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->file;
	_tmp0_ = jpeg_xl_sniffer_is_jpegxl_file (_tmp1_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	if (!_tmp0_) {
		result = NULL;
		if (is_corrupted) {
			*is_corrupted = _vala_is_corrupted;
		}
		return result;
	}
	_tmp3_ = PHOTO_FILE_SNIFFER_CLASS (jpeg_xl_sniffer_parent_class)->sniff (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_GDK_SNIFFER, GdkSniffer), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer), &_tmp2_, &_inner_error0_);
	_vala_is_corrupted = _tmp2_;
	detected = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp4_ = detected;
	if (_tmp4_ == NULL) {
		result = NULL;
		_detected_photo_information_unref0 (detected);
		if (is_corrupted) {
			*is_corrupted = _vala_is_corrupted;
		}
		return result;
	}
	_tmp6_ = detected;
	if (_tmp6_->file_format == PHOTO_FILE_FORMAT_JPEGXL) {
		DetectedPhotoInformation* _tmp7_;
		_tmp7_ = detected;
		_tmp5_ = _tmp7_;
	} else {
		_tmp5_ = NULL;
	}
	_tmp8_ = _detected_photo_information_ref0 (_tmp5_);
	result = _tmp8_;
	_detected_photo_information_unref0 (detected);
	if (is_corrupted) {
		*is_corrupted = _vala_is_corrupted;
	}
	return result;
}

static void
jpeg_xl_sniffer_class_init (JpegXLSnifferClass * klass,
                            gpointer klass_data)
{
	jpeg_xl_sniffer_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileSnifferClass *) klass)->sniff = (DetectedPhotoInformation* (*) (PhotoFileSniffer*, gboolean*, GError**)) jpeg_xl_sniffer_real_sniff;
}

static void
jpeg_xl_sniffer_instance_init (JpegXLSniffer * self,
                               gpointer klass)
{
}

static GType
jpeg_xl_sniffer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (JpegXLSnifferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) jpeg_xl_sniffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (JpegXLSniffer), 0, (GInstanceInitFunc) jpeg_xl_sniffer_instance_init, NULL };
	GType jpeg_xl_sniffer_type_id;
	jpeg_xl_sniffer_type_id = g_type_register_static (TYPE_GDK_SNIFFER, "JpegXLSniffer", &g_define_type_info, 0);
	return jpeg_xl_sniffer_type_id;
}

GType
jpeg_xl_sniffer_get_type (void)
{
	static volatile gsize jpeg_xl_sniffer_type_id__once = 0;
	if (g_once_init_enter (&jpeg_xl_sniffer_type_id__once)) {
		GType jpeg_xl_sniffer_type_id;
		jpeg_xl_sniffer_type_id = jpeg_xl_sniffer_get_type_once ();
		g_once_init_leave (&jpeg_xl_sniffer_type_id__once, jpeg_xl_sniffer_type_id);
	}
	return jpeg_xl_sniffer_type_id__once;
}

JpegXLReader*
jpeg_xl_reader_construct (GType object_type,
                          const gchar* filepath)
{
	JpegXLReader* self = NULL;
	g_return_val_if_fail (filepath != NULL, NULL);
	self = (JpegXLReader*) gdk_reader_construct (object_type, filepath, PHOTO_FILE_FORMAT_JPEGXL);
	return self;
}

JpegXLReader*
jpeg_xl_reader_new (const gchar* filepath)
{
	return jpeg_xl_reader_construct (TYPE_JPEG_XL_READER, filepath);
}

static void
jpeg_xl_reader_class_init (JpegXLReaderClass * klass,
                           gpointer klass_data)
{
	jpeg_xl_reader_parent_class = g_type_class_peek_parent (klass);
}

static void
jpeg_xl_reader_instance_init (JpegXLReader * self,
                              gpointer klass)
{
}

static GType
jpeg_xl_reader_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (JpegXLReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) jpeg_xl_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (JpegXLReader), 0, (GInstanceInitFunc) jpeg_xl_reader_instance_init, NULL };
	GType jpeg_xl_reader_type_id;
	jpeg_xl_reader_type_id = g_type_register_static (TYPE_GDK_READER, "JpegXLReader", &g_define_type_info, 0);
	return jpeg_xl_reader_type_id;
}

GType
jpeg_xl_reader_get_type (void)
{
	static volatile gsize jpeg_xl_reader_type_id__once = 0;
	if (g_once_init_enter (&jpeg_xl_reader_type_id__once)) {
		GType jpeg_xl_reader_type_id;
		jpeg_xl_reader_type_id = jpeg_xl_reader_get_type_once ();
		g_once_init_leave (&jpeg_xl_reader_type_id__once, jpeg_xl_reader_type_id);
	}
	return jpeg_xl_reader_type_id__once;
}

JpegXLMetadataWriter*
jpeg_xl_metadata_writer_construct (GType object_type,
                                   const gchar* filepath)
{
	JpegXLMetadataWriter* self = NULL;
	g_return_val_if_fail (filepath != NULL, NULL);
	self = (JpegXLMetadataWriter*) photo_file_metadata_writer_construct (object_type, filepath, PHOTO_FILE_FORMAT_JPEGXL);
	return self;
}

JpegXLMetadataWriter*
jpeg_xl_metadata_writer_new (const gchar* filepath)
{
	return jpeg_xl_metadata_writer_construct (TYPE_JPEG_XL_METADATA_WRITER, filepath);
}

static void
jpeg_xl_metadata_writer_real_write_metadata (PhotoFileMetadataWriter* base,
                                             PhotoMetadata* metadata,
                                             GError** error)
{
	JpegXLMetadataWriter * self;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_JPEG_XL_METADATA_WRITER, JpegXLMetadataWriter);
	g_return_if_fail (IS_PHOTO_METADATA (metadata));
	_tmp0_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
	_tmp1_ = _tmp0_;
	photo_metadata_write_to_file (metadata, _tmp1_, &_inner_error0_);
	_g_object_unref0 (_tmp1_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
jpeg_xl_metadata_writer_class_init (JpegXLMetadataWriterClass * klass,
                                    gpointer klass_data)
{
	jpeg_xl_metadata_writer_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileMetadataWriterClass *) klass)->write_metadata = (void (*) (PhotoFileMetadataWriter*, PhotoMetadata*, GError**)) jpeg_xl_metadata_writer_real_write_metadata;
}

static void
jpeg_xl_metadata_writer_instance_init (JpegXLMetadataWriter * self,
                                       gpointer klass)
{
}

static GType
jpeg_xl_metadata_writer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (JpegXLMetadataWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) jpeg_xl_metadata_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (JpegXLMetadataWriter), 0, (GInstanceInitFunc) jpeg_xl_metadata_writer_instance_init, NULL };
	GType jpeg_xl_metadata_writer_type_id;
	jpeg_xl_metadata_writer_type_id = g_type_register_static (TYPE_PHOTO_FILE_METADATA_WRITER, "JpegXLMetadataWriter", &g_define_type_info, 0);
	return jpeg_xl_metadata_writer_type_id;
}

GType
jpeg_xl_metadata_writer_get_type (void)
{
	static volatile gsize jpeg_xl_metadata_writer_type_id__once = 0;
	if (g_once_init_enter (&jpeg_xl_metadata_writer_type_id__once)) {
		GType jpeg_xl_metadata_writer_type_id;
		jpeg_xl_metadata_writer_type_id = jpeg_xl_metadata_writer_get_type_once ();
		g_once_init_leave (&jpeg_xl_metadata_writer_type_id__once, jpeg_xl_metadata_writer_type_id);
	}
	return jpeg_xl_metadata_writer_type_id__once;
}

void
jpeg_xl_file_format_driver_init (void)
{
	JpegXLFileFormatDriver* _tmp0_;
	_tmp0_ = jpeg_xl_file_format_driver_new ();
	_photo_file_format_driver_unref0 (jpeg_xl_file_format_driver_instance);
	jpeg_xl_file_format_driver_instance = _tmp0_;
	jpeg_xl_file_format_properties_init ();
}

static gpointer
_photo_file_format_driver_ref0 (gpointer self)
{
	return self ? photo_file_format_driver_ref (self) : NULL;
}

JpegXLFileFormatDriver*
jpeg_xl_file_format_driver_get_instance (void)
{
	JpegXLFileFormatDriver* _tmp0_;
	JpegXLFileFormatDriver* _tmp1_;
	JpegXLFileFormatDriver* result;
	_tmp0_ = jpeg_xl_file_format_driver_instance;
	_tmp1_ = _photo_file_format_driver_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static PhotoFileFormatProperties*
jpeg_xl_file_format_driver_real_get_properties (PhotoFileFormatDriver* base)
{
	JpegXLFileFormatDriver * self;
	JpegXLFileFormatProperties* _tmp0_;
	PhotoFileFormatProperties* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_JPEG_XL_FILE_FORMAT_DRIVER, JpegXLFileFormatDriver);
	_tmp0_ = jpeg_xl_file_format_properties_get_instance ();
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatProperties);
	return result;
}

static PhotoFileReader*
jpeg_xl_file_format_driver_real_create_reader (PhotoFileFormatDriver* base,
                                               const gchar* filepath)
{
	JpegXLFileFormatDriver * self;
	JpegXLReader* _tmp0_;
	PhotoFileReader* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_JPEG_XL_FILE_FORMAT_DRIVER, JpegXLFileFormatDriver);
	g_return_val_if_fail (filepath != NULL, NULL);
	_tmp0_ = jpeg_xl_reader_new (filepath);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PHOTO_FILE_READER, PhotoFileReader);
	return result;
}

static gboolean
jpeg_xl_file_format_driver_real_can_write_image (PhotoFileFormatDriver* base)
{
	JpegXLFileFormatDriver * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_JPEG_XL_FILE_FORMAT_DRIVER, JpegXLFileFormatDriver);
	result = FALSE;
	return result;
}

static gboolean
jpeg_xl_file_format_driver_real_can_write_metadata (PhotoFileFormatDriver* base)
{
	JpegXLFileFormatDriver * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_JPEG_XL_FILE_FORMAT_DRIVER, JpegXLFileFormatDriver);
	result = TRUE;
	return result;
}

static PhotoFileWriter*
jpeg_xl_file_format_driver_real_create_writer (PhotoFileFormatDriver* base,
                                               const gchar* filepath)
{
	JpegXLFileFormatDriver * self;
	PhotoFileWriter* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_JPEG_XL_FILE_FORMAT_DRIVER, JpegXLFileFormatDriver);
	g_return_val_if_fail (filepath != NULL, NULL);
	result = NULL;
	return result;
}

static PhotoFileMetadataWriter*
jpeg_xl_file_format_driver_real_create_metadata_writer (PhotoFileFormatDriver* base,
                                                        const gchar* filepath)
{
	JpegXLFileFormatDriver * self;
	JpegXLMetadataWriter* _tmp0_;
	PhotoFileMetadataWriter* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_JPEG_XL_FILE_FORMAT_DRIVER, JpegXLFileFormatDriver);
	g_return_val_if_fail (filepath != NULL, NULL);
	_tmp0_ = jpeg_xl_metadata_writer_new (filepath);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriter);
	return result;
}

static PhotoFileSniffer*
jpeg_xl_file_format_driver_real_create_sniffer (PhotoFileFormatDriver* base,
                                                GFile* file,
                                                PhotoFileSnifferOptions options)
{
	JpegXLFileFormatDriver * self;
	JpegXLSniffer* _tmp0_;
	PhotoFileSniffer* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_JPEG_XL_FILE_FORMAT_DRIVER, JpegXLFileFormatDriver);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	_tmp0_ = jpeg_xl_sniffer_new (file, options);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer);
	return result;
}

static PhotoMetadata*
jpeg_xl_file_format_driver_real_create_metadata (PhotoFileFormatDriver* base)
{
	JpegXLFileFormatDriver * self;
	PhotoMetadata* _tmp0_;
	PhotoMetadata* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_JPEG_XL_FILE_FORMAT_DRIVER, JpegXLFileFormatDriver);
	_tmp0_ = photo_metadata_new ();
	result = _tmp0_;
	return result;
}

JpegXLFileFormatDriver*
jpeg_xl_file_format_driver_construct (GType object_type)
{
	JpegXLFileFormatDriver* self = NULL;
	self = (JpegXLFileFormatDriver*) photo_file_format_driver_construct (object_type);
	return self;
}

JpegXLFileFormatDriver*
jpeg_xl_file_format_driver_new (void)
{
	return jpeg_xl_file_format_driver_construct (TYPE_JPEG_XL_FILE_FORMAT_DRIVER);
}

static void
jpeg_xl_file_format_driver_class_init (JpegXLFileFormatDriverClass * klass,
                                       gpointer klass_data)
{
	jpeg_xl_file_format_driver_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileFormatDriverClass *) klass)->finalize = jpeg_xl_file_format_driver_finalize;
	((PhotoFileFormatDriverClass *) klass)->get_properties = (PhotoFileFormatProperties* (*) (PhotoFileFormatDriver*)) jpeg_xl_file_format_driver_real_get_properties;
	((PhotoFileFormatDriverClass *) klass)->create_reader = (PhotoFileReader* (*) (PhotoFileFormatDriver*, const gchar*)) jpeg_xl_file_format_driver_real_create_reader;
	((PhotoFileFormatDriverClass *) klass)->can_write_image = (gboolean (*) (PhotoFileFormatDriver*)) jpeg_xl_file_format_driver_real_can_write_image;
	((PhotoFileFormatDriverClass *) klass)->can_write_metadata = (gboolean (*) (PhotoFileFormatDriver*)) jpeg_xl_file_format_driver_real_can_write_metadata;
	((PhotoFileFormatDriverClass *) klass)->create_writer = (PhotoFileWriter* (*) (PhotoFileFormatDriver*, const gchar*)) jpeg_xl_file_format_driver_real_create_writer;
	((PhotoFileFormatDriverClass *) klass)->create_metadata_writer = (PhotoFileMetadataWriter* (*) (PhotoFileFormatDriver*, const gchar*)) jpeg_xl_file_format_driver_real_create_metadata_writer;
	((PhotoFileFormatDriverClass *) klass)->create_sniffer = (PhotoFileSniffer* (*) (PhotoFileFormatDriver*, GFile*, PhotoFileSnifferOptions)) jpeg_xl_file_format_driver_real_create_sniffer;
	((PhotoFileFormatDriverClass *) klass)->create_metadata = (PhotoMetadata* (*) (PhotoFileFormatDriver*)) jpeg_xl_file_format_driver_real_create_metadata;
}

static void
jpeg_xl_file_format_driver_instance_init (JpegXLFileFormatDriver * self,
                                          gpointer klass)
{
}

static void
jpeg_xl_file_format_driver_finalize (PhotoFileFormatDriver * obj)
{
	JpegXLFileFormatDriver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_JPEG_XL_FILE_FORMAT_DRIVER, JpegXLFileFormatDriver);
	PHOTO_FILE_FORMAT_DRIVER_CLASS (jpeg_xl_file_format_driver_parent_class)->finalize (obj);
}

static GType
jpeg_xl_file_format_driver_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (JpegXLFileFormatDriverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) jpeg_xl_file_format_driver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (JpegXLFileFormatDriver), 0, (GInstanceInitFunc) jpeg_xl_file_format_driver_instance_init, NULL };
	GType jpeg_xl_file_format_driver_type_id;
	jpeg_xl_file_format_driver_type_id = g_type_register_static (TYPE_PHOTO_FILE_FORMAT_DRIVER, "JpegXLFileFormatDriver", &g_define_type_info, 0);
	return jpeg_xl_file_format_driver_type_id;
}

GType
jpeg_xl_file_format_driver_get_type (void)
{
	static volatile gsize jpeg_xl_file_format_driver_type_id__once = 0;
	if (g_once_init_enter (&jpeg_xl_file_format_driver_type_id__once)) {
		GType jpeg_xl_file_format_driver_type_id;
		jpeg_xl_file_format_driver_type_id = jpeg_xl_file_format_driver_get_type_once ();
		g_once_init_leave (&jpeg_xl_file_format_driver_type_id__once, jpeg_xl_file_format_driver_type_id);
	}
	return jpeg_xl_file_format_driver_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

