/* rygel-gst-media-engine.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-gst-media-engine.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *         Prasanna Modem <prasanna@ecaspia.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-media-engine-gst.h"
#include <glib.h>
#include "rygel-core.h"
#include <glib-object.h>
#include "rygel-server.h"
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <ges/ges.h>
#include "config.h"
#include <libgupnp-dlna/gupnp-dlna.h>
#include <glib/gi18n-lib.h>
#include <libgupnp-av/gupnp-av.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define RYGEL_TYPE_GST_TRANSCODER (rygel_gst_transcoder_get_type ())
#define RYGEL_GST_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoder))
#define RYGEL_GST_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoderClass))
#define RYGEL_IS_GST_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_TRANSCODER))
#define RYGEL_IS_GST_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_TRANSCODER))
#define RYGEL_GST_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoderClass))

typedef struct _RygelGstTranscoder RygelGstTranscoder;
typedef struct _RygelGstTranscoderClass RygelGstTranscoderClass;
enum  {
	RYGEL_GST_MEDIA_ENGINE_0_PROPERTY,
	RYGEL_GST_MEDIA_ENGINE_NUM_PROPERTIES
};
static GParamSpec* rygel_gst_media_engine_properties[RYGEL_GST_MEDIA_ENGINE_NUM_PROPERTIES];
#define _rygel_dlna_profile_unref0(var) ((var == NULL) ? NULL : (var = (rygel_dlna_profile_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_JPEG_TRANSCODER (rygel_jpeg_transcoder_get_type ())
#define RYGEL_JPEG_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_JPEG_TRANSCODER, RygelJPEGTranscoder))
#define RYGEL_JPEG_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_JPEG_TRANSCODER, RygelJPEGTranscoderClass))
#define RYGEL_IS_JPEG_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_JPEG_TRANSCODER))
#define RYGEL_IS_JPEG_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_JPEG_TRANSCODER))
#define RYGEL_JPEG_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_JPEG_TRANSCODER, RygelJPEGTranscoderClass))

typedef struct _RygelJPEGTranscoder RygelJPEGTranscoder;
typedef struct _RygelJPEGTranscoderClass RygelJPEGTranscoderClass;

#define RYGEL_TYPE_AUDIO_TRANSCODER (rygel_audio_transcoder_get_type ())
#define RYGEL_AUDIO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoder))
#define RYGEL_AUDIO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoderClass))
#define RYGEL_IS_AUDIO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_TRANSCODER))
#define RYGEL_IS_AUDIO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_TRANSCODER))
#define RYGEL_AUDIO_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoderClass))

typedef struct _RygelAudioTranscoder RygelAudioTranscoder;
typedef struct _RygelAudioTranscoderClass RygelAudioTranscoderClass;

#define RYGEL_TYPE_L16_TRANSCODER (rygel_l16_transcoder_get_type ())
#define RYGEL_L16_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_L16_TRANSCODER, RygelL16Transcoder))
#define RYGEL_L16_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_L16_TRANSCODER, RygelL16TranscoderClass))
#define RYGEL_IS_L16_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_L16_TRANSCODER))
#define RYGEL_IS_L16_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_L16_TRANSCODER))
#define RYGEL_L16_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_L16_TRANSCODER, RygelL16TranscoderClass))

typedef struct _RygelL16Transcoder RygelL16Transcoder;
typedef struct _RygelL16TranscoderClass RygelL16TranscoderClass;

#define RYGEL_TYPE_MP3_TRANSCODER (rygel_mp3_transcoder_get_type ())
#define RYGEL_MP3_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MP3_TRANSCODER, RygelMP3Transcoder))
#define RYGEL_MP3_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MP3_TRANSCODER, RygelMP3TranscoderClass))
#define RYGEL_IS_MP3_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MP3_TRANSCODER))
#define RYGEL_IS_MP3_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MP3_TRANSCODER))
#define RYGEL_MP3_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MP3_TRANSCODER, RygelMP3TranscoderClass))

typedef struct _RygelMP3Transcoder RygelMP3Transcoder;
typedef struct _RygelMP3TranscoderClass RygelMP3TranscoderClass;
typedef enum  {
	RYGEL_MP2_TS_PROFILE_SD_EU = 0,
	RYGEL_MP2_TS_PROFILE_SD_NA,
	RYGEL_MP2_TS_PROFILE_HD_NA
} RygelMP2TSProfile;

#define RYGEL_TYPE_MP2_TS_PROFILE (rygel_mp2_ts_profile_get_type ())

#define RYGEL_TYPE_VIDEO_TRANSCODER (rygel_video_transcoder_get_type ())
#define RYGEL_VIDEO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoder))
#define RYGEL_VIDEO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoderClass))
#define RYGEL_IS_VIDEO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_TRANSCODER))
#define RYGEL_IS_VIDEO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_TRANSCODER))
#define RYGEL_VIDEO_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoderClass))

typedef struct _RygelVideoTranscoder RygelVideoTranscoder;
typedef struct _RygelVideoTranscoderClass RygelVideoTranscoderClass;

#define RYGEL_TYPE_MP2_TS_TRANSCODER (rygel_mp2_ts_transcoder_get_type ())
#define RYGEL_MP2_TS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoder))
#define RYGEL_MP2_TS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoderClass))
#define RYGEL_IS_MP2_TS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER))
#define RYGEL_IS_MP2_TS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MP2_TS_TRANSCODER))
#define RYGEL_MP2_TS_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoderClass))

typedef struct _RygelMP2TSTranscoder RygelMP2TSTranscoder;
typedef struct _RygelMP2TSTranscoderClass RygelMP2TSTranscoderClass;

#define RYGEL_TYPE_WMV_TRANSCODER (rygel_wmv_transcoder_get_type ())
#define RYGEL_WMV_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WMV_TRANSCODER, RygelWMVTranscoder))
#define RYGEL_WMV_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_WMV_TRANSCODER, RygelWMVTranscoderClass))
#define RYGEL_IS_WMV_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WMV_TRANSCODER))
#define RYGEL_IS_WMV_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_WMV_TRANSCODER))
#define RYGEL_WMV_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_WMV_TRANSCODER, RygelWMVTranscoderClass))

typedef struct _RygelWMVTranscoder RygelWMVTranscoder;
typedef struct _RygelWMVTranscoderClass RygelWMVTranscoderClass;

#define RYGEL_TYPE_AAC_TRANSCODER (rygel_aac_transcoder_get_type ())
#define RYGEL_AAC_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AAC_TRANSCODER, RygelAACTranscoder))
#define RYGEL_AAC_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AAC_TRANSCODER, RygelAACTranscoderClass))
#define RYGEL_IS_AAC_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AAC_TRANSCODER))
#define RYGEL_IS_AAC_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AAC_TRANSCODER))
#define RYGEL_AAC_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AAC_TRANSCODER, RygelAACTranscoderClass))

typedef struct _RygelAACTranscoder RygelAACTranscoder;
typedef struct _RygelAACTranscoderClass RygelAACTranscoderClass;

#define RYGEL_TYPE_AVC_TRANSCODER (rygel_avc_transcoder_get_type ())
#define RYGEL_AVC_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AVC_TRANSCODER, RygelAVCTranscoder))
#define RYGEL_AVC_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AVC_TRANSCODER, RygelAVCTranscoderClass))
#define RYGEL_IS_AVC_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AVC_TRANSCODER))
#define RYGEL_IS_AVC_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AVC_TRANSCODER))
#define RYGEL_AVC_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AVC_TRANSCODER, RygelAVCTranscoderClass))

typedef struct _RygelAVCTranscoder RygelAVCTranscoder;
typedef struct _RygelAVCTranscoderClass RygelAVCTranscoderClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
typedef struct _RygelGstMediaEngineGetResourcesForItemData RygelGstMediaEngineGetResourcesForItemData;

#define RYGEL_TYPE_GST_DATA_SOURCE (rygel_gst_data_source_get_type ())
#define RYGEL_GST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSource))
#define RYGEL_GST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourceClass))
#define RYGEL_IS_GST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_DATA_SOURCE))
#define RYGEL_IS_GST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_DATA_SOURCE))
#define RYGEL_GST_DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourceClass))

typedef struct _RygelGstDataSource RygelGstDataSource;
typedef struct _RygelGstDataSourceClass RygelGstDataSourceClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelGstMediaEnginePrivate {
	GList* dlna_profiles;
	GList* transcoders;
};

struct _Block1Data {
	int _ref_count_;
	RygelGstMediaEngine* self;
	RygelMediaFileItem* item;
	gpointer _async_data_;
};

struct _RygelGstMediaEngineGetResourcesForItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelGstMediaEngine* self;
	RygelMediaObject* object;
	GeeList* result;
	Block1Data* _data1_;
	RygelMediaFileItem* _tmp0_;
	gchar* source_uri;
	RygelMediaFileItem* _tmp1_;
	gchar* _tmp2_;
	gchar* scheme;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean uri_is_http;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GeeArrayList* resources;
	GeeArrayList* _tmp17_;
	RygelMediaResource* primary_res;
	RygelMediaFileItem* _tmp18_;
	RygelMediaResource* _tmp19_;
	RygelMediaResource* _tmp20_;
	RygelMediaResource* _tmp21_;
	GUPnPDLNAFlags _tmp22_;
	GUPnPDLNAFlags _tmp23_;
	RygelMediaResource* http_res;
	RygelMediaResource* _tmp24_;
	RygelMediaResource* _tmp25_;
	RygelMediaResource* _tmp26_;
	GeeArrayList* _tmp27_;
	RygelMediaResource* _tmp28_;
	RygelMediaFileItem* _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	GList* list;
	GList* _tmp32_;
	GList* transcoder_collection;
	GList* transcoder_it;
	RygelGstTranscoder* _tmp33_;
	RygelGstTranscoder* transcoder;
	gboolean _tmp34_;
	RygelGstTranscoder* _tmp35_;
	RygelMediaFileItem* _tmp36_;
	RygelGstTranscoder* _tmp37_;
	RygelMediaFileItem* _tmp38_;
	RygelGstTranscoder* _tmp39_;
	RygelGstTranscoder* _tmp40_;
	GList* _tmp41_;
	GList* _vala1_transcoder_collection;
	GList* _vala1_transcoder_it;
	RygelGstTranscoder* _tmp42_;
	RygelGstTranscoder* _vala1_transcoder;
	RygelMediaResource* res;
	RygelGstTranscoder* _tmp43_;
	RygelMediaFileItem* _tmp44_;
	RygelMediaResource* _tmp45_;
	RygelMediaResource* _tmp46_;
	GeeArrayList* _tmp47_;
	RygelMediaResource* _tmp48_;
	gboolean _tmp49_;
	RygelMediaResource* _tmp50_;
	const gchar* _tmp51_;
	const gchar* _tmp52_;
	GeeArrayList* _tmp53_;
	RygelMediaResource* _tmp54_;
	GeeArrayList* _tmp55_;
	RygelMediaResource* _tmp56_;
};

static gint RygelGstMediaEngine_private_offset;
static gpointer rygel_gst_media_engine_parent_class = NULL;

VALA_EXTERN GType rygel_gst_transcoder_get_type (void) G_GNUC_CONST ;
static void _rygel_dlna_profile_unref0_ (gpointer var);
static inline void _g_list_free__rygel_dlna_profile_unref0_ (GList* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN RygelJPEGTranscoder* rygel_jpeg_transcoder_new (void);
VALA_EXTERN RygelJPEGTranscoder* rygel_jpeg_transcoder_construct (GType object_type);
VALA_EXTERN GType rygel_jpeg_transcoder_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelL16Transcoder* rygel_l16_transcoder_new (void);
VALA_EXTERN RygelL16Transcoder* rygel_l16_transcoder_construct (GType object_type);
VALA_EXTERN GType rygel_audio_transcoder_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rygel_l16_transcoder_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelMP3Transcoder* rygel_mp3_transcoder_new (void);
VALA_EXTERN RygelMP3Transcoder* rygel_mp3_transcoder_construct (GType object_type);
VALA_EXTERN GType rygel_mp3_transcoder_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rygel_mp2_ts_profile_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelMP2TSTranscoder* rygel_mp2_ts_transcoder_new (RygelMP2TSProfile profile);
VALA_EXTERN RygelMP2TSTranscoder* rygel_mp2_ts_transcoder_construct (GType object_type,
                                                         RygelMP2TSProfile profile);
VALA_EXTERN GType rygel_video_transcoder_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rygel_mp2_ts_transcoder_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelWMVTranscoder* rygel_wmv_transcoder_new (void);
VALA_EXTERN RygelWMVTranscoder* rygel_wmv_transcoder_construct (GType object_type);
VALA_EXTERN GType rygel_wmv_transcoder_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelAACTranscoder* rygel_aac_transcoder_new (void);
VALA_EXTERN RygelAACTranscoder* rygel_aac_transcoder_construct (GType object_type);
VALA_EXTERN GType rygel_aac_transcoder_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelAVCTranscoder* rygel_avc_transcoder_new (void);
VALA_EXTERN RygelAVCTranscoder* rygel_avc_transcoder_construct (GType object_type);
VALA_EXTERN GType rygel_avc_transcoder_get_type (void) G_GNUC_CONST ;
static GList* rygel_gst_media_engine_real_get_dlna_profiles (RygelMediaEngine* base);
static void rygel_gst_media_engine_real_get_resources_for_item_data_free (gpointer _data);
static void rygel_gst_media_engine_real_get_resources_for_item (RygelMediaEngine* base,
                                                         RygelMediaObject* object,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_);
static gboolean rygel_gst_media_engine_real_get_resources_for_item_co (RygelGstMediaEngineGetResourcesForItemData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
VALA_EXTERN guint rygel_gst_transcoder_get_distance (RygelGstTranscoder* self,
                                         RygelMediaFileItem* item);
VALA_EXTERN gboolean rygel_gst_transcoder_transcoding_necessary (RygelGstTranscoder* self,
                                                     RygelMediaFileItem* item);
static gint ___lambda7_ (Block1Data* _data1_,
                  RygelGstTranscoder* transcoder_1,
                  RygelGstTranscoder* transcoder_2);
static gint ____lambda7__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
VALA_EXTERN RygelMediaResource* rygel_gst_transcoder_get_resource_for_item (RygelGstTranscoder* self,
                                                                RygelMediaFileItem* item);
static RygelDataSource* rygel_gst_media_engine_real_create_data_source_for_resource (RygelMediaEngine* base,
                                                                              RygelMediaObject* object,
                                                                              RygelMediaResource* resource,
                                                                              GHashTable* replacements,
                                                                              GError** error);
VALA_EXTERN GType rygel_gst_data_source_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelGstDataSource* rygel_gst_data_source_new (const gchar* uri,
                                               RygelMediaResource* resource,
                                               GError** error);
VALA_EXTERN RygelGstDataSource* rygel_gst_data_source_construct (GType object_type,
                                                     const gchar* uri,
                                                     RygelMediaResource* resource,
                                                     GError** error);
VALA_EXTERN const gchar* rygel_gst_transcoder_get_name (RygelGstTranscoder* self);
VALA_EXTERN const gchar* rygel_gst_transcoder_get_dlna_profile (RygelGstTranscoder* self);
VALA_EXTERN RygelGstDataSource* rygel_gst_transcoder_create_source (RygelGstTranscoder* self,
                                                        RygelMediaFileItem* item,
                                                        RygelDataSource* src,
                                                        GError** error);
static RygelDataSource* rygel_gst_media_engine_real_create_data_source_for_uri (RygelMediaEngine* base,
                                                                         const gchar* source_uri,
                                                                         GError** error);
VALA_EXTERN RygelGstDataSource* rygel_gst_data_source_new_from_element (GstElement* element);
VALA_EXTERN RygelGstDataSource* rygel_gst_data_source_construct_from_element (GType object_type,
                                                                  GstElement* element);
static GList* rygel_gst_media_engine_real_get_internal_protocol_schemes (RygelMediaEngine* base);
static void rygel_gst_media_engine_finalize (GObject * obj);
static GType rygel_gst_media_engine_get_type_once (void);

static inline gpointer
rygel_gst_media_engine_get_instance_private (RygelGstMediaEngine* self)
{
	return G_STRUCT_MEMBER_P (self, RygelGstMediaEngine_private_offset);
}

static void
_rygel_dlna_profile_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (rygel_dlna_profile_unref (var), NULL));
}

static inline void
_g_list_free__rygel_dlna_profile_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _rygel_dlna_profile_unref0_);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_rygel_dlna_profile_ref0 (gpointer self)
{
	return self ? rygel_dlna_profile_ref (self) : NULL;
}

RygelGstMediaEngine*
rygel_gst_media_engine_construct (GType object_type)
{
	RygelGstMediaEngine * self = NULL;
	gchar** args = NULL;
	gint args_length1;
	gint _args_size_;
	GUPnPDLNAProfileGuesser* discoverer = NULL;
	GUPnPDLNAProfileGuesser* _tmp0_;
	GUPnPDLNAProfileGuesser* _tmp1_;
	GList* _tmp2_;
	RygelDLNAProfile* _tmp13_;
	gboolean transcoding = FALSE;
	GeeArrayList* transcoder_list = NULL;
	GeeArrayList* _tmp14_;
	RygelMetaConfig* config = NULL;
	RygelMetaConfig* _tmp15_;
	GError* _inner_error0_ = NULL;
	self = (RygelGstMediaEngine*) rygel_media_engine_construct (object_type);
	args = NULL;
	args_length1 = 0;
	_args_size_ = args_length1;
	gst_init ((gint*) (&args_length1), &args);
	_args_size_ = args_length1;
	ges_init ();
	gst_preset_set_app_dir (PRESET_DIR);
	_tmp0_ = gupnp_dlna_profile_guesser_new (TRUE, FALSE);
	discoverer = _tmp0_;
	_tmp1_ = discoverer;
	_tmp2_ = gupnp_dlna_profile_guesser_list_profiles (_tmp1_);
	{
		GList* profile_collection = NULL;
		GList* profile_it = NULL;
		profile_collection = _tmp2_;
		for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
			GUPnPDLNAProfile* _tmp3_;
			GUPnPDLNAProfile* profile = NULL;
			_tmp3_ = _g_object_ref0 ((GUPnPDLNAProfile*) profile_it->data);
			profile = _tmp3_;
			{
				RygelDLNAProfile* p = NULL;
				GUPnPDLNAProfile* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				GUPnPDLNAProfile* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				RygelDLNAProfile* _tmp10_;
				RygelDLNAProfile* _tmp11_;
				RygelDLNAProfile* _tmp12_;
				_tmp4_ = profile;
				_tmp5_ = gupnp_dlna_profile_get_name (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = profile;
				_tmp8_ = gupnp_dlna_profile_get_mime (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = rygel_dlna_profile_new (_tmp6_, _tmp9_);
				p = _tmp10_;
				_tmp11_ = p;
				_tmp12_ = _rygel_dlna_profile_ref0 (_tmp11_);
				self->priv->dlna_profiles = g_list_prepend (self->priv->dlna_profiles, _tmp12_);
				_rygel_dlna_profile_unref0 (p);
				_g_object_unref0 (profile);
			}
		}
	}
	_tmp13_ = rygel_dlna_profile_new ("DIDL_S", "text/xml");
	self->priv->dlna_profiles = g_list_prepend (self->priv->dlna_profiles, _tmp13_);
	self->priv->dlna_profiles = g_list_reverse (self->priv->dlna_profiles);
	transcoding = TRUE;
	_tmp14_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	transcoder_list = _tmp14_;
	_tmp15_ = rygel_meta_config_get_default ();
	config = _tmp15_;
	{
		gboolean _tmp16_ = FALSE;
		RygelMetaConfig* _tmp17_;
		GeeArrayList* _tmp18_ = NULL;
		RygelMetaConfig* _tmp19_;
		GeeArrayList* _tmp20_;
		GeeArrayList* _tmp21_;
		_tmp17_ = config;
		_tmp16_ = rygel_configuration_get_transcoding ((RygelConfiguration*) _tmp17_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		transcoding = _tmp16_;
		_tmp19_ = config;
		_tmp20_ = rygel_configuration_get_string_list ((RygelConfiguration*) _tmp19_, "GstMediaEngine", "transcoders", &_inner_error0_);
		_tmp18_ = _tmp20_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp21_ = _tmp18_;
		_tmp18_ = NULL;
		_g_object_unref0 (transcoder_list);
		transcoder_list = _tmp21_;
		_g_object_unref0 (_tmp18_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (config);
		_g_object_unref0 (transcoder_list);
		_g_object_unref0 (discoverer);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	if (transcoding) {
		RygelJPEGTranscoder* _tmp22_;
		_tmp22_ = rygel_jpeg_transcoder_new ();
		self->priv->transcoders = g_list_prepend (self->priv->transcoders, (RygelGstTranscoder*) _tmp22_);
		{
			GeeArrayList* _transcoder_list = NULL;
			GeeArrayList* _tmp23_;
			gint _transcoder_size = 0;
			GeeArrayList* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			gint _transcoder_index = 0;
			_tmp23_ = transcoder_list;
			_transcoder_list = _tmp23_;
			_tmp24_ = _transcoder_list;
			_tmp25_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp24_);
			_tmp26_ = _tmp25_;
			_transcoder_size = _tmp26_;
			_transcoder_index = -1;
			while (TRUE) {
				gint _tmp27_;
				gint _tmp28_;
				gchar* transcoder = NULL;
				GeeArrayList* _tmp29_;
				gpointer _tmp30_;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				GQuark _tmp34_ = 0U;
				static GQuark _tmp33_label0 = 0;
				static GQuark _tmp33_label1 = 0;
				static GQuark _tmp33_label2 = 0;
				static GQuark _tmp33_label3 = 0;
				static GQuark _tmp33_label4 = 0;
				static GQuark _tmp33_label5 = 0;
				_transcoder_index = _transcoder_index + 1;
				_tmp27_ = _transcoder_index;
				_tmp28_ = _transcoder_size;
				if (!(_tmp27_ < _tmp28_)) {
					break;
				}
				_tmp29_ = _transcoder_list;
				_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, _transcoder_index);
				transcoder = (gchar*) _tmp30_;
				_tmp31_ = transcoder;
				_tmp32_ = _tmp31_;
				_tmp34_ = (NULL == _tmp32_) ? 0 : g_quark_from_string (_tmp32_);
				if (_tmp34_ == ((0 != _tmp33_label0) ? _tmp33_label0 : (_tmp33_label0 = g_quark_from_static_string ("lpcm")))) {
					switch (0) {
						default:
						{
							RygelL16Transcoder* _tmp35_;
							_tmp35_ = rygel_l16_transcoder_new ();
							self->priv->transcoders = g_list_prepend (self->priv->transcoders, (RygelGstTranscoder*) _tmp35_);
							break;
						}
					}
				} else if (_tmp34_ == ((0 != _tmp33_label1) ? _tmp33_label1 : (_tmp33_label1 = g_quark_from_static_string ("mp3")))) {
					switch (0) {
						default:
						{
							RygelMP3Transcoder* _tmp36_;
							_tmp36_ = rygel_mp3_transcoder_new ();
							self->priv->transcoders = g_list_prepend (self->priv->transcoders, (RygelGstTranscoder*) _tmp36_);
							break;
						}
					}
				} else if (_tmp34_ == ((0 != _tmp33_label2) ? _tmp33_label2 : (_tmp33_label2 = g_quark_from_static_string ("mp2ts")))) {
					switch (0) {
						default:
						{
							RygelMP2TSTranscoder* _tmp37_;
							RygelMP2TSTranscoder* _tmp38_;
							RygelMP2TSTranscoder* _tmp39_;
							_tmp37_ = rygel_mp2_ts_transcoder_new (RYGEL_MP2_TS_PROFILE_SD_EU);
							self->priv->transcoders = g_list_prepend (self->priv->transcoders, (RygelGstTranscoder*) _tmp37_);
							_tmp38_ = rygel_mp2_ts_transcoder_new (RYGEL_MP2_TS_PROFILE_SD_NA);
							self->priv->transcoders = g_list_prepend (self->priv->transcoders, (RygelGstTranscoder*) _tmp38_);
							_tmp39_ = rygel_mp2_ts_transcoder_new (RYGEL_MP2_TS_PROFILE_HD_NA);
							self->priv->transcoders = g_list_prepend (self->priv->transcoders, (RygelGstTranscoder*) _tmp39_);
							break;
						}
					}
				} else if (_tmp34_ == ((0 != _tmp33_label3) ? _tmp33_label3 : (_tmp33_label3 = g_quark_from_static_string ("wmv")))) {
					switch (0) {
						default:
						{
							RygelWMVTranscoder* _tmp40_;
							_tmp40_ = rygel_wmv_transcoder_new ();
							self->priv->transcoders = g_list_prepend (self->priv->transcoders, (RygelGstTranscoder*) _tmp40_);
							break;
						}
					}
				} else if (_tmp34_ == ((0 != _tmp33_label4) ? _tmp33_label4 : (_tmp33_label4 = g_quark_from_static_string ("aac")))) {
					switch (0) {
						default:
						{
							RygelAACTranscoder* _tmp41_;
							_tmp41_ = rygel_aac_transcoder_new ();
							self->priv->transcoders = g_list_prepend (self->priv->transcoders, (RygelGstTranscoder*) _tmp41_);
							break;
						}
					}
				} else if (_tmp34_ == ((0 != _tmp33_label5) ? _tmp33_label5 : (_tmp33_label5 = g_quark_from_static_string ("avc")))) {
					switch (0) {
						default:
						{
							RygelAVCTranscoder* _tmp42_;
							_tmp42_ = rygel_avc_transcoder_new ();
							self->priv->transcoders = g_list_prepend (self->priv->transcoders, (RygelGstTranscoder*) _tmp42_);
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							const gchar* _tmp43_;
							_tmp43_ = transcoder;
							g_debug ("rygel-gst-media-engine.vala:102: Unsupported transcoder \"%s\"", _tmp43_);
							break;
						}
					}
				}
				_g_free0 (transcoder);
			}
		}
		self->priv->transcoders = g_list_reverse (self->priv->transcoders);
	}
	_g_object_unref0 (config);
	_g_object_unref0 (transcoder_list);
	_g_object_unref0 (discoverer);
	return self;
}

RygelGstMediaEngine*
rygel_gst_media_engine_new (void)
{
	return rygel_gst_media_engine_construct (RYGEL_TYPE_GST_MEDIA_ENGINE);
}

static GList*
rygel_gst_media_engine_real_get_dlna_profiles (RygelMediaEngine* base)
{
	RygelGstMediaEngine * self;
	GList* _tmp0_;
	GList* result;
	self = (RygelGstMediaEngine*) base;
	_tmp0_ = self->priv->dlna_profiles;
	result = _tmp0_;
	return result;
}

static void
rygel_gst_media_engine_real_get_resources_for_item_data_free (gpointer _data)
{
	RygelGstMediaEngineGetResourcesForItemData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->object);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelGstMediaEngineGetResourcesForItemData, _data_);
}

static void
rygel_gst_media_engine_real_get_resources_for_item (RygelMediaEngine* base,
                                                    RygelMediaObject* object,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_)
{
	RygelGstMediaEngine * self;
	RygelGstMediaEngineGetResourcesForItemData* _data_;
	RygelGstMediaEngine* _tmp0_;
	RygelMediaObject* _tmp1_;
	g_return_if_fail (object != NULL);
	self = (RygelGstMediaEngine*) base;
	_data_ = g_slice_new0 (RygelGstMediaEngineGetResourcesForItemData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_gst_media_engine_real_get_resources_for_item_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (object);
	_g_object_unref0 (_data_->object);
	_data_->object = _tmp1_;
	rygel_gst_media_engine_real_get_resources_for_item_co (_data_);
}

static GeeList*
rygel_gst_media_engine_get_resources_for_item_finish (RygelMediaEngine* base,
                                                      GAsyncResult* _res_)
{
	GeeList* result;
	RygelGstMediaEngineGetResourcesForItemData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		RygelGstMediaEngine* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->item);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gint
___lambda7_ (Block1Data* _data1_,
             RygelGstTranscoder* transcoder_1,
             RygelGstTranscoder* transcoder_2)
{
	RygelGstMediaEngine* self;
	RygelMediaFileItem* _tmp0_;
	RygelMediaFileItem* _tmp1_;
	gint result;
	self = _data1_->self;
	g_return_val_if_fail (transcoder_1 != NULL, 0);
	g_return_val_if_fail (transcoder_2 != NULL, 0);
	_tmp0_ = _data1_->item;
	_tmp1_ = _data1_->item;
	result = (gint) (rygel_gst_transcoder_get_distance (transcoder_1, _tmp0_) - rygel_gst_transcoder_get_distance (transcoder_2, _tmp1_));
	return result;
}

static gint
____lambda7__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = ___lambda7_ (self, (RygelGstTranscoder*) a, (RygelGstTranscoder*) b);
	return result;
}

static gboolean
rygel_gst_media_engine_real_get_resources_for_item_co (RygelGstMediaEngineGetResourcesForItemData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_data_->object, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
		g_warning ("rygel-gst-media-engine.vala:118: Can only process file-based MediaObje" \
"cts (MediaFileItems)");
		_data_->result = NULL;
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->object, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _data_->object) : NULL);
	_data_->_data1_->item = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->_data1_->item;
	_data_->_tmp2_ = rygel_media_object_get_primary_uri ((RygelMediaObject*) _data_->_tmp1_);
	_data_->source_uri = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->source_uri;
	_data_->_tmp4_ = g_uri_parse_scheme (_data_->_tmp3_);
	_data_->scheme = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->scheme;
	_data_->uri_is_http = g_str_has_prefix (_data_->_tmp5_, "http");
	_data_->_tmp6_ = _data_->scheme;
	if (_data_->_tmp6_ == NULL) {
		_data_->_tmp7_ = _data_->source_uri;
		g_warning (_ ("Invalid URI without prefix: %s"), _data_->_tmp7_);
		_data_->result = NULL;
		_g_free0 (_data_->scheme);
		_g_free0 (_data_->source_uri);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = _data_->source_uri;
	_data_->_tmp9_ = _data_->scheme;
	g_debug ("rygel-gst-media-engine.vala:137: get_resources_for_item(%s), protocol:" \
" %s", _data_->_tmp8_, _data_->_tmp9_);
	_data_->_tmp12_ = _data_->scheme;
	if (!gst_uri_protocol_is_supported (GST_URI_SRC, _data_->_tmp12_)) {
		_data_->_tmp13_ = _data_->scheme;
		_data_->_tmp11_ = g_strcmp0 (_data_->_tmp13_, "gst-launch") != 0;
	} else {
		_data_->_tmp11_ = FALSE;
	}
	if (_data_->_tmp11_) {
		_data_->_tmp14_ = _data_->scheme;
		_data_->_tmp10_ = g_strcmp0 (_data_->_tmp14_, "dvd") != 0;
	} else {
		_data_->_tmp10_ = FALSE;
	}
	if (_data_->_tmp10_) {
		_data_->_tmp15_ = _data_->source_uri;
		_data_->_tmp16_ = _data_->scheme;
		g_warning (_ ("Can’t process URI %s with protocol %s"), _data_->_tmp15_, _data_->_tmp16_);
		_data_->result = NULL;
		_g_free0 (_data_->scheme);
		_g_free0 (_data_->source_uri);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp17_ = gee_array_list_new (RYGEL_TYPE_MEDIA_RESOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data_->resources = _data_->_tmp17_;
	_data_->_tmp18_ = _data_->_data1_->item;
	_data_->_tmp19_ = rygel_media_file_item_get_primary_resource (_data_->_tmp18_);
	_data_->primary_res = _data_->_tmp19_;
	_data_->_tmp20_ = _data_->primary_res;
	_data_->_tmp21_ = _data_->primary_res;
	_data_->_tmp22_ = rygel_media_resource_get_dlna_flags (_data_->_tmp21_);
	_data_->_tmp23_ = _data_->_tmp22_;
	rygel_media_resource_set_dlna_flags (_data_->_tmp21_, _data_->_tmp23_ | GUPNP_DLNA_FLAGS_CONNECTION_STALL);
	if (!_data_->uri_is_http) {
		_data_->_tmp24_ = _data_->primary_res;
		_data_->_tmp25_ = rygel_media_resource_new_from_resource ("primary_http", _data_->_tmp24_);
		_data_->http_res = _data_->_tmp25_;
		_data_->_tmp26_ = _data_->http_res;
		rygel_media_resource_set_uri (_data_->_tmp26_, "");
		_data_->_tmp27_ = _data_->resources;
		_data_->_tmp28_ = _data_->http_res;
		gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp27_, _data_->_tmp28_);
		_g_object_unref0 (_data_->http_res);
	}
	_data_->_tmp29_ = _data_->_data1_->item;
	_data_->_tmp30_ = rygel_media_file_item_get_place_holder (_data_->_tmp29_);
	_data_->_tmp31_ = _data_->_tmp30_;
	if (!_data_->_tmp31_) {
		_data_->list = NULL;
		_data_->_tmp32_ = _data_->self->priv->transcoders;
		{
			_data_->transcoder_collection = _data_->_tmp32_;
			for (_data_->transcoder_it = _data_->transcoder_collection; _data_->transcoder_it != NULL; _data_->transcoder_it = _data_->transcoder_it->next) {
				_data_->_tmp33_ = _g_object_ref0 ((RygelGstTranscoder*) _data_->transcoder_it->data);
				_data_->transcoder = _data_->_tmp33_;
				{
					_data_->_tmp35_ = _data_->transcoder;
					_data_->_tmp36_ = _data_->_data1_->item;
					if (rygel_gst_transcoder_get_distance (_data_->_tmp35_, _data_->_tmp36_) != G_MAXUINT) {
						_data_->_tmp37_ = _data_->transcoder;
						_data_->_tmp38_ = _data_->_data1_->item;
						_data_->_tmp34_ = rygel_gst_transcoder_transcoding_necessary (_data_->_tmp37_, _data_->_tmp38_);
					} else {
						_data_->_tmp34_ = FALSE;
					}
					if (_data_->_tmp34_) {
						_data_->_tmp39_ = _data_->transcoder;
						_data_->_tmp40_ = _g_object_ref0 (_data_->_tmp39_);
						_data_->list = g_list_append (_data_->list, _data_->_tmp40_);
					}
					_g_object_unref0 (_data_->transcoder);
				}
			}
		}
		_data_->list = g_list_sort_with_data (_data_->list, ____lambda7__gcompare_data_func, _data_->_data1_);
		_data_->_tmp41_ = _data_->list;
		{
			_data_->_vala1_transcoder_collection = _data_->_tmp41_;
			for (_data_->_vala1_transcoder_it = _data_->_vala1_transcoder_collection; _data_->_vala1_transcoder_it != NULL; _data_->_vala1_transcoder_it = _data_->_vala1_transcoder_it->next) {
				_data_->_tmp42_ = _g_object_ref0 ((RygelGstTranscoder*) _data_->_vala1_transcoder_it->data);
				_data_->_vala1_transcoder = _data_->_tmp42_;
				{
					_data_->_tmp43_ = _data_->_vala1_transcoder;
					_data_->_tmp44_ = _data_->_data1_->item;
					_data_->_tmp45_ = rygel_gst_transcoder_get_resource_for_item (_data_->_tmp43_, _data_->_tmp44_);
					_data_->res = _data_->_tmp45_;
					_data_->_tmp46_ = _data_->res;
					if (_data_->_tmp46_ != NULL) {
						_data_->_tmp47_ = _data_->resources;
						_data_->_tmp48_ = _data_->res;
						gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp47_, _data_->_tmp48_);
					}
					_g_object_unref0 (_data_->res);
					_g_object_unref0 (_data_->_vala1_transcoder);
				}
			}
		}
		(_data_->list == NULL) ? NULL : (_data_->list = (_g_list_free__g_object_unref0_ (_data_->list), NULL));
	}
	_data_->_tmp50_ = _data_->primary_res;
	_data_->_tmp51_ = rygel_media_resource_get_uri (_data_->_tmp50_);
	_data_->_tmp52_ = _data_->_tmp51_;
	if (_data_->_tmp52_ != NULL) {
		_data_->_tmp49_ = _data_->uri_is_http;
	} else {
		_data_->_tmp49_ = FALSE;
	}
	if (_data_->_tmp49_) {
		_data_->_tmp53_ = _data_->resources;
		_data_->_tmp54_ = _data_->primary_res;
		gee_abstract_list_insert ((GeeAbstractList*) _data_->_tmp53_, 0, _data_->_tmp54_);
	} else {
		_data_->_tmp55_ = _data_->resources;
		_data_->_tmp56_ = _data_->primary_res;
		gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp55_, _data_->_tmp56_);
	}
	_data_->result = (GeeList*) _data_->resources;
	_g_object_unref0 (_data_->primary_res);
	_g_free0 (_data_->scheme);
	_g_free0 (_data_->source_uri);
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static RygelDataSource*
rygel_gst_media_engine_real_create_data_source_for_resource (RygelMediaEngine* base,
                                                             RygelMediaObject* object,
                                                             RygelMediaResource* resource,
                                                             GHashTable* replacements,
                                                             GError** error)
{
	RygelGstMediaEngine * self;
	RygelMediaFileItem* item = NULL;
	RygelMediaFileItem* _tmp0_;
	gchar* source_uri = NULL;
	RygelMediaFileItem* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	RygelGstDataSource* data_source = NULL;
	const gchar* _tmp7_;
	RygelGstDataSource* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GUPnPDLNAConversion _tmp15_;
	GUPnPDLNAConversion _tmp16_;
	GError* _inner_error0_ = NULL;
	RygelDataSource* result;
	self = (RygelGstMediaEngine*) base;
	g_return_val_if_fail (object != NULL, NULL);
	g_return_val_if_fail (resource != NULL, NULL);
	g_return_val_if_fail (replacements != NULL, NULL);
	if (!G_TYPE_CHECK_INSTANCE_TYPE (object, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
		g_warning ("rygel-gst-media-engine.vala:206: Can only process file-based MediaObje" \
"cts (MediaFileItems)");
		result = NULL;
		return result;
	}
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (object, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) object) : NULL);
	item = _tmp0_;
	_tmp1_ = item;
	_tmp2_ = rygel_media_object_get_primary_uri ((RygelMediaObject*) _tmp1_);
	source_uri = _tmp2_;
	_tmp3_ = source_uri;
	g_debug ("rygel-gst-media-engine.vala:214: creating data source for %s", _tmp3_);
	_tmp4_ = source_uri;
	_tmp5_ = rygel_media_object_apply_replacements (replacements, _tmp4_);
	_g_free0 (source_uri);
	source_uri = _tmp5_;
	_tmp6_ = source_uri;
	g_debug ("rygel-gst-media-engine.vala:216: source_uri after applying replacement" \
"s: %s", _tmp6_);
	_tmp7_ = source_uri;
	_tmp8_ = rygel_gst_data_source_new (_tmp7_, resource, &_inner_error0_);
	data_source = _tmp8_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (source_uri);
		_g_object_unref0 (item);
		return NULL;
	}
	_tmp9_ = rygel_media_resource_get_name (resource);
	_tmp10_ = _tmp9_;
	_tmp11_ = rygel_media_resource_get_dlna_profile (resource);
	_tmp12_ = _tmp11_;
	_tmp13_ = rygel_media_resource_get_mime_type (resource);
	_tmp14_ = _tmp13_;
	g_debug ("rygel-gst-media-engine.vala:219: MediaResource %s, profile %s, mime_ty" \
"pe %s", _tmp10_, _tmp12_, _tmp14_);
	_g_free0 (_tmp10_);
	_tmp15_ = rygel_media_resource_get_dlna_conversion (resource);
	_tmp16_ = _tmp15_;
	if (_tmp16_ == GUPNP_DLNA_CONVERSION_TRANSCODED) {
		GList* _tmp17_;
		_tmp17_ = self->priv->transcoders;
		{
			GList* transcoder_collection = NULL;
			GList* transcoder_it = NULL;
			transcoder_collection = _tmp17_;
			for (transcoder_it = transcoder_collection; transcoder_it != NULL; transcoder_it = transcoder_it->next) {
				RygelGstTranscoder* _tmp18_;
				RygelGstTranscoder* transcoder = NULL;
				_tmp18_ = _g_object_ref0 ((RygelGstTranscoder*) transcoder_it->data);
				transcoder = _tmp18_;
				{
					RygelGstTranscoder* _tmp19_;
					const gchar* _tmp20_;
					const gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					gboolean _tmp24_;
					_tmp19_ = transcoder;
					_tmp20_ = rygel_gst_transcoder_get_name (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = rygel_media_resource_get_name (resource);
					_tmp23_ = _tmp22_;
					_tmp24_ = g_strcmp0 (_tmp21_, _tmp23_) == 0;
					_g_free0 (_tmp23_);
					if (_tmp24_) {
						RygelGstTranscoder* _tmp25_;
						const gchar* _tmp26_;
						const gchar* _tmp27_;
						RygelGstTranscoder* _tmp28_;
						const gchar* _tmp29_;
						const gchar* _tmp30_;
						RygelGstDataSource* _tmp31_ = NULL;
						RygelGstTranscoder* _tmp32_;
						RygelMediaFileItem* _tmp33_;
						RygelGstDataSource* _tmp34_;
						RygelGstDataSource* _tmp35_;
						RygelGstDataSource* _tmp36_;
						_tmp25_ = transcoder;
						_tmp26_ = rygel_gst_transcoder_get_name (_tmp25_);
						_tmp27_ = _tmp26_;
						_tmp28_ = transcoder;
						_tmp29_ = rygel_gst_transcoder_get_dlna_profile (_tmp28_);
						_tmp30_ = _tmp29_;
						g_debug ("Creating data source from transcoder %s " "with DLNA profile %s", _tmp27_, _tmp30_);
						_tmp32_ = transcoder;
						_tmp33_ = item;
						_tmp34_ = data_source;
						_tmp35_ = rygel_gst_transcoder_create_source (_tmp32_, _tmp33_, (RygelDataSource*) _tmp34_, &_inner_error0_);
						_tmp31_ = _tmp35_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							g_propagate_error (error, _inner_error0_);
							_g_object_unref0 (transcoder);
							_g_object_unref0 (data_source);
							_g_free0 (source_uri);
							_g_object_unref0 (item);
							return NULL;
						}
						_tmp36_ = _tmp31_;
						_tmp31_ = NULL;
						_g_object_unref0 (data_source);
						data_source = _tmp36_;
						_g_object_unref0 (_tmp31_);
						_g_object_unref0 (transcoder);
						break;
					}
					_g_object_unref0 (transcoder);
				}
			}
		}
	}
	result = (RygelDataSource*) data_source;
	_g_free0 (source_uri);
	_g_object_unref0 (item);
	return result;
}

static RygelDataSource*
rygel_gst_media_engine_real_create_data_source_for_uri (RygelMediaEngine* base,
                                                        const gchar* source_uri,
                                                        GError** error)
{
	RygelGstMediaEngine * self;
	GError* _inner_error0_ = NULL;
	RygelDataSource* result;
	self = (RygelGstMediaEngine*) base;
	g_return_val_if_fail (source_uri != NULL, NULL);
	{
		RygelGstDataSource* _tmp0_ = NULL;
		RygelGstDataSource* _tmp1_;
		RygelGstDataSource* _tmp2_;
		g_debug ("rygel-gst-media-engine.vala:243: creating data source for %s", source_uri);
		_tmp1_ = rygel_gst_data_source_new (source_uri, NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		result = (RygelDataSource*) _tmp2_;
		_g_object_unref0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = _error_;
		_tmp4_ = _tmp3_->message;
		g_warning (_ ("Failed to create GStreamer data source for %s: %s"), source_uri, _tmp4_);
		result = NULL;
		_g_error_free0 (_error_);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

RygelDataSource*
rygel_gst_media_engine_create_data_source_from_element (RygelGstMediaEngine* self,
                                                        GstElement* element)
{
	RygelGstDataSource* _tmp0_;
	RygelDataSource* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (element != NULL, NULL);
	_tmp0_ = rygel_gst_data_source_new_from_element (element);
	result = (RygelDataSource*) _tmp0_;
	return result;
}

static GList*
rygel_gst_media_engine_real_get_internal_protocol_schemes (RygelMediaEngine* base)
{
	RygelGstMediaEngine * self;
	GList* list = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GList* result;
	self = (RygelGstMediaEngine*) base;
	list = NULL;
	_tmp0_ = g_strdup ("dvd");
	list = g_list_prepend (list, _tmp0_);
	_tmp1_ = g_strdup ("gst-launch");
	list = g_list_prepend (list, _tmp1_);
	result = list;
	return result;
}

static void
rygel_gst_media_engine_class_init (RygelGstMediaEngineClass * klass,
                                   gpointer klass_data)
{
	rygel_gst_media_engine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelGstMediaEngine_private_offset);
	((RygelMediaEngineClass *) klass)->get_dlna_profiles = (GList* (*) (RygelMediaEngine*)) rygel_gst_media_engine_real_get_dlna_profiles;
	((RygelMediaEngineClass *) klass)->get_resources_for_item = (void (*) (RygelMediaEngine*, RygelMediaObject*, GAsyncReadyCallback, gpointer)) rygel_gst_media_engine_real_get_resources_for_item;
	((RygelMediaEngineClass *) klass)->get_resources_for_item_finish = (GeeList* (*) (RygelMediaEngine*, GAsyncResult*)) rygel_gst_media_engine_get_resources_for_item_finish;
	((RygelMediaEngineClass *) klass)->create_data_source_for_resource = (RygelDataSource* (*) (RygelMediaEngine*, RygelMediaObject*, RygelMediaResource*, GHashTable*, GError**)) rygel_gst_media_engine_real_create_data_source_for_resource;
	((RygelMediaEngineClass *) klass)->create_data_source_for_uri = (RygelDataSource* (*) (RygelMediaEngine*, const gchar*, GError**)) rygel_gst_media_engine_real_create_data_source_for_uri;
	((RygelMediaEngineClass *) klass)->get_internal_protocol_schemes = (GList* (*) (RygelMediaEngine*)) rygel_gst_media_engine_real_get_internal_protocol_schemes;
	G_OBJECT_CLASS (klass)->finalize = rygel_gst_media_engine_finalize;
}

static void
rygel_gst_media_engine_instance_init (RygelGstMediaEngine * self,
                                      gpointer klass)
{
	self->priv = rygel_gst_media_engine_get_instance_private (self);
	self->priv->dlna_profiles = NULL;
	self->priv->transcoders = NULL;
}

static void
rygel_gst_media_engine_finalize (GObject * obj)
{
	RygelGstMediaEngine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_GST_MEDIA_ENGINE, RygelGstMediaEngine);
	(self->priv->dlna_profiles == NULL) ? NULL : (self->priv->dlna_profiles = (_g_list_free__rygel_dlna_profile_unref0_ (self->priv->dlna_profiles), NULL));
	(self->priv->transcoders == NULL) ? NULL : (self->priv->transcoders = (_g_list_free__g_object_unref0_ (self->priv->transcoders), NULL));
	G_OBJECT_CLASS (rygel_gst_media_engine_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
rygel_gst_media_engine_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelGstMediaEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_gst_media_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelGstMediaEngine), 0, (GInstanceInitFunc) rygel_gst_media_engine_instance_init, NULL };
	GType rygel_gst_media_engine_type_id;
	rygel_gst_media_engine_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ENGINE, "RygelGstMediaEngine", &g_define_type_info, 0);
	RygelGstMediaEngine_private_offset = g_type_add_instance_private (rygel_gst_media_engine_type_id, sizeof (RygelGstMediaEnginePrivate));
	return rygel_gst_media_engine_type_id;
}

GType
rygel_gst_media_engine_get_type (void)
{
	static volatile gsize rygel_gst_media_engine_type_id__once = 0;
	if (g_once_init_enter (&rygel_gst_media_engine_type_id__once)) {
		GType rygel_gst_media_engine_type_id;
		rygel_gst_media_engine_type_id = rygel_gst_media_engine_get_type_once ();
		g_once_init_leave (&rygel_gst_media_engine_type_id__once, rygel_gst_media_engine_type_id);
	}
	return rygel_gst_media_engine_type_id__once;
}

RygelMediaEngine*
module_get_instance (void)
{
	RygelGstMediaEngine* _tmp0_;
	RygelMediaEngine* result;
	_tmp0_ = rygel_gst_media_engine_new ();
	result = (RygelMediaEngine*) _tmp0_;
	return result;
}

