/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.12.0
 *
 * Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtMultimedia.h"

#line 28 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtMultimedia/qaudioformat.sip"
#include <qaudioformat.h>
#line 29 "/build/pyqt6/src/pyqt6-6.9.1/build/QtMultimedia/sipQtMultimediaQAudioFormat.cpp"



PyDoc_STRVAR(doc_QAudioFormat_isValid, "isValid(self) -> bool");

extern "C" {static PyObject *meth_QAudioFormat_isValid(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_isValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QAudioFormat, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isValid();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_isValid, doc_QAudioFormat_isValid);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_setSampleRate, "setSampleRate(self, sampleRate: int)");

extern "C" {static PyObject *meth_QAudioFormat_setSampleRate(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_setSampleRate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QAudioFormat, &sipCpp, &a0))
        {
            sipCpp->setSampleRate(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_setSampleRate, doc_QAudioFormat_setSampleRate);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_sampleRate, "sampleRate(self) -> int");

extern "C" {static PyObject *meth_QAudioFormat_sampleRate(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_sampleRate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QAudioFormat, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->sampleRate();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_sampleRate, doc_QAudioFormat_sampleRate);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_setChannelCount, "setChannelCount(self, channelCount: int)");

extern "C" {static PyObject *meth_QAudioFormat_setChannelCount(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_setChannelCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QAudioFormat, &sipCpp, &a0))
        {
            sipCpp->setChannelCount(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_setChannelCount, doc_QAudioFormat_setChannelCount);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_channelCount, "channelCount(self) -> int");

extern "C" {static PyObject *meth_QAudioFormat_channelCount(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_channelCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QAudioFormat, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->channelCount();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_channelCount, doc_QAudioFormat_channelCount);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_bytesForDuration, "bytesForDuration(self, duration: int) -> int");

extern "C" {static PyObject *meth_QAudioFormat_bytesForDuration(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_bytesForDuration(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qint64 a0;
        const ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QAudioFormat, &sipCpp, &a0))
        {
            ::qint32 sipRes;

            sipRes = sipCpp->bytesForDuration(a0);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_bytesForDuration, doc_QAudioFormat_bytesForDuration);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_durationForBytes, "durationForBytes(self, byteCount: int) -> int");

extern "C" {static PyObject *meth_QAudioFormat_durationForBytes(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_durationForBytes(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qint32 a0;
        const ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QAudioFormat, &sipCpp, &a0))
        {
            ::qint64 sipRes;

            sipRes = sipCpp->durationForBytes(a0);

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_durationForBytes, doc_QAudioFormat_durationForBytes);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_bytesForFrames, "bytesForFrames(self, frameCount: int) -> int");

extern "C" {static PyObject *meth_QAudioFormat_bytesForFrames(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_bytesForFrames(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qint32 a0;
        const ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QAudioFormat, &sipCpp, &a0))
        {
            ::qint32 sipRes;

            sipRes = sipCpp->bytesForFrames(a0);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_bytesForFrames, doc_QAudioFormat_bytesForFrames);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_framesForBytes, "framesForBytes(self, byteCount: int) -> int");

extern "C" {static PyObject *meth_QAudioFormat_framesForBytes(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_framesForBytes(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qint32 a0;
        const ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QAudioFormat, &sipCpp, &a0))
        {
            ::qint32 sipRes;

            sipRes = sipCpp->framesForBytes(a0);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_framesForBytes, doc_QAudioFormat_framesForBytes);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_framesForDuration, "framesForDuration(self, duration: int) -> int");

extern "C" {static PyObject *meth_QAudioFormat_framesForDuration(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_framesForDuration(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qint64 a0;
        const ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QAudioFormat, &sipCpp, &a0))
        {
            ::qint32 sipRes;

            sipRes = sipCpp->framesForDuration(a0);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_framesForDuration, doc_QAudioFormat_framesForDuration);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_durationForFrames, "durationForFrames(self, frameCount: int) -> int");

extern "C" {static PyObject *meth_QAudioFormat_durationForFrames(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_durationForFrames(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qint32 a0;
        const ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QAudioFormat, &sipCpp, &a0))
        {
            ::qint64 sipRes;

            sipRes = sipCpp->durationForFrames(a0);

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_durationForFrames, doc_QAudioFormat_durationForFrames);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_bytesPerFrame, "bytesPerFrame(self) -> int");

extern "C" {static PyObject *meth_QAudioFormat_bytesPerFrame(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_bytesPerFrame(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QAudioFormat, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->bytesPerFrame();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_bytesPerFrame, doc_QAudioFormat_bytesPerFrame);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_setChannelConfig, "setChannelConfig(self, config: QAudioFormat.ChannelConfig)");

extern "C" {static PyObject *meth_QAudioFormat_setChannelConfig(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_setChannelConfig(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QAudioFormat::ChannelConfig a0;
        ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QAudioFormat, &sipCpp, sipType_QAudioFormat_ChannelConfig, &a0))
        {
            sipCpp->setChannelConfig(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_setChannelConfig, doc_QAudioFormat_setChannelConfig);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_channelConfig, "channelConfig(self) -> QAudioFormat.ChannelConfig");

extern "C" {static PyObject *meth_QAudioFormat_channelConfig(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_channelConfig(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QAudioFormat, &sipCpp))
        {
            ::QAudioFormat::ChannelConfig sipRes;

            sipRes = sipCpp->channelConfig();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QAudioFormat_ChannelConfig);
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_channelConfig, doc_QAudioFormat_channelConfig);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_channelOffset, "channelOffset(self, channel: QAudioFormat.AudioChannelPosition) -> int");

extern "C" {static PyObject *meth_QAudioFormat_channelOffset(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_channelOffset(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QAudioFormat::AudioChannelPosition a0;
        const ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QAudioFormat, &sipCpp, sipType_QAudioFormat_AudioChannelPosition, &a0))
        {
            int sipRes;

            sipRes = sipCpp->channelOffset(a0);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_channelOffset, doc_QAudioFormat_channelOffset);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_setSampleFormat, "setSampleFormat(self, f: QAudioFormat.SampleFormat)");

extern "C" {static PyObject *meth_QAudioFormat_setSampleFormat(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_setSampleFormat(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QAudioFormat::SampleFormat a0;
        ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QAudioFormat, &sipCpp, sipType_QAudioFormat_SampleFormat, &a0))
        {
            sipCpp->setSampleFormat(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_setSampleFormat, doc_QAudioFormat_setSampleFormat);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_sampleFormat, "sampleFormat(self) -> QAudioFormat.SampleFormat");

extern "C" {static PyObject *meth_QAudioFormat_sampleFormat(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_sampleFormat(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QAudioFormat, &sipCpp))
        {
            ::QAudioFormat::SampleFormat sipRes;

            sipRes = sipCpp->sampleFormat();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QAudioFormat_SampleFormat);
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_sampleFormat, doc_QAudioFormat_sampleFormat);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_bytesPerSample, "bytesPerSample(self) -> int");

extern "C" {static PyObject *meth_QAudioFormat_bytesPerSample(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_bytesPerSample(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QAudioFormat, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->bytesPerSample();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_bytesPerSample, doc_QAudioFormat_bytesPerSample);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_normalizedSampleValue, "normalizedSampleValue(self, sample: Optional[PyQt6.sip.voidptr]) -> float");

extern "C" {static PyObject *meth_QAudioFormat_normalizedSampleValue(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_normalizedSampleValue(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const void* a0;
        const ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bv", &sipSelf, sipType_QAudioFormat, &sipCpp, &a0))
        {
            float sipRes;

            sipRes = sipCpp->normalizedSampleValue(a0);

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_normalizedSampleValue, doc_QAudioFormat_normalizedSampleValue);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_defaultChannelConfigForChannelCount, "defaultChannelConfigForChannelCount(channelCount: int) -> QAudioFormat.ChannelConfig");

extern "C" {static PyObject *meth_QAudioFormat_defaultChannelConfigForChannelCount(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_defaultChannelConfigForChannelCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "Ci", &sipSelf, &a0))
        {
            ::QAudioFormat::ChannelConfig sipRes;

            sipRes = ::QAudioFormat::defaultChannelConfigForChannelCount(a0);

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QAudioFormat_ChannelConfig);
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_defaultChannelConfigForChannelCount, doc_QAudioFormat_defaultChannelConfigForChannelCount);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QAudioFormat___eq__(PyObject *, PyObject *);}
static PyObject *slot_QAudioFormat___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QAudioFormat *sipCpp = reinterpret_cast< ::QAudioFormat *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QAudioFormat));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QAudioFormat* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QAudioFormat, &a0))
        {
            bool sipRes;

            sipRes = operator==((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtMultimedia, eq_slot, sipType_QAudioFormat, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QAudioFormat___ne__(PyObject *, PyObject *);}
static PyObject *slot_QAudioFormat___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QAudioFormat *sipCpp = reinterpret_cast< ::QAudioFormat *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QAudioFormat));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QAudioFormat* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QAudioFormat, &a0))
        {
            bool sipRes;

            sipRes = operator!=((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtMultimedia, ne_slot, sipType_QAudioFormat, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_QAudioFormat(void *, int);}
static void release_QAudioFormat(void *sipCppV, int)
{
    delete reinterpret_cast< ::QAudioFormat *>(sipCppV);
}


extern "C" {static void *array_QAudioFormat(Py_ssize_t);}
static void *array_QAudioFormat(Py_ssize_t sipNrElem)
{
    return new ::QAudioFormat[sipNrElem];
}


extern "C" {static void array_delete_QAudioFormat(void *);}
static void array_delete_QAudioFormat(void *sipCpp)
{
    delete[] reinterpret_cast< ::QAudioFormat *>(sipCpp);
}


extern "C" {static void assign_QAudioFormat(void *, Py_ssize_t, void *);}
static void assign_QAudioFormat(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QAudioFormat *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QAudioFormat *>(sipSrc);
}


extern "C" {static void *copy_QAudioFormat(const void *, Py_ssize_t);}
static void *copy_QAudioFormat(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QAudioFormat(reinterpret_cast<const ::QAudioFormat *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QAudioFormat(sipSimpleWrapper *);}
static void dealloc_QAudioFormat(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QAudioFormat(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QAudioFormat(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QAudioFormat(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QAudioFormat *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QAudioFormat();

            return sipCpp;
        }
    }

    {
        const ::QAudioFormat* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QAudioFormat, &a0))
        {
            sipCpp = new ::QAudioFormat(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QAudioFormat[] = {
    {(void *)slot_QAudioFormat___eq__, eq_slot},
    {(void *)slot_QAudioFormat___ne__, ne_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QAudioFormat[] = {
    {sipName_bytesForDuration, meth_QAudioFormat_bytesForDuration, METH_VARARGS, doc_QAudioFormat_bytesForDuration},
    {sipName_bytesForFrames, meth_QAudioFormat_bytesForFrames, METH_VARARGS, doc_QAudioFormat_bytesForFrames},
    {sipName_bytesPerFrame, meth_QAudioFormat_bytesPerFrame, METH_VARARGS, doc_QAudioFormat_bytesPerFrame},
    {sipName_bytesPerSample, meth_QAudioFormat_bytesPerSample, METH_VARARGS, doc_QAudioFormat_bytesPerSample},
    {sipName_channelConfig, meth_QAudioFormat_channelConfig, METH_VARARGS, doc_QAudioFormat_channelConfig},
    {sipName_channelCount, meth_QAudioFormat_channelCount, METH_VARARGS, doc_QAudioFormat_channelCount},
    {sipName_channelOffset, meth_QAudioFormat_channelOffset, METH_VARARGS, doc_QAudioFormat_channelOffset},
    {sipName_defaultChannelConfigForChannelCount, meth_QAudioFormat_defaultChannelConfigForChannelCount, METH_VARARGS, doc_QAudioFormat_defaultChannelConfigForChannelCount},
    {sipName_durationForBytes, meth_QAudioFormat_durationForBytes, METH_VARARGS, doc_QAudioFormat_durationForBytes},
    {sipName_durationForFrames, meth_QAudioFormat_durationForFrames, METH_VARARGS, doc_QAudioFormat_durationForFrames},
    {sipName_framesForBytes, meth_QAudioFormat_framesForBytes, METH_VARARGS, doc_QAudioFormat_framesForBytes},
    {sipName_framesForDuration, meth_QAudioFormat_framesForDuration, METH_VARARGS, doc_QAudioFormat_framesForDuration},
    {sipName_isValid, meth_QAudioFormat_isValid, METH_VARARGS, doc_QAudioFormat_isValid},
    {sipName_normalizedSampleValue, meth_QAudioFormat_normalizedSampleValue, METH_VARARGS, doc_QAudioFormat_normalizedSampleValue},
    {sipName_sampleFormat, meth_QAudioFormat_sampleFormat, METH_VARARGS, doc_QAudioFormat_sampleFormat},
    {sipName_sampleRate, meth_QAudioFormat_sampleRate, METH_VARARGS, doc_QAudioFormat_sampleRate},
    {sipName_setChannelConfig, meth_QAudioFormat_setChannelConfig, METH_VARARGS, doc_QAudioFormat_setChannelConfig},
    {sipName_setChannelCount, meth_QAudioFormat_setChannelCount, METH_VARARGS, doc_QAudioFormat_setChannelCount},
    {sipName_setSampleFormat, meth_QAudioFormat_setSampleFormat, METH_VARARGS, doc_QAudioFormat_setSampleFormat},
    {sipName_setSampleRate, meth_QAudioFormat_setSampleRate, METH_VARARGS, doc_QAudioFormat_setSampleRate}
};


/* Define the enum members and ints to be added to this type. */
static sipIntInstanceDef intInstances_QAudioFormat[] = {
    {sipName_UnknownPosition, static_cast<int>(::QAudioFormat::UnknownPosition)},
    {sipName_FrontLeft, static_cast<int>(::QAudioFormat::FrontLeft)},
    {sipName_FrontRight, static_cast<int>(::QAudioFormat::FrontRight)},
    {sipName_FrontCenter, static_cast<int>(::QAudioFormat::FrontCenter)},
    {sipName_LFE, static_cast<int>(::QAudioFormat::LFE)},
    {sipName_BackLeft, static_cast<int>(::QAudioFormat::BackLeft)},
    {sipName_BackRight, static_cast<int>(::QAudioFormat::BackRight)},
    {sipName_FrontLeftOfCenter, static_cast<int>(::QAudioFormat::FrontLeftOfCenter)},
    {sipName_FrontRightOfCenter, static_cast<int>(::QAudioFormat::FrontRightOfCenter)},
    {sipName_BackCenter, static_cast<int>(::QAudioFormat::BackCenter)},
    {sipName_LFE2, static_cast<int>(::QAudioFormat::LFE2)},
    {sipName_SideLeft, static_cast<int>(::QAudioFormat::SideLeft)},
    {sipName_SideRight, static_cast<int>(::QAudioFormat::SideRight)},
    {sipName_TopFrontLeft, static_cast<int>(::QAudioFormat::TopFrontLeft)},
    {sipName_TopFrontRight, static_cast<int>(::QAudioFormat::TopFrontRight)},
    {sipName_TopFrontCenter, static_cast<int>(::QAudioFormat::TopFrontCenter)},
    {sipName_TopCenter, static_cast<int>(::QAudioFormat::TopCenter)},
    {sipName_TopBackLeft, static_cast<int>(::QAudioFormat::TopBackLeft)},
    {sipName_TopBackRight, static_cast<int>(::QAudioFormat::TopBackRight)},
    {sipName_TopSideLeft, static_cast<int>(::QAudioFormat::TopSideLeft)},
    {sipName_TopSideRight, static_cast<int>(::QAudioFormat::TopSideRight)},
    {sipName_TopBackCenter, static_cast<int>(::QAudioFormat::TopBackCenter)},
    {sipName_BottomFrontCenter, static_cast<int>(::QAudioFormat::BottomFrontCenter)},
    {sipName_BottomFrontLeft, static_cast<int>(::QAudioFormat::BottomFrontLeft)},
    {sipName_BottomFrontRight, static_cast<int>(::QAudioFormat::BottomFrontRight)},
    {sipName_ChannelConfigUnknown, static_cast<int>(::QAudioFormat::ChannelConfigUnknown)},
    {sipName_ChannelConfigMono, static_cast<int>(::QAudioFormat::ChannelConfigMono)},
    {sipName_ChannelConfigStereo, static_cast<int>(::QAudioFormat::ChannelConfigStereo)},
    {sipName_ChannelConfig2Dot1, static_cast<int>(::QAudioFormat::ChannelConfig2Dot1)},
    {sipName_ChannelConfigSurround5Dot0, static_cast<int>(::QAudioFormat::ChannelConfigSurround5Dot0)},
    {sipName_ChannelConfigSurround5Dot1, static_cast<int>(::QAudioFormat::ChannelConfigSurround5Dot1)},
    {sipName_ChannelConfigSurround7Dot0, static_cast<int>(::QAudioFormat::ChannelConfigSurround7Dot0)},
    {sipName_ChannelConfigSurround7Dot1, static_cast<int>(::QAudioFormat::ChannelConfigSurround7Dot1)},
    {sipName_ChannelConfig3Dot0, static_cast<int>(::QAudioFormat::ChannelConfig3Dot0)},
    {sipName_ChannelConfig3Dot1, static_cast<int>(::QAudioFormat::ChannelConfig3Dot1)},
    {sipName_Unknown, static_cast<int>(::QAudioFormat::Unknown)},
    {sipName_UInt8, static_cast<int>(::QAudioFormat::UInt8)},
    {sipName_Int16, static_cast<int>(::QAudioFormat::Int16)},
    {sipName_Int32, static_cast<int>(::QAudioFormat::Int32)},
    {sipName_Float, static_cast<int>(::QAudioFormat::Float)},
    {0, 0}
};

PyDoc_STRVAR(doc_QAudioFormat, "\1QAudioFormat()\n"
"QAudioFormat(a0: QAudioFormat)");


sipClassTypeDef sipTypeDef_QtMultimedia_QAudioFormat = {
    {
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QAudioFormat,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_QAudioFormat,
        {0, 0, 1},
        20, methods_QAudioFormat,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, intInstances_QAudioFormat, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QAudioFormat,
    -1,
    sipNameNr_PyQt6_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QAudioFormat,
    init_type_QAudioFormat,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QAudioFormat,
    assign_QAudioFormat,
    array_QAudioFormat,
    copy_QAudioFormat,
    release_QAudioFormat,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QAudioFormat,
    sizeof (::QAudioFormat),
};
