// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkExtrudeCell_gs.h"

const char *vtkExtrudeCell_gs =
"//VTK::System::Dec\n"
"\n"
"//VTK::PositionVC::Dec\n"
"//VTK::TCoord::Dec\n"
"\n"
"out vec3 normalVCGSOutput;\n"
"in vec4 vertexMCVSOutput[];\n"
"\n"
"layout(triangles) in;\n"
"layout(triangle_strip, max_vertices = 18) out;\n"
"\n"
"uniform mat4 MCVCMatrix;\n"
"uniform mat4 MCDCMatrix;\n"
"uniform mat3 normalMatrix;\n"
"uniform int PrimitiveIDOffset;\n"
"\n"
"uniform vec2 scalarRange;\n"
"uniform float extrusionFactor;\n"
"uniform int normalizeData;\n"
"uniform bool basisVisibility;\n"
"\n"
"uniform samplerBuffer textureExtrude;\n"
"\n"
"void main()\n"
"{\n"
"  mat4 VCMCMatrix = inverse(MCVCMatrix); //should be an uniform\n"
"  mat4 DCMCMatrix = inverse(MCDCMatrix); //should be an uniform\n"
"\n"
"  vec3 d1MC = (vertexMCVSOutput[1] - vertexMCVSOutput[0]).xyz;\n"
"  vec3 d2MC = (vertexMCVSOutput[2] - vertexMCVSOutput[0]).xyz;\n"
"  vec3 normalMC = normalize(cross(d1MC, d2MC));\n"
"\n"
"  // compute factor\n"
"  float factor = texelFetch(textureExtrude, gl_PrimitiveIDIn + PrimitiveIDOffset).r;\n"
"\n"
"  bool nullFactor = false;\n"
"\n"
"  // In case of normalizeData, we bound the value to [0, extrusionFactor]\n"
"  // 1% is added to avoid z-fighting\n"
"  if (normalizeData != 0)\n"
"    factor = 0.01 + clamp((factor - scalarRange.x) / (scalarRange.y - scalarRange.x), 0.0, 1.0);\n"
"\n"
"  factor = factor * extrusionFactor;\n"
"\n"
"  vec4 baseDC[3];\n"
"  baseDC[0] = MCDCMatrix * vertexMCVSOutput[0];\n"
"  baseDC[1] = MCDCMatrix * vertexMCVSOutput[1];\n"
"  baseDC[2] = MCDCMatrix * vertexMCVSOutput[2];\n"
"\n"
"  vec4 dirMC = VCMCMatrix*normalize(MCVCMatrix*vec4(normalMC, 0.0));\n"
"\n"
"  vec4 topDC[3];\n"
"  topDC[0] = baseDC[0] + MCDCMatrix*(dirMC) * factor;\n"
"  topDC[1] = baseDC[1] + MCDCMatrix*(dirMC) * factor;\n"
"  topDC[2] = baseDC[2] + MCDCMatrix*(dirMC) * factor;\n"
"\n"
"  // if factor is negative, we need to correct the normals\n"
"  float factorSign = sign(factor);\n"
"\n"
"  // in order to avoid z-fighting, we use a heuristic to consider that a factor is zero\n"
"  // if the extrusion is less than 1% of inscribed circle radius, no extrusion is applied\n"
"  float h = distance(topDC[0],baseDC[0]);\n"
"  float a = distance(baseDC[1],baseDC[0]);\n"
"  float b = distance(baseDC[2],baseDC[1]);\n"
"  float c = distance(baseDC[0],baseDC[2]);\n"
"  float s = 0.5*(a+b+c);\n"
"  float r = (s-a)*(s-b)*(s-c)/s;\n"
"  if (h < 0.01*r)\n"
"    factorSign = 0.0;\n"
"\n"
"  vec3 surfDir = normalMatrix * normalMC;\n"
"\n"
"  if (factorSign != 0.0)\n"
"    surfDir = -factorSign*surfDir;\n"
"  else\n"
"    surfDir = sign(extrusionFactor)*surfDir;\n"
"\n"
"  // create base of prism\n"
"  if (basisVisibility)\n"
"  {\n"
"    for (int i = 0; i < 3; i++)\n"
"    {\n"
"      normalVCGSOutput = surfDir;\n"
"      //VTK::PrimID::Impl\n"
"      //VTK::TCoord::Impl\n"
"      //VTK::PositionVC::Impl\n"
"      gl_Position = baseDC[i];\n"
"      EmitVertex();\n"
"    }\n"
"    EndPrimitive();\n"
"  }\n"
"\n"
"  if (factorSign == 0.0) return; // early exit\n"
"\n"
"  // create top of prism\n"
"  for (int i = 0; i < 3; i++)\n"
"  {\n"
"    normalVCGSOutput = -surfDir;\n"
"    //VTK::PrimID::Impl\n"
"    //VTK::TCoord::Impl\n"
"    //VTK::PositionVC::Impl\n"
"    gl_Position = topDC[i];\n"
"    EmitVertex();\n"
"  }\n"
"  EndPrimitive();\n"
"\n"
"  // create sides (quads) of prism\n"
"  for (int j = 0; j < 3; j++)\n"
"  {\n"
"    int i = j;\n"
"    int k = (j+1)%3;\n"
"\n"
"    vec3 sideNormal = normalMatrix * normalize(cross((DCMCMatrix*(baseDC[k] - baseDC[i])).xyz, normalMC));\n"
"\n"
"    normalVCGSOutput = sideNormal;\n"
"    //VTK::PrimID::Impl\n"
"    //VTK::TCoord::Impl\n"
"    //VTK::PositionVC::Impl\n"
"    gl_Position = topDC[i];\n"
"    EmitVertex();\n"
"\n"
"    normalVCGSOutput = sideNormal;\n"
"    //VTK::PrimID::Impl\n"
"    //VTK::TCoord::Impl\n"
"    //VTK::PositionVC::Impl\n"
"    gl_Position = baseDC[i];\n"
"    EmitVertex();\n"
"\n"
"    i = k;\n"
"\n"
"    normalVCGSOutput = sideNormal;\n"
"    //VTK::PrimID::Impl\n"
"    //VTK::TCoord::Impl\n"
"    //VTK::PositionVC::Impl\n"
"    gl_Position = topDC[i];\n"
"    EmitVertex();\n"
"\n"
"    normalVCGSOutput = sideNormal;\n"
"    //VTK::PrimID::Impl\n"
"    //VTK::TCoord::Impl\n"
"    //VTK::PositionVC::Impl\n"
"    gl_Position = baseDC[i];\n"
"    EmitVertex();\n"
"\n"
"    EndPrimitive();\n"
"  }\n"
"}\n"
"";
