
/// A convenience constructor for a [`Bytes`] that automatically
/// implements a fallback. Provide 1 to 16 characters.
#[macro_export]
macro_rules! bytes {
($b00:expr) => ($crate::Bytes::new([$b00 as u8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], 1, |c| $b00 as u8 == c));
($b00:expr, $b01:expr) => ($crate::Bytes::new([$b00 as u8, $b01 as u8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], 2, |c| $b00 as u8 == c || $b01 as u8 == c));
($b00:expr, $b01:expr, $b02:expr) => ($crate::Bytes::new([$b00 as u8, $b01 as u8, $b02 as u8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], 3, |c| $b00 as u8 == c || $b01 as u8 == c || $b02 as u8 == c));
($b00:expr, $b01:expr, $b02:expr, $b03:expr) => ($crate::Bytes::new([$b00 as u8, $b01 as u8, $b02 as u8, $b03 as u8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], 4, |c| $b00 as u8 == c || $b01 as u8 == c || $b02 as u8 == c || $b03 as u8 == c));
($b00:expr, $b01:expr, $b02:expr, $b03:expr, $b04:expr) => ($crate::Bytes::new([$b00 as u8, $b01 as u8, $b02 as u8, $b03 as u8, $b04 as u8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], 5, |c| $b00 as u8 == c || $b01 as u8 == c || $b02 as u8 == c || $b03 as u8 == c || $b04 as u8 == c));
($b00:expr, $b01:expr, $b02:expr, $b03:expr, $b04:expr, $b05:expr) => ($crate::Bytes::new([$b00 as u8, $b01 as u8, $b02 as u8, $b03 as u8, $b04 as u8, $b05 as u8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], 6, |c| $b00 as u8 == c || $b01 as u8 == c || $b02 as u8 == c || $b03 as u8 == c || $b04 as u8 == c || $b05 as u8 == c));
($b00:expr, $b01:expr, $b02:expr, $b03:expr, $b04:expr, $b05:expr, $b06:expr) => ($crate::Bytes::new([$b00 as u8, $b01 as u8, $b02 as u8, $b03 as u8, $b04 as u8, $b05 as u8, $b06 as u8, 0, 0, 0, 0, 0, 0, 0, 0, 0], 7, |c| $b00 as u8 == c || $b01 as u8 == c || $b02 as u8 == c || $b03 as u8 == c || $b04 as u8 == c || $b05 as u8 == c || $b06 as u8 == c));
($b00:expr, $b01:expr, $b02:expr, $b03:expr, $b04:expr, $b05:expr, $b06:expr, $b07:expr) => ($crate::Bytes::new([$b00 as u8, $b01 as u8, $b02 as u8, $b03 as u8, $b04 as u8, $b05 as u8, $b06 as u8, $b07 as u8, 0, 0, 0, 0, 0, 0, 0, 0], 8, |c| $b00 as u8 == c || $b01 as u8 == c || $b02 as u8 == c || $b03 as u8 == c || $b04 as u8 == c || $b05 as u8 == c || $b06 as u8 == c || $b07 as u8 == c));
($b00:expr, $b01:expr, $b02:expr, $b03:expr, $b04:expr, $b05:expr, $b06:expr, $b07:expr, $b08:expr) => ($crate::Bytes::new([$b00 as u8, $b01 as u8, $b02 as u8, $b03 as u8, $b04 as u8, $b05 as u8, $b06 as u8, $b07 as u8, $b08 as u8, 0, 0, 0, 0, 0, 0, 0], 9, |c| $b00 as u8 == c || $b01 as u8 == c || $b02 as u8 == c || $b03 as u8 == c || $b04 as u8 == c || $b05 as u8 == c || $b06 as u8 == c || $b07 as u8 == c || $b08 as u8 == c));
($b00:expr, $b01:expr, $b02:expr, $b03:expr, $b04:expr, $b05:expr, $b06:expr, $b07:expr, $b08:expr, $b09:expr) => ($crate::Bytes::new([$b00 as u8, $b01 as u8, $b02 as u8, $b03 as u8, $b04 as u8, $b05 as u8, $b06 as u8, $b07 as u8, $b08 as u8, $b09 as u8, 0, 0, 0, 0, 0, 0], 10, |c| $b00 as u8 == c || $b01 as u8 == c || $b02 as u8 == c || $b03 as u8 == c || $b04 as u8 == c || $b05 as u8 == c || $b06 as u8 == c || $b07 as u8 == c || $b08 as u8 == c || $b09 as u8 == c));
($b00:expr, $b01:expr, $b02:expr, $b03:expr, $b04:expr, $b05:expr, $b06:expr, $b07:expr, $b08:expr, $b09:expr, $b10:expr) => ($crate::Bytes::new([$b00 as u8, $b01 as u8, $b02 as u8, $b03 as u8, $b04 as u8, $b05 as u8, $b06 as u8, $b07 as u8, $b08 as u8, $b09 as u8, $b10 as u8, 0, 0, 0, 0, 0], 11, |c| $b00 as u8 == c || $b01 as u8 == c || $b02 as u8 == c || $b03 as u8 == c || $b04 as u8 == c || $b05 as u8 == c || $b06 as u8 == c || $b07 as u8 == c || $b08 as u8 == c || $b09 as u8 == c || $b10 as u8 == c));
($b00:expr, $b01:expr, $b02:expr, $b03:expr, $b04:expr, $b05:expr, $b06:expr, $b07:expr, $b08:expr, $b09:expr, $b10:expr, $b11:expr) => ($crate::Bytes::new([$b00 as u8, $b01 as u8, $b02 as u8, $b03 as u8, $b04 as u8, $b05 as u8, $b06 as u8, $b07 as u8, $b08 as u8, $b09 as u8, $b10 as u8, $b11 as u8, 0, 0, 0, 0], 12, |c| $b00 as u8 == c || $b01 as u8 == c || $b02 as u8 == c || $b03 as u8 == c || $b04 as u8 == c || $b05 as u8 == c || $b06 as u8 == c || $b07 as u8 == c || $b08 as u8 == c || $b09 as u8 == c || $b10 as u8 == c || $b11 as u8 == c));
($b00:expr, $b01:expr, $b02:expr, $b03:expr, $b04:expr, $b05:expr, $b06:expr, $b07:expr, $b08:expr, $b09:expr, $b10:expr, $b11:expr, $b12:expr) => ($crate::Bytes::new([$b00 as u8, $b01 as u8, $b02 as u8, $b03 as u8, $b04 as u8, $b05 as u8, $b06 as u8, $b07 as u8, $b08 as u8, $b09 as u8, $b10 as u8, $b11 as u8, $b12 as u8, 0, 0, 0], 13, |c| $b00 as u8 == c || $b01 as u8 == c || $b02 as u8 == c || $b03 as u8 == c || $b04 as u8 == c || $b05 as u8 == c || $b06 as u8 == c || $b07 as u8 == c || $b08 as u8 == c || $b09 as u8 == c || $b10 as u8 == c || $b11 as u8 == c || $b12 as u8 == c));
($b00:expr, $b01:expr, $b02:expr, $b03:expr, $b04:expr, $b05:expr, $b06:expr, $b07:expr, $b08:expr, $b09:expr, $b10:expr, $b11:expr, $b12:expr, $b13:expr) => ($crate::Bytes::new([$b00 as u8, $b01 as u8, $b02 as u8, $b03 as u8, $b04 as u8, $b05 as u8, $b06 as u8, $b07 as u8, $b08 as u8, $b09 as u8, $b10 as u8, $b11 as u8, $b12 as u8, $b13 as u8, 0, 0], 14, |c| $b00 as u8 == c || $b01 as u8 == c || $b02 as u8 == c || $b03 as u8 == c || $b04 as u8 == c || $b05 as u8 == c || $b06 as u8 == c || $b07 as u8 == c || $b08 as u8 == c || $b09 as u8 == c || $b10 as u8 == c || $b11 as u8 == c || $b12 as u8 == c || $b13 as u8 == c));
($b00:expr, $b01:expr, $b02:expr, $b03:expr, $b04:expr, $b05:expr, $b06:expr, $b07:expr, $b08:expr, $b09:expr, $b10:expr, $b11:expr, $b12:expr, $b13:expr, $b14:expr) => ($crate::Bytes::new([$b00 as u8, $b01 as u8, $b02 as u8, $b03 as u8, $b04 as u8, $b05 as u8, $b06 as u8, $b07 as u8, $b08 as u8, $b09 as u8, $b10 as u8, $b11 as u8, $b12 as u8, $b13 as u8, $b14 as u8, 0], 15, |c| $b00 as u8 == c || $b01 as u8 == c || $b02 as u8 == c || $b03 as u8 == c || $b04 as u8 == c || $b05 as u8 == c || $b06 as u8 == c || $b07 as u8 == c || $b08 as u8 == c || $b09 as u8 == c || $b10 as u8 == c || $b11 as u8 == c || $b12 as u8 == c || $b13 as u8 == c || $b14 as u8 == c));
($b00:expr, $b01:expr, $b02:expr, $b03:expr, $b04:expr, $b05:expr, $b06:expr, $b07:expr, $b08:expr, $b09:expr, $b10:expr, $b11:expr, $b12:expr, $b13:expr, $b14:expr, $b15:expr) => ($crate::Bytes::new([$b00 as u8, $b01 as u8, $b02 as u8, $b03 as u8, $b04 as u8, $b05 as u8, $b06 as u8, $b07 as u8, $b08 as u8, $b09 as u8, $b10 as u8, $b11 as u8, $b12 as u8, $b13 as u8, $b14 as u8, $b15 as u8], 16, |c| $b00 as u8 == c || $b01 as u8 == c || $b02 as u8 == c || $b03 as u8 == c || $b04 as u8 == c || $b05 as u8 == c || $b06 as u8 == c || $b07 as u8 == c || $b08 as u8 == c || $b09 as u8 == c || $b10 as u8 == c || $b11 as u8 == c || $b12 as u8 == c || $b13 as u8 == c || $b14 as u8 == c || $b15 as u8 == c));
}

/// A convenience constructor for an [`AsciiChars`] that automatically
/// implements a fallback. Provide 1 to 16 characters.
#[macro_export]
macro_rules! ascii_chars {
($b00:expr) => ($crate::AsciiChars::new([$b00 as u8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], 1, |c| $b00 as u8 == c));
($b00:expr, $b01:expr) => ($crate::AsciiChars::new([$b00 as u8, $b01 as u8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], 2, |c| $b00 as u8 == c || $b01 as u8 == c));
($b00:expr, $b01:expr, $b02:expr) => ($crate::AsciiChars::new([$b00 as u8, $b01 as u8, $b02 as u8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], 3, |c| $b00 as u8 == c || $b01 as u8 == c || $b02 as u8 == c));
($b00:expr, $b01:expr, $b02:expr, $b03:expr) => ($crate::AsciiChars::new([$b00 as u8, $b01 as u8, $b02 as u8, $b03 as u8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], 4, |c| $b00 as u8 == c || $b01 as u8 == c || $b02 as u8 == c || $b03 as u8 == c));
($b00:expr, $b01:expr, $b02:expr, $b03:expr, $b04:expr) => ($crate::AsciiChars::new([$b00 as u8, $b01 as u8, $b02 as u8, $b03 as u8, $b04 as u8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], 5, |c| $b00 as u8 == c || $b01 as u8 == c || $b02 as u8 == c || $b03 as u8 == c || $b04 as u8 == c));
($b00:expr, $b01:expr, $b02:expr, $b03:expr, $b04:expr, $b05:expr) => ($crate::AsciiChars::new([$b00 as u8, $b01 as u8, $b02 as u8, $b03 as u8, $b04 as u8, $b05 as u8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], 6, |c| $b00 as u8 == c || $b01 as u8 == c || $b02 as u8 == c || $b03 as u8 == c || $b04 as u8 == c || $b05 as u8 == c));
($b00:expr, $b01:expr, $b02:expr, $b03:expr, $b04:expr, $b05:expr, $b06:expr) => ($crate::AsciiChars::new([$b00 as u8, $b01 as u8, $b02 as u8, $b03 as u8, $b04 as u8, $b05 as u8, $b06 as u8, 0, 0, 0, 0, 0, 0, 0, 0, 0], 7, |c| $b00 as u8 == c || $b01 as u8 == c || $b02 as u8 == c || $b03 as u8 == c || $b04 as u8 == c || $b05 as u8 == c || $b06 as u8 == c));
($b00:expr, $b01:expr, $b02:expr, $b03:expr, $b04:expr, $b05:expr, $b06:expr, $b07:expr) => ($crate::AsciiChars::new([$b00 as u8, $b01 as u8, $b02 as u8, $b03 as u8, $b04 as u8, $b05 as u8, $b06 as u8, $b07 as u8, 0, 0, 0, 0, 0, 0, 0, 0], 8, |c| $b00 as u8 == c || $b01 as u8 == c || $b02 as u8 == c || $b03 as u8 == c || $b04 as u8 == c || $b05 as u8 == c || $b06 as u8 == c || $b07 as u8 == c));
($b00:expr, $b01:expr, $b02:expr, $b03:expr, $b04:expr, $b05:expr, $b06:expr, $b07:expr, $b08:expr) => ($crate::AsciiChars::new([$b00 as u8, $b01 as u8, $b02 as u8, $b03 as u8, $b04 as u8, $b05 as u8, $b06 as u8, $b07 as u8, $b08 as u8, 0, 0, 0, 0, 0, 0, 0], 9, |c| $b00 as u8 == c || $b01 as u8 == c || $b02 as u8 == c || $b03 as u8 == c || $b04 as u8 == c || $b05 as u8 == c || $b06 as u8 == c || $b07 as u8 == c || $b08 as u8 == c));
($b00:expr, $b01:expr, $b02:expr, $b03:expr, $b04:expr, $b05:expr, $b06:expr, $b07:expr, $b08:expr, $b09:expr) => ($crate::AsciiChars::new([$b00 as u8, $b01 as u8, $b02 as u8, $b03 as u8, $b04 as u8, $b05 as u8, $b06 as u8, $b07 as u8, $b08 as u8, $b09 as u8, 0, 0, 0, 0, 0, 0], 10, |c| $b00 as u8 == c || $b01 as u8 == c || $b02 as u8 == c || $b03 as u8 == c || $b04 as u8 == c || $b05 as u8 == c || $b06 as u8 == c || $b07 as u8 == c || $b08 as u8 == c || $b09 as u8 == c));
($b00:expr, $b01:expr, $b02:expr, $b03:expr, $b04:expr, $b05:expr, $b06:expr, $b07:expr, $b08:expr, $b09:expr, $b10:expr) => ($crate::AsciiChars::new([$b00 as u8, $b01 as u8, $b02 as u8, $b03 as u8, $b04 as u8, $b05 as u8, $b06 as u8, $b07 as u8, $b08 as u8, $b09 as u8, $b10 as u8, 0, 0, 0, 0, 0], 11, |c| $b00 as u8 == c || $b01 as u8 == c || $b02 as u8 == c || $b03 as u8 == c || $b04 as u8 == c || $b05 as u8 == c || $b06 as u8 == c || $b07 as u8 == c || $b08 as u8 == c || $b09 as u8 == c || $b10 as u8 == c));
($b00:expr, $b01:expr, $b02:expr, $b03:expr, $b04:expr, $b05:expr, $b06:expr, $b07:expr, $b08:expr, $b09:expr, $b10:expr, $b11:expr) => ($crate::AsciiChars::new([$b00 as u8, $b01 as u8, $b02 as u8, $b03 as u8, $b04 as u8, $b05 as u8, $b06 as u8, $b07 as u8, $b08 as u8, $b09 as u8, $b10 as u8, $b11 as u8, 0, 0, 0, 0], 12, |c| $b00 as u8 == c || $b01 as u8 == c || $b02 as u8 == c || $b03 as u8 == c || $b04 as u8 == c || $b05 as u8 == c || $b06 as u8 == c || $b07 as u8 == c || $b08 as u8 == c || $b09 as u8 == c || $b10 as u8 == c || $b11 as u8 == c));
($b00:expr, $b01:expr, $b02:expr, $b03:expr, $b04:expr, $b05:expr, $b06:expr, $b07:expr, $b08:expr, $b09:expr, $b10:expr, $b11:expr, $b12:expr) => ($crate::AsciiChars::new([$b00 as u8, $b01 as u8, $b02 as u8, $b03 as u8, $b04 as u8, $b05 as u8, $b06 as u8, $b07 as u8, $b08 as u8, $b09 as u8, $b10 as u8, $b11 as u8, $b12 as u8, 0, 0, 0], 13, |c| $b00 as u8 == c || $b01 as u8 == c || $b02 as u8 == c || $b03 as u8 == c || $b04 as u8 == c || $b05 as u8 == c || $b06 as u8 == c || $b07 as u8 == c || $b08 as u8 == c || $b09 as u8 == c || $b10 as u8 == c || $b11 as u8 == c || $b12 as u8 == c));
($b00:expr, $b01:expr, $b02:expr, $b03:expr, $b04:expr, $b05:expr, $b06:expr, $b07:expr, $b08:expr, $b09:expr, $b10:expr, $b11:expr, $b12:expr, $b13:expr) => ($crate::AsciiChars::new([$b00 as u8, $b01 as u8, $b02 as u8, $b03 as u8, $b04 as u8, $b05 as u8, $b06 as u8, $b07 as u8, $b08 as u8, $b09 as u8, $b10 as u8, $b11 as u8, $b12 as u8, $b13 as u8, 0, 0], 14, |c| $b00 as u8 == c || $b01 as u8 == c || $b02 as u8 == c || $b03 as u8 == c || $b04 as u8 == c || $b05 as u8 == c || $b06 as u8 == c || $b07 as u8 == c || $b08 as u8 == c || $b09 as u8 == c || $b10 as u8 == c || $b11 as u8 == c || $b12 as u8 == c || $b13 as u8 == c));
($b00:expr, $b01:expr, $b02:expr, $b03:expr, $b04:expr, $b05:expr, $b06:expr, $b07:expr, $b08:expr, $b09:expr, $b10:expr, $b11:expr, $b12:expr, $b13:expr, $b14:expr) => ($crate::AsciiChars::new([$b00 as u8, $b01 as u8, $b02 as u8, $b03 as u8, $b04 as u8, $b05 as u8, $b06 as u8, $b07 as u8, $b08 as u8, $b09 as u8, $b10 as u8, $b11 as u8, $b12 as u8, $b13 as u8, $b14 as u8, 0], 15, |c| $b00 as u8 == c || $b01 as u8 == c || $b02 as u8 == c || $b03 as u8 == c || $b04 as u8 == c || $b05 as u8 == c || $b06 as u8 == c || $b07 as u8 == c || $b08 as u8 == c || $b09 as u8 == c || $b10 as u8 == c || $b11 as u8 == c || $b12 as u8 == c || $b13 as u8 == c || $b14 as u8 == c));
($b00:expr, $b01:expr, $b02:expr, $b03:expr, $b04:expr, $b05:expr, $b06:expr, $b07:expr, $b08:expr, $b09:expr, $b10:expr, $b11:expr, $b12:expr, $b13:expr, $b14:expr, $b15:expr) => ($crate::AsciiChars::new([$b00 as u8, $b01 as u8, $b02 as u8, $b03 as u8, $b04 as u8, $b05 as u8, $b06 as u8, $b07 as u8, $b08 as u8, $b09 as u8, $b10 as u8, $b11 as u8, $b12 as u8, $b13 as u8, $b14 as u8, $b15 as u8], 16, |c| $b00 as u8 == c || $b01 as u8 == c || $b02 as u8 == c || $b03 as u8 == c || $b04 as u8 == c || $b05 as u8 == c || $b06 as u8 == c || $b07 as u8 == c || $b08 as u8 == c || $b09 as u8 == c || $b10 as u8 == c || $b11 as u8 == c || $b12 as u8 == c || $b13 as u8 == c || $b14 as u8 == c || $b15 as u8 == c));
}
