// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
)

func CopyOrigResourceMetricsSlice(dest, src []*otlpmetrics.ResourceMetrics) []*otlpmetrics.ResourceMetrics {
	var newDest []*otlpmetrics.ResourceMetrics
	if cap(dest) < len(src) {
		newDest = make([]*otlpmetrics.ResourceMetrics, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigResourceMetrics()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteOrigResourceMetrics(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigResourceMetrics()
		}
	}
	for i := range src {
		CopyOrigResourceMetrics(newDest[i], src[i])
	}
	return newDest
}

func GenerateOrigTestResourceMetricsSlice() []*otlpmetrics.ResourceMetrics {
	orig := make([]*otlpmetrics.ResourceMetrics, 5)
	orig[0] = NewOrigResourceMetrics()
	orig[1] = GenTestOrigResourceMetrics()
	orig[2] = NewOrigResourceMetrics()
	orig[3] = GenTestOrigResourceMetrics()
	orig[4] = NewOrigResourceMetrics()
	return orig
}
