
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kguiaddons_python.h"

// main header
#include "kdatevalidator_wrapper.h"

// Wrappers providing overrides
#include "ksystemclipboard_wrapper.h"

// Argument includes
#include <QString>
#include <qcoreevent.h>
#include <qdatetime.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qvalidator.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KDateValidator_Type = nullptr;
static PyTypeObject *Sbk_KDateValidator_TypeF(void)
{
    return _Sbk_KDateValidator_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KDateValidatorWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KDateValidatorWrapper::KDateValidatorWrapper(::QObject * parent) : KDateValidator(parent)
{
}

void KDateValidatorWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateValidator_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KSystemClipboardWrapper::sbk_o_childEvent("KDateValidator", funcName, gil, pyOverride, event);
}

void KDateValidatorWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateValidator_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KSystemClipboardWrapper::sbk_o_connectNotify("KDateValidator", funcName, gil, pyOverride, signal);
}

void KDateValidatorWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateValidator_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KSystemClipboardWrapper::sbk_o_customEvent("KDateValidator", funcName, gil, pyOverride, event);
}

void KDateValidatorWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateValidator_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KSystemClipboardWrapper::sbk_o_connectNotify("KDateValidator", funcName, gil, pyOverride, signal);
}

bool KDateValidatorWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateValidator_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return KSystemClipboardWrapper::sbk_o_event("KDateValidator", funcName, gil, pyOverride, event);
}

bool KDateValidatorWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateValidator_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KSystemClipboardWrapper::sbk_o_eventFilter("KDateValidator", funcName, gil, pyOverride, watched, event);
}

void KDateValidatorWrapper::fixup(::QString & input) const
{
    static const char *funcName = "fixup";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateValidator_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::KDateValidator::fixup(input);
    }
    sbk_o_fixup("KDateValidator", funcName, gil, pyOverride, input);
}

void KDateValidatorWrapper::sbk_o_fixup(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QString & input)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &input)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }

    // Begin code injection
    // TEMPLATE - return_QString_native - START
    if (Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], pyResult.object()))
        Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], pyResult.object(), &(input));
    else
        qWarning("KDateValidator::fixup: Argument is not convertible to unicode.");
    // TEMPLATE - return_QString_native - END
    // End of code injection

}

void KDateValidatorWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateValidator_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KSystemClipboardWrapper::sbk_o_timerEvent("KDateValidator", funcName, gil, pyOverride, event);
}

::QValidator::State KDateValidatorWrapper::validate(::QString & text, int & e) const
{
    static const char *funcName = "validate";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateValidator_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::KDateValidator::validate(text, e);
    }
    return sbk_o_validate("KDateValidator", funcName, gil, pyOverride, text, e);
}

::QValidator::State KDateValidatorWrapper::sbk_o_validate(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QString & text, int & e)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(Ni)",
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &text),
        e
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return QValidator::Invalid;
    }
    // Begin code injection
    // TEMPLATE - validator_conversionrule - START
    QValidator::State cppResult;

    if (PySequence_Check(pyResult.object())) {
        Shiboken::AutoDecRef seq(PySequence_Fast(pyResult.object(), 0));
        const Py_ssize_t size = PySequence_Size(seq.object());

        if (size > 1) {
            Shiboken::AutoDecRef _obj1(PySequence_GetItem(seq.object(), 1));
            if (Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], _obj1))
                Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], _obj1, &(text));
            else
                qWarning("KDateValidator::validate: Second tuple element is not convertible to unicode.");
        }

        if (size > 2) {
            Shiboken::AutoDecRef _obj2(PySequence_GetItem(seq.object(), 2));
            if (Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), _obj2))
                Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), _obj2, &(e));
            else
                qWarning("KDateValidator::validate: Second tuple element is not convertible to int.");
        }
        Shiboken::AutoDecRef _sobj(PySequence_GetItem(seq.object(), 0));

        pyResult.reset(_sobj);
        Py_INCREF(pyResult.object()); // we need to incref, because "pyResult.object() = ..." will decref the tuple and the tuple will be decrefed again at the end of this scope.
    }

    // check return value
    if (Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QValidator_State_IDX])))->converter, pyResult.object())) {
        Shiboken::Conversions::pythonToCppCopy(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QValidator_State_IDX])))->converter, pyResult.object(), &(cppResult));
    } else {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.",
                     "QValidator.validate",
                     "PySide6.QtGui.QValidator.State, (PySide6.QtGui.QValidator.State,), (PySide6.QtGui.QValidator.State, unicode) or (PySide6.QtGui.QValidator.State, unicode, int)",
                     Py_TYPE(pyResult)->tp_name);
        return QValidator::State();
    }
    // TEMPLATE - validator_conversionrule - END
    // End of code injection


    return cppResult;
}

const QMetaObject *KDateValidatorWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KDateValidator::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KDateValidatorWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KDateValidator::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KDateValidatorWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KDateValidatorWrapper *>(this));
    }
    return KDateValidator::qt_metacast(_clname);
}

KDateValidatorWrapper::~KDateValidatorWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KDateValidator_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KDateValidator_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KDateValidator >()))
        return -1;

    KDateValidatorWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KDateValidator", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KDateValidator::KDateValidator(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // KDateValidator(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KDateValidator(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKGuiAddonsTypeStructs[SBK_KDateValidator_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKGuiAddonsTypeStructs[SBK_KDateValidator_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKGuiAddonsTypeStructs[SBK_KDateValidator_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KDateValidator(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KDateValidatorWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KDateValidatorWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KDateValidator >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKGuiAddonsTypeStructs[SBK_KDateValidator_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKGuiAddonsTypeStructs[SBK_KDateValidator_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KDateValidatorFunc_date(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateValidator *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KDateValidator_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "date", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KDateValidator::date(QString,QDate&)const->QValidator::State
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDate_IDX]), (pyArgs[1])))) {
        overloadId = 0; // date(QString,QDate&)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "date", errInfo, SbkKGuiAddonsTypeStructs[SBK_KDateValidator_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QDate cppArg1_local;
        ::QDate *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1].isValue())
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (Shiboken::Errors::occurred() == nullptr) {
            // date(QString,QDate&)const
            QValidator::State cppResult = const_cast<const ::KDateValidator *>(cppSelf)->date(cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QValidator_State_IDX])))->converter, &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDateValidatorFunc_fixup(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateValidator *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KDateValidator_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QValidator::fixup(QString&)const
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // fixup(QString&)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "fixup", errInfo, SbkKGuiAddonsTypeStructs[SBK_KDateValidator_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // fixup(QString&)const
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::KDateValidator *>(cppSelf)->::KDateValidator::fixup(cppArg0)
                : const_cast<const ::KDateValidator *>(cppSelf)->fixup(cppArg0);
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qstring-return)]
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppArg0);
            // END of custom code block [file: ../glue/qtcore.cpp (qstring-return)]
            // ========================================================================
            // End of code injection

        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDateValidatorFunc_validate(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateValidator *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KDateValidator_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "validate", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QValidator::validate(QString&,int&)const->PyObject
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // validate(QString&,int&)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "validate", errInfo, SbkKGuiAddonsTypeStructs[SBK_KDateValidator_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // validate(QString&,int&)const
            // Begin code injection
            // TEMPLATE - return_tuple_QValidator_QString_int - START
            ::QValidator::State retval_ = ::QValidator::State((Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self)) ? cppSelf->::KDateValidator::validate(cppArg0, cppArg1) : cppSelf->validate(cppArg0, cppArg1)));
            pyResult = PyTuple_New(3);
            PyTuple_SetItem(pyResult, 0, Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QValidator_State_IDX])))->converter, &retval_));
            PyTuple_SetItem(pyResult, 1, Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppArg0));
            PyTuple_SetItem(pyResult, 2, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppArg1));
            // TEMPLATE - return_tuple_QValidator_QString_int - END
            // End of code injection

        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KDateValidator_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KDateValidator_methods[] = {
    {"date", reinterpret_cast<PyCFunction>(Sbk_KDateValidatorFunc_date), METH_VARARGS, nullptr},
    {"fixup", reinterpret_cast<PyCFunction>(Sbk_KDateValidatorFunc_fixup), METH_O, nullptr},
    {"validate", reinterpret_cast<PyCFunction>(Sbk_KDateValidatorFunc_validate), METH_VARARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KDateValidator_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KDateValidator *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KDateValidator_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KDateValidatorWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KDateValidator_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KDateValidator_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KDateValidator_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KDateValidator_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KDateValidator_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KDateValidator_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KDateValidator_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KDateValidator_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KDateValidator_spec = {
    "1:KGuiAddons.KDateValidator",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KDateValidator_slots
};

} //extern "C"

static void *Sbk_KDateValidator_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KDateValidator *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KDateValidator_PythonToCpp_KDateValidator_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KDateValidator_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KDateValidator_PythonToCpp_KDateValidator_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KDateValidator_TypeF()))
        return KDateValidator_PythonToCpp_KDateValidator_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KDateValidator_PTR_CppToPython_KDateValidator(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KDateValidator *>(const_cast<void *>(cppIn)), Sbk_KDateValidator_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KDateValidator_SignatureStrings[] = {
    "KGuiAddons.KDateValidator(self,parent:PySide6.QtCore.QObject=nullptr)",
    "KGuiAddons.KDateValidator.date(self,text:QString,date:PySide6.QtCore.QDate)->PySide6.QtGui.QValidator.State",
    "KGuiAddons.KDateValidator.fixup(self,input:QString)->QString",
    "KGuiAddons.KDateValidator.validate(self,text:QString,e:int)->PyObject",
    nullptr}; // Sentinel
#else
static constexpr size_t KDateValidator_SignatureByteSize = 157;
static constexpr uint8_t KDateValidator_SignatureBytes[157] = {
    0x78, 0xda, 0x7d, 0x8f, 0x31, 0x0b, 0xc2, 0x30, 0x10, 0x85, 0xf7, 0xfe, 0x12, 0x0b, 0x35, 0xa3,
    0x43, 0x40, 0x41, 0x14, 0x1c, 0x32, 0xd4, 0x10, 0x70, 0x8f, 0xe6, 0x2a, 0x27, 0x21, 0x09, 0xe9,
    0x45, 0xea, 0xbf, 0x37, 0x35, 0x62, 0x07, 0xb5, 0xcb, 0xf1, 0x78, 0xdc, 0xfb, 0xde, 0x9d, 0x38,
    0x24, 0xdc, 0x1a, 0xe3, 0x5d, 0xcf, 0xc4, 0x5e, 0x13, 0x9c, 0xb4, 0x45, 0xa3, 0xc9, 0xc7, 0x45,
    0x0f, 0xb6, 0x6b, 0x82, 0x8e, 0xe0, 0x88, 0x1f, 0x1f, 0x0a, 0x0d, 0xac, 0x98, 0xa4, 0x9d, 0x8f,
    0xc0, 0x64, 0x7b, 0xbe, 0xc1, 0x85, 0xd6, 0x2e, 0x59, 0x1b, 0x28, 0xd6, 0x95, 0xf8, 0x47, 0x61,
    0x79, 0x42, 0x41, 0x11, 0x0c, 0xc4, 0xa5, 0xa2, 0x88, 0xee, 0xda, 0x8c, 0xf6, 0x17, 0x75, 0x4c,
    0xd6, 0xcb, 0xcd, 0x64, 0x67, 0x2a, 0x93, 0x13, 0x4b, 0x51, 0x5e, 0x98, 0xe9, 0xea, 0x70, 0x48,
    0xa1, 0x94, 0xa1, 0x0b, 0xe9, 0xd3, 0x96, 0x99, 0x6f, 0x35, 0x13, 0xbe, 0x17, 0xf5, 0xeb, 0x58,
    0xe0, 0xe8, 0xe8, 0x75, 0x58, 0xf9, 0xbb, 0x7a, 0x02, 0xe1, 0x07, 0x6f, 0xd3
};
#endif

PyTypeObject *init_KDateValidator(PyObject *module)
{
    if (SbkKGuiAddonsTypeStructs[SBK_KDateValidator_IDX].type != nullptr)
        return SbkKGuiAddonsTypeStructs[SBK_KDateValidator_IDX].type;

    Shiboken::AutoDecRef Sbk_KDateValidator_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QValidator_IDX]))));

    _Sbk_KDateValidator_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KDateValidator",
        "KDateValidator*",
        &Sbk_KDateValidator_spec,
        &Shiboken::callCppDestructor< KDateValidator >,
        Sbk_KDateValidator_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KDateValidator_Type; // references _Sbk_KDateValidator_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KDateValidator_SignatureStrings);
#else
    InitSignatureBytes(pyType, KDateValidator_SignatureBytes, KDateValidator_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KDateValidator_PropertyStrings);
    SbkKGuiAddonsTypeStructs[SBK_KDateValidator_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KDateValidator_PythonToCpp_KDateValidator_PTR,
        is_KDateValidator_PythonToCpp_KDateValidator_PTR_Convertible,
        KDateValidator_PTR_CppToPython_KDateValidator);

    Shiboken::Conversions::registerConverterName(converter, "KDateValidator");
    Shiboken::Conversions::registerConverterName(converter, "KDateValidator*");
    Shiboken::Conversions::registerConverterName(converter, "KDateValidator&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KDateValidator).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KDateValidatorWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KDateValidator_TypeF(), &Sbk_KDateValidator_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KDateValidator::staticMetaObject, sizeof(KDateValidatorWrapper));

    return pyType;
}
