{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Data type for holding variation data. Registered OpenType
-- variation-axis tags are listed in
-- <https://docs.microsoft.com/en-us/typography/opentype/spec/dvaraxisreg OpenType Axis Tag Registry>.
-- 
-- /Since: 1.4.2/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.HarfBuzz.Structs.VariationT
    ( 

-- * Exported types
    VariationT(..)                          ,
    newZeroVariationT                       ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveVariationTMethod                 ,
#endif



 -- * Properties


-- ** tag #attr:tag#
-- | The @/hb_tag_t/@ tag of the variation-axis name

    getVariationTTag                        ,
    setVariationTTag                        ,
#if defined(ENABLE_OVERLOADING)
    variationT_tag                          ,
#endif


-- ** value #attr:value#
-- | The value of the variation axis

    getVariationTValue                      ,
    setVariationTValue                      ,
#if defined(ENABLE_OVERLOADING)
    variationT_value                        ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype VariationT = VariationT (SP.ManagedPtr VariationT)
    deriving (Eq)

instance SP.ManagedPtrNewtype VariationT where
    toManagedPtr (VariationT p) = p

instance BoxedPtr VariationT where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 8 >=> B.ManagedPtr.wrapPtr VariationT)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr VariationT where
    boxedPtrCalloc = callocBytes 8


-- | Construct a t'VariationT' struct initialized to zero.
newZeroVariationT :: MonadIO m => m VariationT
newZeroVariationT = liftIO $ boxedPtrCalloc >>= wrapPtr VariationT

instance tag ~ 'AttrSet => Constructible VariationT tag where
    new _ attrs = do
        o <- newZeroVariationT
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@tag@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' variationT #tag
-- @
getVariationTTag :: MonadIO m => VariationT -> m Word32
getVariationTTag s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Word32
    return val

-- | Set the value of the “@tag@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' variationT [ #tag 'Data.GI.Base.Attributes.:=' value ]
-- @
setVariationTTag :: MonadIO m => VariationT -> Word32 -> m ()
setVariationTTag s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data VariationTTagFieldInfo
instance AttrInfo VariationTTagFieldInfo where
    type AttrBaseTypeConstraint VariationTTagFieldInfo = (~) VariationT
    type AttrAllowedOps VariationTTagFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint VariationTTagFieldInfo = (~) Word32
    type AttrTransferTypeConstraint VariationTTagFieldInfo = (~)Word32
    type AttrTransferType VariationTTagFieldInfo = Word32
    type AttrGetType VariationTTagFieldInfo = Word32
    type AttrLabel VariationTTagFieldInfo = "tag"
    type AttrOrigin VariationTTagFieldInfo = VariationT
    attrGet = getVariationTTag
    attrSet = setVariationTTag
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.VariationT.tag"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-VariationT.html#g:attr:tag"
        })

variationT_tag :: AttrLabelProxy "tag"
variationT_tag = AttrLabelProxy

#endif


-- | Get the value of the “@value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' variationT #value
-- @
getVariationTValue :: MonadIO m => VariationT -> m Float
getVariationTValue s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 4) :: IO CFloat
    let val' = realToFrac val
    return val'

-- | Set the value of the “@value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' variationT [ #value 'Data.GI.Base.Attributes.:=' value ]
-- @
setVariationTValue :: MonadIO m => VariationT -> Float -> m ()
setVariationTValue s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 4) (val' :: CFloat)

#if defined(ENABLE_OVERLOADING)
data VariationTValueFieldInfo
instance AttrInfo VariationTValueFieldInfo where
    type AttrBaseTypeConstraint VariationTValueFieldInfo = (~) VariationT
    type AttrAllowedOps VariationTValueFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint VariationTValueFieldInfo = (~) Float
    type AttrTransferTypeConstraint VariationTValueFieldInfo = (~)Float
    type AttrTransferType VariationTValueFieldInfo = Float
    type AttrGetType VariationTValueFieldInfo = Float
    type AttrLabel VariationTValueFieldInfo = "value"
    type AttrOrigin VariationTValueFieldInfo = VariationT
    attrGet = getVariationTValue
    attrSet = setVariationTValue
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.VariationT.value"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-VariationT.html#g:attr:value"
        })

variationT_value :: AttrLabelProxy "value"
variationT_value = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList VariationT
type instance O.AttributeList VariationT = VariationTAttributeList
type VariationTAttributeList = ('[ '("tag", VariationTTagFieldInfo), '("value", VariationTValueFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveVariationTMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveVariationTMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveVariationTMethod t VariationT, O.OverloadedMethod info VariationT p) => OL.IsLabel t (VariationT -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveVariationTMethod t VariationT, O.OverloadedMethod info VariationT p, R.HasField t VariationT p) => R.HasField t VariationT p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveVariationTMethod t VariationT, O.OverloadedMethodInfo info VariationT) => OL.IsLabel t (O.MethodProxy info VariationT) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


