static const char* edge_sobel_cl_source =
"#define SOBEL_RADIUS 1                                                        \n"
"/* FIXME: There are issues while horizontal and vertical are enabled together or\n"
"          if keep_sign is disabled and either of horizontal or vertical is enabled. */\n"
"#define FIXME 1                                                               \n"
"                                                                              \n"
"/* Boundary check function which clamps pixels similar to the                 \n"
"   non OpenCL version */                                                      \n"
"static inline float4 clamp_pixel (global float4 *in,                          \n"
"                                         int     x,                           \n"
"                                         int     y,                           \n"
"                                         int     width,                       \n"
"                                         int     height) {                    \n"
"    x = (x < 0) ? 0 : ((x < width)  ? x : (width - 1));                       \n"
"    y = (y < 0) ? 0 : ((y < height) ? y : (height - 1));                      \n"
"    return in[x + y * width];                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"kernel void kernel_edgesobel (global float4 *in,                              \n"
"                              global float4 *out,                             \n"
"                              const int horizontal,                           \n"
"                              const int vertical,                             \n"
"                              const int keep_sign,                            \n"
"                              const int has_alpha)                            \n"
"{                                                                             \n"
"    const int gidx = get_global_id (0);                                       \n"
"    const int gidy = get_global_id (1);                                       \n"
"                                                                              \n"
"    float4 hor_grad = 0.0f;                                                   \n"
"    float4 ver_grad = 0.0f;                                                   \n"
"    float4 gradient = 0.0f;                                                   \n"
"                                                                              \n"
"    const int dst_width  = get_global_size (0);                               \n"
"    const int dst_height = get_global_size (1);                               \n"
"    const int src_width  = dst_width  + (SOBEL_RADIUS << 1);                  \n"
"    const int src_ht     = dst_height + (SOBEL_RADIUS << 1);                  \n"
"                                                                              \n"
"    const float4 pix_fl = clamp_pixel (in, gidx - 1, gidy - 1, src_width, src_ht);\n"
"    const float4 pix_fm = clamp_pixel (in, gidx,     gidy - 1, src_width, src_ht);\n"
"    const float4 pix_fr = clamp_pixel (in, gidx + 1, gidy - 1, src_width, src_ht);\n"
"    const float4 pix_ml = clamp_pixel (in, gidx - 1, gidy,     src_width, src_ht);\n"
"    const float4 pix_mm = clamp_pixel (in, gidx,     gidy,     src_width, src_ht);\n"
"    const float4 pix_mr = clamp_pixel (in, gidx + 1, gidy,     src_width, src_ht);\n"
"    const float4 pix_bl = clamp_pixel (in, gidx - 1, gidy + 1, src_width, src_ht);\n"
"    const float4 pix_bm = clamp_pixel (in, gidx,     gidy + 1, src_width, src_ht);\n"
"    const float4 pix_br = clamp_pixel (in, gidx + 1, gidy + 1, src_width, src_ht);\n"
"                                                                              \n"
"    if (horizontal)                                                           \n"
"      {                                                                       \n"
"        hor_grad +=                                                           \n"
"            (-1.0f * pix_fl + 1.0f * pix_fr) +                                \n"
"            (-2.0f * pix_ml + 2.0f * pix_mr) +                                \n"
"            (-1.0f * pix_bl + 1.0f * pix_br);                                 \n"
"      }                                                                       \n"
"    if (vertical)                                                             \n"
"      {                                                                       \n"
"        ver_grad +=                                                           \n"
"            ( 1.0f * pix_fl) + ( 2.0f * pix_fm) + ( 1.0f * pix_fr) +          \n"
"            (-1.0f * pix_bl) + (-2.0f * pix_bm) + (-1.0f * pix_br);           \n"
"      }                                                                       \n"
"                                                                              \n"
"#ifndef FIXME                                                                 \n"
"    if (horizontal && vertical)                                               \n"
"      {                                                                       \n"
"        /* sqrt(32.0) = 5.656854 */                                           \n"
"        gradient = hypot (hor_grad, ver_grad) / (float4) 5.656854f;           \n"
"      }                                                                       \n"
"    else                                                                      \n"
"      {                                                                       \n"
"        if (keep_sign)                                                        \n"
"#endif                                                                        \n"
"          gradient = (float4) 0.5f + (hor_grad + ver_grad) / (float4) 8.0f;   \n"
"#ifndef FIXME                                                                 \n"
"        else                                                                  \n"
"          gradient = fabs (hor_grad + ver_grad) / (float4) 4.0f;              \n"
"      }                                                                       \n"
"#endif                                                                        \n"
"    if (has_alpha)                                                            \n"
"      gradient.w = pix_mm.w;                                                  \n"
"    else                                                                      \n"
"      gradient.w = 1.0f;                                                      \n"
"                                                                              \n"
"    out[gidx + gidy * dst_width] = gradient;                                  \n"
"}                                                                             \n"
;
