/* HideTracker.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from HideTracker.vala, do not modify */

/*
 * Copyright 2024 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * Authored by: Leonhard Kargl <leo.kargl@proton.me>
 */

#include <glib-object.h>
#include <meta/display.h>
#include "pantheon-desktop-shell-server-protocol.h"
#include <clutter/clutter.h>
#include <glib.h>
#include <meta/window.h>
#include <gio/gio.h>
#include <meta/meta-workspace-manager.h>
#include <meta/workspace.h>
#include <mtk/mtk.h>
#include <float.h>
#include <math.h>
#include "gala.h"
#include <meta/meta-context.h>
#include <meta/meta-backend.h>
#include <meta/barrier.h>
#include <meta/meta-cursor-tracker.h>
#include <meta/compositor-mutter.h>
#include <meta/meta-monitor-manager.h>

#define GALA_HIDE_TRACKER_BARRIER_OFFSET 50
#define GALA_HIDE_TRACKER_UPDATE_TIMEOUT 200
#define GALA_HIDE_TRACKER_HIDE_DELAY 500
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_HIDE_TRACKER (gala_hide_tracker_get_type ())
#define GALA_HIDE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_HIDE_TRACKER, GalaHideTracker))
#define GALA_HIDE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_HIDE_TRACKER, GalaHideTrackerClass))
#define GALA_IS_HIDE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_HIDE_TRACKER))
#define GALA_IS_HIDE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_HIDE_TRACKER))
#define GALA_HIDE_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_HIDE_TRACKER, GalaHideTrackerClass))

typedef struct _GalaHideTracker GalaHideTracker;
typedef struct _GalaHideTrackerClass GalaHideTrackerClass;
typedef struct _GalaHideTrackerPrivate GalaHideTrackerPrivate;

#define GALA_TYPE_POSITIONED_WINDOW (gala_positioned_window_get_type ())
#define GALA_POSITIONED_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_POSITIONED_WINDOW, GalaPositionedWindow))
#define GALA_POSITIONED_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_POSITIONED_WINDOW, GalaPositionedWindowClass))
#define GALA_IS_POSITIONED_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_POSITIONED_WINDOW))
#define GALA_IS_POSITIONED_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_POSITIONED_WINDOW))
#define GALA_POSITIONED_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_POSITIONED_WINDOW, GalaPositionedWindowClass))

typedef struct _GalaPositionedWindow GalaPositionedWindow;
typedef struct _GalaPositionedWindowClass GalaPositionedWindowClass;

#define GALA_TYPE_SHELL_WINDOW (gala_shell_window_get_type ())
#define GALA_SHELL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_SHELL_WINDOW, GalaShellWindow))
#define GALA_SHELL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_SHELL_WINDOW, GalaShellWindowClass))
#define GALA_IS_SHELL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_SHELL_WINDOW))
#define GALA_IS_SHELL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_SHELL_WINDOW))
#define GALA_SHELL_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_SHELL_WINDOW, GalaShellWindowClass))

typedef struct _GalaShellWindow GalaShellWindow;
typedef struct _GalaShellWindowClass GalaShellWindowClass;

#define GALA_TYPE_PANEL_WINDOW (gala_panel_window_get_type ())
#define GALA_PANEL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_PANEL_WINDOW, GalaPanelWindow))
#define GALA_PANEL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_PANEL_WINDOW, GalaPanelWindowClass))
#define GALA_IS_PANEL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_PANEL_WINDOW))
#define GALA_IS_PANEL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_PANEL_WINDOW))
#define GALA_PANEL_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_PANEL_WINDOW, GalaPanelWindowClass))

typedef struct _GalaPanelWindow GalaPanelWindow;
typedef struct _GalaPanelWindowClass GalaPanelWindowClass;

#define GALA_TYPE_BARRIER (gala_barrier_get_type ())
#define GALA_BARRIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BARRIER, GalaBarrier))
#define GALA_BARRIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BARRIER, GalaBarrierClass))
#define GALA_IS_BARRIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BARRIER))
#define GALA_IS_BARRIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BARRIER))
#define GALA_BARRIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BARRIER, GalaBarrierClass))

typedef struct _GalaBarrier GalaBarrier;
typedef struct _GalaBarrierClass GalaBarrierClass;
enum  {
	GALA_HIDE_TRACKER_0_PROPERTY,
	GALA_HIDE_TRACKER_DISPLAY_PROPERTY,
	GALA_HIDE_TRACKER_PANEL_PROPERTY,
	GALA_HIDE_TRACKER_HIDE_MODE_PROPERTY,
	GALA_HIDE_TRACKER_NUM_PROPERTIES
};
static GParamSpec* gala_hide_tracker_properties[GALA_HIDE_TRACKER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block54Data Block54Data;
enum  {
	GALA_HIDE_TRACKER_HIDE_SIGNAL,
	GALA_HIDE_TRACKER_SHOW_SIGNAL,
	GALA_HIDE_TRACKER_NUM_SIGNALS
};
static guint gala_hide_tracker_signals[GALA_HIDE_TRACKER_NUM_SIGNALS] = {0};

struct _GalaHideTracker {
	GObject parent_instance;
	GalaHideTrackerPrivate * priv;
};

struct _GalaHideTrackerClass {
	GObjectClass parent_class;
};

struct _GalaHideTrackerPrivate {
	MetaDisplay* _display;
	GalaPanelWindow* _panel;
	enum io_elementary_pantheon_panel_v1_hide_mode _hide_mode;
	ClutterPanAction* pan_action;
	gboolean hovered;
	gboolean overlap;
	gboolean focus_overlap;
	gboolean focus_maximized_overlap;
	gboolean fullscreen_overlap;
	MetaWindow* current_focus_window;
	GalaBarrier* barrier;
	guint hide_timeout_id;
	guint update_timeout_id;
};

struct _Block54Data {
	int _ref_count_;
	GalaHideTracker* self;
	gboolean has_transients;
};

static gint GalaHideTracker_private_offset;
static gpointer gala_hide_tracker_parent_class = NULL;
static GSettings* gala_hide_tracker_behavior_settings;
static GSettings* gala_hide_tracker_behavior_settings = NULL;

VALA_EXTERN GType gala_hide_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaHideTracker, g_object_unref)
VALA_EXTERN GType gala_positioned_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaPositionedWindow, g_object_unref)
VALA_EXTERN GType gala_shell_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaShellWindow, g_object_unref)
VALA_EXTERN GType gala_panel_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaPanelWindow, g_object_unref)
VALA_EXTERN GType gala_barrier_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBarrier, g_object_unref)
VALA_EXTERN GalaHideTracker* gala_hide_tracker_new (MetaDisplay* display,
                                        GalaPanelWindow* panel);
VALA_EXTERN GalaHideTracker* gala_hide_tracker_construct (GType object_type,
                                              MetaDisplay* display,
                                              GalaPanelWindow* panel);
static void gala_hide_tracker_track_focus_window (GalaHideTracker* self,
                                           MetaWindow* window);
VALA_EXTERN void gala_hide_tracker_schedule_update (GalaHideTracker* self);
static void _gala_hide_tracker_schedule_update_meta_window_position_changed (MetaWindow* _sender,
                                                                      gpointer self);
static void _gala_hide_tracker_schedule_update_meta_window_size_changed (MetaWindow* _sender,
                                                                  gpointer self);
static void gala_hide_tracker_untrack_focus_window (GalaHideTracker* self,
                                             MetaWindow* window);
static gboolean __lambda45_ (GalaHideTracker* self);
VALA_EXTERN void gala_hide_tracker_update_overlap (GalaHideTracker* self);
static gboolean ___lambda45__gsource_func (gpointer self);
static void gala_hide_tracker_reset_update_timeout (GalaHideTracker* self);
VALA_EXTERN MetaDisplay* gala_hide_tracker_get_display (GalaHideTracker* self);
VALA_EXTERN GalaPanelWindow* gala_hide_tracker_get_panel (GalaHideTracker* self);
VALA_EXTERN MetaWindow* gala_positioned_window_get_window (GalaPositionedWindow* self);
VALA_EXTERN void gala_positioned_window_get_custom_window_rect (GalaPositionedWindow* self,
                                                    MtkRectangle* result);
static void gala_hide_tracker_update_hidden (GalaHideTracker* self);
VALA_EXTERN enum io_elementary_pantheon_panel_v1_hide_mode gala_hide_tracker_get_hide_mode (GalaHideTracker* self);
static void gala_hide_tracker_toggle_display (GalaHideTracker* self,
                                       gboolean should_hide);
VALA_EXTERN gboolean gala_internal_utils_get_x11_in_fullscreen (MetaDisplay* display);
static void gala_hide_tracker_trigger_hide (GalaHideTracker* self);
static void gala_hide_tracker_trigger_show (GalaHideTracker* self);
static Block54Data* block54_data_ref (Block54Data* _data54_);
static void block54_data_unref (void * _userdata_);
static gboolean __lambda46_ (Block54Data* _data54_);
static gboolean ___lambda46__meta_window_foreach_func (MetaWindow* window,
                                                gpointer self);
static void gala_hide_tracker_reset_hide_timeout (GalaHideTracker* self);
static void __lambda47_ (GalaHideTracker* self);
static void ___lambda47__gsource_once_func (gpointer self);
static gboolean gala_hide_tracker_check_valid_gesture (GalaHideTracker* self);
VALA_EXTERN enum io_elementary_pantheon_panel_v1_anchor gala_panel_window_get_anchor (GalaPanelWindow* self);
static gboolean gala_hide_tracker_on_pan (GalaHideTracker* self);
static void gala_hide_tracker_setup_barrier (GalaHideTracker* self);
static void gala_hide_tracker_setup_barrier_top (GalaHideTracker* self,
                                          MtkRectangle* monitor_geom,
                                          gint offset);
static void gala_hide_tracker_setup_barrier_bottom (GalaHideTracker* self,
                                             MtkRectangle* monitor_geom,
                                             gint offset);
VALA_EXTERN GalaBarrier* gala_barrier_new (MetaBackend* backend,
                               gint x1,
                               gint y1,
                               gint x2,
                               gint y2,
                               MetaBarrierDirection directions,
                               gint trigger_pressure_threshold,
                               gint release_pressure_threshold,
                               gint retrigger_pressure_threshold,
                               gint retrigger_delay);
VALA_EXTERN GalaBarrier* gala_barrier_construct (GType object_type,
                                     MetaBackend* backend,
                                     gint x1,
                                     gint y1,
                                     gint x2,
                                     gint y2,
                                     MetaBarrierDirection directions,
                                     gint trigger_pressure_threshold,
                                     gint release_pressure_threshold,
                                     gint retrigger_pressure_threshold,
                                     gint retrigger_delay);
static void gala_hide_tracker_on_barrier_triggered (GalaHideTracker* self);
static void _gala_hide_tracker_on_barrier_triggered_gala_barrier_trigger (GalaBarrier* _sender,
                                                                   gpointer self);
static void gala_hide_tracker_set_display (GalaHideTracker* self,
                                    MetaDisplay* value);
static void gala_hide_tracker_set_panel (GalaHideTracker* self,
                                  GalaPanelWindow* value);
VALA_EXTERN void gala_hide_tracker_set_hide_mode (GalaHideTracker* self,
                                      enum io_elementary_pantheon_panel_v1_hide_mode value);
static GObject * gala_hide_tracker_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void _gala_hide_tracker___lambda48_ (GalaHideTracker* self);
static void __gala_hide_tracker___lambda48__meta_window_unmanaging (MetaWindow* _sender,
                                                             gpointer self);
static void _gala_hide_tracker___lambda49_ (GalaHideTracker* self);
static void __gala_hide_tracker___lambda49__g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
static void _gala_hide_tracker___lambda50_ (GalaHideTracker* self,
                                     MetaWindow* window);
static void _gala_hide_tracker_schedule_update_meta_window_unmanaged (MetaWindow* _sender,
                                                               gpointer self);
static void __gala_hide_tracker___lambda50__meta_display_window_created (MetaDisplay* _sender,
                                                                  MetaWindow* object,
                                                                  gpointer self);
static void _gala_hide_tracker___lambda51_ (GalaHideTracker* self);
static void __gala_hide_tracker___lambda51__meta_cursor_tracker_position_invalidated (MetaCursorTracker* _sender,
                                                                               gpointer self);
static void _gala_hide_tracker_schedule_update_meta_workspace_manager_active_workspace_changed (MetaWorkspaceManager* _sender,
                                                                                         gpointer self);
static gboolean _gala_hide_tracker_check_valid_gesture_clutter_gesture_action_gesture_begin (ClutterGestureAction* _sender,
                                                                                      ClutterActor* actor,
                                                                                      gpointer self);
static gboolean _gala_hide_tracker_on_pan_clutter_pan_action_pan (ClutterPanAction* _sender,
                                                           ClutterActor* actor,
                                                           gboolean is_interpolated,
                                                           gpointer self);
static void _gala_hide_tracker_setup_barrier_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self);
static void _gala_hide_tracker___lambda52_ (GalaHideTracker* self);
static void __gala_hide_tracker___lambda52__meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                            gpointer self);
static void gala_hide_tracker_finalize (GObject * obj);
static GType gala_hide_tracker_get_type_once (void);
static void _vala_gala_hide_tracker_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_gala_hide_tracker_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

static inline gpointer
gala_hide_tracker_get_instance_private (GalaHideTracker* self)
{
	return G_STRUCT_MEMBER_P (self, GalaHideTracker_private_offset);
}

GalaHideTracker*
gala_hide_tracker_construct (GType object_type,
                             MetaDisplay* display,
                             GalaPanelWindow* panel)
{
	GalaHideTracker * self = NULL;
	g_return_val_if_fail (display != NULL, NULL);
	g_return_val_if_fail (panel != NULL, NULL);
	self = (GalaHideTracker*) g_object_new (object_type, "display", display, "panel", panel, NULL);
	return self;
}

GalaHideTracker*
gala_hide_tracker_new (MetaDisplay* display,
                       GalaPanelWindow* panel)
{
	return gala_hide_tracker_construct (GALA_TYPE_HIDE_TRACKER, display, panel);
}

static void
_gala_hide_tracker_schedule_update_meta_window_position_changed (MetaWindow* _sender,
                                                                 gpointer self)
{
	gala_hide_tracker_schedule_update ((GalaHideTracker*) self);
}

static void
_gala_hide_tracker_schedule_update_meta_window_size_changed (MetaWindow* _sender,
                                                             gpointer self)
{
	gala_hide_tracker_schedule_update ((GalaHideTracker*) self);
}

static void
gala_hide_tracker_track_focus_window (GalaHideTracker* self,
                                      MetaWindow* window)
{
	g_return_if_fail (self != NULL);
	if (window == NULL) {
		return;
	}
	g_signal_connect_object (window, "position-changed", (GCallback) _gala_hide_tracker_schedule_update_meta_window_position_changed, self, 0);
	g_signal_connect_object (window, "size-changed", (GCallback) _gala_hide_tracker_schedule_update_meta_window_size_changed, self, 0);
	gala_hide_tracker_schedule_update (self);
}

static void
gala_hide_tracker_untrack_focus_window (GalaHideTracker* self,
                                        MetaWindow* window)
{
	guint _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	if (window == NULL) {
		return;
	}
	g_signal_parse_name ("position-changed", meta_window_get_type (), &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (window, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _gala_hide_tracker_schedule_update_meta_window_position_changed, self);
	g_signal_parse_name ("size-changed", meta_window_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (window, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _gala_hide_tracker_schedule_update_meta_window_size_changed, self);
	gala_hide_tracker_schedule_update (self);
}

static gboolean
__lambda45_ (GalaHideTracker* self)
{
	gboolean result;
	gala_hide_tracker_update_overlap (self);
	self->priv->update_timeout_id = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda45__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda45_ ((GalaHideTracker*) self);
	return result;
}

void
gala_hide_tracker_schedule_update (GalaHideTracker* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->update_timeout_id != ((guint) 0)) {
		return;
	}
	self->priv->update_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) GALA_HIDE_TRACKER_UPDATE_TIMEOUT, ___lambda45__gsource_func, g_object_ref (self), g_object_unref);
}

static void
gala_hide_tracker_reset_update_timeout (GalaHideTracker* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->update_timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->update_timeout_id);
		self->priv->update_timeout_id = (guint) 0;
	}
}

void
gala_hide_tracker_update_overlap (GalaHideTracker* self)
{
	MetaDisplay* _tmp0_;
	GalaPanelWindow* _tmp1_;
	MetaWindow* _tmp2_;
	MetaWindow* _tmp3_;
	MetaDisplay* _tmp4_;
	MetaWorkspaceManager* _tmp5_;
	MetaWorkspace* _tmp6_;
	GList* _tmp7_;
	g_return_if_fail (self != NULL);
	self->priv->overlap = FALSE;
	self->priv->focus_overlap = FALSE;
	self->priv->focus_maximized_overlap = FALSE;
	_tmp0_ = self->priv->_display;
	_tmp1_ = self->priv->_panel;
	_tmp2_ = gala_positioned_window_get_window ((GalaPositionedWindow*) _tmp1_);
	_tmp3_ = _tmp2_;
	self->priv->fullscreen_overlap = meta_display_get_monitor_in_fullscreen (_tmp0_, meta_window_get_monitor (_tmp3_));
	_tmp4_ = self->priv->_display;
	_tmp5_ = meta_display_get_workspace_manager (_tmp4_);
	_tmp6_ = meta_workspace_manager_get_active_workspace (_tmp5_);
	_tmp7_ = meta_workspace_list_windows (_tmp6_);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp7_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				MetaWindow* _tmp8_;
				GalaPanelWindow* _tmp9_;
				MetaWindow* _tmp10_;
				MetaWindow* _tmp11_;
				MetaWindow* _tmp12_;
				gboolean _tmp13_;
				gboolean _tmp14_;
				MetaWindowType type = 0;
				MetaWindow* _tmp15_;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp17_ = FALSE;
				gboolean _tmp18_ = FALSE;
				GalaPanelWindow* _tmp19_;
				MtkRectangle _tmp20_ = {0};
				MetaWindow* _tmp21_;
				MtkRectangle _tmp22_ = {0};
				MetaWindow* _tmp23_;
				MetaDisplay* _tmp24_;
				MetaWindow* _tmp25_;
				MetaWindow* _tmp26_;
				MetaWindow* _tmp27_;
				_tmp8_ = window;
				_tmp9_ = self->priv->_panel;
				_tmp10_ = gala_positioned_window_get_window ((GalaPositionedWindow*) _tmp9_);
				_tmp11_ = _tmp10_;
				if (_tmp8_ == _tmp11_) {
					continue;
				}
				_tmp12_ = window;
				g_object_get (_tmp12_, "minimized", &_tmp13_, NULL);
				_tmp14_ = _tmp13_;
				if (_tmp14_) {
					continue;
				}
				_tmp15_ = window;
				type = meta_window_get_window_type (_tmp15_);
				if (type == META_WINDOW_DESKTOP) {
					_tmp18_ = TRUE;
				} else {
					_tmp18_ = type == META_WINDOW_DOCK;
				}
				if (_tmp18_) {
					_tmp17_ = TRUE;
				} else {
					_tmp17_ = type == META_WINDOW_MENU;
				}
				if (_tmp17_) {
					_tmp16_ = TRUE;
				} else {
					_tmp16_ = type == META_WINDOW_SPLASHSCREEN;
				}
				if (_tmp16_) {
					continue;
				}
				_tmp19_ = self->priv->_panel;
				gala_positioned_window_get_custom_window_rect ((GalaPositionedWindow*) _tmp19_, &_tmp20_);
				_tmp21_ = window;
				meta_window_get_frame_rect (_tmp21_, &_tmp22_);
				if (!mtk_rectangle_overlap (&_tmp20_, &_tmp22_)) {
					continue;
				}
				self->priv->overlap = TRUE;
				_tmp23_ = window;
				_tmp24_ = self->priv->_display;
				_tmp25_ = meta_display_get_focus_window (_tmp24_);
				_tmp26_ = _tmp25_;
				if (_tmp23_ != _tmp26_) {
					continue;
				}
				self->priv->focus_overlap = TRUE;
				_tmp27_ = window;
				self->priv->focus_maximized_overlap = (meta_window_get_maximized (_tmp27_) & META_MAXIMIZE_VERTICAL) == META_MAXIMIZE_VERTICAL;
			}
		}
		(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
	}
	gala_hide_tracker_update_hidden (self);
}

static void
gala_hide_tracker_update_hidden (GalaHideTracker* self)
{
	enum io_elementary_pantheon_panel_v1_hide_mode _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_hide_mode;
	switch (_tmp0_) {
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_MAXIMIZED_FOCUS_WINDOW:
		{
			gala_hide_tracker_toggle_display (self, self->priv->focus_maximized_overlap);
			break;
		}
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_OVERLAPPING_FOCUS_WINDOW:
		{
			gala_hide_tracker_toggle_display (self, self->priv->focus_overlap);
			break;
		}
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_OVERLAPPING_WINDOW:
		{
			gala_hide_tracker_toggle_display (self, self->priv->overlap);
			break;
		}
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_ALWAYS:
		{
			gala_hide_tracker_toggle_display (self, TRUE);
			break;
		}
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_NEVER:
		{
			gala_hide_tracker_toggle_display (self, self->priv->fullscreen_overlap);
			break;
		}
		default:
		break;
	}
}

static void
gala_hide_tracker_toggle_display (GalaHideTracker* self,
                                  gboolean should_hide)
{
	GalaPanelWindow* _tmp0_;
	MetaWindow* _tmp1_;
	MetaWindow* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_panel;
	_tmp1_ = gala_positioned_window_get_window ((GalaPositionedWindow*) _tmp0_);
	_tmp2_ = _tmp1_;
	self->priv->hovered = meta_window_has_pointer (_tmp2_);
	if (should_hide) {
		_tmp5_ = !self->priv->hovered;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		GalaPanelWindow* _tmp6_;
		MetaWindow* _tmp7_;
		MetaWindow* _tmp8_;
		_tmp6_ = self->priv->_panel;
		_tmp7_ = gala_positioned_window_get_window ((GalaPositionedWindow*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = !meta_window_has_focus (_tmp8_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		MetaDisplay* _tmp9_;
		_tmp9_ = self->priv->_display;
		_tmp3_ = gala_internal_utils_get_x11_in_fullscreen (_tmp9_);
	}
	if (_tmp3_) {
		gala_hide_tracker_trigger_hide (self);
	} else {
		gala_hide_tracker_trigger_show (self);
	}
}

static Block54Data*
block54_data_ref (Block54Data* _data54_)
{
	g_atomic_int_inc (&_data54_->_ref_count_);
	return _data54_;
}

static void
block54_data_unref (void * _userdata_)
{
	Block54Data* _data54_;
	_data54_ = (Block54Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data54_->_ref_count_)) {
		GalaHideTracker* self;
		self = _data54_->self;
		_g_object_unref0 (self);
		g_slice_free (Block54Data, _data54_);
	}
}

static gboolean
__lambda46_ (Block54Data* _data54_)
{
	GalaHideTracker* self;
	gboolean result;
	self = _data54_->self;
	_data54_->has_transients = TRUE;
	result = FALSE;
	return result;
}

static gboolean
___lambda46__meta_window_foreach_func (MetaWindow* window,
                                       gpointer self)
{
	gboolean result;
	result = __lambda46_ (self);
	return result;
}

static void
__lambda47_ (GalaHideTracker* self)
{
	g_signal_emit (self, gala_hide_tracker_signals[GALA_HIDE_TRACKER_HIDE_SIGNAL], 0);
	self->priv->hide_timeout_id = (guint) 0;
}

static void
___lambda47__gsource_once_func (gpointer self)
{
	__lambda47_ ((GalaHideTracker*) self);
}

static void
gala_hide_tracker_trigger_hide (GalaHideTracker* self)
{
	Block54Data* _data54_;
	GalaPanelWindow* _tmp0_;
	MetaWindow* _tmp1_;
	MetaWindow* _tmp2_;
	g_return_if_fail (self != NULL);
	_data54_ = g_slice_new0 (Block54Data);
	_data54_->_ref_count_ = 1;
	_data54_->self = g_object_ref (self);
	if (self->priv->hide_timeout_id != ((guint) 0)) {
		block54_data_unref (_data54_);
		_data54_ = NULL;
		return;
	}
	_data54_->has_transients = FALSE;
	_tmp0_ = self->priv->_panel;
	_tmp1_ = gala_positioned_window_get_window ((GalaPositionedWindow*) _tmp0_);
	_tmp2_ = _tmp1_;
	meta_window_foreach_transient (_tmp2_, ___lambda46__meta_window_foreach_func, _data54_);
	if (_data54_->has_transients) {
		gala_hide_tracker_reset_hide_timeout (self);
		block54_data_unref (_data54_);
		_data54_ = NULL;
		return;
	}
	self->priv->hide_timeout_id = g_timeout_add_once ((guint) GALA_HIDE_TRACKER_HIDE_DELAY, ___lambda47__gsource_once_func, self);
	block54_data_unref (_data54_);
	_data54_ = NULL;
}

static void
gala_hide_tracker_reset_hide_timeout (GalaHideTracker* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->hide_timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->hide_timeout_id);
		self->priv->hide_timeout_id = (guint) 0;
	}
}

static void
gala_hide_tracker_trigger_show (GalaHideTracker* self)
{
	g_return_if_fail (self != NULL);
	gala_hide_tracker_reset_hide_timeout (self);
	g_signal_emit (self, gala_hide_tracker_signals[GALA_HIDE_TRACKER_SHOW_SIGNAL], 0);
}

static gboolean
gala_hide_tracker_check_valid_gesture (GalaHideTracker* self)
{
	GalaPanelWindow* _tmp0_;
	enum io_elementary_pantheon_panel_v1_anchor _tmp1_;
	enum io_elementary_pantheon_panel_v1_anchor _tmp2_;
	gfloat y = 0.0F;
	ClutterPanAction* _tmp3_;
	gfloat _tmp4_ = 0.0F;
	MtkRectangle monitor_geom = {0};
	MetaDisplay* _tmp5_;
	GalaPanelWindow* _tmp6_;
	MetaWindow* _tmp7_;
	MetaWindow* _tmp8_;
	MtkRectangle _tmp9_ = {0};
	MtkRectangle _tmp10_;
	MtkRectangle _tmp11_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_panel;
	_tmp1_ = gala_panel_window_get_anchor (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_BOTTOM) {
		g_debug ("HideTracker.vala:260: Swipe to reveal is currently only supported for " \
"bottom anchors");
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->pan_action;
	clutter_gesture_action_get_press_coords ((ClutterGestureAction*) _tmp3_, (guint) 0, NULL, &_tmp4_);
	y = _tmp4_;
	_tmp5_ = self->priv->_display;
	_tmp6_ = self->priv->_panel;
	_tmp7_ = gala_positioned_window_get_window ((GalaPositionedWindow*) _tmp6_);
	_tmp8_ = _tmp7_;
	meta_display_get_monitor_geometry (_tmp5_, meta_window_get_monitor (_tmp8_), &_tmp9_);
	monitor_geom = _tmp9_;
	_tmp10_ = monitor_geom;
	_tmp11_ = monitor_geom;
	if (fabsf ((y - _tmp10_.y) - _tmp11_.height) < ((gfloat) 50)) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
gala_hide_tracker_on_pan (GalaHideTracker* self)
{
	gfloat delta_y = 0.0F;
	ClutterPanAction* _tmp0_;
	gfloat _tmp1_ = 0.0F;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->pan_action;
	clutter_pan_action_get_motion_delta (_tmp0_, (guint) 0, NULL, &_tmp1_);
	delta_y = _tmp1_;
	if (delta_y < ((gfloat) 0)) {
		GalaPanelWindow* _tmp2_;
		MetaWindow* _tmp3_;
		MetaWindow* _tmp4_;
		ClutterPanAction* _tmp5_;
		ClutterEvent* _tmp6_;
		_tmp2_ = self->priv->_panel;
		_tmp3_ = gala_positioned_window_get_window ((GalaPositionedWindow*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->pan_action;
		_tmp6_ = clutter_gesture_action_get_last_event ((ClutterGestureAction*) _tmp5_, (guint) 0);
		meta_window_focus (_tmp4_, clutter_event_get_time (_tmp6_));
		gala_hide_tracker_trigger_show (self);
	}
	result = FALSE;
	return result;
}

static void
gala_hide_tracker_setup_barrier (GalaHideTracker* self)
{
	MtkRectangle monitor_geom = {0};
	MetaDisplay* _tmp0_;
	MetaDisplay* _tmp1_;
	MtkRectangle _tmp2_ = {0};
	gfloat scale = 0.0F;
	MetaDisplay* _tmp3_;
	MetaDisplay* _tmp4_;
	gint offset = 0;
	GalaPanelWindow* _tmp5_;
	enum io_elementary_pantheon_panel_v1_anchor _tmp6_;
	enum io_elementary_pantheon_panel_v1_anchor _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_display;
	_tmp1_ = self->priv->_display;
	meta_display_get_monitor_geometry (_tmp0_, meta_display_get_primary_monitor (_tmp1_), &_tmp2_);
	monitor_geom = _tmp2_;
	_tmp3_ = self->priv->_display;
	_tmp4_ = self->priv->_display;
	scale = meta_display_get_monitor_scale (_tmp3_, meta_display_get_primary_monitor (_tmp4_));
	offset = gala_utils_scale_to_int (GALA_HIDE_TRACKER_BARRIER_OFFSET, scale);
	_tmp5_ = self->priv->_panel;
	_tmp6_ = gala_panel_window_get_anchor (_tmp5_);
	_tmp7_ = _tmp6_;
	switch (_tmp7_) {
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_TOP:
		{
			MtkRectangle _tmp8_;
			_tmp8_ = monitor_geom;
			gala_hide_tracker_setup_barrier_top (self, &_tmp8_, offset);
			break;
		}
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_BOTTOM:
		{
			MtkRectangle _tmp9_;
			_tmp9_ = monitor_geom;
			gala_hide_tracker_setup_barrier_bottom (self, &_tmp9_, offset);
			break;
		}
		default:
		{
			g_warning ("HideTracker.vala:302: Barrier side not supported yet");
			break;
		}
	}
}

static void
_gala_hide_tracker_on_barrier_triggered_gala_barrier_trigger (GalaBarrier* _sender,
                                                              gpointer self)
{
	gala_hide_tracker_on_barrier_triggered ((GalaHideTracker*) self);
}

static void
gala_hide_tracker_setup_barrier_top (GalaHideTracker* self,
                                     MtkRectangle* monitor_geom,
                                     gint offset)
{
	MetaDisplay* _tmp0_;
	MetaContext* _tmp1_;
	MetaBackend* _tmp2_;
	MtkRectangle _tmp3_;
	MtkRectangle _tmp4_;
	MtkRectangle _tmp5_;
	MtkRectangle _tmp6_;
	MtkRectangle _tmp7_;
	GalaBarrier* _tmp8_;
	GalaBarrier* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor_geom != NULL);
	_tmp0_ = self->priv->_display;
	_tmp1_ = meta_display_get_context (_tmp0_);
	_tmp2_ = meta_context_get_backend (_tmp1_);
	_tmp3_ = *monitor_geom;
	_tmp4_ = *monitor_geom;
	_tmp5_ = *monitor_geom;
	_tmp6_ = *monitor_geom;
	_tmp7_ = *monitor_geom;
	_tmp8_ = gala_barrier_new (_tmp2_, _tmp3_.x + offset, _tmp4_.y, (_tmp5_.x + _tmp6_.width) - offset, _tmp7_.y, META_BARRIER_DIRECTION_POSITIVE_Y, 0, 0, G_MAXINT, G_MAXINT);
	_g_object_unref0 (self->priv->barrier);
	self->priv->barrier = _tmp8_;
	_tmp9_ = self->priv->barrier;
	g_signal_connect_object (_tmp9_, "trigger", (GCallback) _gala_hide_tracker_on_barrier_triggered_gala_barrier_trigger, self, 0);
}

static void
gala_hide_tracker_setup_barrier_bottom (GalaHideTracker* self,
                                        MtkRectangle* monitor_geom,
                                        gint offset)
{
	MetaDisplay* _tmp0_;
	MetaContext* _tmp1_;
	MetaBackend* _tmp2_;
	MtkRectangle _tmp3_;
	MtkRectangle _tmp4_;
	MtkRectangle _tmp5_;
	MtkRectangle _tmp6_;
	MtkRectangle _tmp7_;
	MtkRectangle _tmp8_;
	MtkRectangle _tmp9_;
	GalaBarrier* _tmp10_;
	GalaBarrier* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor_geom != NULL);
	_tmp0_ = self->priv->_display;
	_tmp1_ = meta_display_get_context (_tmp0_);
	_tmp2_ = meta_context_get_backend (_tmp1_);
	_tmp3_ = *monitor_geom;
	_tmp4_ = *monitor_geom;
	_tmp5_ = *monitor_geom;
	_tmp6_ = *monitor_geom;
	_tmp7_ = *monitor_geom;
	_tmp8_ = *monitor_geom;
	_tmp9_ = *monitor_geom;
	_tmp10_ = gala_barrier_new (_tmp2_, _tmp3_.x + offset, _tmp4_.y + _tmp5_.height, (_tmp6_.x + _tmp7_.width) - offset, _tmp8_.y + _tmp9_.height, META_BARRIER_DIRECTION_NEGATIVE_Y, 0, 0, G_MAXINT, G_MAXINT);
	_g_object_unref0 (self->priv->barrier);
	self->priv->barrier = _tmp10_;
	_tmp11_ = self->priv->barrier;
	g_signal_connect_object (_tmp11_, "trigger", (GCallback) _gala_hide_tracker_on_barrier_triggered_gala_barrier_trigger, self, 0);
}

static void
gala_hide_tracker_on_barrier_triggered (GalaHideTracker* self)
{
	MetaDisplay* _tmp0_;
	gboolean _tmp1_ = FALSE;
	enum io_elementary_pantheon_panel_v1_hide_mode _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_display;
	if (gala_internal_utils_get_x11_in_fullscreen (_tmp0_)) {
		return;
	}
	_tmp2_ = self->priv->_hide_mode;
	if (_tmp2_ != IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_NEVER) {
		_tmp1_ = TRUE;
	} else {
		GSettings* _tmp3_;
		_tmp3_ = gala_hide_tracker_behavior_settings;
		_tmp1_ = g_settings_get_boolean (_tmp3_, "enable-hotcorners-in-fullscreen");
	}
	if (_tmp1_) {
		gala_hide_tracker_trigger_show (self);
		gala_hide_tracker_schedule_update (self);
	}
}

MetaDisplay*
gala_hide_tracker_get_display (GalaHideTracker* self)
{
	MetaDisplay* result;
	MetaDisplay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_hide_tracker_set_display (GalaHideTracker* self,
                               MetaDisplay* value)
{
	MetaDisplay* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_hide_tracker_get_display (self);
	if (old_value != value) {
		MetaDisplay* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_display);
		self->priv->_display = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_hide_tracker_properties[GALA_HIDE_TRACKER_DISPLAY_PROPERTY]);
	}
}

GalaPanelWindow*
gala_hide_tracker_get_panel (GalaHideTracker* self)
{
	GalaPanelWindow* result;
	GalaPanelWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_panel;
	result = _tmp0_;
	return result;
}

static void
gala_hide_tracker_set_panel (GalaHideTracker* self,
                             GalaPanelWindow* value)
{
	GalaPanelWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_hide_tracker_get_panel (self);
	if (old_value != value) {
		self->priv->_panel = value;
		g_object_notify_by_pspec ((GObject *) self, gala_hide_tracker_properties[GALA_HIDE_TRACKER_PANEL_PROPERTY]);
	}
}

enum io_elementary_pantheon_panel_v1_hide_mode
gala_hide_tracker_get_hide_mode (GalaHideTracker* self)
{
	enum io_elementary_pantheon_panel_v1_hide_mode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_hide_mode;
	return result;
}

void
gala_hide_tracker_set_hide_mode (GalaHideTracker* self,
                                 enum io_elementary_pantheon_panel_v1_hide_mode value)
{
	enum io_elementary_pantheon_panel_v1_hide_mode old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_hide_tracker_get_hide_mode (self);
	if (old_value != value) {
		self->priv->_hide_mode = value;
		g_object_notify_by_pspec ((GObject *) self, gala_hide_tracker_properties[GALA_HIDE_TRACKER_HIDE_MODE_PROPERTY]);
	}
}

static void
_gala_hide_tracker___lambda48_ (GalaHideTracker* self)
{
	gala_hide_tracker_reset_hide_timeout (self);
	gala_hide_tracker_reset_update_timeout (self);
}

static void
__gala_hide_tracker___lambda48__meta_window_unmanaging (MetaWindow* _sender,
                                                        gpointer self)
{
	_gala_hide_tracker___lambda48_ ((GalaHideTracker*) self);
}

static void
_gala_hide_tracker___lambda49_ (GalaHideTracker* self)
{
	MetaWindow* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaWindow* _tmp2_;
	MetaWindow* _tmp3_;
	MetaWindow* _tmp4_;
	MetaWindow* _tmp5_;
	_tmp0_ = self->priv->current_focus_window;
	gala_hide_tracker_untrack_focus_window (self, _tmp0_);
	_tmp1_ = self->priv->_display;
	_tmp2_ = meta_display_get_focus_window (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->current_focus_window);
	self->priv->current_focus_window = _tmp4_;
	_tmp5_ = self->priv->current_focus_window;
	gala_hide_tracker_track_focus_window (self, _tmp5_);
}

static void
__gala_hide_tracker___lambda49__g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	_gala_hide_tracker___lambda49_ ((GalaHideTracker*) self);
}

static void
_gala_hide_tracker_schedule_update_meta_window_unmanaged (MetaWindow* _sender,
                                                          gpointer self)
{
	gala_hide_tracker_schedule_update ((GalaHideTracker*) self);
}

static void
_gala_hide_tracker___lambda50_ (GalaHideTracker* self,
                                MetaWindow* window)
{
	g_return_if_fail (window != NULL);
	gala_hide_tracker_schedule_update (self);
	g_signal_connect_object (window, "unmanaged", (GCallback) _gala_hide_tracker_schedule_update_meta_window_unmanaged, self, 0);
}

static void
__gala_hide_tracker___lambda50__meta_display_window_created (MetaDisplay* _sender,
                                                             MetaWindow* object,
                                                             gpointer self)
{
	_gala_hide_tracker___lambda50_ ((GalaHideTracker*) self, object);
}

static void
_gala_hide_tracker___lambda51_ (GalaHideTracker* self)
{
	gboolean has_pointer = FALSE;
	GalaPanelWindow* _tmp0_;
	MetaWindow* _tmp1_;
	MetaWindow* _tmp2_;
	_tmp0_ = self->priv->_panel;
	_tmp1_ = gala_positioned_window_get_window ((GalaPositionedWindow*) _tmp0_);
	_tmp2_ = _tmp1_;
	has_pointer = meta_window_has_pointer (_tmp2_);
	if (self->priv->hovered != has_pointer) {
		self->priv->hovered = has_pointer;
		gala_hide_tracker_schedule_update (self);
	}
}

static void
__gala_hide_tracker___lambda51__meta_cursor_tracker_position_invalidated (MetaCursorTracker* _sender,
                                                                          gpointer self)
{
	_gala_hide_tracker___lambda51_ ((GalaHideTracker*) self);
}

static void
_gala_hide_tracker_schedule_update_meta_workspace_manager_active_workspace_changed (MetaWorkspaceManager* _sender,
                                                                                    gpointer self)
{
	gala_hide_tracker_schedule_update ((GalaHideTracker*) self);
}

static gboolean
_gala_hide_tracker_check_valid_gesture_clutter_gesture_action_gesture_begin (ClutterGestureAction* _sender,
                                                                             ClutterActor* actor,
                                                                             gpointer self)
{
	gboolean result;
	result = gala_hide_tracker_check_valid_gesture ((GalaHideTracker*) self);
	return result;
}

static gboolean
_gala_hide_tracker_on_pan_clutter_pan_action_pan (ClutterPanAction* _sender,
                                                  ClutterActor* actor,
                                                  gboolean is_interpolated,
                                                  gpointer self)
{
	gboolean result;
	result = gala_hide_tracker_on_pan ((GalaHideTracker*) self);
	return result;
}

static void
_gala_hide_tracker_setup_barrier_g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self)
{
	gala_hide_tracker_setup_barrier ((GalaHideTracker*) self);
}

static void
_gala_hide_tracker___lambda52_ (GalaHideTracker* self)
{
	gala_hide_tracker_setup_barrier (self);
	gala_hide_tracker_schedule_update (self);
}

static void
__gala_hide_tracker___lambda52__meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                       gpointer self)
{
	_gala_hide_tracker___lambda52_ ((GalaHideTracker*) self);
}

static GObject *
gala_hide_tracker_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaHideTracker * self;
	GalaPanelWindow* _tmp0_;
	MetaWindow* _tmp1_;
	MetaWindow* _tmp2_;
	MetaDisplay* _tmp3_;
	MetaWindow* _tmp4_;
	MetaWindow* _tmp5_;
	MetaWindow* _tmp6_;
	MetaWindow* _tmp7_;
	MetaDisplay* _tmp8_;
	MetaDisplay* _tmp9_;
	MetaCursorTracker* cursor_tracker = NULL;
	MetaDisplay* _tmp10_;
	MetaCursorTracker* _tmp11_;
	MetaCursorTracker* _tmp12_;
	MetaDisplay* _tmp13_;
	MetaWorkspaceManager* _tmp14_;
	ClutterPanAction* _tmp15_ = NULL;
	ClutterPanAction* _tmp16_;
	ClutterPanAction* _tmp17_;
	MetaDisplay* _tmp18_;
	ClutterActor* _tmp19_;
	ClutterPanAction* _tmp20_;
	GalaPanelWindow* _tmp21_;
	MetaMonitorManager* monitor_manager = NULL;
	MetaDisplay* _tmp22_;
	MetaContext* _tmp23_;
	MetaBackend* _tmp24_;
	MetaMonitorManager* _tmp25_;
	MetaMonitorManager* _tmp26_;
	MetaMonitorManager* _tmp27_;
	parent_class = G_OBJECT_CLASS (gala_hide_tracker_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_HIDE_TRACKER, GalaHideTracker);
	_tmp0_ = self->priv->_panel;
	_tmp1_ = gala_positioned_window_get_window ((GalaPositionedWindow*) _tmp0_);
	_tmp2_ = _tmp1_;
	g_signal_connect_object (_tmp2_, "unmanaging", (GCallback) __gala_hide_tracker___lambda48__meta_window_unmanaging, self, G_CONNECT_AFTER);
	_tmp3_ = self->priv->_display;
	_tmp4_ = meta_display_get_focus_window (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (self->priv->current_focus_window);
	self->priv->current_focus_window = _tmp6_;
	_tmp7_ = self->priv->current_focus_window;
	gala_hide_tracker_track_focus_window (self, _tmp7_);
	_tmp8_ = self->priv->_display;
	g_signal_connect_object ((GObject*) _tmp8_, "notify::focus-window", (GCallback) __gala_hide_tracker___lambda49__g_object_notify, self, 0);
	_tmp9_ = self->priv->_display;
	g_signal_connect_object (_tmp9_, "window-created", (GCallback) __gala_hide_tracker___lambda50__meta_display_window_created, self, 0);
	_tmp10_ = self->priv->_display;
	_tmp11_ = meta_cursor_tracker_get_for_display (_tmp10_);
	cursor_tracker = _tmp11_;
	_tmp12_ = cursor_tracker;
	g_signal_connect_object (_tmp12_, "position-invalidated", (GCallback) __gala_hide_tracker___lambda51__meta_cursor_tracker_position_invalidated, self, 0);
	_tmp13_ = self->priv->_display;
	_tmp14_ = meta_display_get_workspace_manager (_tmp13_);
	g_signal_connect_object (_tmp14_, "active-workspace-changed", (GCallback) _gala_hide_tracker_schedule_update_meta_workspace_manager_active_workspace_changed, self, 0);
	_tmp15_ = (ClutterPanAction*) clutter_pan_action_new ();
	clutter_gesture_action_set_n_touch_points ((ClutterGestureAction*) _tmp15_, 1);
	clutter_pan_action_set_pan_axis (_tmp15_, CLUTTER_PAN_X_AXIS);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->pan_action);
	self->priv->pan_action = _tmp15_;
	_tmp16_ = self->priv->pan_action;
	g_signal_connect_object ((ClutterGestureAction*) _tmp16_, "gesture-begin", (GCallback) _gala_hide_tracker_check_valid_gesture_clutter_gesture_action_gesture_begin, self, 0);
	_tmp17_ = self->priv->pan_action;
	g_signal_connect_object (_tmp17_, "pan", (GCallback) _gala_hide_tracker_on_pan_clutter_pan_action_pan, self, 0);
	_tmp18_ = self->priv->_display;
	_tmp19_ = meta_get_stage_for_display (_tmp18_);
	_tmp20_ = self->priv->pan_action;
	clutter_actor_add_action_full (_tmp19_, "panel-swipe-gesture", CLUTTER_PHASE_CAPTURE, (ClutterAction*) _tmp20_);
	_tmp21_ = self->priv->_panel;
	g_signal_connect_object ((GObject*) _tmp21_, "notify::anchor", (GCallback) _gala_hide_tracker_setup_barrier_g_object_notify, self, 0);
	_tmp22_ = self->priv->_display;
	_tmp23_ = meta_display_get_context (_tmp22_);
	_tmp24_ = meta_context_get_backend (_tmp23_);
	_tmp25_ = meta_backend_get_monitor_manager (_tmp24_);
	_tmp26_ = _g_object_ref0 (_tmp25_);
	monitor_manager = _tmp26_;
	_tmp27_ = monitor_manager;
	g_signal_connect_object (_tmp27_, "monitors-changed", (GCallback) __gala_hide_tracker___lambda52__meta_monitor_manager_monitors_changed, self, 0);
	gala_hide_tracker_setup_barrier (self);
	_g_object_unref0 (monitor_manager);
	return obj;
}

static void
gala_hide_tracker_class_init (GalaHideTrackerClass * klass,
                              gpointer klass_data)
{
	GSettings* _tmp0_;
	gala_hide_tracker_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaHideTracker_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_hide_tracker_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_hide_tracker_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_hide_tracker_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_hide_tracker_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_HIDE_TRACKER_DISPLAY_PROPERTY, gala_hide_tracker_properties[GALA_HIDE_TRACKER_DISPLAY_PROPERTY] = g_param_spec_object ("display", "display", "display", meta_display_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_HIDE_TRACKER_PANEL_PROPERTY, gala_hide_tracker_properties[GALA_HIDE_TRACKER_PANEL_PROPERTY] = g_param_spec_object ("panel", "panel", "panel", GALA_TYPE_PANEL_WINDOW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_HIDE_TRACKER_HIDE_MODE_PROPERTY, gala_hide_tracker_properties[GALA_HIDE_TRACKER_HIDE_MODE_PROPERTY] = g_param_spec_int ("hide-mode", "hide-mode", "hide-mode", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gala_hide_tracker_signals[GALA_HIDE_TRACKER_HIDE_SIGNAL] = g_signal_new ("hide", GALA_TYPE_HIDE_TRACKER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gala_hide_tracker_signals[GALA_HIDE_TRACKER_SHOW_SIGNAL] = g_signal_new ("show", GALA_TYPE_HIDE_TRACKER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = g_settings_new ("io.elementary.desktop.wm.behavior");
	_g_object_unref0 (gala_hide_tracker_behavior_settings);
	gala_hide_tracker_behavior_settings = _tmp0_;
}

static void
gala_hide_tracker_instance_init (GalaHideTracker * self,
                                 gpointer klass)
{
	self->priv = gala_hide_tracker_get_instance_private (self);
	self->priv->hovered = FALSE;
	self->priv->overlap = FALSE;
	self->priv->focus_overlap = FALSE;
	self->priv->focus_maximized_overlap = FALSE;
	self->priv->fullscreen_overlap = FALSE;
	self->priv->hide_timeout_id = (guint) 0;
	self->priv->update_timeout_id = (guint) 0;
}

static void
gala_hide_tracker_finalize (GObject * obj)
{
	GalaHideTracker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_HIDE_TRACKER, GalaHideTracker);
	_g_object_unref0 (self->priv->_display);
	_g_object_unref0 (self->priv->pan_action);
	_g_object_unref0 (self->priv->current_focus_window);
	_g_object_unref0 (self->priv->barrier);
	G_OBJECT_CLASS (gala_hide_tracker_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_hide_tracker_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaHideTrackerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_hide_tracker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaHideTracker), 0, (GInstanceInitFunc) gala_hide_tracker_instance_init, NULL };
	GType gala_hide_tracker_type_id;
	gala_hide_tracker_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaHideTracker", &g_define_type_info, 0);
	GalaHideTracker_private_offset = g_type_add_instance_private (gala_hide_tracker_type_id, sizeof (GalaHideTrackerPrivate));
	return gala_hide_tracker_type_id;
}

GType
gala_hide_tracker_get_type (void)
{
	static gsize gala_hide_tracker_type_id__once = 0;
	if (g_once_init_enter (&gala_hide_tracker_type_id__once)) {
		GType gala_hide_tracker_type_id;
		gala_hide_tracker_type_id = gala_hide_tracker_get_type_once ();
		g_once_init_leave (&gala_hide_tracker_type_id__once, gala_hide_tracker_type_id);
	}
	return gala_hide_tracker_type_id__once;
}

static void
_vala_gala_hide_tracker_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	GalaHideTracker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_HIDE_TRACKER, GalaHideTracker);
	switch (property_id) {
		case GALA_HIDE_TRACKER_DISPLAY_PROPERTY:
		g_value_set_object (value, gala_hide_tracker_get_display (self));
		break;
		case GALA_HIDE_TRACKER_PANEL_PROPERTY:
		g_value_set_object (value, gala_hide_tracker_get_panel (self));
		break;
		case GALA_HIDE_TRACKER_HIDE_MODE_PROPERTY:
		g_value_set_int (value, gala_hide_tracker_get_hide_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_hide_tracker_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	GalaHideTracker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_HIDE_TRACKER, GalaHideTracker);
	switch (property_id) {
		case GALA_HIDE_TRACKER_DISPLAY_PROPERTY:
		gala_hide_tracker_set_display (self, g_value_get_object (value));
		break;
		case GALA_HIDE_TRACKER_PANEL_PROPERTY:
		gala_hide_tracker_set_panel (self, g_value_get_object (value));
		break;
		case GALA_HIDE_TRACKER_HIDE_MODE_PROPERTY:
		gala_hide_tracker_set_hide_mode (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

