/* NotificationStack.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from NotificationStack.vala, do not modify */

/*
 * Copyright 2020 elementary, Inc (https://elementary.io)
 *           2014 Tom Beckmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <glib.h>
#include <meta/display.h>
#include <gee.h>
#include <meta/meta-window-actor.h>
#include <stdlib.h>
#include <string.h>
#include <clutter/clutter.h>
#include <meta/window.h>
#include <mtk/mtk.h>
#include <meta/prefs.h>
#include <float.h>
#include <math.h>
#include <meta/meta-workspace-manager.h>
#include <meta/workspace.h>
#include "gala.h"
#include <meta/meta-monitor-manager.h>
#include <meta/meta-context.h>
#include <meta/meta-backend.h>

#define GALA_NOTIFICATION_STACK_TRANSITION_ENTRY_NAME "entry"
#define GALA_NOTIFICATION_STACK_TRANSITION_MOVE_STACK_ID "move-stack"
#define GALA_NOTIFICATION_STACK_TOP_OFFSET 2
#define GALA_NOTIFICATION_STACK_ADDITIONAL_MARGIN 12
#define GALA_NOTIFICATION_STACK_MARGIN 12
#define GALA_NOTIFICATION_STACK_WIDTH 300
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_NOTIFICATION_STACK (gala_notification_stack_get_type ())
#define GALA_NOTIFICATION_STACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_NOTIFICATION_STACK, GalaNotificationStack))
#define GALA_NOTIFICATION_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_NOTIFICATION_STACK, GalaNotificationStackClass))
#define GALA_IS_NOTIFICATION_STACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_NOTIFICATION_STACK))
#define GALA_IS_NOTIFICATION_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_NOTIFICATION_STACK))
#define GALA_NOTIFICATION_STACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_NOTIFICATION_STACK, GalaNotificationStackClass))

typedef struct _GalaNotificationStack GalaNotificationStack;
typedef struct _GalaNotificationStackClass GalaNotificationStackClass;
typedef struct _GalaNotificationStackPrivate GalaNotificationStackPrivate;
enum  {
	GALA_NOTIFICATION_STACK_0_PROPERTY,
	GALA_NOTIFICATION_STACK_DISPLAY_PROPERTY,
	GALA_NOTIFICATION_STACK_NUM_PROPERTIES
};
static GParamSpec* gala_notification_stack_properties[GALA_NOTIFICATION_STACK_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block7Data Block7Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GalaNotificationStack {
	GObject parent_instance;
	GalaNotificationStackPrivate * priv;
};

struct _GalaNotificationStackClass {
	GObjectClass parent_class;
};

struct _GalaNotificationStackPrivate {
	gint stack_y;
	gint stack_width;
	MetaDisplay* _display;
	GeeArrayList* notifications;
};

struct _Block7Data {
	int _ref_count_;
	GalaNotificationStack* self;
	MetaWindowActor* notification;
};

static gint GalaNotificationStack_private_offset;
static gpointer gala_notification_stack_parent_class = NULL;

VALA_EXTERN GType gala_notification_stack_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaNotificationStack, g_object_unref)
VALA_EXTERN GalaNotificationStack* gala_notification_stack_new (MetaDisplay* display);
VALA_EXTERN GalaNotificationStack* gala_notification_stack_construct (GType object_type,
                                                          MetaDisplay* display);
VALA_EXTERN void gala_notification_stack_show_notification (GalaNotificationStack* self,
                                                MetaWindowActor* notification);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void _vala_GValue_array_free (GValue * array,
                              gssize array_length);
static void ___lambda44_ (Block7Data* _data7_);
static void ____lambda44__clutter_actor_transitions_completed (ClutterActor* _sender,
                                                        gpointer self);
VALA_EXTERN MetaDisplay* gala_notification_stack_get_display (GalaNotificationStack* self);
static void gala_notification_stack_update_positions (GalaNotificationStack* self,
                                               gfloat scale,
                                               gfloat add_y);
static void gala_notification_stack_move_window (MetaWindowActor* actor,
                                          gint x,
                                          gint y);
static void gala_notification_stack_update_stack_allocation (GalaNotificationStack* self);
VALA_EXTERN void gala_notification_stack_destroy_notification (GalaNotificationStack* self,
                                                   MetaWindowActor* notification);
VALA_EXTERN gboolean gala_notification_stack_is_notification (MetaWindow* window);
static void gala_notification_stack_set_display (GalaNotificationStack* self,
                                          MetaDisplay* value);
static GObject * gala_notification_stack_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void _gala_notification_stack_update_stack_allocation_meta_monitor_manager_monitors_changed_internal (MetaMonitorManager* _sender,
                                                                                                      gpointer self);
static void _gala_notification_stack_update_stack_allocation_meta_display_workareas_changed (MetaDisplay* _sender,
                                                                                      gpointer self);
static void gala_notification_stack_finalize (GObject * obj);
static GType gala_notification_stack_get_type_once (void);
static void _vala_gala_notification_stack_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_gala_notification_stack_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static inline gpointer
gala_notification_stack_get_instance_private (GalaNotificationStack* self)
{
	return G_STRUCT_MEMBER_P (self, GalaNotificationStack_private_offset);
}

GalaNotificationStack*
gala_notification_stack_construct (GType object_type,
                                   MetaDisplay* display)
{
	GalaNotificationStack * self = NULL;
	g_return_val_if_fail (display != NULL, NULL);
	self = (GalaNotificationStack*) g_object_new (object_type, "display", display, NULL);
	return self;
}

GalaNotificationStack*
gala_notification_stack_new (MetaDisplay* display)
{
	return gala_notification_stack_construct (GALA_TYPE_NOTIFICATION_STACK, display);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		GalaNotificationStack* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->notification);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
_vala_GValue_array_free (GValue * array,
                         gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			g_value_unset (&array[i]);
		}
	}
	g_free (array);
}

static void
___lambda44_ (Block7Data* _data7_)
{
	GalaNotificationStack* self;
	self = _data7_->self;
	clutter_actor_remove_all_transitions ((ClutterActor*) _data7_->notification);
}

static void
____lambda44__clutter_actor_transitions_completed (ClutterActor* _sender,
                                                   gpointer self)
{
	___lambda44_ (self);
}

void
gala_notification_stack_show_notification (GalaNotificationStack* self,
                                           MetaWindowActor* notification)
{
	GeeArrayList* _tmp0_;
	Block7Data* _data7_;
	MetaWindowActor* _tmp1_;
	MetaWindow* window = NULL;
	MetaWindow* _tmp2_;
	MetaWindow* _tmp3_;
	MtkRectangle window_rect = {0};
	MetaWindow* _tmp4_;
	MtkRectangle _tmp5_ = {0};
	MetaWindow* _tmp6_;
	gint primary = 0;
	MetaDisplay* _tmp30_;
	MtkRectangle area = {0};
	MetaDisplay* _tmp31_;
	MetaWorkspaceManager* _tmp32_;
	MetaWorkspace* _tmp33_;
	MtkRectangle _tmp34_ = {0};
	gfloat scale = 0.0F;
	MetaDisplay* _tmp35_;
	MtkRectangle _tmp36_;
	gint notification_x_pos = 0;
	MtkRectangle _tmp37_;
	MtkRectangle _tmp38_;
	MtkRectangle _tmp39_;
	GeeArrayList* _tmp40_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (notification != NULL);
	_tmp0_ = self->priv->notifications;
	_vala_return_if_fail (((notification != NULL) && (!meta_window_actor_is_destroyed (notification))) && (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, notification)), "notification != null && !notification.is_destroyed () && !notifications.contains (notification)");
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp1_ = _g_object_ref0 (notification);
	_g_object_unref0 (_data7_->notification);
	_data7_->notification = _tmp1_;
	clutter_actor_set_pivot_point ((ClutterActor*) _data7_->notification, 0.5f, 0.5f);
	_tmp2_ = meta_window_actor_get_meta_window (_data7_->notification);
	window = _tmp2_;
	_tmp3_ = window;
	if (_tmp3_ == NULL) {
		g_warning ("NotificationStack.vala:58: NotificationStack: Unable to show notificat" \
"ion, window is null");
		block7_data_unref (_data7_);
		_data7_ = NULL;
		return;
	}
	_tmp4_ = window;
	meta_window_get_frame_rect (_tmp4_, &_tmp5_);
	window_rect = _tmp5_;
	_tmp6_ = window;
	meta_window_stick (_tmp6_);
	if (meta_prefs_get_gnome_animations ()) {
		ClutterPropertyTransition* opacity_transition = NULL;
		ClutterPropertyTransition* _tmp7_;
		ClutterPropertyTransition* _tmp8_;
		GValue _tmp9_ = {0};
		ClutterPropertyTransition* _tmp10_;
		GValue _tmp11_ = {0};
		ClutterKeyframeTransition* flip_transition = NULL;
		ClutterKeyframeTransition* _tmp12_;
		ClutterKeyframeTransition* _tmp13_;
		GValue _tmp14_ = {0};
		ClutterKeyframeTransition* _tmp15_;
		GValue _tmp16_ = {0};
		ClutterKeyframeTransition* _tmp17_;
		gdouble* _tmp18_;
		gdouble* _tmp19_;
		gint _tmp19__length1;
		ClutterKeyframeTransition* _tmp20_;
		GValue _tmp21_ = {0};
		GValue* _tmp22_;
		GValue* _tmp23_;
		gint _tmp23__length1;
		ClutterTransitionGroup* entry = NULL;
		ClutterTransitionGroup* _tmp24_ = NULL;
		ClutterTransitionGroup* _tmp25_;
		ClutterPropertyTransition* _tmp26_;
		ClutterTransitionGroup* _tmp27_;
		ClutterKeyframeTransition* _tmp28_;
		ClutterTransitionGroup* _tmp29_;
		clutter_actor_set_opacity ((ClutterActor*) _data7_->notification, (guint) 0);
		g_object_set ((ClutterActor*) _data7_->notification, "rotation-angle-x", (gdouble) 90, NULL);
		_tmp7_ = (ClutterPropertyTransition*) clutter_property_transition_new ("opacity");
		opacity_transition = _tmp7_;
		_tmp8_ = opacity_transition;
		g_value_init (&_tmp9_, G_TYPE_INT);
		g_value_set_int (&_tmp9_, 0);
		clutter_transition_set_from_value ((ClutterTransition*) _tmp8_, &_tmp9_);
		G_IS_VALUE (&_tmp9_) ? (g_value_unset (&_tmp9_), NULL) : NULL;
		_tmp10_ = opacity_transition;
		g_value_init (&_tmp11_, G_TYPE_INT);
		g_value_set_int (&_tmp11_, 255);
		clutter_transition_set_to_value ((ClutterTransition*) _tmp10_, &_tmp11_);
		G_IS_VALUE (&_tmp11_) ? (g_value_unset (&_tmp11_), NULL) : NULL;
		_tmp12_ = (ClutterKeyframeTransition*) clutter_keyframe_transition_new ("rotation-angle-x");
		flip_transition = _tmp12_;
		_tmp13_ = flip_transition;
		g_value_init (&_tmp14_, G_TYPE_DOUBLE);
		g_value_set_double (&_tmp14_, 90.0);
		clutter_transition_set_from_value ((ClutterTransition*) _tmp13_, &_tmp14_);
		G_IS_VALUE (&_tmp14_) ? (g_value_unset (&_tmp14_), NULL) : NULL;
		_tmp15_ = flip_transition;
		g_value_init (&_tmp16_, G_TYPE_DOUBLE);
		g_value_set_double (&_tmp16_, 0.0);
		clutter_transition_set_to_value ((ClutterTransition*) _tmp15_, &_tmp16_);
		G_IS_VALUE (&_tmp16_) ? (g_value_unset (&_tmp16_), NULL) : NULL;
		_tmp17_ = flip_transition;
		_tmp18_ = g_new0 (gdouble, 1);
		_tmp18_[0] = 0.6;
		_tmp19_ = _tmp18_;
		_tmp19__length1 = 1;
		clutter_keyframe_transition_set_key_frames (_tmp17_, (guint) 1, _tmp19_);
		_tmp19_ = (g_free (_tmp19_), NULL);
		_tmp20_ = flip_transition;
		g_value_init (&_tmp21_, G_TYPE_DOUBLE);
		g_value_set_double (&_tmp21_, -10.0);
		_tmp22_ = g_new0 (GValue, 1);
		_tmp22_[0] = _tmp21_;
		_tmp23_ = _tmp22_;
		_tmp23__length1 = 1;
		clutter_keyframe_transition_set_values (_tmp20_, (guint) 1, _tmp23_);
		_tmp23_ = (_vala_GValue_array_free (_tmp23_, _tmp23__length1), NULL);
		_tmp24_ = (ClutterTransitionGroup*) clutter_transition_group_new ();
		clutter_timeline_set_duration ((ClutterTimeline*) _tmp24_, (guint) 400);
		entry = _tmp24_;
		_tmp25_ = entry;
		_tmp26_ = opacity_transition;
		clutter_transition_group_add_transition (_tmp25_, (ClutterTransition*) _tmp26_);
		_tmp27_ = entry;
		_tmp28_ = flip_transition;
		clutter_transition_group_add_transition (_tmp27_, (ClutterTransition*) _tmp28_);
		g_signal_connect_data ((ClutterActor*) _data7_->notification, "transitions-completed", (GCallback) ____lambda44__clutter_actor_transitions_completed, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
		_tmp29_ = entry;
		clutter_actor_add_transition ((ClutterActor*) _data7_->notification, GALA_NOTIFICATION_STACK_TRANSITION_ENTRY_NAME, (ClutterTransition*) _tmp29_);
		_g_object_unref0 (entry);
		_g_object_unref0 (flip_transition);
		_g_object_unref0 (opacity_transition);
	}
	_tmp30_ = self->priv->_display;
	primary = meta_display_get_primary_monitor (_tmp30_);
	_tmp31_ = self->priv->_display;
	_tmp32_ = meta_display_get_workspace_manager (_tmp31_);
	_tmp33_ = meta_workspace_manager_get_active_workspace (_tmp32_);
	meta_workspace_get_work_area_for_monitor (_tmp33_, primary, &_tmp34_);
	area = _tmp34_;
	_tmp35_ = self->priv->_display;
	scale = meta_display_get_monitor_scale (_tmp35_, primary);
	_tmp36_ = window_rect;
	gala_notification_stack_update_positions (self, scale, (gfloat) _tmp36_.height);
	_tmp37_ = area;
	_tmp38_ = area;
	_tmp39_ = window_rect;
	notification_x_pos = (_tmp37_.x + _tmp38_.width) - _tmp39_.width;
	if (clutter_get_default_text_direction () == CLUTTER_TEXT_DIRECTION_RTL) {
		notification_x_pos = 0;
	}
	gala_notification_stack_move_window (_data7_->notification, notification_x_pos, (self->priv->stack_y + GALA_NOTIFICATION_STACK_TOP_OFFSET) + gala_utils_scale_to_int (GALA_NOTIFICATION_STACK_ADDITIONAL_MARGIN, scale));
	_tmp40_ = self->priv->notifications;
	gee_abstract_list_insert ((GeeAbstractList*) _tmp40_, 0, _data7_->notification);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

static void
gala_notification_stack_update_stack_allocation (GalaNotificationStack* self)
{
	gint primary = 0;
	MetaDisplay* _tmp0_;
	MtkRectangle area = {0};
	MetaDisplay* _tmp1_;
	MetaWorkspaceManager* _tmp2_;
	MetaWorkspace* _tmp3_;
	MtkRectangle _tmp4_ = {0};
	gfloat scale = 0.0F;
	MetaDisplay* _tmp5_;
	MtkRectangle _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_display;
	primary = meta_display_get_primary_monitor (_tmp0_);
	_tmp1_ = self->priv->_display;
	_tmp2_ = meta_display_get_workspace_manager (_tmp1_);
	_tmp3_ = meta_workspace_manager_get_active_workspace (_tmp2_);
	meta_workspace_get_work_area_for_monitor (_tmp3_, primary, &_tmp4_);
	area = _tmp4_;
	_tmp5_ = self->priv->_display;
	scale = meta_display_get_monitor_scale (_tmp5_, primary);
	self->priv->stack_width = gala_utils_scale_to_int (GALA_NOTIFICATION_STACK_WIDTH + GALA_NOTIFICATION_STACK_MARGIN, scale);
	_tmp6_ = area;
	self->priv->stack_y = _tmp6_.y;
}

static void
gala_notification_stack_update_positions (GalaNotificationStack* self,
                                          gfloat scale,
                                          gfloat add_y)
{
	gfloat y = 0.0F;
	gint i = 0;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_ = 0;
	gint delay_step = 0;
	gint iterator = 0;
	g_return_if_fail (self != NULL);
	y = ((self->priv->stack_y + GALA_NOTIFICATION_STACK_TOP_OFFSET) + add_y) + gala_utils_scale_to_int (GALA_NOTIFICATION_STACK_ADDITIONAL_MARGIN, scale);
	_tmp0_ = self->priv->notifications;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	i = _tmp2_;
	if (i > 0) {
		_tmp3_ = 150 / i;
	} else {
		_tmp3_ = 0;
	}
	delay_step = _tmp3_;
	iterator = 0;
	while (TRUE) {
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		MetaWindowActor* actor = NULL;
		GeeArrayList* _tmp7_;
		gpointer _tmp8_;
		gint _tmp9_;
		gboolean _tmp10_ = FALSE;
		MetaWindowActor* _tmp11_;
		MetaWindowActor* _tmp19_;
		MetaWindow* window = NULL;
		MetaWindowActor* _tmp21_;
		MetaWindow* _tmp22_;
		MetaWindow* _tmp23_;
		MetaWindow* _tmp26_;
		MtkRectangle _tmp27_ = {0};
		_tmp4_ = self->priv->notifications;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		if (!(_tmp6_ > iterator)) {
			break;
		}
		_tmp7_ = self->priv->notifications;
		_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, iterator);
		actor = (MetaWindowActor*) _tmp8_;
		_tmp9_ = iterator;
		iterator = _tmp9_ + 1;
		_tmp11_ = actor;
		if (_tmp11_ == NULL) {
			_tmp10_ = TRUE;
		} else {
			MetaWindowActor* _tmp12_;
			_tmp12_ = actor;
			_tmp10_ = meta_window_actor_is_destroyed (_tmp12_);
		}
		if (_tmp10_) {
			g_warning ("NotificationStack.vala:130: NotificationStack: Notification actor was " \
"null or destroyed");
			continue;
		}
		if (meta_prefs_get_gnome_animations ()) {
			MetaWindowActor* _tmp13_;
			MetaWindowActor* _tmp14_;
			MetaWindowActor* _tmp15_;
			MetaWindowActor* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			_tmp13_ = actor;
			clutter_actor_save_easing_state ((ClutterActor*) _tmp13_);
			_tmp14_ = actor;
			clutter_actor_set_easing_mode ((ClutterActor*) _tmp14_, CLUTTER_EASE_OUT_BACK);
			_tmp15_ = actor;
			clutter_actor_set_easing_duration ((ClutterActor*) _tmp15_, (guint) 200);
			_tmp16_ = actor;
			_tmp17_ = i;
			i = _tmp17_ - 1;
			_tmp18_ = delay_step;
			clutter_actor_set_easing_delay ((ClutterActor*) _tmp16_, (guint) (_tmp17_ * _tmp18_));
		}
		_tmp19_ = actor;
		gala_notification_stack_move_window (_tmp19_, -1, (gint) y);
		if (meta_prefs_get_gnome_animations ()) {
			MetaWindowActor* _tmp20_;
			_tmp20_ = actor;
			clutter_actor_restore_easing_state ((ClutterActor*) _tmp20_);
		}
		_tmp21_ = actor;
		_tmp22_ = meta_window_actor_get_meta_window (_tmp21_);
		window = _tmp22_;
		_tmp23_ = window;
		if (_tmp23_ == NULL) {
			GeeArrayList* _tmp24_;
			MetaWindowActor* _tmp25_;
			_tmp24_ = self->priv->notifications;
			_tmp25_ = actor;
			gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp24_, _tmp25_);
			g_warning ("NotificationStack.vala:155: NotificationStack: Notification window was" \
" null (probably removed during workspace transition?)");
			continue;
		}
		_tmp26_ = window;
		meta_window_get_frame_rect (_tmp26_, &_tmp27_);
		y += (gfloat) _tmp27_.height;
	}
}

void
gala_notification_stack_destroy_notification (GalaNotificationStack* self,
                                              MetaWindowActor* notification)
{
	gint primary = 0;
	MetaDisplay* _tmp4_;
	gfloat scale = 0.0F;
	MetaDisplay* _tmp5_;
	GeeArrayList* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (notification != NULL);
	if (meta_prefs_get_gnome_animations ()) {
		gfloat _tmp0_;
		gfloat _tmp1_;
		clutter_actor_save_easing_state ((ClutterActor*) notification);
		clutter_actor_set_easing_duration ((ClutterActor*) notification, (guint) 100);
		clutter_actor_set_easing_mode ((ClutterActor*) notification, CLUTTER_EASE_IN_QUAD);
		clutter_actor_set_opacity ((ClutterActor*) notification, (guint) 0);
		_tmp0_ = clutter_actor_get_x ((ClutterActor*) notification);
		_tmp1_ = _tmp0_;
		clutter_actor_set_x ((ClutterActor*) notification, _tmp1_ + self->priv->stack_width);
		clutter_actor_restore_easing_state ((ClutterActor*) notification);
	} else {
		gfloat _tmp2_;
		gfloat _tmp3_;
		clutter_actor_set_opacity ((ClutterActor*) notification, (guint) 0);
		_tmp2_ = clutter_actor_get_x ((ClutterActor*) notification);
		_tmp3_ = _tmp2_;
		clutter_actor_set_x ((ClutterActor*) notification, _tmp3_ + self->priv->stack_width);
	}
	_tmp4_ = self->priv->_display;
	primary = meta_display_get_primary_monitor (_tmp4_);
	_tmp5_ = self->priv->_display;
	scale = meta_display_get_monitor_scale (_tmp5_, primary);
	_tmp6_ = self->priv->notifications;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp6_, notification);
	gala_notification_stack_update_positions (self, scale, 0.0f);
}

/**
     * This function takes care of properly updating both the actor
     * position and the actual window position.
     *
     * To enable animations for a window we first need to move it's frame
     * in the compositor and then calculate & apply the coordinates for the window
     * actor.
     */
static void
gala_notification_stack_move_window (MetaWindowActor* actor,
                                     gint x,
                                     gint y)
{
	MetaWindow* window = NULL;
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	MtkRectangle rect = {0};
	MetaWindow* _tmp2_;
	MtkRectangle _tmp3_ = {0};
	gint _tmp4_ = 0;
	gint _tmp6_ = 0;
	MetaWindow* _tmp8_;
	MetaWindow* _tmp9_;
	MtkRectangle _tmp10_ = {0};
	MtkRectangle _tmp11_;
	gfloat _tmp12_;
	gfloat _tmp13_;
	MtkRectangle _tmp14_;
	MtkRectangle _tmp15_;
	gfloat _tmp16_;
	gfloat _tmp17_;
	MtkRectangle _tmp18_;
	g_return_if_fail (actor != NULL);
	_vala_return_if_fail ((actor != NULL) && (!meta_window_actor_is_destroyed (actor)), "actor != null && !actor.is_destroyed ()");
	_tmp0_ = meta_window_actor_get_meta_window (actor);
	window = _tmp0_;
	_tmp1_ = window;
	if (_tmp1_ == NULL) {
		g_warning ("NotificationStack.vala:195: NotificationStack: Unable to move the wind" \
"ow, window is null");
		return;
	}
	_tmp2_ = window;
	meta_window_get_frame_rect (_tmp2_, &_tmp3_);
	rect = _tmp3_;
	if (x != -1) {
		_tmp4_ = x;
	} else {
		MtkRectangle _tmp5_;
		_tmp5_ = rect;
		_tmp4_ = _tmp5_.x;
	}
	if (y != -1) {
		_tmp6_ = y;
	} else {
		MtkRectangle _tmp7_;
		_tmp7_ = rect;
		_tmp6_ = _tmp7_.y;
	}
	_tmp8_ = window;
	meta_window_move_frame (_tmp8_, FALSE, _tmp4_, _tmp6_);
	_tmp9_ = window;
	meta_window_get_buffer_rect (_tmp9_, &_tmp10_);
	rect = _tmp10_;
	_tmp11_ = rect;
	_tmp12_ = clutter_actor_get_width ((ClutterActor*) actor);
	_tmp13_ = _tmp12_;
	_tmp14_ = rect;
	_tmp15_ = rect;
	_tmp16_ = clutter_actor_get_height ((ClutterActor*) actor);
	_tmp17_ = _tmp16_;
	_tmp18_ = rect;
	clutter_actor_set_position ((ClutterActor*) actor, _tmp11_.x - ((_tmp13_ - _tmp14_.width) / 2), _tmp15_.y - ((_tmp17_ - _tmp18_.height) / 2));
}

gboolean
gala_notification_stack_is_notification (MetaWindow* window)
{
	gboolean _tmp0_ = FALSE;
	MetaWindowType _tmp1_;
	MetaWindowType _tmp2_;
	gboolean result;
	g_return_val_if_fail (window != NULL, FALSE);
	_tmp1_ = meta_window_get_window_type (window);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == META_WINDOW_NOTIFICATION) {
		_tmp0_ = TRUE;
	} else {
		gconstpointer _tmp3_;
		_tmp3_ = g_object_get_data ((GObject*) window, GALA_NOTIFICATION_DATA_KEY);
		_tmp0_ = (gboolean) ((gintptr) _tmp3_);
	}
	result = _tmp0_;
	return result;
}

MetaDisplay*
gala_notification_stack_get_display (GalaNotificationStack* self)
{
	MetaDisplay* result;
	MetaDisplay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}

static void
gala_notification_stack_set_display (GalaNotificationStack* self,
                                     MetaDisplay* value)
{
	MetaDisplay* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_notification_stack_get_display (self);
	if (old_value != value) {
		MetaDisplay* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_display);
		self->priv->_display = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_notification_stack_properties[GALA_NOTIFICATION_STACK_DISPLAY_PROPERTY]);
	}
}

static void
_gala_notification_stack_update_stack_allocation_meta_monitor_manager_monitors_changed_internal (MetaMonitorManager* _sender,
                                                                                                 gpointer self)
{
	gala_notification_stack_update_stack_allocation ((GalaNotificationStack*) self);
}

static void
_gala_notification_stack_update_stack_allocation_meta_display_workareas_changed (MetaDisplay* _sender,
                                                                                 gpointer self)
{
	gala_notification_stack_update_stack_allocation ((GalaNotificationStack*) self);
}

static GObject *
gala_notification_stack_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaNotificationStack * self;
	GeeArrayList* _tmp0_;
	MetaMonitorManager* monitor_manager = NULL;
	MetaDisplay* _tmp1_;
	MetaContext* _tmp2_;
	MetaBackend* _tmp3_;
	MetaMonitorManager* _tmp4_;
	MetaMonitorManager* _tmp5_;
	MetaDisplay* _tmp6_;
	parent_class = G_OBJECT_CLASS (gala_notification_stack_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_NOTIFICATION_STACK, GalaNotificationStack);
	_tmp0_ = gee_array_list_new (meta_window_actor_get_type (), NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->notifications);
	self->priv->notifications = _tmp0_;
	_tmp1_ = self->priv->_display;
	_tmp2_ = meta_display_get_context (_tmp1_);
	_tmp3_ = meta_context_get_backend (_tmp2_);
	_tmp4_ = meta_backend_get_monitor_manager (_tmp3_);
	monitor_manager = _tmp4_;
	_tmp5_ = monitor_manager;
	g_signal_connect_object (_tmp5_, "monitors-changed-internal", (GCallback) _gala_notification_stack_update_stack_allocation_meta_monitor_manager_monitors_changed_internal, self, 0);
	_tmp6_ = self->priv->_display;
	g_signal_connect_object (_tmp6_, "workareas-changed", (GCallback) _gala_notification_stack_update_stack_allocation_meta_display_workareas_changed, self, 0);
	gala_notification_stack_update_stack_allocation (self);
	return obj;
}

static void
gala_notification_stack_class_init (GalaNotificationStackClass * klass,
                                    gpointer klass_data)
{
	gala_notification_stack_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaNotificationStack_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_notification_stack_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_notification_stack_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_notification_stack_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_notification_stack_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_NOTIFICATION_STACK_DISPLAY_PROPERTY, gala_notification_stack_properties[GALA_NOTIFICATION_STACK_DISPLAY_PROPERTY] = g_param_spec_object ("display", "display", "display", meta_display_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
gala_notification_stack_instance_init (GalaNotificationStack * self,
                                       gpointer klass)
{
	self->priv = gala_notification_stack_get_instance_private (self);
}

static void
gala_notification_stack_finalize (GObject * obj)
{
	GalaNotificationStack * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_NOTIFICATION_STACK, GalaNotificationStack);
	_g_object_unref0 (self->priv->_display);
	_g_object_unref0 (self->priv->notifications);
	G_OBJECT_CLASS (gala_notification_stack_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_notification_stack_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaNotificationStackClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_notification_stack_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaNotificationStack), 0, (GInstanceInitFunc) gala_notification_stack_instance_init, NULL };
	GType gala_notification_stack_type_id;
	gala_notification_stack_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaNotificationStack", &g_define_type_info, 0);
	GalaNotificationStack_private_offset = g_type_add_instance_private (gala_notification_stack_type_id, sizeof (GalaNotificationStackPrivate));
	return gala_notification_stack_type_id;
}

GType
gala_notification_stack_get_type (void)
{
	static gsize gala_notification_stack_type_id__once = 0;
	if (g_once_init_enter (&gala_notification_stack_type_id__once)) {
		GType gala_notification_stack_type_id;
		gala_notification_stack_type_id = gala_notification_stack_get_type_once ();
		g_once_init_leave (&gala_notification_stack_type_id__once, gala_notification_stack_type_id);
	}
	return gala_notification_stack_type_id__once;
}

static void
_vala_gala_notification_stack_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	GalaNotificationStack * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_NOTIFICATION_STACK, GalaNotificationStack);
	switch (property_id) {
		case GALA_NOTIFICATION_STACK_DISPLAY_PROPERTY:
		g_value_set_object (value, gala_notification_stack_get_display (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_notification_stack_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	GalaNotificationStack * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_NOTIFICATION_STACK, GalaNotificationStack);
	switch (property_id) {
		case GALA_NOTIFICATION_STACK_DISPLAY_PROPERTY:
		gala_notification_stack_set_display (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

