/* GestureController.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from GestureController.vala, do not modify */

/*
 * Copyright 2025 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * Authored by: Leonhard Kargl <leo.kargl@proton.me>
 */

#include <glib-object.h>
#include "gala.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <clutter/clutter.h>
#include <meta/prefs.h>

#define GALA_GESTURE_CONTROLLER_SUCCESS_VELOCITY_THRESHOLD 0.003
#define GALA_GESTURE_CONTROLLER_MAX_VELOCITY 0.01
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_GESTURE_CONTROLLER (gala_gesture_controller_get_type ())
#define GALA_GESTURE_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_CONTROLLER, GalaGestureController))
#define GALA_GESTURE_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_GESTURE_CONTROLLER, GalaGestureControllerClass))
#define GALA_IS_GESTURE_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_CONTROLLER))
#define GALA_IS_GESTURE_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_GESTURE_CONTROLLER))
#define GALA_GESTURE_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_GESTURE_CONTROLLER, GalaGestureControllerClass))

typedef struct _GalaGestureController GalaGestureController;
typedef struct _GalaGestureControllerClass GalaGestureControllerClass;
typedef struct _GalaGestureControllerPrivate GalaGestureControllerPrivate;

#define GALA_TYPE_ROOT_TARGET (gala_root_target_get_type ())
#define GALA_ROOT_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ROOT_TARGET, GalaRootTarget))
#define GALA_IS_ROOT_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ROOT_TARGET))
#define GALA_ROOT_TARGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_TYPE_ROOT_TARGET, GalaRootTargetIface))

typedef struct _GalaRootTarget GalaRootTarget;
typedef struct _GalaRootTargetIface GalaRootTargetIface;

#define GALA_TYPE_GESTURE_TARGET (gala_gesture_target_get_type ())
#define GALA_GESTURE_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_TARGET, GalaGestureTarget))
#define GALA_IS_GESTURE_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_TARGET))
#define GALA_GESTURE_TARGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_TYPE_GESTURE_TARGET, GalaGestureTargetIface))

typedef struct _GalaGestureTarget GalaGestureTarget;
typedef struct _GalaGestureTargetIface GalaGestureTargetIface;
typedef enum  {
	GALA_GESTURE_TARGET_UPDATE_TYPE_START,
	GALA_GESTURE_TARGET_UPDATE_TYPE_UPDATE,
	GALA_GESTURE_TARGET_UPDATE_TYPE_COMMIT,
	GALA_GESTURE_TARGET_UPDATE_TYPE_END
} GalaGestureTargetUpdateType;

#define GALA_GESTURE_TARGET_TYPE_UPDATE_TYPE (gala_gesture_target_update_type_get_type ())

#define GALA_TYPE_TOUCHEGG_BACKEND (gala_touchegg_backend_get_type ())
#define GALA_TOUCHEGG_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_TOUCHEGG_BACKEND, GalaToucheggBackend))
#define GALA_TOUCHEGG_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_TOUCHEGG_BACKEND, GalaToucheggBackendClass))
#define GALA_IS_TOUCHEGG_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_TOUCHEGG_BACKEND))
#define GALA_IS_TOUCHEGG_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_TOUCHEGG_BACKEND))
#define GALA_TOUCHEGG_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_TOUCHEGG_BACKEND, GalaToucheggBackendClass))

typedef struct _GalaToucheggBackend GalaToucheggBackend;
typedef struct _GalaToucheggBackendClass GalaToucheggBackendClass;

#define GALA_TYPE_SCROLL_BACKEND (gala_scroll_backend_get_type ())
#define GALA_SCROLL_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_SCROLL_BACKEND, GalaScrollBackend))
#define GALA_SCROLL_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_SCROLL_BACKEND, GalaScrollBackendClass))
#define GALA_IS_SCROLL_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_SCROLL_BACKEND))
#define GALA_IS_SCROLL_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_SCROLL_BACKEND))
#define GALA_SCROLL_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_SCROLL_BACKEND, GalaScrollBackendClass))

typedef struct _GalaScrollBackend GalaScrollBackend;
typedef struct _GalaScrollBackendClass GalaScrollBackendClass;

#define GALA_TYPE_GESTURE_BACKEND (gala_gesture_backend_get_type ())
#define GALA_GESTURE_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_BACKEND, GalaGestureBackend))
#define GALA_IS_GESTURE_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_BACKEND))
#define GALA_GESTURE_BACKEND_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_TYPE_GESTURE_BACKEND, GalaGestureBackendIface))

typedef struct _GalaGestureBackend GalaGestureBackend;
typedef struct _GalaGestureBackendIface GalaGestureBackendIface;

#define GALA_TYPE_SPRING_TIMELINE (gala_spring_timeline_get_type ())
#define GALA_SPRING_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_SPRING_TIMELINE, GalaSpringTimeline))
#define GALA_SPRING_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_SPRING_TIMELINE, GalaSpringTimelineClass))
#define GALA_IS_SPRING_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_SPRING_TIMELINE))
#define GALA_IS_SPRING_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_SPRING_TIMELINE))
#define GALA_SPRING_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_SPRING_TIMELINE, GalaSpringTimelineClass))

typedef struct _GalaSpringTimeline GalaSpringTimeline;
typedef struct _GalaSpringTimelineClass GalaSpringTimelineClass;
enum  {
	GALA_GESTURE_CONTROLLER_0_PROPERTY,
	GALA_GESTURE_CONTROLLER_ACTION_PROPERTY,
	GALA_GESTURE_CONTROLLER_WM_PROPERTY,
	GALA_GESTURE_CONTROLLER_TARGET_PROPERTY,
	GALA_GESTURE_CONTROLLER_ACTION_INFO_PROPERTY,
	GALA_GESTURE_CONTROLLER_DISTANCE_PROPERTY,
	GALA_GESTURE_CONTROLLER_OVERSHOOT_LOWER_CLAMP_PROPERTY,
	GALA_GESTURE_CONTROLLER_OVERSHOOT_UPPER_CLAMP_PROPERTY,
	GALA_GESTURE_CONTROLLER_SNAP_PROPERTY,
	GALA_GESTURE_CONTROLLER_PROGRESS_PROPERTY,
	GALA_GESTURE_CONTROLLER_ENABLED_PROPERTY,
	GALA_GESTURE_CONTROLLER_RECOGNIZING_PROPERTY,
	GALA_GESTURE_CONTROLLER_NUM_PROPERTIES
};
static GParamSpec* gala_gesture_controller_properties[GALA_GESTURE_CONTROLLER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define GALA_TYPE_GESTURE (gala_gesture_get_type ())
#define GALA_GESTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE, GalaGesture))
#define GALA_GESTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_GESTURE, GalaGestureClass))
#define GALA_IS_GESTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE))
#define GALA_IS_GESTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_GESTURE))
#define GALA_GESTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_GESTURE, GalaGestureClass))

typedef struct _GalaGesture GalaGesture;
typedef struct _GalaGestureClass GalaGestureClass;

#define GALA_TYPE_GESTURE_SETTINGS (gala_gesture_settings_get_type ())
#define GALA_GESTURE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_SETTINGS, GalaGestureSettings))
#define GALA_GESTURE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_GESTURE_SETTINGS, GalaGestureSettingsClass))
#define GALA_IS_GESTURE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_SETTINGS))
#define GALA_IS_GESTURE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_GESTURE_SETTINGS))
#define GALA_GESTURE_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_GESTURE_SETTINGS, GalaGestureSettingsClass))

typedef struct _GalaGestureSettings GalaGestureSettings;
typedef struct _GalaGestureSettingsClass GalaGestureSettingsClass;
typedef struct _GalaGesturePrivate GalaGesturePrivate;
typedef enum  {
	GALA_GESTURE_DIRECTION_UNKNOWN = 0,
	GALA_GESTURE_DIRECTION_UP = 1,
	GALA_GESTURE_DIRECTION_DOWN = 2,
	GALA_GESTURE_DIRECTION_LEFT = 3,
	GALA_GESTURE_DIRECTION_RIGHT = 4,
	GALA_GESTURE_DIRECTION_IN = 5,
	GALA_GESTURE_DIRECTION_OUT = 6
} GalaGestureDirection;

#define GALA_TYPE_GESTURE_DIRECTION (gala_gesture_direction_get_type ())
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GalaGestureController {
	GObject parent_instance;
	GalaGestureControllerPrivate * priv;
};

struct _GalaGestureControllerClass {
	GObjectClass parent_class;
};

struct _GalaGestureTargetIface {
	GTypeInterface parent_iface;
	void (*propagate) (GalaGestureTarget* self, GalaGestureTargetUpdateType update_type, GalaGestureAction action, gdouble progress);
	ClutterActor* (*get_actor) (GalaGestureTarget* self);
};

struct _GalaRootTargetIface {
	GTypeInterface parent_iface;
};

struct _GalaGestureBackendIface {
	GTypeInterface parent_iface;
	void (*prepare_gesture_handling) (GalaGestureBackend* self);
	void (*cancel_gesture) (GalaGestureBackend* self);
};

struct _GalaGestureControllerPrivate {
	GalaGestureAction _action;
	GalaWindowManager* _wm;
	GalaRootTarget* _target;
	GVariant* _action_info;
	gdouble _distance;
	gdouble _overshoot_lower_clamp;
	gdouble _overshoot_upper_clamp;
	gboolean _snap;
	gdouble _progress;
	gboolean _enabled;
	gboolean _recognizing;
	GalaToucheggBackend* touchpad_backend;
	GalaScrollBackend* scroll_backend;
	GalaGestureBackend* recognizing_backend;
	gdouble gesture_progress;
	gdouble previous_percentage;
	guint64 previous_time;
	gdouble previous_delta;
	gdouble velocity;
	gint direction_multiplier;
	GalaSpringTimeline* timeline;
};

struct _GalaGesture {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GalaGesturePrivate * priv;
	ClutterEventType type;
	GalaGestureDirection direction;
	gint fingers;
	ClutterInputDeviceType performed_on_device_type;
	gfloat origin_x;
	gfloat origin_y;
};

struct _GalaGestureClass {
	GTypeClass parent_class;
	void (*finalize) (GalaGesture *self);
};

static gint GalaGestureController_private_offset;
static gpointer gala_gesture_controller_parent_class = NULL;

VALA_EXTERN GType gala_gesture_controller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureController, g_object_unref)
VALA_EXTERN GType gala_gesture_target_update_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gala_gesture_target_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureTarget, g_object_unref)
VALA_EXTERN GType gala_root_target_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gala_touchegg_backend_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaToucheggBackend, g_object_unref)
VALA_EXTERN GType gala_scroll_backend_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaScrollBackend, g_object_unref)
VALA_EXTERN GType gala_gesture_backend_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureBackend, g_object_unref)
VALA_EXTERN GType gala_spring_timeline_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaSpringTimeline, g_object_unref)
VALA_EXTERN GalaGestureController* gala_gesture_controller_new (GalaGestureAction action,
                                                    GalaWindowManager* wm);
VALA_EXTERN GalaGestureController* gala_gesture_controller_construct (GType object_type,
                                                          GalaGestureAction action,
                                                          GalaWindowManager* wm);
VALA_EXTERN void gala_gesture_controller_attached (GalaGestureController* self,
                                       GalaRootTarget* target);
static void gala_gesture_controller_set_target (GalaGestureController* self,
                                         GalaRootTarget* value);
VALA_EXTERN void gala_gesture_controller_detached (GalaGestureController* self);
VALA_EXTERN void gala_gesture_controller_enable_touchpad (GalaGestureController* self);
VALA_EXTERN GalaToucheggBackend* gala_touchegg_backend_get_default (void);
VALA_EXTERN gpointer gala_gesture_ref (gpointer instance);
VALA_EXTERN void gala_gesture_unref (gpointer instance);
VALA_EXTERN GParamSpec* gala_param_spec_gesture (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void gala_value_set_gesture (GValue* value,
                             gpointer v_object);
VALA_EXTERN void gala_value_take_gesture (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer gala_value_get_gesture (const GValue* value);
VALA_EXTERN GType gala_gesture_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGesture, gala_gesture_unref)
static gboolean gala_gesture_controller_gesture_detected (GalaGestureController* self,
                                                   GalaGestureBackend* backend,
                                                   GalaGesture* gesture,
                                                   guint32 timestamp);
static gboolean _gala_gesture_controller_gesture_detected_gala_gesture_backend_on_gesture_detected (GalaGestureBackend* _sender,
                                                                                             GalaGesture* gesture,
                                                                                             guint32 timestamp,
                                                                                             gpointer self);
static void gala_gesture_controller_gesture_begin (GalaGestureController* self,
                                            gdouble percentage,
                                            guint64 elapsed_time);
static void _gala_gesture_controller_gesture_begin_gala_gesture_backend_on_begin (GalaGestureBackend* _sender,
                                                                           gdouble delta,
                                                                           guint64 time,
                                                                           gpointer self);
static void gala_gesture_controller_gesture_update (GalaGestureController* self,
                                             gdouble percentage,
                                             guint64 elapsed_time);
static void _gala_gesture_controller_gesture_update_gala_gesture_backend_on_update (GalaGestureBackend* _sender,
                                                                             gdouble delta,
                                                                             guint64 time,
                                                                             gpointer self);
static void gala_gesture_controller_gesture_end (GalaGestureController* self,
                                          gdouble percentage,
                                          guint64 elapsed_time);
static void _gala_gesture_controller_gesture_end_gala_gesture_backend_on_end (GalaGestureBackend* _sender,
                                                                       gdouble delta,
                                                                       guint64 time,
                                                                       gpointer self);
VALA_EXTERN void gala_gesture_controller_enable_scroll (GalaGestureController* self,
                                            ClutterActor* actor,
                                            ClutterOrientation orientation);
VALA_EXTERN GalaGestureSettings* gala_gesture_settings_new (void);
VALA_EXTERN GalaGestureSettings* gala_gesture_settings_construct (GType object_type);
VALA_EXTERN GType gala_gesture_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureSettings, g_object_unref)
VALA_EXTERN GalaScrollBackend* gala_scroll_backend_new (ClutterActor* actor,
                                            ClutterOrientation orientation,
                                            GalaGestureSettings* settings);
VALA_EXTERN GalaScrollBackend* gala_scroll_backend_construct (GType object_type,
                                                  ClutterActor* actor,
                                                  ClutterOrientation orientation,
                                                  GalaGestureSettings* settings);
static void gala_gesture_controller_prepare (GalaGestureController* self);
VALA_EXTERN GalaRootTarget* gala_gesture_controller_get_target (GalaGestureController* self);
VALA_EXTERN void gala_gesture_target_propagate (GalaGestureTarget* self,
                                    GalaGestureTargetUpdateType update_type,
                                    GalaGestureAction action,
                                    gdouble progress);
VALA_EXTERN GalaGestureAction gala_gesture_controller_get_action (GalaGestureController* self);
VALA_EXTERN gdouble gala_gesture_controller_get_progress (GalaGestureController* self);
VALA_EXTERN gboolean gala_gesture_controller_get_recognizing (GalaGestureController* self);
VALA_EXTERN gboolean gala_gesture_controller_get_enabled (GalaGestureController* self);
VALA_EXTERN GalaGestureAction gala_gesture_settings_get_action (GalaGesture* gesture,
                                                    GVariant** action_info);
VALA_EXTERN GalaWindowManager* gala_gesture_controller_get_wm (GalaGestureController* self);
static void gala_gesture_controller_set_recognizing (GalaGestureController* self,
                                              gboolean value);
VALA_EXTERN GType gala_gesture_direction_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean gala_gesture_controller_get_snap (GalaGestureController* self);
static void gala_gesture_controller_finish (GalaGestureController* self,
                                     gdouble velocity,
                                     gdouble to);
static void gala_gesture_controller_update_gesture_progress (GalaGestureController* self,
                                                      gdouble percentage,
                                                      gdouble percentage_delta);
VALA_EXTERN gdouble gala_gesture_controller_get_overshoot_lower_clamp (GalaGestureController* self);
VALA_EXTERN gdouble gala_gesture_controller_get_overshoot_upper_clamp (GalaGestureController* self);
VALA_EXTERN void gala_gesture_controller_set_progress (GalaGestureController* self,
                                           gdouble value);
static void gala_gesture_controller_finished (GalaGestureController* self,
                                       gboolean is_finished);
VALA_EXTERN ClutterActor* gala_gesture_target_get_actor (GalaGestureTarget* self);
VALA_EXTERN GalaSpringTimeline* gala_spring_timeline_new (ClutterActor* actor,
                                              gdouble value_from,
                                              gdouble value_to,
                                              gdouble initial_velocity,
                                              gdouble damping_ratio,
                                              gdouble mass,
                                              gdouble stiffness);
VALA_EXTERN GalaSpringTimeline* gala_spring_timeline_construct (GType object_type,
                                                    ClutterActor* actor,
                                                    gdouble value_from,
                                                    gdouble value_to,
                                                    gdouble initial_velocity,
                                                    gdouble damping_ratio,
                                                    gdouble mass,
                                                    gdouble stiffness);
static void __lambda9_ (GalaGestureController* self,
                 gdouble value);
static void ___lambda9__gala_spring_timeline_progress (GalaSpringTimeline* _sender,
                                                gdouble value,
                                                gpointer self);
static void _gala_gesture_controller_finished_clutter_timeline_stopped (ClutterTimeline* _sender,
                                                                 gboolean is_finished,
                                                                 gpointer self);
VALA_EXTERN void gala_gesture_controller_goto (GalaGestureController* self,
                                   gdouble to);
VALA_EXTERN gdouble gala_spring_timeline_get_value_to (GalaSpringTimeline* self);
VALA_EXTERN void gala_gesture_controller_cancel_gesture (GalaGestureController* self);
VALA_EXTERN void gala_gesture_backend_cancel_gesture (GalaGestureBackend* self);
static void gala_gesture_controller_set_action (GalaGestureController* self,
                                         GalaGestureAction value);
static void gala_gesture_controller_set_wm (GalaGestureController* self,
                                     GalaWindowManager* value);
VALA_EXTERN GVariant* gala_gesture_controller_get_action_info (GalaGestureController* self);
VALA_EXTERN gdouble gala_gesture_controller_get_distance (GalaGestureController* self);
VALA_EXTERN void gala_gesture_controller_set_distance (GalaGestureController* self,
                                           gdouble value);
VALA_EXTERN void gala_gesture_controller_set_overshoot_lower_clamp (GalaGestureController* self,
                                                        gdouble value);
VALA_EXTERN void gala_gesture_controller_set_overshoot_upper_clamp (GalaGestureController* self,
                                                        gdouble value);
VALA_EXTERN void gala_gesture_controller_set_snap (GalaGestureController* self,
                                       gboolean value);
VALA_EXTERN void gala_gesture_controller_set_enabled (GalaGestureController* self,
                                          gboolean value);
static void gala_gesture_controller_finalize (GObject * obj);
static GType gala_gesture_controller_get_type_once (void);
static void _vala_gala_gesture_controller_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_gala_gesture_controller_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static inline gpointer
gala_gesture_controller_get_instance_private (GalaGestureController* self)
{
	return G_STRUCT_MEMBER_P (self, GalaGestureController_private_offset);
}

GalaGestureController*
gala_gesture_controller_construct (GType object_type,
                                   GalaGestureAction action,
                                   GalaWindowManager* wm)
{
	GalaGestureController * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	self = (GalaGestureController*) g_object_new (object_type, "action", action, "wm", wm, NULL);
	return self;
}

GalaGestureController*
gala_gesture_controller_new (GalaGestureAction action,
                             GalaWindowManager* wm)
{
	return gala_gesture_controller_construct (GALA_TYPE_GESTURE_CONTROLLER, action, wm);
}

/**
     * Do not call this directly, use {@link RooTarget.add_controller} instead.
     */
void
gala_gesture_controller_attached (GalaGestureController* self,
                                  GalaRootTarget* target)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (target != NULL);
	g_object_ref ((GObject*) self);
	gala_gesture_controller_set_target (self, target);
}

void
gala_gesture_controller_detached (GalaGestureController* self)
{
	g_return_if_fail (self != NULL);
	self->priv->_target = NULL;
	g_object_unref ((GObject*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_gala_gesture_controller_gesture_detected_gala_gesture_backend_on_gesture_detected (GalaGestureBackend* _sender,
                                                                                    GalaGesture* gesture,
                                                                                    guint32 timestamp,
                                                                                    gpointer self)
{
	gboolean result;
	result = gala_gesture_controller_gesture_detected ((GalaGestureController*) self, _sender, gesture, timestamp);
	return result;
}

static void
_gala_gesture_controller_gesture_begin_gala_gesture_backend_on_begin (GalaGestureBackend* _sender,
                                                                      gdouble delta,
                                                                      guint64 time,
                                                                      gpointer self)
{
	gala_gesture_controller_gesture_begin ((GalaGestureController*) self, delta, time);
}

static void
_gala_gesture_controller_gesture_update_gala_gesture_backend_on_update (GalaGestureBackend* _sender,
                                                                        gdouble delta,
                                                                        guint64 time,
                                                                        gpointer self)
{
	gala_gesture_controller_gesture_update ((GalaGestureController*) self, delta, time);
}

static void
_gala_gesture_controller_gesture_end_gala_gesture_backend_on_end (GalaGestureBackend* _sender,
                                                                  gdouble delta,
                                                                  guint64 time,
                                                                  gpointer self)
{
	gala_gesture_controller_gesture_end ((GalaGestureController*) self, delta, time);
}

void
gala_gesture_controller_enable_touchpad (GalaGestureController* self)
{
	GalaToucheggBackend* _tmp0_;
	GalaToucheggBackend* _tmp1_;
	GalaToucheggBackend* _tmp2_;
	GalaToucheggBackend* _tmp3_;
	GalaToucheggBackend* _tmp4_;
	GalaToucheggBackend* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gala_touchegg_backend_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->touchpad_backend);
	self->priv->touchpad_backend = _tmp1_;
	_tmp2_ = self->priv->touchpad_backend;
	g_signal_connect_object ((GalaGestureBackend*) _tmp2_, "on-gesture-detected", (GCallback) _gala_gesture_controller_gesture_detected_gala_gesture_backend_on_gesture_detected, self, 0);
	_tmp3_ = self->priv->touchpad_backend;
	g_signal_connect_object ((GalaGestureBackend*) _tmp3_, "on-begin", (GCallback) _gala_gesture_controller_gesture_begin_gala_gesture_backend_on_begin, self, 0);
	_tmp4_ = self->priv->touchpad_backend;
	g_signal_connect_object ((GalaGestureBackend*) _tmp4_, "on-update", (GCallback) _gala_gesture_controller_gesture_update_gala_gesture_backend_on_update, self, 0);
	_tmp5_ = self->priv->touchpad_backend;
	g_signal_connect_object ((GalaGestureBackend*) _tmp5_, "on-end", (GCallback) _gala_gesture_controller_gesture_end_gala_gesture_backend_on_end, self, 0);
}

void
gala_gesture_controller_enable_scroll (GalaGestureController* self,
                                       ClutterActor* actor,
                                       ClutterOrientation orientation)
{
	GalaGestureSettings* _tmp0_;
	GalaGestureSettings* _tmp1_;
	GalaScrollBackend* _tmp2_;
	GalaScrollBackend* _tmp3_;
	GalaScrollBackend* _tmp4_;
	GalaScrollBackend* _tmp5_;
	GalaScrollBackend* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (actor != NULL);
	_tmp0_ = gala_gesture_settings_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = gala_scroll_backend_new (actor, orientation, _tmp1_);
	_g_object_unref0 (self->priv->scroll_backend);
	self->priv->scroll_backend = _tmp2_;
	_g_object_unref0 (_tmp1_);
	_tmp3_ = self->priv->scroll_backend;
	g_signal_connect_object ((GalaGestureBackend*) _tmp3_, "on-gesture-detected", (GCallback) _gala_gesture_controller_gesture_detected_gala_gesture_backend_on_gesture_detected, self, 0);
	_tmp4_ = self->priv->scroll_backend;
	g_signal_connect_object ((GalaGestureBackend*) _tmp4_, "on-begin", (GCallback) _gala_gesture_controller_gesture_begin_gala_gesture_backend_on_begin, self, 0);
	_tmp5_ = self->priv->scroll_backend;
	g_signal_connect_object ((GalaGestureBackend*) _tmp5_, "on-update", (GCallback) _gala_gesture_controller_gesture_update_gala_gesture_backend_on_update, self, 0);
	_tmp6_ = self->priv->scroll_backend;
	g_signal_connect_object ((GalaGestureBackend*) _tmp6_, "on-end", (GCallback) _gala_gesture_controller_gesture_end_gala_gesture_backend_on_end, self, 0);
}

static void
gala_gesture_controller_prepare (GalaGestureController* self)
{
	GalaSpringTimeline* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timeline;
	if (_tmp0_ != NULL) {
		_g_object_unref0 (self->priv->timeline);
		self->priv->timeline = NULL;
	} else {
		GalaRootTarget* _tmp1_;
		GalaRootTarget* _tmp2_;
		GalaGestureAction _tmp3_;
		gdouble _tmp4_;
		gdouble _tmp5_;
		_tmp1_ = gala_gesture_controller_get_target (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = self->priv->_action;
		_tmp4_ = gala_gesture_controller_get_progress (self);
		_tmp5_ = _tmp4_;
		gala_gesture_target_propagate ((GalaGestureTarget*) _tmp2_, GALA_GESTURE_TARGET_UPDATE_TYPE_START, _tmp3_, _tmp5_);
	}
}

static gboolean
gala_gesture_controller_gesture_detected (GalaGestureController* self,
                                          GalaGestureBackend* backend,
                                          GalaGesture* gesture,
                                          guint32 timestamp)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GalaGestureAction recognized_action = 0;
	GVariant* _tmp4_ = NULL;
	GalaGestureAction _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GalaWindowManager* _tmp8_;
	gboolean _tmp12_;
	gboolean _tmp20_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (backend != NULL, FALSE);
	g_return_val_if_fail (gesture != NULL, FALSE);
	_tmp1_ = self->priv->_recognizing;
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = gala_gesture_controller_get_enabled (self);
		_tmp3_ = _tmp2_;
		_tmp0_ = !_tmp3_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = gala_gesture_settings_get_action (gesture, &_tmp4_);
	_g_variant_unref0 (self->priv->_action_info);
	self->priv->_action_info = _tmp4_;
	recognized_action = _tmp5_;
	_tmp8_ = self->priv->_wm;
	if (!gala_window_manager_filter_action (_tmp8_, recognized_action)) {
		GalaGestureAction _tmp9_;
		_tmp9_ = self->priv->_action;
		_tmp7_ = recognized_action == _tmp9_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		gboolean _tmp10_ = FALSE;
		GalaScrollBackend* _tmp11_;
		_tmp11_ = self->priv->scroll_backend;
		if (backend == G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GALA_TYPE_GESTURE_BACKEND, GalaGestureBackend)) {
			_tmp10_ = recognized_action == GALA_GESTURE_ACTION_NONE;
		} else {
			_tmp10_ = FALSE;
		}
		_tmp6_ = _tmp10_;
	}
	gala_gesture_controller_set_recognizing (self, _tmp6_);
	_tmp12_ = self->priv->_recognizing;
	if (_tmp12_) {
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_;
		GalaGestureBackend* _tmp19_;
		if (gesture->direction == GALA_GESTURE_DIRECTION_UP) {
			_tmp14_ = TRUE;
		} else {
			_tmp14_ = gesture->direction == GALA_GESTURE_DIRECTION_RIGHT;
		}
		if (_tmp14_) {
			_tmp13_ = TRUE;
		} else {
			_tmp13_ = gesture->direction == GALA_GESTURE_DIRECTION_OUT;
		}
		if (_tmp13_) {
			self->priv->direction_multiplier = 1;
		} else {
			self->priv->direction_multiplier = -1;
		}
		_tmp16_ = self->priv->_snap;
		if (_tmp16_) {
			_tmp15_ = !meta_prefs_get_gnome_animations ();
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			gdouble _tmp17_;
			gdouble _tmp18_;
			gala_gesture_controller_set_recognizing (self, FALSE);
			gala_gesture_controller_prepare (self);
			_tmp17_ = gala_gesture_controller_get_progress (self);
			_tmp18_ = _tmp17_;
			gala_gesture_controller_finish (self, (gdouble) 0, _tmp18_ + self->priv->direction_multiplier);
		}
		_tmp19_ = _g_object_ref0 (backend);
		_g_object_unref0 (self->priv->recognizing_backend);
		self->priv->recognizing_backend = _tmp19_;
	}
	_tmp20_ = self->priv->_recognizing;
	result = _tmp20_;
	return result;
}

static void
gala_gesture_controller_gesture_begin (GalaGestureController* self,
                                       gdouble percentage,
                                       guint64 elapsed_time)
{
	gboolean _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_recognizing;
	if (!_tmp0_) {
		return;
	}
	gala_gesture_controller_prepare (self);
	_tmp1_ = gala_gesture_controller_get_progress (self);
	_tmp2_ = _tmp1_;
	self->priv->gesture_progress = _tmp2_;
	self->priv->previous_percentage = percentage;
	self->priv->previous_time = elapsed_time;
}

static void
gala_gesture_controller_gesture_update (GalaGestureController* self,
                                        gdouble percentage,
                                        guint64 elapsed_time)
{
	gboolean _tmp0_;
	gdouble updated_delta = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_recognizing;
	if (!_tmp0_) {
		return;
	}
	updated_delta = self->priv->previous_delta;
	if (elapsed_time != self->priv->previous_time) {
		gdouble distance = 0.0;
		gdouble time = 0.0;
		distance = percentage - self->priv->previous_percentage;
		time = (gdouble) (elapsed_time - self->priv->previous_time);
		self->priv->velocity = distance / time;
		if (self->priv->velocity > GALA_GESTURE_CONTROLLER_MAX_VELOCITY) {
			gdouble used_percentage = 0.0;
			self->priv->velocity = GALA_GESTURE_CONTROLLER_MAX_VELOCITY;
			used_percentage = (GALA_GESTURE_CONTROLLER_MAX_VELOCITY * time) + self->priv->previous_percentage;
			updated_delta += percentage - used_percentage;
		}
	}
	gala_gesture_controller_update_gesture_progress (self, percentage, updated_delta);
	self->priv->previous_percentage = percentage;
	self->priv->previous_time = elapsed_time;
	self->priv->previous_delta = updated_delta;
}

static void
gala_gesture_controller_gesture_end (GalaGestureController* self,
                                     gdouble percentage,
                                     guint64 elapsed_time)
{
	gboolean _tmp0_;
	gdouble to = 0.0;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_recognizing;
	if (!_tmp0_) {
		return;
	}
	gala_gesture_controller_set_recognizing (self, FALSE);
	gala_gesture_controller_update_gesture_progress (self, percentage, self->priv->previous_delta);
	_tmp1_ = gala_gesture_controller_get_progress (self);
	_tmp2_ = _tmp1_;
	to = _tmp2_;
	_tmp3_ = self->priv->_snap;
	if (_tmp3_) {
		if (fabs (self->priv->velocity) > GALA_GESTURE_CONTROLLER_SUCCESS_VELOCITY_THRESHOLD) {
			gint _tmp4_ = 0;
			if (self->priv->velocity > ((gdouble) 0)) {
				_tmp4_ = self->priv->direction_multiplier;
			} else {
				_tmp4_ = -self->priv->direction_multiplier;
			}
			to += _tmp4_ * 0.5;
		}
		to = round (to);
	}
	gala_gesture_controller_finish (self, self->priv->velocity * self->priv->direction_multiplier, to);
	self->priv->gesture_progress = (gdouble) 0;
	self->priv->previous_percentage = (gdouble) 0;
	self->priv->previous_time = (guint64) 0;
	self->priv->previous_delta = (gdouble) 0;
	self->priv->velocity = (gdouble) 0;
	self->priv->direction_multiplier = 0;
}

static void
gala_gesture_controller_update_gesture_progress (GalaGestureController* self,
                                                 gdouble percentage,
                                                 gdouble percentage_delta)
{
	gint lower_clamp_int = 0;
	gdouble _tmp0_;
	gint upper_clamp_int = 0;
	gdouble _tmp1_;
	gdouble stretched_percentage = 0.0;
	gdouble clamped = 0.0;
	g_return_if_fail (self != NULL);
	self->priv->gesture_progress = self->priv->gesture_progress + (((percentage - percentage_delta) - (self->priv->previous_percentage - self->priv->previous_delta)) * self->priv->direction_multiplier);
	_tmp0_ = self->priv->_overshoot_lower_clamp;
	lower_clamp_int = (gint) _tmp0_;
	_tmp1_ = self->priv->_overshoot_upper_clamp;
	upper_clamp_int = (gint) _tmp1_;
	stretched_percentage = (gdouble) 0;
	if (self->priv->gesture_progress < ((gdouble) lower_clamp_int)) {
		gdouble _tmp2_;
		_tmp2_ = self->priv->_overshoot_lower_clamp;
		stretched_percentage = (self->priv->gesture_progress - lower_clamp_int) * (-(_tmp2_ - lower_clamp_int));
	} else {
		if (self->priv->gesture_progress > ((gdouble) upper_clamp_int)) {
			gdouble _tmp3_;
			_tmp3_ = self->priv->_overshoot_upper_clamp;
			stretched_percentage = (self->priv->gesture_progress - upper_clamp_int) * (_tmp3_ - upper_clamp_int);
		}
	}
	clamped = CLAMP (self->priv->gesture_progress, (gdouble) lower_clamp_int, (gdouble) upper_clamp_int);
	gala_gesture_controller_set_progress (self, clamped + stretched_percentage);
}

static void
__lambda9_ (GalaGestureController* self,
            gdouble value)
{
	gala_gesture_controller_set_progress (self, value);
}

static void
___lambda9__gala_spring_timeline_progress (GalaSpringTimeline* _sender,
                                           gdouble value,
                                           gpointer self)
{
	__lambda9_ ((GalaGestureController*) self, value);
}

static void
_gala_gesture_controller_finished_clutter_timeline_stopped (ClutterTimeline* _sender,
                                                            gboolean is_finished,
                                                            gpointer self)
{
	gala_gesture_controller_finished ((GalaGestureController*) self, is_finished);
}

static void
gala_gesture_controller_finish (GalaGestureController* self,
                                gdouble velocity,
                                gdouble to)
{
	gdouble clamped_to = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	GalaRootTarget* _tmp2_;
	GalaRootTarget* _tmp3_;
	GalaGestureAction _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	GalaSpringTimeline* spring = NULL;
	GalaRootTarget* _tmp7_;
	GalaRootTarget* _tmp8_;
	ClutterActor* _tmp9_;
	ClutterActor* _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	GalaSpringTimeline* _tmp13_;
	GalaSpringTimeline* _tmp14_;
	GalaSpringTimeline* _tmp15_;
	GalaSpringTimeline* _tmp16_;
	GalaSpringTimeline* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_overshoot_lower_clamp;
	_tmp1_ = self->priv->_overshoot_upper_clamp;
	clamped_to = CLAMP (to, (gdouble) ((gint) _tmp0_), (gdouble) ((gint) _tmp1_));
	_tmp2_ = gala_gesture_controller_get_target (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->_action;
	gala_gesture_target_propagate ((GalaGestureTarget*) _tmp3_, GALA_GESTURE_TARGET_UPDATE_TYPE_COMMIT, _tmp4_, clamped_to);
	_tmp5_ = gala_gesture_controller_get_progress (self);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == to) {
		gala_gesture_controller_finished (self, TRUE);
		return;
	}
	if (!meta_prefs_get_gnome_animations ()) {
		gala_gesture_controller_set_progress (self, clamped_to);
		gala_gesture_controller_finished (self, TRUE);
		return;
	}
	_tmp7_ = gala_gesture_controller_get_target (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = gala_gesture_target_get_actor ((GalaGestureTarget*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = gala_gesture_controller_get_progress (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = gala_spring_timeline_new (_tmp10_, _tmp12_, clamped_to, velocity, (gdouble) 1, (gdouble) 1, (gdouble) 500);
	spring = _tmp13_;
	_tmp14_ = spring;
	g_signal_connect_object (_tmp14_, "progress", (GCallback) ___lambda9__gala_spring_timeline_progress, self, 0);
	_tmp15_ = spring;
	g_signal_connect_object ((ClutterTimeline*) _tmp15_, "stopped", (GCallback) _gala_gesture_controller_finished_clutter_timeline_stopped, self, G_CONNECT_AFTER);
	_tmp16_ = spring;
	_tmp17_ = _g_object_ref0 (_tmp16_);
	_g_object_unref0 (self->priv->timeline);
	self->priv->timeline = _tmp17_;
	_g_object_unref0 (spring);
}

static void
gala_gesture_controller_finished (GalaGestureController* self,
                                  gboolean is_finished)
{
	GalaRootTarget* _tmp0_;
	GalaRootTarget* _tmp1_;
	GalaGestureAction _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (is_finished, "is_finished");
	_tmp0_ = gala_gesture_controller_get_target (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_action;
	_tmp3_ = gala_gesture_controller_get_progress (self);
	_tmp4_ = _tmp3_;
	gala_gesture_target_propagate ((GalaGestureTarget*) _tmp1_, GALA_GESTURE_TARGET_UPDATE_TYPE_END, _tmp2_, _tmp4_);
	_g_object_unref0 (self->priv->timeline);
	self->priv->timeline = NULL;
	_g_variant_unref0 (self->priv->_action_info);
	self->priv->_action_info = NULL;
}

/**
     * Animates to the given progress value.
     * If the gesture is currently recognizing, it will do nothing.
     * If that's not what you want, you should call {@link cancel_gesture} first.
     * If you don't want animation but an immediate jump, you should set {@link progress} directly.
     */
void
gala_gesture_controller_goto (GalaGestureController* self,
                              gdouble to)
{
	gdouble clamped_to = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gint _tmp12_ = 0;
	gdouble _tmp13_;
	gdouble _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_overshoot_lower_clamp;
	_tmp1_ = self->priv->_overshoot_upper_clamp;
	clamped_to = CLAMP (to, (gdouble) ((gint) _tmp0_), (gdouble) ((gint) _tmp1_));
	_tmp4_ = gala_gesture_controller_get_progress (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == to) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp6_;
		_tmp6_ = self->priv->_recognizing;
		_tmp3_ = _tmp6_;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp7_ = FALSE;
		GalaSpringTimeline* _tmp8_;
		_tmp8_ = self->priv->timeline;
		if (_tmp8_ != NULL) {
			GalaSpringTimeline* _tmp9_;
			gdouble _tmp10_;
			gdouble _tmp11_;
			_tmp9_ = self->priv->timeline;
			_tmp10_ = gala_spring_timeline_get_value_to (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp7_ = clamped_to == _tmp11_;
		} else {
			_tmp7_ = FALSE;
		}
		_tmp2_ = _tmp7_;
	}
	if (_tmp2_) {
		return;
	}
	gala_gesture_controller_prepare (self);
	_tmp13_ = gala_gesture_controller_get_progress (self);
	_tmp14_ = _tmp13_;
	if (to > _tmp14_) {
		_tmp12_ = 1;
	} else {
		_tmp12_ = -1;
	}
	gala_gesture_controller_finish (self, (gdouble) (_tmp12_ * 1), to);
}

void
gala_gesture_controller_cancel_gesture (GalaGestureController* self)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_recognizing;
	if (_tmp0_) {
		GalaGestureBackend* _tmp1_;
		_tmp1_ = self->priv->recognizing_backend;
		gala_gesture_backend_cancel_gesture (_tmp1_);
		gala_gesture_controller_gesture_end (self, self->priv->previous_percentage, self->priv->previous_time);
	}
}

GalaGestureAction
gala_gesture_controller_get_action (GalaGestureController* self)
{
	GalaGestureAction result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_action;
	return result;
}

static void
gala_gesture_controller_set_action (GalaGestureController* self,
                                    GalaGestureAction value)
{
	GalaGestureAction old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_gesture_controller_get_action (self);
	if (old_value != value) {
		self->priv->_action = value;
		g_object_notify_by_pspec ((GObject *) self, gala_gesture_controller_properties[GALA_GESTURE_CONTROLLER_ACTION_PROPERTY]);
	}
}

GalaWindowManager*
gala_gesture_controller_get_wm (GalaGestureController* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_gesture_controller_set_wm (GalaGestureController* self,
                                GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_gesture_controller_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_gesture_controller_properties[GALA_GESTURE_CONTROLLER_WM_PROPERTY]);
	}
}

GalaRootTarget*
gala_gesture_controller_get_target (GalaGestureController* self)
{
	GalaRootTarget* result;
	GalaRootTarget* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_target;
	result = _tmp0_;
	return result;
}

static void
gala_gesture_controller_set_target (GalaGestureController* self,
                                    GalaRootTarget* value)
{
	GalaRootTarget* _tmp0_;
	GalaGestureAction _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	g_return_if_fail (self != NULL);
	self->priv->_target = value;
	_tmp0_ = self->priv->_target;
	_tmp1_ = self->priv->_action;
	_tmp2_ = gala_gesture_controller_get_progress (self);
	_tmp3_ = _tmp2_;
	gala_gesture_target_propagate ((GalaGestureTarget*) _tmp0_, GALA_GESTURE_TARGET_UPDATE_TYPE_UPDATE, _tmp1_, _tmp3_);
	g_object_notify_by_pspec ((GObject *) self, gala_gesture_controller_properties[GALA_GESTURE_CONTROLLER_TARGET_PROPERTY]);
}

GVariant*
gala_gesture_controller_get_action_info (GalaGestureController* self)
{
	GVariant* result;
	GVariant* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_action_info;
	result = _tmp0_;
	return result;
}

gdouble
gala_gesture_controller_get_distance (GalaGestureController* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_distance;
	return result;
}

void
gala_gesture_controller_set_distance (GalaGestureController* self,
                                      gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_gesture_controller_get_distance (self);
	if (old_value != value) {
		self->priv->_distance = value;
		g_object_notify_by_pspec ((GObject *) self, gala_gesture_controller_properties[GALA_GESTURE_CONTROLLER_DISTANCE_PROPERTY]);
	}
}

gdouble
gala_gesture_controller_get_overshoot_lower_clamp (GalaGestureController* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_overshoot_lower_clamp;
	return result;
}

void
gala_gesture_controller_set_overshoot_lower_clamp (GalaGestureController* self,
                                                   gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_gesture_controller_get_overshoot_lower_clamp (self);
	if (old_value != value) {
		self->priv->_overshoot_lower_clamp = value;
		g_object_notify_by_pspec ((GObject *) self, gala_gesture_controller_properties[GALA_GESTURE_CONTROLLER_OVERSHOOT_LOWER_CLAMP_PROPERTY]);
	}
}

gdouble
gala_gesture_controller_get_overshoot_upper_clamp (GalaGestureController* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_overshoot_upper_clamp;
	return result;
}

void
gala_gesture_controller_set_overshoot_upper_clamp (GalaGestureController* self,
                                                   gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_gesture_controller_get_overshoot_upper_clamp (self);
	if (old_value != value) {
		self->priv->_overshoot_upper_clamp = value;
		g_object_notify_by_pspec ((GObject *) self, gala_gesture_controller_properties[GALA_GESTURE_CONTROLLER_OVERSHOOT_UPPER_CLAMP_PROPERTY]);
	}
}

gboolean
gala_gesture_controller_get_snap (GalaGestureController* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_snap;
	return result;
}

void
gala_gesture_controller_set_snap (GalaGestureController* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_gesture_controller_get_snap (self);
	if (old_value != value) {
		self->priv->_snap = value;
		g_object_notify_by_pspec ((GObject *) self, gala_gesture_controller_properties[GALA_GESTURE_CONTROLLER_SNAP_PROPERTY]);
	}
}

gdouble
gala_gesture_controller_get_progress (GalaGestureController* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_progress;
	return result;
}

void
gala_gesture_controller_set_progress (GalaGestureController* self,
                                      gdouble value)
{
	GalaRootTarget* _tmp0_;
	GalaRootTarget* _tmp1_;
	GalaGestureAction _tmp2_;
	g_return_if_fail (self != NULL);
	self->priv->_progress = value;
	_tmp0_ = gala_gesture_controller_get_target (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_action;
	gala_gesture_target_propagate ((GalaGestureTarget*) _tmp1_, GALA_GESTURE_TARGET_UPDATE_TYPE_UPDATE, _tmp2_, value);
	g_object_notify_by_pspec ((GObject *) self, gala_gesture_controller_properties[GALA_GESTURE_CONTROLLER_PROGRESS_PROPERTY]);
}

gboolean
gala_gesture_controller_get_enabled (GalaGestureController* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_enabled;
	return result;
}

void
gala_gesture_controller_set_enabled (GalaGestureController* self,
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	gala_gesture_controller_cancel_gesture (self);
	self->priv->_enabled = value;
	g_object_notify_by_pspec ((GObject *) self, gala_gesture_controller_properties[GALA_GESTURE_CONTROLLER_ENABLED_PROPERTY]);
}

gboolean
gala_gesture_controller_get_recognizing (GalaGestureController* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_recognizing;
	return result;
}

static void
gala_gesture_controller_set_recognizing (GalaGestureController* self,
                                         gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_gesture_controller_get_recognizing (self);
	if (old_value != value) {
		self->priv->_recognizing = value;
		g_object_notify_by_pspec ((GObject *) self, gala_gesture_controller_properties[GALA_GESTURE_CONTROLLER_RECOGNIZING_PROPERTY]);
	}
}

static void
gala_gesture_controller_class_init (GalaGestureControllerClass * klass,
                                    gpointer klass_data)
{
	gala_gesture_controller_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaGestureController_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_gesture_controller_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_gesture_controller_set_property;
	G_OBJECT_CLASS (klass)->finalize = gala_gesture_controller_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_GESTURE_CONTROLLER_ACTION_PROPERTY, gala_gesture_controller_properties[GALA_GESTURE_CONTROLLER_ACTION_PROPERTY] = g_param_spec_enum ("action", "action", "action", GALA_TYPE_GESTURE_ACTION, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_GESTURE_CONTROLLER_WM_PROPERTY, gala_gesture_controller_properties[GALA_GESTURE_CONTROLLER_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_GESTURE_CONTROLLER_TARGET_PROPERTY, gala_gesture_controller_properties[GALA_GESTURE_CONTROLLER_TARGET_PROPERTY] = g_param_spec_object ("target", "target", "target", GALA_TYPE_ROOT_TARGET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_GESTURE_CONTROLLER_ACTION_INFO_PROPERTY, gala_gesture_controller_properties[GALA_GESTURE_CONTROLLER_ACTION_INFO_PROPERTY] = g_param_spec_variant ("action-info", "action-info", "action-info", G_VARIANT_TYPE_ANY, NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_GESTURE_CONTROLLER_DISTANCE_PROPERTY, gala_gesture_controller_properties[GALA_GESTURE_CONTROLLER_DISTANCE_PROPERTY] = g_param_spec_double ("distance", "distance", "distance", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_GESTURE_CONTROLLER_OVERSHOOT_LOWER_CLAMP_PROPERTY, gala_gesture_controller_properties[GALA_GESTURE_CONTROLLER_OVERSHOOT_LOWER_CLAMP_PROPERTY] = g_param_spec_double ("overshoot-lower-clamp", "overshoot-lower-clamp", "overshoot-lower-clamp", -G_MAXDOUBLE, G_MAXDOUBLE, 0., G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_GESTURE_CONTROLLER_OVERSHOOT_UPPER_CLAMP_PROPERTY, gala_gesture_controller_properties[GALA_GESTURE_CONTROLLER_OVERSHOOT_UPPER_CLAMP_PROPERTY] = g_param_spec_double ("overshoot-upper-clamp", "overshoot-upper-clamp", "overshoot-upper-clamp", -G_MAXDOUBLE, G_MAXDOUBLE, 1., G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	     * When disabled gesture progress will stay where the gesture ended and not snap to full integers values.
	     * This will also cause the controller to emit smooth progress information even if animations are disabled.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_GESTURE_CONTROLLER_SNAP_PROPERTY, gala_gesture_controller_properties[GALA_GESTURE_CONTROLLER_SNAP_PROPERTY] = g_param_spec_boolean ("snap", "snap", "snap", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_GESTURE_CONTROLLER_PROGRESS_PROPERTY, gala_gesture_controller_properties[GALA_GESTURE_CONTROLLER_PROGRESS_PROPERTY] = g_param_spec_double ("progress", "progress", "progress", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_GESTURE_CONTROLLER_ENABLED_PROPERTY, gala_gesture_controller_properties[GALA_GESTURE_CONTROLLER_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_GESTURE_CONTROLLER_RECOGNIZING_PROPERTY, gala_gesture_controller_properties[GALA_GESTURE_CONTROLLER_RECOGNIZING_PROPERTY] = g_param_spec_boolean ("recognizing", "recognizing", "recognizing", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gala_gesture_controller_instance_init (GalaGestureController * self,
                                       gpointer klass)
{
	self->priv = gala_gesture_controller_get_instance_private (self);
	self->priv->_overshoot_lower_clamp = 0.;
	self->priv->_overshoot_upper_clamp = 1.;
	self->priv->_snap = TRUE;
	self->priv->_progress = (gdouble) 0;
	self->priv->_enabled = TRUE;
}

static void
gala_gesture_controller_finalize (GObject * obj)
{
	GalaGestureController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_GESTURE_CONTROLLER, GalaGestureController);
	_g_object_unref0 (self->priv->_wm);
	_g_variant_unref0 (self->priv->_action_info);
	_g_object_unref0 (self->priv->touchpad_backend);
	_g_object_unref0 (self->priv->scroll_backend);
	_g_object_unref0 (self->priv->recognizing_backend);
	_g_object_unref0 (self->priv->timeline);
	G_OBJECT_CLASS (gala_gesture_controller_parent_class)->finalize (obj);
}

/**
 * The class responsible for handling gestures and updating the target. It has a persistent
 * double progress that is either updated by a gesture that is configured with the given
 * {@link GestureAction} from various backends (see the enable_* methods) or manually
 * by calling {@link goto} or setting {@link progress} directly.
 * You shouldn't connect a notify to the progress directly though, but rather use a
 * {@link GestureTarget} implementation.
 * The {@link progress} can be seen as representing the state that the UI the gesture affects
 * is currently in (e.g. 0 for multitasking view closed, 1 for it opend, or 0 for first workspace,
 * -1 for second, -2 for third, etc.). Therefore the progress often needs boundaries which can be
 * set with {@link overshoot_lower_clamp} and {@link overshoot_upper_clamp}. If the values are integers
 * it will be a hard boundary, if they are fractional it will slow the gesture progress when over the
 * limit simulating a kind of spring that pushes against it.
 * Note that the progress snaps to full integer values after a gesture ends.
 */
 G_GNUC_NO_INLINE static GType
gala_gesture_controller_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaGestureControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_gesture_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaGestureController), 0, (GInstanceInitFunc) gala_gesture_controller_instance_init, NULL };
	GType gala_gesture_controller_type_id;
	gala_gesture_controller_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaGestureController", &g_define_type_info, 0);
	GalaGestureController_private_offset = g_type_add_instance_private (gala_gesture_controller_type_id, sizeof (GalaGestureControllerPrivate));
	return gala_gesture_controller_type_id;
}

GType
gala_gesture_controller_get_type (void)
{
	static gsize gala_gesture_controller_type_id__once = 0;
	if (g_once_init_enter (&gala_gesture_controller_type_id__once)) {
		GType gala_gesture_controller_type_id;
		gala_gesture_controller_type_id = gala_gesture_controller_get_type_once ();
		g_once_init_leave (&gala_gesture_controller_type_id__once, gala_gesture_controller_type_id);
	}
	return gala_gesture_controller_type_id__once;
}

static void
_vala_gala_gesture_controller_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	GalaGestureController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_GESTURE_CONTROLLER, GalaGestureController);
	switch (property_id) {
		case GALA_GESTURE_CONTROLLER_ACTION_PROPERTY:
		g_value_set_enum (value, gala_gesture_controller_get_action (self));
		break;
		case GALA_GESTURE_CONTROLLER_WM_PROPERTY:
		g_value_set_object (value, gala_gesture_controller_get_wm (self));
		break;
		case GALA_GESTURE_CONTROLLER_TARGET_PROPERTY:
		g_value_set_object (value, gala_gesture_controller_get_target (self));
		break;
		case GALA_GESTURE_CONTROLLER_ACTION_INFO_PROPERTY:
		g_value_set_variant (value, gala_gesture_controller_get_action_info (self));
		break;
		case GALA_GESTURE_CONTROLLER_DISTANCE_PROPERTY:
		g_value_set_double (value, gala_gesture_controller_get_distance (self));
		break;
		case GALA_GESTURE_CONTROLLER_OVERSHOOT_LOWER_CLAMP_PROPERTY:
		g_value_set_double (value, gala_gesture_controller_get_overshoot_lower_clamp (self));
		break;
		case GALA_GESTURE_CONTROLLER_OVERSHOOT_UPPER_CLAMP_PROPERTY:
		g_value_set_double (value, gala_gesture_controller_get_overshoot_upper_clamp (self));
		break;
		case GALA_GESTURE_CONTROLLER_SNAP_PROPERTY:
		g_value_set_boolean (value, gala_gesture_controller_get_snap (self));
		break;
		case GALA_GESTURE_CONTROLLER_PROGRESS_PROPERTY:
		g_value_set_double (value, gala_gesture_controller_get_progress (self));
		break;
		case GALA_GESTURE_CONTROLLER_ENABLED_PROPERTY:
		g_value_set_boolean (value, gala_gesture_controller_get_enabled (self));
		break;
		case GALA_GESTURE_CONTROLLER_RECOGNIZING_PROPERTY:
		g_value_set_boolean (value, gala_gesture_controller_get_recognizing (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_gesture_controller_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	GalaGestureController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_GESTURE_CONTROLLER, GalaGestureController);
	switch (property_id) {
		case GALA_GESTURE_CONTROLLER_ACTION_PROPERTY:
		gala_gesture_controller_set_action (self, g_value_get_enum (value));
		break;
		case GALA_GESTURE_CONTROLLER_WM_PROPERTY:
		gala_gesture_controller_set_wm (self, g_value_get_object (value));
		break;
		case GALA_GESTURE_CONTROLLER_TARGET_PROPERTY:
		gala_gesture_controller_set_target (self, g_value_get_object (value));
		break;
		case GALA_GESTURE_CONTROLLER_DISTANCE_PROPERTY:
		gala_gesture_controller_set_distance (self, g_value_get_double (value));
		break;
		case GALA_GESTURE_CONTROLLER_OVERSHOOT_LOWER_CLAMP_PROPERTY:
		gala_gesture_controller_set_overshoot_lower_clamp (self, g_value_get_double (value));
		break;
		case GALA_GESTURE_CONTROLLER_OVERSHOOT_UPPER_CLAMP_PROPERTY:
		gala_gesture_controller_set_overshoot_upper_clamp (self, g_value_get_double (value));
		break;
		case GALA_GESTURE_CONTROLLER_SNAP_PROPERTY:
		gala_gesture_controller_set_snap (self, g_value_get_boolean (value));
		break;
		case GALA_GESTURE_CONTROLLER_PROGRESS_PROPERTY:
		gala_gesture_controller_set_progress (self, g_value_get_double (value));
		break;
		case GALA_GESTURE_CONTROLLER_ENABLED_PROPERTY:
		gala_gesture_controller_set_enabled (self, g_value_get_boolean (value));
		break;
		case GALA_GESTURE_CONTROLLER_RECOGNIZING_PROPERTY:
		gala_gesture_controller_set_recognizing (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

