/* ofono-persona.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ofono-persona.vala, do not modify */

/*
 * Copyright (C) 2012 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *          Jeremy Whiting <jeremy.whiting@collabora.co.uk>
 *
 * Based on kf-persona.vala by:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include "ofono.h"
#include "folks/folks.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "folks/small-set.h"
#include <glib-object.h>
#include <gee.h>
#include <libebook-contacts/libebook-contacts.h>
#include "folks/small-set-internal.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FOLKS_BACKENDS_OFONO_PERSONA_0_PROPERTY,
	FOLKS_BACKENDS_OFONO_PERSONA_LINKABLE_PROPERTIES_PROPERTY,
	FOLKS_BACKENDS_OFONO_PERSONA_WRITEABLE_PROPERTIES_PROPERTY,
	FOLKS_BACKENDS_OFONO_PERSONA_PHONE_NUMBERS_PROPERTY,
	FOLKS_BACKENDS_OFONO_PERSONA_STRUCTURED_NAME_PROPERTY,
	FOLKS_BACKENDS_OFONO_PERSONA_FULL_NAME_PROPERTY,
	FOLKS_BACKENDS_OFONO_PERSONA_NICKNAME_PROPERTY,
	FOLKS_BACKENDS_OFONO_PERSONA_EMAIL_ADDRESSES_PROPERTY,
	FOLKS_BACKENDS_OFONO_PERSONA_NUM_PROPERTIES
};
static GParamSpec* folks_backends_ofono_persona_properties[FOLKS_BACKENDS_OFONO_PERSONA_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define __vala_EVCardAttribute_free0(var) ((var == NULL) ? NULL : (var = (_vala_EVCardAttribute_free (var), NULL)))

struct _FolksBackendsOfonoPersonaPrivate {
	FolksStructuredName* _structured_name;
	gchar* _full_name;
	gchar* _nickname;
	FolksSmallSet* _phone_numbers;
	GeeSet* _phone_numbers_ro;
	FolksSmallSet* _email_addresses;
	GeeSet* _email_addresses_ro;
};

static gint FolksBackendsOfonoPersona_private_offset;
static gpointer folks_backends_ofono_persona_parent_class = NULL;
static gchar** folks_backends_ofono_persona__writeable_properties;
static gint folks_backends_ofono_persona__writeable_properties_length1;
static gchar** folks_backends_ofono_persona__writeable_properties = NULL;
static gint folks_backends_ofono_persona__writeable_properties_length1 = 0;
static gint _folks_backends_ofono_persona__writeable_properties_size_ = 0;
static FolksEmailDetailsIface * folks_backends_ofono_persona_folks_email_details_parent_iface = NULL;
static FolksNameDetailsIface * folks_backends_ofono_persona_folks_name_details_parent_iface = NULL;
static FolksPhoneDetailsIface * folks_backends_ofono_persona_folks_phone_details_parent_iface = NULL;

static void _folks_backends_ofono_persona_set_vcard (FolksBackendsOfonoPersona* self,
                                              const gchar* vcard);
static EVCardAttribute* _vala_EVCardAttribute_copy (EVCardAttribute* self);
static void _vala_EVCardAttribute_free (EVCardAttribute* self);
static void folks_backends_ofono_persona_real_linkable_property_to_links (FolksPersona* base,
                                                                   const gchar* prop_name,
                                                                   FolksPersonaLinkablePropertyCallback callback,
                                                                   gpointer callback_target);
static GObject * folks_backends_ofono_persona_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
static void folks_backends_ofono_persona_finalize (GObject * obj);
static GType folks_backends_ofono_persona_get_type_once (void);
static void _vala_folks_backends_ofono_persona_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_folks_backends_ofono_persona_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);

static const gchar* FOLKS_BACKENDS_OFONO_PERSONA__linkable_properties[3] = {"phone-numbers", "email-addresses", NULL};

static inline gpointer
folks_backends_ofono_persona_get_instance_private (FolksBackendsOfonoPersona* self)
{
	return G_STRUCT_MEMBER_P (self, FolksBackendsOfonoPersona_private_offset);
}

/**
   * Create a new persona.
   *
   * Create a new persona for the given vCard contents.
   *
   * @param vcard the vCard data to use for this {@link Persona}.
   * @param store the {@link PersonaStore} this {@link Persona} belongs to.
   *
   * @since 0.9.0
   */
FolksBackendsOfonoPersona*
folks_backends_ofono_persona_construct (GType object_type,
                                        const gchar* vcard,
                                        FolksPersonaStore* store)
{
	FolksBackendsOfonoPersona * self = NULL;
	gchar* iid = NULL;
	gchar* _tmp0_;
	gchar* uid = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (vcard != NULL, NULL);
	g_return_val_if_fail (store != NULL, NULL);
	_tmp0_ = g_compute_checksum_for_string (G_CHECKSUM_SHA1, vcard, (gsize) -1);
	iid = _tmp0_;
	_tmp1_ = folks_persona_store_get_id (store);
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_persona_build_uid ("ofono", _tmp2_, iid);
	uid = _tmp3_;
	self = (FolksBackendsOfonoPersona*) g_object_new (object_type, "display-id", iid, "iid", iid, "uid", uid, "store", store, "is-user", FALSE, NULL);
	_folks_backends_ofono_persona_set_vcard (self, vcard);
	_g_free0 (uid);
	_g_free0 (iid);
	return self;
}

FolksBackendsOfonoPersona*
folks_backends_ofono_persona_new (const gchar* vcard,
                                  FolksPersonaStore* store)
{
	return folks_backends_ofono_persona_construct (FOLKS_BACKENDS_OFONO_TYPE_PERSONA, vcard, store);
}

static EVCardAttribute*
_vala_EVCardAttribute_copy (EVCardAttribute* self)
{
	return g_boxed_copy (e_vcard_attribute_get_type (), self);
}

static gpointer
__vala_EVCardAttribute_copy0 (gpointer self)
{
	return self ? _vala_EVCardAttribute_copy (self) : NULL;
}

static void
_vala_EVCardAttribute_free (EVCardAttribute* self)
{
	g_boxed_free (e_vcard_attribute_get_type (), self);
}

static void
_folks_backends_ofono_persona_set_vcard (FolksBackendsOfonoPersona* self,
                                         const gchar* vcard)
{
	EVCard* card = NULL;
	EVCard* _tmp0_;
	EVCardAttribute* attribute = NULL;
	EVCard* _tmp1_;
	EVCardAttribute* _tmp2_;
	EVCardAttribute* _tmp3_;
	EVCardAttribute* _tmp4_;
	EVCard* _tmp12_;
	EVCardAttribute* _tmp13_;
	EVCardAttribute* _tmp14_;
	EVCardAttribute* _tmp15_;
	EVCard* _tmp21_;
	EVCardAttribute* _tmp22_;
	EVCardAttribute* _tmp23_;
	EVCardAttribute* _tmp24_;
	EVCard* _tmp30_;
	EVCardAttribute* _tmp31_;
	EVCardAttribute* _tmp32_;
	EVCardAttribute* _tmp33_;
	EVCard* _tmp54_;
	EVCardAttribute* _tmp55_;
	EVCardAttribute* _tmp56_;
	EVCardAttribute* _tmp57_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (vcard != NULL);
	_tmp0_ = e_vcard_new_from_string (vcard);
	card = _tmp0_;
	_tmp1_ = card;
	_tmp2_ = e_vcard_get_attribute (_tmp1_, "TEL");
	_tmp3_ = __vala_EVCardAttribute_copy0 (_tmp2_);
	attribute = _tmp3_;
	_tmp4_ = attribute;
	if (_tmp4_ != NULL) {
		FolksSmallSet* _tmp5_;
		EVCardAttribute* _tmp6_;
		GString* _tmp7_;
		GString* _tmp8_;
		const gchar* _tmp9_;
		FolksPhoneFieldDetails* _tmp10_;
		FolksPhoneFieldDetails* _tmp11_;
		_tmp5_ = self->priv->_phone_numbers;
		_tmp6_ = attribute;
		_tmp7_ = e_vcard_attribute_get_value_decoded (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_->str;
		_tmp10_ = folks_phone_field_details_new (_tmp9_, NULL);
		_tmp11_ = _tmp10_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp11_);
		_g_object_unref0 (_tmp11_);
		_g_string_free0 (_tmp8_);
	}
	_tmp12_ = card;
	_tmp13_ = e_vcard_get_attribute (_tmp12_, "FN");
	_tmp14_ = __vala_EVCardAttribute_copy0 (_tmp13_);
	__vala_EVCardAttribute_free0 (attribute);
	attribute = _tmp14_;
	_tmp15_ = attribute;
	if (_tmp15_ != NULL) {
		EVCardAttribute* _tmp16_;
		GString* _tmp17_;
		GString* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp16_ = attribute;
		_tmp17_ = e_vcard_attribute_get_value_decoded (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = _tmp18_->str;
		_tmp20_ = g_strdup (_tmp19_);
		_g_free0 (self->priv->_full_name);
		self->priv->_full_name = _tmp20_;
		_g_string_free0 (_tmp18_);
	}
	_tmp21_ = card;
	_tmp22_ = e_vcard_get_attribute (_tmp21_, "NICKNAME");
	_tmp23_ = __vala_EVCardAttribute_copy0 (_tmp22_);
	__vala_EVCardAttribute_free0 (attribute);
	attribute = _tmp23_;
	_tmp24_ = attribute;
	if (_tmp24_ != NULL) {
		EVCardAttribute* _tmp25_;
		GString* _tmp26_;
		GString* _tmp27_;
		const gchar* _tmp28_;
		gchar* _tmp29_;
		_tmp25_ = attribute;
		_tmp26_ = e_vcard_attribute_get_value_decoded (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = _tmp27_->str;
		_tmp29_ = g_strdup (_tmp28_);
		_g_free0 (self->priv->_nickname);
		self->priv->_nickname = _tmp29_;
		_g_string_free0 (_tmp27_);
	}
	_tmp30_ = card;
	_tmp31_ = e_vcard_get_attribute (_tmp30_, "N");
	_tmp32_ = __vala_EVCardAttribute_copy0 (_tmp31_);
	__vala_EVCardAttribute_free0 (attribute);
	attribute = _tmp32_;
	_tmp33_ = attribute;
	if (_tmp33_ != NULL) {
		GList* values = NULL;
		EVCardAttribute* _tmp34_;
		GList* _tmp35_;
		GList* _tmp36_;
		_tmp34_ = attribute;
		_tmp35_ = e_vcard_attribute_get_values_decoded (_tmp34_);
		values = _tmp35_;
		_tmp36_ = values;
		if (g_list_length (_tmp36_) >= ((guint) 5)) {
			GList* _tmp37_;
			gconstpointer _tmp38_;
			const gchar* _tmp39_;
			GList* _tmp40_;
			gconstpointer _tmp41_;
			const gchar* _tmp42_;
			GList* _tmp43_;
			gconstpointer _tmp44_;
			const gchar* _tmp45_;
			GList* _tmp46_;
			gconstpointer _tmp47_;
			const gchar* _tmp48_;
			GList* _tmp49_;
			gconstpointer _tmp50_;
			const gchar* _tmp51_;
			FolksStructuredName* _tmp52_;
			_tmp37_ = values;
			_tmp38_ = g_list_nth_data (_tmp37_, (guint) 0);
			_tmp39_ = ((GString*) _tmp38_)->str;
			_tmp40_ = values;
			_tmp41_ = g_list_nth_data (_tmp40_, (guint) 1);
			_tmp42_ = ((GString*) _tmp41_)->str;
			_tmp43_ = values;
			_tmp44_ = g_list_nth_data (_tmp43_, (guint) 2);
			_tmp45_ = ((GString*) _tmp44_)->str;
			_tmp46_ = values;
			_tmp47_ = g_list_nth_data (_tmp46_, (guint) 3);
			_tmp48_ = ((GString*) _tmp47_)->str;
			_tmp49_ = values;
			_tmp50_ = g_list_nth_data (_tmp49_, (guint) 4);
			_tmp51_ = ((GString*) _tmp50_)->str;
			_tmp52_ = folks_structured_name_new (_tmp39_, _tmp42_, _tmp45_, _tmp48_, _tmp51_);
			_g_object_unref0 (self->priv->_structured_name);
			self->priv->_structured_name = _tmp52_;
		} else {
			GList* _tmp53_;
			_tmp53_ = values;
			g_warning ("ofono-persona.vala:194: Expected 5 components to N value of vcard, got" \
" %u", g_list_length (_tmp53_));
		}
	}
	_tmp54_ = card;
	_tmp55_ = e_vcard_get_attribute (_tmp54_, "EMAIL");
	_tmp56_ = __vala_EVCardAttribute_copy0 (_tmp55_);
	__vala_EVCardAttribute_free0 (attribute);
	attribute = _tmp56_;
	_tmp57_ = attribute;
	if (_tmp57_ != NULL) {
		FolksSmallSet* _tmp58_;
		EVCardAttribute* _tmp59_;
		GString* _tmp60_;
		GString* _tmp61_;
		const gchar* _tmp62_;
		FolksEmailFieldDetails* _tmp63_;
		FolksEmailFieldDetails* _tmp64_;
		_tmp58_ = self->priv->_email_addresses;
		_tmp59_ = attribute;
		_tmp60_ = e_vcard_attribute_get_value_decoded (_tmp59_);
		_tmp61_ = _tmp60_;
		_tmp62_ = _tmp61_->str;
		_tmp63_ = folks_email_field_details_new (_tmp62_, NULL);
		_tmp64_ = _tmp63_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp58_, _tmp64_);
		_g_object_unref0 (_tmp64_);
		_g_string_free0 (_tmp61_);
	}
	__vala_EVCardAttribute_free0 (attribute);
	_g_object_unref0 (card);
}

/**
   * {@inheritDoc}
   */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
folks_backends_ofono_persona_real_linkable_property_to_links (FolksPersona* base,
                                                              const gchar* prop_name,
                                                              FolksPersonaLinkablePropertyCallback callback,
                                                              gpointer callback_target)
{
	FolksBackendsOfonoPersona * self;
	self = (FolksBackendsOfonoPersona*) base;
	g_return_if_fail (prop_name != NULL);
	if (g_strcmp0 (prop_name, "phone-numbers") == 0) {
		{
			FolksSmallSet* _phone_number_list = NULL;
			FolksSmallSet* _tmp0_;
			gint _phone_number_size = 0;
			FolksSmallSet* _tmp1_;
			gint _tmp2_;
			gint _tmp3_;
			gint _phone_number_index = 0;
			_tmp0_ = self->priv->_phone_numbers;
			_phone_number_list = _tmp0_;
			_tmp1_ = _phone_number_list;
			_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
			_tmp3_ = _tmp2_;
			_phone_number_size = _tmp3_;
			_phone_number_index = -1;
			while (TRUE) {
				gint _tmp4_;
				gint _tmp5_;
				FolksPhoneFieldDetails* phone_number = NULL;
				FolksSmallSet* _tmp6_;
				gconstpointer _tmp7_;
				FolksPhoneFieldDetails* _tmp8_;
				FolksPhoneFieldDetails* _tmp9_;
				gconstpointer _tmp10_;
				gconstpointer _tmp11_;
				_phone_number_index = _phone_number_index + 1;
				_tmp4_ = _phone_number_index;
				_tmp5_ = _phone_number_size;
				if (!(_tmp4_ < _tmp5_)) {
					break;
				}
				_tmp6_ = _phone_number_list;
				_tmp7_ = folks_small_set_get (_tmp6_, _phone_number_index);
				_tmp8_ = _g_object_ref0 ((FolksPhoneFieldDetails*) _tmp7_);
				phone_number = _tmp8_;
				_tmp9_ = phone_number;
				_tmp10_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp9_);
				_tmp11_ = _tmp10_;
				if (((const gchar*) _tmp11_) != NULL) {
					FolksPhoneFieldDetails* _tmp12_;
					gconstpointer _tmp13_;
					gconstpointer _tmp14_;
					_tmp12_ = phone_number;
					_tmp13_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp12_);
					_tmp14_ = _tmp13_;
					callback ((const gchar*) _tmp14_, callback_target);
				}
				_g_object_unref0 (phone_number);
			}
		}
	} else {
		if (g_strcmp0 (prop_name, "email-addresses") == 0) {
			{
				FolksSmallSet* _email_address_list = NULL;
				FolksSmallSet* _tmp15_;
				gint _email_address_size = 0;
				FolksSmallSet* _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				gint _email_address_index = 0;
				_tmp15_ = self->priv->_email_addresses;
				_email_address_list = _tmp15_;
				_tmp16_ = _email_address_list;
				_tmp17_ = gee_collection_get_size ((GeeCollection*) _tmp16_);
				_tmp18_ = _tmp17_;
				_email_address_size = _tmp18_;
				_email_address_index = -1;
				while (TRUE) {
					gint _tmp19_;
					gint _tmp20_;
					FolksEmailFieldDetails* email_address = NULL;
					FolksSmallSet* _tmp21_;
					gconstpointer _tmp22_;
					FolksEmailFieldDetails* _tmp23_;
					FolksEmailFieldDetails* _tmp24_;
					gconstpointer _tmp25_;
					gconstpointer _tmp26_;
					_email_address_index = _email_address_index + 1;
					_tmp19_ = _email_address_index;
					_tmp20_ = _email_address_size;
					if (!(_tmp19_ < _tmp20_)) {
						break;
					}
					_tmp21_ = _email_address_list;
					_tmp22_ = folks_small_set_get (_tmp21_, _email_address_index);
					_tmp23_ = _g_object_ref0 ((FolksEmailFieldDetails*) _tmp22_);
					email_address = _tmp23_;
					_tmp24_ = email_address;
					_tmp25_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp24_);
					_tmp26_ = _tmp25_;
					if (((const gchar*) _tmp26_) != NULL) {
						FolksEmailFieldDetails* _tmp27_;
						gconstpointer _tmp28_;
						gconstpointer _tmp29_;
						_tmp27_ = email_address;
						_tmp28_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp27_);
						_tmp29_ = _tmp28_;
						callback ((const gchar*) _tmp29_, callback_target);
					}
					_g_object_unref0 (email_address);
				}
			}
		} else {
			FOLKS_PERSONA_CLASS (folks_backends_ofono_persona_parent_class)->linkable_property_to_links (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_PERSONA, FolksPersona), prop_name, callback, callback_target);
		}
	}
}

static gchar**
folks_backends_ofono_persona_real_get_linkable_properties (FolksPersona* base,
                                                           gint* result_length1)
{
	gchar** result;
	FolksBackendsOfonoPersona* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	self = (FolksBackendsOfonoPersona*) base;
	_tmp0_ = FOLKS_BACKENDS_OFONO_PERSONA__linkable_properties;
	_tmp0__length1 = G_N_ELEMENTS (FOLKS_BACKENDS_OFONO_PERSONA__linkable_properties);
	if (result_length1) {
		*result_length1 = _tmp0__length1;
	}
	result = _tmp0_;
	return result;
}

static gchar**
folks_backends_ofono_persona_real_get_writeable_properties (FolksPersona* base,
                                                            gint* result_length1)
{
	gchar** result;
	FolksBackendsOfonoPersona* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	self = (FolksBackendsOfonoPersona*) base;
	_tmp0_ = folks_backends_ofono_persona__writeable_properties;
	_tmp0__length1 = folks_backends_ofono_persona__writeable_properties_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static GeeSet*
folks_backends_ofono_persona_real_get_phone_numbers (FolksPhoneDetails* base)
{
	GeeSet* result;
	FolksBackendsOfonoPersona* self;
	GeeSet* _tmp0_;
	self = (FolksBackendsOfonoPersona*) base;
	_tmp0_ = self->priv->_phone_numbers_ro;
	result = _tmp0_;
	return result;
}

static void
folks_backends_ofono_persona_real_set_phone_numbers (FolksPhoneDetails* base,
                                                     GeeSet* value)
{
	FolksBackendsOfonoPersona* self;
	self = (FolksBackendsOfonoPersona*) base;
	folks_phone_details_change_phone_numbers ((FolksPhoneDetails*) self, value, NULL, NULL);
}

static FolksStructuredName*
folks_backends_ofono_persona_real_get_structured_name (FolksNameDetails* base)
{
	FolksStructuredName* result;
	FolksBackendsOfonoPersona* self;
	FolksStructuredName* _tmp0_;
	self = (FolksBackendsOfonoPersona*) base;
	_tmp0_ = self->priv->_structured_name;
	result = _tmp0_;
	return result;
}

static void
folks_backends_ofono_persona_real_set_structured_name (FolksNameDetails* base,
                                                       FolksStructuredName* value)
{
	FolksBackendsOfonoPersona* self;
	self = (FolksBackendsOfonoPersona*) base;
	folks_name_details_change_structured_name ((FolksNameDetails*) self, value, NULL, NULL);
}

static const gchar*
folks_backends_ofono_persona_real_get_full_name (FolksNameDetails* base)
{
	const gchar* result;
	FolksBackendsOfonoPersona* self;
	const gchar* _tmp0_;
	self = (FolksBackendsOfonoPersona*) base;
	_tmp0_ = self->priv->_full_name;
	result = _tmp0_;
	return result;
}

static void
folks_backends_ofono_persona_real_set_full_name (FolksNameDetails* base,
                                                 const gchar* value)
{
	FolksBackendsOfonoPersona* self;
	self = (FolksBackendsOfonoPersona*) base;
	folks_name_details_change_full_name ((FolksNameDetails*) self, value, NULL, NULL);
}

static const gchar*
folks_backends_ofono_persona_real_get_nickname (FolksNameDetails* base)
{
	const gchar* result;
	FolksBackendsOfonoPersona* self;
	const gchar* _tmp0_;
	self = (FolksBackendsOfonoPersona*) base;
	_tmp0_ = self->priv->_nickname;
	result = _tmp0_;
	return result;
}

static void
folks_backends_ofono_persona_real_set_nickname (FolksNameDetails* base,
                                                const gchar* value)
{
	FolksBackendsOfonoPersona* self;
	self = (FolksBackendsOfonoPersona*) base;
	folks_name_details_change_nickname ((FolksNameDetails*) self, value, NULL, NULL);
}

static GeeSet*
folks_backends_ofono_persona_real_get_email_addresses (FolksEmailDetails* base)
{
	GeeSet* result;
	FolksBackendsOfonoPersona* self;
	GeeSet* _tmp0_;
	self = (FolksBackendsOfonoPersona*) base;
	_tmp0_ = self->priv->_email_addresses_ro;
	result = _tmp0_;
	return result;
}

static void
folks_backends_ofono_persona_real_set_email_addresses (FolksEmailDetails* base,
                                                       GeeSet* value)
{
	FolksBackendsOfonoPersona* self;
	self = (FolksBackendsOfonoPersona*) base;
	folks_email_details_change_email_addresses ((FolksEmailDetails*) self, value, NULL, NULL);
}

static GObject *
folks_backends_ofono_persona_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FolksBackendsOfonoPersona * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	FolksSmallSet* _tmp6_;
	FolksSmallSet* _tmp7_;
	GeeSet* _tmp8_;
	GeeSet* _tmp9_;
	FolksSmallSet* _tmp10_;
	FolksSmallSet* _tmp11_;
	GeeSet* _tmp12_;
	GeeSet* _tmp13_;
	parent_class = G_OBJECT_CLASS (folks_backends_ofono_persona_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_BACKENDS_OFONO_TYPE_PERSONA, FolksBackendsOfonoPersona);
	_tmp0_ = folks_persona_get_uid ((FolksPersona*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = folks_persona_get_iid ((FolksPersona*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = folks_persona_get_display_id ((FolksPersona*) self);
	_tmp5_ = _tmp4_;
	g_debug ("ofono-persona.vala:148: Adding Ofono Persona '%s' (IID '%s', group '%s" \
"')", _tmp1_, _tmp3_, _tmp5_);
	_tmp6_ = folks_small_set_new (FOLKS_TYPE_PHONE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_phone_numbers);
	self->priv->_phone_numbers = _tmp6_;
	_tmp7_ = self->priv->_phone_numbers;
	_tmp8_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp7_);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (self->priv->_phone_numbers_ro);
	self->priv->_phone_numbers_ro = _tmp9_;
	_tmp10_ = folks_small_set_new (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_email_addresses);
	self->priv->_email_addresses = _tmp10_;
	_tmp11_ = self->priv->_email_addresses;
	_tmp12_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp11_);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (self->priv->_email_addresses_ro);
	self->priv->_email_addresses_ro = _tmp13_;
	return obj;
}

static void
folks_backends_ofono_persona_class_init (FolksBackendsOfonoPersonaClass * klass,
                                         gpointer klass_data)
{
	gchar** _tmp0_;
	folks_backends_ofono_persona_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolksBackendsOfonoPersona_private_offset);
	((FolksPersonaClass *) klass)->linkable_property_to_links = (void (*) (FolksPersona*, const gchar*, FolksPersonaLinkablePropertyCallback, gpointer)) folks_backends_ofono_persona_real_linkable_property_to_links;
	FOLKS_PERSONA_CLASS (klass)->get_linkable_properties = (gchar** (*) (FolksPersona*, gint*)) folks_backends_ofono_persona_real_get_linkable_properties;
	FOLKS_PERSONA_CLASS (klass)->get_writeable_properties = (gchar** (*) (FolksPersona*, gint*)) folks_backends_ofono_persona_real_get_writeable_properties;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backends_ofono_persona_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_backends_ofono_persona_set_property;
	G_OBJECT_CLASS (klass)->constructor = folks_backends_ofono_persona_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_backends_ofono_persona_finalize;
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_PERSONA_LINKABLE_PROPERTIES_PROPERTY, folks_backends_ofono_persona_properties[FOLKS_BACKENDS_OFONO_PERSONA_LINKABLE_PROPERTIES_PROPERTY] = g_param_spec_boxed ("linkable-properties", "linkable-properties", "linkable-properties", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_PERSONA_WRITEABLE_PROPERTIES_PROPERTY, folks_backends_ofono_persona_properties[FOLKS_BACKENDS_OFONO_PERSONA_WRITEABLE_PROPERTIES_PROPERTY] = g_param_spec_boxed ("writeable-properties", "writeable-properties", "writeable-properties", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_PERSONA_PHONE_NUMBERS_PROPERTY, folks_backends_ofono_persona_properties[FOLKS_BACKENDS_OFONO_PERSONA_PHONE_NUMBERS_PROPERTY] = g_param_spec_object ("phone-numbers", "phone-numbers", "phone-numbers", GEE_TYPE_SET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_PERSONA_STRUCTURED_NAME_PROPERTY, folks_backends_ofono_persona_properties[FOLKS_BACKENDS_OFONO_PERSONA_STRUCTURED_NAME_PROPERTY] = g_param_spec_object ("structured-name", "structured-name", "structured-name", FOLKS_TYPE_STRUCTURED_NAME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_PERSONA_FULL_NAME_PROPERTY, folks_backends_ofono_persona_properties[FOLKS_BACKENDS_OFONO_PERSONA_FULL_NAME_PROPERTY] = g_param_spec_string ("full-name", "full-name", "full-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_PERSONA_NICKNAME_PROPERTY, folks_backends_ofono_persona_properties[FOLKS_BACKENDS_OFONO_PERSONA_NICKNAME_PROPERTY] = g_param_spec_string ("nickname", "nickname", "nickname", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_PERSONA_EMAIL_ADDRESSES_PROPERTY, folks_backends_ofono_persona_properties[FOLKS_BACKENDS_OFONO_PERSONA_EMAIL_ADDRESSES_PROPERTY] = g_param_spec_object ("email-addresses", "email-addresses", "email-addresses", GEE_TYPE_SET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	folks_backends_ofono_persona__writeable_properties = _tmp0_;
	folks_backends_ofono_persona__writeable_properties_length1 = 0;
	_folks_backends_ofono_persona__writeable_properties_size_ = folks_backends_ofono_persona__writeable_properties_length1;
}

static void
folks_backends_ofono_persona_folks_email_details_interface_init (FolksEmailDetailsIface * iface,
                                                                 gpointer iface_data)
{
	folks_backends_ofono_persona_folks_email_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_email_addresses = folks_backends_ofono_persona_real_get_email_addresses;
	iface->set_email_addresses = folks_backends_ofono_persona_real_set_email_addresses;
}

static void
folks_backends_ofono_persona_folks_name_details_interface_init (FolksNameDetailsIface * iface,
                                                                gpointer iface_data)
{
	folks_backends_ofono_persona_folks_name_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_structured_name = folks_backends_ofono_persona_real_get_structured_name;
	iface->set_structured_name = folks_backends_ofono_persona_real_set_structured_name;
	iface->get_full_name = folks_backends_ofono_persona_real_get_full_name;
	iface->set_full_name = folks_backends_ofono_persona_real_set_full_name;
	iface->get_nickname = folks_backends_ofono_persona_real_get_nickname;
	iface->set_nickname = folks_backends_ofono_persona_real_set_nickname;
}

static void
folks_backends_ofono_persona_folks_phone_details_interface_init (FolksPhoneDetailsIface * iface,
                                                                 gpointer iface_data)
{
	folks_backends_ofono_persona_folks_phone_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_phone_numbers = folks_backends_ofono_persona_real_get_phone_numbers;
	iface->set_phone_numbers = folks_backends_ofono_persona_real_set_phone_numbers;
}

static void
folks_backends_ofono_persona_instance_init (FolksBackendsOfonoPersona * self,
                                            gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = folks_backends_ofono_persona_get_instance_private (self);
	self->priv->_structured_name = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->_full_name = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_nickname = _tmp1_;
}

static void
folks_backends_ofono_persona_finalize (GObject * obj)
{
	FolksBackendsOfonoPersona * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_BACKENDS_OFONO_TYPE_PERSONA, FolksBackendsOfonoPersona);
	_g_object_unref0 (self->priv->_structured_name);
	_g_free0 (self->priv->_full_name);
	_g_free0 (self->priv->_nickname);
	_g_object_unref0 (self->priv->_phone_numbers);
	_g_object_unref0 (self->priv->_phone_numbers_ro);
	_g_object_unref0 (self->priv->_email_addresses);
	_g_object_unref0 (self->priv->_email_addresses_ro);
	G_OBJECT_CLASS (folks_backends_ofono_persona_parent_class)->finalize (obj);
}

/**
 * A persona subclass which represents a single persona from a simple key file.
 *
 * @since 0.9.0
 */
static GType
folks_backends_ofono_persona_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksBackendsOfonoPersonaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backends_ofono_persona_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendsOfonoPersona), 0, (GInstanceInitFunc) folks_backends_ofono_persona_instance_init, NULL };
	static const GInterfaceInfo folks_email_details_info = { (GInterfaceInitFunc) folks_backends_ofono_persona_folks_email_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo folks_name_details_info = { (GInterfaceInitFunc) folks_backends_ofono_persona_folks_name_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo folks_phone_details_info = { (GInterfaceInitFunc) folks_backends_ofono_persona_folks_phone_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType folks_backends_ofono_persona_type_id;
	folks_backends_ofono_persona_type_id = g_type_register_static (FOLKS_TYPE_PERSONA, "FolksBackendsOfonoPersona", &g_define_type_info, 0);
	g_type_add_interface_static (folks_backends_ofono_persona_type_id, FOLKS_TYPE_EMAIL_DETAILS, &folks_email_details_info);
	g_type_add_interface_static (folks_backends_ofono_persona_type_id, FOLKS_TYPE_NAME_DETAILS, &folks_name_details_info);
	g_type_add_interface_static (folks_backends_ofono_persona_type_id, FOLKS_TYPE_PHONE_DETAILS, &folks_phone_details_info);
	FolksBackendsOfonoPersona_private_offset = g_type_add_instance_private (folks_backends_ofono_persona_type_id, sizeof (FolksBackendsOfonoPersonaPrivate));
	return folks_backends_ofono_persona_type_id;
}

GType
folks_backends_ofono_persona_get_type (void)
{
	static volatile gsize folks_backends_ofono_persona_type_id__once = 0;
	if (g_once_init_enter (&folks_backends_ofono_persona_type_id__once)) {
		GType folks_backends_ofono_persona_type_id;
		folks_backends_ofono_persona_type_id = folks_backends_ofono_persona_get_type_once ();
		g_once_init_leave (&folks_backends_ofono_persona_type_id__once, folks_backends_ofono_persona_type_id);
	}
	return folks_backends_ofono_persona_type_id__once;
}

static void
_vala_folks_backends_ofono_persona_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	FolksBackendsOfonoPersona * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_BACKENDS_OFONO_TYPE_PERSONA, FolksBackendsOfonoPersona);
	switch (property_id) {
		case FOLKS_BACKENDS_OFONO_PERSONA_LINKABLE_PROPERTIES_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_linkable_properties ((FolksPersona*) self, &length));
		}
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_WRITEABLE_PROPERTIES_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_writeable_properties ((FolksPersona*) self, &length));
		}
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_PHONE_NUMBERS_PROPERTY:
		g_value_set_object (value, folks_phone_details_get_phone_numbers ((FolksPhoneDetails*) self));
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_STRUCTURED_NAME_PROPERTY:
		g_value_set_object (value, folks_name_details_get_structured_name ((FolksNameDetails*) self));
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_FULL_NAME_PROPERTY:
		g_value_set_string (value, folks_name_details_get_full_name ((FolksNameDetails*) self));
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_NICKNAME_PROPERTY:
		g_value_set_string (value, folks_name_details_get_nickname ((FolksNameDetails*) self));
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_EMAIL_ADDRESSES_PROPERTY:
		g_value_set_object (value, folks_email_details_get_email_addresses ((FolksEmailDetails*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_folks_backends_ofono_persona_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	FolksBackendsOfonoPersona * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_BACKENDS_OFONO_TYPE_PERSONA, FolksBackendsOfonoPersona);
	switch (property_id) {
		case FOLKS_BACKENDS_OFONO_PERSONA_PHONE_NUMBERS_PROPERTY:
		folks_phone_details_set_phone_numbers ((FolksPhoneDetails*) self, g_value_get_object (value));
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_STRUCTURED_NAME_PROPERTY:
		folks_name_details_set_structured_name ((FolksNameDetails*) self, g_value_get_object (value));
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_FULL_NAME_PROPERTY:
		folks_name_details_set_full_name ((FolksNameDetails*) self, g_value_get_string (value));
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_NICKNAME_PROPERTY:
		folks_name_details_set_nickname ((FolksNameDetails*) self, g_value_get_string (value));
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_EMAIL_ADDRESSES_PROPERTY:
		folks_email_details_set_email_addresses ((FolksEmailDetails*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

