
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "locationbar_loadaction_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_LocationBar_LoadAction_Type = nullptr;
static PyTypeObject *Sbk_LocationBar_LoadAction_TypeF(void)
{
    return _Sbk_LocationBar_LoadAction_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_LocationBar_LoadAction_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::LocationBar::LoadAction >()))
        return -1;

    ::LocationBar::LoadAction *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "LoadAction", 0, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: LoadAction::LoadAction()
    // 1: LoadAction::LoadAction(LocationBar::LoadAction)
    if (numArgs == 0) {
        overloadId = 0; // LoadAction()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_LoadAction_IDX]), (pyArgs[0])))) {
        overloadId = 1; // LoadAction(LocationBar::LoadAction)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_LocationBar_LoadAction_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_LocationBar_LoadAction_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // LoadAction()
        {

            // LoadAction()
            cptr = new ::LocationBar::LoadAction();
            break;
        }
        case 1: // LoadAction(const LocationBar::LoadAction &LoadAction)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::LocationBar::LoadAction cppArg0_local;
            ::LocationBar::LoadAction *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // LoadAction(LocationBar::LoadAction)
                cptr = new ::LocationBar::LoadAction(*cppArg0);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::LocationBar::LoadAction >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_LocationBar_LoadAction_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_LocationBar_LoadAction__copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::LocationBar::LoadAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_LoadAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_LoadAction_IDX]), &cppSelf);
    if (Shiboken::Errors::occurred() != nullptr || pyResult == nullptr) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_LocationBar_LoadAction_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_LocationBar_LoadAction_EnumFlagInfo[] = {
    "Type:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_LocationBar_LoadAction_methods[] = {
    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_LocationBar_LoadAction__copy__), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static PyObject *Sbk_LocationBar_LoadAction_get_type(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::LocationBar::LoadAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_LoadAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::LocationBar::LoadAction::Type cppOut_local = cppSelf->type;
    return Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_LoadAction_Type_IDX])))->converter, &cppOut_local);
}
static int Sbk_LocationBar_LoadAction_set_type(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::LocationBar::LoadAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_LoadAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("type");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_LoadAction_Type_IDX])))->converter, (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("type", "Type");
        return -1;
    }

    auto cppOut_local = cppSelf->type;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->type = cppOut_local;

    return 0;
}

static PyObject *Sbk_LocationBar_LoadAction_get_searchEngine(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::LocationBar::LoadAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_LoadAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    auto *fieldTypeObject = Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]);
    if (auto *sbkOut = Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->searchEngine), fieldTypeObject)) {
        pyOut = reinterpret_cast<PyObject *>(sbkOut);
        Py_INCREF(pyOut);
    } else {
        pyOut = Shiboken::Object::newObject(fieldTypeObject, &(cppSelf->searchEngine), false, true);
        Shiboken::Object::setParent(self, pyOut);
    }
    return pyOut;
}
static int Sbk_LocationBar_LoadAction_set_searchEngine(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::LocationBar::LoadAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_LoadAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("searchEngine");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_Engine_IDX]), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("searchEngine", "Engine");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->searchEngine;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_LocationBar_LoadAction_get_bookmark(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::LocationBar::LoadAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_LoadAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), cppSelf->bookmark);
}
static int Sbk_LocationBar_LoadAction_set_bookmark(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::LocationBar::LoadAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_LoadAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("bookmark");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BookmarkItem_IDX]), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("bookmark", "BookmarkItem");
        return -1;
    }

    auto *&cppOut_ptr = cppSelf->bookmark;
    pythonToCpp(pyIn, &cppOut_ptr);

    Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(self), "bookmark", pyIn);
    return 0;
}

static PyObject *Sbk_LocationBar_LoadAction_get_loadRequest(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::LocationBar::LoadAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_LoadAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    auto *fieldTypeObject = Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX]);
    if (auto *sbkOut = Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->loadRequest), fieldTypeObject)) {
        pyOut = reinterpret_cast<PyObject *>(sbkOut);
        Py_INCREF(pyOut);
    } else {
        pyOut = Shiboken::Object::newObject(fieldTypeObject, &(cppSelf->loadRequest), false, true);
        Shiboken::Object::setParent(self, pyOut);
    }
    return pyOut;
}
static int Sbk_LocationBar_LoadAction_set_loadRequest(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::LocationBar::LoadAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_LoadAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("loadRequest");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX]), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("loadRequest", "LoadRequest");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->loadRequest;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

// Getters and Setters for LoadAction
static PyGetSetDef Sbk_LocationBar_LoadAction_getsetlist[] = {
    {const_cast<char *>("type"), Sbk_LocationBar_LoadAction_get_type, Sbk_LocationBar_LoadAction_set_type, nullptr, nullptr},
    {const_cast<char *>("searchEngine"), Sbk_LocationBar_LoadAction_get_searchEngine, Sbk_LocationBar_LoadAction_set_searchEngine, nullptr, nullptr},
    {const_cast<char *>("bookmark"), Sbk_LocationBar_LoadAction_get_bookmark, Sbk_LocationBar_LoadAction_set_bookmark, nullptr, nullptr},
    {const_cast<char *>("loadRequest"), Sbk_LocationBar_LoadAction_get_loadRequest, Sbk_LocationBar_LoadAction_set_loadRequest, nullptr, nullptr},
    {nullptr, nullptr, nullptr, nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_LocationBar_LoadAction_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_LocationBar_LoadAction_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_LocationBar_LoadAction_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_LocationBar_LoadAction_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_LocationBar_LoadAction_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_LocationBar_LoadAction_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_LocationBar_LoadAction_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_LocationBar_LoadAction_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_LocationBar_LoadAction_spec = {
    "1:PyFalkon.LocationBar.LoadAction",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_LocationBar_LoadAction_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_LocationBar_LoadAction_Type(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::LocationBar::LoadAction::Type>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::LocationBar::LoadAction::Type *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_LocationBar_LoadAction_Type_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_LoadAction_Type_IDX])))
        return Enum_PythonToCpp_LocationBar_LoadAction_Type;
    return {};
}

static PyObject *LocationBar_LoadAction_Type_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::LocationBar::LoadAction::Type>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::LocationBar::LoadAction::Type *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void LoadAction_PythonToCpp_LoadAction_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_LocationBar_LoadAction_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_LoadAction_PythonToCpp_LoadAction_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_LocationBar_LoadAction_TypeF()))
        return LoadAction_PythonToCpp_LoadAction_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *LoadAction_PTR_CppToPython_LoadAction(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_LocationBar_LoadAction_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_LocationBar_LoadAction_TypeF(), const_cast<void *>(cppIn), false);

}

// C++ to Python copy conversion.
static PyObject *LoadAction_COPY_CppToPython_LoadAction(const void *cppIn)
{
    auto *source = reinterpret_cast<const ::LocationBar::LoadAction *>(cppIn);
    return Shiboken::Object::newObject(Sbk_LocationBar_LoadAction_TypeF(), new ::LocationBar::LoadAction(*source), true, true);
}

// Python to C++ copy conversion.
static void LoadAction_PythonToCpp_LoadAction_COPY(PyObject *pyIn, void *cppOut)
{
    *reinterpret_cast<::LocationBar::LoadAction *>(cppOut) = *reinterpret_cast< ::LocationBar::LoadAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LocationBar_LoadAction_IDX]), reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_LoadAction_PythonToCpp_LoadAction_COPY_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Sbk_LocationBar_LoadAction_TypeF()))
        return LoadAction_PythonToCpp_LoadAction_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *LocationBar_LoadAction_SignatureStrings[] = {
    "1:PyFalkon.LocationBar.LoadAction(self)",
    "0:PyFalkon.LocationBar.LoadAction(self,LoadAction:PyFalkon.LocationBar.LoadAction)",
    "PyFalkon.LocationBar.LoadAction.__copy__(self)->typing._Self",
    nullptr}; // Sentinel
#else
static constexpr size_t LocationBar_LoadAction_SignatureByteSize = 82;
static constexpr uint8_t LocationBar_LoadAction_SignatureBytes[82] = {
    0x78, 0xda, 0x33, 0xb4, 0x0a, 0xa8, 0x74, 0x4b, 0xcc, 0xc9, 0xce, 0xcf, 0xd3, 0xf3, 0xc9, 0x4f,
    0x4e, 0x2c, 0xc9, 0xcc, 0xcf, 0x73, 0x4a, 0x2c, 0x02, 0xb2, 0x13, 0x53, 0x1c, 0x93, 0x41, 0x3c,
    0x8d, 0xe2, 0xd4, 0x9c, 0x34, 0x4d, 0x2e, 0x03, 0xa2, 0xd4, 0xe9, 0x20, 0xf8, 0x84, 0xd4, 0x6b,
    0x72, 0x11, 0x50, 0xa0, 0x17, 0x1f, 0x9f, 0x9c, 0x5f, 0x50, 0x19, 0x1f, 0x0f, 0x71, 0x81, 0xae,
    0x5d, 0x49, 0x65, 0x41, 0x66, 0x5e, 0xba, 0x5e, 0x7c, 0x30, 0x90, 0xcb, 0x05, 0x00, 0xef, 0x17,
    0x42, 0x5b
};
#endif

PyTypeObject *init_LocationBar_LoadAction(PyObject *enclosingClass)
{
    if (SbkPyFalkonTypeStructs[SBK_LocationBar_LoadAction_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_LocationBar_LoadAction_IDX].type;

    Shiboken::AutoDecRef Sbk_LocationBar_LoadAction_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_LocationBar_LoadAction_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "LoadAction",
        "LocationBar::LoadAction",
        &Sbk_LocationBar_LoadAction_spec,
        &Shiboken::callCppDestructor< ::LocationBar::LoadAction >,
        Sbk_LocationBar_LoadAction_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::InnerClass | Shiboken::ObjectType::WrapperFlags::Value);
    auto *pyType = _Sbk_LocationBar_LoadAction_Type; // references _Sbk_LocationBar_LoadAction_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, LocationBar_LoadAction_SignatureStrings);
#else
    InitSignatureBytes(pyType, LocationBar_LoadAction_SignatureBytes, LocationBar_LoadAction_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_LocationBar_LoadAction_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_LocationBar_LoadAction_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        LoadAction_PythonToCpp_LoadAction_PTR,
        is_LoadAction_PythonToCpp_LoadAction_PTR_Convertible,
        LoadAction_PTR_CppToPython_LoadAction,
        LoadAction_COPY_CppToPython_LoadAction);

    Shiboken::Conversions::registerConverterName(converter, "LocationBar::LoadAction");
    Shiboken::Conversions::registerConverterName(converter, "LocationBar::LoadAction*");
    Shiboken::Conversions::registerConverterName(converter, "LocationBar::LoadAction&");
    Shiboken::Conversions::registerConverterAlias(converter, "LoadAction");
    Shiboken::Conversions::registerConverterAlias(converter, "LoadAction*");
    Shiboken::Conversions::registerConverterAlias(converter, "LoadAction&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::LocationBar::LoadAction).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        LoadAction_PythonToCpp_LoadAction_COPY,
        is_LoadAction_PythonToCpp_LoadAction_COPY_Convertible);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_LocationBar_LoadAction_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'Type'.
    const char *Type_Initializer[] = {
        "Invalid",
        "Search",
        "Bookmark",
        "Url",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t Type_InitializerValues[] = {
        uint8_t(LocationBar::LoadAction::Type::Invalid),  //  0x00  0
        uint8_t(LocationBar::LoadAction::Type::Search),   //  0x01  1
        uint8_t(LocationBar::LoadAction::Type::Bookmark), //  0x02  2
        uint8_t(LocationBar::LoadAction::Type::Url)       //  0x03  3
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_LocationBar_LoadAction_TypeF(),
        "1:PyFalkon.LocationBar.LoadAction.Type",
        Type_Initializer, Type_InitializerValues);
    SbkPyFalkonTypeStructs[SBK_LocationBar_LoadAction_Type_IDX].type = EType;
    // Register converter for enum 'LocationBar::LoadAction::Type'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            LocationBar_LoadAction_Type_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_LocationBar_LoadAction_Type,
            is_Enum_PythonToCpp_LocationBar_LoadAction_Type_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "LocationBar::LoadAction::Type");
        Shiboken::Conversions::registerConverterAlias(converter, "LoadAction::Type");
        Shiboken::Conversions::registerConverterAlias(converter, "Type");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'Type' enum.

    qRegisterMetaType< ::LocationBar::LoadAction >("LoadAction");
    qRegisterMetaType< ::LocationBar::LoadAction >("LocationBar::LoadAction");
    qRegisterMetaType< ::LocationBar::LoadAction::Type >("LoadAction::Type");
    qRegisterMetaType< ::LocationBar::LoadAction::Type >("LocationBar::LoadAction::Type");

    return pyType;
}
