// DxilValidationImpl.inc - Generated by hctgen.py
// DO NOT MODIFY!!!
// Changes to this code are made in gen_intrin_main.txt

const char *hlsl::GetValidationRuleText(ValidationRule value) {
switch(value) {
  case hlsl::ValidationRule::BitcodeValid: return "Module bitcode is invalid.";
  case hlsl::ValidationRule::ContainerPartMatches: return "Container part '%0' does not match expected for module.";
  case hlsl::ValidationRule::ContainerPartRepeated: return "More than one container part '%0'.";
  case hlsl::ValidationRule::ContainerPartMissing: return "Missing part '%0' required by module.";
  case hlsl::ValidationRule::ContainerPartInvalid: return "Unknown part '%0' found in DXIL container.";
  case hlsl::ValidationRule::ContainerRootSignatureIncompatible: return "Root Signature in DXIL container is not compatible with shader.";
  case hlsl::ValidationRule::ContainerContentMatches: return "DXIL container mismatch for '%0' between '%1' part:('%2') and DXIL module:('%3')";
  case hlsl::ValidationRule::ContainerContentInvalid: return "In '%0', '%1' is not well-formed";
  case hlsl::ValidationRule::ContainerUnusedItemInTable: return "In '%0', '%1' is not used";
  case hlsl::ValidationRule::MetaRequired: return "Required metadata missing.";
  case hlsl::ValidationRule::MetaComputeWithNode: return "Compute entry '%0' has unexpected node shader metadata";
  case hlsl::ValidationRule::MetaKnown: return "Named metadata '%0' is unknown.";
  case hlsl::ValidationRule::MetaUsed: return "All metadata must be used by dxil.";
  case hlsl::ValidationRule::MetaTarget: return "Unknown target triple '%0'.";
  case hlsl::ValidationRule::MetaWellFormed: return "Metadata must be well-formed in operand count and types.";
  case hlsl::ValidationRule::MetaVersionSupported: return "%0 version in metadata (%1.%2) is not supported; maximum: (%3.%4).";
  case hlsl::ValidationRule::MetaSemanticLen: return "Semantic length must be at least 1 and at most 64.";
  case hlsl::ValidationRule::MetaInterpModeValid: return "Invalid interpolation mode for '%0'.";
  case hlsl::ValidationRule::MetaSemaKindValid: return "Semantic kind for '%0' is invalid.";
  case hlsl::ValidationRule::MetaNoSemanticOverlap: return "Semantic '%0' overlap at %1.";
  case hlsl::ValidationRule::MetaSemaKindMatchesName: return "Semantic name %0 does not match System Value kind %1.";
  case hlsl::ValidationRule::MetaDuplicateSysValue: return "System value %0 appears more than once in the same signature.";
  case hlsl::ValidationRule::MetaSemanticIndexMax: return "%0 semantic index exceeds maximum (%1).";
  case hlsl::ValidationRule::MetaSystemValueRows: return "rows for system value semantic %0 must be 1.";
  case hlsl::ValidationRule::MetaSemanticShouldBeAllocated: return "%0 Semantic '%1' should have a valid packing location.";
  case hlsl::ValidationRule::MetaSemanticShouldNotBeAllocated: return "%0 Semantic '%1' should have a packing location of -1.";
  case hlsl::ValidationRule::MetaValueRange: return "Metadata value must be within range.";
  case hlsl::ValidationRule::MetaFlagsUsage: return "Flags must match usage.";
  case hlsl::ValidationRule::MetaDenseResIDs: return "Resource identifiers must be zero-based and dense.";
  case hlsl::ValidationRule::MetaSignatureOverlap: return "signature element %0 at location (%1,%2) size (%3,%4) overlaps another signature element.";
  case hlsl::ValidationRule::MetaSignatureOutOfRange: return "signature element %0 at location (%1,%2) size (%3,%4) is out of range.";
  case hlsl::ValidationRule::MetaSignatureIndexConflict: return "signature element %0 at location (%1,%2) size (%3,%4) has an indexing conflict with another signature element packed into the same row.";
  case hlsl::ValidationRule::MetaSignatureIllegalComponentOrder: return "signature element %0 at location (%1,%2) size (%3,%4) violates component ordering rule (arb < sv < sgv).";
  case hlsl::ValidationRule::MetaSignatureDataWidth: return "signature element %0 at location (%1, %2) size (%3, %4) has data width that differs from another element packed into the same row.";
  case hlsl::ValidationRule::MetaIntegerInterpMode: return "signature element %0 specifies invalid interpolation mode for integer component type.";
  case hlsl::ValidationRule::MetaInterpModeInOneRow: return "signature element %0 at location (%1,%2) size (%3,%4) has interpolation mode that differs from another element packed into the same row.";
  case hlsl::ValidationRule::MetaSemanticCompType: return "%0 must be %1.";
  case hlsl::ValidationRule::MetaClipCullMaxRows: return "ClipDistance and CullDistance occupy more than the maximum of 2 rows combined.";
  case hlsl::ValidationRule::MetaClipCullMaxComponents: return "ClipDistance and CullDistance use more than the maximum of 8 components combined.";
  case hlsl::ValidationRule::MetaSignatureCompType: return "signature %0 specifies unrecognized or invalid component type.";
  case hlsl::ValidationRule::MetaTessellatorPartition: return "Invalid Tessellator Partitioning specified. Must be integer, pow2, fractional_odd or fractional_even.";
  case hlsl::ValidationRule::MetaTessellatorOutputPrimitive: return "Invalid Tessellator Output Primitive specified. Must be point, line, triangleCW or triangleCCW.";
  case hlsl::ValidationRule::MetaMaxTessFactor: return "Hull Shader MaxTessFactor must be [%0..%1].  %2 specified.";
  case hlsl::ValidationRule::MetaValidSamplerMode: return "Invalid sampler mode on sampler .";
  case hlsl::ValidationRule::MetaCoherenceNotOnAppendConsume: return "%0coherent cannot be used on buffer with counter";
  case hlsl::ValidationRule::MetaStructBufAlignment: return "structured buffer element size must be a multiple of %0 bytes (actual size %1 bytes).";
  case hlsl::ValidationRule::MetaStructBufAlignmentOutOfBound: return "structured buffer elements cannot be larger than %0 bytes (actual size %1 bytes).";
  case hlsl::ValidationRule::MetaEntryFunction: return "entrypoint not found.";
  case hlsl::ValidationRule::MetaInvalidControlFlowHint: return "Invalid control flow hint.";
  case hlsl::ValidationRule::MetaBranchFlatten: return "Can't use branch and flatten attributes together.";
  case hlsl::ValidationRule::MetaForceCaseOnSwitch: return "Attribute forcecase only works for switch.";
  case hlsl::ValidationRule::MetaControlFlowHintNotOnControlFlow: return "Control flow hint only works on control flow inst.";
  case hlsl::ValidationRule::MetaTextureType: return "elements of typed buffers and textures must fit in four 32-bit quantities.";
  case hlsl::ValidationRule::MetaBarycentricsInterpolation: return "SV_Barycentrics cannot be used with 'nointerpolation' type.";
  case hlsl::ValidationRule::MetaBarycentricsFloat3: return "only 'float3' type is allowed for SV_Barycentrics.";
  case hlsl::ValidationRule::MetaBarycentricsTwoPerspectives: return "There can only be up to two input attributes of SV_Barycentrics with different perspective interpolation mode.";
  case hlsl::ValidationRule::MetaNoEntryPropsForEntry: return "Entry point %0 must have entry properties.";
  case hlsl::ValidationRule::InstrOload: return "DXIL intrinsic overload must be valid.";
  case hlsl::ValidationRule::InstrCallOload: return "Call to DXIL intrinsic '%0' does not match an allowed overload signature.";
  case hlsl::ValidationRule::InstrPtrBitCast: return "Pointer type bitcast must be have same size.";
  case hlsl::ValidationRule::InstrMinPrecisonBitCast: return "Bitcast on minprecison types is not allowed.";
  case hlsl::ValidationRule::InstrStructBitCast: return "Bitcast on struct types is not allowed.";
  case hlsl::ValidationRule::InstrStatus: return "Resource status should only be used by CheckAccessFullyMapped.";
  case hlsl::ValidationRule::InstrCheckAccessFullyMapped: return "CheckAccessFullyMapped should only be used on resource status.";
  case hlsl::ValidationRule::InstrOpConst: return "%0 of %1 must be an immediate constant.";
  case hlsl::ValidationRule::InstrAllowed: return "Instructions must be of an allowed type.";
  case hlsl::ValidationRule::InstrOpCodeReserved: return "Instructions must not reference reserved opcodes.";
  case hlsl::ValidationRule::InstrOperandRange: return "expect %0 between %1, got %2.";
  case hlsl::ValidationRule::InstrNoReadingUninitialized: return "Instructions should not read uninitialized value.";
  case hlsl::ValidationRule::InstrNoGenericPtrAddrSpaceCast: return "Address space cast between pointer types must have one part to be generic address space.";
  case hlsl::ValidationRule::InstrInBoundsAccess: return "Access to out-of-bounds memory is disallowed.";
  case hlsl::ValidationRule::InstrOpConstRange: return "Constant values must be in-range for operation.";
  case hlsl::ValidationRule::InstrImmBiasForSampleB: return "bias amount for sample_b must be in the range [%0,%1], but %2 was specified as an immediate.";
  case hlsl::ValidationRule::InstrIllegalDXILOpCode: return "DXILOpCode must be [0..%0].  %1 specified.";
  case hlsl::ValidationRule::InstrIllegalDXILOpFunction: return "'%0' is not a DXILOpFuncition for DXILOpcode '%1'.";
  case hlsl::ValidationRule::InstrNoIndefiniteLog: return "No indefinite logarithm.";
  case hlsl::ValidationRule::InstrNoIndefiniteAsin: return "No indefinite arcsine.";
  case hlsl::ValidationRule::InstrNoIndefiniteAcos: return "No indefinite arccosine.";
  case hlsl::ValidationRule::InstrNoIDivByZero: return "No signed integer division by zero.";
  case hlsl::ValidationRule::InstrNoUDivByZero: return "No unsigned integer division by zero.";
  case hlsl::ValidationRule::InstrNoIndefiniteDsxy: return "No indefinite derivative calculation.";
  case hlsl::ValidationRule::InstrMinPrecisionNotPrecise: return "Instructions marked precise may not refer to minprecision values.";
  case hlsl::ValidationRule::InstrOnlyOneAllocConsume: return "RWStructuredBuffers may increment or decrement their counters, but not both.";
  case hlsl::ValidationRule::InstrTextureOffset: return "offset texture instructions must take offset which can resolve to integer literal in the range -8 to 7.";
  case hlsl::ValidationRule::InstrCannotPullPosition: return "%0 does not support pull-model evaluation of position.";
  case hlsl::ValidationRule::InstrEvalInterpolationMode: return "Interpolation mode on %0 used with eval_* instruction must be linear, linear_centroid, linear_noperspective, linear_noperspective_centroid, linear_sample or linear_noperspective_sample.";
  case hlsl::ValidationRule::InstrResourceCoordinateMiss: return "coord uninitialized.";
  case hlsl::ValidationRule::InstrResourceCoordinateTooMany: return "out of bound coord must be undef.";
  case hlsl::ValidationRule::InstrResourceOffsetMiss: return "offset uninitialized.";
  case hlsl::ValidationRule::InstrResourceOffsetTooMany: return "out of bound offset must be undef.";
  case hlsl::ValidationRule::InstrUndefResultForGetDimension: return "GetDimensions used undef dimension %0 on %1.";
  case hlsl::ValidationRule::InstrSamplerModeForLOD: return "lod instruction requires sampler declared in default mode.";
  case hlsl::ValidationRule::InstrSamplerModeForSample: return "sample/_l/_d/_cl_s/gather instruction requires sampler declared in default mode.";
  case hlsl::ValidationRule::InstrSamplerModeForSampleC: return "sample_c_*/gather_c instructions require sampler declared in comparison mode.";
  case hlsl::ValidationRule::InstrSampleCompType: return "sample_* instructions require resource to be declared to return UNORM, SNORM or FLOAT.";
  case hlsl::ValidationRule::InstrBarrierModeUselessUGroup: return "sync can't specify both _ugroup and _uglobal. If both are needed, just specify _uglobal.";
  case hlsl::ValidationRule::InstrBarrierModeNoMemory: return "sync must include some form of memory barrier - _u (UAV) and/or _g (Thread Group Shared Memory).  Only _t (thread group sync) is optional.";
  case hlsl::ValidationRule::InstrBarrierModeForNonCS: return "sync in a non-Compute/Amplification/Mesh/Node Shader must only sync UAV (sync_uglobal).";
  case hlsl::ValidationRule::InstrBarrierFlagInvalid: return "Invalid %0 flags on DXIL operation '%1'";
  case hlsl::ValidationRule::InstrBarrierNonConstantFlagArgument: return "Memory type, access, or sync flag is not constant";
  case hlsl::ValidationRule::InstrBarrierRequiresNode: return "sync in a non-Node Shader must not sync node record memory.";
  case hlsl::ValidationRule::InstrWriteMaskForTypedUAVStore: return "store on typed uav must write to all four components of the UAV.";
  case hlsl::ValidationRule::InstrWriteMaskGapForUAV: return "UAV write mask must be contiguous, starting at x: .x, .xy, .xyz, or .xyzw.";
  case hlsl::ValidationRule::InstrResourceKindForCalcLOD: return "lod requires resource declared as texture1D/2D/3D/Cube/CubeArray/1DArray/2DArray.";
  case hlsl::ValidationRule::InstrResourceKindForSample: return "sample/_l/_d requires resource declared as texture1D/2D/3D/Cube/1DArray/2DArray/CubeArray.";
  case hlsl::ValidationRule::InstrResourceKindForSampleC: return "samplec requires resource declared as texture1D/2D/Cube/1DArray/2DArray/CubeArray.";
  case hlsl::ValidationRule::InstrResourceKindForGather: return "gather requires resource declared as texture/2D/Cube/2DArray/CubeArray.";
  case hlsl::ValidationRule::InstrWriteMaskMatchValueForUAVStore: return "uav store write mask must match store value mask, write mask is %0 and store value mask is %1.";
  case hlsl::ValidationRule::InstrUndefinedValueForUAVStore: return "Assignment of undefined values to UAV.";
  case hlsl::ValidationRule::InstrResourceKindForBufferLoadStore: return "buffer load/store only works on Raw/Typed/StructuredBuffer.";
  case hlsl::ValidationRule::InstrResourceKindForTextureStore: return "texture store only works on Texture1D/1DArray/2D/2DArray/3D.";
  case hlsl::ValidationRule::InstrResourceKindForGetDim: return "Invalid resource kind on GetDimensions.";
  case hlsl::ValidationRule::InstrResourceKindForTextureLoad: return "texture load only works on Texture1D/1DArray/2D/2DArray/3D/MS2D/MS2DArray.";
  case hlsl::ValidationRule::InstrResourceClassForSamplerGather: return "sample, lod and gather should be on srv resource.";
  case hlsl::ValidationRule::InstrResourceClassForUAVStore: return "store should be on uav resource.";
  case hlsl::ValidationRule::InstrResourceClassForLoad: return "load can only run on UAV/SRV resource.";
  case hlsl::ValidationRule::InstrResourceMapToSingleEntry: return "Fail to map resource to resource table.";
  case hlsl::ValidationRule::InstrResourceUser: return "Resource should only be used by Load/GEP/Call.";
  case hlsl::ValidationRule::InstrResourceKindForTraceRay: return "TraceRay should only use RTAccelerationStructure.";
  case hlsl::ValidationRule::InstrOffsetOnUAVLoad: return "uav load don't support offset.";
  case hlsl::ValidationRule::InstrMipOnUAVLoad: return "uav load don't support mipLevel/sampleIndex.";
  case hlsl::ValidationRule::InstrSampleIndexForLoad2DMS: return "load on Texture2DMS/2DMSArray require sampleIndex.";
  case hlsl::ValidationRule::InstrCoordinateCountForRawTypedBuf: return "raw/typed buffer offset must be undef.";
  case hlsl::ValidationRule::InstrConstAlignForRawBuf: return "Raw Buffer alignment value must be a constant.";
  case hlsl::ValidationRule::InstrCoordinateCountForStructBuf: return "structured buffer requires defined index and offset coordinates.";
  case hlsl::ValidationRule::InstrMipLevelForGetDimension: return "Use mip level on buffer when GetDimensions.";
  case hlsl::ValidationRule::InstrDxilStructUser: return "Dxil struct types should only be used by ExtractValue.";
  case hlsl::ValidationRule::InstrDxilStructUserOutOfBound: return "Index out of bound when extract value from dxil struct types.";
  case hlsl::ValidationRule::InstrHandleNotFromCreateHandle: return "Resource handle should returned by createHandle.";
  case hlsl::ValidationRule::InstrBufferUpdateCounterOnUAV: return "BufferUpdateCounter valid only on UAV.";
  case hlsl::ValidationRule::InstrBufferUpdateCounterOnResHasCounter: return "BufferUpdateCounter valid only when HasCounter is true.";
  case hlsl::ValidationRule::InstrCBufferOutOfBound: return "Cbuffer access out of bound.";
  case hlsl::ValidationRule::InstrCBufferClassForCBufferHandle: return "Expect Cbuffer for CBufferLoad handle.";
  case hlsl::ValidationRule::InstrFailToResloveTGSMPointer: return "TGSM pointers must originate from an unambiguous TGSM global variable.";
  case hlsl::ValidationRule::InstrExtractValue: return "ExtractValue should only be used on dxil struct types and cmpxchg.";
  case hlsl::ValidationRule::InstrTGSMRaceCond: return "Race condition writing to shared memory detected, consider making this write conditional.";
  case hlsl::ValidationRule::InstrAttributeAtVertexNoInterpolation: return "Attribute %0 must have nointerpolation mode in order to use GetAttributeAtVertex function.";
  case hlsl::ValidationRule::InstrCreateHandleImmRangeID: return "Local resource must map to global resource.";
  case hlsl::ValidationRule::InstrSignatureOperationNotInEntry: return "Dxil operation for input output signature must be in entryPoints.";
  case hlsl::ValidationRule::InstrMultipleSetMeshOutputCounts: return "SetMeshOUtputCounts cannot be called multiple times.";
  case hlsl::ValidationRule::InstrMissingSetMeshOutputCounts: return "Missing SetMeshOutputCounts call.";
  case hlsl::ValidationRule::InstrNonDominatingSetMeshOutputCounts: return "Non-Dominating SetMeshOutputCounts call.";
  case hlsl::ValidationRule::InstrMultipleGetMeshPayload: return "GetMeshPayload cannot be called multiple times.";
  case hlsl::ValidationRule::InstrNotOnceDispatchMesh: return "DispatchMesh must be called exactly once in an Amplification shader.";
  case hlsl::ValidationRule::InstrNonDominatingDispatchMesh: return "Non-Dominating DispatchMesh call.";
  case hlsl::ValidationRule::InstrAtomicOpNonGroupsharedOrRecord: return "Non-groupshared or node record destination to atomic operation.";
  case hlsl::ValidationRule::InstrAtomicIntrinNonUAV: return "Non-UAV destination to atomic intrinsic.";
  case hlsl::ValidationRule::InstrSVConflictingLaunchMode: return "Call to DXIL intrinsic %0 (%1) is not allowed in node shader launch type %2";
  case hlsl::ValidationRule::InstrAtomicConst: return "Constant destination to atomic.";
  case hlsl::ValidationRule::InstrNodeRecordHandleUseAfterComplete: return "Invalid use of completed record handle.";
  case hlsl::ValidationRule::InstrUndefHitObject: return "HitObject is undef.";
  case hlsl::ValidationRule::InstrParamMultiple: return "parameter '%0' must be a multiple of %1, got %2";
  case hlsl::ValidationRule::InstrMayReorderThreadUndefCoherenceHintParam: return "Use of undef coherence hint or num coherence hint bits in MaybeReorderThread.";
  case hlsl::ValidationRule::InstrReorderCoherentRequiresSM69: return "reordercoherent requires SM 6.9 or later.";
  case hlsl::ValidationRule::InstrMatVecOpIsUnsignedFlagsAreConst: return "%0 is not a constant value";
  case hlsl::ValidationRule::InstrLinalgInterpretationParamAreConst: return "%0 is not a constant value";
  case hlsl::ValidationRule::InstrLinalgInvalidRegisterInterpValue: return "'%0' is not a valid %1 interpretation value";
  case hlsl::ValidationRule::InstrLinalgInvalidMemoryInterpValue: return "'%0' is not a valid %1 interpretation value";
  case hlsl::ValidationRule::InstrLinalgMatrixShapeParamsAreConst: return "'%0' is not a constant value";
  case hlsl::ValidationRule::InstrLinalgInvalidMatrixLayoutValueForMatVecOps: return "matrix layout value '%0' is not valid. Must be between [%1 - %2]";
  case hlsl::ValidationRule::InstrLinalgMatrixStrideZeroForOptimalLayouts: return "matrix stride must be a constant zero for optimal layouts";
  case hlsl::ValidationRule::InstrLinalgMatrixLayoutNotTransposable: return "%0 matrix layout is not transposable";
  case hlsl::ValidationRule::InstrLinalgNotAnUnsignedType: return "IsUnsigned flag set to true for a float type '%0' vector";
  case hlsl::ValidationRule::InstrLinalgInvalidMatrixLayoutValueForOuterProductAccumulate: return "matrix layout value '%0' is not valid for outerproductaccumulate, must be '%1'";
  case hlsl::ValidationRule::TypesNoVector: return "Vector type '%0' is not allowed.";
  case hlsl::ValidationRule::TypesDefined: return "Type '%0' is not defined on DXIL primitives.";
  case hlsl::ValidationRule::TypesIntWidth: return "Int type '%0' has an invalid width.";
  case hlsl::ValidationRule::TypesNoMultiDim: return "Only one dimension allowed for array type.";
  case hlsl::ValidationRule::TypesNoPtrToPtr: return "Pointers to pointers, or pointers in structures are not allowed.";
  case hlsl::ValidationRule::TypesI8: return "I8 can only be used as immediate value for intrinsic or as i8* via bitcast by lifetime intrinsics.";
  case hlsl::ValidationRule::SmName: return "Unknown shader model '%0'.";
  case hlsl::ValidationRule::SmDxilVersion: return "Shader model requires Dxil Version %0.%1.";
  case hlsl::ValidationRule::SmProgramVersion: return "Program Version is %0.%1 but Dxil Module shader model version is %2.%3.";
  case hlsl::ValidationRule::SmOpcode: return "Opcode %0 not valid in shader model %1.";
  case hlsl::ValidationRule::SmOperand: return "Operand must be defined in target shader model.";
  case hlsl::ValidationRule::SmSemantic: return "Semantic '%0' is invalid as %1 %2.";
  case hlsl::ValidationRule::SmNoInterpMode: return "Interpolation mode for '%0' is set but should be undefined.";
  case hlsl::ValidationRule::SmConstantInterpMode: return "Interpolation mode for '%0' should be constant.";
  case hlsl::ValidationRule::SmNoPSOutputIdx: return "Pixel shader output registers are not indexable.";
  case hlsl::ValidationRule::SmPSConsistentInterp: return "Interpolation mode for PS input position must be linear_noperspective_centroid or linear_noperspective_sample when outputting oDepthGE or oDepthLE and not running at sample frequency (which is forced by inputting SV_SampleIndex or declaring an input linear_sample or linear_noperspective_sample).";
  case hlsl::ValidationRule::SmThreadGroupChannelRange: return "Declared Thread Group %0 size %1 outside valid range [%2..%3].";
  case hlsl::ValidationRule::SmMaxTheadGroup: return "Declared Thread Group Count %0 (X*Y*Z) is beyond the valid maximum of %1.";
  case hlsl::ValidationRule::SmMaxTGSMSize: return "Total Thread Group Shared Memory storage is %0, exceeded %1.";
  case hlsl::ValidationRule::SmTGSMUnsupported: return "Thread Group Shared Memory not supported %0.";
  case hlsl::ValidationRule::SmWaveSizeValue: return "WaveSize %0 (%1) outside valid range [%2..%3], or not a power of 2.";
  case hlsl::ValidationRule::SmWaveSizeAllZeroWhenUndefined: return "WaveSize Max (%0) and Preferred (%1) must be 0 when Min is 0";
  case hlsl::ValidationRule::SmWaveSizeMaxAndPreferredZeroWhenNoRange: return "WaveSize Max (%0) and Preferred (%1) must be 0 to encode min==max";
  case hlsl::ValidationRule::SmWaveSizeMaxGreaterThanMin: return "WaveSize Max (%0) is less than Min (%1)";
  case hlsl::ValidationRule::SmWaveSizePreferredInRange: return "WaveSize Preferred (%0) outside Min..Max range [%1..%2]";
  case hlsl::ValidationRule::SmWaveSizeOnComputeOrNode: return "WaveSize only allowed on compute or node shaders";
  case hlsl::ValidationRule::SmWaveSizeNeedsSM66or67: return "WaveSize is valid only for Shader Model 6.6 and 6.7.";
  case hlsl::ValidationRule::SmWaveSizeRangeNeedsSM68Plus: return "WaveSize Range is valid only for Shader Model 6.8 and higher.";
  case hlsl::ValidationRule::SmWaveSizeRangeExpectsThreeParams: return "WaveSize Range tag expects exactly 3 parameters.";
  case hlsl::ValidationRule::SmWaveSizeExpectsOneParam: return "WaveSize tag expects exactly 1 parameter.";
  case hlsl::ValidationRule::SmWaveSizeTagDuplicate: return "WaveSize or WaveSizeRange tag may only appear once per entry point.";
  case hlsl::ValidationRule::SmWaveSizeNeedsConstantOperands: return "WaveSize metadata operands must be constant values.";
  case hlsl::ValidationRule::SmROVOnlyInPS: return "RasterizerOrdered objects are only allowed in 5.0+ pixel shaders.";
  case hlsl::ValidationRule::SmTessFactorForDomain: return "Required TessFactor for domain not found declared anywhere in Patch Constant data.";
  case hlsl::ValidationRule::SmTessFactorSizeMatchDomain: return "TessFactor rows, columns (%0, %1) invalid for domain %2.  Expected %3 rows and 1 column.";
  case hlsl::ValidationRule::SmInsideTessFactorSizeMatchDomain: return "InsideTessFactor rows, columns (%0, %1) invalid for domain %2.  Expected %3 rows and 1 column.";
  case hlsl::ValidationRule::SmDomainLocationIdxOOB: return "DomainLocation component index out of bounds for the domain.";
  case hlsl::ValidationRule::SmHullPassThruControlPointCountMatch: return "For pass thru hull shader, input control point count must match output control point count";
  case hlsl::ValidationRule::SmOutputControlPointsTotalScalars: return "Total number of scalars across all HS output control points must not exceed .";
  case hlsl::ValidationRule::SmIsoLineOutputPrimitiveMismatch: return "Hull Shader declared with IsoLine Domain must specify output primitive point or line. Triangle_cw or triangle_ccw output are not compatible with the IsoLine Domain.";
  case hlsl::ValidationRule::SmTriOutputPrimitiveMismatch: return "Hull Shader declared with Tri Domain must specify output primitive point, triangle_cw or triangle_ccw. Line output is not compatible with the Tri domain.";
  case hlsl::ValidationRule::SmValidDomain: return "Invalid Tessellator Domain specified. Must be isoline, tri or quad.";
  case hlsl::ValidationRule::SmPatchConstantOnlyForHSDS: return "patch constant signature only valid in HS and DS.";
  case hlsl::ValidationRule::SmStreamIndexRange: return "Stream index (%0) must between 0 and %1.";
  case hlsl::ValidationRule::SmPSOutputSemantic: return "Pixel Shader allows output semantics to be SV_Target, SV_Depth, SV_DepthGreaterEqual, SV_DepthLessEqual, SV_Coverage or SV_StencilRef, %0 found.";
  case hlsl::ValidationRule::SmPSMultipleDepthSemantic: return "Pixel Shader only allows one type of depth semantic to be declared.";
  case hlsl::ValidationRule::SmPSTargetIndexMatchesRow: return "SV_Target semantic index must match packed row location.";
  case hlsl::ValidationRule::SmPSTargetCol0: return "SV_Target packed location must start at column 0.";
  case hlsl::ValidationRule::SmPSCoverageAndInnerCoverage: return "InnerCoverage and Coverage are mutually exclusive.";
  case hlsl::ValidationRule::SmGSOutputVertexCountRange: return "GS output vertex count must be [0..%0].  %1 specified.";
  case hlsl::ValidationRule::SmGSInstanceCountRange: return "GS instance count must be [1..%0].  %1 specified.";
  case hlsl::ValidationRule::SmDSInputControlPointCountRange: return "DS input control point count must be [0..%0].  %1 specified.";
  case hlsl::ValidationRule::SmHSInputControlPointCountRange: return "HS input control point count must be [0..%0].  %1 specified.";
  case hlsl::ValidationRule::SmZeroHSInputControlPointWithInput: return "When HS input control point count is 0, no input signature should exist.";
  case hlsl::ValidationRule::SmOutputControlPointCountRange: return "output control point count must be [%0..%1].  %2 specified.";
  case hlsl::ValidationRule::SmGSValidInputPrimitive: return "GS input primitive unrecognized.";
  case hlsl::ValidationRule::SmGSValidOutputPrimitiveTopology: return "GS output primitive topology unrecognized.";
  case hlsl::ValidationRule::SmAppendAndConsumeOnSameUAV: return "BufferUpdateCounter inc and dec on a given UAV (%d) cannot both be in the same shader for shader model less than 5.1.";
  case hlsl::ValidationRule::SmInvalidTextureKindOnUAV: return "TextureCube[Array] resources are not supported with UAVs.";
  case hlsl::ValidationRule::SmInvalidResourceKind: return "Invalid resources kind.";
  case hlsl::ValidationRule::SmInvalidResourceCompType: return "Invalid resource return type.";
  case hlsl::ValidationRule::SmInvalidSamplerFeedbackType: return "Invalid sampler feedback type.";
  case hlsl::ValidationRule::SmSampleCountOnlyOn2DMS: return "Only Texture2DMS/2DMSArray could has sample count.";
  case hlsl::ValidationRule::SmCounterOnlyOnStructBuf: return "BufferUpdateCounter valid only on structured buffers.";
  case hlsl::ValidationRule::SmGSTotalOutputVertexDataRange: return "Declared output vertex count (%0) multiplied by the total number of declared scalar components of output data (%1) equals %2.  This value cannot be greater than %3.";
  case hlsl::ValidationRule::SmMultiStreamMustBePoint: return "Multiple GS output streams are used but '%0' is not pointlist.";
  case hlsl::ValidationRule::SmCompletePosition: return "Not all elements of SV_Position were written.";
  case hlsl::ValidationRule::SmUndefinedOutput: return "Not all elements of output %0 were written.";
  case hlsl::ValidationRule::SmCSNoSignatures: return "Compute shaders must not have shader signatures.";
  case hlsl::ValidationRule::SmCBufferTemplateTypeMustBeStruct: return "D3D12 constant/texture buffer template element can only be a struct.";
  case hlsl::ValidationRule::SmResourceRangeOverlap: return "Resource %0 with base %1 size %2 overlap with other resource with base %3 size %4 in space %5.";
  case hlsl::ValidationRule::SmCBufferSize: return "CBuffer size is %0 bytes, exceeding maximum of 65536 bytes.";
  case hlsl::ValidationRule::SmCBufferOffsetOverlap: return "CBuffer %0 has offset overlaps at %1.";
  case hlsl::ValidationRule::SmCBufferElementOverflow: return "CBuffer %0 size insufficient for element at offset %1.";
  case hlsl::ValidationRule::SmCBufferArrayOffsetAlignment: return "CBuffer %0 has unaligned array offset at %1.";
  case hlsl::ValidationRule::SmOpcodeInInvalidFunction: return "opcode '%0' should only be used in '%1'.";
  case hlsl::ValidationRule::SmViewIDNeedsSlot: return "Pixel shader input signature lacks available space for ViewID.";
  case hlsl::ValidationRule::Sm64bitRawBufferLoadStore: return "i64/f64 rawBufferLoad/Store overloads are allowed after SM 6.3.";
  case hlsl::ValidationRule::SmRayShaderSignatures: return "Ray tracing shader '%0' should not have any shader signatures.";
  case hlsl::ValidationRule::SmRayShaderPayloadSize: return "For shader '%0', %1 size is smaller than argument's allocation size.";
  case hlsl::ValidationRule::SmMeshShaderMaxVertexCount: return "MS max vertex output count must be [0..%0].  %1 specified.";
  case hlsl::ValidationRule::SmMeshShaderMaxPrimitiveCount: return "MS max primitive output count must be [0..%0].  %1 specified.";
  case hlsl::ValidationRule::SmMeshShaderPayloadSize: return "For mesh shader with entry '%0', payload size %1 is greater than maximum size of %2 bytes.";
  case hlsl::ValidationRule::SmMeshShaderPayloadSizeDeclared: return "For mesh shader with entry '%0', payload size %1 is greater than declared size of %2 bytes.";
  case hlsl::ValidationRule::SmMeshShaderOutputSize: return "For shader '%0', vertex plus primitive output size is greater than %1.";
  case hlsl::ValidationRule::SmMeshShaderInOutSize: return "For shader '%0', payload plus output size is greater than %1.";
  case hlsl::ValidationRule::SmMeshVSigRowCount: return "For shader '%0', vertex output signatures are taking up more than %1 rows.";
  case hlsl::ValidationRule::SmMeshPSigRowCount: return "For shader '%0', primitive output signatures are taking up more than %1 rows.";
  case hlsl::ValidationRule::SmMeshTotalSigRowCount: return "For shader '%0', vertex and primitive output signatures are taking up more than %1 rows.";
  case hlsl::ValidationRule::SmMaxMSSMSize: return "Total Thread Group Shared Memory storage is %0, exceeded %1.";
  case hlsl::ValidationRule::SmAmplificationShaderPayloadSize: return "For amplification shader with entry '%0', payload size %1 is greater than maximum size of %2 bytes.";
  case hlsl::ValidationRule::SmAmplificationShaderPayloadSizeDeclared: return "For amplification shader with entry '%0', payload size %1 is greater than declared size of %2 bytes.";
  case hlsl::ValidationRule::FlowReducible: return "Execution flow must be reducible.";
  case hlsl::ValidationRule::FlowNoRecursion: return "Recursion is not permitted.";
  case hlsl::ValidationRule::FlowDeadLoop: return "Loop must have break.";
  case hlsl::ValidationRule::FlowFunctionCall: return "Function %0 with parameter is not permitted, it should be inlined.";
  case hlsl::ValidationRule::DeclDxilNsReserved: return "Declaration '%0' uses a reserved prefix.";
  case hlsl::ValidationRule::DeclDxilFnExtern: return "External function '%0' is not a DXIL function.";
  case hlsl::ValidationRule::DeclUsedInternal: return "Internal declaration '%0' is unused.";
  case hlsl::ValidationRule::DeclNotUsedExternal: return "External declaration '%0' is unused.";
  case hlsl::ValidationRule::DeclUsedExternalFunction: return "External function '%0' is unused.";
  case hlsl::ValidationRule::DeclFnIsCalled: return "Function '%0' is used for something other than calling.";
  case hlsl::ValidationRule::DeclFnFlattenParam: return "Type '%0' is a struct type but is used as a parameter in function '%1'.";
  case hlsl::ValidationRule::DeclFnAttribute: return "Function '%0' contains invalid attribute '%1' with value '%2'.";
  case hlsl::ValidationRule::DeclResourceInFnSig: return "Function '%0' uses resource in function signature.";
  case hlsl::ValidationRule::DeclRayQueryInFnSig: return "Function '%0' uses rayquery object in function signature.";
  case hlsl::ValidationRule::DeclAllocateRayQueryFlagsAreConst: return "constRayFlags argument of AllocateRayQuery must be constant";
  case hlsl::ValidationRule::DeclAllocateRayQuery2FlagsAreConst: return "constRayFlags and RayQueryFlags arguments of AllocateRayQuery2 must be constant";
  case hlsl::ValidationRule::DeclAllowOpacityMicromapsExpectedGivenForceOMM2State: return "RAYQUERY_FLAG_ALLOW_OPACITY_MICROMAPS must be set for RayQueryFlags when RAY_FLAG_FORCE_OMM_2_STATE is set for constRayFlags on AllocateRayQuery2 operation.";
  case hlsl::ValidationRule::DeclPayloadStruct: return "Argument '%0' must be a struct type for payload in shader function '%1'.";
  case hlsl::ValidationRule::DeclAttrStruct: return "Argument '%0' must be a struct type for attributes in shader function '%1'.";
  case hlsl::ValidationRule::DeclParamStruct: return "Argument '%0' must be a struct type for callable shader function '%1'.";
  case hlsl::ValidationRule::DeclExtraArgs: return "Extra argument '%0' not allowed for shader function '%1'.";
  case hlsl::ValidationRule::DeclShaderReturnVoid: return "Shader function '%0' must have void return type.";
  case hlsl::ValidationRule::DeclShaderMissingArg: return "%0 shader '%1' missing required %2 parameter.";
  case hlsl::ValidationRule::DeclMultipleNodeInputs: return "node shader '%0' may not have more than one input record (%1 are declared)";
  case hlsl::ValidationRule::DeclNodeLaunchInputType: return "%0 node shader '%1' has incompatible input record type (should be %2)";
  case hlsl::ValidationRule::SmIncompatibleCallInEntry: return "Entry function calls one or more functions using incompatible features.  See other errors for details.";
  case hlsl::ValidationRule::SmIncompatibleOperation: return "Entry function performs some operation that is incompatible with the shader stage or other entry properties.  See other errors for details.";
  case hlsl::ValidationRule::SmIncompatibleStage: return "Function uses features incompatible with the shader stage (%0) of the entry function.";
  case hlsl::ValidationRule::SmIncompatibleShaderModel: return "Function uses features incompatible with the shader model.";
  case hlsl::ValidationRule::SmIncompatibleThreadGroupDim: return "Function uses derivatives in compute-model shader with NumThreads (%0, %1, %2); derivatives require NumThreads to be 1D and a multiple of 4, or 2D/3D with X and Y both being a multiple of 2.";
  case hlsl::ValidationRule::SmIncompatibleDerivInComputeShaderModel: return "Function uses derivatives in compute-model shader, which is only supported in shader model 6.6 and above.";
  case hlsl::ValidationRule::SmIncompatibleRequiresGroup: return "Function requires a visible group, but is called from a shader without one.";
  case hlsl::ValidationRule::SmIncompatibleDerivLaunch: return "Function called from %0 launch node shader uses derivatives; only broadcasting launch supports derivatives.";
}
  llvm_unreachable("invalid value");
  return "<unknown>";
}
namespace hlsl {

static bool ValidateOpcodeInProfile(DXIL::OpCode opcode,
                                    DXIL::ShaderKind SK,
                                    unsigned major,
                                    unsigned minor) {
  unsigned op = (unsigned)opcode;// Instructions: ThreadId=93, GroupId=94, ThreadIdInGroup=95,
// FlattenedThreadIdInGroup=96
if ((93 <= op && op <= 96))
  return (SK == DXIL::ShaderKind::Compute || SK == DXIL::ShaderKind::Mesh || SK == DXIL::ShaderKind::Amplification || SK == DXIL::ShaderKind::Node);
// Instructions: DomainLocation=105
if (op == 105)
  return (SK == DXIL::ShaderKind::Domain);
// Instructions: LoadOutputControlPoint=103, LoadPatchConstant=104
if ((103 <= op && op <= 104))
  return (SK == DXIL::ShaderKind::Domain || SK == DXIL::ShaderKind::Hull);
// Instructions: EmitStream=97, CutStream=98, EmitThenCutStream=99,
// GSInstanceID=100
if ((97 <= op && op <= 100))
  return (SK == DXIL::ShaderKind::Geometry);
// Instructions: PrimitiveID=108
if (op == 108)
  return (SK == DXIL::ShaderKind::Geometry || SK == DXIL::ShaderKind::Domain || SK == DXIL::ShaderKind::Hull);
// Instructions: StorePatchConstant=106, OutputControlPointID=107
if ((106 <= op && op <= 107))
  return (SK == DXIL::ShaderKind::Hull);
// Instructions: QuadReadLaneAt=122, QuadOp=123
if ((122 <= op && op <= 123))
  return (SK == DXIL::ShaderKind::Library || SK == DXIL::ShaderKind::Compute || SK == DXIL::ShaderKind::Amplification || SK == DXIL::ShaderKind::Mesh || SK == DXIL::ShaderKind::Pixel || SK == DXIL::ShaderKind::Node);
// Instructions: WaveIsFirstLane=110, WaveGetLaneIndex=111,
// WaveGetLaneCount=112, WaveAnyTrue=113, WaveAllTrue=114,
// WaveActiveAllEqual=115, WaveActiveBallot=116, WaveReadLaneAt=117,
// WaveReadLaneFirst=118, WaveActiveOp=119, WaveActiveBit=120,
// WavePrefixOp=121, WaveAllBitCount=135, WavePrefixBitCount=136
if ((110 <= op && op <= 121) || (135 <= op && op <= 136))
  return (SK == DXIL::ShaderKind::Library || SK == DXIL::ShaderKind::Compute || SK == DXIL::ShaderKind::Amplification || SK == DXIL::ShaderKind::Mesh || SK == DXIL::ShaderKind::Pixel || SK == DXIL::ShaderKind::Vertex || SK == DXIL::ShaderKind::Hull || SK == DXIL::ShaderKind::Domain || SK == DXIL::ShaderKind::Geometry || SK == DXIL::ShaderKind::RayGeneration || SK == DXIL::ShaderKind::Intersection || SK == DXIL::ShaderKind::AnyHit || SK == DXIL::ShaderKind::ClosestHit || SK == DXIL::ShaderKind::Miss || SK == DXIL::ShaderKind::Callable || SK == DXIL::ShaderKind::Node);
// Instructions: Sample=60, SampleBias=61, SampleCmp=64, CalculateLOD=81,
// DerivCoarseX=83, DerivCoarseY=84, DerivFineX=85, DerivFineY=86
if ((60 <= op && op <= 61) || op == 64 || op == 81 || (83 <= op && op <= 86))
  return (SK == DXIL::ShaderKind::Library || SK == DXIL::ShaderKind::Pixel || SK == DXIL::ShaderKind::Compute || SK == DXIL::ShaderKind::Amplification || SK == DXIL::ShaderKind::Mesh || SK == DXIL::ShaderKind::Node);
// Instructions: RenderTargetGetSamplePosition=76,
// RenderTargetGetSampleCount=77, Discard=82, EvalSnapped=87,
// EvalSampleIndex=88, EvalCentroid=89, SampleIndex=90, Coverage=91,
// InnerCoverage=92
if ((76 <= op && op <= 77) || op == 82 || (87 <= op && op <= 92))
  return (SK == DXIL::ShaderKind::Pixel);
// Instructions: AttributeAtVertex=137
if (op == 137)
  return (major > 6 || (major == 6 && minor >= 1))
      && (SK == DXIL::ShaderKind::Pixel);
// Instructions: ViewID=138
if (op == 138)
  return (major > 6 || (major == 6 && minor >= 1))
      && (SK == DXIL::ShaderKind::Vertex || SK == DXIL::ShaderKind::Hull || SK == DXIL::ShaderKind::Domain || SK == DXIL::ShaderKind::Geometry || SK == DXIL::ShaderKind::Pixel || SK == DXIL::ShaderKind::Mesh);
// Instructions: RawBufferLoad=139, RawBufferStore=140
if ((139 <= op && op <= 140))
  return (major > 6 || (major == 6 && minor >= 2));
// Instructions: CreateHandleForLib=160
if (op == 160)
  return (major > 6 || (major == 6 && minor >= 3));
// Instructions: IgnoreHit=155, AcceptHitAndEndSearch=156
if ((155 <= op && op <= 156))
  return (major > 6 || (major == 6 && minor >= 3))
      && (SK == DXIL::ShaderKind::AnyHit);
// Instructions: CallShader=159
if (op == 159)
  return (major > 6 || (major == 6 && minor >= 3))
      && (SK == DXIL::ShaderKind::Library || SK == DXIL::ShaderKind::ClosestHit || SK == DXIL::ShaderKind::RayGeneration || SK == DXIL::ShaderKind::Miss || SK == DXIL::ShaderKind::Callable);
// Instructions: ReportHit=158
if (op == 158)
  return (major > 6 || (major == 6 && minor >= 3))
      && (SK == DXIL::ShaderKind::Library || SK == DXIL::ShaderKind::Intersection);
// Instructions: InstanceID=141, InstanceIndex=142, HitKind=143,
// ObjectRayOrigin=149, ObjectRayDirection=150, ObjectToWorld=151,
// WorldToObject=152, PrimitiveIndex=161
if ((141 <= op && op <= 143) || (149 <= op && op <= 152) || op == 161)
  return (major > 6 || (major == 6 && minor >= 3))
      && (SK == DXIL::ShaderKind::Library || SK == DXIL::ShaderKind::Intersection || SK == DXIL::ShaderKind::AnyHit || SK == DXIL::ShaderKind::ClosestHit);
// Instructions: RayFlags=144, WorldRayOrigin=147, WorldRayDirection=148,
// RayTMin=153, RayTCurrent=154
if (op == 144 || (147 <= op && op <= 148) || (153 <= op && op <= 154))
  return (major > 6 || (major == 6 && minor >= 3))
      && (SK == DXIL::ShaderKind::Library || SK == DXIL::ShaderKind::Intersection || SK == DXIL::ShaderKind::AnyHit || SK == DXIL::ShaderKind::ClosestHit || SK == DXIL::ShaderKind::Miss);
// Instructions: TraceRay=157
if (op == 157)
  return (major > 6 || (major == 6 && minor >= 3))
      && (SK == DXIL::ShaderKind::Library || SK == DXIL::ShaderKind::RayGeneration || SK == DXIL::ShaderKind::ClosestHit || SK == DXIL::ShaderKind::Miss);
// Instructions: DispatchRaysIndex=145, DispatchRaysDimensions=146
if ((145 <= op && op <= 146))
  return (major > 6 || (major == 6 && minor >= 3))
      && (SK == DXIL::ShaderKind::Library || SK == DXIL::ShaderKind::RayGeneration || SK == DXIL::ShaderKind::Intersection || SK == DXIL::ShaderKind::AnyHit || SK == DXIL::ShaderKind::ClosestHit || SK == DXIL::ShaderKind::Miss || SK == DXIL::ShaderKind::Callable);
// Instructions: Dot2AddHalf=162, Dot4AddI8Packed=163, Dot4AddU8Packed=164
if ((162 <= op && op <= 164))
  return (major > 6 || (major == 6 && minor >= 4));
// Instructions: WriteSamplerFeedbackLevel=176, WriteSamplerFeedbackGrad=177,
// AllocateRayQuery=178, RayQuery_TraceRayInline=179, RayQuery_Proceed=180,
// RayQuery_Abort=181, RayQuery_CommitNonOpaqueTriangleHit=182,
// RayQuery_CommitProceduralPrimitiveHit=183, RayQuery_CommittedStatus=184,
// RayQuery_CandidateType=185, RayQuery_CandidateObjectToWorld3x4=186,
// RayQuery_CandidateWorldToObject3x4=187,
// RayQuery_CommittedObjectToWorld3x4=188,
// RayQuery_CommittedWorldToObject3x4=189,
// RayQuery_CandidateProceduralPrimitiveNonOpaque=190,
// RayQuery_CandidateTriangleFrontFace=191,
// RayQuery_CommittedTriangleFrontFace=192,
// RayQuery_CandidateTriangleBarycentrics=193,
// RayQuery_CommittedTriangleBarycentrics=194, RayQuery_RayFlags=195,
// RayQuery_WorldRayOrigin=196, RayQuery_WorldRayDirection=197,
// RayQuery_RayTMin=198, RayQuery_CandidateTriangleRayT=199,
// RayQuery_CommittedRayT=200, RayQuery_CandidateInstanceIndex=201,
// RayQuery_CandidateInstanceID=202, RayQuery_CandidateGeometryIndex=203,
// RayQuery_CandidatePrimitiveIndex=204, RayQuery_CandidateObjectRayOrigin=205,
// RayQuery_CandidateObjectRayDirection=206,
// RayQuery_CommittedInstanceIndex=207, RayQuery_CommittedInstanceID=208,
// RayQuery_CommittedGeometryIndex=209, RayQuery_CommittedPrimitiveIndex=210,
// RayQuery_CommittedObjectRayOrigin=211,
// RayQuery_CommittedObjectRayDirection=212,
// RayQuery_CandidateInstanceContributionToHitGroupIndex=214,
// RayQuery_CommittedInstanceContributionToHitGroupIndex=215
if ((176 <= op && op <= 212) || (214 <= op && op <= 215))
  return (major > 6 || (major == 6 && minor >= 5));
// Instructions: DispatchMesh=173
if (op == 173)
  return (major > 6 || (major == 6 && minor >= 5))
      && (SK == DXIL::ShaderKind::Amplification);
// Instructions: WaveMatch=165, WaveMultiPrefixOp=166,
// WaveMultiPrefixBitCount=167
if ((165 <= op && op <= 167))
  return (major > 6 || (major == 6 && minor >= 5))
      && (SK == DXIL::ShaderKind::Library || SK == DXIL::ShaderKind::Compute || SK == DXIL::ShaderKind::Amplification || SK == DXIL::ShaderKind::Mesh || SK == DXIL::ShaderKind::Pixel || SK == DXIL::ShaderKind::Vertex || SK == DXIL::ShaderKind::Hull || SK == DXIL::ShaderKind::Domain || SK == DXIL::ShaderKind::Geometry || SK == DXIL::ShaderKind::RayGeneration || SK == DXIL::ShaderKind::Intersection || SK == DXIL::ShaderKind::AnyHit || SK == DXIL::ShaderKind::ClosestHit || SK == DXIL::ShaderKind::Miss || SK == DXIL::ShaderKind::Callable || SK == DXIL::ShaderKind::Node);
// Instructions: GeometryIndex=213
if (op == 213)
  return (major > 6 || (major == 6 && minor >= 5))
      && (SK == DXIL::ShaderKind::Library || SK == DXIL::ShaderKind::Intersection || SK == DXIL::ShaderKind::AnyHit || SK == DXIL::ShaderKind::ClosestHit);
// Instructions: WriteSamplerFeedback=174, WriteSamplerFeedbackBias=175
if ((174 <= op && op <= 175))
  return (major > 6 || (major == 6 && minor >= 5))
      && (SK == DXIL::ShaderKind::Library || SK == DXIL::ShaderKind::Pixel);
// Instructions: SetMeshOutputCounts=168, EmitIndices=169, GetMeshPayload=170,
// StoreVertexOutput=171, StorePrimitiveOutput=172
if ((168 <= op && op <= 172))
  return (major > 6 || (major == 6 && minor >= 5))
      && (SK == DXIL::ShaderKind::Mesh);
// Instructions: AnnotateHandle=216, CreateHandleFromBinding=217,
// CreateHandleFromHeap=218, Unpack4x8=219, Pack4x8=220, IsHelperLane=221
if ((216 <= op && op <= 221))
  return (major > 6 || (major == 6 && minor >= 6));
// Instructions: TextureGatherRaw=223, SampleCmpLevel=224,
// TextureStoreSample=225
if ((223 <= op && op <= 225))
  return (major > 6 || (major == 6 && minor >= 7));
// Instructions: QuadVote=222
if (op == 222)
  return (major > 6 || (major == 6 && minor >= 7))
      && (SK == DXIL::ShaderKind::Library || SK == DXIL::ShaderKind::Compute || SK == DXIL::ShaderKind::Amplification || SK == DXIL::ShaderKind::Mesh || SK == DXIL::ShaderKind::Pixel || SK == DXIL::ShaderKind::Node);
// Instructions: BarrierByMemoryType=244, BarrierByMemoryHandle=245,
// SampleCmpGrad=254
if ((244 <= op && op <= 245) || op == 254)
  return (major > 6 || (major == 6 && minor >= 8));
// Instructions: SampleCmpBias=255
if (op == 255)
  return (major > 6 || (major == 6 && minor >= 8))
      && (SK == DXIL::ShaderKind::Library || SK == DXIL::ShaderKind::Pixel || SK == DXIL::ShaderKind::Compute || SK == DXIL::ShaderKind::Amplification || SK == DXIL::ShaderKind::Mesh || SK == DXIL::ShaderKind::Node);
// Instructions: AllocateNodeOutputRecords=238, GetNodeRecordPtr=239,
// IncrementOutputCount=240, OutputComplete=241, GetInputRecordCount=242,
// FinishedCrossGroupSharing=243, BarrierByNodeRecordHandle=246,
// CreateNodeOutputHandle=247, IndexNodeHandle=248, AnnotateNodeHandle=249,
// CreateNodeInputRecordHandle=250, AnnotateNodeRecordHandle=251,
// NodeOutputIsValid=252, GetRemainingRecursionLevels=253
if ((238 <= op && op <= 243) || (246 <= op && op <= 253))
  return (major > 6 || (major == 6 && minor >= 8))
      && (SK == DXIL::ShaderKind::Node);
// Instructions: StartVertexLocation=256, StartInstanceLocation=257
if ((256 <= op && op <= 257))
  return (major > 6 || (major == 6 && minor >= 8))
      && (SK == DXIL::ShaderKind::Vertex);
// Instructions: AllocateRayQuery2=258, RawBufferVectorLoad=303,
// RawBufferVectorStore=304, MatVecMul=305, MatVecMulAdd=306,
// OuterProductAccumulate=307, VectorAccumulate=308
if (op == 258 || (303 <= op && op <= 308))
  return (major > 6 || (major == 6 && minor >= 9));
// Instructions: MaybeReorderThread=268
if (op == 268)
  return (major > 6 || (major == 6 && minor >= 9))
      && (SK == DXIL::ShaderKind::Library || SK == DXIL::ShaderKind::RayGeneration);
// Instructions: HitObject_TraceRay=262, HitObject_FromRayQuery=263,
// HitObject_FromRayQueryWithAttrs=264, HitObject_MakeMiss=265,
// HitObject_MakeNop=266, HitObject_Invoke=267, HitObject_IsMiss=269,
// HitObject_IsHit=270, HitObject_IsNop=271, HitObject_RayFlags=272,
// HitObject_RayTMin=273, HitObject_RayTCurrent=274,
// HitObject_WorldRayOrigin=275, HitObject_WorldRayDirection=276,
// HitObject_ObjectRayOrigin=277, HitObject_ObjectRayDirection=278,
// HitObject_ObjectToWorld3x4=279, HitObject_WorldToObject3x4=280,
// HitObject_GeometryIndex=281, HitObject_InstanceIndex=282,
// HitObject_InstanceID=283, HitObject_PrimitiveIndex=284,
// HitObject_HitKind=285, HitObject_ShaderTableIndex=286,
// HitObject_SetShaderTableIndex=287, HitObject_LoadLocalRootTableConstant=288,
// HitObject_Attributes=289
if ((262 <= op && op <= 267) || (269 <= op && op <= 289))
  return (major > 6 || (major == 6 && minor >= 9))
      && (SK == DXIL::ShaderKind::Library || SK == DXIL::ShaderKind::RayGeneration || SK == DXIL::ShaderKind::ClosestHit || SK == DXIL::ShaderKind::Miss);
return true;
}

static bool IsLLVMInstructionAllowed(llvm::Instruction &I) {
  unsigned op = I.getOpcode();// Instructions: Ret=1, Br=2, Switch=3, Add=8, FAdd=9, Sub=10, FSub=11, Mul=12,
// FMul=13, UDiv=14, SDiv=15, FDiv=16, URem=17, SRem=18, FRem=19, Shl=20,
// LShr=21, AShr=22, And=23, Or=24, Xor=25, Alloca=26, Load=27, Store=28,
// GetElementPtr=29, AtomicCmpXchg=31, AtomicRMW=32, Trunc=33, ZExt=34,
// SExt=35, FPToUI=36, FPToSI=37, UIToFP=38, SIToFP=39, FPTrunc=40, FPExt=41,
// BitCast=44, AddrSpaceCast=45, ICmp=46, FCmp=47, PHI=48, Call=49, Select=50,
// ExtractElement=54, InsertElement=55, ShuffleVector=56, ExtractValue=57
return (1 <= op && op <= 3) || (8 <= op && op <= 29) || (31 <= op && op <= 41) || (44 <= op && op <= 50) || (54 <= op && op <= 57);
}

void GetValidationVersion(unsigned *pMajor, unsigned *pMinor) {// 1.0 is the first validator.
// 1.1 adds:
// - ILDN container part support
// 1.2 adds:
// - Metadata for floating point denorm mode
// 1.3 adds:
// - Library support
// - Raytracing support
// - i64/f64 overloads for rawBufferLoad/Store
// 1.4 adds:
// - packed u8x4/i8x4 dot with accumulate to i32
// - half dot2 with accumulate to float
// 1.5 adds:
// - WaveMatch, WaveMultiPrefixOp, WaveMultiPrefixBitCount
// - HASH container part support
// - Mesh and Amplification shaders
// - DXR 1.1 & RayQuery support
*pMajor = 1;
*pMinor = 9;
}
}
