// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        (unknown)
// source: buf/alpha/registry/v1alpha1/repository.proto

package registryv1alpha1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Visibility int32

const (
	Visibility_VISIBILITY_UNSPECIFIED Visibility = 0
	Visibility_VISIBILITY_PUBLIC      Visibility = 1
	Visibility_VISIBILITY_PRIVATE     Visibility = 2
)

// Enum value maps for Visibility.
var (
	Visibility_name = map[int32]string{
		0: "VISIBILITY_UNSPECIFIED",
		1: "VISIBILITY_PUBLIC",
		2: "VISIBILITY_PRIVATE",
	}
	Visibility_value = map[string]int32{
		"VISIBILITY_UNSPECIFIED": 0,
		"VISIBILITY_PUBLIC":      1,
		"VISIBILITY_PRIVATE":     2,
	}
)

func (x Visibility) Enum() *Visibility {
	p := new(Visibility)
	*p = x
	return p
}

func (x Visibility) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Visibility) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_repository_proto_enumTypes[0].Descriptor()
}

func (Visibility) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_repository_proto_enumTypes[0]
}

func (x Visibility) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type Repository struct {
	state                         protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Id                 string                 `protobuf:"bytes,1,opt,name=id,proto3"`
	xxx_hidden_CreateTime         *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3"`
	xxx_hidden_UpdateTime         *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3"`
	xxx_hidden_Name               string                 `protobuf:"bytes,4,opt,name=name,proto3"`
	xxx_hidden_Owner              isRepository_Owner     `protobuf_oneof:"owner"`
	xxx_hidden_Visibility         Visibility             `protobuf:"varint,7,opt,name=visibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility"`
	xxx_hidden_Deprecated         bool                   `protobuf:"varint,8,opt,name=deprecated,proto3"`
	xxx_hidden_DeprecationMessage string                 `protobuf:"bytes,9,opt,name=deprecation_message,json=deprecationMessage,proto3"`
	xxx_hidden_OwnerName          string                 `protobuf:"bytes,10,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_Description        string                 `protobuf:"bytes,11,opt,name=description,proto3"`
	xxx_hidden_Url                string                 `protobuf:"bytes,12,opt,name=url,proto3"`
	xxx_hidden_DefaultBranch      string                 `protobuf:"bytes,13,opt,name=default_branch,json=defaultBranch,proto3"`
	unknownFields                 protoimpl.UnknownFields
	sizeCache                     protoimpl.SizeCache
}

func (x *Repository) Reset() {
	*x = Repository{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Repository) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Repository) ProtoMessage() {}

func (x *Repository) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Repository) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *Repository) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_CreateTime
	}
	return nil
}

func (x *Repository) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_UpdateTime
	}
	return nil
}

func (x *Repository) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *Repository) GetUserId() string {
	if x != nil {
		if x, ok := x.xxx_hidden_Owner.(*repository_UserId); ok {
			return x.UserId
		}
	}
	return ""
}

func (x *Repository) GetOrganizationId() string {
	if x != nil {
		if x, ok := x.xxx_hidden_Owner.(*repository_OrganizationId); ok {
			return x.OrganizationId
		}
	}
	return ""
}

func (x *Repository) GetVisibility() Visibility {
	if x != nil {
		return x.xxx_hidden_Visibility
	}
	return Visibility_VISIBILITY_UNSPECIFIED
}

func (x *Repository) GetDeprecated() bool {
	if x != nil {
		return x.xxx_hidden_Deprecated
	}
	return false
}

func (x *Repository) GetDeprecationMessage() string {
	if x != nil {
		return x.xxx_hidden_DeprecationMessage
	}
	return ""
}

func (x *Repository) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *Repository) GetDescription() string {
	if x != nil {
		return x.xxx_hidden_Description
	}
	return ""
}

func (x *Repository) GetUrl() string {
	if x != nil {
		return x.xxx_hidden_Url
	}
	return ""
}

func (x *Repository) GetDefaultBranch() string {
	if x != nil {
		return x.xxx_hidden_DefaultBranch
	}
	return ""
}

func (x *Repository) SetId(v string) {
	x.xxx_hidden_Id = v
}

func (x *Repository) SetCreateTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_CreateTime = v
}

func (x *Repository) SetUpdateTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_UpdateTime = v
}

func (x *Repository) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *Repository) SetUserId(v string) {
	x.xxx_hidden_Owner = &repository_UserId{v}
}

func (x *Repository) SetOrganizationId(v string) {
	x.xxx_hidden_Owner = &repository_OrganizationId{v}
}

func (x *Repository) SetVisibility(v Visibility) {
	x.xxx_hidden_Visibility = v
}

func (x *Repository) SetDeprecated(v bool) {
	x.xxx_hidden_Deprecated = v
}

func (x *Repository) SetDeprecationMessage(v string) {
	x.xxx_hidden_DeprecationMessage = v
}

func (x *Repository) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *Repository) SetDescription(v string) {
	x.xxx_hidden_Description = v
}

func (x *Repository) SetUrl(v string) {
	x.xxx_hidden_Url = v
}

func (x *Repository) SetDefaultBranch(v string) {
	x.xxx_hidden_DefaultBranch = v
}

func (x *Repository) HasCreateTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_CreateTime != nil
}

func (x *Repository) HasUpdateTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_UpdateTime != nil
}

func (x *Repository) HasOwner() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Owner != nil
}

func (x *Repository) HasUserId() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Owner.(*repository_UserId)
	return ok
}

func (x *Repository) HasOrganizationId() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Owner.(*repository_OrganizationId)
	return ok
}

func (x *Repository) ClearCreateTime() {
	x.xxx_hidden_CreateTime = nil
}

func (x *Repository) ClearUpdateTime() {
	x.xxx_hidden_UpdateTime = nil
}

func (x *Repository) ClearOwner() {
	x.xxx_hidden_Owner = nil
}

func (x *Repository) ClearUserId() {
	if _, ok := x.xxx_hidden_Owner.(*repository_UserId); ok {
		x.xxx_hidden_Owner = nil
	}
}

func (x *Repository) ClearOrganizationId() {
	if _, ok := x.xxx_hidden_Owner.(*repository_OrganizationId); ok {
		x.xxx_hidden_Owner = nil
	}
}

const Repository_Owner_not_set_case case_Repository_Owner = 0
const Repository_UserId_case case_Repository_Owner = 5
const Repository_OrganizationId_case case_Repository_Owner = 6

func (x *Repository) WhichOwner() case_Repository_Owner {
	if x == nil {
		return Repository_Owner_not_set_case
	}
	switch x.xxx_hidden_Owner.(type) {
	case *repository_UserId:
		return Repository_UserId_case
	case *repository_OrganizationId:
		return Repository_OrganizationId_case
	default:
		return Repository_Owner_not_set_case
	}
}

type Repository_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// primary key, unique, immutable
	Id string
	// immutable
	CreateTime *timestamppb.Timestamp
	// mutable
	UpdateTime *timestamppb.Timestamp
	// unique, mutable
	Name string
	// Fields of oneof xxx_hidden_Owner:
	// foreign key, mutable
	UserId *string
	// foreign key, mutable
	OrganizationId *string
	// -- end of xxx_hidden_Owner
	Visibility Visibility
	// deprecated means this repository is deprecated.
	Deprecated bool
	// deprecation_message is the message shown if the repository is deprecated.
	DeprecationMessage string
	// owner_name is the name of the owner of the repository,
	// either a username or organization name.
	OwnerName string
	// description is the user configurable description of the repository.
	Description string
	// url is the user configurable URL in the description of the repository,
	// always included the scheme and will not have a #fragment suffix.
	Url string
	// default_branch in a BSR repository. It is used when syncing a git repository, to make sure both
	// default branches (BSR and Git) are in sync. By default, every BSR repository is created with a
	// "main" default branch.
	DefaultBranch string
}

func (b0 Repository_builder) Build() *Repository {
	m0 := &Repository{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	x.xxx_hidden_CreateTime = b.CreateTime
	x.xxx_hidden_UpdateTime = b.UpdateTime
	x.xxx_hidden_Name = b.Name
	if b.UserId != nil {
		x.xxx_hidden_Owner = &repository_UserId{*b.UserId}
	}
	if b.OrganizationId != nil {
		x.xxx_hidden_Owner = &repository_OrganizationId{*b.OrganizationId}
	}
	x.xxx_hidden_Visibility = b.Visibility
	x.xxx_hidden_Deprecated = b.Deprecated
	x.xxx_hidden_DeprecationMessage = b.DeprecationMessage
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_Description = b.Description
	x.xxx_hidden_Url = b.Url
	x.xxx_hidden_DefaultBranch = b.DefaultBranch
	return m0
}

type case_Repository_Owner protoreflect.FieldNumber

func (x case_Repository_Owner) String() string {
	md := file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[0].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isRepository_Owner interface {
	isRepository_Owner()
}

type repository_UserId struct {
	// foreign key, mutable
	UserId string `protobuf:"bytes,5,opt,name=user_id,json=userId,proto3,oneof"`
}

type repository_OrganizationId struct {
	// foreign key, mutable
	OrganizationId string `protobuf:"bytes,6,opt,name=organization_id,json=organizationId,proto3,oneof"`
}

func (*repository_UserId) isRepository_Owner() {}

func (*repository_OrganizationId) isRepository_Owner() {}

type RepositoryCounts struct {
	state                  protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_TagsCount   uint32                 `protobuf:"varint,1,opt,name=tags_count,json=tagsCount,proto3"`
	xxx_hidden_DraftsCount uint32                 `protobuf:"varint,3,opt,name=drafts_count,json=draftsCount,proto3"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *RepositoryCounts) Reset() {
	*x = RepositoryCounts{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RepositoryCounts) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RepositoryCounts) ProtoMessage() {}

func (x *RepositoryCounts) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *RepositoryCounts) GetTagsCount() uint32 {
	if x != nil {
		return x.xxx_hidden_TagsCount
	}
	return 0
}

func (x *RepositoryCounts) GetDraftsCount() uint32 {
	if x != nil {
		return x.xxx_hidden_DraftsCount
	}
	return 0
}

func (x *RepositoryCounts) SetTagsCount(v uint32) {
	x.xxx_hidden_TagsCount = v
}

func (x *RepositoryCounts) SetDraftsCount(v uint32) {
	x.xxx_hidden_DraftsCount = v
}

type RepositoryCounts_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	TagsCount   uint32
	DraftsCount uint32
}

func (b0 RepositoryCounts_builder) Build() *RepositoryCounts {
	m0 := &RepositoryCounts{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_TagsCount = b.TagsCount
	x.xxx_hidden_DraftsCount = b.DraftsCount
	return m0
}

type RepositoryContributor struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_User         *User                  `protobuf:"bytes,1,opt,name=user,proto3"`
	xxx_hidden_RepositoryId string                 `protobuf:"bytes,2,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_ExplicitRole RepositoryRole         `protobuf:"varint,3,opt,name=explicit_role,json=explicitRole,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole"`
	xxx_hidden_ImplicitRole RepositoryRole         `protobuf:"varint,4,opt,name=implicit_role,json=implicitRole,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *RepositoryContributor) Reset() {
	*x = RepositoryContributor{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RepositoryContributor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RepositoryContributor) ProtoMessage() {}

func (x *RepositoryContributor) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *RepositoryContributor) GetUser() *User {
	if x != nil {
		return x.xxx_hidden_User
	}
	return nil
}

func (x *RepositoryContributor) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *RepositoryContributor) GetExplicitRole() RepositoryRole {
	if x != nil {
		return x.xxx_hidden_ExplicitRole
	}
	return RepositoryRole_REPOSITORY_ROLE_UNSPECIFIED
}

func (x *RepositoryContributor) GetImplicitRole() RepositoryRole {
	if x != nil {
		return x.xxx_hidden_ImplicitRole
	}
	return RepositoryRole_REPOSITORY_ROLE_UNSPECIFIED
}

func (x *RepositoryContributor) SetUser(v *User) {
	x.xxx_hidden_User = v
}

func (x *RepositoryContributor) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *RepositoryContributor) SetExplicitRole(v RepositoryRole) {
	x.xxx_hidden_ExplicitRole = v
}

func (x *RepositoryContributor) SetImplicitRole(v RepositoryRole) {
	x.xxx_hidden_ImplicitRole = v
}

func (x *RepositoryContributor) HasUser() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_User != nil
}

func (x *RepositoryContributor) ClearUser() {
	x.xxx_hidden_User = nil
}

type RepositoryContributor_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	User *User
	// The ID of the for which the role belongs to.
	RepositoryId string
	// The role that the user has been explicitly assigned against the repository.
	ExplicitRole RepositoryRole
	// Optionally defines the role that the user has implicitly against the repository through the owning organization.
	// If the repository does not belong to an organization or the user is not part of the owning organization, this is unset.
	ImplicitRole RepositoryRole
}

func (b0 RepositoryContributor_builder) Build() *RepositoryContributor {
	m0 := &RepositoryContributor{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_User = b.User
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_ExplicitRole = b.ExplicitRole
	x.xxx_hidden_ImplicitRole = b.ImplicitRole
	return m0
}

type RepositoryMetadata struct {
	state                              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Id                      string                 `protobuf:"bytes,1,opt,name=id,proto3"`
	xxx_hidden_Name                    string                 `protobuf:"bytes,2,opt,name=name,proto3"`
	xxx_hidden_OwnerName               string                 `protobuf:"bytes,3,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_OwnerVerificationStatus VerificationStatus     `protobuf:"varint,4,opt,name=owner_verification_status,json=ownerVerificationStatus,proto3,enum=buf.alpha.registry.v1alpha1.VerificationStatus"`
	xxx_hidden_LatestCommitTime        *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=latest_commit_time,json=latestCommitTime,proto3"`
	xxx_hidden_LatestSpdxLicenseId     string                 `protobuf:"bytes,6,opt,name=latest_spdx_license_id,json=latestSpdxLicenseId,proto3"`
	unknownFields                      protoimpl.UnknownFields
	sizeCache                          protoimpl.SizeCache
}

func (x *RepositoryMetadata) Reset() {
	*x = RepositoryMetadata{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RepositoryMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RepositoryMetadata) ProtoMessage() {}

func (x *RepositoryMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *RepositoryMetadata) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *RepositoryMetadata) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *RepositoryMetadata) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *RepositoryMetadata) GetOwnerVerificationStatus() VerificationStatus {
	if x != nil {
		return x.xxx_hidden_OwnerVerificationStatus
	}
	return VerificationStatus_VERIFICATION_STATUS_UNSPECIFIED
}

func (x *RepositoryMetadata) GetLatestCommitTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_LatestCommitTime
	}
	return nil
}

func (x *RepositoryMetadata) GetLatestSpdxLicenseId() string {
	if x != nil {
		return x.xxx_hidden_LatestSpdxLicenseId
	}
	return ""
}

func (x *RepositoryMetadata) SetId(v string) {
	x.xxx_hidden_Id = v
}

func (x *RepositoryMetadata) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *RepositoryMetadata) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *RepositoryMetadata) SetOwnerVerificationStatus(v VerificationStatus) {
	x.xxx_hidden_OwnerVerificationStatus = v
}

func (x *RepositoryMetadata) SetLatestCommitTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_LatestCommitTime = v
}

func (x *RepositoryMetadata) SetLatestSpdxLicenseId(v string) {
	x.xxx_hidden_LatestSpdxLicenseId = v
}

func (x *RepositoryMetadata) HasLatestCommitTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_LatestCommitTime != nil
}

func (x *RepositoryMetadata) ClearLatestCommitTime() {
	x.xxx_hidden_LatestCommitTime = nil
}

type RepositoryMetadata_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the repository.
	Id string
	// The name of the repository.
	Name string
	// The owner name of the repository.
	OwnerName string
	// The verification status of the owner of the repository.
	OwnerVerificationStatus VerificationStatus
	// The commit time of the latest main commit in the repository.
	LatestCommitTime *timestamppb.Timestamp
	// The SPDX license ID of the latest main commit in the repository.
	LatestSpdxLicenseId string
}

func (b0 RepositoryMetadata_builder) Build() *RepositoryMetadata {
	m0 := &RepositoryMetadata{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_OwnerVerificationStatus = b.OwnerVerificationStatus
	x.xxx_hidden_LatestCommitTime = b.LatestCommitTime
	x.xxx_hidden_LatestSpdxLicenseId = b.LatestSpdxLicenseId
	return m0
}

type GetRepositoriesByFullNameRequest struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_FullNames []string               `protobuf:"bytes,1,rep,name=full_names,json=fullNames,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *GetRepositoriesByFullNameRequest) Reset() {
	*x = GetRepositoriesByFullNameRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepositoriesByFullNameRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositoriesByFullNameRequest) ProtoMessage() {}

func (x *GetRepositoriesByFullNameRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRepositoriesByFullNameRequest) GetFullNames() []string {
	if x != nil {
		return x.xxx_hidden_FullNames
	}
	return nil
}

func (x *GetRepositoriesByFullNameRequest) SetFullNames(v []string) {
	x.xxx_hidden_FullNames = v
}

type GetRepositoriesByFullNameRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// minimum length is 1
	// maximum length is 250
	FullNames []string
}

func (b0 GetRepositoriesByFullNameRequest_builder) Build() *GetRepositoriesByFullNameRequest {
	m0 := &GetRepositoriesByFullNameRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_FullNames = b.FullNames
	return m0
}

type GetRepositoriesByFullNameResponse struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Repositories *[]*Repository         `protobuf:"bytes,1,rep,name=repositories,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *GetRepositoriesByFullNameResponse) Reset() {
	*x = GetRepositoriesByFullNameResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepositoriesByFullNameResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositoriesByFullNameResponse) ProtoMessage() {}

func (x *GetRepositoriesByFullNameResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRepositoriesByFullNameResponse) GetRepositories() []*Repository {
	if x != nil {
		if x.xxx_hidden_Repositories != nil {
			return *x.xxx_hidden_Repositories
		}
	}
	return nil
}

func (x *GetRepositoriesByFullNameResponse) SetRepositories(v []*Repository) {
	x.xxx_hidden_Repositories = &v
}

type GetRepositoriesByFullNameResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Repositories []*Repository
}

func (b0 GetRepositoriesByFullNameResponse_builder) Build() *GetRepositoriesByFullNameResponse {
	m0 := &GetRepositoriesByFullNameResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Repositories = &b.Repositories
	return m0
}

type GetRepositoryRequest struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Id string                 `protobuf:"bytes,1,opt,name=id,proto3"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetRepositoryRequest) Reset() {
	*x = GetRepositoryRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepositoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositoryRequest) ProtoMessage() {}

func (x *GetRepositoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRepositoryRequest) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *GetRepositoryRequest) SetId(v string) {
	x.xxx_hidden_Id = v
}

type GetRepositoryRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Id string
}

func (b0 GetRepositoryRequest_builder) Build() *GetRepositoryRequest {
	m0 := &GetRepositoryRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	return m0
}

type GetRepositoryResponse struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Repository *Repository            `protobuf:"bytes,1,opt,name=repository,proto3"`
	xxx_hidden_Counts     *RepositoryCounts      `protobuf:"bytes,2,opt,name=counts,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *GetRepositoryResponse) Reset() {
	*x = GetRepositoryResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepositoryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositoryResponse) ProtoMessage() {}

func (x *GetRepositoryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRepositoryResponse) GetRepository() *Repository {
	if x != nil {
		return x.xxx_hidden_Repository
	}
	return nil
}

func (x *GetRepositoryResponse) GetCounts() *RepositoryCounts {
	if x != nil {
		return x.xxx_hidden_Counts
	}
	return nil
}

func (x *GetRepositoryResponse) SetRepository(v *Repository) {
	x.xxx_hidden_Repository = v
}

func (x *GetRepositoryResponse) SetCounts(v *RepositoryCounts) {
	x.xxx_hidden_Counts = v
}

func (x *GetRepositoryResponse) HasRepository() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Repository != nil
}

func (x *GetRepositoryResponse) HasCounts() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Counts != nil
}

func (x *GetRepositoryResponse) ClearRepository() {
	x.xxx_hidden_Repository = nil
}

func (x *GetRepositoryResponse) ClearCounts() {
	x.xxx_hidden_Counts = nil
}

type GetRepositoryResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Repository *Repository
	Counts     *RepositoryCounts
}

func (b0 GetRepositoryResponse_builder) Build() *GetRepositoryResponse {
	m0 := &GetRepositoryResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Repository = b.Repository
	x.xxx_hidden_Counts = b.Counts
	return m0
}

type GetRepositoryByFullNameRequest struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_FullName string                 `protobuf:"bytes,1,opt,name=full_name,json=fullName,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *GetRepositoryByFullNameRequest) Reset() {
	*x = GetRepositoryByFullNameRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepositoryByFullNameRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositoryByFullNameRequest) ProtoMessage() {}

func (x *GetRepositoryByFullNameRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRepositoryByFullNameRequest) GetFullName() string {
	if x != nil {
		return x.xxx_hidden_FullName
	}
	return ""
}

func (x *GetRepositoryByFullNameRequest) SetFullName(v string) {
	x.xxx_hidden_FullName = v
}

type GetRepositoryByFullNameRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	FullName string
}

func (b0 GetRepositoryByFullNameRequest_builder) Build() *GetRepositoryByFullNameRequest {
	m0 := &GetRepositoryByFullNameRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_FullName = b.FullName
	return m0
}

type GetRepositoryByFullNameResponse struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Repository *Repository            `protobuf:"bytes,1,opt,name=repository,proto3"`
	xxx_hidden_Counts     *RepositoryCounts      `protobuf:"bytes,2,opt,name=counts,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *GetRepositoryByFullNameResponse) Reset() {
	*x = GetRepositoryByFullNameResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepositoryByFullNameResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositoryByFullNameResponse) ProtoMessage() {}

func (x *GetRepositoryByFullNameResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRepositoryByFullNameResponse) GetRepository() *Repository {
	if x != nil {
		return x.xxx_hidden_Repository
	}
	return nil
}

func (x *GetRepositoryByFullNameResponse) GetCounts() *RepositoryCounts {
	if x != nil {
		return x.xxx_hidden_Counts
	}
	return nil
}

func (x *GetRepositoryByFullNameResponse) SetRepository(v *Repository) {
	x.xxx_hidden_Repository = v
}

func (x *GetRepositoryByFullNameResponse) SetCounts(v *RepositoryCounts) {
	x.xxx_hidden_Counts = v
}

func (x *GetRepositoryByFullNameResponse) HasRepository() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Repository != nil
}

func (x *GetRepositoryByFullNameResponse) HasCounts() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Counts != nil
}

func (x *GetRepositoryByFullNameResponse) ClearRepository() {
	x.xxx_hidden_Repository = nil
}

func (x *GetRepositoryByFullNameResponse) ClearCounts() {
	x.xxx_hidden_Counts = nil
}

type GetRepositoryByFullNameResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Repository *Repository
	Counts     *RepositoryCounts
}

func (b0 GetRepositoryByFullNameResponse_builder) Build() *GetRepositoryByFullNameResponse {
	m0 := &GetRepositoryByFullNameResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Repository = b.Repository
	x.xxx_hidden_Counts = b.Counts
	return m0
}

type ListRepositoriesRequest struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_PageSize  uint32                 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken string                 `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_Reverse   bool                   `protobuf:"varint,3,opt,name=reverse,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *ListRepositoriesRequest) Reset() {
	*x = ListRepositoriesRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRepositoriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRepositoriesRequest) ProtoMessage() {}

func (x *ListRepositoriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListRepositoriesRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *ListRepositoriesRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *ListRepositoriesRequest) GetReverse() bool {
	if x != nil {
		return x.xxx_hidden_Reverse
	}
	return false
}

func (x *ListRepositoriesRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *ListRepositoriesRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

func (x *ListRepositoriesRequest) SetReverse(v bool) {
	x.xxx_hidden_Reverse = v
}

type ListRepositoriesRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	PageSize uint32
	// The first page is returned if this is empty.
	PageToken string
	Reverse   bool
}

func (b0 ListRepositoriesRequest_builder) Build() *ListRepositoriesRequest {
	m0 := &ListRepositoriesRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_Reverse = b.Reverse
	return m0
}

type ListRepositoriesResponse struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Repositories  *[]*Repository         `protobuf:"bytes,1,rep,name=repositories,proto3"`
	xxx_hidden_NextPageToken string                 `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *ListRepositoriesResponse) Reset() {
	*x = ListRepositoriesResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRepositoriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRepositoriesResponse) ProtoMessage() {}

func (x *ListRepositoriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListRepositoriesResponse) GetRepositories() []*Repository {
	if x != nil {
		if x.xxx_hidden_Repositories != nil {
			return *x.xxx_hidden_Repositories
		}
	}
	return nil
}

func (x *ListRepositoriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *ListRepositoriesResponse) SetRepositories(v []*Repository) {
	x.xxx_hidden_Repositories = &v
}

func (x *ListRepositoriesResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

type ListRepositoriesResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Repositories []*Repository
	// There are no more pages if this is empty.
	NextPageToken string
}

func (b0 ListRepositoriesResponse_builder) Build() *ListRepositoriesResponse {
	m0 := &ListRepositoriesResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Repositories = &b.Repositories
	x.xxx_hidden_NextPageToken = b.NextPageToken
	return m0
}

type ListUserRepositoriesRequest struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_UserId    string                 `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3"`
	xxx_hidden_PageSize  uint32                 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken string                 `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_Reverse   bool                   `protobuf:"varint,4,opt,name=reverse,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *ListUserRepositoriesRequest) Reset() {
	*x = ListUserRepositoriesRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListUserRepositoriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListUserRepositoriesRequest) ProtoMessage() {}

func (x *ListUserRepositoriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListUserRepositoriesRequest) GetUserId() string {
	if x != nil {
		return x.xxx_hidden_UserId
	}
	return ""
}

func (x *ListUserRepositoriesRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *ListUserRepositoriesRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *ListUserRepositoriesRequest) GetReverse() bool {
	if x != nil {
		return x.xxx_hidden_Reverse
	}
	return false
}

func (x *ListUserRepositoriesRequest) SetUserId(v string) {
	x.xxx_hidden_UserId = v
}

func (x *ListUserRepositoriesRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *ListUserRepositoriesRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

func (x *ListUserRepositoriesRequest) SetReverse(v bool) {
	x.xxx_hidden_Reverse = v
}

type ListUserRepositoriesRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the user whose repositories should be listed.
	UserId   string
	PageSize uint32
	// The first page is returned if this is empty.
	PageToken string
	Reverse   bool
}

func (b0 ListUserRepositoriesRequest_builder) Build() *ListUserRepositoriesRequest {
	m0 := &ListUserRepositoriesRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_UserId = b.UserId
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_Reverse = b.Reverse
	return m0
}

type ListUserRepositoriesResponse struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Repositories  *[]*Repository         `protobuf:"bytes,1,rep,name=repositories,proto3"`
	xxx_hidden_NextPageToken string                 `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *ListUserRepositoriesResponse) Reset() {
	*x = ListUserRepositoriesResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListUserRepositoriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListUserRepositoriesResponse) ProtoMessage() {}

func (x *ListUserRepositoriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListUserRepositoriesResponse) GetRepositories() []*Repository {
	if x != nil {
		if x.xxx_hidden_Repositories != nil {
			return *x.xxx_hidden_Repositories
		}
	}
	return nil
}

func (x *ListUserRepositoriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *ListUserRepositoriesResponse) SetRepositories(v []*Repository) {
	x.xxx_hidden_Repositories = &v
}

func (x *ListUserRepositoriesResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

type ListUserRepositoriesResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Repositories []*Repository
	// There are no more pages if this is empty.
	NextPageToken string
}

func (b0 ListUserRepositoriesResponse_builder) Build() *ListUserRepositoriesResponse {
	m0 := &ListUserRepositoriesResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Repositories = &b.Repositories
	x.xxx_hidden_NextPageToken = b.NextPageToken
	return m0
}

type ListRepositoriesUserCanAccessRequest struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_PageSize  uint32                 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken string                 `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_Reverse   bool                   `protobuf:"varint,3,opt,name=reverse,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *ListRepositoriesUserCanAccessRequest) Reset() {
	*x = ListRepositoriesUserCanAccessRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRepositoriesUserCanAccessRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRepositoriesUserCanAccessRequest) ProtoMessage() {}

func (x *ListRepositoriesUserCanAccessRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListRepositoriesUserCanAccessRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *ListRepositoriesUserCanAccessRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *ListRepositoriesUserCanAccessRequest) GetReverse() bool {
	if x != nil {
		return x.xxx_hidden_Reverse
	}
	return false
}

func (x *ListRepositoriesUserCanAccessRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *ListRepositoriesUserCanAccessRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

func (x *ListRepositoriesUserCanAccessRequest) SetReverse(v bool) {
	x.xxx_hidden_Reverse = v
}

type ListRepositoriesUserCanAccessRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	PageSize uint32
	// The first page is returned if this is empty.
	PageToken string
	Reverse   bool
}

func (b0 ListRepositoriesUserCanAccessRequest_builder) Build() *ListRepositoriesUserCanAccessRequest {
	m0 := &ListRepositoriesUserCanAccessRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_Reverse = b.Reverse
	return m0
}

type ListRepositoriesUserCanAccessResponse struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Repositories  *[]*Repository         `protobuf:"bytes,1,rep,name=repositories,proto3"`
	xxx_hidden_NextPageToken string                 `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *ListRepositoriesUserCanAccessResponse) Reset() {
	*x = ListRepositoriesUserCanAccessResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRepositoriesUserCanAccessResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRepositoriesUserCanAccessResponse) ProtoMessage() {}

func (x *ListRepositoriesUserCanAccessResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListRepositoriesUserCanAccessResponse) GetRepositories() []*Repository {
	if x != nil {
		if x.xxx_hidden_Repositories != nil {
			return *x.xxx_hidden_Repositories
		}
	}
	return nil
}

func (x *ListRepositoriesUserCanAccessResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *ListRepositoriesUserCanAccessResponse) SetRepositories(v []*Repository) {
	x.xxx_hidden_Repositories = &v
}

func (x *ListRepositoriesUserCanAccessResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

type ListRepositoriesUserCanAccessResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Repositories []*Repository
	// There are no more pages if this is empty.
	NextPageToken string
}

func (b0 ListRepositoriesUserCanAccessResponse_builder) Build() *ListRepositoriesUserCanAccessResponse {
	m0 := &ListRepositoriesUserCanAccessResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Repositories = &b.Repositories
	x.xxx_hidden_NextPageToken = b.NextPageToken
	return m0
}

type ListOrganizationRepositoriesRequest struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId string                 `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	xxx_hidden_PageSize       uint32                 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken      string                 `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_Reverse        bool                   `protobuf:"varint,4,opt,name=reverse,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *ListOrganizationRepositoriesRequest) Reset() {
	*x = ListOrganizationRepositoriesRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListOrganizationRepositoriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOrganizationRepositoriesRequest) ProtoMessage() {}

func (x *ListOrganizationRepositoriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListOrganizationRepositoriesRequest) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *ListOrganizationRepositoriesRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *ListOrganizationRepositoriesRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *ListOrganizationRepositoriesRequest) GetReverse() bool {
	if x != nil {
		return x.xxx_hidden_Reverse
	}
	return false
}

func (x *ListOrganizationRepositoriesRequest) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

func (x *ListOrganizationRepositoriesRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *ListOrganizationRepositoriesRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

func (x *ListOrganizationRepositoriesRequest) SetReverse(v bool) {
	x.xxx_hidden_Reverse = v
}

type ListOrganizationRepositoriesRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the organization whose repositories should be listed.
	OrganizationId string
	PageSize       uint32
	// The first page is returned if this is empty.
	PageToken string
	Reverse   bool
}

func (b0 ListOrganizationRepositoriesRequest_builder) Build() *ListOrganizationRepositoriesRequest {
	m0 := &ListOrganizationRepositoriesRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_Reverse = b.Reverse
	return m0
}

type ListOrganizationRepositoriesResponse struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Repositories  *[]*Repository         `protobuf:"bytes,1,rep,name=repositories,proto3"`
	xxx_hidden_NextPageToken string                 `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *ListOrganizationRepositoriesResponse) Reset() {
	*x = ListOrganizationRepositoriesResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListOrganizationRepositoriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOrganizationRepositoriesResponse) ProtoMessage() {}

func (x *ListOrganizationRepositoriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListOrganizationRepositoriesResponse) GetRepositories() []*Repository {
	if x != nil {
		if x.xxx_hidden_Repositories != nil {
			return *x.xxx_hidden_Repositories
		}
	}
	return nil
}

func (x *ListOrganizationRepositoriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *ListOrganizationRepositoriesResponse) SetRepositories(v []*Repository) {
	x.xxx_hidden_Repositories = &v
}

func (x *ListOrganizationRepositoriesResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

type ListOrganizationRepositoriesResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Repositories []*Repository
	// There are no more pages if this is empty.
	NextPageToken string
}

func (b0 ListOrganizationRepositoriesResponse_builder) Build() *ListOrganizationRepositoriesResponse {
	m0 := &ListOrganizationRepositoriesResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Repositories = &b.Repositories
	x.xxx_hidden_NextPageToken = b.NextPageToken
	return m0
}

type CreateRepositoryByFullNameRequest struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_FullName   string                 `protobuf:"bytes,1,opt,name=full_name,json=fullName,proto3"`
	xxx_hidden_Visibility Visibility             `protobuf:"varint,2,opt,name=visibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *CreateRepositoryByFullNameRequest) Reset() {
	*x = CreateRepositoryByFullNameRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateRepositoryByFullNameRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRepositoryByFullNameRequest) ProtoMessage() {}

func (x *CreateRepositoryByFullNameRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateRepositoryByFullNameRequest) GetFullName() string {
	if x != nil {
		return x.xxx_hidden_FullName
	}
	return ""
}

func (x *CreateRepositoryByFullNameRequest) GetVisibility() Visibility {
	if x != nil {
		return x.xxx_hidden_Visibility
	}
	return Visibility_VISIBILITY_UNSPECIFIED
}

func (x *CreateRepositoryByFullNameRequest) SetFullName(v string) {
	x.xxx_hidden_FullName = v
}

func (x *CreateRepositoryByFullNameRequest) SetVisibility(v Visibility) {
	x.xxx_hidden_Visibility = v
}

type CreateRepositoryByFullNameRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Must be unique across repositories.
	FullName   string
	Visibility Visibility
}

func (b0 CreateRepositoryByFullNameRequest_builder) Build() *CreateRepositoryByFullNameRequest {
	m0 := &CreateRepositoryByFullNameRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_FullName = b.FullName
	x.xxx_hidden_Visibility = b.Visibility
	return m0
}

type CreateRepositoryByFullNameResponse struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Repository *Repository            `protobuf:"bytes,1,opt,name=repository,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *CreateRepositoryByFullNameResponse) Reset() {
	*x = CreateRepositoryByFullNameResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateRepositoryByFullNameResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRepositoryByFullNameResponse) ProtoMessage() {}

func (x *CreateRepositoryByFullNameResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateRepositoryByFullNameResponse) GetRepository() *Repository {
	if x != nil {
		return x.xxx_hidden_Repository
	}
	return nil
}

func (x *CreateRepositoryByFullNameResponse) SetRepository(v *Repository) {
	x.xxx_hidden_Repository = v
}

func (x *CreateRepositoryByFullNameResponse) HasRepository() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Repository != nil
}

func (x *CreateRepositoryByFullNameResponse) ClearRepository() {
	x.xxx_hidden_Repository = nil
}

type CreateRepositoryByFullNameResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Repository *Repository
}

func (b0 CreateRepositoryByFullNameResponse_builder) Build() *CreateRepositoryByFullNameResponse {
	m0 := &CreateRepositoryByFullNameResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Repository = b.Repository
	return m0
}

type DeleteRepositoryRequest struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Id string                 `protobuf:"bytes,1,opt,name=id,proto3"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteRepositoryRequest) Reset() {
	*x = DeleteRepositoryRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteRepositoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRepositoryRequest) ProtoMessage() {}

func (x *DeleteRepositoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DeleteRepositoryRequest) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *DeleteRepositoryRequest) SetId(v string) {
	x.xxx_hidden_Id = v
}

type DeleteRepositoryRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Id string
}

func (b0 DeleteRepositoryRequest_builder) Build() *DeleteRepositoryRequest {
	m0 := &DeleteRepositoryRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	return m0
}

type DeleteRepositoryResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteRepositoryResponse) Reset() {
	*x = DeleteRepositoryResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteRepositoryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRepositoryResponse) ProtoMessage() {}

func (x *DeleteRepositoryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type DeleteRepositoryResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 DeleteRepositoryResponse_builder) Build() *DeleteRepositoryResponse {
	m0 := &DeleteRepositoryResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type DeleteRepositoryByFullNameRequest struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_FullName string                 `protobuf:"bytes,1,opt,name=full_name,json=fullName,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *DeleteRepositoryByFullNameRequest) Reset() {
	*x = DeleteRepositoryByFullNameRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteRepositoryByFullNameRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRepositoryByFullNameRequest) ProtoMessage() {}

func (x *DeleteRepositoryByFullNameRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DeleteRepositoryByFullNameRequest) GetFullName() string {
	if x != nil {
		return x.xxx_hidden_FullName
	}
	return ""
}

func (x *DeleteRepositoryByFullNameRequest) SetFullName(v string) {
	x.xxx_hidden_FullName = v
}

type DeleteRepositoryByFullNameRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	FullName string
}

func (b0 DeleteRepositoryByFullNameRequest_builder) Build() *DeleteRepositoryByFullNameRequest {
	m0 := &DeleteRepositoryByFullNameRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_FullName = b.FullName
	return m0
}

type DeleteRepositoryByFullNameResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteRepositoryByFullNameResponse) Reset() {
	*x = DeleteRepositoryByFullNameResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteRepositoryByFullNameResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRepositoryByFullNameResponse) ProtoMessage() {}

func (x *DeleteRepositoryByFullNameResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type DeleteRepositoryByFullNameResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 DeleteRepositoryByFullNameResponse_builder) Build() *DeleteRepositoryByFullNameResponse {
	m0 := &DeleteRepositoryByFullNameResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type DeprecateRepositoryByNameRequest struct {
	state                         protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerName          string                 `protobuf:"bytes,1,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_RepositoryName     string                 `protobuf:"bytes,2,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_DeprecationMessage string                 `protobuf:"bytes,3,opt,name=deprecation_message,json=deprecationMessage,proto3"`
	unknownFields                 protoimpl.UnknownFields
	sizeCache                     protoimpl.SizeCache
}

func (x *DeprecateRepositoryByNameRequest) Reset() {
	*x = DeprecateRepositoryByNameRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeprecateRepositoryByNameRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeprecateRepositoryByNameRequest) ProtoMessage() {}

func (x *DeprecateRepositoryByNameRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DeprecateRepositoryByNameRequest) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *DeprecateRepositoryByNameRequest) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *DeprecateRepositoryByNameRequest) GetDeprecationMessage() string {
	if x != nil {
		return x.xxx_hidden_DeprecationMessage
	}
	return ""
}

func (x *DeprecateRepositoryByNameRequest) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *DeprecateRepositoryByNameRequest) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *DeprecateRepositoryByNameRequest) SetDeprecationMessage(v string) {
	x.xxx_hidden_DeprecationMessage = v
}

type DeprecateRepositoryByNameRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	OwnerName      string
	RepositoryName string
	// A message shown along with the deprecation warning for this repository.
	// It must be a utf8 encoded string containing 256 or fewer characters.
	DeprecationMessage string
}

func (b0 DeprecateRepositoryByNameRequest_builder) Build() *DeprecateRepositoryByNameRequest {
	m0 := &DeprecateRepositoryByNameRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_DeprecationMessage = b.DeprecationMessage
	return m0
}

type DeprecateRepositoryByNameResponse struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Repository *Repository            `protobuf:"bytes,1,opt,name=repository,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *DeprecateRepositoryByNameResponse) Reset() {
	*x = DeprecateRepositoryByNameResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeprecateRepositoryByNameResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeprecateRepositoryByNameResponse) ProtoMessage() {}

func (x *DeprecateRepositoryByNameResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DeprecateRepositoryByNameResponse) GetRepository() *Repository {
	if x != nil {
		return x.xxx_hidden_Repository
	}
	return nil
}

func (x *DeprecateRepositoryByNameResponse) SetRepository(v *Repository) {
	x.xxx_hidden_Repository = v
}

func (x *DeprecateRepositoryByNameResponse) HasRepository() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Repository != nil
}

func (x *DeprecateRepositoryByNameResponse) ClearRepository() {
	x.xxx_hidden_Repository = nil
}

type DeprecateRepositoryByNameResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Repository *Repository
}

func (b0 DeprecateRepositoryByNameResponse_builder) Build() *DeprecateRepositoryByNameResponse {
	m0 := &DeprecateRepositoryByNameResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Repository = b.Repository
	return m0
}

type UndeprecateRepositoryByNameRequest struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerName      string                 `protobuf:"bytes,1,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_RepositoryName string                 `protobuf:"bytes,2,opt,name=repository_name,json=repositoryName,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *UndeprecateRepositoryByNameRequest) Reset() {
	*x = UndeprecateRepositoryByNameRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UndeprecateRepositoryByNameRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeprecateRepositoryByNameRequest) ProtoMessage() {}

func (x *UndeprecateRepositoryByNameRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UndeprecateRepositoryByNameRequest) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *UndeprecateRepositoryByNameRequest) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *UndeprecateRepositoryByNameRequest) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *UndeprecateRepositoryByNameRequest) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

type UndeprecateRepositoryByNameRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	OwnerName      string
	RepositoryName string
}

func (b0 UndeprecateRepositoryByNameRequest_builder) Build() *UndeprecateRepositoryByNameRequest {
	m0 := &UndeprecateRepositoryByNameRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_RepositoryName = b.RepositoryName
	return m0
}

type UndeprecateRepositoryByNameResponse struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Repository *Repository            `protobuf:"bytes,1,opt,name=repository,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *UndeprecateRepositoryByNameResponse) Reset() {
	*x = UndeprecateRepositoryByNameResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UndeprecateRepositoryByNameResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeprecateRepositoryByNameResponse) ProtoMessage() {}

func (x *UndeprecateRepositoryByNameResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UndeprecateRepositoryByNameResponse) GetRepository() *Repository {
	if x != nil {
		return x.xxx_hidden_Repository
	}
	return nil
}

func (x *UndeprecateRepositoryByNameResponse) SetRepository(v *Repository) {
	x.xxx_hidden_Repository = v
}

func (x *UndeprecateRepositoryByNameResponse) HasRepository() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Repository != nil
}

func (x *UndeprecateRepositoryByNameResponse) ClearRepository() {
	x.xxx_hidden_Repository = nil
}

type UndeprecateRepositoryByNameResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Repository *Repository
}

func (b0 UndeprecateRepositoryByNameResponse_builder) Build() *UndeprecateRepositoryByNameResponse {
	m0 := &UndeprecateRepositoryByNameResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Repository = b.Repository
	return m0
}

type SetRepositoryContributorRequest struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId   string                 `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_UserId         string                 `protobuf:"bytes,2,opt,name=user_id,json=userId,proto3"`
	xxx_hidden_RepositoryRole RepositoryRole         `protobuf:"varint,3,opt,name=repository_role,json=repositoryRole,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *SetRepositoryContributorRequest) Reset() {
	*x = SetRepositoryContributorRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetRepositoryContributorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetRepositoryContributorRequest) ProtoMessage() {}

func (x *SetRepositoryContributorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *SetRepositoryContributorRequest) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *SetRepositoryContributorRequest) GetUserId() string {
	if x != nil {
		return x.xxx_hidden_UserId
	}
	return ""
}

func (x *SetRepositoryContributorRequest) GetRepositoryRole() RepositoryRole {
	if x != nil {
		return x.xxx_hidden_RepositoryRole
	}
	return RepositoryRole_REPOSITORY_ROLE_UNSPECIFIED
}

func (x *SetRepositoryContributorRequest) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *SetRepositoryContributorRequest) SetUserId(v string) {
	x.xxx_hidden_UserId = v
}

func (x *SetRepositoryContributorRequest) SetRepositoryRole(v RepositoryRole) {
	x.xxx_hidden_RepositoryRole = v
}

type SetRepositoryContributorRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the repository for which the user's role will be set.
	RepositoryId string
	// The ID of the user whose role will be set.
	UserId string
	// The role to assign to the user.
	// Setting UNSPECIFIED means removing the user's role.
	RepositoryRole RepositoryRole
}

func (b0 SetRepositoryContributorRequest_builder) Build() *SetRepositoryContributorRequest {
	m0 := &SetRepositoryContributorRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_UserId = b.UserId
	x.xxx_hidden_RepositoryRole = b.RepositoryRole
	return m0
}

type SetRepositoryContributorResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SetRepositoryContributorResponse) Reset() {
	*x = SetRepositoryContributorResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetRepositoryContributorResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetRepositoryContributorResponse) ProtoMessage() {}

func (x *SetRepositoryContributorResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type SetRepositoryContributorResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 SetRepositoryContributorResponse_builder) Build() *SetRepositoryContributorResponse {
	m0 := &SetRepositoryContributorResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type ListRepositoryContributorsRequest struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId string                 `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_PageSize     uint32                 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken    string                 `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_Reverse      bool                   `protobuf:"varint,4,opt,name=reverse,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *ListRepositoryContributorsRequest) Reset() {
	*x = ListRepositoryContributorsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRepositoryContributorsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRepositoryContributorsRequest) ProtoMessage() {}

func (x *ListRepositoryContributorsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListRepositoryContributorsRequest) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *ListRepositoryContributorsRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *ListRepositoryContributorsRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *ListRepositoryContributorsRequest) GetReverse() bool {
	if x != nil {
		return x.xxx_hidden_Reverse
	}
	return false
}

func (x *ListRepositoryContributorsRequest) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *ListRepositoryContributorsRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *ListRepositoryContributorsRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

func (x *ListRepositoryContributorsRequest) SetReverse(v bool) {
	x.xxx_hidden_Reverse = v
}

type ListRepositoryContributorsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	RepositoryId string
	PageSize     uint32
	// The first page is returned if this is empty.
	PageToken string
	Reverse   bool
}

func (b0 ListRepositoryContributorsRequest_builder) Build() *ListRepositoryContributorsRequest {
	m0 := &ListRepositoryContributorsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_Reverse = b.Reverse
	return m0
}

type ListRepositoryContributorsResponse struct {
	state                    protoimpl.MessageState    `protogen:"opaque.v1"`
	xxx_hidden_Users         *[]*RepositoryContributor `protobuf:"bytes,1,rep,name=users,proto3"`
	xxx_hidden_NextPageToken string                    `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *ListRepositoryContributorsResponse) Reset() {
	*x = ListRepositoryContributorsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRepositoryContributorsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRepositoryContributorsResponse) ProtoMessage() {}

func (x *ListRepositoryContributorsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListRepositoryContributorsResponse) GetUsers() []*RepositoryContributor {
	if x != nil {
		if x.xxx_hidden_Users != nil {
			return *x.xxx_hidden_Users
		}
	}
	return nil
}

func (x *ListRepositoryContributorsResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *ListRepositoryContributorsResponse) SetUsers(v []*RepositoryContributor) {
	x.xxx_hidden_Users = &v
}

func (x *ListRepositoryContributorsResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

type ListRepositoryContributorsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Users []*RepositoryContributor
	// There are no more pages if this is empty.
	NextPageToken string
}

func (b0 ListRepositoryContributorsResponse_builder) Build() *ListRepositoryContributorsResponse {
	m0 := &ListRepositoryContributorsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Users = &b.Users
	x.xxx_hidden_NextPageToken = b.NextPageToken
	return m0
}

type GetRepositorySettingsRequest struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId string                 `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *GetRepositorySettingsRequest) Reset() {
	*x = GetRepositorySettingsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepositorySettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositorySettingsRequest) ProtoMessage() {}

func (x *GetRepositorySettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRepositorySettingsRequest) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *GetRepositorySettingsRequest) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

type GetRepositorySettingsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the repository for which to get the settings.
	RepositoryId string
}

func (b0 GetRepositorySettingsRequest_builder) Build() *GetRepositorySettingsRequest {
	m0 := &GetRepositorySettingsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	return m0
}

type GetRepositorySettingsResponse struct {
	state                        protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_ContributorsCount uint32                 `protobuf:"varint,1,opt,name=contributors_count,json=contributorsCount,proto3"`
	unknownFields                protoimpl.UnknownFields
	sizeCache                    protoimpl.SizeCache
}

func (x *GetRepositorySettingsResponse) Reset() {
	*x = GetRepositorySettingsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepositorySettingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositorySettingsResponse) ProtoMessage() {}

func (x *GetRepositorySettingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRepositorySettingsResponse) GetContributorsCount() uint32 {
	if x != nil {
		return x.xxx_hidden_ContributorsCount
	}
	return 0
}

func (x *GetRepositorySettingsResponse) SetContributorsCount(v uint32) {
	x.xxx_hidden_ContributorsCount = v
}

type GetRepositorySettingsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The number of outside contributors in the repository,
	// excluding owning-organization's members that have an explicit role.
	ContributorsCount uint32
}

func (b0 GetRepositorySettingsResponse_builder) Build() *GetRepositorySettingsResponse {
	m0 := &GetRepositorySettingsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_ContributorsCount = b.ContributorsCount
	return m0
}

type UpdateRepositorySettingsByNameRequest struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerName      string                 `protobuf:"bytes,1,opt,name=owner_name,json=ownerName,proto3"`
	xxx_hidden_RepositoryName string                 `protobuf:"bytes,2,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_Visibility     Visibility             `protobuf:"varint,3,opt,name=visibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility"`
	xxx_hidden_Description    *string                `protobuf:"bytes,4,opt,name=description,proto3,oneof"`
	xxx_hidden_Url            *string                `protobuf:"bytes,5,opt,name=url,proto3,oneof"`
	xxx_hidden_DefaultBranch  *string                `protobuf:"bytes,6,opt,name=default_branch,json=defaultBranch,proto3,oneof"`
	XXX_raceDetectHookData    protoimpl.RaceDetectHookData
	XXX_presence              [1]uint32
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *UpdateRepositorySettingsByNameRequest) Reset() {
	*x = UpdateRepositorySettingsByNameRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateRepositorySettingsByNameRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRepositorySettingsByNameRequest) ProtoMessage() {}

func (x *UpdateRepositorySettingsByNameRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UpdateRepositorySettingsByNameRequest) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *UpdateRepositorySettingsByNameRequest) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *UpdateRepositorySettingsByNameRequest) GetVisibility() Visibility {
	if x != nil {
		return x.xxx_hidden_Visibility
	}
	return Visibility_VISIBILITY_UNSPECIFIED
}

func (x *UpdateRepositorySettingsByNameRequest) GetDescription() string {
	if x != nil {
		if x.xxx_hidden_Description != nil {
			return *x.xxx_hidden_Description
		}
		return ""
	}
	return ""
}

func (x *UpdateRepositorySettingsByNameRequest) GetUrl() string {
	if x != nil {
		if x.xxx_hidden_Url != nil {
			return *x.xxx_hidden_Url
		}
		return ""
	}
	return ""
}

func (x *UpdateRepositorySettingsByNameRequest) GetDefaultBranch() string {
	if x != nil {
		if x.xxx_hidden_DefaultBranch != nil {
			return *x.xxx_hidden_DefaultBranch
		}
		return ""
	}
	return ""
}

func (x *UpdateRepositorySettingsByNameRequest) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

func (x *UpdateRepositorySettingsByNameRequest) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *UpdateRepositorySettingsByNameRequest) SetVisibility(v Visibility) {
	x.xxx_hidden_Visibility = v
}

func (x *UpdateRepositorySettingsByNameRequest) SetDescription(v string) {
	x.xxx_hidden_Description = &v
	protoimpl.X.SetPresent(&(x.XXX_presence[0]), 3, 6)
}

func (x *UpdateRepositorySettingsByNameRequest) SetUrl(v string) {
	x.xxx_hidden_Url = &v
	protoimpl.X.SetPresent(&(x.XXX_presence[0]), 4, 6)
}

func (x *UpdateRepositorySettingsByNameRequest) SetDefaultBranch(v string) {
	x.xxx_hidden_DefaultBranch = &v
	protoimpl.X.SetPresent(&(x.XXX_presence[0]), 5, 6)
}

func (x *UpdateRepositorySettingsByNameRequest) HasDescription() bool {
	if x == nil {
		return false
	}
	return protoimpl.X.Present(&(x.XXX_presence[0]), 3)
}

func (x *UpdateRepositorySettingsByNameRequest) HasUrl() bool {
	if x == nil {
		return false
	}
	return protoimpl.X.Present(&(x.XXX_presence[0]), 4)
}

func (x *UpdateRepositorySettingsByNameRequest) HasDefaultBranch() bool {
	if x == nil {
		return false
	}
	return protoimpl.X.Present(&(x.XXX_presence[0]), 5)
}

func (x *UpdateRepositorySettingsByNameRequest) ClearDescription() {
	protoimpl.X.ClearPresent(&(x.XXX_presence[0]), 3)
	x.xxx_hidden_Description = nil
}

func (x *UpdateRepositorySettingsByNameRequest) ClearUrl() {
	protoimpl.X.ClearPresent(&(x.XXX_presence[0]), 4)
	x.xxx_hidden_Url = nil
}

func (x *UpdateRepositorySettingsByNameRequest) ClearDefaultBranch() {
	protoimpl.X.ClearPresent(&(x.XXX_presence[0]), 5)
	x.xxx_hidden_DefaultBranch = nil
}

type UpdateRepositorySettingsByNameRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	OwnerName      string
	RepositoryName string
	// optional, update to visibility will only be made if this is specified.
	Visibility Visibility
	// optional, update to description will only be made when this is present
	Description *string
	// optional, update to url will only be made when this is present
	Url *string
	// optional, update to default_branch will only be made when this is present
	DefaultBranch *string
}

func (b0 UpdateRepositorySettingsByNameRequest_builder) Build() *UpdateRepositorySettingsByNameRequest {
	m0 := &UpdateRepositorySettingsByNameRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerName = b.OwnerName
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_Visibility = b.Visibility
	if b.Description != nil {
		protoimpl.X.SetPresentNonAtomic(&(x.XXX_presence[0]), 3, 6)
		x.xxx_hidden_Description = b.Description
	}
	if b.Url != nil {
		protoimpl.X.SetPresentNonAtomic(&(x.XXX_presence[0]), 4, 6)
		x.xxx_hidden_Url = b.Url
	}
	if b.DefaultBranch != nil {
		protoimpl.X.SetPresentNonAtomic(&(x.XXX_presence[0]), 5, 6)
		x.xxx_hidden_DefaultBranch = b.DefaultBranch
	}
	return m0
}

type UpdateRepositorySettingsByNameResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateRepositorySettingsByNameResponse) Reset() {
	*x = UpdateRepositorySettingsByNameResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateRepositorySettingsByNameResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRepositorySettingsByNameResponse) ProtoMessage() {}

func (x *UpdateRepositorySettingsByNameResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type UpdateRepositorySettingsByNameResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 UpdateRepositorySettingsByNameResponse_builder) Build() *UpdateRepositorySettingsByNameResponse {
	m0 := &UpdateRepositorySettingsByNameResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type GetRepositoriesMetadataRequest struct {
	state          protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Ids []string               `protobuf:"bytes,1,rep,name=ids,proto3"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *GetRepositoriesMetadataRequest) Reset() {
	*x = GetRepositoriesMetadataRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepositoriesMetadataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositoriesMetadataRequest) ProtoMessage() {}

func (x *GetRepositoriesMetadataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRepositoriesMetadataRequest) GetIds() []string {
	if x != nil {
		return x.xxx_hidden_Ids
	}
	return nil
}

func (x *GetRepositoriesMetadataRequest) SetIds(v []string) {
	x.xxx_hidden_Ids = v
}

type GetRepositoriesMetadataRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The list of repository IDs to request the metadata.
	Ids []string
}

func (b0 GetRepositoriesMetadataRequest_builder) Build() *GetRepositoriesMetadataRequest {
	m0 := &GetRepositoriesMetadataRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Ids = b.Ids
	return m0
}

type GetRepositoriesMetadataResponse struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Metadata *[]*RepositoryMetadata `protobuf:"bytes,1,rep,name=metadata,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *GetRepositoriesMetadataResponse) Reset() {
	*x = GetRepositoriesMetadataResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepositoriesMetadataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositoriesMetadataResponse) ProtoMessage() {}

func (x *GetRepositoriesMetadataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRepositoriesMetadataResponse) GetMetadata() []*RepositoryMetadata {
	if x != nil {
		if x.xxx_hidden_Metadata != nil {
			return *x.xxx_hidden_Metadata
		}
	}
	return nil
}

func (x *GetRepositoriesMetadataResponse) SetMetadata(v []*RepositoryMetadata) {
	x.xxx_hidden_Metadata = &v
}

type GetRepositoriesMetadataResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Metadata []*RepositoryMetadata
}

func (b0 GetRepositoriesMetadataResponse_builder) Build() *GetRepositoriesMetadataResponse {
	m0 := &GetRepositoriesMetadataResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Metadata = &b.Metadata
	return m0
}

type GetRepositoryDependencyDOTStringRequest struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Owner      string                 `protobuf:"bytes,1,opt,name=owner,proto3"`
	xxx_hidden_Repository string                 `protobuf:"bytes,2,opt,name=repository,proto3"`
	xxx_hidden_Reference  string                 `protobuf:"bytes,3,opt,name=reference,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *GetRepositoryDependencyDOTStringRequest) Reset() {
	*x = GetRepositoryDependencyDOTStringRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepositoryDependencyDOTStringRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositoryDependencyDOTStringRequest) ProtoMessage() {}

func (x *GetRepositoryDependencyDOTStringRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRepositoryDependencyDOTStringRequest) GetOwner() string {
	if x != nil {
		return x.xxx_hidden_Owner
	}
	return ""
}

func (x *GetRepositoryDependencyDOTStringRequest) GetRepository() string {
	if x != nil {
		return x.xxx_hidden_Repository
	}
	return ""
}

func (x *GetRepositoryDependencyDOTStringRequest) GetReference() string {
	if x != nil {
		return x.xxx_hidden_Reference
	}
	return ""
}

func (x *GetRepositoryDependencyDOTStringRequest) SetOwner(v string) {
	x.xxx_hidden_Owner = v
}

func (x *GetRepositoryDependencyDOTStringRequest) SetRepository(v string) {
	x.xxx_hidden_Repository = v
}

func (x *GetRepositoryDependencyDOTStringRequest) SetReference(v string) {
	x.xxx_hidden_Reference = v
}

type GetRepositoryDependencyDOTStringRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The owner of the BSR repository.
	Owner string
	// The name of the BSR repository.
	Repository string
	// Optional reference (if unspecified, will use the repository's default_branch).
	Reference string
}

func (b0 GetRepositoryDependencyDOTStringRequest_builder) Build() *GetRepositoryDependencyDOTStringRequest {
	m0 := &GetRepositoryDependencyDOTStringRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Owner = b.Owner
	x.xxx_hidden_Repository = b.Repository
	x.xxx_hidden_Reference = b.Reference
	return m0
}

type GetRepositoryDependencyDOTStringResponse struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_DotString string                 `protobuf:"bytes,1,opt,name=dot_string,json=dotString,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *GetRepositoryDependencyDOTStringResponse) Reset() {
	*x = GetRepositoryDependencyDOTStringResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepositoryDependencyDOTStringResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositoryDependencyDOTStringResponse) ProtoMessage() {}

func (x *GetRepositoryDependencyDOTStringResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRepositoryDependencyDOTStringResponse) GetDotString() string {
	if x != nil {
		return x.xxx_hidden_DotString
	}
	return ""
}

func (x *GetRepositoryDependencyDOTStringResponse) SetDotString(v string) {
	x.xxx_hidden_DotString = v
}

type GetRepositoryDependencyDOTStringResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The string DOT representation of the dependency graph for the repository.
	//
	// DOT language reference: https://graphviz.org/doc/info/lang.html
	DotString string
}

func (b0 GetRepositoryDependencyDOTStringResponse_builder) Build() *GetRepositoryDependencyDOTStringResponse {
	m0 := &GetRepositoryDependencyDOTStringResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_DotString = b.DotString
	return m0
}

type AddRepositoryGroupRequest struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId string                 `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_GroupName    string                 `protobuf:"bytes,2,opt,name=group_name,json=groupName,proto3"`
	xxx_hidden_RoleOverride RepositoryRole         `protobuf:"varint,3,opt,name=role_override,json=roleOverride,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *AddRepositoryGroupRequest) Reset() {
	*x = AddRepositoryGroupRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AddRepositoryGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddRepositoryGroupRequest) ProtoMessage() {}

func (x *AddRepositoryGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *AddRepositoryGroupRequest) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *AddRepositoryGroupRequest) GetGroupName() string {
	if x != nil {
		return x.xxx_hidden_GroupName
	}
	return ""
}

func (x *AddRepositoryGroupRequest) GetRoleOverride() RepositoryRole {
	if x != nil {
		return x.xxx_hidden_RoleOverride
	}
	return RepositoryRole_REPOSITORY_ROLE_UNSPECIFIED
}

func (x *AddRepositoryGroupRequest) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *AddRepositoryGroupRequest) SetGroupName(v string) {
	x.xxx_hidden_GroupName = v
}

func (x *AddRepositoryGroupRequest) SetRoleOverride(v RepositoryRole) {
	x.xxx_hidden_RoleOverride = v
}

type AddRepositoryGroupRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the repository for which to add the group.
	RepositoryId string
	// The name of the group to add.
	GroupName string
	// The role to associate with any user who is added to the repository via this group.
	//
	// Any user who maps to this repository via this group will be granted this role. If no role is
	// set, the user will be granted the containing-organization's base repository role.
	RoleOverride RepositoryRole
}

func (b0 AddRepositoryGroupRequest_builder) Build() *AddRepositoryGroupRequest {
	m0 := &AddRepositoryGroupRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_GroupName = b.GroupName
	x.xxx_hidden_RoleOverride = b.RoleOverride
	return m0
}

type AddRepositoryGroupResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AddRepositoryGroupResponse) Reset() {
	*x = AddRepositoryGroupResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AddRepositoryGroupResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddRepositoryGroupResponse) ProtoMessage() {}

func (x *AddRepositoryGroupResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type AddRepositoryGroupResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 AddRepositoryGroupResponse_builder) Build() *AddRepositoryGroupResponse {
	m0 := &AddRepositoryGroupResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type UpdateRepositoryGroupRequest struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId string                 `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_GroupName    string                 `protobuf:"bytes,2,opt,name=group_name,json=groupName,proto3"`
	xxx_hidden_RoleOverride RepositoryRole         `protobuf:"varint,3,opt,name=role_override,json=roleOverride,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole,oneof"`
	XXX_raceDetectHookData  protoimpl.RaceDetectHookData
	XXX_presence            [1]uint32
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *UpdateRepositoryGroupRequest) Reset() {
	*x = UpdateRepositoryGroupRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateRepositoryGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRepositoryGroupRequest) ProtoMessage() {}

func (x *UpdateRepositoryGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UpdateRepositoryGroupRequest) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *UpdateRepositoryGroupRequest) GetGroupName() string {
	if x != nil {
		return x.xxx_hidden_GroupName
	}
	return ""
}

func (x *UpdateRepositoryGroupRequest) GetRoleOverride() RepositoryRole {
	if x != nil {
		if protoimpl.X.Present(&(x.XXX_presence[0]), 2) {
			return x.xxx_hidden_RoleOverride
		}
	}
	return RepositoryRole_REPOSITORY_ROLE_UNSPECIFIED
}

func (x *UpdateRepositoryGroupRequest) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *UpdateRepositoryGroupRequest) SetGroupName(v string) {
	x.xxx_hidden_GroupName = v
}

func (x *UpdateRepositoryGroupRequest) SetRoleOverride(v RepositoryRole) {
	x.xxx_hidden_RoleOverride = v
	protoimpl.X.SetPresent(&(x.XXX_presence[0]), 2, 3)
}

func (x *UpdateRepositoryGroupRequest) HasRoleOverride() bool {
	if x == nil {
		return false
	}
	return protoimpl.X.Present(&(x.XXX_presence[0]), 2)
}

func (x *UpdateRepositoryGroupRequest) ClearRoleOverride() {
	protoimpl.X.ClearPresent(&(x.XXX_presence[0]), 2)
	x.xxx_hidden_RoleOverride = RepositoryRole_REPOSITORY_ROLE_UNSPECIFIED
}

type UpdateRepositoryGroupRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the repository to which this group belongs.
	RepositoryId string
	// The name of the group to update.
	GroupName string
	// The role to associate with this repository group.
	//
	// Setting this to 'UNSPECIFIED' will remove the override. Leaving this unset will not update this
	// property.
	RoleOverride *RepositoryRole
}

func (b0 UpdateRepositoryGroupRequest_builder) Build() *UpdateRepositoryGroupRequest {
	m0 := &UpdateRepositoryGroupRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_GroupName = b.GroupName
	if b.RoleOverride != nil {
		protoimpl.X.SetPresentNonAtomic(&(x.XXX_presence[0]), 2, 3)
		x.xxx_hidden_RoleOverride = *b.RoleOverride
	}
	return m0
}

type UpdateRepositoryGroupResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateRepositoryGroupResponse) Reset() {
	*x = UpdateRepositoryGroupResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateRepositoryGroupResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRepositoryGroupResponse) ProtoMessage() {}

func (x *UpdateRepositoryGroupResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type UpdateRepositoryGroupResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 UpdateRepositoryGroupResponse_builder) Build() *UpdateRepositoryGroupResponse {
	m0 := &UpdateRepositoryGroupResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type RemoveRepositoryGroupRequest struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId string                 `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_GroupName    string                 `protobuf:"bytes,2,opt,name=group_name,json=groupName,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *RemoveRepositoryGroupRequest) Reset() {
	*x = RemoveRepositoryGroupRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RemoveRepositoryGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveRepositoryGroupRequest) ProtoMessage() {}

func (x *RemoveRepositoryGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *RemoveRepositoryGroupRequest) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *RemoveRepositoryGroupRequest) GetGroupName() string {
	if x != nil {
		return x.xxx_hidden_GroupName
	}
	return ""
}

func (x *RemoveRepositoryGroupRequest) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *RemoveRepositoryGroupRequest) SetGroupName(v string) {
	x.xxx_hidden_GroupName = v
}

type RemoveRepositoryGroupRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the repository for which to remove the group.
	RepositoryId string
	// The name of the group to remove.
	GroupName string
}

func (b0 RemoveRepositoryGroupRequest_builder) Build() *RemoveRepositoryGroupRequest {
	m0 := &RemoveRepositoryGroupRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_GroupName = b.GroupName
	return m0
}

type RemoveRepositoryGroupResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RemoveRepositoryGroupResponse) Reset() {
	*x = RemoveRepositoryGroupResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RemoveRepositoryGroupResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveRepositoryGroupResponse) ProtoMessage() {}

func (x *RemoveRepositoryGroupResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type RemoveRepositoryGroupResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 RemoveRepositoryGroupResponse_builder) Build() *RemoveRepositoryGroupResponse {
	m0 := &RemoveRepositoryGroupResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

var File_buf_alpha_registry_v1alpha1_repository_proto protoreflect.FileDescriptor

const file_buf_alpha_registry_v1alpha1_repository_proto_rawDesc = "" +
	"\n" +
	",buf/alpha/registry/v1alpha1/repository.proto\x12\x1bbuf.alpha.registry.v1alpha1\x1a&buf/alpha/registry/v1alpha1/role.proto\x1a&buf/alpha/registry/v1alpha1/user.proto\x1a5buf/alpha/registry/v1alpha1/verification_status.proto\x1a\x1fgoogle/protobuf/timestamp.proto\"\x8d\x04\n" +
	"\n" +
	"Repository\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12;\n" +
	"\vcreate_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"createTime\x12;\n" +
	"\vupdate_time\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"updateTime\x12\x12\n" +
	"\x04name\x18\x04 \x01(\tR\x04name\x12\x19\n" +
	"\auser_id\x18\x05 \x01(\tH\x00R\x06userId\x12)\n" +
	"\x0forganization_id\x18\x06 \x01(\tH\x00R\x0eorganizationId\x12G\n" +
	"\n" +
	"visibility\x18\a \x01(\x0e2'.buf.alpha.registry.v1alpha1.VisibilityR\n" +
	"visibility\x12\x1e\n" +
	"\n" +
	"deprecated\x18\b \x01(\bR\n" +
	"deprecated\x12/\n" +
	"\x13deprecation_message\x18\t \x01(\tR\x12deprecationMessage\x12\x1d\n" +
	"\n" +
	"owner_name\x18\n" +
	" \x01(\tR\townerName\x12 \n" +
	"\vdescription\x18\v \x01(\tR\vdescription\x12\x10\n" +
	"\x03url\x18\f \x01(\tR\x03url\x12%\n" +
	"\x0edefault_branch\x18\r \x01(\tR\rdefaultBranchB\a\n" +
	"\x05owner\"h\n" +
	"\x10RepositoryCounts\x12\x1d\n" +
	"\n" +
	"tags_count\x18\x01 \x01(\rR\ttagsCount\x12!\n" +
	"\fdrafts_count\x18\x03 \x01(\rR\vdraftsCountJ\x04\b\x02\x10\x03R\ftracks_count\"\x97\x02\n" +
	"\x15RepositoryContributor\x125\n" +
	"\x04user\x18\x01 \x01(\v2!.buf.alpha.registry.v1alpha1.UserR\x04user\x12#\n" +
	"\rrepository_id\x18\x02 \x01(\tR\frepositoryId\x12P\n" +
	"\rexplicit_role\x18\x03 \x01(\x0e2+.buf.alpha.registry.v1alpha1.RepositoryRoleR\fexplicitRole\x12P\n" +
	"\rimplicit_role\x18\x04 \x01(\x0e2+.buf.alpha.registry.v1alpha1.RepositoryRoleR\fimplicitRole\"\xc3\x02\n" +
	"\x12RepositoryMetadata\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x12\n" +
	"\x04name\x18\x02 \x01(\tR\x04name\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x03 \x01(\tR\townerName\x12k\n" +
	"\x19owner_verification_status\x18\x04 \x01(\x0e2/.buf.alpha.registry.v1alpha1.VerificationStatusR\x17ownerVerificationStatus\x12H\n" +
	"\x12latest_commit_time\x18\x05 \x01(\v2\x1a.google.protobuf.TimestampR\x10latestCommitTime\x123\n" +
	"\x16latest_spdx_license_id\x18\x06 \x01(\tR\x13latestSpdxLicenseId\"A\n" +
	" GetRepositoriesByFullNameRequest\x12\x1d\n" +
	"\n" +
	"full_names\x18\x01 \x03(\tR\tfullNames\"p\n" +
	"!GetRepositoriesByFullNameResponse\x12K\n" +
	"\frepositories\x18\x01 \x03(\v2'.buf.alpha.registry.v1alpha1.RepositoryR\frepositories\"&\n" +
	"\x14GetRepositoryRequest\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\"\xa7\x01\n" +
	"\x15GetRepositoryResponse\x12G\n" +
	"\n" +
	"repository\x18\x01 \x01(\v2'.buf.alpha.registry.v1alpha1.RepositoryR\n" +
	"repository\x12E\n" +
	"\x06counts\x18\x02 \x01(\v2-.buf.alpha.registry.v1alpha1.RepositoryCountsR\x06counts\"=\n" +
	"\x1eGetRepositoryByFullNameRequest\x12\x1b\n" +
	"\tfull_name\x18\x01 \x01(\tR\bfullName\"\xb1\x01\n" +
	"\x1fGetRepositoryByFullNameResponse\x12G\n" +
	"\n" +
	"repository\x18\x01 \x01(\v2'.buf.alpha.registry.v1alpha1.RepositoryR\n" +
	"repository\x12E\n" +
	"\x06counts\x18\x02 \x01(\v2-.buf.alpha.registry.v1alpha1.RepositoryCountsR\x06counts\"o\n" +
	"\x17ListRepositoriesRequest\x12\x1b\n" +
	"\tpage_size\x18\x01 \x01(\rR\bpageSize\x12\x1d\n" +
	"\n" +
	"page_token\x18\x02 \x01(\tR\tpageToken\x12\x18\n" +
	"\areverse\x18\x03 \x01(\bR\areverse\"\x8f\x01\n" +
	"\x18ListRepositoriesResponse\x12K\n" +
	"\frepositories\x18\x01 \x03(\v2'.buf.alpha.registry.v1alpha1.RepositoryR\frepositories\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"\x8c\x01\n" +
	"\x1bListUserRepositoriesRequest\x12\x17\n" +
	"\auser_id\x18\x01 \x01(\tR\x06userId\x12\x1b\n" +
	"\tpage_size\x18\x02 \x01(\rR\bpageSize\x12\x1d\n" +
	"\n" +
	"page_token\x18\x03 \x01(\tR\tpageToken\x12\x18\n" +
	"\areverse\x18\x04 \x01(\bR\areverse\"\x93\x01\n" +
	"\x1cListUserRepositoriesResponse\x12K\n" +
	"\frepositories\x18\x01 \x03(\v2'.buf.alpha.registry.v1alpha1.RepositoryR\frepositories\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"|\n" +
	"$ListRepositoriesUserCanAccessRequest\x12\x1b\n" +
	"\tpage_size\x18\x01 \x01(\rR\bpageSize\x12\x1d\n" +
	"\n" +
	"page_token\x18\x02 \x01(\tR\tpageToken\x12\x18\n" +
	"\areverse\x18\x03 \x01(\bR\areverse\"\x9c\x01\n" +
	"%ListRepositoriesUserCanAccessResponse\x12K\n" +
	"\frepositories\x18\x01 \x03(\v2'.buf.alpha.registry.v1alpha1.RepositoryR\frepositories\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"\xa4\x01\n" +
	"#ListOrganizationRepositoriesRequest\x12'\n" +
	"\x0forganization_id\x18\x01 \x01(\tR\x0eorganizationId\x12\x1b\n" +
	"\tpage_size\x18\x02 \x01(\rR\bpageSize\x12\x1d\n" +
	"\n" +
	"page_token\x18\x03 \x01(\tR\tpageToken\x12\x18\n" +
	"\areverse\x18\x04 \x01(\bR\areverse\"\x9b\x01\n" +
	"$ListOrganizationRepositoriesResponse\x12K\n" +
	"\frepositories\x18\x01 \x03(\v2'.buf.alpha.registry.v1alpha1.RepositoryR\frepositories\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"\x89\x01\n" +
	"!CreateRepositoryByFullNameRequest\x12\x1b\n" +
	"\tfull_name\x18\x01 \x01(\tR\bfullName\x12G\n" +
	"\n" +
	"visibility\x18\x02 \x01(\x0e2'.buf.alpha.registry.v1alpha1.VisibilityR\n" +
	"visibility\"m\n" +
	"\"CreateRepositoryByFullNameResponse\x12G\n" +
	"\n" +
	"repository\x18\x01 \x01(\v2'.buf.alpha.registry.v1alpha1.RepositoryR\n" +
	"repository\")\n" +
	"\x17DeleteRepositoryRequest\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\"\x1a\n" +
	"\x18DeleteRepositoryResponse\"@\n" +
	"!DeleteRepositoryByFullNameRequest\x12\x1b\n" +
	"\tfull_name\x18\x01 \x01(\tR\bfullName\"$\n" +
	"\"DeleteRepositoryByFullNameResponse\"\x9b\x01\n" +
	" DeprecateRepositoryByNameRequest\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x01 \x01(\tR\townerName\x12'\n" +
	"\x0frepository_name\x18\x02 \x01(\tR\x0erepositoryName\x12/\n" +
	"\x13deprecation_message\x18\x03 \x01(\tR\x12deprecationMessage\"l\n" +
	"!DeprecateRepositoryByNameResponse\x12G\n" +
	"\n" +
	"repository\x18\x01 \x01(\v2'.buf.alpha.registry.v1alpha1.RepositoryR\n" +
	"repository\"l\n" +
	"\"UndeprecateRepositoryByNameRequest\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x01 \x01(\tR\townerName\x12'\n" +
	"\x0frepository_name\x18\x02 \x01(\tR\x0erepositoryName\"n\n" +
	"#UndeprecateRepositoryByNameResponse\x12G\n" +
	"\n" +
	"repository\x18\x01 \x01(\v2'.buf.alpha.registry.v1alpha1.RepositoryR\n" +
	"repository\"\xb5\x01\n" +
	"\x1fSetRepositoryContributorRequest\x12#\n" +
	"\rrepository_id\x18\x01 \x01(\tR\frepositoryId\x12\x17\n" +
	"\auser_id\x18\x02 \x01(\tR\x06userId\x12T\n" +
	"\x0frepository_role\x18\x03 \x01(\x0e2+.buf.alpha.registry.v1alpha1.RepositoryRoleR\x0erepositoryRole\"\"\n" +
	" SetRepositoryContributorResponse\"\x9e\x01\n" +
	"!ListRepositoryContributorsRequest\x12#\n" +
	"\rrepository_id\x18\x01 \x01(\tR\frepositoryId\x12\x1b\n" +
	"\tpage_size\x18\x02 \x01(\rR\bpageSize\x12\x1d\n" +
	"\n" +
	"page_token\x18\x03 \x01(\tR\tpageToken\x12\x18\n" +
	"\areverse\x18\x04 \x01(\bR\areverse\"\x96\x01\n" +
	"\"ListRepositoryContributorsResponse\x12H\n" +
	"\x05users\x18\x01 \x03(\v22.buf.alpha.registry.v1alpha1.RepositoryContributorR\x05users\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"C\n" +
	"\x1cGetRepositorySettingsRequest\x12#\n" +
	"\rrepository_id\x18\x01 \x01(\tR\frepositoryId\"N\n" +
	"\x1dGetRepositorySettingsResponse\x12-\n" +
	"\x12contributors_count\x18\x01 \x01(\rR\x11contributorsCount\"\xcd\x02\n" +
	"%UpdateRepositorySettingsByNameRequest\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x01 \x01(\tR\townerName\x12'\n" +
	"\x0frepository_name\x18\x02 \x01(\tR\x0erepositoryName\x12G\n" +
	"\n" +
	"visibility\x18\x03 \x01(\x0e2'.buf.alpha.registry.v1alpha1.VisibilityR\n" +
	"visibility\x12%\n" +
	"\vdescription\x18\x04 \x01(\tH\x00R\vdescription\x88\x01\x01\x12\x15\n" +
	"\x03url\x18\x05 \x01(\tH\x01R\x03url\x88\x01\x01\x12*\n" +
	"\x0edefault_branch\x18\x06 \x01(\tH\x02R\rdefaultBranch\x88\x01\x01B\x0e\n" +
	"\f_descriptionB\x06\n" +
	"\x04_urlB\x11\n" +
	"\x0f_default_branch\"(\n" +
	"&UpdateRepositorySettingsByNameResponse\"2\n" +
	"\x1eGetRepositoriesMetadataRequest\x12\x10\n" +
	"\x03ids\x18\x01 \x03(\tR\x03ids\"n\n" +
	"\x1fGetRepositoriesMetadataResponse\x12K\n" +
	"\bmetadata\x18\x01 \x03(\v2/.buf.alpha.registry.v1alpha1.RepositoryMetadataR\bmetadata\"}\n" +
	"'GetRepositoryDependencyDOTStringRequest\x12\x14\n" +
	"\x05owner\x18\x01 \x01(\tR\x05owner\x12\x1e\n" +
	"\n" +
	"repository\x18\x02 \x01(\tR\n" +
	"repository\x12\x1c\n" +
	"\treference\x18\x03 \x01(\tR\treference\"I\n" +
	"(GetRepositoryDependencyDOTStringResponse\x12\x1d\n" +
	"\n" +
	"dot_string\x18\x01 \x01(\tR\tdotString\"\xb1\x01\n" +
	"\x19AddRepositoryGroupRequest\x12#\n" +
	"\rrepository_id\x18\x01 \x01(\tR\frepositoryId\x12\x1d\n" +
	"\n" +
	"group_name\x18\x02 \x01(\tR\tgroupName\x12P\n" +
	"\rrole_override\x18\x03 \x01(\x0e2+.buf.alpha.registry.v1alpha1.RepositoryRoleR\froleOverride\"\x1c\n" +
	"\x1aAddRepositoryGroupResponse\"\xcb\x01\n" +
	"\x1cUpdateRepositoryGroupRequest\x12#\n" +
	"\rrepository_id\x18\x01 \x01(\tR\frepositoryId\x12\x1d\n" +
	"\n" +
	"group_name\x18\x02 \x01(\tR\tgroupName\x12U\n" +
	"\rrole_override\x18\x03 \x01(\x0e2+.buf.alpha.registry.v1alpha1.RepositoryRoleH\x00R\froleOverride\x88\x01\x01B\x10\n" +
	"\x0e_role_override\"\x1f\n" +
	"\x1dUpdateRepositoryGroupResponse\"b\n" +
	"\x1cRemoveRepositoryGroupRequest\x12#\n" +
	"\rrepository_id\x18\x01 \x01(\tR\frepositoryId\x12\x1d\n" +
	"\n" +
	"group_name\x18\x02 \x01(\tR\tgroupName\"\x1f\n" +
	"\x1dRemoveRepositoryGroupResponse*W\n" +
	"\n" +
	"Visibility\x12\x1a\n" +
	"\x16VISIBILITY_UNSPECIFIED\x10\x00\x12\x15\n" +
	"\x11VISIBILITY_PUBLIC\x10\x01\x12\x16\n" +
	"\x12VISIBILITY_PRIVATE\x10\x022\xdf\x19\n" +
	"\x11RepositoryService\x12{\n" +
	"\rGetRepository\x121.buf.alpha.registry.v1alpha1.GetRepositoryRequest\x1a2.buf.alpha.registry.v1alpha1.GetRepositoryResponse\"\x03\x90\x02\x01\x12\x99\x01\n" +
	"\x17GetRepositoryByFullName\x12;.buf.alpha.registry.v1alpha1.GetRepositoryByFullNameRequest\x1a<.buf.alpha.registry.v1alpha1.GetRepositoryByFullNameResponse\"\x03\x90\x02\x01\x12\x84\x01\n" +
	"\x10ListRepositories\x124.buf.alpha.registry.v1alpha1.ListRepositoriesRequest\x1a5.buf.alpha.registry.v1alpha1.ListRepositoriesResponse\"\x03\x90\x02\x01\x12\x90\x01\n" +
	"\x14ListUserRepositories\x128.buf.alpha.registry.v1alpha1.ListUserRepositoriesRequest\x1a9.buf.alpha.registry.v1alpha1.ListUserRepositoriesResponse\"\x03\x90\x02\x01\x12\xab\x01\n" +
	"\x1dListRepositoriesUserCanAccess\x12A.buf.alpha.registry.v1alpha1.ListRepositoriesUserCanAccessRequest\x1aB.buf.alpha.registry.v1alpha1.ListRepositoriesUserCanAccessResponse\"\x03\x90\x02\x01\x12\xa8\x01\n" +
	"\x1cListOrganizationRepositories\x12@.buf.alpha.registry.v1alpha1.ListOrganizationRepositoriesRequest\x1aA.buf.alpha.registry.v1alpha1.ListOrganizationRepositoriesResponse\"\x03\x90\x02\x01\x12\xa2\x01\n" +
	"\x1aCreateRepositoryByFullName\x12>.buf.alpha.registry.v1alpha1.CreateRepositoryByFullNameRequest\x1a?.buf.alpha.registry.v1alpha1.CreateRepositoryByFullNameResponse\"\x03\x90\x02\x02\x12\x84\x01\n" +
	"\x10DeleteRepository\x124.buf.alpha.registry.v1alpha1.DeleteRepositoryRequest\x1a5.buf.alpha.registry.v1alpha1.DeleteRepositoryResponse\"\x03\x90\x02\x02\x12\xa2\x01\n" +
	"\x1aDeleteRepositoryByFullName\x12>.buf.alpha.registry.v1alpha1.DeleteRepositoryByFullNameRequest\x1a?.buf.alpha.registry.v1alpha1.DeleteRepositoryByFullNameResponse\"\x03\x90\x02\x02\x12\x9a\x01\n" +
	"\x19DeprecateRepositoryByName\x12=.buf.alpha.registry.v1alpha1.DeprecateRepositoryByNameRequest\x1a>.buf.alpha.registry.v1alpha1.DeprecateRepositoryByNameResponse\x12\xa0\x01\n" +
	"\x1bUndeprecateRepositoryByName\x12?.buf.alpha.registry.v1alpha1.UndeprecateRepositoryByNameRequest\x1a@.buf.alpha.registry.v1alpha1.UndeprecateRepositoryByNameResponse\x12\x9f\x01\n" +
	"\x19GetRepositoriesByFullName\x12=.buf.alpha.registry.v1alpha1.GetRepositoriesByFullNameRequest\x1a>.buf.alpha.registry.v1alpha1.GetRepositoriesByFullNameResponse\"\x03\x90\x02\x01\x12\x97\x01\n" +
	"\x18SetRepositoryContributor\x12<.buf.alpha.registry.v1alpha1.SetRepositoryContributorRequest\x1a=.buf.alpha.registry.v1alpha1.SetRepositoryContributorResponse\x12\xa2\x01\n" +
	"\x1aListRepositoryContributors\x12>.buf.alpha.registry.v1alpha1.ListRepositoryContributorsRequest\x1a?.buf.alpha.registry.v1alpha1.ListRepositoryContributorsResponse\"\x03\x90\x02\x01\x12\x93\x01\n" +
	"\x15GetRepositorySettings\x129.buf.alpha.registry.v1alpha1.GetRepositorySettingsRequest\x1a:.buf.alpha.registry.v1alpha1.GetRepositorySettingsResponse\"\x03\x90\x02\x01\x12\xa9\x01\n" +
	"\x1eUpdateRepositorySettingsByName\x12B.buf.alpha.registry.v1alpha1.UpdateRepositorySettingsByNameRequest\x1aC.buf.alpha.registry.v1alpha1.UpdateRepositorySettingsByNameResponse\x12\x99\x01\n" +
	"\x17GetRepositoriesMetadata\x12;.buf.alpha.registry.v1alpha1.GetRepositoriesMetadataRequest\x1a<.buf.alpha.registry.v1alpha1.GetRepositoriesMetadataResponse\"\x03\x90\x02\x01\x12\xb4\x01\n" +
	" GetRepositoryDependencyDOTString\x12D.buf.alpha.registry.v1alpha1.GetRepositoryDependencyDOTStringRequest\x1aE.buf.alpha.registry.v1alpha1.GetRepositoryDependencyDOTStringResponse\"\x03\x90\x02\x01\x12\x8a\x01\n" +
	"\x12AddRepositoryGroup\x126.buf.alpha.registry.v1alpha1.AddRepositoryGroupRequest\x1a7.buf.alpha.registry.v1alpha1.AddRepositoryGroupResponse\"\x03\x90\x02\x02\x12\x93\x01\n" +
	"\x15UpdateRepositoryGroup\x129.buf.alpha.registry.v1alpha1.UpdateRepositoryGroupRequest\x1a:.buf.alpha.registry.v1alpha1.UpdateRepositoryGroupResponse\"\x03\x90\x02\x02\x12\x93\x01\n" +
	"\x15RemoveRepositoryGroup\x129.buf.alpha.registry.v1alpha1.RemoveRepositoryGroupRequest\x1a:.buf.alpha.registry.v1alpha1.RemoveRepositoryGroupResponse\"\x03\x90\x02\x02B\x9c\x02\n" +
	"\x1fcom.buf.alpha.registry.v1alpha1B\x0fRepositoryProtoP\x01ZYgithub.com/bufbuild/buf/private/gen/proto/go/buf/alpha/registry/v1alpha1;registryv1alpha1\xa2\x02\x03BAR\xaa\x02\x1bBuf.Alpha.Registry.V1alpha1\xca\x02\x1bBuf\\Alpha\\Registry\\V1alpha1\xe2\x02'Buf\\Alpha\\Registry\\V1alpha1\\GPBMetadata\xea\x02\x1eBuf::Alpha::Registry::V1alpha1b\x06proto3"

var file_buf_alpha_registry_v1alpha1_repository_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes = make([]protoimpl.MessageInfo, 46)
var file_buf_alpha_registry_v1alpha1_repository_proto_goTypes = []any{
	(Visibility)(0),                                  // 0: buf.alpha.registry.v1alpha1.Visibility
	(*Repository)(nil),                               // 1: buf.alpha.registry.v1alpha1.Repository
	(*RepositoryCounts)(nil),                         // 2: buf.alpha.registry.v1alpha1.RepositoryCounts
	(*RepositoryContributor)(nil),                    // 3: buf.alpha.registry.v1alpha1.RepositoryContributor
	(*RepositoryMetadata)(nil),                       // 4: buf.alpha.registry.v1alpha1.RepositoryMetadata
	(*GetRepositoriesByFullNameRequest)(nil),         // 5: buf.alpha.registry.v1alpha1.GetRepositoriesByFullNameRequest
	(*GetRepositoriesByFullNameResponse)(nil),        // 6: buf.alpha.registry.v1alpha1.GetRepositoriesByFullNameResponse
	(*GetRepositoryRequest)(nil),                     // 7: buf.alpha.registry.v1alpha1.GetRepositoryRequest
	(*GetRepositoryResponse)(nil),                    // 8: buf.alpha.registry.v1alpha1.GetRepositoryResponse
	(*GetRepositoryByFullNameRequest)(nil),           // 9: buf.alpha.registry.v1alpha1.GetRepositoryByFullNameRequest
	(*GetRepositoryByFullNameResponse)(nil),          // 10: buf.alpha.registry.v1alpha1.GetRepositoryByFullNameResponse
	(*ListRepositoriesRequest)(nil),                  // 11: buf.alpha.registry.v1alpha1.ListRepositoriesRequest
	(*ListRepositoriesResponse)(nil),                 // 12: buf.alpha.registry.v1alpha1.ListRepositoriesResponse
	(*ListUserRepositoriesRequest)(nil),              // 13: buf.alpha.registry.v1alpha1.ListUserRepositoriesRequest
	(*ListUserRepositoriesResponse)(nil),             // 14: buf.alpha.registry.v1alpha1.ListUserRepositoriesResponse
	(*ListRepositoriesUserCanAccessRequest)(nil),     // 15: buf.alpha.registry.v1alpha1.ListRepositoriesUserCanAccessRequest
	(*ListRepositoriesUserCanAccessResponse)(nil),    // 16: buf.alpha.registry.v1alpha1.ListRepositoriesUserCanAccessResponse
	(*ListOrganizationRepositoriesRequest)(nil),      // 17: buf.alpha.registry.v1alpha1.ListOrganizationRepositoriesRequest
	(*ListOrganizationRepositoriesResponse)(nil),     // 18: buf.alpha.registry.v1alpha1.ListOrganizationRepositoriesResponse
	(*CreateRepositoryByFullNameRequest)(nil),        // 19: buf.alpha.registry.v1alpha1.CreateRepositoryByFullNameRequest
	(*CreateRepositoryByFullNameResponse)(nil),       // 20: buf.alpha.registry.v1alpha1.CreateRepositoryByFullNameResponse
	(*DeleteRepositoryRequest)(nil),                  // 21: buf.alpha.registry.v1alpha1.DeleteRepositoryRequest
	(*DeleteRepositoryResponse)(nil),                 // 22: buf.alpha.registry.v1alpha1.DeleteRepositoryResponse
	(*DeleteRepositoryByFullNameRequest)(nil),        // 23: buf.alpha.registry.v1alpha1.DeleteRepositoryByFullNameRequest
	(*DeleteRepositoryByFullNameResponse)(nil),       // 24: buf.alpha.registry.v1alpha1.DeleteRepositoryByFullNameResponse
	(*DeprecateRepositoryByNameRequest)(nil),         // 25: buf.alpha.registry.v1alpha1.DeprecateRepositoryByNameRequest
	(*DeprecateRepositoryByNameResponse)(nil),        // 26: buf.alpha.registry.v1alpha1.DeprecateRepositoryByNameResponse
	(*UndeprecateRepositoryByNameRequest)(nil),       // 27: buf.alpha.registry.v1alpha1.UndeprecateRepositoryByNameRequest
	(*UndeprecateRepositoryByNameResponse)(nil),      // 28: buf.alpha.registry.v1alpha1.UndeprecateRepositoryByNameResponse
	(*SetRepositoryContributorRequest)(nil),          // 29: buf.alpha.registry.v1alpha1.SetRepositoryContributorRequest
	(*SetRepositoryContributorResponse)(nil),         // 30: buf.alpha.registry.v1alpha1.SetRepositoryContributorResponse
	(*ListRepositoryContributorsRequest)(nil),        // 31: buf.alpha.registry.v1alpha1.ListRepositoryContributorsRequest
	(*ListRepositoryContributorsResponse)(nil),       // 32: buf.alpha.registry.v1alpha1.ListRepositoryContributorsResponse
	(*GetRepositorySettingsRequest)(nil),             // 33: buf.alpha.registry.v1alpha1.GetRepositorySettingsRequest
	(*GetRepositorySettingsResponse)(nil),            // 34: buf.alpha.registry.v1alpha1.GetRepositorySettingsResponse
	(*UpdateRepositorySettingsByNameRequest)(nil),    // 35: buf.alpha.registry.v1alpha1.UpdateRepositorySettingsByNameRequest
	(*UpdateRepositorySettingsByNameResponse)(nil),   // 36: buf.alpha.registry.v1alpha1.UpdateRepositorySettingsByNameResponse
	(*GetRepositoriesMetadataRequest)(nil),           // 37: buf.alpha.registry.v1alpha1.GetRepositoriesMetadataRequest
	(*GetRepositoriesMetadataResponse)(nil),          // 38: buf.alpha.registry.v1alpha1.GetRepositoriesMetadataResponse
	(*GetRepositoryDependencyDOTStringRequest)(nil),  // 39: buf.alpha.registry.v1alpha1.GetRepositoryDependencyDOTStringRequest
	(*GetRepositoryDependencyDOTStringResponse)(nil), // 40: buf.alpha.registry.v1alpha1.GetRepositoryDependencyDOTStringResponse
	(*AddRepositoryGroupRequest)(nil),                // 41: buf.alpha.registry.v1alpha1.AddRepositoryGroupRequest
	(*AddRepositoryGroupResponse)(nil),               // 42: buf.alpha.registry.v1alpha1.AddRepositoryGroupResponse
	(*UpdateRepositoryGroupRequest)(nil),             // 43: buf.alpha.registry.v1alpha1.UpdateRepositoryGroupRequest
	(*UpdateRepositoryGroupResponse)(nil),            // 44: buf.alpha.registry.v1alpha1.UpdateRepositoryGroupResponse
	(*RemoveRepositoryGroupRequest)(nil),             // 45: buf.alpha.registry.v1alpha1.RemoveRepositoryGroupRequest
	(*RemoveRepositoryGroupResponse)(nil),            // 46: buf.alpha.registry.v1alpha1.RemoveRepositoryGroupResponse
	(*timestamppb.Timestamp)(nil),                    // 47: google.protobuf.Timestamp
	(*User)(nil),                                     // 48: buf.alpha.registry.v1alpha1.User
	(RepositoryRole)(0),                              // 49: buf.alpha.registry.v1alpha1.RepositoryRole
	(VerificationStatus)(0),                          // 50: buf.alpha.registry.v1alpha1.VerificationStatus
}
var file_buf_alpha_registry_v1alpha1_repository_proto_depIdxs = []int32{
	47, // 0: buf.alpha.registry.v1alpha1.Repository.create_time:type_name -> google.protobuf.Timestamp
	47, // 1: buf.alpha.registry.v1alpha1.Repository.update_time:type_name -> google.protobuf.Timestamp
	0,  // 2: buf.alpha.registry.v1alpha1.Repository.visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	48, // 3: buf.alpha.registry.v1alpha1.RepositoryContributor.user:type_name -> buf.alpha.registry.v1alpha1.User
	49, // 4: buf.alpha.registry.v1alpha1.RepositoryContributor.explicit_role:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	49, // 5: buf.alpha.registry.v1alpha1.RepositoryContributor.implicit_role:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	50, // 6: buf.alpha.registry.v1alpha1.RepositoryMetadata.owner_verification_status:type_name -> buf.alpha.registry.v1alpha1.VerificationStatus
	47, // 7: buf.alpha.registry.v1alpha1.RepositoryMetadata.latest_commit_time:type_name -> google.protobuf.Timestamp
	1,  // 8: buf.alpha.registry.v1alpha1.GetRepositoriesByFullNameResponse.repositories:type_name -> buf.alpha.registry.v1alpha1.Repository
	1,  // 9: buf.alpha.registry.v1alpha1.GetRepositoryResponse.repository:type_name -> buf.alpha.registry.v1alpha1.Repository
	2,  // 10: buf.alpha.registry.v1alpha1.GetRepositoryResponse.counts:type_name -> buf.alpha.registry.v1alpha1.RepositoryCounts
	1,  // 11: buf.alpha.registry.v1alpha1.GetRepositoryByFullNameResponse.repository:type_name -> buf.alpha.registry.v1alpha1.Repository
	2,  // 12: buf.alpha.registry.v1alpha1.GetRepositoryByFullNameResponse.counts:type_name -> buf.alpha.registry.v1alpha1.RepositoryCounts
	1,  // 13: buf.alpha.registry.v1alpha1.ListRepositoriesResponse.repositories:type_name -> buf.alpha.registry.v1alpha1.Repository
	1,  // 14: buf.alpha.registry.v1alpha1.ListUserRepositoriesResponse.repositories:type_name -> buf.alpha.registry.v1alpha1.Repository
	1,  // 15: buf.alpha.registry.v1alpha1.ListRepositoriesUserCanAccessResponse.repositories:type_name -> buf.alpha.registry.v1alpha1.Repository
	1,  // 16: buf.alpha.registry.v1alpha1.ListOrganizationRepositoriesResponse.repositories:type_name -> buf.alpha.registry.v1alpha1.Repository
	0,  // 17: buf.alpha.registry.v1alpha1.CreateRepositoryByFullNameRequest.visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	1,  // 18: buf.alpha.registry.v1alpha1.CreateRepositoryByFullNameResponse.repository:type_name -> buf.alpha.registry.v1alpha1.Repository
	1,  // 19: buf.alpha.registry.v1alpha1.DeprecateRepositoryByNameResponse.repository:type_name -> buf.alpha.registry.v1alpha1.Repository
	1,  // 20: buf.alpha.registry.v1alpha1.UndeprecateRepositoryByNameResponse.repository:type_name -> buf.alpha.registry.v1alpha1.Repository
	49, // 21: buf.alpha.registry.v1alpha1.SetRepositoryContributorRequest.repository_role:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	3,  // 22: buf.alpha.registry.v1alpha1.ListRepositoryContributorsResponse.users:type_name -> buf.alpha.registry.v1alpha1.RepositoryContributor
	0,  // 23: buf.alpha.registry.v1alpha1.UpdateRepositorySettingsByNameRequest.visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	4,  // 24: buf.alpha.registry.v1alpha1.GetRepositoriesMetadataResponse.metadata:type_name -> buf.alpha.registry.v1alpha1.RepositoryMetadata
	49, // 25: buf.alpha.registry.v1alpha1.AddRepositoryGroupRequest.role_override:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	49, // 26: buf.alpha.registry.v1alpha1.UpdateRepositoryGroupRequest.role_override:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	7,  // 27: buf.alpha.registry.v1alpha1.RepositoryService.GetRepository:input_type -> buf.alpha.registry.v1alpha1.GetRepositoryRequest
	9,  // 28: buf.alpha.registry.v1alpha1.RepositoryService.GetRepositoryByFullName:input_type -> buf.alpha.registry.v1alpha1.GetRepositoryByFullNameRequest
	11, // 29: buf.alpha.registry.v1alpha1.RepositoryService.ListRepositories:input_type -> buf.alpha.registry.v1alpha1.ListRepositoriesRequest
	13, // 30: buf.alpha.registry.v1alpha1.RepositoryService.ListUserRepositories:input_type -> buf.alpha.registry.v1alpha1.ListUserRepositoriesRequest
	15, // 31: buf.alpha.registry.v1alpha1.RepositoryService.ListRepositoriesUserCanAccess:input_type -> buf.alpha.registry.v1alpha1.ListRepositoriesUserCanAccessRequest
	17, // 32: buf.alpha.registry.v1alpha1.RepositoryService.ListOrganizationRepositories:input_type -> buf.alpha.registry.v1alpha1.ListOrganizationRepositoriesRequest
	19, // 33: buf.alpha.registry.v1alpha1.RepositoryService.CreateRepositoryByFullName:input_type -> buf.alpha.registry.v1alpha1.CreateRepositoryByFullNameRequest
	21, // 34: buf.alpha.registry.v1alpha1.RepositoryService.DeleteRepository:input_type -> buf.alpha.registry.v1alpha1.DeleteRepositoryRequest
	23, // 35: buf.alpha.registry.v1alpha1.RepositoryService.DeleteRepositoryByFullName:input_type -> buf.alpha.registry.v1alpha1.DeleteRepositoryByFullNameRequest
	25, // 36: buf.alpha.registry.v1alpha1.RepositoryService.DeprecateRepositoryByName:input_type -> buf.alpha.registry.v1alpha1.DeprecateRepositoryByNameRequest
	27, // 37: buf.alpha.registry.v1alpha1.RepositoryService.UndeprecateRepositoryByName:input_type -> buf.alpha.registry.v1alpha1.UndeprecateRepositoryByNameRequest
	5,  // 38: buf.alpha.registry.v1alpha1.RepositoryService.GetRepositoriesByFullName:input_type -> buf.alpha.registry.v1alpha1.GetRepositoriesByFullNameRequest
	29, // 39: buf.alpha.registry.v1alpha1.RepositoryService.SetRepositoryContributor:input_type -> buf.alpha.registry.v1alpha1.SetRepositoryContributorRequest
	31, // 40: buf.alpha.registry.v1alpha1.RepositoryService.ListRepositoryContributors:input_type -> buf.alpha.registry.v1alpha1.ListRepositoryContributorsRequest
	33, // 41: buf.alpha.registry.v1alpha1.RepositoryService.GetRepositorySettings:input_type -> buf.alpha.registry.v1alpha1.GetRepositorySettingsRequest
	35, // 42: buf.alpha.registry.v1alpha1.RepositoryService.UpdateRepositorySettingsByName:input_type -> buf.alpha.registry.v1alpha1.UpdateRepositorySettingsByNameRequest
	37, // 43: buf.alpha.registry.v1alpha1.RepositoryService.GetRepositoriesMetadata:input_type -> buf.alpha.registry.v1alpha1.GetRepositoriesMetadataRequest
	39, // 44: buf.alpha.registry.v1alpha1.RepositoryService.GetRepositoryDependencyDOTString:input_type -> buf.alpha.registry.v1alpha1.GetRepositoryDependencyDOTStringRequest
	41, // 45: buf.alpha.registry.v1alpha1.RepositoryService.AddRepositoryGroup:input_type -> buf.alpha.registry.v1alpha1.AddRepositoryGroupRequest
	43, // 46: buf.alpha.registry.v1alpha1.RepositoryService.UpdateRepositoryGroup:input_type -> buf.alpha.registry.v1alpha1.UpdateRepositoryGroupRequest
	45, // 47: buf.alpha.registry.v1alpha1.RepositoryService.RemoveRepositoryGroup:input_type -> buf.alpha.registry.v1alpha1.RemoveRepositoryGroupRequest
	8,  // 48: buf.alpha.registry.v1alpha1.RepositoryService.GetRepository:output_type -> buf.alpha.registry.v1alpha1.GetRepositoryResponse
	10, // 49: buf.alpha.registry.v1alpha1.RepositoryService.GetRepositoryByFullName:output_type -> buf.alpha.registry.v1alpha1.GetRepositoryByFullNameResponse
	12, // 50: buf.alpha.registry.v1alpha1.RepositoryService.ListRepositories:output_type -> buf.alpha.registry.v1alpha1.ListRepositoriesResponse
	14, // 51: buf.alpha.registry.v1alpha1.RepositoryService.ListUserRepositories:output_type -> buf.alpha.registry.v1alpha1.ListUserRepositoriesResponse
	16, // 52: buf.alpha.registry.v1alpha1.RepositoryService.ListRepositoriesUserCanAccess:output_type -> buf.alpha.registry.v1alpha1.ListRepositoriesUserCanAccessResponse
	18, // 53: buf.alpha.registry.v1alpha1.RepositoryService.ListOrganizationRepositories:output_type -> buf.alpha.registry.v1alpha1.ListOrganizationRepositoriesResponse
	20, // 54: buf.alpha.registry.v1alpha1.RepositoryService.CreateRepositoryByFullName:output_type -> buf.alpha.registry.v1alpha1.CreateRepositoryByFullNameResponse
	22, // 55: buf.alpha.registry.v1alpha1.RepositoryService.DeleteRepository:output_type -> buf.alpha.registry.v1alpha1.DeleteRepositoryResponse
	24, // 56: buf.alpha.registry.v1alpha1.RepositoryService.DeleteRepositoryByFullName:output_type -> buf.alpha.registry.v1alpha1.DeleteRepositoryByFullNameResponse
	26, // 57: buf.alpha.registry.v1alpha1.RepositoryService.DeprecateRepositoryByName:output_type -> buf.alpha.registry.v1alpha1.DeprecateRepositoryByNameResponse
	28, // 58: buf.alpha.registry.v1alpha1.RepositoryService.UndeprecateRepositoryByName:output_type -> buf.alpha.registry.v1alpha1.UndeprecateRepositoryByNameResponse
	6,  // 59: buf.alpha.registry.v1alpha1.RepositoryService.GetRepositoriesByFullName:output_type -> buf.alpha.registry.v1alpha1.GetRepositoriesByFullNameResponse
	30, // 60: buf.alpha.registry.v1alpha1.RepositoryService.SetRepositoryContributor:output_type -> buf.alpha.registry.v1alpha1.SetRepositoryContributorResponse
	32, // 61: buf.alpha.registry.v1alpha1.RepositoryService.ListRepositoryContributors:output_type -> buf.alpha.registry.v1alpha1.ListRepositoryContributorsResponse
	34, // 62: buf.alpha.registry.v1alpha1.RepositoryService.GetRepositorySettings:output_type -> buf.alpha.registry.v1alpha1.GetRepositorySettingsResponse
	36, // 63: buf.alpha.registry.v1alpha1.RepositoryService.UpdateRepositorySettingsByName:output_type -> buf.alpha.registry.v1alpha1.UpdateRepositorySettingsByNameResponse
	38, // 64: buf.alpha.registry.v1alpha1.RepositoryService.GetRepositoriesMetadata:output_type -> buf.alpha.registry.v1alpha1.GetRepositoriesMetadataResponse
	40, // 65: buf.alpha.registry.v1alpha1.RepositoryService.GetRepositoryDependencyDOTString:output_type -> buf.alpha.registry.v1alpha1.GetRepositoryDependencyDOTStringResponse
	42, // 66: buf.alpha.registry.v1alpha1.RepositoryService.AddRepositoryGroup:output_type -> buf.alpha.registry.v1alpha1.AddRepositoryGroupResponse
	44, // 67: buf.alpha.registry.v1alpha1.RepositoryService.UpdateRepositoryGroup:output_type -> buf.alpha.registry.v1alpha1.UpdateRepositoryGroupResponse
	46, // 68: buf.alpha.registry.v1alpha1.RepositoryService.RemoveRepositoryGroup:output_type -> buf.alpha.registry.v1alpha1.RemoveRepositoryGroupResponse
	48, // [48:69] is the sub-list for method output_type
	27, // [27:48] is the sub-list for method input_type
	27, // [27:27] is the sub-list for extension type_name
	27, // [27:27] is the sub-list for extension extendee
	0,  // [0:27] is the sub-list for field type_name
}

func init() { file_buf_alpha_registry_v1alpha1_repository_proto_init() }
func file_buf_alpha_registry_v1alpha1_repository_proto_init() {
	if File_buf_alpha_registry_v1alpha1_repository_proto != nil {
		return
	}
	file_buf_alpha_registry_v1alpha1_role_proto_init()
	file_buf_alpha_registry_v1alpha1_user_proto_init()
	file_buf_alpha_registry_v1alpha1_verification_status_proto_init()
	file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[0].OneofWrappers = []any{
		(*repository_UserId)(nil),
		(*repository_OrganizationId)(nil),
	}
	file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[34].OneofWrappers = []any{}
	file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes[42].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_alpha_registry_v1alpha1_repository_proto_rawDesc), len(file_buf_alpha_registry_v1alpha1_repository_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   46,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_alpha_registry_v1alpha1_repository_proto_goTypes,
		DependencyIndexes: file_buf_alpha_registry_v1alpha1_repository_proto_depIdxs,
		EnumInfos:         file_buf_alpha_registry_v1alpha1_repository_proto_enumTypes,
		MessageInfos:      file_buf_alpha_registry_v1alpha1_repository_proto_msgTypes,
	}.Build()
	File_buf_alpha_registry_v1alpha1_repository_proto = out.File
	file_buf_alpha_registry_v1alpha1_repository_proto_goTypes = nil
	file_buf_alpha_registry_v1alpha1_repository_proto_depIdxs = nil
}
