/******************************************************************************
  This source file is part of the Avogadro project.
  This source code is released under the 3-Clause BSD License, (see "LICENSE").
******************************************************************************/

#include <QtCore/QtPlugin>

#include "/build/avogadrolibs/src/avogadrolibs/avogadro/qtplugins/coloropacitymap/coloropacitymap.h"


namespace Avogadro::QtPlugins {

class ColorOpacityMapFactory : public QObject, public QtGui::ExtensionPluginFactory
{
  Q_OBJECT
  Q_PLUGIN_METADATA(IID "org.openchemistry.avogadro.ExtensionPluginFactory")
  Q_INTERFACES(Avogadro::QtGui::ExtensionPluginFactory)

public:
  explicit ColorOpacityMapFactory(QObject* parent_ = nullptr) : QObject(parent_) {}

  QtGui::ExtensionPlugin* createInstance(QObject* parent_ = nullptr) override
  {
    auto* object = new ColorOpacityMap(parent_);
    object->setObjectName("ColorOpacityMap");
    return object;
  }

  QString identifier() const override { return "ColorOpacityMap"; }

  QString description() const override { return "Edit the color opacity map."; }

};

} // namespace Avogadro::QtPlugins

#include "ColorOpacityMapPlugin.moc"
